/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.Trace;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.rowio.AbstractRowInputText;
import com.streamscape.ds.io.rowio.RowInputInterface;
import com.streamscape.ds.io.rowio.RowOutputInterface;
import com.streamscape.ds.io.scriptio.ScriptWriterText;
import com.streamscape.ds.lib.HsqlByteArrayOutputStream;
import com.streamscape.ds.persist.AbstractTextTableIOManager;
import com.streamscape.ds.persist.CachedObject;
import com.streamscape.ds.persist.FileTableCache;
import com.streamscape.ds.persist.FileTableSettings;
import com.streamscape.ds.persist.RandomAccessInputStream;
import com.streamscape.ds.persist.row.RowAVLDiskData;
import com.streamscape.ds.schema.table.FileTable;
import com.streamscape.lib.file.DelimitedFileLinesReader;
import com.streamscape.lib.file.FileLinesReader;
import com.streamscape.lib.file.RandomAccessInterface;
import de.jarnbjo.jsnappy.SnappyCompressor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class PlainFileTableIOManager
extends AbstractTextTableIOManager<Long> {
    private FileLinesReader reader;

    PlainFileTableIOManager(RandomAccessInterface dataFile, FileTableSettings textFileSettings, RowInputInterface rowIn, RowOutputInterface rowOut, boolean isReadOnly, String fileName, int blockSize, FileTable fileTable, boolean isAppendable) {
        super(dataFile, textFileSettings, rowIn, rowOut, isReadOnly, fileName, blockSize);
        if (fileTable.getFileDescriptorName() != null) {
            this.reader = fileTable.getFileDescriptorProcessorFactory().createFileLinesReader(new RandomAccessInputStream(dataFile), textFileSettings.stringEncoding, !isAppendable);
        } else {
            this.reader = new DelimitedFileLinesReader(new RandomAccessInputStream(dataFile), textFileSettings.stringEncoding, !isAppendable);
            if (textFileSettings.isQuoted) {
                ((DelimitedFileLinesReader)this.reader).setQuoteSymbol('\"');
                ((DelimitedFileLinesReader)this.reader).setQuoteEscapeSymbol('\"');
                ((DelimitedFileLinesReader)this.reader).setFieldsDelimiter(textFileSettings.fs);
            }
        }
    }

    @Override
    public AbstractRowInputText readNextRow(long pos) {
        this.dataFileLock.lock();
        try {
            String rowString2;
            this.reader.resetMark(pos);
            while (this.reader.hasNext(true)) {
                this.rowIn.skippedLines(this.reader.getLastSkippedLines());
                this.lastPos = this.reader.getCurrentStartPositionInBytes();
                rowString2 = this.reader.currentWithDelimiter();
                if (this.rowIn.accepts(rowString2)) {
                    ++this.rowNum;
                    if (!this.isForStream) {
                        this.rowNumToPosMap.put(this.rowNum, this.lastPos);
                    }
                    this.rowIn.setSource(rowString2, this.rowNum, this.reader.getCurrentWithDelimiterLengthBytes());
                    this.rowIn.increaseLine();
                    AbstractRowInputText abstractRowInputText = this.rowIn;
                    return abstractRowInputText;
                }
                this.rowIn.skippedLine();
            }
            this.rowIn.skippedLines(this.reader.getLastSkippedLines());
            try {
                this.lastPos = this.dataFile.length();
            }
            catch (IOException rowString2) {
                // empty catch block
            }
            rowString2 = null;
            return rowString2;
        }
        catch (Exception exception) {
            throw Error.error(484, exception);
        }
        finally {
            this.dataFileLock.unlock();
        }
    }

    @Override
    public int readHeaderLine() throws IOException {
        return this.readHeaderLines(1);
    }

    @Override
    public int readHeaderLines(int lines) throws IOException {
        this.dataFileLock.lock();
        try {
            this.header = this.reader.readHeaderLines(lines);
            int n = this.header.length();
            return n;
        }
        finally {
            this.dataFileLock.unlock();
        }
    }

    @Override
    public void convert(String targetFileName, FileTableCache cache) {
        this.dataFileLock.lock();
        try {
            AbstractRowInputText rowIn;
            Trace.logInfo(this, "Starting Compression...");
            this.reset();
            long nextpos = 0L;
            FileOutputStream fout = new FileOutputStream(new File(targetFileName));
            fout.write(FileTableCache.COMPRESSED_FILE_MAGIC);
            int ignoreFirstLines = cache.getIgnoreFirstLines();
            if (ignoreFirstLines <= 0 && cache.isIgnoreFirstLine()) {
                ignoreFirstLines = 1;
            }
            if (ignoreFirstLines > 0) {
                nextpos += (long)this.readHeaderLines(ignoreFirstLines);
                this.writeShort(fout, this.header.getBytes().length);
                fout.write(this.header.getBytes());
            } else if (cache.isIgnoreFirstLine()) {
                nextpos += (long)this.readHeaderLine();
                this.writeShort(fout, this.header.getBytes().length);
                fout.write(this.header.getBytes());
            }
            byte[] buffer = new byte[this.blockSize];
            int counter = 0;
            while ((rowIn = this.readNextRow(nextpos)) != null) {
                if (counter + rowIn.getSize() + 2 < this.blockSize) {
                    rowBuffer = rowIn.getText().getBytes();
                    buffer[counter++] = (byte)(rowBuffer.length >>> 8 & 0xFF);
                    buffer[counter++] = (byte)(rowBuffer.length >>> 0 & 0xFF);
                    System.arraycopy(rowBuffer, 0, buffer, counter, rowBuffer.length);
                    counter += rowBuffer.length;
                } else {
                    buffer = SnappyCompressor.compress((byte[])buffer, (int)0, (int)counter).toByteArray();
                    this.writeShort(fout, buffer.length);
                    this.writeShort(fout, buffer.length);
                    fout.write(buffer, 0, buffer.length);
                    fout.flush();
                    counter = 0;
                    buffer = new byte[this.blockSize];
                    rowBuffer = rowIn.getText().getBytes();
                    buffer[counter++] = (byte)(rowBuffer.length >>> 8 & 0xFF);
                    buffer[counter++] = (byte)(rowBuffer.length >>> 0 & 0xFF);
                    System.arraycopy(rowBuffer, 0, buffer, counter, rowBuffer.length);
                    counter += rowBuffer.length;
                }
                long pos = (Long)this.rowNumToPosMap.get(rowIn.getPos());
                nextpos = pos + (long)rowIn.getSize();
            }
            if (counter > 0) {
                buffer = SnappyCompressor.compress((byte[])buffer, (int)0, (int)counter).toByteArray();
                this.writeShort(fout, buffer.length);
                this.writeShort(fout, buffer.length);
                fout.write(buffer, 0, buffer.length);
                fout.flush();
                counter = 0;
            }
            fout.close();
            Trace.logInfo(this, "Compression Completed.");
        }
        catch (Throwable t) {
            t.printStackTrace();
            int linenumber = this.getLineNumber();
            throw Error.error(t, 483, 0, new Object[]{new Integer(linenumber), t.toString()});
        }
        finally {
            this.dataFileLock.unlock();
        }
    }

    @Override
    public long getFileLength() throws IOException {
        this.dataFileLock.lock();
        try {
            long l = this.dataFile.length();
            return l;
        }
        finally {
            this.dataFileLock.unlock();
        }
    }

    @Override
    public void truncate() {
        this.dataFileLock.lock();
        try {
            this.dataFile.synch();
            this.dataFile.setLength(0L);
            this.resetOnTruncate();
        }
        finally {
            this.dataFileLock.unlock();
        }
    }

    @Override
    public void reset() {
        this.dataFileLock.lock();
        try {
            this.rowNum = -1;
            try {
                this.dataFile.seek(0L);
                this.reader.resetMark(0L);
            }
            catch (IOException error) {
                Trace.logException(this, error, false);
            }
        }
        finally {
            this.dataFileLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readRow(CachedObject object) throws IOException {
        this.dataFileLock.lock();
        try {
            this.buffer.reset(object.getStorageSize());
            long pos = (Long)this.rowNumToPosMap.get(object.getPos());
            this.dataFile.seek(pos);
            this.dataFile.read(this.buffer.getBuffer(), 0, object.getStorageSize());
            this.buffer.setSize(object.getStorageSize());
            this.reader.resetMark(0L);
            String rowString = this.buffer.toString(this.textFileSettings.stringEncoding);
            this.rowIn.setSource(rowString, object.getPos(), this.buffer.size());
        }
        finally {
            this.dataFileLock.unlock();
        }
    }

    @Override
    public void writeRow(CachedObject object) {
        this.dataFileLock.lock();
        try {
            this.rowOut.reset();
            object.write(this.rowOut);
            long pos = (Long)this.rowNumToPosMap.get(object.getPos());
            this.dataFile.seek(pos);
            this.dataFile.write(this.rowOut.getOutputStream().getBuffer(), 0, this.rowOut.getOutputStream().size());
            this.reader.resetMark(0L);
        }
        catch (IOException e) {
            throw Error.error(466, e);
        }
        finally {
            this.dataFileLock.unlock();
        }
    }

    @Override
    public void clearRowImage(CachedObject row) {
        this.dataFileLock.lock();
        try {
            byte[] rowLineSeparatorBytes;
            byte[] lineSeparatorBytes = ScriptWriterText.BYTES_LINE_SEP;
            if (row instanceof RowAVLDiskData && (rowLineSeparatorBytes = ((RowAVLDiskData)row).getLineSeparatorBytes()) != null) {
                lineSeparatorBytes = rowLineSeparatorBytes;
            }
            int length = row.getStorageSize() - lineSeparatorBytes.length;
            this.rowOut.reset();
            HsqlByteArrayOutputStream out = this.rowOut.getOutputStream();
            out.fill(32, length);
            out.write(lineSeparatorBytes);
            long pos = (Long)this.rowNumToPosMap.get(row.getPos());
            if (pos > 0L && pos == this.dataFile.length()) {
                this.dataFile.seek(pos - 1L);
                if (this.dataFile.read() != 10) {
                    this.dataFile.write(ScriptWriterText.BYTES_LINE_SEP, 0, ScriptWriterText.BYTES_LINE_SEP.length);
                    this.rowNumToPosMap.put(row.getPos(), pos += (long)ScriptWriterText.BYTES_LINE_SEP.length);
                }
            }
            this.dataFile.seek(pos);
            this.dataFile.write(out.getBuffer(), 0, out.size());
            this.reader.resetMark(0L);
        }
        catch (IOException e) {
            throw Error.runtimeError(201, e.getMessage());
        }
        finally {
            this.dataFileLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long allocateRow(CachedObject object) {
        this.dataFileLock.lock();
        try {
            int rowSize = object.getStorageSize();
            long newFreePosition = this.fileFreePos + (long)rowSize;
            ++this.rowNum;
            this.rowNumToPosMap.put(this.rowNum, this.fileFreePos);
            object.setPos(this.rowNum);
            this.fileFreePos = newFreePosition;
            long l = newFreePosition;
            return l;
        }
        finally {
            this.dataFileLock.unlock();
        }
    }
}

