/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.HsqlDeque;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.lib.LongKeyHashMap;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.persist.DataFileCacheSession;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.PersistentStoreCollection;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.TableBase;
import com.streamscape.ds.session.Session;

public class PersistentStoreCollectionSession
implements PersistentStoreCollection {
    private final Session session;
    private final LongKeyHashMap rowStoreMapSession = new LongKeyHashMap();
    private LongKeyHashMap rowStoreMapTransaction = new LongKeyHashMap();
    private LongKeyHashMap rowStoreMapStatement = new LongKeyHashMap();
    private HsqlDeque rowStoreListStatement;
    DataFileCacheSession resultCache;

    public PersistentStoreCollectionSession(Session session) {
        this.session = session;
    }

    @Override
    public void setStore(Object key, PersistentStore store) {
        TableBase table = (TableBase)key;
        switch (table.persistenceScope) {
            case 21: {
                if (store == null) {
                    this.rowStoreMapStatement.remove(table.getPersistenceId());
                    break;
                }
                this.rowStoreMapStatement.put(table.getPersistenceId(), store);
                break;
            }
            case 22: 
            case 24: {
                if (store == null) {
                    this.rowStoreMapTransaction.remove(table.getPersistenceId());
                    break;
                }
                this.rowStoreMapTransaction.put(table.getPersistenceId(), store);
                break;
            }
            case 23: {
                if (store == null) {
                    this.rowStoreMapSession.remove(table.getPersistenceId());
                    break;
                }
                this.rowStoreMapSession.put(table.getPersistenceId(), store);
                break;
            }
            default: {
                throw Error.runtimeError(201, "PersistentStoreCollectionSession");
            }
        }
    }

    public PersistentStore getViewStore(long persistenceId) {
        return (PersistentStore)this.rowStoreMapStatement.get(persistenceId);
    }

    @Override
    public PersistentStore getStore(Object key) {
        try {
            TableBase table = (TableBase)key;
            switch (table.persistenceScope) {
                case 21: {
                    PersistentStore store = (PersistentStore)this.rowStoreMapStatement.get(table.getPersistenceId());
                    if (store == null) {
                        store = this.session.dataspaceStore.dataspaceLogger.newStore(this.session, this, table);
                    }
                    return store;
                }
                case 22: 
                case 24: {
                    PersistentStore store = (PersistentStore)this.rowStoreMapTransaction.get(table.getPersistenceId());
                    if (store == null) {
                        store = this.session.dataspaceStore.dataspaceLogger.newStore(this.session, this, table);
                    }
                    if (table.getTableType() == 1) {
                        this.session.dataspaceStore.dsInfo.setStore(this.session, (Table)table, store);
                    }
                    return store;
                }
                case 23: {
                    PersistentStore store = (PersistentStore)this.rowStoreMapSession.get(table.getPersistenceId());
                    if (store == null) {
                        store = this.session.dataspaceStore.dataspaceLogger.newStore(this.session, this, table);
                    }
                    return store;
                }
            }
        }
        catch (DataspaceException dataspaceException) {
            // empty catch block
        }
        throw Error.runtimeError(201, "PersistentStoreCollectionSession");
    }

    public void clearAllTables() {
        this.clearSessionTables();
        this.clearTransactionTables();
        this.clearStatementTables();
        this.closeResultCache();
    }

    public void clearResultTables(long actionTimestamp) {
        if (this.rowStoreMapSession.isEmpty()) {
            return;
        }
        Iterator it = this.rowStoreMapSession.values().iterator();
        while (it.hasNext()) {
            PersistentStore store = (PersistentStore)it.next();
            if (store.getTimestamp() != actionTimestamp) continue;
            store.release();
            it.remove();
        }
    }

    public void clearSessionTables() {
        if (this.rowStoreMapSession.isEmpty()) {
            return;
        }
        Iterator it = this.rowStoreMapSession.values().iterator();
        while (it.hasNext()) {
            PersistentStore store = (PersistentStore)it.next();
            store.release();
        }
        this.rowStoreMapSession.clear();
    }

    public void clearTransactionTables() {
        if (this.rowStoreMapTransaction.isEmpty()) {
            return;
        }
        Iterator it = this.rowStoreMapTransaction.values().iterator();
        while (it.hasNext()) {
            PersistentStore store = (PersistentStore)it.next();
            store.release();
        }
        this.rowStoreMapTransaction.clear();
    }

    public void clearStatementTables() {
        if (this.rowStoreMapStatement.isEmpty()) {
            return;
        }
        Iterator it = this.rowStoreMapStatement.values().iterator();
        while (it.hasNext()) {
            PersistentStore store = (PersistentStore)it.next();
            store.release();
        }
        this.rowStoreMapStatement.clear();
    }

    public void registerIndex(Table table) {
        PersistentStore store = this.findStore(table);
        if (store == null) {
            return;
        }
        store.resetAccessorKeys(table.getIndexList());
    }

    public PersistentStore findStore(Table table) {
        PersistentStore store = null;
        switch (table.persistenceScope) {
            case 21: {
                store = (PersistentStore)this.rowStoreMapStatement.get(table.getPersistenceId());
                break;
            }
            case 22: 
            case 24: {
                store = (PersistentStore)this.rowStoreMapTransaction.get(table.getPersistenceId());
                break;
            }
            case 23: {
                store = (PersistentStore)this.rowStoreMapSession.get(table.getPersistenceId());
            }
        }
        return store;
    }

    public void moveData(Table oldTable, Table newTable, int colIndex, int adjust) {
        PersistentStore oldStore = this.findStore(oldTable);
        if (oldStore == null) {
            return;
        }
        PersistentStore newStore = this.getStore(newTable);
        try {
            newStore.moveData(this.session, oldStore, colIndex, adjust);
        }
        catch (DataspaceException e) {
            newStore.release();
            this.setStore(newTable, null);
            throw e;
        }
        this.setStore(oldTable, null);
    }

    public void push() {
        if (this.rowStoreListStatement == null) {
            this.rowStoreListStatement = new HsqlDeque();
        }
        if (this.rowStoreMapStatement.isEmpty()) {
            this.rowStoreListStatement.add(ValuePool.emptyObjectArray);
            return;
        }
        Object[] array = this.rowStoreMapStatement.toArray();
        this.rowStoreListStatement.add(array);
        this.rowStoreMapStatement.clear();
    }

    public void pop() {
        Object[] array = (Object[])this.rowStoreListStatement.removeLast();
        this.clearStatementTables();
        for (int i = 0; i < array.length; ++i) {
            PersistentStore store = (PersistentStore)array[i];
            this.rowStoreMapStatement.put(store.getTable().getPersistenceId(), store);
        }
    }

    public DataFileCacheSession getResultCache() {
        if (this.resultCache == null) {
            String path = this.session.dataspaceStore.dataspaceLogger.getTempDirectoryPath();
            if (path == null) {
                return null;
            }
            try {
                this.resultCache = new DataFileCacheSession(this.session.dataspaceStore);
                this.resultCache.init(path + "/session_" + Long.toString(this.session.getId()));
                this.resultCache.open(false);
            }
            catch (Throwable t) {
                return null;
            }
        }
        return this.resultCache;
    }

    public void closeResultCache() {
        if (this.resultCache != null) {
            try {
                this.resultCache.close(false);
                this.resultCache.deleteFile();
            }
            catch (DataspaceException dataspaceException) {
                // empty catch block
            }
            this.resultCache = null;
        }
    }
}

