/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.ds.lib.LongKeyHashMap;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.PersistentStoreCollection;
import com.streamscape.ds.schema.table.TableBase;

public class PersistentStoreCollectionDatabase
implements PersistentStoreCollection {
    private long persistentStoreIdSequence;
    private final LongKeyHashMap rowStoreMap = new LongKeyHashMap();

    @Override
    public void setStore(Object key, PersistentStore store) {
        long persistenceId = ((TableBase)key).getPersistenceId();
        if (store == null) {
            this.rowStoreMap.remove(persistenceId);
        } else {
            this.rowStoreMap.put(persistenceId, store);
        }
    }

    @Override
    public PersistentStore getStore(Object key) {
        long persistenceId = ((TableBase)key).getPersistenceId();
        PersistentStore store = (PersistentStore)this.rowStoreMap.get(persistenceId);
        return store;
    }

    public void releaseStore(TableBase table) {
        PersistentStore store = (PersistentStore)this.rowStoreMap.get(table.getPersistenceId());
        if (store != null) {
            store.release();
            this.rowStoreMap.remove(table.getPersistenceId());
        }
    }

    public long getNextId() {
        return this.persistentStoreIdSequence++;
    }
}

