/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.Trace;
import com.streamscape.ds.CheckpointManager;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.DataspaceURL;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.DataspaceStoreState;
import com.streamscape.ds.core.MemoryModel;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.scriptio.ScriptWriterBase;
import com.streamscape.ds.io.scriptio.ScriptWriterText;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.lib.FileAccess;
import com.streamscape.ds.lib.FileUtil;
import com.streamscape.ds.lib.FrameworkLogger;
import com.streamscape.ds.lib.HashMap;
import com.streamscape.ds.lib.InputStreamInterface;
import com.streamscape.ds.lib.InputStreamWrapper;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.lib.SimpleLog;
import com.streamscape.ds.lib.StringUtil;
import com.streamscape.ds.lib.tar.DbBackup;
import com.streamscape.ds.lib.tar.TarMalformatException;
import com.streamscape.ds.parser.expression.DataspaceQueryMemoryMonitor;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.persist.Crypto;
import com.streamscape.ds.persist.DataFileCache;
import com.streamscape.ds.persist.DataspaceStoreProperties;
import com.streamscape.ds.persist.ExternalFileTableCache;
import com.streamscape.ds.persist.FileTableCache;
import com.streamscape.ds.persist.Log;
import com.streamscape.ds.persist.LogFileIndex;
import com.streamscape.ds.persist.LogRecordType;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.PersistentStoreCollection;
import com.streamscape.ds.persist.RAShadowFile;
import com.streamscape.ds.persist.RowStoreAVLDisk;
import com.streamscape.ds.persist.RowStoreAVLDiskData;
import com.streamscape.ds.persist.RowStoreAVLHybrid;
import com.streamscape.ds.persist.RowStoreAVLHybridExtended;
import com.streamscape.ds.persist.RowStoreAVLMemory;
import com.streamscape.ds.persist.RowStoreDataChange;
import com.streamscape.ds.persist.StoreFilesState;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.persist.index.IndexAVL;
import com.streamscape.ds.persist.index.IndexAVLMemory;
import com.streamscape.ds.persist.jfq.IndexJFQ;
import com.streamscape.ds.persist.jfq.RowStoreJFQ;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.persist.snapshot.IndexSnapshot;
import com.streamscape.ds.persist.snapshot.RowStoreSnapshot;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.fspace.table.FileTableCollection;
import com.streamscape.ds.schema.sequence.NumberSequence;
import com.streamscape.ds.schema.server.FileServerObject;
import com.streamscape.ds.schema.table.FileTable;
import com.streamscape.ds.schema.table.JournalFileQueueTable;
import com.streamscape.ds.schema.table.SnapshotDataspaceTable;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.TableBase;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.stable.index.SIndexType;
import com.streamscape.ds.transaction.TransactionManagerMV2PL;
import com.streamscape.ds.transaction.TransactionManagerMVCC;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.RowType;
import com.streamscape.ds.types.Type;
import com.streamscape.lib.timer.FabricTimer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Logger {
    public SimpleLog appLog;
    public SimpleLog sqlLog;
    FrameworkLogger fwLogger;
    FrameworkLogger sqlLogger;
    private DataspaceStore store;
    private boolean logsStatements;
    private boolean loggingEnabled;
    boolean propIsFileDatabase;
    boolean propFilesReadOnly;
    boolean propStoreReadOnly;
    boolean propIncrementBackup;
    boolean propNioDataFile;
    long propNioMaxSize = 0x10000000L;
    int propMaxFreeBlocks = 512;
    int propCacheMaxRows;
    int propCacheMaxSize;
    int propCacheFileScale;
    int propCacheDefragLimit;
    public boolean propTextAllowFullPath;
    int propWriteDelay;
    public int propLogSize;
    public int propLogSizeCritical;
    boolean propLogData = true;
    int propEventLogLevel;
    int propSqlLogLevel;
    int propGC;
    int propTxMode = 0;
    boolean propRefIntegrity = true;
    int propLobBlockSize = 32768;
    boolean propLobInMem = false;
    boolean propExtendedSqlAudit = false;
    String propScriptFormat = "TEXT";
    String propFlobLocationPath;
    public String propCheckpointInterval = null;
    public String propCheckpointIntervalRepeat = null;
    public String propCheckpointIntervalCritical = null;
    public String propCheckpointLockTimeout1 = null;
    public String propCheckpointLockTimeout2 = null;
    public boolean propCheckpointCheckConsistency = false;
    public String indexOperationMaxTime = null;
    Log log;
    private Crypto crypto;
    boolean cryptLobs;
    public FileAccess fileAccess;
    public boolean isStoredFileAccess;
    String tempDirectoryPath;
    private HashMap textCacheList = new HashMap();
    public boolean isNewDatabase;
    public boolean isSingleFile;
    private FabricTimer checkpointTimer = null;
    AtomicInteger backupState = new AtomicInteger();
    static final int stateNormal = 0;
    static final int stateBackup = 1;
    static final int stateCheckpoint = 2;
    public static final String oldFileExtension = ".v";
    public static final String newFileExtension = ".new";
    public static final String appLogFileExtension = ".app.log";
    public static final String sqlLogFileExtension = ".sql.log";
    public static final String recoveryLogFileExtension = ".rcv";
    public static final String logFileExtension = ".log";
    public static final String dataFileExtension = ".dat";
    public static final String backupFileExtension = ".backup";
    public static final String lobsFileExtension = ".lobs";
    public static final String indexFileExtension = ".idx";
    public static final String tmpFileExtension = ".tmp";
    public static final String errorSqlFileExtension = ".err";
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private Lock readLock = this.lock.readLock();
    private Lock writeLock = this.lock.writeLock();
    private SimpleDateFormat backupFileFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
    private Character runtimeFileDelim = new Character(System.getProperty("file.separator").charAt(0));
    DbBackup backup;

    public Logger(DataspaceStore database) {
        this.store = database;
    }

    public void openPersistence() {
        String fileaccess_class_name = this.store.getURLProperties().getProperty("fileaccess_class_name");
        if (fileaccess_class_name != null) {
            String storagekey = this.store.getURLProperties().getProperty("storage_key");
            try {
                Class<?> zclass = Class.forName(fileaccess_class_name);
                Constructor<?> constructor = zclass.getConstructor(Object.class);
                this.fileAccess = (FileAccess)constructor.newInstance(storagekey);
                this.isStoredFileAccess = true;
            }
            catch (Exception e) {
                Trace.logError(this, e.getClass().getSimpleName() + ": " + e.getMessage());
            }
        } else {
            this.fileAccess = FileUtil.getFileAccess(this.store.isFilesInJar());
        }
        if (this.fileAccess.isStreamElement(this.store.getPath() + errorSqlFileExtension)) {
            this.fileAccess.removeElement(this.store.getPath() + errorSqlFileExtension);
        }
        this.propIsFileDatabase = DataspaceURL.isFileBasedDatabaseType(this.store.getModel());
        this.store.dataspaceStoreProperties = new DataspaceStoreProperties(this.store);
        if (this.propIsFileDatabase) {
            boolean exists = this.fileAccess.isStreamElement(this.store.getPath() + logFileExtension);
            if (!exists) {
                exists = this.fileAccess.isStreamElement(this.store.getPath() + ".log.new");
                if (exists) {
                    this.store.setDBModified(StoreFilesState.MODIFIED_NEW);
                }
            } else {
                this.store.setDBModified(StoreFilesState.MODIFIED);
            }
            this.isNewDatabase = !exists;
        } else {
            this.isNewDatabase = true;
        }
        if (this.isNewDatabase) {
            this.store.dataspaceStoreProperties.setURLProperties(this.store.getURLProperties());
            this.store.setDBModified(StoreFilesState.NOT_MODIFIED_NEW);
        } else {
            if (this.store.getURLProperties().isPropertyTrue("dtspace.files_readonly")) {
                this.store.dataspaceStoreProperties.setProperty("dtspace.files_readonly", true);
            }
            if (this.store.getURLProperties().isPropertyTrue("dtspace.readonly")) {
                this.store.dataspaceStoreProperties.setProperty("dtspace.readonly", true);
            }
        }
        this.setVariables();
        String appLogPath = null;
        String sqlLogPath = null;
        if (this.propIsFileDatabase && !this.store.isFilesReadOnly()) {
            appLogPath = this.store.getPath() + appLogFileExtension;
            sqlLogPath = this.store.getPath() + sqlLogFileExtension;
        }
        this.appLog = new SimpleLog(appLogPath, this.propEventLogLevel);
        this.sqlLog = new SimpleLog(sqlLogPath, this.propSqlLogLevel);
        this.store.setReferentialIntegrity(this.propRefIntegrity);
        if (!this.isFileDatabase()) {
            return;
        }
        this.logsStatements = false;
        this.log = new Log(this.store);
        this.log.open();
        this.logsStatements = true;
        this.loggingEnabled = this.propLogData && !this.store.isFilesReadOnly();
    }

    private void setVariables() {
        String timezoneProperty;
        String tableType;
        DataspaceStoreProperties props = this.store.getDataspaceStoreProperties();
        String cryptKey = this.store.getURLProperties().getProperty("crypt_key");
        if (cryptKey != null) {
            String cryptType = this.store.getURLProperties().getProperty("crypt_type");
            String cryptProvider = this.store.getURLProperties().getProperty("crypt_provider");
            this.crypto = new Crypto(cryptKey, cryptType, cryptProvider);
        }
        if (props.isPropertyTrue("dtspace.readonly")) {
            this.store.setReadOnly();
        }
        if (props.isPropertyTrue("dtspace.files_readonly")) {
            this.store.setFilesReadOnly();
        }
        if (!this.store.isFilesReadOnly()) {
            if (this.store.getModel() == "mem://" || this.isStoredFileAccess) {
                this.tempDirectoryPath = props.getStringProperty("dtspace.temp_directory");
            } else {
                String fullPath = this.store.getPath();
                fullPath = fullPath.substring(0, fullPath.indexOf("dtspace"));
                this.tempDirectoryPath = fullPath + "tmp";
            }
            if (this.tempDirectoryPath != null) {
                this.tempDirectoryPath = FileUtil.makeDirectories(this.tempDirectoryPath);
            }
        }
        this.propScriptFormat = props.getStringProperty("dtspace.script_format");
        this.propMaxFreeBlocks = this.store.dataspaceStoreProperties.getIntegerProperty("dtspace.cache_free_count_scale");
        this.propMaxFreeBlocks = ArrayUtil.getTwoPowerFloor(this.propMaxFreeBlocks);
        if (this.tempDirectoryPath != null) {
            int rows = props.getIntegerProperty("dtspace.result_max_memory_rows");
            this.store.setResultMaxMemoryRows(rows);
        }
        if ("CACHED".equalsIgnoreCase(tableType = props.getStringProperty("dtspace.default_memory_model"))) {
            this.store.schemaManager.setDefaultMemoryModel(MemoryModel.PERSISTENT);
        } else if ("PERSISTENT".equalsIgnoreCase(tableType)) {
            this.store.schemaManager.setDefaultMemoryModel(MemoryModel.PERSISTENT);
        } else if ("LOGGED".equalsIgnoreCase(tableType)) {
            this.store.schemaManager.setDefaultMemoryModel(MemoryModel.LOGGED);
        } else if ("MEMORY".equalsIgnoreCase(tableType)) {
            this.store.schemaManager.setDefaultMemoryModel(MemoryModel.MEMORY);
        }
        String txMode = props.getStringProperty("dtspace.tx_management");
        if ("MVCC".equalsIgnoreCase(txMode)) {
            this.propTxMode = 2;
        } else if ("MVLOCKS".equalsIgnoreCase(txMode)) {
            this.propTxMode = 1;
        } else if ("LOCKS".equalsIgnoreCase(txMode)) {
            this.propTxMode = 0;
        }
        switch (this.propTxMode) {
            case 0: {
                break;
            }
            case 1: {
                this.store.txManager = new TransactionManagerMV2PL(this.store);
                break;
            }
            case 2: {
                this.store.txManager = new TransactionManagerMVCC(this.store);
            }
        }
        String txLevel = props.getStringProperty("dtspace.tx_isolation_level");
        this.store.defaultIsolationLevel = "SERIALIZABLE".equalsIgnoreCase(txLevel) ? 8 : 2;
        boolean needToPersist = false;
        this.store.txConflictRollback = this.store.dataspaceStoreProperties.isPropertyTrue("dtspace.tx_conflict_rollback");
        this.store.txConflictSpinLockTimeout = this.store.dataspaceStoreProperties.getIntegerProperty("dtspace.tx_conflict_spin_lock_timeout", 0);
        this.store.sqlEnforceNames = props.isPropertyTrue("sql.enforce_names");
        this.store.sqlEnforceRefs = props.isPropertyTrue("sql.enforce_refs");
        this.store.sqlEnforceSize = props.isPropertyTrue("sql.enforce_size");
        if (!this.store.sqlEnforceSize) {
            this.store.sqlEnforceSize = props.isPropertyTrue("sql.enforce_strict_size");
        }
        this.store.sqlEnforceTypes = props.isPropertyTrue("sql.enforce_types");
        this.store.sqlEnforceTDCD = props.isPropertyTrue("sql.enforce_tdc_delete");
        this.store.sqlEnforceTDCU = props.isPropertyTrue("sql.enforce_tdc_update");
        this.store.sqlTranslateTTI = props.isPropertyTrue("jdbc.translate_tti_types");
        this.store.sqlConcatNulls = props.isPropertyTrue("sql.concat_nulls");
        this.store.sqlUniqueNulls = props.isPropertyTrue("sql.unique_nulls");
        this.store.sqlConvertTruncate = props.isPropertyTrue("sql.convert_trunc");
        if (this.store.dataspaceStoreProperties.isPropertyTrue("sql.pad_space", true)) {
            this.store.collation.setPadding(true);
        }
        if (!this.store.properties.containsKey("sql.pad_space")) {
            this.store.properties.put("sql.pad_space", (Object)true);
            this.store.collation.setPadding(true);
            needToPersist = true;
        }
        if (props.isPropertyTrue("sql.compare_in_locale")) {
            this.store.collation.setCollationAsLocale();
        }
        this.propEventLogLevel = props.getIntegerProperty("dtspace.applog");
        this.propFilesReadOnly = props.isPropertyTrue("dtspace.files_readonly");
        this.propStoreReadOnly = props.isPropertyTrue("dtspace.readonly");
        this.propIncrementBackup = props.isPropertyTrue("dtspace.incremental_backup");
        this.propNioDataFile = props.isPropertyTrue("dtspace.nio_data_file");
        this.propNioMaxSize = (long)(props.getIntegerProperty("dtspace.nio_max_size") * 1024) * 1024L;
        this.propCacheMaxRows = props.getIntegerProperty("dtspace.cache_rows");
        this.propCacheMaxSize = props.getIntegerProperty("dtspace.cache_size") * 1024;
        this.setLobFileScaleNoCheck(props.getIntegerProperty("dtspace.lob_file_scale"));
        this.setLobInMemoryNoCheck(Boolean.parseBoolean(props.getProperty("dtspace.lob_in_mem")));
        this.propExtendedSqlAudit = Boolean.parseBoolean(props.getProperty("dtspace.extended_sql_audit"));
        this.setCacheFileScaleNoCheck(props.getIntegerProperty("dtspace.cache_file_scale"));
        this.propFlobLocationPath = props.getStringProperty("dtspace.flob_location_path");
        if (!this.store.properties.containsKey("dtspace.flob_location_path")) {
            this.store.properties.put("dtspace.flob_location_path", this.propFlobLocationPath);
            needToPersist = true;
        }
        this.propCacheDefragLimit = props.getIntegerProperty("dtspace.defrag_limit");
        this.propTextAllowFullPath = props.isPropertyTrue("file.allow_full_path");
        this.propWriteDelay = props.getIntegerProperty("dtspace.write_delay_millis");
        if (!props.isPropertyTrue("dtspace.write_delay")) {
            this.propWriteDelay = 0;
        }
        this.propLogSize = props.getIntegerProperty("dtspace.log_size");
        this.propLogData = props.isPropertyTrue("dtspace.log_data");
        this.propGC = props.getIntegerProperty("runtime.gc_interval");
        this.propRefIntegrity = props.isPropertyTrue("sql.ref_integrity");
        this.propCheckpointInterval = props.getProperty("dtspace.checkpoint_interval");
        this.propCheckpointIntervalRepeat = props.getStringProperty("dtspace.checkpoint_interval_repeat");
        this.propCheckpointIntervalCritical = props.getStringProperty("dtspace.checkpoint_interval_critical");
        this.propCheckpointLockTimeout1 = props.getStringProperty("dtspace.checkpoint_lock_timeout1");
        this.propCheckpointLockTimeout2 = props.getStringProperty("dtspace.checkpoint_lock_timeout2");
        this.propCheckpointCheckConsistency = props.getBooleanProperty("dtspace.checkpoint_check_consistency");
        this.propLogSizeCritical = props.getIntegerProperty("dtspace.log_size_critical");
        if (!this.store.properties.containsKey("dtspace.checkpoint_interval_repeat")) {
            this.store.properties.put("dtspace.checkpoint_interval_repeat", this.propCheckpointIntervalRepeat);
            this.store.properties.put("dtspace.checkpoint_interval_critical", this.propCheckpointIntervalCritical);
            this.store.properties.put("dtspace.checkpoint_lock_timeout1", this.propCheckpointLockTimeout1);
            this.store.properties.put("dtspace.checkpoint_lock_timeout2", this.propCheckpointLockTimeout2);
            this.store.properties.put("dtspace.checkpoint_check_consistency", (Object)this.propCheckpointCheckConsistency);
            this.store.properties.put("dtspace.log_size_critical", (Object)this.propLogSizeCritical);
            needToPersist = true;
        }
        this.indexOperationMaxTime = props.getStringProperty("dtspace.index_operation_max_time");
        if (!this.store.properties.containsKey("dtspace.index_operation_max_time")) {
            this.store.properties.put("dtspace.index_operation_max_time", this.indexOperationMaxTime);
            needToPersist = true;
        }
        Trace.logInfo(this, "Index operation max time: " + this.indexOperationMaxTime);
        NameManager.ObjectName dataspaceName = this.store.schemaManager.findSchemaHsqlName(props.getStringProperty("dtspace.default_dataspace"));
        this.store.schemaManager.setDefaultSchemaHsqlName(dataspaceName);
        int memLimit = props.getIntegerProperty("dtspace.query_mem_limit");
        int memLimitChkRows = props.getIntegerProperty("dtspace.query_mem_limit_chk_rows_start");
        int memLimitChkRowsInterval = props.getIntegerProperty("dtspace.query_mem_limit_chk_rows_interval");
        this.store.queryMemoryMonitor = new DataspaceQueryMemoryMonitor(memLimit, memLimitChkRows, memLimitChkRowsInterval);
        if (!this.store.properties.containsKey("dtspace.query_mem_limit")) {
            this.store.properties.put("dtspace.query_mem_limit", (Object)memLimit);
            this.store.properties.put("dtspace.query_mem_limit_chk_rows_start", (Object)memLimitChkRows);
            this.store.properties.put("dtspace.query_mem_limit_chk_rows_interval", (Object)memLimitChkRowsInterval);
            needToPersist = true;
        }
        OtherType.typeSafe = props.isPropertyTrue("dtspace.typesafe");
        if (!this.store.properties.containsKey("dtspace.typesafe")) {
            this.store.properties.put("dtspace.typesafe", (Object)true);
            OtherType.typeSafe = true;
            needToPersist = true;
        }
        if (!this.store.properties.containsKey("file.ignore_first_lines")) {
            this.store.properties.put("file.ignore_first_lines", (Object)0);
            needToPersist = true;
        }
        if ((timezoneProperty = props.getStringProperty("dtspace.timezone")) == null || !this.store.properties.containsKey("dtspace.timezone")) {
            this.store.properties.put("dtspace.timezone", DataspaceStoreProperties.getDefaultTimezone());
            needToPersist = true;
            timezoneProperty = DataspaceStoreProperties.getDefaultTimezone();
        }
        if ("default".equalsIgnoreCase(timezoneProperty)) {
            timezoneProperty = DataspaceStoreProperties.getDefaultTimezone();
        }
        if (props.getStringProperty("file.ccsid") == null || !this.store.properties.containsKey("file.ccsid")) {
            this.store.properties.put("file.ccsid", DataspaceStoreProperties.getDefaultCCSID());
            needToPersist = true;
        }
        if (!this.store.properties.containsKey("file.encoding")) {
            this.store.properties.remove("file.encoding");
            needToPersist = true;
        }
        if (needToPersist) {
            this.store.persistStoreState();
        }
    }

    public boolean closePersistence() {
        if (this.checkpointTimer != null) {
            this.checkpointTimer.stop();
            this.checkpointTimer = null;
        }
        if (this.log == null) {
            this.closeAllTextCaches(false);
            return true;
        }
        this.log.synchLog();
        this.store.lobManager.synch();
        this.store.lobManager.deleteUnusedLobs();
        this.store.flobManager.synch();
        this.store.flobManager.deleteUnusedFlobs();
        if (this.store.checkpointManager != null) {
            this.store.checkpointManager.stop();
        }
        try {
            this.log.shutdown();
        }
        catch (Throwable e) {
            this.store.dataspaceLogger.logSevereEvent("error closing log", e);
            this.log = null;
            return false;
        }
        this.store.dataspaceLogger.logInfoEvent("Database closed");
        this.log = null;
        this.appLog.close();
        this.logsStatements = false;
        this.loggingEnabled = false;
        return true;
    }

    String newUniqueName() {
        Object name = StringUtil.toPaddedString(Long.toHexString(System.currentTimeMillis()), 16, '0', false);
        name = "DATASPACE" + ((String)name).substring(9).toUpperCase(Locale.ENGLISH);
        return name;
    }

    public boolean isLogged() {
        return DataspaceURL.isFileBasedDatabaseType(this.store.getModel()) && !this.store.isFilesReadOnly();
    }

    private void getEventLogger() {
        if (this.fwLogger != null) {
            return;
        }
        String name = this.store.getUniqueName();
        if (name == null) {
            return;
        }
        this.fwLogger = FrameworkLogger.getLog("ENGINE", "dtstore." + this.store.getUniqueName());
    }

    public void setEventLogLevel(int level, boolean sqlLog) {
        if (level < 0 || level > 3) {
            throw Error.error(5556);
        }
        if (sqlLog) {
            this.propSqlLogLevel = level;
            this.sqlLog.setLevel(level);
        } else {
            this.propEventLogLevel = level;
            this.appLog.setLevel(level);
        }
    }

    public void logSevereEvent(String message, Throwable t) {
        this.getEventLogger();
        if (this.fwLogger != null) {
            this.fwLogger.severe(message, t);
        }
        if (this.appLog != null) {
            if (t == null) {
                this.appLog.logContext(1, message);
            } else {
                this.appLog.logContext(t, message, 1);
            }
        }
        Trace.logError(this, message);
        if (t != null) {
            Trace.logException(this, t, false);
        }
    }

    public void logWarningEvent(String message, Throwable t) {
        this.getEventLogger();
        if (this.fwLogger != null) {
            this.fwLogger.warning(message, t);
        }
        this.appLog.logContext(t, message, 1);
        Trace.logInfo(this, "WARNING: " + message);
    }

    public void logInfoEvent(String message) {
        this.getEventLogger();
        if (this.fwLogger != null) {
            this.fwLogger.info(message);
        }
        this.appLog.logContext(2, message);
        Trace.logDebug(this, message);
    }

    public void logDetailEvent(String message) {
        this.getEventLogger();
        if (this.fwLogger != null) {
            this.fwLogger.finest(message);
        }
        if (this.appLog != null) {
            this.appLog.logContext(3, message);
        }
        Trace.logDebug(this, message);
    }

    public void logStatementEvent(Session session, Statement statement, Object[] paramValues, int level) {
        this.getEventLogger();
        if (this.sqlLogger != null) {
            this.sqlLogger.finest(statement.getSQL());
        }
        if (this.sqlLog != null && level <= this.propSqlLogLevel) {
            String sessionId = Long.toString(session.getId());
            String sql = statement.getSQL();
            String values = "";
            if (sql.length() > 100) {
                sql.substring(0, 100);
            }
            if (level == 3 && paramValues != null && paramValues.length > 0) {
                values = RowType.convertToSQLString(paramValues, statement.getParametersMetaData().getParameterTypes(), 32);
            }
            this.sqlLog.logContext(3, sessionId, sql, values);
        }
    }

    public int getSqlEventLogLevel() {
        return this.propSqlLogLevel;
    }

    private DataFileCache getCache() {
        if (this.log != null) {
            return this.log.getCache();
        }
        return null;
    }

    private boolean hasCache() {
        if (this.log != null) {
            return this.log.hasCache();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOtherStatement(Session session, LogRecordType type, String statement, NameManager.ObjectName objectName) {
        if (this.loggingEnabled) {
            this.writeLock.lock();
            try {
                NameManager.ObjectName nameForIndex = objectName;
                if (objectName != null && objectName.type != 2 && objectName.type != 1 && objectName.schema != null) {
                    this.writeSessionIdAndSchema(session, objectName.schema);
                } else {
                    this.writeSessionIdAndSchema(session);
                }
                if (statement != null && statement.equalsIgnoreCase("DISCONNECT")) {
                    this.writeSessionIdWithoutChecks(session, objectName);
                }
                long pos = this.log.dbLogWriter.getByteCount();
                this.log.writeOtherStatement(session, statement);
                int size = (int)(this.log.dbLogWriter.getByteCount() - pos);
                this.indexRecoveryLogRecord(session, nameForIndex, type, size);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeInsertStatement(Session session, Row row, Table table) {
        Objects.requireNonNull(session);
        if (!table.isLogged()) {
            return;
        }
        if (this.loggingEnabled) {
            this.writeLock.lock();
            try {
                NameManager.ObjectName nameForIndex = table.getObjectName();
                this.writeSessionIdAndSchema(session, table.getObjectName().schema);
                long pos = this.log.dbLogWriter.getByteCount();
                this.log.writeInsertStatement(session, row, table);
                int size = (int)(this.log.dbLogWriter.getByteCount() - pos);
                this.indexRecoveryLogRecord(session, nameForIndex, LogRecordType.INSERT, size);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDeleteStatement(Session session, Table table, Object[] row) {
        Objects.requireNonNull(session);
        if (!table.isLogged()) {
            return;
        }
        if (this.loggingEnabled) {
            this.writeLock.lock();
            try {
                NameManager.ObjectName nameForIndex = table.getObjectName();
                this.writeSessionIdAndSchema(session, table.getObjectName().schema);
                long pos = this.log.dbLogWriter.getByteCount();
                this.log.writeDeleteStatement(session, table, row);
                int size = (int)(this.log.dbLogWriter.getByteCount() - pos);
                this.indexRecoveryLogRecord(session, nameForIndex, LogRecordType.DELETE, size);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSequenceStatement(Session session, NumberSequence s) {
        if (this.loggingEnabled) {
            this.writeLock.lock();
            try {
                this.writeSessionIdAndSchema(session, s.getObjectName().schema);
                long pos = this.log.dbLogWriter.getByteCount();
                this.log.writeSequenceStatement(session, s);
                int size = (int)(this.log.dbLogWriter.getByteCount() - pos);
                this.indexRecoveryLogRecord(session, s.getObjectName(), LogRecordType.OTHER, size);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCommitStatement(Session session) {
        if (this.loggingEnabled) {
            this.writeLock.lock();
            try {
                this.writeSessionIdAndSchema(session);
                this.writeSessionIdWithoutChecks(session, null);
                long pos = this.log.dbLogWriter.getByteCount();
                this.log.writeCommitStatement(session);
                int size = (int)(this.log.dbLogWriter.getByteCount() - pos);
                this.indexRecoveryLogRecord(session, null, LogRecordType.COMMIT, size);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePrepareCommitStatement(Session session) {
        if (this.loggingEnabled) {
            this.writeLock.lock();
            try {
                this.writeSessionIdAndSchema(session);
                this.writeSessionIdWithoutChecks(session, null);
                long pos = this.log.dbLogWriter.getByteCount();
                this.log.writePrepareCommitStatement(session);
                int size = (int)(this.log.dbLogWriter.getByteCount() - pos);
                this.indexRecoveryLogRecord(session, null, LogRecordType.PREPARE_COMMIT, size);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRollbackStatement(Session session) {
        if (this.loggingEnabled) {
            this.writeLock.lock();
            try {
                this.writeSessionIdAndSchema(session);
                this.writeSessionIdWithoutChecks(session, null);
                long pos = this.log.dbLogWriter.getByteCount();
                this.log.writeOtherStatement(session, "ROLLBACK");
                int size = (int)(this.log.dbLogWriter.getByteCount() - pos);
                this.indexRecoveryLogRecord(session, null, LogRecordType.ROLLBACK, size);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    private void writeSessionIdAndSchema(Session session) {
        long pos = this.log.dbLogWriter.getByteCount();
        this.log.writeSessionIdAndSchema(session);
        int size = (int)(this.log.dbLogWriter.getByteCount() - pos);
        if (size > 0) {
            this.indexRecoveryLogRecord(session, session.currentDataspace, LogRecordType.SESSION, size);
        }
    }

    private void writeSessionIdAndSchema(Session session, NameManager.ObjectName schemaName) {
        long pos = this.log.dbLogWriter.getByteCount();
        this.log.writeSessionIdAndSchema(session, schemaName);
        int size = (int)(this.log.dbLogWriter.getByteCount() - pos);
        if (size > 0) {
            this.indexRecoveryLogRecord(session, schemaName, LogRecordType.SESSION, size);
        }
    }

    private void writeSessionIdWithoutChecks(Session session, NameManager.ObjectName schemaName) {
        long pos = this.log.dbLogWriter.getByteCount();
        this.log.writeSessionIdWithoutChecks(session, schemaName);
        int size = (int)(this.log.dbLogWriter.getByteCount() - pos);
        if (size > 0) {
            this.indexRecoveryLogRecord(session, schemaName, LogRecordType.SESSION, size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result checkpoint(boolean defrag, CheckpointManager.CheckpointStats.CheckpointAttempt checkpointAttempt) {
        try {
            this.store.lobManager.lock();
            Result result = this.checkpointWithLock(defrag, checkpointAttempt);
            return result;
        }
        finally {
            this.store.lobManager.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result checkpointWithLock(boolean defrag, CheckpointManager.CheckpointStats.CheckpointAttempt checkpointAttempt) {
        this.writeLock.lock();
        try {
            if (!this.backupState.compareAndSet(0, 2)) {
                throw Error.error(457);
            }
            try {
                Result result = this.checkpointInternal(defrag, checkpointAttempt);
                this.backupState.set(0);
                return result;
            }
            catch (Throwable throwable) {
                this.backupState.set(0);
                throw throwable;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public CountDownLatch lock() {
        return this.log.lock();
    }

    public void unlock() {
        this.log.unlock();
    }

    Result checkpointInternal(boolean mode, CheckpointManager.CheckpointStats.CheckpointAttempt checkpointAttempt) {
        Result result = Result.updateNoResult;
        if (this.logsStatements) {
            this.store.dataspaceLogger.logInfoEvent("Checkpoint start");
            result = this.log.checkpoint(mode, checkpointAttempt);
            this.store.collectionSessionManager.resetLoggedSchemas();
            this.store.dataspaceLogger.logInfoEvent("Checkpoint end");
        } else if (!this.isFileDatabase() && !this.store.txManager.isMVCC()) {
            this.store.lobManager.deleteUnusedLobs();
            this.store.flobManager.deleteUnusedFlobs();
        }
        return result;
    }

    public void setLogSize(int megas) {
        this.writeLock.lock();
        try {
            this.propLogSize = megas;
            if (this.store.checkpointManager != null) {
                this.store.checkpointManager.setLogSizeMax(this.propLogSize * 1024 * 1024);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setLogData(boolean mode) {
        this.writeLock.lock();
        try {
            this.propLogData = mode;
            this.loggingEnabled = this.propLogData && !this.store.isFilesReadOnly();
            this.loggingEnabled &= this.logsStatements;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setScriptType(String format) {
        this.writeLock.lock();
        try {
            if (format.equals(this.propScriptFormat)) {
                return;
            }
            this.propScriptFormat = format;
            this.store.getCheckpointManager().enqueueCheckpointRequired();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setWriteDelay(int delay) {
        this.writeLock.lock();
        try {
            this.propWriteDelay = delay;
            if (this.log != null) {
                this.log.setWriteDelay(delay);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Crypto getCrypto() {
        return this.crypto;
    }

    public int getWriteDelay() {
        return this.propWriteDelay;
    }

    public int getLobBlockSize() {
        return this.propLobBlockSize;
    }

    public boolean isLobInMem() {
        return this.propLobInMem;
    }

    public String getFlobLocationPath() {
        return this.propFlobLocationPath;
    }

    public void setIncrementBackup(boolean val) {
        this.writeLock.lock();
        try {
            if (val == this.propIncrementBackup) {
                return;
            }
            if (this.log != null) {
                this.log.setIncrementBackup(val);
                if (this.log.hasCache()) {
                    this.store.getCheckpointManager().enqueueCheckpointRequired();
                }
            }
            this.propIncrementBackup = val;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setCacheMaxRows(int value) {
        this.propCacheMaxRows = value;
    }

    public int getCacheRowsDefault() {
        return this.propCacheMaxRows;
    }

    public void setCacheSize(int value) {
        this.propCacheMaxSize = value * 1024;
    }

    public int getCacheSize() {
        return this.propCacheMaxSize;
    }

    public void setCacheFileScale(int value) {
        if (this.propCacheFileScale == value) {
            return;
        }
        Logger.checkPower(value, 10);
        if (value < 8 && value != 1) {
            throw Error.error(5556);
        }
        if (this.hasCache()) {
            throw Error.error(469);
        }
        this.propCacheFileScale = value;
    }

    public void setCacheFileScaleNoCheck(int value) {
        Logger.checkPower(value, 10);
        if (value < 8 && value != 1) {
            throw Error.error(5556);
        }
        this.propCacheFileScale = value;
    }

    public int getCacheFileScale() {
        return this.propCacheFileScale;
    }

    public void setLobFileScale(int value) {
        if (this.propLobBlockSize == value * 1024) {
            return;
        }
        Logger.checkPower(value, 5);
        if (this.store.lobManager.getLobCount() > 0) {
            throw Error.error(469);
        }
        this.propLobBlockSize = value * 1024;
        this.store.lobManager.close();
        this.store.lobManager.open();
    }

    public void setLobFileScaleNoCheck(int value) {
        Logger.checkPower(value, 5);
        this.propLobBlockSize = value * 1024;
    }

    public void setLobInMemoryNoCheck(boolean value) {
        this.propLobInMem = value;
    }

    public int getLobFileScale() {
        return this.propLobBlockSize / 1024;
    }

    public void setDefagLimit(int value) {
        this.propCacheDefragLimit = value;
    }

    public int getDefragLimit() {
        return this.propCacheDefragLimit;
    }

    public void setNioDataFile(boolean value) {
        this.propNioDataFile = value;
    }

    public void setNioMaxSize(int value) {
        if (value < 8) {
            throw Error.error(5556);
        }
        if (!(ArrayUtil.isTwoPower(value, 10) || value >= 1024 && value % 512 == 0)) {
            throw Error.error(5556);
        }
        this.propNioMaxSize = (long)value * 1024L * 1024L;
    }

    public FileAccess getFileAccess() {
        return this.fileAccess;
    }

    public boolean isStoredFileAccess() {
        return this.isStoredFileAccess;
    }

    public boolean isFileDatabase() {
        return this.propIsFileDatabase;
    }

    public String getTempDirectoryPath() {
        return this.tempDirectoryPath;
    }

    static void checkPower(int n, int max) {
        if (!ArrayUtil.isTwoPower(n, max)) {
            throw Error.error(5556);
        }
    }

    public void setCheckpointRequired() {
        this.store.getCheckpointManager().enqueueCheckpointRequired();
    }

    public PersistentStore newStore(Session session, PersistentStoreCollection collection, TableBase table) {
        switch (table.getTableType()) {
            case 6: {
                DataFileCache cache = this.getCache();
                if (cache == null) break;
                return new RowStoreAVLDisk(collection, cache, (Table)table);
            }
            case 4: 
            case 5: 
            case 12: 
            case 13: {
                return new RowStoreAVLMemory(collection, (Table)table);
            }
            case 8: {
                return new RowStoreAVLDiskData(collection, (Table)table);
            }
            case 15: {
                return new RowStoreJFQ(collection, (JournalFileQueueTable)table);
            }
            case 16: {
                return new RowStoreSnapshot(collection, (SnapshotDataspaceTable)table);
            }
            case 1: {
                return new RowStoreAVLHybridExtended(session, collection, table, false);
            }
            case 3: {
                return new RowStoreAVLHybridExtended(session, collection, table, true);
            }
            case 14: {
                return new RowStoreDataChange(session, collection, table);
            }
            case 2: 
            case 9: 
            case 10: 
            case 11: {
                if (session == null) {
                    return null;
                }
                return new RowStoreAVLHybrid(session, collection, table, true);
            }
        }
        throw Error.runtimeError(201, "Logger");
    }

    public Index newIndex(NameManager.ObjectName name, long id, TableBase table, int[] columns, boolean[] descending, boolean[] nullsLast, Type[] colTypes, boolean pk, boolean unique, boolean constraint, boolean forward, SIndexType sIndexType) {
        switch (table.getTableType()) {
            case 1: 
            case 4: 
            case 5: 
            case 13: {
                return new IndexAVLMemory(name, id, table, columns, descending, nullsLast, colTypes, pk, unique, constraint, forward, this.indexOperationMaxTime);
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                return new IndexAVL(name, id, table, columns, descending, nullsLast, colTypes, pk, unique, constraint, forward, this.indexOperationMaxTime);
            }
            case 15: {
                return new IndexJFQ(name, id, table, columns, descending, nullsLast, colTypes, pk, unique, constraint, forward);
            }
            case 16: {
                return new IndexSnapshot(name, id, table, columns, descending, nullsLast, colTypes, pk, unique, constraint, forward, sIndexType);
            }
        }
        throw Error.runtimeError(201, "Logger");
    }

    public Index newIndex(Table table, Index index, int[] columns, SIndexType sIndexType) {
        boolean[] modeFlags = new boolean[columns.length];
        Object[] colTypes = new Type[columns.length];
        ArrayUtil.projectRow(table.getColumnTypes(), columns, colTypes);
        switch (table.getTableType()) {
            case 4: 
            case 5: {
                return new IndexAVLMemory(index.getObjectName(), index.getPersistenceId(), table, columns, modeFlags, modeFlags, (Type[])colTypes, false, false, false, false, this.indexOperationMaxTime);
            }
            case 6: 
            case 8: {
                return new IndexAVL(index.getObjectName(), index.getPersistenceId(), table, columns, modeFlags, modeFlags, (Type[])colTypes, false, false, false, false, this.indexOperationMaxTime);
            }
            case 16: {
                return new IndexSnapshot(index.getObjectName(), index.getPersistenceId(), table, columns, modeFlags, modeFlags, (Type[])colTypes, false, false, false, false, sIndexType);
            }
        }
        throw Error.runtimeError(201, "Logger");
    }

    public String getValueStringForProperty(String name) {
        String value = "";
        if ("dtspace.tx_management".equals(name)) {
            switch (this.store.txManager.getTransactionControl()) {
                case 2: {
                    value = "MVCC".toLowerCase();
                    break;
                }
                case 1: {
                    value = "MVLOCKS".toLowerCase();
                    break;
                }
                case 0: {
                    value = "LOCKS".toLowerCase();
                }
            }
            return value;
        }
        if ("dtspace.tx_isolation_level".equals(name)) {
            switch (this.store.defaultIsolationLevel) {
                case 2: {
                    value = new StringBuffer("READ").append(' ').append("COMMITTED").toString().toLowerCase();
                    break;
                }
                case 8: {
                    value = "SERIALIZABLE".toLowerCase();
                }
            }
            return value;
        }
        if ("dtspace.applog".equals(name)) {
            return String.valueOf(this.appLog.getLevel());
        }
        if ("dtspace.lob_file_scale".equals(name)) {
            return String.valueOf(this.propLobBlockSize);
        }
        if ("dtspace.lob_in_mem".equals(name)) {
            return String.valueOf(this.propLobInMem);
        }
        if ("dtspace.extended_sql_audit".equals(name)) {
            return String.valueOf(this.propExtendedSqlAudit);
        }
        if ("dtspace.flob_location_path".equals(name)) {
            return String.valueOf(this.propFlobLocationPath);
        }
        if ("dtspace.cache_file_scale".equals(name)) {
            return String.valueOf(this.propCacheFileScale);
        }
        if ("dtspace.cache_free_count_scale".equals(name)) {
            return String.valueOf(this.propMaxFreeBlocks);
        }
        if ("dtspace.cache_rows".equals(name)) {
            return String.valueOf(this.propCacheMaxRows);
        }
        if ("dtspace.cache_size".equals(name)) {
            String.valueOf(this.propCacheMaxSize);
        }
        if ("dtspace.default_memory_model".equals(name)) {
            return this.store.schemaManager.getDefaultMemoryModel() == MemoryModel.PERSISTENT ? "persistent" : (this.store.schemaManager.getDefaultMemoryModel() == MemoryModel.LOGGED ? "logged" : "memory");
        }
        if ("dtspace.defrag_limit".equals(name)) {
            return String.valueOf(this.propCacheDefragLimit);
        }
        if ("dtspace.files_readonly".equals(name)) {
            return this.store.dataspaceStoreProperties.getPropertyString("dtspace.files_readonly");
        }
        if ("dtspace.log_data".equals(name)) {
            return String.valueOf(this.propLogData);
        }
        if ("dtspace.log_size".equals(name)) {
            return String.valueOf(this.propLogSize);
        }
        if ("dtspace.log_size_critical".equals(name)) {
            return String.valueOf(this.propLogSizeCritical);
        }
        if ("dtspace.nio_data_file".equals(name)) {
            return String.valueOf(this.propNioDataFile);
        }
        if ("dtspace.nio_max_size".equals(name)) {
            return String.valueOf(this.propNioMaxSize);
        }
        if ("dtspace.script_format".equals(name)) {
            return ScriptWriterBase.LIST_SCRIPT_FORMATS[0].toLowerCase();
        }
        if ("dtspace.temp_directory".equals(name)) {
            return null;
        }
        if ("dtspace.result_max_memory_rows".equals(name)) {
            return String.valueOf(this.propCacheDefragLimit);
        }
        if ("dtspace.write_delay".equals(name)) {
            return String.valueOf(this.propWriteDelay != 0);
        }
        if ("dtspace.write_delay_millis".equals(name)) {
            return String.valueOf(this.propWriteDelay);
        }
        if ("sql.ref_integrity".equals(name)) {
            return this.store.isReferentialIntegrity() ? "true" : "false";
        }
        if ("sql.compare_in_locale".equals(name)) {
            return null;
        }
        if ("sql.enforce_size".equals(name)) {
            return String.valueOf(this.store.sqlEnforceSize);
        }
        if ("sql.enforce_strict_size".equals(name)) {
            return String.valueOf(this.store.sqlEnforceSize);
        }
        if ("sql.enforce_refs".equals(name)) {
            return String.valueOf(this.store.sqlEnforceRefs);
        }
        if ("sql.enforce_names".equals(name)) {
            return String.valueOf(this.store.sqlEnforceNames);
        }
        if ("sql.enforce_types".equals(name)) {
            return String.valueOf(this.store.sqlEnforceTypes);
        }
        if ("jdbc.translate_tti_types".equals(name)) {
            return String.valueOf(this.store.sqlTranslateTTI);
        }
        if ("sql.longvar_is_lob".equals(name)) {
            return String.valueOf(this.store.sqlLongvarIsLob);
        }
        if ("dtspace.checkpoint_interval".equals(name)) {
            return String.valueOf(this.propCheckpointInterval);
        }
        if ("dtspace.checkpoint_interval_repeat".equals(name)) {
            return String.valueOf(this.propCheckpointIntervalRepeat);
        }
        if ("dtspace.checkpoint_interval_critical".equals(name)) {
            return String.valueOf(this.propCheckpointIntervalCritical);
        }
        if ("dtspace.checkpoint_lock_timeout1".equals(name)) {
            return String.valueOf(this.propCheckpointLockTimeout1);
        }
        if ("dtspace.checkpoint_lock_timeout2".equals(name)) {
            return String.valueOf(this.propCheckpointLockTimeout2);
        }
        if ("dtspace.checkpoint_check_consistency".equals(name)) {
            return String.valueOf(this.propCheckpointCheckConsistency);
        }
        if ("dtspace.index_operation_max_time".equals(name)) {
            return String.valueOf(this.indexOperationMaxTime);
        }
        if ("dtspace.query_mem_limit".equals(name)) {
            return this.store.queryMemoryMonitor != null ? String.valueOf(this.store.queryMemoryMonitor.getThresholdPercent()) : this.store.dataspaceStoreProperties.getPropertyString("dtspace.query_mem_limit");
        }
        if ("dtspace.query_mem_limit_chk_rows_start".equals(name)) {
            return this.store.queryMemoryMonitor != null ? String.valueOf(this.store.queryMemoryMonitor.getChkRowsStart()) : this.store.dataspaceStoreProperties.getPropertyString("dtspace.query_mem_limit_chk_rows_start");
        }
        if ("dtspace.query_mem_limit_chk_rows_interval".equals(name)) {
            return this.store.queryMemoryMonitor != null ? String.valueOf(this.store.queryMemoryMonitor.getChkRowsInterval()) : this.store.dataspaceStoreProperties.getPropertyString("dtspace.query_mem_limit_chk_rows_interval");
        }
        if ("dtspace.typesafe".equals(name)) {
            return this.store.dataspaceStoreProperties.getPropertyString("dtspace.typesafe");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backup(String destPath, boolean script, boolean blocking, boolean compressed) {
        if (!this.backupState.compareAndSet(0, 1)) {
            throw Error.error(470, "BACKUP IN PROGRESS");
        }
        try {
            this.backupInternal(destPath, script, blocking, compressed);
        }
        finally {
            this.backupState.set(0);
        }
    }

    void backupInternal(String destPath, boolean script, boolean blocking, boolean compressed) {
        block19: {
            boolean nameImpliesCompress;
            String scriptName = null;
            String dbPath = this.store.getPath();
            String instanceName = new File(dbPath).getName();
            char lastChar = destPath.charAt(destPath.length() - 1);
            boolean generateName = lastChar == '/' || lastChar == this.runtimeFileDelim.charValue();
            String defaultCompressionSuffix = compressed ? ".tar.gz" : ".tar";
            File archiveFile = generateName ? new File(destPath.substring(0, destPath.length() - 1), instanceName + "-" + this.backupFileFormat.format(new Date()) + defaultCompressionSuffix) : new File(destPath);
            boolean bl = nameImpliesCompress = archiveFile.getName().toLowerCase().endsWith(".tar.gz") || archiveFile.getName().toLowerCase().endsWith(".tgz");
            if (!nameImpliesCompress && !archiveFile.getName().toLowerCase().endsWith(".tar")) {
                throw Error.error(null, 462, 0, new String[]{archiveFile.getName(), ".tar, .tar.gz, .tgz"});
            }
            if (compressed != nameImpliesCompress) {
                throw Error.error(null, 463, 0, new Object[]{new Boolean(compressed), archiveFile.getName()});
            }
            try {
                this.store.dataspaceLogger.logInfoEvent("Initiating backup of instance '" + instanceName + "'");
                if (script) {
                    Object path = this.getTempDirectoryPath();
                    if (path == null) {
                        return;
                    }
                    path = (String)path + "/" + new File(this.store.getPath()).getName();
                    scriptName = (String)path + logFileExtension;
                    LogFileIndex logIndex = new LogFileIndex(this.log.logFileName + ".idx.v", this.fileAccess);
                    logIndex.openForWrite(false);
                    ScriptWriterText dsw = new ScriptWriterText(this.store, scriptName, true, false, true);
                    this.store.generateLogIndex = true;
                    this.store.logIndexBuilder = new java.util.HashMap<Integer, DataspaceStore.DDLRecordNode>();
                    dsw.writeAll(logIndex);
                    dsw.close();
                    logIndex.close();
                    this.store.logIndexBuilder = null;
                    this.store.generateLogIndex = false;
                    this.backup = new DbBackup(archiveFile, (String)path, true);
                    this.backup.write();
                } else {
                    this.backup = new DbBackup(archiveFile, dbPath);
                    this.backup.setAbortUponModify(false);
                    if (!blocking) {
                        InputStreamWrapper isw;
                        File file = null;
                        if (this.hasCache()) {
                            DataFileCache dataFileCache = this.getCache();
                            RAShadowFile shadowFile = dataFileCache.getShadowFile();
                            if (shadowFile == null) {
                                this.backup.setFileIgnore(dataFileExtension);
                            } else {
                                file = new File(dataFileCache.dataFileName);
                                isw = new InputStreamWrapper(new FileInputStream(file));
                                isw.setSizeLimit(dataFileCache.fileStartFreePosition);
                                this.backup.setStream(dataFileExtension, isw);
                                InputStreamInterface isi = shadowFile.getInputStream();
                                this.backup.setStream(backupFileExtension, isi);
                            }
                        }
                        file = new File(this.log.getRecoveryLogFileName());
                        long fileLength = file.length();
                        isw = new InputStreamWrapper(new FileInputStream(file));
                        isw.setSizeLimit(fileLength);
                        this.backup.setStream(recoveryLogFileExtension, isw);
                    }
                    this.backup.write();
                }
                this.store.dataspaceLogger.logInfoEvent("Successfully backed up instance '" + instanceName + "' to '" + destPath + "'");
                if (scriptName == null) break block19;
                FileUtil.getFileUtil().delete(scriptName);
            }
            catch (IOException ioe) {
                throw Error.error(452, ioe.toString());
            }
            catch (TarMalformatException tme) {
                throw Error.error(452, tme.toString());
            }
            finally {
                if (scriptName != null) {
                    FileUtil.getFileUtil().delete(scriptName);
                }
                if (blocking) {
                    this.log.checkpointReopen();
                }
            }
        }
        if (blocking) {
            this.log.checkpointReopen();
        }
    }

    public String getSecurePath(String path) {
        File pathFile;
        String startupDir = (String)DataspaceStoreManager.getRuntimeContext().getEnvironment().get("streamscape.runtime.startup.dir");
        if (startupDir == null || startupDir.equals(".") || startupDir.length() == 0) {
            startupDir = System.getProperty("user.dir");
        }
        if (!(pathFile = new File((String)path)).isAbsolute()) {
            path = startupDir + File.separator + (String)path;
        }
        startupDir = FileUtil.getFileUtil().canonicalOrAbsolutePath(startupDir);
        path = FileUtil.getFileUtil().canonicalOrAbsolutePath((String)path);
        if (!((String)path).startsWith(startupDir) && !this.store.dataspaceLogger.propTextAllowFullPath) {
            return null;
        }
        return path;
    }

    public DataFileCache openTextFilePersistence(FileTable table, String source, boolean readOnlyData, FileServerObject serverObject, boolean isAppendable) {
        this.closeTextCache(table);
        String originalSource = source;
        if (serverObject == null) {
            source = this.getSecurePath(originalSource);
        }
        if (source == null) {
            throw Error.error(471, new Object[]{"Source file '" + originalSource + "' is external file."});
        }
        FileTableCache fileTableCache = serverObject == null ? new FileTableCache(table) : new ExternalFileTableCache(table, serverObject);
        fileTableCache.setAppendable(isAppendable);
        fileTableCache.init(source);
        fileTableCache.open(readOnlyData || this.store.isFilesReadOnly());
        this.textCacheList.put(table.getObjectName(), fileTableCache);
        return fileTableCache;
    }

    public void closeTextCache(Table table) {
        FileTableCache fileTableCache = (FileTableCache)this.textCacheList.remove(table.getObjectName());
        if (fileTableCache != null) {
            try {
                fileTableCache.close(true);
            }
            catch (DataspaceException dataspaceException) {
                // empty catch block
            }
        }
    }

    void closeAllTextCaches(boolean script) {
        Iterator it = this.textCacheList.values().iterator();
        while (it.hasNext()) {
            FileTableCache textCache = (FileTableCache)it.next();
            if (script && !textCache.table.isDataReadOnly()) {
                textCache.purge();
                continue;
            }
            textCache.close(true);
        }
    }

    boolean isAnyTextCacheModified() {
        Iterator it = this.textCacheList.values().iterator();
        while (it.hasNext()) {
            if (!((FileTableCache)it.next()).isModified()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void relinkRecoveryLogTable() {
        Session session = null;
        try {
            session = this.store.getSessionManager().getSysSessionForScript(this.store);
            session.setDataspace("SDS");
            SchemaObject recoveryErrorsTable = this.store.schemaManager.findSchemaObject("RECOVERY_LOG", "SDS", 4);
            FileTableCollection recoveryErrors = (FileTableCollection)recoveryErrorsTable;
            if (recoveryErrors != null && recoveryErrors.isLinked()) {
                recoveryErrors.unlink(session);
                recoveryErrors.link(session, false);
            }
            if (!this.store.dataspaceLogger.isRecoveryLogFailuresEmpty(session)) {
                this.store.setStoreState(DataspaceStoreState.RECOVERY_FAILED);
            }
            DataspaceStoreState.ONLINE.name();
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    public boolean isRecoveryLogFailuresEmpty(Session session) {
        SchemaObject recoveryErrors = this.store.schemaManager.findSchemaObject("RECOVERY_LOG", "SDS", 4);
        if (recoveryErrors instanceof FileTableCollection && ((FileTableCollection)recoveryErrors).isLinked()) {
            PersistentStore persistentStore = this.store.persistentStoreCollection.getStore(((FileTableCollection)recoveryErrors).getBaseTable());
            long size = persistentStore.elementCount(session);
            return size <= 0L;
        }
        File file = new File(this.store.getPath() + errorSqlFileExtension);
        return !file.exists() || file.length() <= 0L;
    }

    public void indexRecoveryLogRecord(Session session, NameManager.ObjectName objectName, LogRecordType type, int length) {
        if (objectName != null) {
            if (objectName.type == 2) {
                this.log.recoveryLogIndex.indexLogRecord(type, length, objectName.getId(), -1, session);
            } else {
                this.log.recoveryLogIndex.indexLogRecord(type, length, objectName.schema.getId(), objectName.getId(), session);
            }
        } else {
            this.log.recoveryLogIndex.indexLogRecord(type, length, -1, -1, session);
        }
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public void setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    public long getRecoveryLogSize() {
        if (this.log != null) {
            return this.log.getRecoveryLogSize();
        }
        return 0L;
    }

    public long getLogSize() {
        if (this.log != null) {
            return this.log.getLogSize();
        }
        return 0L;
    }
}

