/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.ds.persist.LogFileIndex;
import com.streamscape.ds.persist.LogRecord;
import com.streamscape.ds.persist.LogRecordType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class LogIndexesAnalyzer {
    LogIndexesAnalyzer() {
    }

    static void analyse(LogFileIndex logIndex, LogFileIndex recoveryLogIndex) {
        boolean dropped;
        if (recoveryLogIndex.dropDataspaceLogRecords != null && logIndex.logRecords != null && recoveryLogIndex.logRecords != null) {
            for (LogRecord dropRecord : recoveryLogIndex.dropDataspaceLogRecords) {
                if (dropRecord.getDataspaceId() == -1) continue;
                dropped = false;
                dropped |= LogIndexesAnalyzer.invalidateForDropDataspaceRecord(dropRecord, logIndex.logRecords, -1);
                if (!(dropped |= LogIndexesAnalyzer.invalidateForDropDataspaceRecord(dropRecord, recoveryLogIndex.logRecords, dropRecord.recordId))) continue;
                dropRecord.setInvalid();
            }
        }
        if (recoveryLogIndex.dropObjectLogRecords != null && logIndex.logRecords != null && recoveryLogIndex.logRecords != null) {
            for (LogRecord dropRecord : recoveryLogIndex.dropObjectLogRecords) {
                if (!dropRecord.valid || dropRecord.getDataspaceId() == -1 || dropRecord.getObjectId() == -1) continue;
                dropped = false;
                dropped |= LogIndexesAnalyzer.invalidateForDropObjectRecord(dropRecord, logIndex.logRecords, -1);
                if (!(dropped |= LogIndexesAnalyzer.invalidateForDropObjectRecord(dropRecord, recoveryLogIndex.logRecords, dropRecord.recordId))) continue;
                dropRecord.setInvalid();
            }
        }
        if (recoveryLogIndex.unlinkLogRecords != null && logIndex.unlinkLogRecords != null && recoveryLogIndex.unlinkLogRecords != null) {
            for (LogRecord unlinkRecord : recoveryLogIndex.unlinkLogRecords) {
                if (!unlinkRecord.valid || unlinkRecord.getDataspaceId() == -1 || unlinkRecord.getObjectId() == -1) continue;
                boolean unlinked = false;
                unlinked |= LogIndexesAnalyzer.invalidateForUnlinkRecord(unlinkRecord, logIndex.logRecords, -1);
                if (!(unlinked |= LogIndexesAnalyzer.invalidateForUnlinkRecord(unlinkRecord, recoveryLogIndex.logRecords, unlinkRecord.recordId))) continue;
                unlinkRecord.setInvalid();
            }
        }
        if (recoveryLogIndex.logRecords != null) {
            HashMap<Long, ArrayList<LogRecord>> sessionIdToRecord = new HashMap<Long, ArrayList<LogRecord>>();
            for (LogRecord record : recoveryLogIndex.logRecords) {
                List<LogRecord> sessionRecords;
                if (!record.isValid()) continue;
                if (record.getType() == LogRecordType.COMMIT || record.getType() == LogRecordType.DISCONNECT) {
                    sessionIdToRecord.remove(record.getSessionId());
                    continue;
                }
                if (record.getType() == LogRecordType.ROLLBACK) {
                    sessionRecords = (ArrayList<LogRecord>)sessionIdToRecord.remove(record.getSessionId());
                    if (sessionRecords == null) continue;
                    for (LogRecord rolledBackRecord : sessionRecords) {
                        if (rolledBackRecord.getType() != LogRecordType.INSERT && rolledBackRecord.getType() != LogRecordType.DELETE) continue;
                        rolledBackRecord.setInvalid();
                    }
                    continue;
                }
                sessionRecords = (List)sessionIdToRecord.get(record.getSessionId());
                if (sessionRecords == null) {
                    sessionRecords = new ArrayList<LogRecord>();
                    sessionIdToRecord.put(record.getSessionId(), (ArrayList<LogRecord>)sessionRecords);
                }
                sessionRecords.add(record);
            }
            for (List records : sessionIdToRecord.values()) {
                for (LogRecord record : records) {
                    record.setCommitted(false);
                }
            }
        }
    }

    private static boolean invalidateForDropObjectRecord(LogRecord dropRecord, List<LogRecord> records, int limit) {
        boolean dropped = false;
        for (LogRecord logRecord : records) {
            if (logRecord.valid && logRecord.dataspaceId == dropRecord.dataspaceId && logRecord.objectId == dropRecord.objectId && logRecord != dropRecord) {
                logRecord.valid = false;
                dropped = true;
            }
            if (limit == -1 || logRecord.recordId < limit) continue;
            break;
        }
        return dropped;
    }

    private static boolean invalidateForUnlinkRecord(LogRecord dropRecord, List<LogRecord> records, int limit) {
        boolean dropped = false;
        for (LogRecord logRecord : records) {
            if (logRecord.type == LogRecordType.LINK && logRecord.valid && logRecord.dataspaceId == dropRecord.dataspaceId && logRecord.objectId == dropRecord.objectId && logRecord != dropRecord) {
                logRecord.valid = false;
                dropped = true;
            }
            if (limit == -1 || logRecord.recordId < limit) continue;
            break;
        }
        return dropped;
    }

    private static boolean invalidateForDropDataspaceRecord(LogRecord dropRecord, List<LogRecord> records, int limit) {
        boolean dropped = false;
        for (LogRecord logRecord : records) {
            if (logRecord.valid && logRecord.dataspaceId == dropRecord.dataspaceId && logRecord != dropRecord && logRecord.type != LogRecordType.SESSION && logRecord.type != LogRecordType.DISCONNECT) {
                logRecord.valid = false;
                dropped = true;
            }
            if (limit == -1 || logRecord.recordId < limit) continue;
            break;
        }
        return dropped;
    }
}

