/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.lib.FileUtil;
import com.streamscape.ds.persist.LogFileIndex;
import com.streamscape.ds.persist.LogIndexesAnalyzer;
import com.streamscape.ds.persist.LogRecord;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Iterator;

public class LogIndexPrinter {
    public static void main(String[] args) throws Exception {
        String logFileName = "dtspace.log";
        String logIndexFileName = logFileName + ".idx";
        String rcvFileName = "dtspace.rcv";
        String rcvIndexFileName = rcvFileName + ".idx";
        LogFileIndex logIndexFile = new LogFileIndex(logIndexFileName, FileUtil.getFileUtil());
        logIndexFile.read();
        LogFileIndex rcvIndexFile = new LogFileIndex(rcvIndexFileName, FileUtil.getFileUtil());
        rcvIndexFile.read();
        LogIndexesAnalyzer.analyse(logIndexFile, rcvIndexFile);
        LogIndexPrinter.printLogFile(logFileName, logIndexFile);
        LogIndexPrinter.printLogFile(rcvFileName, rcvIndexFile);
    }

    static void printLogFile(String filename, LogFileIndex indexFile) throws Exception {
        System.out.println("\n======= File " + filename + " =========\n");
        PrintStream out = new PrintStream(new FileOutputStream(new File(filename + ".decoded")));
        File logFile = new File(filename);
        if (!logFile.exists()) {
            throw new Exception("Log file " + filename + " doesn't exist.");
        }
        FileInputStream logFileInput = new FileInputStream(logFile);
        Iterator<LogRecord> iterator = indexFile.getIterator();
        byte[] buffer = new byte[1024];
        long totalReadBytes = 0L;
        while (iterator.hasNext()) {
            int readBytes;
            LogRecord logRecord = iterator.next();
            if (logRecord.size > buffer.length) {
                buffer = new byte[logRecord.size];
            }
            if (logRecord.size != (readBytes = logFileInput.read(buffer, 0, logRecord.size))) {
                throw new DataspaceException("Unable to read recovery log record. Already read " + totalReadBytes + " bytes.");
            }
            totalReadBytes += (long)readBytes;
            String statement = new String(buffer, 0, logRecord.size, "ISO-8859-1");
            out.println("---- size: " + logRecord.size + ", type: " + String.valueOf((Object)logRecord.type) + ", recordId: " + logRecord.recordId + ", dataspaceId: " + logRecord.dataspaceId + ", objectId: " + logRecord.objectId + ", sessionId: " + logRecord.sessionId + ", isValid: " + logRecord.isValid() + ", isCommitted: " + logRecord.committed);
            out.println(statement);
        }
        logFileInput.close();
        out.close();
        System.out.println("total read bytes " + totalReadBytes + " of " + logFile.length());
    }
}

