/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.lib.FileAccess;
import com.streamscape.ds.persist.LogRecord;
import com.streamscape.ds.persist.LogRecordType;
import com.streamscape.ds.session.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LogFileIndex {
    private static final byte INDEX_FILE_FORMAT_VERSION = 5;
    protected String indexFileName;
    protected FileOutputStream indexFile;
    protected List<LogRecord> logRecords;
    protected List<LogRecord> dropObjectLogRecords;
    protected List<LogRecord> dropDataspaceLogRecords;
    protected List<LogRecord> unlinkLogRecords;
    protected long logRecordsSize;
    protected FileAccess fileAccess;
    protected boolean corrupted = false;
    private static final int RECORD_TYPE = 0;
    private static final int RECORD_TYPE_SIZE = 1;
    private static final int RECORD_SIZE_IN_FILE = 1;
    private static final int RECORD_SIZE_IN_FILE_SIZE = 4;
    private static final int RECORD_DATASPACE_ID = 5;
    private static final int RECORD_DATASPACE_ID_SIZE = 4;
    private static final int RECORD_OBJECT_ID = 9;
    private static final int RECORD_OBJECT_ID_SIZE = 4;
    private static final int RECORD_SESSION_ID = 13;
    private static final int RECORD_SESSION_ID_SIZE = 8;
    public static final int RECORD_SIZE = 21;
    public static final int VERSION_SIZE = 1;
    byte[] buffer = new byte[21];

    protected LogFileIndex(String indexFileName, FileAccess fa) {
        this.indexFileName = indexFileName;
        this.fileAccess = fa;
    }

    public void openForWrite(boolean append) {
        try {
            File inputFileDescriptor = new File(this.indexFileName);
            if (append && (!inputFileDescriptor.exists() || inputFileDescriptor.length() == 0L)) {
                this.corrupted = true;
                return;
            }
            this.corrupted = false;
            long length = inputFileDescriptor.length();
            this.indexFile = new FileOutputStream(inputFileDescriptor, append);
            if (length == 0L) {
                this.writeVersion();
            }
        }
        catch (IOException error) {
            Trace.logError(this, error.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trim(long length) {
        block7: {
            try {
                File file = new File(this.indexFileName);
                if (!file.exists() || file.length() <= length) break block7;
                try (RandomAccessFile randomAccessFile = null;){
                    randomAccessFile = new RandomAccessFile(file, "rw");
                    randomAccessFile.setLength(length);
                }
                this.openForWrite(true);
                if (length == 0L) {
                    this.writeVersion();
                }
            }
            catch (Exception exception) {
                Trace.logError(this, "Failed to trim index file '" + this.indexFileName + "'.");
                Trace.logException(this, exception, true);
            }
        }
    }

    private void writeVersion() {
        try {
            this.indexFile.write(5);
            this.indexFile.flush();
        }
        catch (IOException error) {
            Trace.logError(this, error.getMessage());
        }
    }

    public long getLogRecordsSize() {
        return this.logRecordsSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() {
        block23: {
            FileInputStream input = null;
            try {
                LogRecord record;
                File indexFileDescriptor = new File(this.indexFileName);
                long length = indexFileDescriptor.length();
                input = new FileInputStream(indexFileDescriptor);
                if (input == null || length <= 0L) break block23;
                this.logRecords = new ArrayList<LogRecord>();
                this.dropDataspaceLogRecords = new ArrayList<LogRecord>();
                this.dropObjectLogRecords = new ArrayList<LogRecord>();
                this.unlinkLogRecords = new ArrayList<LogRecord>();
                this.logRecordsSize = 0L;
                try {
                    byte version = (byte)input.read();
                    if (version != 5) {
                        Trace.logError(this, "Version mismatch. Existing log index file has an obsolete format and will be skipped.");
                        this.close();
                        this.fileAccess.removeElement(this.indexFileName);
                        return;
                    }
                }
                catch (IOException error) {
                    Trace.logError(this, "Unable to read index file version. " + error.getMessage() + " Index will be recreated.");
                    this.close();
                    return;
                }
                int recordId = -1;
                while ((record = this.readLogRecord(input)) != null) {
                    this.logRecordsSize += (long)record.getSize();
                    record.recordId = ++recordId;
                    this.logRecords.add(record);
                    if (record.type == LogRecordType.DROP_OBJECT) {
                        this.dropObjectLogRecords.add(record);
                    }
                    if (record.type == LogRecordType.DROP_DATASPACE) {
                        this.dropDataspaceLogRecords.add(record);
                    }
                    if (record.type != LogRecordType.UNLINK) continue;
                    this.unlinkLogRecords.add(record);
                }
            }
            catch (FileNotFoundException error) {
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException error) {
                        Trace.logError(this, error.getMessage());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexLogRecord(LogRecordType type, int size, int dataspaceId, int objectId, Session session) {
        if (this.corrupted) {
            return;
        }
        this.buffer[0] = (byte)type.getId();
        this.writeInt(size, 1);
        this.writeInt(dataspaceId, 5);
        this.writeInt(objectId, 9);
        this.writeLong(session.getId(), 13);
        try {
            FileOutputStream fileOutputStream = this.indexFile;
            synchronized (fileOutputStream) {
                if (this.indexFile != null) {
                    this.indexFile.write(this.buffer);
                }
            }
        }
        catch (IOException error) {
            throw new DataspaceException(error);
        }
    }

    public LogRecord readLogRecord(FileInputStream input) {
        try {
            if (input.read(this.buffer) != this.buffer.length) {
                return null;
            }
            LogRecordType type = LogRecordType.typeForId(this.buffer[0]);
            int size = this.readInt(1);
            int dataspaceId = this.readInt(5);
            int objectId = this.readInt(9);
            long sessionId = this.readLong(13);
            return new LogRecord(type, size, dataspaceId, objectId, sessionId);
        }
        catch (IOException error) {
            Trace.logError(this, error.getMessage());
            return null;
        }
    }

    public boolean isEmpty() {
        return this.logRecords == null || this.logRecords.isEmpty();
    }

    public Iterator<LogRecord> getIterator() {
        return this.logRecords.iterator();
    }

    public void writeShort(short v, int startPos) {
        this.buffer[startPos] = (byte)(v >>> 8);
        this.buffer[startPos + 1] = (byte)v;
    }

    public void writeInt(int v, int startPos) {
        this.buffer[startPos] = (byte)(v >>> 24);
        this.buffer[startPos + 1] = (byte)(v >>> 16);
        this.buffer[startPos + 2] = (byte)(v >>> 8);
        this.buffer[startPos + 3] = (byte)v;
    }

    public void writeLong(long v, int pos) {
        this.writeInt((int)(v >>> 32), pos);
        this.writeInt((int)v, pos + 4);
    }

    public short readShort(int pos) throws IOException {
        int ch1 = this.buffer[pos] & 0xFF;
        int ch2 = this.buffer[pos + 1] & 0xFF;
        return (short)((ch1 << 8) + ch2);
    }

    public int readInt(int pos) throws IOException {
        int ch1 = this.buffer[pos] & 0xFF;
        int ch2 = this.buffer[pos + 1] & 0xFF;
        int ch3 = this.buffer[pos + 2] & 0xFF;
        int ch4 = this.buffer[pos + 3] & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    public long readLong(int pos) throws IOException {
        return ((long)this.readInt(pos) << 32) + ((long)this.readInt(pos + 4) & 0xFFFFFFFFL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        if (this.indexFile != null) {
            FileOutputStream fileOutputStream = this.indexFile;
            synchronized (fileOutputStream) {
                try {
                    this.indexFile.flush();
                    this.indexFile.getFD().sync();
                }
                catch (IOException e) {
                    Trace.logInfo(this, "WARNING: Recovery log index sync error. " + e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.indexFile != null) {
            FileOutputStream fileOutputStream = this.indexFile;
            synchronized (fileOutputStream) {
                this.sync();
                try {
                    this.indexFile.close();
                    this.indexFile = null;
                }
                catch (Exception error) {
                    throw new DataspaceException(error);
                }
            }
        }
        if (this.logRecords != null) {
            this.logRecords.clear();
            this.logRecords = null;
        }
        if (this.dropObjectLogRecords != null) {
            this.dropObjectLogRecords.clear();
            this.dropObjectLogRecords = null;
        }
        if (this.dropDataspaceLogRecords != null) {
            this.dropDataspaceLogRecords.clear();
            this.dropDataspaceLogRecords = null;
        }
        if (this.unlinkLogRecords != null) {
            this.unlinkLogRecords.clear();
            this.unlinkLogRecords = null;
        }
        this.logRecordsSize = 0L;
    }

    public String getFileName() {
        return this.indexFileName;
    }
}

