/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.Trace;
import com.streamscape.ds.CheckpointManager;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.DataspaceStoreState;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.scriptio.ScriptReaderBase;
import com.streamscape.ds.io.scriptio.ScriptReaderDecode;
import com.streamscape.ds.io.scriptio.ScriptReaderText;
import com.streamscape.ds.io.scriptio.ScriptWriterBase;
import com.streamscape.ds.io.scriptio.ScriptWriterEncode;
import com.streamscape.ds.io.scriptio.ScriptWriterText;
import com.streamscape.ds.lib.FileAccess;
import com.streamscape.ds.lib.FileUtil;
import com.streamscape.ds.lib.HsqlByteArrayOutputStream;
import com.streamscape.ds.lib.HsqlTimer;
import com.streamscape.ds.persist.Crypto;
import com.streamscape.ds.persist.DataFileCache;
import com.streamscape.ds.persist.DataspaceStoreProperties;
import com.streamscape.ds.persist.LogFileIndex;
import com.streamscape.ds.persist.LogIndexesAnalyzer;
import com.streamscape.ds.persist.ScriptRunner;
import com.streamscape.ds.persist.StoreFilesState;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.sequence.NumberSequence;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;

public class Log
implements Runnable {
    private DataspaceStoreProperties properties;
    private String fileName;
    private DataspaceStore store;
    private FileAccess fa;
    ScriptWriterBase dbLogWriter;
    String logFileName;
    String recoveryLogFileName;
    private boolean filesReadOnly;
    private int writeDelay;
    private DataFileCache cache;
    HsqlByteArrayOutputStream tempBuffer = new HsqlByteArrayOutputStream();
    LogFileIndex recoveryLogIndex;
    ReentrantLock backupLock = new ReentrantLock();
    CountDownLatch backupNotify = null;
    private Object timerTask;
    private int recoveryLogSize;

    Log(DataspaceStore store) {
        this.store = store;
        this.fa = store.dataspaceLogger.getFileAccess();
        this.fileName = store.getPath();
        this.properties = store.getDataspaceStoreProperties();
    }

    void initParams() {
        this.writeDelay = this.store.dataspaceLogger.propWriteDelay;
        this.filesReadOnly = this.store.isFilesReadOnly();
        this.logFileName = this.fileName + ".log";
        this.recoveryLogFileName = this.fileName + ".rcv";
    }

    void open() {
        this.initParams();
        LogFileIndex logIndex = new LogFileIndex(this.logFileName + ".idx", this.fa);
        this.recoveryLogIndex = new LogFileIndex(this.recoveryLogFileName + ".idx", this.fa);
        logIndex.read();
        this.recoveryLogIndex.read();
        LogIndexesAnalyzer.analyse(logIndex, this.recoveryLogIndex);
        this.openRecoveryLog(true);
        StoreFilesState state = this.store.getDBModified();
        switch (state) {
            case NOT_MODIFIED_NEW: {
                DataspaceStoreState.ONLINE.name();
                break;
            }
            case MODIFIED: {
                this.deleteNewAndOldFiles();
                this.deleteOldTempFiles();
                this.processLog(logIndex);
                this.processRecoveryLog();
                this.store.dataspaceLogger.relinkRecoveryLogTable();
                this.checkpoint();
                break;
            }
            case MODIFIED_NEW: {
                this.renameNewDataFile();
                this.renameNewBackup();
                this.renameNewLog();
                this.deleteRecoveryLog();
                this.store.setDBModified(StoreFilesState.NOT_MODIFIED);
            }
            case NOT_MODIFIED: {
                this.processLog(logIndex);
                if (!this.filesReadOnly && this.isAnyCacheModified()) {
                    this.store.setDBModified(StoreFilesState.MODIFIED);
                    this.checkpoint();
                }
                this.store.dataspaceLogger.relinkRecoveryLogTable();
            }
        }
        if (!this.filesReadOnly) {
            this.store.setDBModified(StoreFilesState.MODIFIED);
        }
        logIndex = null;
    }

    void openRecoveryLogIndex(boolean append) {
        try {
            this.recoveryLogIndex.openForWrite(append);
        }
        catch (Exception error) {
            Trace.logError(this, "Unable to open recovery log file index. " + error.getMessage());
        }
    }

    void shutdown() {
        if (this.cache != null) {
            this.cache.close(false);
        }
        this.store.dataspaceLogger.closeAllTextCaches(false);
        this.closeRecoveryLog();
    }

    void deleteNewAndOldFiles() {
        this.deleteOldDataFiles();
        this.fa.removeElement(this.fileName + ".dat.new");
        this.fa.removeElement(this.fileName + ".tmp.new");
        this.fa.removeElement(this.fileName + ".backup.new");
        this.fa.removeElement(this.logFileName + ".new");
        this.fa.removeElement(this.logFileName + ".tmp");
    }

    void deleteBackup() {
        this.fa.removeElement(this.fileName + ".backup");
    }

    void deleteData() {
        this.fa.removeElement(this.fileName + ".dat");
    }

    void renameNewDataFile() {
        if (this.fa.isStreamElement(this.fileName + ".dat.new")) {
            this.fa.renameElement(this.fileName + ".dat.new", this.fileName + ".dat");
        }
    }

    void renameNewBackup() {
        this.fa.removeElement(this.fileName + ".backup");
        if (this.fa.isStreamElement(this.fileName + ".backup.new")) {
            this.fa.renameElement(this.fileName + ".backup.new", this.fileName + ".backup");
        }
    }

    void renameNewLog() {
        if (this.fa.isStreamElement(this.logFileName + ".new")) {
            this.fa.renameElement(this.logFileName + ".new", this.logFileName);
        }
        if (this.fa.isStreamElement(this.logFileName + ".idx.v")) {
            this.fa.renameElement(this.logFileName + ".idx.v", this.logFileName + ".idx");
        }
    }

    void deleteNewLog() {
        this.fa.removeElement(this.logFileName + ".tmp");
        this.fa.removeElement(this.logFileName + ".new");
        this.fa.removeElement(this.logFileName + ".idx.v");
    }

    void deleteNewBackup() {
        this.fa.removeElement(this.fileName + ".backup.new");
    }

    void deleteRecoveryLog() {
        this.fa.removeElement(this.recoveryLogFileName);
        this.deleteFile(this.recoveryLogIndex.getFileName());
    }

    boolean isAnyCacheModified() {
        if (this.cache != null && this.cache.isModified()) {
            return true;
        }
        return this.store.dataspaceLogger.isAnyTextCacheModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Result checkpoint() {
        Result result = null;
        try {
            if (this.store.isRecoveryFailed()) {
                Trace.logError(this, "Dataspace Store is in RECOVERY FAILED state. Checkpoint cancelled.");
                Result result2 = Result.newErrorResult(new DataspaceException("Dataspace Store is in RECOVERY FAILED state. Checkpoint cancelled."));
                return result2;
            }
            if (this.filesReadOnly) {
                Result result3 = Result.newErrorResult(new DataspaceException("Files are read-only. Checkpoint cancelled."));
                return result3;
            }
            result = this.checkpointClose();
        }
        finally {
            if (this.backupNotify != null) {
                this.backupNotify.countDown();
                this.backupNotify = null;
            }
        }
        if (!result.isError()) {
            this.backupLock.lock();
            try {
                this.checkpointReopen();
            }
            finally {
                this.backupLock.unlock();
            }
        } else {
            this.store.dataspaceLogger.logSevereEvent("checkpoint failed - see previous error", null);
        }
        return result;
    }

    CountDownLatch lock() {
        if (this.backupLock.isLocked()) {
            return null;
        }
        this.backupLock.lock();
        this.backupNotify = new CountDownLatch(1);
        return this.backupNotify;
    }

    void unlock() {
        if (this.backupLock.isLocked()) {
            if (this.backupNotify != null) {
                this.backupNotify.countDown();
            }
            this.backupLock.unlock();
        }
    }

    Result checkpoint(boolean defrag, CheckpointManager.CheckpointStats.CheckpointAttempt checkpointAttempt) {
        if (this.filesReadOnly) {
            return Result.updateNoResult;
        }
        if (this.cache == null) {
            defrag = false;
            checkpointAttempt.setForcedDefrag(false);
        } else if (this.forceDefrag()) {
            Trace.logInfo(CheckpointManager.class, "Forced defrag is enabled!");
            checkpointAttempt.setForcedDefrag(true);
            defrag = true;
        }
        Result result = null;
        if (defrag) {
            try {
                this.defrag();
                this.store.collectionSessionManager.resetLoggedSchemas();
                result = Result.updateNoResult;
            }
            catch (Throwable exception) {
                this.store.dataspaceLogger.logSevereEvent("defrag failed", exception);
                Trace.logException(this, exception, true);
                result = Result.newErrorResult(exception);
            }
        }
        if (!defrag || result != null) {
            Result result1 = this.checkpoint();
            if (result == null || !result.isError()) {
                result = result1;
            }
        }
        return result;
    }

    Result checkpointClose() {
        if (this.filesReadOnly) {
            return Result.updateNoResult;
        }
        this.store.dataspaceLogger.logInfoEvent("checkpointClose start");
        this.synchLog();
        this.store.lobManager.synch();
        this.store.flobManager.synch();
        if (!this.store.txManager.isMVCC()) {
            this.store.lobManager.deleteUnusedLobs();
            this.store.flobManager.deleteUnusedFlobs();
        }
        this.deleteOldDataFiles();
        try {
            this.writeLog(false);
        }
        catch (Throwable e) {
            this.deleteNewLog();
            Trace.logException(this, e, true);
            this.store.dataspaceLogger.logSevereEvent("checkpoint failed - recovered", e);
            return Result.newErrorResult(e);
        }
        try {
            if (this.cache != null) {
                this.cache.commitChanges();
                this.cache.backupFile(false);
            }
        }
        catch (Throwable ee) {
            this.deleteNewLog();
            this.deleteNewBackup();
            try {
                if (!this.cache.isFileOpen()) {
                    this.cache.open(false);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.store.dataspaceLogger.logSevereEvent("checkpoint failed - recovered", ee);
            return Result.newErrorResult(ee);
        }
        this.closeRecoveryLog();
        this.properties.setProperty("dtspace.script_format", this.store.dataspaceLogger.propScriptFormat);
        this.store.setDBModified(StoreFilesState.MODIFIED_NEW);
        this.deleteRecoveryLog();
        this.renameNewLog();
        this.renameNewBackup();
        try {
            this.store.setDBModified(StoreFilesState.NOT_MODIFIED);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.store.dataspaceLogger.logInfoEvent("checkpointClose end");
        return Result.updateNoResult;
    }

    boolean checkpointReopen() {
        if (this.filesReadOnly) {
            return true;
        }
        this.store.collectionSessionManager.resetLoggedSchemas();
        try {
            if (this.cache != null) {
                this.cache.openShadowFile();
            }
            if (this.dbLogWriter != null) {
                this.openRecoveryLog(this.store.isRecoveryFailed());
            }
            this.store.setDBModified(StoreFilesState.MODIFIED);
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    public void defrag() {
        if (this.cache.fileFreePosition == (long)this.cache.initialFreePos) {
            return;
        }
        this.store.dataspaceLogger.logInfoEvent("defrag start");
        Trace.logInfo(CheckpointManager.class, "defrag start");
        try {
            this.synchLog();
            this.store.lobManager.synch();
            this.store.flobManager.synch();
            this.deleteOldDataFiles();
            this.cache.defrag();
        }
        catch (DataspaceException e) {
            throw e;
        }
        catch (Throwable e) {
            this.store.dataspaceLogger.logSevereEvent("defrag failure", e);
            throw Error.error(466, e);
        }
        this.store.dataspaceLogger.logInfoEvent("defrag end");
        Trace.logInfo(CheckpointManager.class, "defrag end");
    }

    boolean forceDefrag() {
        long limit = (long)this.store.dataspaceLogger.propCacheDefragLimit * this.cache.getFileFreePos() / 100L;
        long lostSize = this.cache.freeBlocks.getLostBlocksSize();
        return limit > 0L && lostSize > limit;
    }

    void deleteFile(String fileName) {
        this.fa.removeElement(fileName);
        if (this.fa.isStreamElement(fileName)) {
            this.fa.removeElement(fileName);
            if (this.fa.isStreamElement(fileName)) {
                String discardName = FileUtil.newDiscardFileName(fileName);
                this.fa.renameElement(fileName, discardName);
            }
        }
    }

    boolean hasCache() {
        return this.cache != null;
    }

    DataFileCache getCache() {
        if (this.cache == null) {
            this.cache = new DataFileCache(this.store);
            this.cache.init(this.fileName);
            this.cache.open(this.filesReadOnly);
        }
        return this.cache;
    }

    int getWriteDelay() {
        return this.writeDelay;
    }

    void setWriteDelay(int delay) {
        this.stopSyncTimer();
        this.writeDelay = delay;
        if (this.dbLogWriter != null && this.dbLogWriter.getWriteDelay() != delay) {
            this.dbLogWriter.forceSync();
            this.dbLogWriter.setWriteDelay(delay);
        }
        this.startSyncTimer();
    }

    public void setIncrementBackup(boolean val) {
        if (this.cache != null) {
            this.cache.setIncrementBackup(val);
        }
    }

    void writeOtherStatement(Session session, String s) {
        try {
            this.dbLogWriter.writeOtherStatement(session, s);
        }
        catch (IOException e) {
            throw Error.error(452, this.recoveryLogFileName);
        }
        this.checkCheckpointRequired();
    }

    void writeInsertStatement(Session session, Row row, Table t) {
        try {
            this.dbLogWriter.writeInsertStatement(session, row, t);
        }
        catch (IOException e) {
            throw Error.error(452, this.recoveryLogFileName);
        }
        this.checkCheckpointRequired();
    }

    void writeDeleteStatement(Session session, Table t, Object[] row) {
        try {
            this.dbLogWriter.writeDeleteStatement(session, t, row);
        }
        catch (IOException e) {
            throw Error.error(452, this.recoveryLogFileName);
        }
        this.checkCheckpointRequired();
    }

    void writeSequenceStatement(Session session, NumberSequence s) {
        try {
            this.dbLogWriter.writeSequenceStatement(session, s);
        }
        catch (IOException e) {
            throw Error.error(452, this.recoveryLogFileName);
        }
        this.checkCheckpointRequired();
    }

    void writeCommitStatement(Session session) {
        try {
            this.dbLogWriter.writeCommitStatement(session);
        }
        catch (IOException e) {
            throw Error.error(452, this.recoveryLogFileName);
        }
        this.checkCheckpointRequired();
    }

    void writePrepareCommitStatement(Session session) {
        try {
            this.dbLogWriter.writePrepareCommitStatement(session);
        }
        catch (IOException e) {
            throw Error.error(452, this.recoveryLogFileName);
        }
    }

    void writeSessionIdAndSchema(Session session) {
        try {
            this.dbLogWriter.writeSessionIdAndSchema(session);
        }
        catch (IOException e) {
            throw Error.error(452, this.recoveryLogFileName);
        }
        this.checkCheckpointRequired();
    }

    void writeSessionIdAndSchema(Session session, NameManager.ObjectName schemaName) {
        try {
            this.dbLogWriter.writeSessionIdAndSchema(session, schemaName);
        }
        catch (IOException e) {
            throw Error.error(452, this.recoveryLogFileName);
        }
        this.checkCheckpointRequired();
    }

    void writeSessionIdWithoutChecks(Session session, NameManager.ObjectName schemaName) {
        try {
            this.dbLogWriter.writeSessionIdWithoutChecks(session, schemaName);
        }
        catch (IOException e) {
            throw Error.error(452, this.recoveryLogFileName);
        }
        this.checkCheckpointRequired();
    }

    private void checkCheckpointRequired() {
        if (this.store.checkpointManager != null && this.store.checkpointManager.getLogSizeMax() > 0L && this.dbLogWriter.size() > this.store.checkpointManager.getLogSizeMax()) {
            this.store.dataspaceLogger.setCheckpointRequired();
        }
    }

    void synchLog() {
        if (this.dbLogWriter != null) {
            this.dbLogWriter.forceSync();
        }
    }

    void openRecoveryLog(boolean isSuspect) {
        if (this.filesReadOnly) {
            return;
        }
        Crypto crypto = this.store.dataspaceLogger.getCrypto();
        try {
            this.dbLogWriter = crypto == null ? new ScriptWriterText(this.store, this.recoveryLogFileName, false, false, false, isSuspect) : new ScriptWriterEncode(this.store, this.recoveryLogFileName, crypto, isSuspect);
            this.openRecoveryLogIndex(isSuspect);
            this.dbLogWriter.setWriteDelay(this.writeDelay);
            this.startSyncTimer();
        }
        catch (Throwable e) {
            throw Error.error(452, this.recoveryLogFileName);
        }
    }

    synchronized void closeRecoveryLog() {
        this.stopSyncTimer();
        if (this.dbLogWriter != null) {
            this.dbLogWriter.sync();
            this.dbLogWriter.close();
        }
        if (this.recoveryLogIndex != null) {
            this.recoveryLogIndex.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeLog(boolean full) {
        this.store.generateLogIndex = true;
        this.store.logIndexBuilder = new HashMap<Integer, DataspaceStore.DDLRecordNode>();
        this.deleteNewLog();
        ScriptWriterBase scw = null;
        Crypto crypto = this.store.dataspaceLogger.getCrypto();
        LogFileIndex logIndex = new LogFileIndex(this.logFileName + ".idx.v", this.fa);
        logIndex.openForWrite(false);
        try {
            if (crypto == null) {
                boolean compressed = this.store.dataspaceLogger.propScriptFormat.equals("COMPRESSED");
                scw = new ScriptWriterText(this.store, this.logFileName + ".tmp", full, compressed, false);
            } else {
                scw = new ScriptWriterEncode(this.store, this.logFileName + ".tmp", full, crypto);
            }
            scw.setForLog();
            scw.writeAll(logIndex);
        }
        finally {
            if (scw != null) {
                scw.close();
            }
        }
        if (this.fa.isStreamElement(this.logFileName + ".tmp")) {
            this.fa.renameElement(this.logFileName + ".tmp", this.logFileName + ".new");
        }
        logIndex.close();
        logIndex = null;
        scw = null;
        this.store.logIndexBuilder.clear();
        this.store.logIndexBuilder = null;
        this.store.generateLogIndex = false;
    }

    private void processLog(LogFileIndex logIndex) {
        Trace.logInfo(this, "Processing Dataspace Log...");
        ScriptReaderBase scr = null;
        try (Session session = null;){
            Crypto crypto = this.store.dataspaceLogger.getCrypto();
            if (crypto == null) {
                boolean compressed = this.store.dataspaceLogger.propScriptFormat.equals("COMPRESSED");
                scr = new ScriptReaderText(this.store, this.logFileName, compressed);
            } else {
                scr = new ScriptReaderDecode(this.store, this.logFileName, crypto, false);
            }
            scr.setForLog();
            session = this.store.collectionSessionManager.getSysSessionForScript(this.store);
            if (logIndex != null && !logIndex.isEmpty()) {
                scr.setIndex(logIndex);
            }
            scr.readAll(session);
            scr.close();
            Trace.logInfo(this, "Dataspace Log processed.");
        }
    }

    private void processRecoveryLog() {
        if (this.fa.isStreamElement(this.recoveryLogFileName)) {
            ScriptRunner.runRecoveryLog(this.store, this.recoveryLogFileName, this.recoveryLogIndex.isEmpty() ? null : this.recoveryLogIndex);
        }
    }

    void deleteOldDataFiles() {
        if (this.store.dataspaceLogger.isStoredFileAccess()) {
            return;
        }
        try {
            File file = new File(this.store.getCanonicalPath());
            File[] list = file.getParentFile().listFiles();
            for (int i = 0; i < list.length; ++i) {
                if (!list[i].getName().startsWith(file.getName()) || !list[i].getName().endsWith(".dat.v")) continue;
                list[i].delete();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void deleteOldTempFiles() {
        try {
            if (this.store.dataspaceLogger.tempDirectoryPath == null) {
                return;
            }
            File file = new File(this.store.dataspaceLogger.tempDirectoryPath);
            File[] list = file.listFiles();
            for (int i = 0; i < list.length; ++i) {
                list[i].delete();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void deleteTempFileDirectory() {
        try {
            if (this.store.dataspaceLogger.tempDirectoryPath == null) {
                return;
            }
            File file = new File(this.store.dataspaceLogger.tempDirectoryPath);
            file.delete();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getRecoveryLogFileName() {
        return this.recoveryLogFileName;
    }

    @Override
    public void run() {
        if (this.writeDelay != 0) {
            try {
                this.dbLogWriter.sync();
                this.recoveryLogIndex.sync();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void startSyncTimer() {
        if (this.writeDelay > 0) {
            this.timerTask = DataspaceStoreManager.getTimer().schedulePeriodicallyAfter(0L, this.writeDelay, this, false);
        }
    }

    public void stopSyncTimer() {
        if (this.timerTask != null) {
            HsqlTimer.cancel(this.timerTask);
            this.timerTask = null;
        }
    }

    public long getRecoveryLogSize() {
        ScriptWriterBase dbLogWriterLocal = this.dbLogWriter;
        if (dbLogWriterLocal != null) {
            return dbLogWriterLocal.size();
        }
        return 0L;
    }

    public long getLogSize() {
        try {
            return new File(this.logFileName).length();
        }
        catch (Exception exception) {
            Trace.logError(this, "Failed to get log file size: " + exception.toString());
            return 0L;
        }
    }
}

