/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.DataspaceSchema;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.FlobData;
import com.streamscape.ds.types.LobData;
import com.streamscape.ds.types.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class LobValidator {
    private DataspaceStore dataspaceStore;
    private Session session;
    private Runnable sessionLock;
    private Runnable sessionUnlock;
    private Supplier<List<Long>> allIdsProvider;
    private Predicate<Type> typePredicate;
    private Function<LobData, LobData> oneLobValidator;

    public LobValidator(DataspaceStore dataspaceStore, Session session, Runnable sessionLock, Runnable sessionUnlock, Supplier<List<Long>> allIdsProvider, Predicate<Type> typePredicate, Function<LobData, LobData> oneLobValidator) {
        this.dataspaceStore = dataspaceStore;
        this.session = session;
        this.sessionLock = sessionLock;
        this.sessionUnlock = sessionUnlock;
        this.allIdsProvider = allIdsProvider;
        this.typePredicate = typePredicate;
        this.oneLobValidator = oneLobValidator;
    }

    public InvalidLobs checkAllLobs(boolean withInvalidRows) {
        List<Long> lobIds = this.allIdsProvider.get();
        ArrayList<InvalidTable> invalidTables = new ArrayList<InvalidTable>();
        for (String schemaName : this.dataspaceStore.schemaManager.getSchemaNamesArray()) {
            invalidTables.addAll(this.checkAllLobs(schemaName, null, null, lobIds, withInvalidRows).getInvalidTables());
        }
        return new InvalidLobs(invalidTables, lobIds);
    }

    public InvalidLobs checkAllLobs(String schemaName, String tableName, String column, List<Long> allLobIds, boolean withInvalidRows) {
        ArrayList<InvalidTable> invalidTables = new ArrayList<InvalidTable>();
        DataspaceSchema schema = this.dataspaceStore.schemaManager.findSchema(schemaName);
        if (schema == null) {
            throw new DataspaceException("Schema '" + schemaName + "' doesn't exist.");
        }
        if (tableName != null) {
            InvalidTable invalidTable;
            Table table = this.session.dataspaceStore.schemaManager.getTable(this.session, tableName, schemaName);
            HashSet<String> columns = null;
            if (column != null) {
                columns = new HashSet<String>();
                columns.add(column);
            }
            if ((invalidTable = this.checkTableLobs(table, columns, allLobIds, withInvalidRows)) != null) {
                invalidTables.add(invalidTable);
            }
        } else {
            for (int i = 0; i < schema.getTables().size(); ++i) {
                Table table = (Table)schema.getTables().get(i);
                InvalidTable invalidTable = this.checkTableLobs(table, null, allLobIds, withInvalidRows);
                if (invalidTable == null) continue;
                invalidTables.add(invalidTable);
            }
        }
        return new InvalidLobs(invalidTables, null);
    }

    public InvalidTable checkTableLobs(Table table, Set<String> columns, final List<Long> allLobIds, final boolean withInvalidRows) {
        final InvalidTable invalidTable = new InvalidTable(table.getObjectName());
        final InvalidRow[] invalidRow = new InvalidRow[1];
        final Object[] currentRow = new Object[1];
        this.selectAllLobsFromTable(table, true, columns, new LobListener(){

            @Override
            public void onLob(LobData lobData, List<String> lobColumnNames, int index, Object[] current, int identityStart) {
                InvalidColumn invalidColumn = null;
                long lobId = lobData.getId();
                if (allLobIds != null) {
                    allLobIds.remove(lobId);
                }
                try {
                    LobValidator.this.oneLobValidator.apply(lobData);
                }
                catch (Exception exception) {
                    invalidColumn = new InvalidColumn(index, lobId, lobData, exception);
                }
                if (lobData instanceof FlobData && !LobValidator.this.dataspaceStore.flobManager.getFlobFileManager().isFlobLocationExists(((FlobData)lobData).getLocation())) {
                    invalidTable.addInvalidLocation(((FlobData)lobData).getLocation());
                }
                if (invalidColumn != null) {
                    invalidTable.incrementInvalidLobsCount();
                    invalidTable.addInvalidColumnName(lobColumnNames.get(index));
                    if (invalidColumn.getException() instanceof DataspaceException && ((DataspaceException)invalidColumn.getException()).getErrorCode() == 3476) {
                        invalidTable.incrementBrokenLobs();
                    }
                    if (currentRow[0] != current) {
                        invalidTable.incrementInvalidRowsCount();
                    }
                    if (withInvalidRows) {
                        if (currentRow[0] != current) {
                            ArrayList<Object> identity = new ArrayList<Object>(current.length - identityStart);
                            for (int j = 0; j < current.length - identityStart; ++j) {
                                identity.add(current[identityStart + j]);
                            }
                            invalidRow[0] = new InvalidRow(identity);
                            if (invalidTable.getColumnNames() == null || invalidTable.getColumnNames().size() == 0) {
                                invalidTable.setColumnNames(lobColumnNames);
                            }
                            invalidTable.addInvalidRow(invalidRow[0]);
                        }
                        invalidRow[0].addInvalidColumn(invalidColumn);
                    }
                    currentRow[0] = current;
                }
            }
        });
        return invalidTable.getInvalidLobsCount() > 0L ? invalidTable : null;
    }

    public FlobValidationPerColumnAndLocationResult validateFlobsForTable(Table table, Set<String> columns) {
        final FlobValidationPerColumnAndLocationResult result = new FlobValidationPerColumnAndLocationResult();
        this.selectAllLobsFromTable(table, true, columns, new LobListener(){

            @Override
            public void onLob(LobData lobData, List<String> lobColumnNames, int index, Object[] current, int identityStart) {
                boolean valid = true;
                try {
                    LobValidator.this.oneLobValidator.apply(lobData);
                }
                catch (Exception exception) {
                    valid = false;
                }
                result.addLob(lobColumnNames.get(0), ((FlobData)lobData).getLocation(), valid);
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectAllLobsFromTable(Table table, boolean withIdentity, Set<String> columns, LobListener listener) {
        ArrayList<String> indentityColumns = new ArrayList<String>();
        ArrayList<String> primaryKeyColumns = new ArrayList<String>();
        ArrayList<String> lobColumns = new ArrayList<String>();
        for (int i = 0; i < table.getColumnCount(); ++i) {
            ColumnSchema column = table.getColumn(i);
            if (this.typePredicate.test(column.getDataType()) && (columns == null || columns.size() == 0 || columns.contains(column.getNameString()))) {
                lobColumns.add(column.getNameString());
            }
            if (column.isIdentity()) {
                indentityColumns.add(column.getNameString());
            }
            if (!column.isPrimaryKey()) continue;
            primaryKeyColumns.add(column.getNameString());
        }
        if (lobColumns.size() > 0) {
            StringBuilder builder = new StringBuilder();
            builder.append("select ");
            lobColumns.forEach(n -> builder.append("[").append((String)n).append("]").append(","));
            if (withIdentity) {
                if (primaryKeyColumns.size() > 0) {
                    primaryKeyColumns.forEach(n -> builder.append((String)n).append(","));
                } else if (indentityColumns.size() > 0) {
                    indentityColumns.forEach(n -> builder.append((String)n).append(","));
                }
            }
            builder.deleteCharAt(builder.length() - 1);
            builder.append(" from ").append(table.getObjectName().getSchemaQualifiedStatementName());
            builder.append(" where ");
            lobColumns.forEach(n -> builder.append("[").append((String)n).append("]").append(" != null or "));
            builder.delete(builder.length() - 3, builder.length());
            this.sessionLock.run();
            try {
                Statement statement = this.session.compileStatement(builder.toString());
                Result result = this.session.executeCompiledStatement(statement, new Object[0]);
                RowSetNavigator navigator = result.getNavigator();
                while (navigator != null && navigator.next()) {
                    for (int i = 0; i < lobColumns.size(); ++i) {
                        LobData llobData = (LobData)navigator.getCurrent()[i];
                        if (llobData == null) continue;
                        listener.onLob(llobData, lobColumns, i, navigator.getCurrent(), lobColumns.size());
                    }
                }
            }
            finally {
                this.sessionUnlock.run();
            }
        }
    }

    public static class InvalidLobs {
        private List<InvalidTable> invalidTables;
        private List<Long> unreferncedLobs;

        public InvalidLobs(List<InvalidTable> invalidTables, List<Long> unreferncedLobs) {
            this.invalidTables = invalidTables;
            this.unreferncedLobs = unreferncedLobs;
        }

        public List<InvalidTable> getInvalidTables() {
            return this.invalidTables;
        }

        public List<Long> getUnreferencedLobs() {
            return this.unreferncedLobs;
        }
    }

    public static class InvalidTable {
        private NameManager.ObjectName objectName;
        private long invalidRowsCount;
        private long invalidLobsCount;
        private long brokenLobsCount;
        private Set<String> invalidColumnNames = new HashSet<String>();
        private Set<String> invalidLocations = new HashSet<String>();
        private List<InvalidRow> invalidRows = new ArrayList<InvalidRow>();
        private List<String> columnNames = new ArrayList<String>();

        public InvalidTable(NameManager.ObjectName objectName) {
            this.objectName = objectName;
        }

        public NameManager.ObjectName getObjectName() {
            return this.objectName;
        }

        public void addInvalidRow(InvalidRow invalidRow) {
            this.invalidRows.add(invalidRow);
        }

        public void setColumnNames(List<String> columnNames) {
            this.columnNames = columnNames;
        }

        public List<InvalidRow> getInvalidRows() {
            return this.invalidRows;
        }

        public List<String> getColumnNames() {
            return this.columnNames;
        }

        public void incrementInvalidRowsCount() {
            ++this.invalidRowsCount;
        }

        public void incrementInvalidLobsCount() {
            ++this.invalidLobsCount;
        }

        public void incrementBrokenLobs() {
            ++this.brokenLobsCount;
        }

        public long getInvalidRowsCount() {
            return this.invalidRowsCount;
        }

        public long getInvalidLobsCount() {
            return this.invalidLobsCount;
        }

        public long getBrokenLobsCount() {
            return this.brokenLobsCount;
        }

        public void addInvalidColumnName(String invalidColumnName) {
            this.invalidColumnNames.add(invalidColumnName);
        }

        public Set<String> getInvalidColumnNames() {
            return this.invalidColumnNames;
        }

        public void addInvalidLocation(String invalidLocation) {
            this.invalidLocations.add(invalidLocation);
        }

        public Set<String> getInvalidLocations() {
            return this.invalidLocations;
        }
    }

    public static class InvalidRow {
        private List<Object> identity;
        private List<InvalidColumn> invalidColumns = new ArrayList<InvalidColumn>();

        public InvalidRow(List<Object> identity) {
            this.identity = identity;
        }

        public List<Object> getIdentity() {
            return this.identity;
        }

        public void addInvalidColumn(InvalidColumn invalidColumn) {
            this.invalidColumns.add(invalidColumn);
        }

        public List<InvalidColumn> getInvalidColumns() {
            return this.invalidColumns.stream().sorted((i1, i2) -> Long.compare(i1.getLobId(), i2.getLobId())).collect(Collectors.toList());
        }
    }

    public static interface LobListener {
        public void onLob(LobData var1, List<String> var2, int var3, Object[] var4, int var5);
    }

    public static class FlobValidationPerColumnAndLocationResult {
        private Map<FlobValidationPerColumnAndLocationKey, FlobValidationPerColumnAndLocationValidCount> map = new HashMap<FlobValidationPerColumnAndLocationKey, FlobValidationPerColumnAndLocationValidCount>();

        public void addLob(String columnName, String location, boolean isValid) {
            FlobValidationPerColumnAndLocationKey key = new FlobValidationPerColumnAndLocationKey(columnName, location);
            FlobValidationPerColumnAndLocationValidCount count = this.map.get(key);
            if (count == null) {
                count = new FlobValidationPerColumnAndLocationValidCount();
                this.map.put(key, count);
            }
            if (isValid) {
                ++count.validCount;
            } else {
                ++count.invalidCount;
            }
        }

        public Map<FlobValidationPerColumnAndLocationKey, FlobValidationPerColumnAndLocationValidCount> getMap() {
            return this.map;
        }
    }

    public static class FlobValidationPerColumnAndLocationValidCount {
        private long validCount = 0L;
        private long invalidCount = 0L;

        public long getValidCount() {
            return this.validCount;
        }

        public long getInvalidCount() {
            return this.invalidCount;
        }
    }

    public static class FlobValidationPerColumnAndLocationKey {
        private String column;
        private String location;

        public FlobValidationPerColumnAndLocationKey(String column, String location) {
            this.column = column;
            this.location = location;
        }

        public String getColumn() {
            return this.column;
        }

        public String getLocation() {
            return this.location;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FlobValidationPerColumnAndLocationKey)) {
                return false;
            }
            FlobValidationPerColumnAndLocationKey that = (FlobValidationPerColumnAndLocationKey)o;
            return Objects.equals(this.column, that.column) && Objects.equals(this.location, that.location);
        }

        public int hashCode() {
            return Objects.hash(this.column, this.location);
        }
    }

    public static class InvalidColumn {
        private int columnId;
        private long lobId;
        private LobData lobData;
        private Exception exception;

        public InvalidColumn(int columnId, long lobId, LobData lobData, Exception exception) {
            this.columnId = columnId;
            this.lobId = lobId;
            this.lobData = lobData;
            this.exception = exception;
        }

        public int getColumnId() {
            return this.columnId;
        }

        public long getLobId() {
            return this.lobId;
        }

        public LobData getLobData() {
            return this.lobData;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

