/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.persist.LobStore;
import com.streamscape.ds.persist.ScaledRAFile;
import com.streamscape.ds.persist.ScaledRAFileSimple;
import com.streamscape.lib.file.RandomAccessInterface;

public class LobStoreRAFile
implements LobStore {
    final int lobBlockSize;
    RandomAccessInterface file;
    DataspaceStore store;

    public LobStoreRAFile(DataspaceStore database, int lobBlockSize) {
        this.lobBlockSize = lobBlockSize;
        this.store = database;
        try {
            String name = database.getPath() + ".lobs";
            boolean exists = database.dataspaceLogger.getFileAccess().isStreamElement(name);
            if (exists) {
                this.openFile();
            }
        }
        catch (Throwable t) {
            throw Error.error(466, t);
        }
    }

    private void openFile() {
        try {
            String name = this.store.getPath() + ".lobs";
            boolean readonly = this.store.isReadOnly();
            this.file = this.store.dataspaceLogger.isStoredFileAccess() ? ScaledRAFile.newScaledRAFile(this.store, name, readonly, 3) : new ScaledRAFileSimple(this.store, name, readonly ? "r" : "rws");
        }
        catch (Throwable t) {
            throw Error.error(466, t);
        }
    }

    @Override
    public byte[] getBlockBytes(int blockAddress, int blockCount) {
        if (this.file == null) {
            throw Error.error(452);
        }
        try {
            long address = (long)blockAddress * (long)this.lobBlockSize;
            int count = blockCount * this.lobBlockSize;
            byte[] dataBytes = new byte[count];
            this.file.seek(address);
            this.file.read(dataBytes, 0, count);
            return dataBytes;
        }
        catch (Throwable t) {
            throw Error.error(466, t);
        }
    }

    @Override
    public void setBlockBytes(byte[] dataBytes, int blockAddress, int blockCount) {
        if (this.file == null) {
            this.openFile();
        }
        try {
            long address = (long)blockAddress * (long)this.lobBlockSize;
            int count = blockCount * this.lobBlockSize;
            this.file.seek(address);
            this.file.write(dataBytes, 0, count);
        }
        catch (Throwable t) {
            throw Error.error(466, t);
        }
    }

    @Override
    public void setBlockBytes(byte[] dataBytes, long position, int offset, int length) {
        if (length == 0) {
            return;
        }
        if (this.file == null) {
            this.openFile();
        }
        try {
            this.file.seek(position);
            this.file.write(dataBytes, offset, length);
        }
        catch (Throwable t) {
            throw Error.error(466, t);
        }
    }

    @Override
    public int getBlockSize() {
        return this.lobBlockSize;
    }

    @Override
    public void close() {
        try {
            if (this.file != null) {
                this.file.synch();
                this.file.close();
            }
        }
        catch (Throwable t) {
            throw Error.error(466, t);
        }
    }

    @Override
    public void synch() {
        if (this.file != null) {
            this.file.synch();
        }
    }
}

