/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.persist.LobStore;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class LobStoreInJar
implements LobStore {
    final int lobBlockSize;
    DataspaceStore database;
    DataInputStream file;
    final String fileName;
    long realPosition;

    public LobStoreInJar(DataspaceStore database, int lobBlockSize) {
        this.lobBlockSize = lobBlockSize;
        this.database = database;
        try {
            this.fileName = database.getPath() + ".lobs";
        }
        catch (Throwable t) {
            throw Error.error(466, t);
        }
    }

    @Override
    public byte[] getBlockBytes(int blockAddress, int blockCount) {
        if (this.file == null) {
            throw Error.error(452);
        }
        try {
            long address = (long)blockAddress * (long)this.lobBlockSize;
            int count = blockCount * this.lobBlockSize;
            byte[] dataBytes = new byte[count];
            this.fileSeek(address);
            this.file.readFully(dataBytes, 0, count);
            this.realPosition = address + (long)count;
            return dataBytes;
        }
        catch (Throwable t) {
            throw Error.error(466, t);
        }
    }

    @Override
    public void setBlockBytes(byte[] dataBytes, int blockAddress, int blockCount) {
    }

    @Override
    public void setBlockBytes(byte[] dataBytes, long position, int offset, int length) {
    }

    @Override
    public int getBlockSize() {
        return this.lobBlockSize;
    }

    @Override
    public void close() {
        try {
            if (this.file != null) {
                this.file.close();
            }
        }
        catch (Throwable t) {
            throw Error.error(466, t);
        }
    }

    private void resetStream() throws IOException {
        if (this.file != null) {
            this.file.close();
        }
        InputStream fis = null;
        try {
            ClassLoader cl;
            fis = this.getClass().getResourceAsStream(this.fileName);
            if (fis == null && (cl = Thread.currentThread().getContextClassLoader()) != null) {
                fis = cl.getResourceAsStream(this.fileName);
            }
        }
        catch (Throwable throwable) {
            if (fis == null) {
                throw new FileNotFoundException(this.fileName);
            }
        }
        finally {
            if (fis == null) {
                throw new FileNotFoundException(this.fileName);
            }
        }
        this.file = new DataInputStream(fis);
        this.realPosition = 0L;
    }

    private void fileSeek(long position) throws IOException {
        long skipPosition;
        if (this.file == null) {
            this.resetStream();
        }
        if (position < (skipPosition = this.realPosition)) {
            this.resetStream();
            skipPosition = 0L;
        }
        while (position > skipPosition) {
            skipPosition += this.file.skip(position - skipPosition);
        }
        this.realPosition = position;
    }

    @Override
    public void synch() {
    }
}

