/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.Trace;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.lib.HashMappedList;
import com.streamscape.ds.lib.LineGroupReader;
import com.streamscape.ds.lib.LongDeque;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.persist.FlobManager;
import com.streamscape.ds.persist.LobStore;
import com.streamscape.ds.persist.LobStoreMem;
import com.streamscape.ds.persist.LobStoreRAFile;
import com.streamscape.ds.persist.LobValidator;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultLob;
import com.streamscape.ds.result.ResultLobFactoryFactory;
import com.streamscape.ds.result.ResultMetaData;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.BinaryData;
import com.streamscape.ds.types.BlobData;
import com.streamscape.ds.types.BlobDataID;
import com.streamscape.ds.types.BlobType;
import com.streamscape.ds.types.ClobData;
import com.streamscape.ds.types.ClobDataID;
import com.streamscape.ds.types.ClobType;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class LobManager {
    static final String resourceFileName = "/com/streamscape/ds/resources/lob-schema.sql";
    static final String[] starters = new String[]{"/*"};
    DataspaceStore database;
    LobStore lobStore;
    Session sysLobSession;
    volatile boolean storeModified;
    byte[] byteBuffer;
    int lobBlockSize;
    int totalBlockLimitCount = Integer.MAX_VALUE;
    Statement getLob;
    Statement getLobPart;
    Statement deleteLobCall;
    Statement deleteLobPartCall;
    Statement divideLobPartCall;
    Statement createLob;
    Statement createLobPartCall;
    Statement updateLobLength;
    Statement updateLobUsage;
    Statement getNextLobId;
    Statement deleteUnusedLobs;
    Statement getLobCount;
    Statement selectAllLobIdsStm;
    boolean usageCountChanged;
    ReadWriteLock lock = new ReentrantReadWriteLock();
    Lock writeLock = this.lock.writeLock();
    private static String initialiseBlocksSQL = "INSERT INTO SYS_LOBS.BLOCKS VALUES(?,?,?)";
    private static String getLobSQL = "SELECT * FROM SYS_LOBS.LOB_IDS WHERE LOB_ID = ?";
    private static String getLobPartSQL = "SELECT * FROM SYS_LOBS.LOBS WHERE LOB_ID = ? AND BLOCK_OFFSET + BLOCK_COUNT > ? AND BLOCK_OFFSET < ? ORDER BY BLOCK_OFFSET";
    private static String deleteLobPartCallSQL = "CALL SYS_LOBS.DELETE_BLOCKS(?,?,?,?)";
    private static String createLobSQL = "INSERT INTO SYS_LOBS.LOB_IDS VALUES(?, ?, ?, ?)";
    private static String updateLobLengthSQL = "UPDATE SYS_LOBS.LOB_IDS SET LOB_LENGTH = ? WHERE LOB_ID = ?";
    private static String createLobPartCallSQL = "CALL SYS_LOBS.ALLOC_BLOCKS(?, ?, ?)";
    private static String divideLobPartCallSQL = "CALL SYS_LOBS.DIVIDE_BLOCK(?, ?)";
    private static String getSpanningBlockSQL = "SELECT * FROM SYS_LOBS.LOBS WHERE LOB_ID = ? AND ? > BLOCK_OFFSET AND ? < BLOCK_OFFSET + BLOCK_COUNT";
    private static String updateLobUsageSQL = "UPDATE SYS_LOBS.LOB_IDS SET LOB_USAGE_COUNT = (CASE LOB_USAGE_COUNT WHEN 2147483647 THEN 0 ELSE LOB_USAGE_COUNT END) + ? WHERE LOB_ID = ?";
    private static String getNextLobIdSQL = "VALUES NEXT VALUE FOR SYS_LOBS.LOB_ID";
    private static String deleteLobCallSQL = "CALL SYS_LOBS.DELETE_LOB(?, ?)";
    private static String deleteUnusedCallSQL = "CALL SYS_LOBS.DELETE_UNUSED()";
    private static String getLobCountSQL = "SELECT COUNT(*) FROM SYS_LOBS.LOB_IDS";
    private static String selectAllLobIdsSQL = "SELECT LOB_ID FROM SYS_LOBS.LOB_IDS";

    public LobManager(DataspaceStore database) {
        this.database = database;
    }

    public void lock() {
        this.writeLock.lock();
    }

    public void unlock() {
        this.writeLock.unlock();
    }

    public void createSchema() {
        this.sysLobSession = this.database.collectionSessionManager.getSysLobSession();
        InputStream fis = (InputStream)AccessController.doPrivileged(new PrivilegedAction(this){

            public InputStream run() {
                return this.getClass().getResourceAsStream(LobManager.resourceFileName);
            }
        });
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(fis, "ISO-8859-1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        LineNumberReader lineReader = new LineNumberReader(reader);
        LineGroupReader lg = new LineGroupReader(lineReader, starters);
        HashMappedList map = lg.getAsMap();
        lg.close();
        String sql = (String)map.get("/*lob_schema_definition*/");
        Statement statement = this.sysLobSession.compileStatement(sql);
        Result result = statement.execute(this.sysLobSession);
        if (result.isError()) {
            throw result.getException();
        }
        NameManager.ObjectName name = this.database.schemaManager.getSchemaHsqlName("SYS_LOBS");
        Table table = this.database.schemaManager.getTable(this.sysLobSession, "BLOCKS", "SYS_LOBS");
        this.compileStatements();
    }

    public void compileStatements() {
        this.writeLock.lock();
        try {
            this.getLob = this.sysLobSession.compileStatement(getLobSQL);
            this.getLobPart = this.sysLobSession.compileStatement(getLobPartSQL);
            this.createLob = this.sysLobSession.compileStatement(createLobSQL);
            this.createLobPartCall = this.sysLobSession.compileStatement(createLobPartCallSQL);
            this.divideLobPartCall = this.sysLobSession.compileStatement(divideLobPartCallSQL);
            this.deleteLobCall = this.sysLobSession.compileStatement(deleteLobCallSQL);
            this.deleteLobPartCall = this.sysLobSession.compileStatement(deleteLobPartCallSQL);
            this.updateLobLength = this.sysLobSession.compileStatement(updateLobLengthSQL);
            this.updateLobUsage = this.sysLobSession.compileStatement(updateLobUsageSQL);
            this.getNextLobId = this.sysLobSession.compileStatement(getNextLobIdSQL);
            this.deleteUnusedLobs = this.sysLobSession.compileStatement(deleteUnusedCallSQL);
            this.getLobCount = this.sysLobSession.compileStatement(getLobCountSQL);
            this.selectAllLobIdsStm = this.sysLobSession.compileStatement(selectAllLobIdsSQL);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void initialiseLobSpace() {
        Statement statement = this.sysLobSession.compileStatement(initialiseBlocksSQL);
        Object[] params = new Object[]{ValuePool.INTEGER_0, ValuePool.getInt(this.totalBlockLimitCount), ValuePool.getLong(0L)};
        this.sysLobSession.executeCompiledStatement(statement, params);
    }

    public void open() {
        this.lobBlockSize = this.database.dataspaceLogger.getLobBlockSize();
        if (this.database.dataspaceLogger.isLobInMem()) {
            this.lobStore = new LobStoreMem(this.lobBlockSize);
            this.byteBuffer = new byte[this.lobBlockSize];
        } else if (this.database.getModel().equals("file://")) {
            this.lobStore = new LobStoreRAFile(this.database, this.lobBlockSize);
            this.byteBuffer = new byte[this.lobBlockSize];
        } else {
            this.lobStore = new LobStoreMem(this.lobBlockSize);
            this.byteBuffer = new byte[this.lobBlockSize];
        }
    }

    public void close() {
        this.lobStore.close();
    }

    public LobStore getLobStore() {
        if (this.lobStore == null) {
            this.open();
        }
        return this.lobStore;
    }

    private long getNewLobID() {
        Result result = this.getNextLobId.execute(this.sysLobSession);
        if (result.isError()) {
            return 0L;
        }
        RowSetNavigator navigator = result.getNavigator();
        boolean next = navigator.next();
        if (!next) {
            navigator.release();
            return 0L;
        }
        Object[] data = navigator.getCurrent();
        return (Long)data[0];
    }

    private Object[] getLobHeader(long lobID) {
        ResultMetaData meta = this.getLob.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = ValuePool.getLong(lobID);
        this.sysLobSession.sessionContext.pushDynamicArguments(params);
        Result result = this.getLob.execute(this.sysLobSession);
        this.sysLobSession.sessionContext.pop();
        if (result.isError()) {
            return null;
        }
        RowSetNavigator navigator = result.getNavigator();
        boolean next = navigator.next();
        if (!next) {
            navigator.release();
            return null;
        }
        Object[] data = navigator.getCurrent();
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlobData getBlob(long lobID) {
        this.writeLock.lock();
        try {
            BlobDataID blob;
            Object[] data = this.getLobHeader(lobID);
            if (data == null) {
                BlobData blobData = null;
                return blobData;
            }
            BlobDataID blobDataID = blob = new BlobDataID(lobID);
            return blobDataID;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClobData getClob(long lobID) {
        this.writeLock.lock();
        try {
            ClobDataID clob;
            Object[] data = this.getLobHeader(lobID);
            if (data == null) {
                ClobData clobData = null;
                return clobData;
            }
            ClobDataID clobDataID = clob = new ClobDataID(lobID);
            return clobDataID;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createBlob(Session session, long length) {
        this.writeLock.lock();
        try {
            long lobID = this.getNewLobID();
            ResultMetaData meta = this.createLob.getParametersMetaData();
            Object[] params = new Object[meta.getColumnCount()];
            params[0] = ValuePool.getLong(lobID);
            params[1] = ValuePool.getLong(length);
            params[2] = ValuePool.INTEGER_0;
            params[3] = ValuePool.getInt(30);
            Result result = this.sysLobSession.executeCompiledStatement(this.createLob, params);
            this.usageCountChanged = true;
            long l = lobID;
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createClob(Session session, long length) {
        this.writeLock.lock();
        try {
            long lobID = this.getNewLobID();
            ResultMetaData meta = this.createLob.getParametersMetaData();
            Object[] params = new Object[meta.getColumnCount()];
            params[0] = ValuePool.getLong(lobID);
            params[1] = ValuePool.getLong(length);
            params[2] = ValuePool.INTEGER_0;
            params[3] = ValuePool.getInt(40);
            Result result = this.sysLobSession.executeCompiledStatement(this.createLob, params);
            this.usageCountChanged = true;
            long l = lobID;
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result deleteLob(long lobID) {
        this.writeLock.lock();
        try {
            ResultMetaData meta = this.deleteLobCall.getParametersMetaData();
            Object[] params = new Object[meta.getColumnCount()];
            params[0] = ValuePool.getLong(lobID);
            params[1] = ValuePool.getLong(0L);
            Result result = this.sysLobSession.executeCompiledStatement(this.deleteLobCall, params);
            this.usageCountChanged = true;
            Result result2 = result;
            return result2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Result deleteUnusedLobs() {
        return this.deleteUnusedLobs(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result deleteUnusedLobs(boolean withUsageCountCheck) {
        this.writeLock.lock();
        try {
            if (withUsageCountCheck && !this.usageCountChanged) {
                Result result = Result.updateZeroResult;
                return result;
            }
            Session[] sessions = this.database.collectionSessionManager.getAllSessions();
            LongDeque ids = new LongDeque();
            for (int i = 0; i < sessions.length; ++i) {
                LongDeque sessionIDs;
                if (sessions[i].isClosed() || (sessionIDs = sessions[i].sessionData.getNewLobIDs()) == null) continue;
                ids.addAll(sessionIDs);
            }
            long[] idArray = new long[ids.size()];
            ids.toArray(idArray);
            Object[] idObjectArray = new Object[idArray.length];
            for (int i = 0; i < idArray.length; ++i) {
                idObjectArray[i] = idArray[i];
            }
            Object[] params = new Object[]{idObjectArray};
            Result result = this.sysLobSession.executeCompiledStatement(this.deleteUnusedLobs, params);
            this.usageCountChanged = false;
            Result result2 = result;
            return result2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getLength(long lobID) {
        this.writeLock.lock();
        try {
            Object[] data = this.getLobHeader(lobID);
            if (data == null) {
                throw Error.error(3474);
            }
            long length = (Long)data[1];
            int type = (Integer)data[3];
            ResultLob resultLob = ResultLobFactoryFactory.getLobResultFactory().newLobSetResponse(lobID, length);
            return resultLob;
        }
        catch (DataspaceException e) {
            Result result = Result.newErrorResult(e);
            return result;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compare(BlobData a, byte[] b) {
        this.writeLock.lock();
        try {
            Object[] data = this.getLobHeader(a.getId());
            long aLength = (Long)data[1];
            int[][] aAddresses = this.getBlockAddresses(a.getId(), 0, Integer.MAX_VALUE);
            int aIndex = 0;
            int bOffset = 0;
            int aOffset = 0;
            do {
                int aBlockOffset = aAddresses[aIndex][0] + aOffset;
                byte[] aBytes = this.getLobStore().getBlockBytes(aBlockOffset, 1);
                for (int i = 0; i < aBytes.length; ++i) {
                    if (bOffset + i >= b.length) {
                        if (aLength == (long)b.length) {
                            int n = 0;
                            return n;
                        }
                        int n = 1;
                        return n;
                    }
                    if (aBytes[i] == b[bOffset + i]) continue;
                    int n = (aBytes[i] & 0xFF) > (b[bOffset + i] & 0xFF) ? 1 : -1;
                    return n;
                }
                bOffset += this.lobBlockSize;
                if (++aOffset != aAddresses[aIndex][1]) continue;
                aOffset = 0;
                ++aIndex;
            } while (aIndex != aAddresses.length);
            int n = -1;
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compare(BlobData a, BlobData b) {
        if (a.getId() == b.getId()) {
            return 0;
        }
        this.writeLock.lock();
        try {
            Object[] data = this.getLobHeader(a.getId());
            if (data == null) {
                int n = 1;
                return n;
            }
            long lengthA = (Long)data[1];
            data = this.getLobHeader(b.getId());
            if (data == null) {
                int n = -1;
                return n;
            }
            long lengthB = (Long)data[1];
            if (lengthA > lengthB) {
                int n = 1;
                return n;
            }
            if (lengthA < lengthB) {
                int n = -1;
                return n;
            }
            int n = this.compareBytes(a.getId(), b.getId());
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compare(ClobData a, String b) {
        this.writeLock.lock();
        try {
            Object[] data = this.getLobHeader(a.getId());
            long aLength = (Long)data[1];
            int[][] aAddresses = this.getBlockAddresses(a.getId(), 0, Integer.MAX_VALUE);
            int aIndex = 0;
            int bOffset = 0;
            int aOffset = 0;
            do {
                String bString;
                int diff;
                int aBlockOffset = aAddresses[aIndex][0] + aOffset;
                byte[] aBytes = this.getLobStore().getBlockBytes(aBlockOffset, 1);
                long aLimit = aLength - (long)((aAddresses[aIndex][2] + aOffset) * this.lobBlockSize / 2);
                if (aLimit > (long)(this.lobBlockSize / 2)) {
                    aLimit = this.lobBlockSize / 2;
                }
                String aString = new String(ArrayUtil.byteArrayToChars(aBytes), 0, (int)aLimit);
                int bLimit = b.length() - bOffset;
                if (bLimit > this.lobBlockSize / 2) {
                    bLimit = this.lobBlockSize / 2;
                }
                if ((diff = this.database.collation.compare(aString, bString = b.substring(bOffset, bOffset + bLimit))) != 0) {
                    int n = diff;
                    return n;
                }
                bOffset += this.lobBlockSize / 2;
                if (++aOffset != aAddresses[aIndex][1]) continue;
                aOffset = 0;
                ++aIndex;
            } while (aIndex != aAddresses.length);
            int n = 0;
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public int compare(ClobData a, ClobData b) {
        if (a.getId() == b.getId()) {
            return 0;
        }
        return this.compareText(a.getId(), b.getId());
    }

    private int compareBytes(long aID, long bID) {
        int[][] aAddresses = this.getBlockAddresses(aID, 0, Integer.MAX_VALUE);
        int[][] bAddresses = this.getBlockAddresses(bID, 0, Integer.MAX_VALUE);
        int aIndex = 0;
        int bIndex = 0;
        int aOffset = 0;
        int bOffset = 0;
        do {
            int aBlockOffset = aAddresses[aIndex][0] + aOffset;
            int bBlockOffset = bAddresses[bIndex][0] + bOffset;
            byte[] aBytes = this.getLobStore().getBlockBytes(aBlockOffset, 1);
            byte[] bBytes = this.getLobStore().getBlockBytes(bBlockOffset, 1);
            for (int i = 0; i < aBytes.length; ++i) {
                if (aBytes[i] == bBytes[i]) continue;
                return (aBytes[i] & 0xFF) > (bBytes[i] & 0xFF) ? 1 : -1;
            }
            ++bOffset;
            if (++aOffset == aAddresses[aIndex][1]) {
                aOffset = 0;
                ++aIndex;
            }
            if (bOffset != bAddresses[bIndex][1]) continue;
            bOffset = 0;
            ++bIndex;
        } while (aIndex != aAddresses.length);
        return 0;
    }

    private int compareText(long aID, long bID) {
        Object[] data = this.getLobHeader(aID);
        long aLength = (Long)data[1];
        data = this.getLobHeader(bID);
        long bLength = (Long)data[1];
        int[][] aAddresses = this.getBlockAddresses(aID, 0, Integer.MAX_VALUE);
        int[][] bAddresses = this.getBlockAddresses(bID, 0, Integer.MAX_VALUE);
        int aIndex = 0;
        int bIndex = 0;
        int aOffset = 0;
        int bOffset = 0;
        do {
            String bString;
            String aString;
            int diff;
            long bLimit;
            int aBlockOffset = aAddresses[aIndex][0] + aOffset;
            int bBlockOffset = bAddresses[bIndex][0] + bOffset;
            byte[] aBytes = this.getLobStore().getBlockBytes(aBlockOffset, 1);
            byte[] bBytes = this.getLobStore().getBlockBytes(bBlockOffset, 1);
            long aLimit = aLength - (long)((aAddresses[aIndex][2] + aOffset) * this.lobBlockSize / 2);
            if (aLimit > (long)(this.lobBlockSize / 2)) {
                aLimit = this.lobBlockSize / 2;
            }
            if ((bLimit = bLength - (long)((bAddresses[bIndex][2] + bOffset) * this.lobBlockSize / 2)) > (long)(this.lobBlockSize / 2)) {
                bLimit = this.lobBlockSize / 2;
            }
            if ((diff = this.database.collation.compare(aString = new String(ArrayUtil.byteArrayToChars(aBytes), 0, (int)aLimit), bString = new String(ArrayUtil.byteArrayToChars(bBytes), 0, (int)bLimit))) != 0) {
                return diff;
            }
            ++bOffset;
            if (++aOffset == aAddresses[aIndex][1]) {
                aOffset = 0;
                ++aIndex;
            }
            if (bOffset != bAddresses[bIndex][1]) continue;
            bOffset = 0;
            ++bIndex;
        } while (aIndex != aAddresses.length);
        return 0;
    }

    public Result getLob(long lobID, long offset, long length) {
        if (offset == 0L) {
            return this.createDuplicateLob(lobID, length, false);
        }
        throw Error.runtimeError(201, "LobManager");
    }

    public Result createDuplicateLob(long lobID) {
        Result result = this.getLength(lobID);
        if (result.isError()) {
            return result;
        }
        return this.createDuplicateLob(lobID, ((ResultLob)result).getBlockLength(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result createDuplicateLob(long lobID, long newLength, boolean duplicate) {
        this.writeLock.lock();
        try {
            Object[] data = this.getLobHeader(lobID);
            if (data == null) {
                Result result = Result.newErrorResult(Error.error(3474));
                return result;
            }
            long length = (Long)data[1];
            if (!duplicate && length <= newLength) {
                ResultLob resultLob = ResultLobFactoryFactory.getLobResultFactory().newLobCreateBlobResponse(lobID);
                return resultLob;
            }
            long newLobID = this.getNewLobID();
            Object[] params = new Object[data.length];
            params[0] = ValuePool.getLong(newLobID);
            params[1] = data[1];
            params[2] = data[2];
            params[3] = data[3];
            Result result = this.sysLobSession.executeCompiledStatement(this.createLob, params);
            if (result.isError()) {
                Result result2 = result;
                return result2;
            }
            this.usageCountChanged = true;
            if (newLength == 0L) {
                ResultLob resultLob = ResultLobFactoryFactory.getLobResultFactory().newLobSetResponse(newLobID, newLength);
                return resultLob;
            }
            long byteLength = newLength;
            int lobType = (Integer)data[3];
            if (lobType == 40) {
                byteLength *= 2L;
            }
            int newBlockCount = (int)(byteLength / (long)this.lobBlockSize);
            if (byteLength % (long)this.lobBlockSize != 0L) {
                ++newBlockCount;
            }
            this.createBlockAddresses(newLobID, 0, newBlockCount);
            int[][] sourceBlocks = this.getBlockAddresses(lobID, 0, Integer.MAX_VALUE);
            int[][] targetBlocks = this.getBlockAddresses(newLobID, 0, Integer.MAX_VALUE);
            try {
                this.copyBlockSet(sourceBlocks, targetBlocks);
            }
            catch (DataspaceException e) {
                Result result3 = Result.newErrorResult(e);
                this.writeLock.unlock();
                return result3;
            }
            int endOffset = (int)(byteLength % (long)this.lobBlockSize);
            if (endOffset != 0) {
                int[] block = targetBlocks[targetBlocks.length - 1];
                int blockOffset = block[0] + block[1] - 1;
                byte[] bytes = this.getLobStore().getBlockBytes(blockOffset, 1);
                ArrayUtil.fillArray(bytes, endOffset, (byte)0);
                this.getLobStore().setBlockBytes(bytes, blockOffset, 1);
            }
            ResultLob resultLob = ResultLobFactoryFactory.getLobResultFactory().newLobSetResponse(newLobID, newLength);
            return resultLob;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getTruncateLength(long lobID) {
        this.writeLock.lock();
        try {
            Object[] data = this.getLobHeader(lobID);
            if (data == null) {
                throw Error.error(3474);
            }
            long length = (Long)data[1];
            int type = (Integer)data[3];
            ResultLob resultLob = ResultLobFactoryFactory.getLobResultFactory().newLobSetResponse(lobID, length);
            return resultLob;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void copyBlockSet(int[][] source, int[][] target) {
        int sourceIndex = 0;
        int targetIndex = 0;
        do {
            int sourceOffset = 0;
            int targetOffset = 0;
            byte[] bytes = this.getLobStore().getBlockBytes(source[sourceIndex][0] + sourceOffset, 1);
            this.getLobStore().setBlockBytes(bytes, target[targetIndex][0] + targetOffset, 1);
            ++targetOffset;
            if (++sourceOffset == source[sourceIndex][1]) {
                sourceOffset = 0;
                ++sourceIndex;
            }
            if (targetOffset != target[targetIndex][1]) continue;
            targetOffset = 0;
            ++targetIndex;
        } while (sourceIndex != source.length && targetIndex != target.length);
        this.storeModified = true;
    }

    public Result getChars(long lobID, long offset, int length) {
        Result result = this.getBytes(lobID, offset * 2L, length * 2);
        if (result.isError()) {
            return result;
        }
        byte[] bytes = ((ResultLob)result).getByteArray();
        char[] chars = ArrayUtil.byteArrayToChars(bytes);
        return ResultLobFactoryFactory.getLobResultFactory().newLobGetCharsResponse(lobID, offset, chars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getBytes(long lobID, long offset, int length) {
        this.writeLock.lock();
        try {
            byte[] bytes;
            int blockOffset = (int)(offset / (long)this.lobBlockSize);
            int byteBlockOffset = (int)(offset % (long)this.lobBlockSize);
            int blockLimit = (int)((offset + (long)length) / (long)this.lobBlockSize);
            int byteLimitOffset = (int)((offset + (long)length) % (long)this.lobBlockSize);
            if (byteLimitOffset == 0) {
                byteLimitOffset = this.lobBlockSize;
            } else {
                ++blockLimit;
            }
            if (length == 0) {
                ResultLob resultLob = ResultLobFactoryFactory.getLobResultFactory().newLobGetBytesResponse(lobID, offset, BinaryData.zeroLengthBytes);
                return resultLob;
            }
            int dataBytesPosition = 0;
            byte[] dataBytes = new byte[length];
            int[][] blockAddresses = this.getBlockAddresses(lobID, blockOffset, blockLimit);
            if (blockAddresses.length == 0) {
                Result result = Result.newErrorResult(Error.error(3474));
                return result;
            }
            int i = 0;
            int blockCount = blockAddresses[i][1] + blockAddresses[i][2] - blockOffset;
            if (blockAddresses[i][1] + blockAddresses[i][2] > blockLimit) {
                blockCount -= blockAddresses[i][1] + blockAddresses[i][2] - blockLimit;
            }
            try {
                bytes = this.getLobStore().getBlockBytes(blockAddresses[i][0] - blockAddresses[i][2] + blockOffset, blockCount);
            }
            catch (DataspaceException e) {
                Result result = Result.newErrorResult(e);
                this.writeLock.unlock();
                return result;
            }
            int subLength = this.lobBlockSize * blockCount - byteBlockOffset;
            if (subLength > length) {
                subLength = length;
            }
            System.arraycopy(bytes, byteBlockOffset, dataBytes, dataBytesPosition, subLength);
            dataBytesPosition += subLength;
            ++i;
            while (i < blockAddresses.length && dataBytesPosition < length) {
                blockCount = blockAddresses[i][1];
                if (blockAddresses[i][1] + blockAddresses[i][2] > blockLimit) {
                    blockCount -= blockAddresses[i][1] + blockAddresses[i][2] - blockLimit;
                }
                try {
                    bytes = this.getLobStore().getBlockBytes(blockAddresses[i][0], blockCount);
                }
                catch (DataspaceException e) {
                    Result result = Result.newErrorResult(e);
                    this.writeLock.unlock();
                    return result;
                }
                subLength = this.lobBlockSize * blockCount;
                if (subLength > length - dataBytesPosition) {
                    subLength = length - dataBytesPosition;
                }
                System.arraycopy(bytes, 0, dataBytes, dataBytesPosition, subLength);
                dataBytesPosition += subLength;
                ++i;
            }
            ResultLob resultLob = ResultLobFactoryFactory.getLobResultFactory().newLobGetBytesResponse(lobID, offset, dataBytes);
            return resultLob;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result setBytesBA(long lobID, long offset, byte[] dataBytes, int dataLength) {
        if (dataLength == 0) {
            return ResultLobFactoryFactory.getLobResultFactory().newLobSetResponse(lobID, 0L);
        }
        this.writeLock.lock();
        try {
            boolean newBlocks = false;
            int blockOffset = (int)(offset / (long)this.lobBlockSize);
            int byteBlockOffset = (int)(offset % (long)this.lobBlockSize);
            int blockLimit = (int)((offset + (long)dataLength) / (long)this.lobBlockSize);
            int byteLimitOffset = (int)((offset + (long)dataLength) % (long)this.lobBlockSize);
            if (byteLimitOffset == 0) {
                byteLimitOffset = this.lobBlockSize;
            } else {
                ++blockLimit;
            }
            int[][] blockAddresses = this.getBlockAddresses(lobID, blockOffset, blockLimit);
            int existingLimit = blockOffset;
            if (blockAddresses.length > 0) {
                existingLimit = blockAddresses[blockAddresses.length - 1][2] + blockAddresses[blockAddresses.length - 1][1];
            }
            if (existingLimit < blockLimit) {
                this.createBlockAddresses(lobID, existingLimit, blockLimit - existingLimit);
                blockAddresses = this.getBlockAddresses(lobID, blockOffset, blockLimit);
                newBlocks = true;
            }
            int currentDataOffset = 0;
            int currentDataLength = dataLength;
            try {
                for (int i = 0; i < blockAddresses.length; ++i) {
                    long currentBlockOffset = blockAddresses[i][2] * this.lobBlockSize;
                    long currentBlockLength = blockAddresses[i][1] * this.lobBlockSize;
                    long currentBlockPosition = blockAddresses[i][0] * this.lobBlockSize;
                    int padding = 0;
                    if (offset > currentBlockOffset) {
                        currentBlockLength -= offset - currentBlockOffset;
                        currentBlockPosition += offset - currentBlockOffset;
                    }
                    if ((long)currentDataLength < currentBlockLength) {
                        if (newBlocks) {
                            padding = (int)((currentBlockLength - (long)currentDataLength) % (long)this.lobBlockSize);
                        }
                        currentBlockLength = currentDataLength;
                    }
                    this.getLobStore().setBlockBytes(dataBytes, currentBlockPosition, currentDataOffset, (int)currentBlockLength);
                    if (padding != 0) {
                        ArrayUtil.fillArray(this.byteBuffer, 0, (byte)0);
                        this.getLobStore().setBlockBytes(this.byteBuffer, currentBlockPosition + currentBlockLength, 0, padding);
                    }
                    currentDataOffset = (int)((long)currentDataOffset + currentBlockLength);
                    currentDataLength = (int)((long)currentDataLength - currentBlockLength);
                }
            }
            catch (DataspaceException e) {
                Result result = Result.newErrorResult(e);
                this.writeLock.unlock();
                return result;
            }
            this.storeModified = true;
            ResultLob resultLob = ResultLobFactoryFactory.getLobResultFactory().newLobSetResponse(lobID, 0L);
            return resultLob;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Result setBytesIS(long lobID, InputStream inputStream, long length, boolean adjustLength) {
        long writeLength = 0L;
        int blockLimit = (int)(length / (long)this.lobBlockSize);
        int byteLimitOffset = (int)(length % (long)this.lobBlockSize);
        if (byteLimitOffset == 0) {
            byteLimitOffset = this.lobBlockSize;
        } else {
            ++blockLimit;
        }
        this.createBlockAddresses(lobID, 0, blockLimit);
        int[][] blockAddresses = this.getBlockAddresses(lobID, 0, blockLimit);
        for (int i = 0; i < blockAddresses.length; ++i) {
            for (int j = 0; j < blockAddresses[i][1]; ++j) {
                int localLength = this.lobBlockSize;
                ArrayUtil.fillArray(this.byteBuffer, 0, (byte)0);
                if (i == blockAddresses.length - 1 && j == blockAddresses[i][1] - 1) {
                    localLength = byteLimitOffset;
                }
                try {
                    int count = 0;
                    while (localLength > 0) {
                        int read = inputStream.read(this.byteBuffer, count, localLength);
                        if (read == -1) {
                            if (!adjustLength) return Result.newErrorResult(new EOFException());
                            read = localLength;
                        } else {
                            writeLength += (long)read;
                        }
                        localLength -= read;
                        count += read;
                    }
                }
                catch (IOException e) {
                    Trace.logException(this, e, true);
                    return Result.newErrorResult(e);
                }
                try {
                    this.getLobStore().setBlockBytes(this.byteBuffer, blockAddresses[i][0] + j, 1);
                    continue;
                }
                catch (DataspaceException e) {
                    Trace.logException(this, e, true);
                    return Result.newErrorResult(e);
                }
            }
        }
        this.storeModified = true;
        return ResultLobFactoryFactory.getLobResultFactory().newLobSetResponse(lobID, writeLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result setBytes(long lobID, long offset, byte[] dataBytes, int dataLength) {
        if (dataLength == 0) {
            return ResultLobFactoryFactory.getLobResultFactory().newLobSetResponse(lobID, 0L);
        }
        this.writeLock.lock();
        try {
            Result result;
            long length;
            Object[] data = this.getLobHeader(lobID);
            if (data == null) {
                Result result2 = Result.newErrorResult(Error.error(3474));
                return result2;
            }
            long newLength = length = ((Long)data[1]).longValue();
            if (offset + (long)dataLength > length) {
                newLength = offset + (long)dataLength;
            }
            if ((result = this.setBytesBA(lobID, offset, dataBytes, dataLength)).isError()) {
                Result result3 = result;
                return result3;
            }
            if (newLength > length) {
                this.setLength(lobID, newLength);
                if (result.isError()) {
                    Result result4 = result;
                    return result4;
                }
            }
            ResultLob resultLob = ResultLobFactoryFactory.getLobResultFactory().newLobSetResponse(lobID, length);
            return resultLob;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result setBytesForNewBlob(long lobID, InputStream inputStream, long length) {
        if (length == 0L) {
            return ResultLobFactoryFactory.getLobResultFactory().newLobSetResponse(lobID, 0L);
        }
        this.writeLock.lock();
        try {
            Result result;
            Result result2 = result = this.setBytesIS(lobID, inputStream, length, false);
            return result2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result setChars(long lobID, long offset, char[] chars) {
        if (chars.length == 0) {
            return ResultLobFactoryFactory.getLobResultFactory().newLobSetResponse(lobID, 0L);
        }
        this.writeLock.lock();
        try {
            Object[] data = this.getLobHeader(lobID);
            if (data == null) {
                Result result = Result.newErrorResult(Error.error(3474));
                return result;
            }
            long length = (Long)data[1];
            byte[] bytes = ArrayUtil.charArrayToBytes(chars);
            Result result = this.setBytesBA(lobID, offset * 2L, bytes, chars.length * 2);
            if (result.isError()) {
                Result result2 = result;
                return result2;
            }
            if (offset + (long)chars.length > length && (result = this.setLength(lobID, length = offset + (long)chars.length)).isError()) {
                Result result3 = result;
                return result3;
            }
            ResultLob resultLob = ResultLobFactoryFactory.getLobResultFactory().newLobSetResponse(lobID, length);
            return resultLob;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result setCharsForNewClob(long lobID, InputStream inputStream, long length, boolean adjustLength) {
        if (length == 0L) {
            return ResultLobFactoryFactory.getLobResultFactory().newLobSetResponse(lobID, 0L);
        }
        this.writeLock.lock();
        try {
            Result result;
            Result result2 = this.setBytesIS(lobID, inputStream, length * 2L, adjustLength);
            if (result2.isError()) {
                Result result3 = result2;
                return result3;
            }
            long newLength = ((ResultLob)result2).getBlockLength();
            if (newLength < length) {
                result = this.truncate(lobID, newLength / 2L);
            }
            result = result2;
            return result;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result truncate(long lobID, long offset) {
        this.writeLock.lock();
        try {
            Object[] data = this.getLobHeader(lobID);
            if (data == null) {
                Result result = Result.newErrorResult(Error.error(3474));
                return result;
            }
            long length = (Long)data[1];
            long byteLength = offset;
            if ((Integer)data[3] == 40) {
                byteLength *= 2L;
            }
            int blockOffset = (int)((byteLength + (long)this.lobBlockSize - 1L) / (long)this.lobBlockSize);
            ResultMetaData meta = this.deleteLobPartCall.getParametersMetaData();
            Object[] params = new Object[meta.getColumnCount()];
            params[0] = ValuePool.getLong(lobID);
            params[1] = new Integer(blockOffset);
            params[2] = ValuePool.INTEGER_MAX;
            params[3] = ValuePool.getLong(this.sysLobSession.getTransactionTimestamp());
            Result result = this.sysLobSession.executeCompiledStatement(this.deleteLobPartCall, params);
            this.setLength(lobID, offset);
            ResultLob resultLob = ResultLobFactoryFactory.getLobResultFactory().newLobTruncateResponse(lobID, offset);
            return resultLob;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Result setLength(long lobID, long length) {
        ResultMetaData meta = this.updateLobLength.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = ValuePool.getLong(length);
        params[1] = ValuePool.getLong(lobID);
        Result result = this.sysLobSession.executeCompiledStatement(this.updateLobLength, params);
        return result;
    }

    public Result adjustUsageCount(Session session, long lobID, int delta) {
        ResultMetaData meta = this.updateLobUsage.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = ValuePool.getInt(delta);
        params[1] = ValuePool.getLong(lobID);
        session.sessionContext.pushDynamicArguments(params);
        Result result = this.updateLobUsage.execute(session);
        session.sessionContext.pop();
        return result;
    }

    private int[][] getBlockAddresses(long lobID, int offset, int limit) {
        ResultMetaData meta = this.getLobPart.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = ValuePool.getLong(lobID);
        params[1] = ValuePool.getInt(offset);
        params[2] = ValuePool.getInt(limit);
        this.sysLobSession.sessionContext.pushDynamicArguments(params);
        Result result = this.getLobPart.execute(this.sysLobSession);
        this.sysLobSession.sessionContext.pop();
        RowSetNavigator navigator = result.getNavigator();
        int size = navigator.getSize();
        int[][] blocks = new int[size][3];
        for (int i = 0; i < size; ++i) {
            navigator.absolute(i);
            Object[] data = navigator.getCurrent();
            blocks[i][0] = (Integer)data[0];
            blocks[i][1] = (Integer)data[1];
            blocks[i][2] = (Integer)data[2];
        }
        navigator.release();
        return blocks;
    }

    private void deleteBlockAddresses(long lobID, int offset, int limit) {
        ResultMetaData meta = this.deleteLobPartCall.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = ValuePool.getLong(lobID);
        params[1] = ValuePool.getInt(offset);
        params[2] = ValuePool.getInt(limit);
        params[3] = ValuePool.getLong(this.sysLobSession.getTransactionTimestamp());
        Result result = this.sysLobSession.executeCompiledStatement(this.deleteLobPartCall, params);
    }

    private void divideBlockAddresses(long lobID, int offset) {
        ResultMetaData meta = this.divideLobPartCall.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = ValuePool.getInt(offset);
        params[1] = ValuePool.getLong(lobID);
        Result result = this.sysLobSession.executeCompiledStatement(this.divideLobPartCall, params);
    }

    private void createBlockAddresses(long lobID, int offset, int count) {
        ResultMetaData meta = this.createLobPartCall.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = ValuePool.getInt(count);
        params[1] = ValuePool.getInt(offset);
        params[2] = ValuePool.getLong(lobID);
        Result result = this.sysLobSession.executeCompiledStatement(this.createLobPartCall, params);
    }

    private int getBlockAddress(int[][] blockAddresses, int blockOffset) {
        for (int i = 0; i < blockAddresses.length; ++i) {
            if (blockAddresses[i][2] + blockAddresses[i][1] <= blockOffset) continue;
            return blockAddresses[i][0] - blockAddresses[i][2] + blockOffset;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLobCount() {
        this.writeLock.lock();
        try {
            this.sysLobSession.sessionContext.pushDynamicArguments(new Object[0]);
            Result result = this.getLobCount.execute(this.sysLobSession);
            this.sysLobSession.sessionContext.pop();
            RowSetNavigator navigator = result.getNavigator();
            boolean next = navigator.next();
            if (!next) {
                navigator.release();
                int n = 0;
                return n;
            }
            Object[] data = navigator.getCurrent();
            int n = ((Number)data[0]).intValue();
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void synch() {
        if (this.storeModified && this.lobStore != null) {
            this.writeLock.lock();
            try {
                this.lobStore.synch();
                this.storeModified = false;
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveUnreferencedLobs(List<Long> unreferencedLobs) {
        if (unreferencedLobs.isEmpty()) {
            return;
        }
        if (this.database.schemaManager.findSchemaObject("UNREFERENCED_LOBS", "SDS", 4) == null) {
            return;
        }
        AbstractDataspace dataspace = (AbstractDataspace)this.database.schemaManager.findSchema("SYS");
        if (dataspace != null) {
            Session session = dataspace.createSession();
            try {
                Statement insertUnreferencedLob = session.compileStatement("INSERT INTO SDS.UNREFERENCED_LOBS VALUES(?,?,?)");
                for (Long lobId : unreferencedLobs) {
                    Result result;
                    Object[] lobData = this.getLobHeader(lobId);
                    if (lobData == null) continue;
                    Object[] args = new Object[]{lobId, null, null};
                    int lobType = (Integer)lobData[3];
                    int usageCount = (Integer)lobData[2];
                    if (lobType == 30) {
                        args[1] = new BlobDataID(lobId);
                    } else {
                        args[2] = new ClobDataID(lobId);
                    }
                    try {
                        result = session.executeCompiledStatement(insertUnreferencedLob, args);
                        FlobManager.checkResultNoError(result, "Failed to insert lob with ID " + lobId + " to UNREFERENCED_LOBS table.");
                    }
                    catch (Exception exception) {
                        Trace.logError(this, exception.getMessage());
                        continue;
                    }
                    try {
                        result = session.executeCompiledStatement(this.updateLobUsage, new Object[]{-usageCount, lobId});
                        FlobManager.checkResultNoError(result, "Failed to adjust usage count for unreferenced lob with ID " + lobId + ".");
                    }
                    catch (Exception exception) {
                        Trace.logError(this, exception.getMessage());
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
        }
    }

    public LobValidator getValidator() {
        return new LobValidator(this.database, this.sysLobSession, this::lock, this::unlock, this::getAllLobIds, type -> type instanceof BlobType || type instanceof ClobType, lobData -> {
            Object[] header = this.getLobHeader(lobData.getId());
            if (header == null) {
                throw new DataspaceException("Lob header doesn't exist.");
            }
            int[][] addresses = this.getBlockAddresses(lobData.getId(), 0, Integer.MAX_VALUE);
            if (addresses == null || addresses.length == 0) {
                throw new DataspaceException("Lob block addresses don't exist.");
            }
            return lobData;
        });
    }

    private List<Long> getAllLobIds() {
        ArrayList<Long> ids = new ArrayList<Long>();
        this.lock();
        try {
            Result result = this.sysLobSession.executeCompiledStatement(this.selectAllLobIdsStm, new Object[0]);
            while (result.navigator.next()) {
                ids.add((long)((Long)result.navigator.getCurrent()[0]));
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
        finally {
            this.unlock();
        }
        return ids;
    }

    private static interface LOB_IDS {
        public static final int LOB_ID = 0;
        public static final int LOB_LENGTH = 1;
        public static final int LOB_USAGE_COUNT = 2;
        public static final int LOB_TYPE = 3;
    }

    private static interface LOBS {
        public static final int BLOCK_ADDR = 0;
        public static final int BLOCK_COUNT = 1;
        public static final int BLOCK_OFFSET = 2;
        public static final int LOB_ID = 3;
    }

    private static interface DELETE_BLOCKS {
        public static final int LOB_ID = 0;
        public static final int BLOCK_OFFSET = 1;
        public static final int BLOCK_LIMIT = 2;
        public static final int TX_ID = 3;
    }

    private static interface UPDATE_LENGTH {
        public static final int LOB_LENGTH = 0;
        public static final int LOB_ID = 1;
    }

    private static interface UPDATE_USAGE {
        public static final int BLOCK_COUNT = 0;
        public static final int LOB_ID = 1;
    }

    private static interface GET_LOB_PART {
        public static final int LOB_ID = 0;
        public static final int BLOCK_OFFSET = 1;
        public static final int BLOCK_LIMIT = 2;
    }

    private static interface DIVIDE_BLOCK {
        public static final int BLOCK_OFFSET = 0;
        public static final int LOB_ID = 1;
    }

    private static interface ALLOC_BLOCKS {
        public static final int BLOCK_COUNT = 0;
        public static final int BLOCK_OFFSET = 1;
        public static final int LOB_ID = 2;
    }
}

