/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.lib.LongDeque;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.persist.FlobFileManager;
import com.streamscape.ds.persist.LobValidator;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultLob;
import com.streamscape.ds.result.ResultLobFactoryFactory;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.FlobData;
import com.streamscape.ds.types.FlobDataID;
import com.streamscape.ds.types.FlobInfo;
import com.streamscape.ds.types.FlobType;
import com.streamscape.ds.types.LobData;
import com.streamscape.ds.types.Type;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.tools.lexer.BufferUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;

public class FlobManager {
    private static final String FLOB_SCHEMA_SQL = "/com/streamscape/ds/resources/flob-schema.sql";
    private DataspaceStore dataspaceStore;
    private Session sysFlobSession;
    private FlobFileManager flobFileManager;
    private String flobLocationPath;
    private Statement getOrCreateLocationIdStm;
    private Statement getOrCreateFlobIdStm;
    private Statement getNextLobIdStm;
    private Statement insertNewFlobStm;
    private Statement selectFlobDataStm;
    private Statement selectAllFlobDataStm;
    private Statement updateFlobUsageStm;
    private Statement selectUsageCountStm;
    private Statement deleteUnusedFlobStm;
    private Statement selectUnusedFlobIdStm;
    private Statement deleteUnusedLocationsStm;
    private Statement selectAllFlobIdsStm;
    private Statement deleteFlobStm;
    private Statement selectCountOfFileReferencesStm;
    private Statement selectLocationsStm;
    private Statement updateFlobIsValidStm;
    private Statement updateFlobLocationIdStm;
    private final Lock sessionLock = new ReentrantLock();
    private final Lock createDeleteFileLock = new ReentrantLock();
    private static Field FlobDataIDIsValidField;

    public FlobManager(DataspaceStore dataspaceStore) {
        this.dataspaceStore = dataspaceStore;
        this.flobFileManager = new FlobFileManager(dataspaceStore);
    }

    public void createSchema() {
        this.sysFlobSession = this.dataspaceStore.collectionSessionManager.getSysFlobSession();
        this.sysFlobSession.setAutoCommit(true);
        try (InputStream fis = (InputStream)AccessController.doPrivileged(new PrivilegedAction(this){

            public InputStream run() {
                return this.getClass().getResourceAsStream(FlobManager.FLOB_SCHEMA_SQL);
            }
        });){
            BufferedReader reader = new BufferedReader(new InputStreamReader(fis, "ISO-8859-1"));
            String line = null;
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (line.trim().startsWith("--") || line.trim().length() == 0) continue;
                builder.append(line).append("\n");
            }
            Statement statement = this.sysFlobSession.compileStatement(builder.toString());
            Result result = statement.execute(this.sysFlobSession);
            if (result.isError()) {
                throw result.getException();
            }
        }
        catch (Exception exception) {
            throw new DataspaceException("Failed to create schema 'SYS_FLOBS'.", exception);
        }
        this.compileStatements();
    }

    private void compileStatements() {
        this.getOrCreateLocationIdStm = this.sysFlobSession.compileStatement("SELECT SYS_FLOBS.GET_OR_CREATE_FLOB_LOCATION(?)");
        this.getOrCreateFlobIdStm = this.sysFlobSession.compileStatement("SELECT SYS_FLOBS.GET_OR_CREATE_FLOB_ID(?,?,?,?,?)");
        this.getNextLobIdStm = this.sysFlobSession.compileStatement("VALUES NEXT VALUE FOR SYS_FLOBS.FLOB_ID");
        this.insertNewFlobStm = this.sysFlobSession.compileStatement("INSERT INTO SYS_FLOBS.FLOB_IDS VALUES(?,?,?,?,?,?,?,?)");
        this.selectFlobDataStm = this.sysFlobSession.compileStatement("SELECT FLOB_FILENAME, FLOB_CHARSET, FLOB_IS_LINKED, FLOB_IS_MANAGED, l.LOCATION_PATH, FLOB_USAGE_COUNT, FLOB_IS_VALID FROM SYS_FLOBS.FLOB_IDS LEFT JOIN SYS_FLOBS.FLOB_LOCATIONS AS l ON LOCATION_ID=l.LOCATION_ID WHERE FLOB_ID=(?)");
        this.selectAllFlobDataStm = this.sysFlobSession.compileStatement("SELECT FLOB_ID, FLOB_FILENAME, FLOB_CHARSET, FLOB_IS_LINKED, FLOB_IS_MANAGED, l.LOCATION_PATH, FLOB_USAGE_COUNT, FLOB_IS_VALID FROM SYS_FLOBS.FLOB_IDS LEFT JOIN SYS_FLOBS.FLOB_LOCATIONS AS l ON LOCATION_ID=l.LOCATION_ID");
        this.updateFlobUsageStm = this.sysFlobSession.compileStatement("UPDATE SYS_FLOBS.FLOB_IDS SET FLOB_USAGE_COUNT = (CASE FLOB_USAGE_COUNT WHEN 2147483647 THEN 0 ELSE FLOB_USAGE_COUNT END) + ? WHERE FLOB_ID = ?");
        this.selectUsageCountStm = this.sysFlobSession.compileStatement("SELECT FLOB_USAGE_COUNT FROM SYS_FLOBS.FLOB_IDS WHERE FLOB_ID = ?");
        this.deleteUnusedFlobStm = this.sysFlobSession.compileStatement("DELETE FROM SYS_FLOBS.FLOB_IDS WHERE FLOB_ID = ? AND FLOB_USAGE_COUNT <= 0");
        this.selectUnusedFlobIdStm = this.sysFlobSession.compileStatement("SELECT FLOB_ID FROM SYS_FLOBS.FLOB_IDS WHERE FLOB_USAGE_COUNT<=0");
        this.deleteUnusedLocationsStm = this.sysFlobSession.compileStatement("DELETE FROM SYS_FLOBS.FLOB_LOCATIONS WHERE LOCATION_ID IN (SELECT LOCATION_ID FROM SYS_FLOBS.FLOB_IDS WHERE FLOB_USAGE_COUNT<=0)");
        this.selectAllFlobIdsStm = this.sysFlobSession.compileStatement("SELECT FLOB_ID FROM SYS_FLOBS.FLOB_IDS");
        this.deleteFlobStm = this.sysFlobSession.compileStatement("DELETE FROM SYS_FLOBS.FLOB_IDS WHERE FLOB_ID = ?");
        this.selectCountOfFileReferencesStm = this.sysFlobSession.compileStatement("SELECT COUNT(*) FROM SYS_FLOBS.FLOB_IDS WHERE FLOB_FILENAME=? AND LOCATION_ID=?");
        this.selectLocationsStm = this.sysFlobSession.compileStatement("SELECT LOCATION_ID, LOCATION_PATH FROM SYS_FLOBS.FLOB_LOCATIONS");
        this.updateFlobIsValidStm = this.sysFlobSession.compileStatement("UPDATE SYS_FLOBS.FLOB_IDS SET FLOB_IS_VALID = ? WHERE FLOB_ID = ?");
        this.updateFlobLocationIdStm = this.sysFlobSession.compileStatement("UPDATE SYS_FLOBS.FLOB_IDS SET LOCATION_ID = ? WHERE FLOB_ID = ?");
    }

    public void open() {
        this.flobLocationPath = this.dataspaceStore.dataspaceLogger.getFlobLocationPath();
        this.getOrCreateFlobLocationPath(this.flobLocationPath);
    }

    public void close() {
    }

    public void initialiseFlobSpace() {
    }

    public void lock() {
        this.sessionLock.lock();
    }

    public void unlock() {
        this.sessionLock.unlock();
    }

    public void synch() {
    }

    public FlobFileManager getFlobFileManager() {
        return this.flobFileManager;
    }

    public long getOrCreateFlobLocationPath(String locationPath) {
        return this.getOrCreateFlobLocationPath(locationPath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOrCreateFlobLocationPath(String locationPath, boolean allowInvalidLocation) {
        locationPath = this.getLocationPath(locationPath);
        if (!allowInvalidLocation) {
            this.flobFileManager.checkAndCreateLocationDirectory(locationPath);
        }
        String normalizedUnifiedPath = FlobManager.normalizePath(locationPath);
        this.lock();
        try {
            Result result = this.sysFlobSession.executeCompiledStatement(this.getOrCreateLocationIdStm, new Object[]{normalizedUnifiedPath});
            long l = (Long)this.getResultData(result, "Failed to create flob location path '" + normalizedUnifiedPath + "'.");
            return l;
        }
        finally {
            this.unlock();
        }
    }

    public static String normalizeFilename(String filename) {
        return BufferUtils.unslashPath(filename);
    }

    public static String normalizePath(String locationPath) {
        String prefix = DropBoxUtils.getProtocolPrefix(locationPath = FlobManager.unifyPath(locationPath));
        return prefix != null ? FlobManager.unifyPath("dropbox:/" + Paths.get(locationPath.substring(prefix.length()), new String[0]).normalize().toString()) : FlobManager.unifyPath(Paths.get(locationPath, new String[0]).normalize().toString());
    }

    public static String unifyPath(String path) {
        return path.replace('\\', '/');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlobDataID createFlob(Type type, String filename, String charset, boolean isLinked, boolean isManaged, boolean allowInvalidLocation) {
        FlobType flobType = (FlobType)type;
        String locationPath = this.getLocationPath(flobType.getLocation());
        long locationId = this.getOrCreateFlobLocationPath(locationPath, allowInvalidLocation);
        if (!isLinked) {
            filename = Paths.get(filename, new String[0]).getFileName().toString();
        }
        filename = FlobManager.normalizeFilename(filename);
        if (charset == null && flobType.isCharsetFromDefinition()) {
            charset = flobType.getCharset();
        }
        this.lock();
        try {
            Long flobId = null;
            if (flobType.getAutotag() != null && flobType.getAutotag().booleanValue()) {
                result = this.sysFlobSession.executeCompiledStatement(this.getNextLobIdStm, new Object[0]);
                flobId = (Long)this.getResultData(result, "Failed to get next flob id for file '" + filename + "' at location '" + locationId + "'.");
                filename = this.tagFilename(filename, flobId);
                result = this.sysFlobSession.executeCompiledStatement(this.insertNewFlobStm, new Object[]{flobId, filename, charset, isLinked, 1, locationId, isManaged, true});
                this.checkResultIsUpdateCount(result, 1, "Failed to insert new flob id '" + flobId + "' for file '" + filename + "' at location '" + locationId + "'.");
            } else {
                result = this.sysFlobSession.executeCompiledStatement(this.getOrCreateFlobIdStm, new Object[]{filename, charset, isLinked, isManaged, locationId});
                flobId = (Long)this.getResultData(result, "Failed to create flob id for file '" + filename + "' at location '" + locationId + "'.");
            }
            FlobDataID flobDataID = new FlobDataID(flobId, filename, charset, locationPath, flobType.getAutotag() == null ? false : flobType.getAutotag(), isLinked, isManaged, true);
            return flobDataID;
        }
        finally {
            this.unlock();
        }
    }

    public String getLocationPath(String locationPath) {
        if (locationPath == null) {
            locationPath = this.flobLocationPath;
        }
        return locationPath;
    }

    public String tagFilename(String filename, long flobId) {
        filename = Paths.get(filename, new String[0]).getFileName().toString();
        return flobId + "_" + filename;
    }

    private Boolean isFilenameTagged(String filename) {
        if (filename == null) {
            return false;
        }
        int pos = filename.indexOf("_");
        if (pos > 0 && pos < filename.length() - 1) {
            String prefix = filename.substring(0, pos);
            try {
                return Long.valueOf(prefix) >= 0L;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public FlobData getFlobData(long flobId) {
        return this.getFlobData(flobId, true);
    }

    public FlobData getFlobData(long flobId, boolean throwErrorIfLocationNotExist) {
        this.lock();
        try {
            Result result = this.sysFlobSession.executeCompiledStatement(this.selectFlobDataStm, new Object[]{flobId});
            this.checkResultIsData(result, "Cannot get flob '" + flobId + "' data.");
            RowSetNavigator navigator = result.getNavigator();
            if (!navigator.next()) {
                throw new DataspaceException("Flob '" + flobId + "' doesn't exist.");
            }
            String filename = (String)navigator.getCurrent()[0];
            String charset = (String)navigator.getCurrent()[1];
            boolean isLinked = (Boolean)navigator.getCurrent()[2];
            boolean isManaged = (Boolean)navigator.getCurrent()[3];
            String location = (String)navigator.getCurrent()[4];
            int usageCount = (Integer)navigator.getCurrent()[5];
            boolean isValid = (Boolean)navigator.getCurrent()[6];
            if (throwErrorIfLocationNotExist && location == null) {
                throw new DataspaceException("Flob '" + flobId + "' location doesn't exist in FLOB_LOCATIONS table.");
            }
            FlobDataID flobDataID = new FlobDataID(flobId, filename, charset, location, null, isLinked, isManaged, usageCount, isValid);
            return flobDataID;
        }
        catch (Exception exception) {
            throw new DataspaceException("Flob is broken. " + exception.getMessage(), "0000", 3476);
        }
        finally {
            this.unlock();
        }
    }

    public FlobData validateFlob(long flobId, boolean notEmpty) {
        FlobData flobData = this.getFlobData(flobId);
        if (!this.flobFileManager.isFlobFileExists(flobData) || notEmpty && this.getLength(flobData) == 0L) {
            if (flobData.isValid()) {
                this.updateFlobIsValid(flobId, false);
                FlobManager.setFlobDataValid((FlobDataID)flobData, false);
            }
        } else if (!flobData.isValid()) {
            this.updateFlobIsValid(flobId, true);
            FlobManager.setFlobDataValid((FlobDataID)flobData, true);
        }
        return flobData;
    }

    public void invalidateFlob(long flobId) {
        this.updateFlobIsValid(flobId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FlobData> getAllFlobData() {
        this.lock();
        try {
            Result result = this.sysFlobSession.executeCompiledStatement(this.selectAllFlobDataStm, new Object[0]);
            this.checkResultIsData(result, "Cannot get all flob data.");
            RowSetNavigator navigator = result.getNavigator();
            ArrayList<FlobData> flobs = new ArrayList<FlobData>();
            while (navigator.next()) {
                long flobId = (Long)navigator.getCurrent()[0];
                String filename = (String)navigator.getCurrent()[1];
                String charset = (String)navigator.getCurrent()[2];
                boolean isLinked = (Boolean)navigator.getCurrent()[3];
                boolean isManaged = (Boolean)navigator.getCurrent()[4];
                String location = (String)navigator.getCurrent()[5];
                int usageCount = (Integer)navigator.getCurrent()[6];
                boolean isValid = (Boolean)navigator.getCurrent()[7];
                flobs.add(new FlobDataID(flobId, filename, charset, location, null, isLinked, isManaged, usageCount, isValid));
            }
            ArrayList<FlobData> arrayList = flobs;
            return arrayList;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getFlobLocations() {
        this.lock();
        try {
            Result result = this.sysFlobSession.executeCompiledStatement(this.selectLocationsStm, new Object[0]);
            this.checkResultIsData(result, "Cannot get flob locations.");
            RowSetNavigator navigator = result.getNavigator();
            ArrayList<String> locations = new ArrayList<String>();
            while (navigator.next()) {
                locations.add((String)navigator.getCurrent()[1]);
            }
            ArrayList<String> arrayList = locations;
            return arrayList;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFlobIsValid(long flobId, boolean isValid) {
        this.lock();
        try {
            Result result = this.sysFlobSession.executeCompiledStatement(this.updateFlobIsValidStm, new Object[]{isValid, flobId});
            FlobManager.checkResultNoError(result, "Failed to update FLOB_IS_VALID.");
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFlobLocationId(long flobId, long locationId) {
        this.lock();
        try {
            Result result = this.sysFlobSession.executeCompiledStatement(this.updateFlobLocationIdStm, new Object[]{locationId, flobId});
            FlobManager.checkResultNoError(result, "Failed to update FLOB_LOCATION_ID.");
        }
        finally {
            this.unlock();
        }
    }

    public Result getLengthResult(long flobId) {
        return this.getLengthResult(this.getFlobData(flobId));
    }

    public Result getLengthResult(FlobData flobData) {
        return ResultLobFactoryFactory.getFlobResultFactory().newLobSetResponse(flobData.getId(), this.getLength(flobData));
    }

    public long getLength(FlobData flobData) {
        try {
            return this.flobFileManager.getLength(flobData.getFilename(), flobData.getLocation());
        }
        catch (IOException exception) {
            throw new DataspaceException("Failed to get length for flob '" + flobData.getId() + "'. Cause: " + exception.getMessage());
        }
    }

    public Result getChars(Session session, long flobId, long offset, int length) {
        FlobData flobData = this.getFlobData(flobId);
        try {
            char[] chars = this.flobFileManager.getChars(session, flobData.getFilename(), flobData.getCharset(), flobData.getLocation(), offset, length);
            return ResultLobFactoryFactory.getFlobResultFactory().newLobGetCharsResponse(flobId, offset, chars);
        }
        catch (IOException exception) {
            throw new DataspaceException("Failed to get chars for flob '" + flobId + "'. Cause: " + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result setChars(FlobData lob, Reader reader, long length, String charset) {
        try {
            Object[] result = this.flobFileManager.createFlobTmpFile(lob, reader, length, charset);
            this.createDeleteFileLock.lock();
            try {
                this.flobFileManager.moveTmpFileToFlob(result[0].toString(), result[1].toString());
            }
            finally {
                this.createDeleteFileLock.unlock();
            }
            return ResultLobFactoryFactory.getFlobResultFactory().newLobSetResponse(lob.getId(), (Long)result[2]);
        }
        catch (Exception exception) {
            return Result.newErrorResult(exception);
        }
    }

    public Result getBytes(long flobId, long offset, int length) {
        FlobData flobData = this.getFlobData(flobId);
        try {
            byte[] bytes = this.flobFileManager.getBytes(flobData.getFilename(), flobData.getLocation(), offset, length);
            return ResultLobFactoryFactory.getFlobResultFactory().newLobGetBytesResponse(flobId, offset, bytes);
        }
        catch (IOException exception) {
            throw new DataspaceException("Failed to get chars for flob '" + flobId + "'. Cause: " + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result setBytes(FlobData lob, InputStream inputStream, long length) {
        try {
            Object[] result = this.flobFileManager.createFlobTmpFile(lob, inputStream, length);
            this.createDeleteFileLock.lock();
            try {
                this.flobFileManager.moveTmpFileToFlob(result[0].toString(), result[1].toString());
            }
            finally {
                this.createDeleteFileLock.unlock();
            }
            return ResultLobFactoryFactory.getFlobResultFactory().newLobSetResponse(lob.getId(), (Long)result[2]);
        }
        catch (Exception exception) {
            return Result.newErrorResult(exception);
        }
    }

    public Result position(long flobId, long offset, byte[] byteArray) {
        FlobData flobData = this.getFlobData(flobId);
        try {
            int position = this.flobFileManager.position(flobData, offset, byteArray);
            if (position >= 0) {
                ++position;
            }
            return ResultLobFactoryFactory.getFlobResultFactory().newLobGetBytePatternPositionResponse(flobId, position);
        }
        catch (IOException exception) {
            throw new DataspaceException("Failed to get chars for flob '" + flobId + "'. Cause: " + exception.getMessage());
        }
    }

    public Result position(long flobId, long offset, char[] charArray) {
        FlobData flobData = this.getFlobData(flobId);
        try {
            int position = this.flobFileManager.position(flobData, offset, charArray);
            if (position >= 0) {
                ++position;
            }
            return ResultLobFactoryFactory.getFlobResultFactory().newLobGetCharPatternPositionResponse(flobId, position);
        }
        catch (IOException exception) {
            throw new DataspaceException("Failed to get chars for flob '" + flobId + "'. Cause: " + exception.getMessage());
        }
    }

    public Result truncate(long flobId, long offset) {
        FlobData flobData = this.getFlobData(flobId);
        this.createDeleteFileLock.lock();
        try {
            offset = this.flobFileManager.truncate(flobData.getFilename(), flobData.getLocation(), offset);
            ResultLob resultLob = ResultLobFactoryFactory.getFlobResultFactory().newLobTruncateResponse(flobId, offset);
            return resultLob;
        }
        catch (IOException exception) {
            throw new DataspaceException("Failed to get chars for flob '" + flobId + "'. Cause: " + exception.getMessage());
        }
        finally {
            this.createDeleteFileLock.unlock();
        }
    }

    public Result getFlob(long id, long offset, long blockLength) {
        return null;
    }

    public Result setBytes(long id, long offset, byte[] byteArray, int blockLength) {
        return null;
    }

    public Result setChars(long id, long offset, char[] charArray) {
        return null;
    }

    public Result createDuplicateLob(long id) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustUsageCount(Session session, long flobId, int delta) {
        block9: {
            this.lock();
            try {
                Result result = this.sysFlobSession.executeCompiledStatement(this.updateFlobUsageStm, new Object[]{delta, flobId});
                this.checkResultIsUpdateCount(result, 1, "Failed to adjust flob '" + flobId + "' usage count. Probably flob is no longer valid.");
                if (delta >= 0) break block9;
                try {
                    Result result1 = this.sysFlobSession.executeCompiledStatement(this.selectUsageCountStm, new Object[]{flobId});
                    this.checkResultIsData(result1, "Failed to get usage count for flob '" + flobId + "'.");
                    if (result1.navigator.next() && (Integer)result1.navigator.getCurrent()[0] <= 0) {
                        session.sessionData.addFlobToDelete(flobId);
                    }
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, true);
                }
            }
            catch (Exception exception) {
                if (delta > 0) {
                    throw exception;
                }
                Trace.logException(this, exception, false);
            }
            finally {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustUsageCountForNewlyCreatedFlob(long flobId) {
        this.lock();
        try {
            Result result = this.sysFlobSession.executeCompiledStatement(this.updateFlobUsageStm, new Object[]{-1, flobId});
            this.checkResultIsUpdateCount(result, "Failed to adjust usage count for newly created flob " + flobId + ".");
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
        }
        finally {
            this.unlock();
        }
    }

    public void deleteUnusedFlobs() {
        this.lock();
        try {
            Result result = this.sysFlobSession.executeCompiledStatement(this.selectUnusedFlobIdStm, new Object[0]);
            this.checkResultIsData(result, "Failed to get unused flobs.");
            LongDeque ids = new LongDeque();
            while (result.navigator.next()) {
                ids.add((Long)result.navigator.getCurrent()[0]);
            }
            this.deleteUnusedFlobs(ids);
            result = this.sysFlobSession.executeCompiledStatement(this.deleteUnusedLocationsStm, new Object[0]);
            FlobManager.checkResultNoError(result, "Failed to remove unused flob locations.");
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUnusedFlobs(LongDeque flobIDsToDelete) {
        if (flobIDsToDelete == null) {
            return;
        }
        for (int i = 0; i < flobIDsToDelete.size(); ++i) {
            long flobId = flobIDsToDelete.get(i);
            this.lock();
            try {
                FlobData flobData = this.getFlobData(flobId, false);
                this.createDeleteFileLock.lock();
                try {
                    Result result = this.sysFlobSession.executeCompiledStatement(this.deleteUnusedFlobStm, new Object[]{flobId});
                    this.checkResultIsUpdateCount(result, "Failed to delete unused flob for '" + flobId + "'.");
                    if (result.getUpdateCount() != 1 || !flobData.isManaged() || flobData.getLocation() == null) continue;
                    this.flobFileManager.deleteFlobFile(flobData.getFilename(), flobData.getLocation());
                    continue;
                }
                finally {
                    this.createDeleteFileLock.unlock();
                }
            }
            catch (Exception exception) {
                Trace.logError(this, "Failed to delete unused flob: " + exception.toString());
                continue;
            }
            finally {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFlobs(List<Long> flobIDsToDelete) {
        if (flobIDsToDelete == null) {
            return;
        }
        for (int i = 0; i < flobIDsToDelete.size(); ++i) {
            long flobId = flobIDsToDelete.get(i);
            this.lock();
            try {
                FlobData flobData = this.getFlobData(flobId);
                this.createDeleteFileLock.lock();
                try {
                    Result result = this.sysFlobSession.executeCompiledStatement(this.deleteFlobStm, new Object[]{flobId});
                    this.checkResultIsUpdateCount(result, "Failed to delete unreferenced flob for '" + flobId + "'.");
                    Trace.logError(this, "WARNING: Unreferenced FLOB({}, {}/{}) has been removed from FLOB_IDS table.", flobData.getId(), flobData.getLocation(), flobData.getFilename());
                    if (flobData == null || !flobData.isManaged()) continue;
                    result = this.sysFlobSession.executeCompiledStatement(this.selectCountOfFileReferencesStm, new Object[]{flobData.getFilename(), this.getOrCreateFlobLocationPath(flobData.getLocation())});
                    this.checkResultIsData(result, "Failed to count flobs for '" + flobData.getLocation() + "/" + flobData.getFilename() + "'.");
                    if (!result.navigator.next() || (Integer)result.navigator.getCurrent()[0] != 0) continue;
                    Trace.logError(this, "WARNING: Unreferenced FLOB file {}/{} found.", flobData.getLocation(), flobData.getFilename());
                    continue;
                }
                finally {
                    this.createDeleteFileLock.unlock();
                }
            }
            catch (Exception exception) {
                Trace.logException(this, exception, true);
                continue;
            }
            finally {
                this.unlock();
            }
        }
    }

    public LobValidator getValidator(boolean notEmpty) {
        return new LobValidator(this.dataspaceStore, this.sysFlobSession, this::lock, this::unlock, this::getAllFlobIds, type -> type instanceof FlobType, lobData -> {
            FlobData flobData = this.getFlobData(lobData.getId());
            ((FlobDataID)lobData).initialize(flobData);
            if (!this.getFlobFileManager().isFlobLocationExists(flobData.getLocation())) {
                throw new DataspaceException("Flob location doesn't exist.");
            }
            if (!this.getFlobFileManager().isFlobFileExists(flobData) || notEmpty && this.getLength(flobData) == 0L) {
                throw new DataspaceException("Flob file doesn't exist or flob is empty");
            }
            return lobData;
        });
    }

    public LobValidator getValidator(Function<LobData, LobData> oneLobValidator) {
        return new LobValidator(this.dataspaceStore, this.sysFlobSession, this::lock, this::unlock, this::getAllFlobIds, type -> type instanceof FlobType, oneLobValidator);
    }

    private List<Long> getAllFlobIds() {
        ArrayList<Long> flobIds = new ArrayList<Long>();
        this.lock();
        try {
            Result result = this.sysFlobSession.executeCompiledStatement(this.selectAllFlobIdsStm, new Object[0]);
            this.checkResultIsData(result, "Failed to get all flob ids.");
            while (result.navigator.next()) {
                flobIds.add((long)((Long)result.navigator.getCurrent()[0]));
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
        finally {
            this.unlock();
        }
        return flobIds;
    }

    public List<String> validateLocations() {
        ArrayList<String> locations = new ArrayList<String>();
        for (String location : this.getFlobLocations()) {
            if (this.flobFileManager.isFlobLocationExists(location)) continue;
            locations.add(location);
        }
        return locations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FlobLocation> listLocations(boolean withTables) {
        HashMap<Long, FlobLocation> locations = new HashMap<Long, FlobLocation>();
        this.lock();
        try {
            Result result = this.sysFlobSession.executeCompiledStatement(this.selectLocationsStm, new Object[0]);
            this.checkResultIsData(result, "Cannot get flob locations.");
            RowSetNavigator navigator = result.getNavigator();
            while (navigator.next()) {
                String location = (String)navigator.getCurrent()[1];
                locations.put((Long)navigator.getCurrent()[0], new FlobLocation(location, this.flobFileManager.isFlobLocationExists(location)));
            }
        }
        finally {
            this.unlock();
        }
        if (withTables) {
            for (Object object : this.dataspaceStore.schemaManager.getAllTables(false).toArray()) {
                Table table = (Table)object;
                for (int i = 0; i < table.getColumnCount(); ++i) {
                    ColumnSchema column = table.getColumn(i);
                    if (!(column.getDataType() instanceof FlobType)) continue;
                    String location = ((FlobType)column.getDataType()).getLocation();
                    long id = this.getOrCreateFlobLocationPath(location = FlobManager.normalizePath(this.getLocationPath(location)));
                    FlobLocation flobLocation = (FlobLocation)locations.get(id);
                    if (flobLocation == null) {
                        flobLocation = new FlobLocation(this.getLocationPath(location), this.flobFileManager.isFlobLocationExists(location));
                        locations.put(id, flobLocation);
                    }
                    flobLocation.addReference(table.getObjectName().getSchemaQualifiedStatementName() + "/" + column.getNameString());
                }
            }
        }
        return locations.values().stream().sorted((c1, c2) -> c1.location.compareTo(c2.location)).collect(Collectors.toList());
    }

    public AllFlobsInfo listAllFlobs(boolean withTables) {
        final AllFlobsInfo allFlobsInfo = new AllFlobsInfo();
        for (FlobData flobData : this.getAllFlobData()) {
            boolean exists = flobData.getLocation() != null ? this.flobFileManager.isFlobFileExists(flobData) : false;
            long length = -1L;
            if (exists) {
                try {
                    length = this.flobFileManager.getLength(flobData.getFilename(), flobData.getLocation());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            allFlobsInfo.addFlobInfo(new FlobDataIdWrapper((FlobDataID)flobData, exists, length));
        }
        if (withTables) {
            for (final Object object : this.dataspaceStore.schemaManager.getAllTables(false).toArray()) {
                this.getValidator(false).selectAllLobsFromTable((Table)object, false, null, new LobValidator.LobListener(){

                    @Override
                    public void onLob(LobData flobDataID, List<String> flobColumnNames, int index, Object[] current, int identityStart) {
                        FlobDataIdWrapper flobDataIdWrapper = allFlobsInfo.getFlobDataIdWrapper(flobDataID.getId());
                        if (flobDataIdWrapper != null) {
                            flobDataIdWrapper.addReference(allFlobsInfo.addReference(((Table)object).getObjectName().getSchemaQualifiedStatementName() + "/" + flobColumnNames.get(index)));
                        }
                    }
                });
            }
        }
        return allFlobsInfo;
    }

    public AllFlobsInfo listAllFlobs(String dataspaceName, String tableName, String columnName) {
        final AllFlobsInfo allFlobsInfo = new AllFlobsInfo();
        for (final Object object : this.dataspaceStore.schemaManager.getAllTables(false).toArray()) {
            Table table = (Table)object;
            if (!table.getObjectName().schema.name.equals(dataspaceName) || tableName != null && !table.getObjectName().name.equals(tableName)) continue;
            HashSet<String> columns = null;
            if (columnName != null) {
                columns = new HashSet<String>();
                columns.add(columnName);
            }
            this.getValidator(false).selectAllLobsFromTable((Table)object, false, columns, new LobValidator.LobListener(){

                @Override
                public void onLob(LobData flobDataID, List<String> flobColumnNames, int index, Object[] current, int identityStart) {
                    FlobDataIdWrapper flobDataIdWrapper = allFlobsInfo.getFlobDataIdWrapper(flobDataID.getId());
                    if (flobDataIdWrapper == null) {
                        FlobData flobData = (FlobData)flobDataID;
                        boolean exists = flobData.getLocation() != null && flobData.getFilename() != null ? FlobManager.this.flobFileManager.isFlobFileExists(flobData) : false;
                        long length = -1L;
                        if (exists) {
                            try {
                                length = FlobManager.this.flobFileManager.getLength(flobData.getFilename(), flobData.getLocation());
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        flobDataIdWrapper = new FlobDataIdWrapper((FlobDataID)flobData, exists, length);
                        allFlobsInfo.addFlobInfo(flobDataIdWrapper);
                    }
                    flobDataIdWrapper.addReference(allFlobsInfo.addReference(((Table)object).getObjectName().getSchemaQualifiedStatementName() + "/" + flobColumnNames.get(index)));
                }
            });
        }
        return allFlobsInfo;
    }

    private <T> T getResultData(Result result, String error) {
        this.checkResultIsData(result, error);
        RowSetNavigator navigator = result.getNavigator();
        if (!navigator.next()) {
            throw new DataspaceException(error + " Statement returned no data.");
        }
        return (T)navigator.getCurrent()[0];
    }

    public static void checkResultNoError(Result result, String error) {
        if (result.isError()) {
            throw new DataspaceException(error + " Cause: " + new DataspaceException(result).getMessage());
        }
    }

    private void checkResultIsData(Result result, String error) {
        FlobManager.checkResultNoError(result, error);
        if (!result.isData()) {
            throw new DataspaceException(error + " Statement returned no data.");
        }
    }

    private void checkResultIsUpdateCount(Result result, String error) {
        FlobManager.checkResultNoError(result, error);
        if (!result.isUpdateCount()) {
            throw new DataspaceException(error + " Statement returned not update count.");
        }
    }

    private void checkResultIsUpdateCount(Result result, int updateCount, String error) {
        this.checkResultIsUpdateCount(result, error);
        if (result.getUpdateCount() != updateCount) {
            throw new DataspaceException(error + " Statement update count is '" + result.getUpdateCount() + "' but expected '" + updateCount + "'.");
        }
    }

    public static Object convertFlobDataToFlobInfo(Session session, Object datum, FlobDataID flobData) {
        FlobInfo flobInfo = new FlobInfo(flobData.getId());
        flobInfo.setFilename(flobData.getFilename());
        flobInfo.setLinked(flobData.getLinked());
        flobInfo.setManaged(flobData.isManaged());
        flobInfo.setLocation(flobData.getLocation());
        flobInfo.setUsageCount(flobData.getUsageCount());
        flobInfo.setValid(flobInfo.isValid());
        if (flobData.getCharset() != null) {
            flobInfo.setCharset(flobData.getCharset());
        } else {
            flobInfo.setCharset(session.getSessionCCSID().toString());
        }
        flobInfo.setAutotag(false);
        if (flobData.getAutotag() != null) {
            flobInfo.setAutotag(flobData.getAutotag());
        }
        if (datum instanceof FlobDataID) {
            if (flobData.getAutotag() == null && ((FlobDataID)datum).getAutotag() != null) {
                flobInfo.setAutotag(((FlobDataID)datum).getAutotag());
            }
            try {
                flobInfo.setSize(session.dataspaceStore.flobManager.getLength(flobData));
            }
            catch (Exception exception) {
                flobInfo.setSize(-1L);
            }
        } else {
            try {
                flobInfo.setSize(session.sessionData.getFilelLength(flobData.getFilename()));
            }
            catch (Exception exception) {
                flobInfo.setSize(-1L);
            }
        }
        return flobInfo;
    }

    public static void setFlobDataValid(FlobDataID flobDataID, boolean isValid) {
        try {
            FlobDataIDIsValidField.setBoolean(flobDataID, isValid);
        }
        catch (Exception e) {
            Trace.logError(FlobManager.class, "Failed to set FlobDataID isValid: " + e.toString());
        }
    }

    static {
        try {
            FlobDataIDIsValidField = FlobDataID.class.getDeclaredField("isValid");
            FlobDataIDIsValidField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            Trace.logError(FlobManager.class, "Failed to get FlobDataID isValid: " + e.toString());
        }
    }

    public static class FlobLocation {
        private String location;
        private List<String> references = new ArrayList<String>();
        private boolean exists;

        public FlobLocation(String location, boolean exists) {
            this.location = location;
            this.exists = exists;
        }

        public void addReference(String reference) {
            this.references.add(reference);
        }

        public List<String> getReferences() {
            return this.references;
        }

        public String getLocation() {
            return this.location;
        }

        public boolean exists() {
            return this.exists;
        }
    }

    public static class AllFlobsInfo {
        private Map<Long, FlobDataIdWrapper> flobDataIdWrappers = new HashMap<Long, FlobDataIdWrapper>();
        private List<String> references = new ArrayList<String>();

        public void addFlobInfo(FlobDataIdWrapper flobDataIdWrapper) {
            this.flobDataIdWrappers.put(flobDataIdWrapper.flobDataID.getId(), flobDataIdWrapper);
        }

        public int addReference(String reference) {
            int index = this.references.indexOf(reference);
            if (index == -1) {
                this.references.add(reference);
                index = this.references.size() - 1;
            }
            return index;
        }

        public FlobDataIdWrapper getFlobDataIdWrapper(long id) {
            return this.flobDataIdWrappers.get(id);
        }

        public List<FlobDataIdWrapper> getFlobDataIdWrappers() {
            return this.flobDataIdWrappers.values().stream().sorted((i1, i2) -> i1.flobDataID != null && i2.flobDataID != null ? Long.compare(i1.flobDataID.getId(), i2.flobDataID.getId()) : -1).collect(Collectors.toList());
        }

        public List<String> resolveReferences(Collection<Integer> references) {
            return references.stream().map(i -> this.references.get((int)i)).collect(Collectors.toList());
        }
    }

    public static class FlobDataIdWrapper {
        private FlobDataID flobDataID;
        private boolean exists;
        private Set<Integer> references = new HashSet<Integer>();
        private long length;

        public FlobDataIdWrapper(FlobDataID flobDataID, boolean exists, long length) {
            this.flobDataID = flobDataID;
            this.exists = exists;
            this.length = length;
        }

        public void addReference(int reference) {
            this.references.add(reference);
        }

        public boolean exists() {
            return this.exists;
        }

        public List<Integer> getReferences() {
            return this.references.stream().sorted().collect(Collectors.toList());
        }

        public FlobDataID getFlobData() {
            return this.flobDataID;
        }

        public long getLength() {
            return this.length;
        }
    }
}

