/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.persist.FlobManager;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.FlobData;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.lib.fs.client.FileSystemWrapper;
import com.streamscape.lib.fs.client.local.LocalFileSystem;
import com.streamscape.sef.dropbox.DropBoxUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.commons.io.FilenameUtils;

public class FlobFileManager {
    private static int BUFFER_SIZE = 65536;
    private DataspaceStore dataspaceStore;
    private final Object locationDirectoryMutex = new Object();

    public FlobFileManager(DataspaceStore dataspaceStore) {
        this.dataspaceStore = dataspaceStore;
    }

    public String getAbsoluteLocationPath(String locationPath) {
        String normalizedPath;
        String absolutePath = normalizedPath = FlobManager.normalizePath(locationPath);
        if (!DropBoxUtils.isDropBoxURL(normalizedPath) && !this.isAbsolute(absolutePath)) {
            absolutePath = Paths.get(this.dataspaceStore.dataspaceLocation, new String[0]).normalize().toAbsolutePath().resolve(absolutePath).toString();
        }
        return absolutePath;
    }

    private boolean isAbsolute(String path) {
        return path.startsWith("dropbox://") || path.startsWith("dropbox:/") || Paths.get(path, new String[0]).normalize().isAbsolute();
    }

    public String getAbsoluteFilePath(String location, String filename) {
        return FlobManager.normalizePath(new File(this.getAbsoluteLocationPath(location), filename).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndCreateLocationDirectory(String locationPath) {
        String normalizedPath = FlobManager.normalizePath(locationPath);
        String absolutePath = this.getAbsoluteLocationPath(locationPath);
        Object object = this.locationDirectoryMutex;
        synchronized (object) {
            block15: {
                try (FileSystem fileSystem = this.createFileSystem(absolutePath);){
                    if (fileSystem.exists(absolutePath)) {
                        if (!fileSystem.isDirectory(absolutePath)) {
                            throw new DataspaceException("Flob storage path '" + normalizedPath + "' is not a directory.");
                        }
                        break block15;
                    }
                    try {
                        fileSystem.mkdir(absolutePath);
                    }
                    catch (IOException exception) {
                        throw new DataspaceException("Failed to created flob storage directory '" + normalizedPath + "'.", exception);
                    }
                }
                catch (IOException e) {
                    Trace.logException(this, e, true);
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    public Object[] createFlobTmpFile(FlobData flob, Reader reader, long length, String charset) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Object[] createFlobTmpFile(FlobData flob, InputStream inputStream, long length) throws IOException {
        this.checkAndCreateLocationDirectory(flob.getLocation());
        String location = this.getAbsoluteLocationPath(flob.getLocation());
        String filename = flob.getFilename();
        String filepath = this.getAbsoluteFilePath(location, filename);
        try (FileSystem fileSystem = this.createFileSystem(filepath);){
            Object[] objectArray;
            block17: {
                String prefix = FilenameUtils.getName(filename);
                String tempfilepath = fileSystem.createTempFile(location, prefix, "");
                OutputStream outputStrem = fileSystem.openForWrite(tempfilepath);
                try {
                    long remaining;
                    int read;
                    byte[] buffer = new byte[BUFFER_SIZE];
                    if (length == -1L) {
                        length = Long.MAX_VALUE;
                    }
                    for (remaining = length; remaining > 0L && (read = inputStream.read(buffer, 0, (int)Math.min((long)buffer.length, remaining))) != -1; remaining -= (long)read) {
                        outputStrem.write(buffer, 0, read);
                    }
                    objectArray = new Object[]{tempfilepath, filepath, length - remaining};
                    if (outputStrem == null) break block17;
                }
                catch (Throwable throwable) {
                    try {
                        if (outputStrem != null) {
                            try {
                                outputStrem.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        fileSystem.delete(tempfilepath, false);
                        throw exception;
                    }
                }
                outputStrem.close();
            }
            return objectArray;
        }
    }

    public void moveTmpFileToFlob(String tmpfilepth, String flobfilepath) throws IOException {
        try (FileSystem fileSystem = this.createFileSystem(tmpfilepth);){
            String path = FilenameUtils.getPath(flobfilepath);
            if (!fileSystem.exists(path)) {
                fileSystem.mkdir(path);
            }
            fileSystem.move(tmpfilepth, flobfilepath);
        }
    }

    public long getLength(String filename, String location) throws IOException {
        String path = this.getAbsoluteFilePath(location, filename);
        try (FileSystem fileSystem = this.createFileSystem(path);){
            this.checkFileExists(fileSystem, path);
            long l = fileSystem.getSize(path);
            return l;
        }
    }

    /*
     * Exception decompiling
     */
    public char[] getChars(Session session, String filename, String charset, String location, long offset, int length) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public byte[] getBytes(String filename, String location, long offset, int length) throws IOException {
        String path = this.getAbsoluteFilePath(location, filename);
        try (FileSystem fileSystem = this.createFileSystem(path);){
            byte[] byArray;
            block14: {
                InputStream inputStream = fileSystem.open(path);
                try {
                    inputStream.skip(offset);
                    byte[] bytes = new byte[length];
                    int read = 0;
                    int count = 0;
                    while (bytes.length - read > 0 && (count = inputStream.read(bytes, read, bytes.length - read)) > 0) {
                        read += count;
                    }
                    if (read != bytes.length) {
                        bytes = Arrays.copyOf(bytes, read);
                    }
                    byArray = bytes;
                    if (inputStream == null) break block14;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return byArray;
        }
    }

    public long truncate(String filename, String location, long offset) throws IOException {
        String path = this.getAbsoluteFilePath(location, filename);
        try (FileSystem fileSystem = this.createFileSystem(path);){
            long l = fileSystem.truncate(path, offset);
            return l;
        }
    }

    public void deleteFlobFile(String filename, String location) throws IOException {
        String path = this.getAbsoluteFilePath(location, filename);
        try (FileSystem fileSystem = this.createFileSystem(path);){
            fileSystem.delete(path, false);
        }
    }

    public boolean isFlobFileExists(FlobData flobData) {
        boolean bl;
        block8: {
            String path = this.getAbsoluteFilePath(flobData.getLocation(), flobData.getFilename());
            FileSystem fileSystem = this.createFileSystem(path);
            try {
                bl = fileSystem.isFile(path);
                if (fileSystem == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fileSystem != null) {
                        try {
                            fileSystem.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            fileSystem.close();
        }
        return bl;
    }

    public boolean isFlobLocationExists(String location) {
        boolean bl;
        block8: {
            String path = this.getAbsoluteLocationPath(location);
            FileSystem fileSystem = this.createFileSystem(path);
            try {
                bl = fileSystem.isDirectory(path);
                if (fileSystem == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fileSystem != null) {
                        try {
                            fileSystem.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return false;
                }
            }
            fileSystem.close();
        }
        return bl;
    }

    public int position(FlobData flobData, long offset, byte[] byteArray) throws IOException {
        throw new IOException("Not yet implemented.");
    }

    public int position(FlobData flobData, long offset, char[] charArray) throws IOException {
        throw new IOException("Not yet implemented.");
    }

    public void checkFileExists(String path) throws IOException {
        try (FileSystem fileSystem = this.createFileSystem(path);){
            this.checkFileExists(fileSystem, path);
        }
    }

    private void checkFileExists(FileSystem fileSystem, String path) throws IOException {
        if (!fileSystem.exists(path) || fileSystem.isDirectory(path)) {
            throw new DataspaceException("File '" + path + "' does not exist.");
        }
        if (!fileSystem.exists(path) || fileSystem.isDirectory(path)) {
            throw new DataspaceException("Specified file '" + path + "' is directory.");
        }
    }

    public FileSystem createFileSystem(String path) {
        if (DropBoxUtils.isDropBoxURL(path)) {
            String username;
            Session session = Session.sessionThreadLocal.get();
            String string = username = session != null ? session.getUsername() : DataspaceStore.getContext().getUserName();
            if (session != null) {
                String dropBoxName = DropBoxUtils.getDropBoxNameFromURL(path);
                String key = dropBoxName + ":" + username;
                FileSystem fileSystem = session.dropBoxFileSystems.get(key);
                if (fileSystem == null) {
                    fileSystem = DropBoxUtils.createFileSystem(DataspaceStore.getContext(), username, path);
                    fileSystem = new FileSystemWrapper(this, fileSystem){

                        @Override
                        public void close() throws IOException {
                        }
                    };
                    session.dropBoxFileSystems.put(key, fileSystem);
                }
                return fileSystem;
            }
            return DropBoxUtils.createFileSystem(DataspaceStore.getContext(), username, path);
        }
        return new LocalFileSystem();
    }
}

