/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.persist.BaseStoreProperties;
import com.streamscape.ds.persist.DataspaceStoreProperties;
import com.streamscape.lib.file.FileDescriptor;

public class FileTableSettings {
    public static final String NL = System.getProperty("line.separator");
    public String fs;
    public String vs;
    public String lvs;
    public String stringEncoding;
    public boolean isQuoted;
    public boolean isAllQuoted;
    public boolean ignoreFirst;
    public int ignoreFirstLines;
    public int blockSize;
    public boolean ignoreUnknownRecords = false;
    DataspaceStore database;
    String dataFileName;
    public int maxCacheRows;
    public int maxCacheBytes;
    public int readBufferSize;
    static final byte[] BYTES_LINE_SEP = NL.getBytes();
    static final char DOUBLE_QUOTE_CHAR = '\"';
    static final char BACKSLASH_CHAR = '\\';
    static final char LF_CHAR = '\n';
    static final char CR_CHAR = '\r';
    public String dateFormat;
    public String sqlDateFormat;
    public String sqlTimeFormat;
    public String sqlTimestampFormat;

    public FileTableSettings(DataspaceStore database, String fileSettingsString) {
        this(database, fileSettingsString, null);
    }

    public FileTableSettings(DataspaceStore database, String fileSettingsString, FileDescriptor fileDescriptor) {
        this.database = database;
        BaseStoreProperties tableprops = BaseStoreProperties.delimitedArgPairsToProps(fileSettingsString, "=", ";", "file");
        DataspaceStoreProperties dbProps = database.getProperties();
        switch (tableprops.errorCodes.length) {
            case 0: {
                this.dataFileName = null;
            }
            case 1: {
                this.dataFileName = tableprops.errorKeys[0].trim();
                break;
            }
            default: {
                throw Error.error(302);
            }
        }
        this.fs = dbProps.getStringProperty("file.fs");
        this.fs = tableprops.getProperty("file.fs", this.fs);
        this.vs = dbProps.getStringProperty("file.vs");
        this.vs = tableprops.getProperty("file.vs", this.vs);
        this.lvs = dbProps.getStringProperty("file.lvs");
        this.lvs = tableprops.getProperty("file.lvs", this.lvs);
        this.blockSize = dbProps.getIntegerProperty("file.compression_block_size", 4096);
        this.blockSize = tableprops.getIntegerProperty("file.compression_block_size", this.blockSize);
        if (this.vs == null) {
            this.vs = this.fs;
        }
        if (this.lvs == null) {
            this.lvs = this.fs;
        }
        this.fs = FileTableSettings.translateSep(this.fs);
        this.vs = FileTableSettings.translateSep(this.vs);
        this.lvs = FileTableSettings.translateSep(this.lvs);
        if (this.fs.length() == 0 || this.vs.length() == 0 || this.lvs.length() == 0) {
            throw Error.error(303);
        }
        this.ignoreFirst = dbProps.isPropertyTrue("file.ignore_first");
        this.ignoreFirst = tableprops.isPropertyTrue("file.ignore_first", this.ignoreFirst);
        this.isQuoted = dbProps.isPropertyTrue("file.quoted");
        this.isQuoted = tableprops.isPropertyTrue("file.quoted", this.isQuoted);
        this.isAllQuoted = dbProps.isPropertyTrue("file.all_quoted");
        this.isAllQuoted = tableprops.isPropertyTrue("file.all_quoted", this.isAllQuoted);
        this.stringEncoding = database.getCCSID().toString();
        this.stringEncoding = tableprops.getProperty("encoding", this.stringEncoding);
        if (!tableprops.isPropertyExist("encoding") && fileDescriptor != null && fileDescriptor.getEncoding() != null && fileDescriptor.getEncoding().length() > 0) {
            this.stringEncoding = fileDescriptor.getEncoding();
        }
        int cacheScale = dbProps.getIntegerProperty("file.cache_scale");
        cacheScale = tableprops.getIntegerProperty("file.cache_scale", cacheScale);
        int cacheSizeScale = dbProps.getIntegerProperty("file.cache_size_scale");
        cacheSizeScale = tableprops.getIntegerProperty("file.cache_size_scale", cacheSizeScale);
        this.ignoreFirstLines = dbProps.getIntegerProperty("file.ignore_first_lines");
        this.ignoreFirstLines = tableprops.getIntegerProperty("file.ignore_first_lines", this.ignoreFirstLines);
        if (!tableprops.isPropertyExist("file.ignore_first_lines") && fileDescriptor != null) {
            this.ignoreFirstLines = fileDescriptor.getSkipLinesCount();
        }
        if (!tableprops.isPropertyExist("file.ignore_first") && fileDescriptor != null) {
            this.ignoreFirst = fileDescriptor.isSkipFirstLine();
        }
        if (tableprops.isPropertyExist("file.ignore_first_lines") && !tableprops.isPropertyExist("file.ignore_first")) {
            this.ignoreFirst = false;
        }
        if (this.ignoreFirstLines > 0) {
            this.ignoreFirst = true;
        }
        this.ignoreUnknownRecords = tableprops.isPropertyTrue("file.file_table_ignore_unknown_records");
        this.maxCacheRows = (1 << cacheScale) * 3;
        this.maxCacheRows = dbProps.getIntegerProperty("file.cache_rows", this.maxCacheRows);
        this.maxCacheRows = tableprops.getIntegerProperty("file.cache_rows", this.maxCacheRows);
        this.maxCacheBytes = (1 << cacheSizeScale) * this.maxCacheRows / 1024;
        if (this.maxCacheBytes < 4) {
            this.maxCacheBytes = 4;
        }
        this.maxCacheBytes = dbProps.getIntegerProperty("file.cache_size", this.maxCacheBytes);
        this.maxCacheBytes = tableprops.getIntegerProperty("file.cache_size", this.maxCacheBytes);
        this.maxCacheBytes *= 1024;
        this.readBufferSize = dbProps.getIntegerProperty("file.read_buffer_size", 4096);
        this.readBufferSize = tableprops.getIntegerProperty("file.read_buffer_size", this.readBufferSize);
        this.dateFormat = dbProps.getProperty("file.date_format", "yyyy-MM-dd HH:mm:ss");
        this.dateFormat = tableprops.getProperty("file.date_format", this.dateFormat);
        this.sqlDateFormat = dbProps.getProperty("file.sqldate_format", "yyyy-MM-dd");
        this.sqlDateFormat = tableprops.getProperty("file.sqldate_format", this.sqlDateFormat);
        this.sqlTimeFormat = dbProps.getProperty("file.sqltime_format", "HH:mm:ss");
        this.sqlTimeFormat = tableprops.getProperty("file.sqltime_format", this.sqlTimeFormat);
        this.sqlTimestampFormat = dbProps.getProperty("file.sqltimestamp_format", "yyyy-MM-dd HH:mm:ss.SSS");
        this.sqlTimestampFormat = tableprops.getProperty("file.sqltimestamp_format", this.sqlTimestampFormat);
    }

    public String getFileName() {
        return this.dataFileName;
    }

    int getMaxCacheRows() {
        return this.maxCacheRows;
    }

    int getMaxCacheBytes() {
        return this.maxCacheBytes;
    }

    int getBlockSize() {
        return this.blockSize;
    }

    private static String translateSep(String sep) {
        return FileTableSettings.translateSep(sep, false);
    }

    private static String translateSep(String sep, boolean isProperty) {
        if (sep == null) {
            return null;
        }
        int next = sep.indexOf(92);
        if (next != -1) {
            int start = 0;
            char[] sepArray = sep.toCharArray();
            int ch = 0;
            int len = sep.length();
            StringBuilder builder = new StringBuilder(len);
            do {
                builder.append(sepArray, start, next - start);
                start = ++next;
                if (next >= len) {
                    builder.append('\\');
                    break;
                }
                if (!isProperty) {
                    ch = sepArray[next];
                }
                if (ch == 110) {
                    builder.append('\n');
                    ++start;
                    continue;
                }
                if (ch == 114) {
                    builder.append('\r');
                    ++start;
                    continue;
                }
                if (ch == 116) {
                    builder.append('\t');
                    ++start;
                    continue;
                }
                if (ch == 92) {
                    builder.append('\\');
                    ++start;
                    continue;
                }
                if (ch == 117) {
                    builder.append((char)Integer.parseInt(sep.substring(++start, start + 4), 16));
                    start += 4;
                    continue;
                }
                if (sep.startsWith("semi", next)) {
                    builder.append(';');
                    start += 4;
                    continue;
                }
                if (sep.startsWith("space", next)) {
                    builder.append(' ');
                    start += 5;
                    continue;
                }
                if (sep.startsWith("quote", next)) {
                    builder.append('\"');
                    start += 5;
                    continue;
                }
                if (sep.startsWith("apos", next)) {
                    builder.append('\'');
                    start += 4;
                    continue;
                }
                builder.append('\\');
                builder.append(sepArray[next]);
                ++start;
            } while ((next = sep.indexOf(92, start)) != -1);
            builder.append(sepArray, start, len - start);
            sep = builder.toString();
        }
        return sep;
    }
}

