/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.rowio.AbstractRowInputText;
import com.streamscape.ds.io.rowio.RowInputInterface;
import com.streamscape.ds.io.rowio.RowInputText;
import com.streamscape.ds.io.rowio.RowInputTextFileDescriptor;
import com.streamscape.ds.io.rowio.RowInputTextFileDescriptorTypesOnly;
import com.streamscape.ds.io.rowio.RowInputTextQuoted;
import com.streamscape.ds.io.rowio.RowOutputInterface;
import com.streamscape.ds.io.rowio.RowOutputText;
import com.streamscape.ds.io.rowio.RowOutputTextFileDescriptor;
import com.streamscape.ds.io.rowio.RowOutputTextFileDescriptorTypesOnly;
import com.streamscape.ds.io.rowio.RowOutputTextQuoted;
import com.streamscape.ds.lib.FileUtil;
import com.streamscape.ds.lib.IntKeyHashMap;
import com.streamscape.ds.persist.CachedObject;
import com.streamscape.ds.persist.CompressedFileTableIOManager;
import com.streamscape.ds.persist.DataFileBlockManager;
import com.streamscape.ds.persist.DataFileCache;
import com.streamscape.ds.persist.FileTableIOManager;
import com.streamscape.ds.persist.FileTableSettings;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.PersistentStoreTypesCheckDelegate;
import com.streamscape.ds.persist.PlainFileTableIOManager;
import com.streamscape.ds.persist.ScaledRAAppendableFile;
import com.streamscape.ds.persist.ScaledRAFile;
import com.streamscape.ds.schema.table.FileTable;
import java.io.IOException;
import java.util.Arrays;

public class FileTableCache
extends DataFileCache {
    protected FileTableSettings fileTableSettings;
    private boolean isAppendable;
    protected String header;
    protected FileTable table;
    protected IntKeyHashMap uncommittedCache;
    protected FileTableIOManager ioManager;
    protected boolean isCompressed;
    static final byte[] COMPRESSED_FILE_MAGIC = new byte[]{123, 124, 125};
    public static final int FILE_READ_BUFFER_SIZE_DEFAULT = 4096;

    FileTableCache(FileTable table) {
        super(table.database);
        this.table = table;
        this.uncommittedCache = new IntKeyHashMap();
    }

    @Override
    protected void doInit(String fileName) {
        this.fileAccess = FileUtil.getFileUtil();
        this.fileTableSettings = this.table.getFileTableSettings(fileName);
        this.dataFileName = this.fileTableSettings.getFileName();
        if (this.dataFileName == null) {
            throw Error.error(301);
        }
        this.dataFileName = ((FileUtil)this.fileAccess).canonicalOrAbsolutePath(this.dataFileName);
        this.maxCacheRows = this.fileTableSettings.getMaxCacheRows();
        this.maxCacheBytes = this.fileTableSettings.getMaxCacheBytes();
        this.maxDataFileSize = Long.MAX_VALUE;
        this.cachedRowPadding = 1;
        this.cacheFileScale = 1;
    }

    @Override
    protected void initBuffers() {
        this.rowIn = this.createRowInputObject();
        this.rowOut = this.createRowOutputObject();
    }

    public RowInputInterface createRowInputObject() {
        if (this.table.getFileDescriptorName() != null) {
            if (this.table.getTypesOnly()) {
                return new RowInputTextFileDescriptorTypesOnly(this.table.getFileDescriptorProcessorFactory(), this.fileTableSettings);
            }
            return new RowInputTextFileDescriptor(this.table.getFileDescriptorProcessorFactory(), this.fileTableSettings);
        }
        if (this.fileTableSettings.isQuoted || this.fileTableSettings.isAllQuoted) {
            return new RowInputTextQuoted(this.fileTableSettings.fs, this.fileTableSettings.vs, this.fileTableSettings.lvs, this.fileTableSettings.isAllQuoted);
        }
        return new RowInputText(this.fileTableSettings.fs, this.fileTableSettings.vs, this.fileTableSettings.lvs, false);
    }

    public RowOutputInterface createRowOutputObject() {
        if (this.table.getFileDescriptorName() != null) {
            if (this.table.getTypesOnly()) {
                return new RowOutputTextFileDescriptorTypesOnly(this.table.getFileDescriptorProcessorFactory().createOneRecordWriter(), this.fileTableSettings.stringEncoding, this.table.getFileDescriptorProcessorFactory().getFileDescriptor() != null ? this.table.getFileDescriptorProcessorFactory().getFileDescriptor().getUnescapedLinesDelimiter() : null);
            }
            return new RowOutputTextFileDescriptor(this.table.getFileDescriptorProcessorFactory(), this.fileTableSettings.stringEncoding);
        }
        if (this.fileTableSettings.isQuoted || this.fileTableSettings.isAllQuoted) {
            return new RowOutputTextQuoted(this.fileTableSettings.fs, this.fileTableSettings.vs, this.fileTableSettings.lvs, this.fileTableSettings.isAllQuoted, this.fileTableSettings.stringEncoding);
        }
        return new RowOutputText(this.fileTableSettings.fs, this.fileTableSettings.vs, this.fileTableSettings.lvs, false, this.fileTableSettings.stringEncoding);
    }

    @Override
    public void open(boolean readonly) {
        this.fileFreePosition = 0L;
        try {
            block4: {
                this.dataFile = this.isAppendable ? new ScaledRAAppendableFile(this.dataspaceStore, this.dataFileName) : ScaledRAFile.newScaledRAFile(this.dataspaceStore, this.dataFileName, readonly, 5);
                try {
                    this.fileFreePosition = this.dataFile.length();
                }
                catch (IOException exception) {
                    if (this.isAppendable) break block4;
                    throw exception;
                }
            }
            this.initBuffers();
            this.freeBlocks = new DataFileBlockManager(0, this.cacheFileScale, 0, 0L);
            this.isCompressed = this.checkIfCompressed();
            int blockSize = this.fileTableSettings.blockSize;
            this.ioManager = this.isCompressed ? new CompressedFileTableIOManager(this.dataFile, this.fileTableSettings, this.rowIn, this.rowOut, this.cacheReadonly, this.dataFileName, blockSize) : new PlainFileTableIOManager(this.dataFile, this.fileTableSettings, this.rowIn, this.rowOut, this.cacheReadonly, this.dataFileName, blockSize, this.table, this.isAppendable);
        }
        catch (Throwable t) {
            throw Error.error(t, 452, 42, new Object[]{t.toString(), this.dataFileName});
        }
        this.cacheReadonly = readonly;
    }

    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            this.cache.clear();
            this.fileStartFreePosition = this.fileFreePosition = (long)this.initialFreePos;
            this.freeBlocks.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean isFileCompressed() {
        return this.isCompressed;
    }

    private boolean checkIfCompressed() {
        if (!this.isAppendable) {
            try {
                this.dataFile.seek(0L);
                byte[] magic = new byte[3];
                this.dataFile.read(magic, 0, 3);
                if (Arrays.equals(COMPRESSED_FILE_MAGIC, magic)) {
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    void reopen() {
        this.open(this.cacheReadonly);
    }

    @Override
    public void close(boolean write) {
        if (this.dataFile == null) {
            return;
        }
        this.writeLock.lock();
        try {
            this.cache.saveAll();
            boolean empty = this.dataFile.length() <= (long)FileTableSettings.NL.length();
            this.dataFile.synch();
            this.dataFile.close();
            this.dataFile = null;
            if (empty && !this.cacheReadonly) {
                FileUtil.getFileUtil().delete(this.dataFileName);
            }
            this.uncommittedCache.clear();
        }
        catch (Throwable t) {
            throw Error.error(t, 452, 43, new Object[]{t.toString(), this.dataFileName});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void purge() {
        this.writeLock.lock();
        try {
            this.uncommittedCache.clear();
            if (this.cacheReadonly) {
                this.close(false);
            } else {
                if (this.dataFile != null) {
                    this.dataFile.close();
                    this.dataFile = null;
                }
                FileUtil.getFileUtil().delete(this.dataFileName);
            }
        }
        catch (Throwable t) {
            throw Error.error(t, 452, 44, new Object[]{t.toString(), this.dataFileName});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remove(int pos, PersistentStore store) {
        this.writeLock.lock();
        try {
            CachedObject row = (CachedObject)this.uncommittedCache.remove(pos);
            if (row == null) {
                row = this.cache.release(pos);
            }
            if (row != null) {
                int n = row.getStorageSize();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void removePersistence(CachedObject row) {
        this.writeLock.lock();
        try {
            this.ioManager.clearRowImage(row);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void addInit(CachedObject object) {
        this.writeLock.lock();
        try {
            this.cache.put(object.getPos(), object);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void add(CachedObject object) {
        this.writeLock.lock();
        try {
            this.setFilePos(object);
            this.uncommittedCache.put(object.getPos(), object);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private int setFilePos(CachedObject r) {
        long newPosition = this.ioManager.allocateRow(r);
        if (newPosition > this.maxDataFileSize) {
            this.dataspaceStore.dataspaceLogger.logSevereEvent("data file reached maximum size " + this.dataFileName, null);
            throw Error.error(468);
        }
        this.ioManager.clearRowImage(r);
        return r.getPos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CachedObject get(CachedObject object, PersistentStore store, boolean keep) {
        if (object == null) {
            return null;
        }
        this.writeLock.lock();
        try {
            this.ioManager.readRow(object);
            boolean isTypesCheck = store instanceof PersistentStoreTypesCheckDelegate;
            try {
                this.rowIn.setTypesCheck(isTypesCheck);
                if (isTypesCheck) {
                    object = store.get(this.rowIn);
                } else {
                    store.get(this.rowIn);
                    this.cache.put(object.getPos(), object);
                }
            }
            finally {
                this.rowIn.setTypesCheck(false);
            }
            CachedObject cachedObject = object;
            return cachedObject;
        }
        catch (IOException err) {
            if (this.isAppendable) {
                Trace.logException(this, err, true);
                throw new DataspaceException("Read from appendable file failed.");
            }
            this.dataspaceStore.dataspaceLogger.logSevereEvent(this.dataFileName + " getFromFile problem " + object.getPos(), err);
            this.cache.forceCleanUp();
            System.gc();
            CachedObject cachedObject = object;
            return cachedObject;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public CachedObject get(int i, PersistentStore store, boolean keep) {
        throw Error.runtimeError(201, "TextCache");
    }

    @Override
    protected void saveRows(CachedObject[] rows, int offset, int count) {
    }

    @Override
    public void saveRow(CachedObject row) {
        this.writeLock.lock();
        try {
            this.setFileModified();
            this.ioManager.writeRow(row);
            this.uncommittedCache.remove(row.getPos());
            this.cache.put(row.getPos(), row);
        }
        catch (Throwable e) {
            this.dataspaceStore.dataspaceLogger.logSevereEvent("saveRow failed", e);
            throw Error.error(466, e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeaderInitialise(String header) {
        this.header = header;
    }

    public void setHeader(String header) {
        if (this.fileTableSettings.ignoreFirst && this.fileFreePosition == 0L) {
            try {
                this.fileFreePosition = this.ioManager.writeHeader(header, this.fileTableSettings.stringEncoding);
                this.header = header;
            }
            catch (DataspaceException e) {
                throw new DataspaceException(e, Error.getMessage(467), 467);
            }
            return;
        }
        throw Error.error(486);
    }

    public int getLineNumber() {
        return ((AbstractRowInputText)this.rowIn).getLineNumber();
    }

    public FileTableSettings getTextFileSettings() {
        return this.fileTableSettings;
    }

    public boolean isIgnoreFirstLine() {
        return this.fileTableSettings.ignoreFirst;
    }

    public int getIgnoreFirstLines() {
        return this.fileTableSettings.ignoreFirstLines;
    }

    @Override
    protected void setFileModified() {
        this.fileModified = true;
    }

    public FileTableIOManager getIOManager() {
        return this.ioManager;
    }

    public String getConvertedFileName() {
        return this.dataFileName + ".cmpz";
    }

    public void replaceDataFile(String target) {
        this.fileAccess.removeElement(this.dataFileName);
        this.fileAccess.renameElement(target, this.dataFileName);
    }

    public void setAppendable(boolean isAppendable) {
        this.isAppendable = isAppendable;
    }
}

