/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.rowio.AbstractRowInputText;
import com.streamscape.ds.io.rowio.RowInputInterface;
import com.streamscape.ds.io.rowio.RowOutputInterface;
import com.streamscape.ds.persist.AbstractTextTableIOManager;
import com.streamscape.ds.persist.CachedObject;
import com.streamscape.ds.persist.ExternalFileTableCache;
import com.streamscape.ds.persist.FileTableCache;
import com.streamscape.ds.persist.FileTableSettings;
import com.streamscape.ds.persist.RandomAccessInputStream;
import com.streamscape.ds.schema.table.FileTable;
import com.streamscape.lib.file.DelimitedFileLinesReader;
import com.streamscape.lib.file.FileLinesReader;
import java.io.IOException;
import java.io.OutputStream;

public class ExternalFileTableIOManager
extends AbstractTextTableIOManager<Long> {
    private FileLinesReader reader;
    private RandomAccessInputStream input;
    private ExternalFileTableCache externalFileTableCache;

    ExternalFileTableIOManager(RandomAccessInputStream input, ExternalFileTableCache externalFileTableCache, FileTableSettings textFileSettings, RowInputInterface rowIn, RowOutputInterface rowOut, boolean isReadOnly, String fileName, int blockSize, FileTable fileTable) {
        super(null, textFileSettings, rowIn, rowOut, isReadOnly, fileName, blockSize);
        this.input = input;
        this.externalFileTableCache = externalFileTableCache;
        if (fileTable.getFileDescriptorName() != null) {
            this.reader = fileTable.getFileDescriptorProcessorFactory().createFileLinesReader(input, textFileSettings.stringEncoding, true);
        } else {
            this.reader = new DelimitedFileLinesReader(input, textFileSettings.stringEncoding);
            if (textFileSettings.isQuoted) {
                ((DelimitedFileLinesReader)this.reader).setQuoteSymbol('\"');
                ((DelimitedFileLinesReader)this.reader).setQuoteEscapeSymbol('\"');
                ((DelimitedFileLinesReader)this.reader).setFieldsDelimiter(textFileSettings.fs);
            }
        }
    }

    @Override
    public void convert(String targetFileName, FileTableCache cache) {
        throw new UnsupportedOperationException("External file table does not support conversion.");
    }

    @Override
    public long getFileLength() throws IOException {
        return this.input.getSize();
    }

    @Override
    public void truncate() {
        this.dataFileLock.lock();
        try {
            try {
                this.input.synch();
            }
            catch (IOException exception) {
                Trace.logException(this, exception, false);
            }
            this.input.setLength(0);
            this.resetOnTruncate();
        }
        finally {
            this.dataFileLock.unlock();
        }
    }

    @Override
    public void reset() {
        this.rowNum = -1;
        try {
            this.input.seek(0L);
            this.reader.resetMark(0L);
        }
        catch (IOException error) {
            Trace.logException(this, error, false);
        }
    }

    @Override
    public void readRow(CachedObject object) throws IOException {
        this.buffer.reset(object.getStorageSize());
        long pos = (Long)this.rowNumToPosMap.get(object.getPos());
        this.input.seek(pos);
        this.input.read(this.buffer.getBuffer(), 0, object.getStorageSize());
        this.buffer.setSize(object.getStorageSize());
        this.reader.resetMark(0L);
        String rowString = this.buffer.toString(this.textFileSettings.stringEncoding);
        this.rowIn.setSource(rowString, object.getPos(), this.buffer.size());
    }

    @Override
    public void writeRow(CachedObject object) {
        try {
            OutputStream output = this.externalFileTableCache.getOutput();
            if (output == null) {
                throw new DataspaceException("Cannot initialize file output stream. See log file for details.");
            }
            this.rowOut.reset();
            object.write(this.rowOut);
            output.write(this.rowOut.getOutputStream().getBuffer(), 0, this.rowOut.getOutputStream().size());
            output.flush();
            this.reader.resetMark(0L);
        }
        catch (IOException e) {
            throw Error.error(466, e);
        }
    }

    @Override
    public int writeHeader(String header, String encoding) {
        throw new DataspaceException("External file table supports read-only operations only.");
    }

    @Override
    public void clearRowImage(CachedObject row) {
    }

    @Override
    public long allocateRow(CachedObject object) {
        int rowSize = object.getStorageSize();
        long newFreePosition = this.fileFreePos + (long)rowSize;
        ++this.rowNum;
        this.rowNumToPosMap.put(this.rowNum, this.fileFreePos);
        object.setPos(this.rowNum);
        this.fileFreePos = newFreePosition;
        return newFreePosition;
    }

    @Override
    public int readHeaderLine() throws IOException {
        return this.readHeaderLines(1);
    }

    @Override
    public int readHeaderLines(int lines) throws IOException {
        this.header = this.reader.readHeaderLines(lines);
        return this.header.length();
    }

    @Override
    public AbstractRowInputText readNextRow(long pos) {
        try {
            this.reader.resetMark(pos);
            while (this.reader.hasNext(true)) {
                this.rowIn.skippedLines(this.reader.getLastSkippedLines());
                this.lastPos = this.reader.getCurrentStartPositionInBytes();
                String rowString = this.reader.currentWithDelimiter();
                if (this.rowIn.accepts(rowString)) {
                    ++this.rowNum;
                    if (!this.isForStream) {
                        this.rowNumToPosMap.put(this.rowNum, this.lastPos);
                    }
                    this.rowIn.setSource(rowString, this.rowNum, this.reader.getCurrentWithDelimiterLengthBytes());
                    this.rowIn.increaseLine();
                    return this.rowIn;
                }
                this.rowIn.skippedLine();
            }
            this.rowIn.skippedLines(this.reader.getLastSkippedLines());
            try {
                this.lastPos = this.input.getSize();
            }
            catch (IOException rowString) {
                // empty catch block
            }
            return null;
        }
        catch (Exception exception) {
            throw Error.error(484, exception);
        }
    }

    public ExternalFileTableCache getExternalFileTableCache() {
        return this.externalFileTableCache;
    }
}

