/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.rowio.AbstractRowInputText;
import com.streamscape.ds.lib.IntKeyHashMap;
import com.streamscape.ds.persist.CachedObject;
import com.streamscape.ds.persist.DataFileBlockManager;
import com.streamscape.ds.persist.ExternalFileTableIOManager;
import com.streamscape.ds.persist.FileTableCache;
import com.streamscape.ds.persist.FileTableIOManager;
import com.streamscape.ds.persist.FileTableSettings;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.PersistentStoreTypesCheckDelegate;
import com.streamscape.ds.persist.RandomAccessInputStream;
import com.streamscape.ds.schema.server.FileServerObject;
import com.streamscape.ds.schema.table.FileTable;
import com.streamscape.lib.fs.client.AbstractFileSystemClientConnection;
import com.streamscape.lib.fs.client.FileInfo;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.service.osf.clients.ClientConnection;
import java.io.IOException;
import java.io.OutputStream;

public class ExternalFileTableCache
extends FileTableCache {
    private FileServerObject fileServer;
    private ClientConnection connection = null;
    private FileSystem fs = null;
    private FileInfo fileInfo = null;
    private RandomAccessInputStream input = null;
    private OutputStream output = null;

    ExternalFileTableCache(FileTable table, FileServerObject fileServer) {
        super(table);
        this.table = table;
        this.fileServer = fileServer;
        this.uncommittedCache = new IntKeyHashMap();
    }

    @Override
    protected void doInit(String fileName) {
        this.fileTableSettings = this.table.getFileTableSettings(fileName);
        this.dataFileName = this.fileTableSettings.getFileName();
        if (this.dataFileName == null) {
            throw Error.error(301);
        }
        this.maxCacheRows = this.fileTableSettings.getMaxCacheRows();
        this.maxCacheBytes = this.fileTableSettings.getMaxCacheBytes();
        this.maxDataFileSize = Long.MAX_VALUE;
        this.cachedRowPadding = 1;
        this.cacheFileScale = 1;
    }

    @Override
    public void open(boolean readonly) {
        this.fileFreePosition = 0L;
        try {
            Trace.logDebug(this, "Opening up a client connection...");
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            ClassLoader systemClassLoaderChain = this.fileServer.getDataspace().getPackageManifestManager().getManifestClassLoader();
            Thread.currentThread().setContextClassLoader(systemClassLoaderChain);
            this.connection = this.fileServer.createConnection("FileTable$" + this.table.getObjectName().name);
            Trace.logDebug(this, "Connection created.");
            try {
                this.connection.connect();
            }
            catch (Throwable exception) {
                this.fileServer.removeConnection(this.connection);
                this.connection = null;
                throw exception;
            }
            finally {
                Thread.currentThread().setContextClassLoader(loader);
            }
            for (int counter = 0; this.connection.getState() != ConnectionState.OPEN && counter < 50; ++counter) {
                Thread.sleep(100L);
            }
            this.fs = ((AbstractFileSystemClientConnection)this.connection).getFileSystem();
            this.input = this.fs.openForRandomRead(this.dataFileName, this.fileTableSettings.readBufferSize);
            if (!readonly) {
                this.initAppendOutput();
            }
            this.fileInfo = this.fs.getInfo(this.dataFileName);
            this.fileFreePosition = this.fileInfo.getSize();
            this.initBuffers();
            this.freeBlocks = new DataFileBlockManager(0, this.cacheFileScale, 0, 0L);
            this.isCompressed = this.checkIfCompressed();
            this.ioManager = new ExternalFileTableIOManager(this.input, this, this.fileTableSettings, this.rowIn, this.rowOut, true, this.dataFileName, this.fileTableSettings.blockSize, this.table);
        }
        catch (Throwable t) {
            if (this.connection != null) {
                this.fileServer.removeConnection(this.connection);
            }
            throw Error.error(t, 452, 42, new Object[]{t.toString(), this.dataFileName});
        }
        this.cacheReadonly = readonly;
    }

    @Override
    public boolean isFileCompressed() {
        return this.isCompressed;
    }

    public OutputStream getOutput() {
        if (this.output == null) {
            this.initAppendOutput();
        }
        return this.output;
    }

    private void initAppendOutput() {
        block3: {
            if (this.cacheReadonly) {
                return;
            }
            try {
                this.output = this.fs.append(this.dataFileName, 1024);
            }
            catch (Exception exception) {
                Trace.logError(this, "WARNING: Cannot open append stream for source file " + this.dataFileName + " and file table " + this.table.getObjectName().getSchemaQualifiedStatementName());
                if (!Trace.isDebugEnabled(this.getClass())) break block3;
                Trace.logException(this, exception, true);
            }
        }
    }

    public ClientConnection getConnection() {
        return this.connection;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    private boolean checkIfCompressed() {
        return false;
    }

    @Override
    void reopen() {
        this.open(this.cacheReadonly);
    }

    @Override
    public void close(boolean write) {
        this.writeLock.lock();
        try {
            try {
                this.cache.saveAll();
            }
            catch (Throwable exception) {
                Trace.logException(this, exception, true);
            }
            try {
                if (this.output != null) {
                    this.output.flush();
                    this.output.close();
                    this.output = null;
                }
            }
            catch (Throwable exception) {
                Trace.logException(this, exception, true);
            }
            try {
                if (this.input != null) {
                    this.input.synch();
                    this.input.close();
                    this.input = null;
                }
            }
            catch (Throwable exception) {
                Trace.logException(this, exception, true);
            }
            try {
                if (this.fs != null) {
                    this.fs.close();
                }
            }
            catch (Throwable exception) {
                Trace.logException(this, exception, true);
            }
            try {
                if (this.connection != null) {
                    this.connection.disconnect();
                }
            }
            catch (Throwable exception) {
                Trace.logException(this, exception, true);
            }
            this.uncommittedCache.clear();
        }
        catch (Throwable t) {
            Trace.logException(this, t, true);
        }
        finally {
            if (this.connection != null) {
                this.fileServer.removeConnection(this.connection);
            }
            this.connection = null;
            this.writeLock.unlock();
        }
    }

    @Override
    void purge() {
        this.writeLock.lock();
        try {
            this.uncommittedCache.clear();
            this.close(false);
        }
        catch (Throwable t) {
            throw Error.error(t, 452, 44, new Object[]{t.toString(), this.dataFileName});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private int setFilePos(CachedObject r) {
        long newPosition = this.ioManager.allocateRow(r);
        if (newPosition > this.maxDataFileSize) {
            this.dataspaceStore.dataspaceLogger.logSevereEvent("data file reached maximum size " + this.dataFileName, null);
            throw Error.error(468);
        }
        this.clearRowImage(r);
        return r.getPos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remove(int pos, PersistentStore store) {
        this.writeLock.lock();
        try {
            CachedObject row = (CachedObject)this.uncommittedCache.remove(pos);
            if (row == null) {
                row = this.cache.release(pos);
            }
            if (row != null) {
                int n = row.getStorageSize();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void removePersistence(CachedObject row) {
        this.writeLock.lock();
        try {
            this.clearRowImage(row);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void clearRowImage(CachedObject row) {
        this.ioManager.clearRowImage(row);
    }

    @Override
    public void addInit(CachedObject object) {
        this.writeLock.lock();
        try {
            this.cache.put(object.getPos(), object);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void add(CachedObject object) {
        this.writeLock.lock();
        try {
            this.setFilePos(object);
            this.uncommittedCache.put(object.getPos(), object);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CachedObject get(CachedObject object, PersistentStore store, boolean keep) {
        if (object == null) {
            return null;
        }
        this.writeLock.lock();
        try {
            this.ioManager.readRow(object);
            boolean isTypesCheck = store instanceof PersistentStoreTypesCheckDelegate;
            try {
                this.rowIn.setTypesCheck(isTypesCheck);
                if (isTypesCheck) {
                    object = store.get(this.rowIn);
                } else {
                    store.get(this.rowIn);
                    this.cache.put(object.getPos(), object);
                }
            }
            finally {
                this.rowIn.setTypesCheck(false);
            }
            CachedObject cachedObject = object;
            return cachedObject;
        }
        catch (IOException err) {
            this.dataspaceStore.dataspaceLogger.logSevereEvent(this.dataFileName + " getFromFile problem " + object.getPos(), err);
            this.cache.forceCleanUp();
            System.gc();
            CachedObject cachedObject = object;
            return cachedObject;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public CachedObject get(int i, PersistentStore store, boolean keep) {
        throw Error.runtimeError(201, "TextCache");
    }

    @Override
    protected void saveRows(CachedObject[] rows, int offset, int count) {
    }

    @Override
    public void saveRow(CachedObject row) {
        this.writeLock.lock();
        try {
            this.setFileModified();
            this.ioManager.writeRow(row);
            this.uncommittedCache.remove(row.getPos());
            this.cache.put(row.getPos(), row);
        }
        catch (Throwable e) {
            this.dataspaceStore.dataspaceLogger.logSevereEvent("saveRow failed", e);
            throw Error.error(466, e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public String getHeader() {
        return this.header;
    }

    @Override
    public void setHeaderInitialise(String header) {
        this.header = header;
    }

    @Override
    public void setHeader(String header) {
        if (this.fileTableSettings.ignoreFirst && this.fileFreePosition == 0L) {
            try {
                this.fileFreePosition = this.ioManager.writeHeader(header, this.fileTableSettings.stringEncoding);
                this.header = header;
            }
            catch (DataspaceException e) {
                throw new DataspaceException(e, Error.getMessage(467), 467);
            }
            return;
        }
        throw Error.error(486);
    }

    @Override
    public int getLineNumber() {
        return ((AbstractRowInputText)this.rowIn).getLineNumber();
    }

    @Override
    public FileTableSettings getTextFileSettings() {
        return this.fileTableSettings;
    }

    @Override
    public boolean isIgnoreFirstLine() {
        return this.fileTableSettings.ignoreFirst;
    }

    @Override
    public int getIgnoreFirstLines() {
        return this.fileTableSettings.ignoreFirstLines;
    }

    @Override
    protected void setFileModified() {
        this.fileModified = true;
    }

    @Override
    public FileTableIOManager getIOManager() {
        return this.ioManager;
    }

    @Override
    public String getConvertedFileName() {
        return this.dataFileName + ".cmpz";
    }

    public void replaceinput(String target) {
        this.fileAccess.removeElement(this.dataFileName);
        this.fileAccess.renameElement(target, this.dataFileName);
    }
}

