/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.Version;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.HashMap;
import com.streamscape.ds.lib.HashSet;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.lib.Set;
import com.streamscape.ds.lib.StringUtil;
import com.streamscape.ds.persist.BaseStoreProperties;
import com.streamscape.ds.persist.DatastoreProperties;
import com.streamscape.ds.persist.StoreFilesState;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TimeZone;

public class DataspaceStoreProperties
extends BaseStoreProperties {
    private static final String dataspace_method_class_names = "dataspace.method_class_names";
    private static HashSet accessibleJavaMethodNames;
    public static final int SYSTEM_PROPERTY = 0;
    public static final int FILE_PROPERTY = 1;
    public static final int SQL_PROPERTY = 2;
    private static final HashMap dbMeta;
    private static final HashMap textMeta;
    public static final String THIS_VERSION;
    public static final String THIS_FULL_VERSION;
    public static final String THIS_CACHE_VERSION;
    public static final String PRODUCT_NAME = "StreamScape Dataspaces";
    public static final int MAJOR;
    public static final int MINOR;
    public static final int REVISION;
    public static final String system_lockfile_poll_retries_property = "dtspace.lockfile_poll_retries";
    public static final String system_max_char_or_varchar_display_size = "dtspace.max_char_or_varchar_display_size";
    public static final String dataspace_inc_backup = "dtspace.incremental_backup";
    public static final String dataspace_store_version = "dtspace.version";
    public static final String dataspace_store_readonly = "dtspace.readonly";
    public static final String runtime_gc_interval = "runtime.gc_interval";
    public static final String url_default_schema = "default_schema";
    public static final String url_check_props = "check_props";
    public static final String url_storage_class_name = "storage_class_name";
    public static final String url_fileaccess_class_name = "fileaccess_class_name";
    public static final String url_storage_key = "storage_key";
    public static final String url_crypt_key = "crypt_key";
    public static final String url_crypt_type = "crypt_type";
    public static final String url_crypt_provider = "crypt_provider";
    public static final String tx_management = "dtspace.tx_management";
    public static final String tx_level = "dtspace.tx_isolation_level";
    public static final String tx_conflict_rollback = "dtspace.tx_conflict_rollback";
    public static final String tx_conflict_spin_lock_timeout = "dtspace.tx_conflict_spin_lock_timeout";
    public static final String applog = "dtspace.applog";
    public static final String lob_file_scale = "dtspace.lob_file_scale";
    public static final String lob_in_mem = "dtspace.lob_in_mem";
    public static final String extended_sql_audit = "dtspace.extended_sql_audit";
    public static final String flob_location_path = "dtspace.flob_location_path";
    public static final String cache_file_scale = "dtspace.cache_file_scale";
    public static final String cache_free_count = "dtspace.cache_free_count_scale";
    public static final String cache_rows = "dtspace.cache_rows";
    public static final String cache_size = "dtspace.cache_size";
    public static final String default_memory_model = "dtspace.default_memory_model";
    public static final String defrag_limit = "dtspace.defrag_limit";
    public static final String files_readonly = "dtspace.files_readonly";
    public static final String log_data = "dtspace.log_data";
    public static final String log_size = "dtspace.log_size";
    public static final String log_size_critical = "dtspace.log_size_critical";
    public static final String nio_data_file = "dtspace.nio_data_file";
    public static final String nio_max_size = "dtspace.nio_max_size";
    public static final String script_format = "dtspace.script_format";
    public static final String temp_directory = "dtspace.temp_directory";
    public static final String result_max_memory_rows = "dtspace.result_max_memory_rows";
    public static final String write_delay = "dtspace.write_delay";
    public static final String write_delay_millis = "dtspace.write_delay_millis";
    public static final String exception_log_processing = "dtspace.exception_log_processing";
    public static final String checkpoint_interval = "dtspace.checkpoint_interval";
    public static final String checkpoint_interval_repeat = "dtspace.checkpoint_interval_repeat";
    public static final String checkpoint_interval_critical = "dtspace.checkpoint_interval_critical";
    public static final String checkpoint_lock_timeout1 = "dtspace.checkpoint_lock_timeout1";
    public static final String checkpoint_lock_timeout2 = "dtspace.checkpoint_lock_timeout2";
    public static final String checkpoint_check_consistency = "dtspace.checkpoint_check_consistency";
    public static final String query_mem_limit = "dtspace.query_mem_limit";
    public static final String query_mem_limit_chk_rows_start = "dtspace.query_mem_limit_chk_rows_start";
    public static final String query_mem_limit_chk_rows_interval = "dtspace.query_mem_limit_chk_rows_interval";
    public static final String typesafe = "dtspace.typesafe";
    public static final String timezone = "dtspace.timezone";
    public static final String index_operation_max_time = "dtspace.index_operation_max_time";
    public static final String sql_ref_integrity = "sql.ref_integrity";
    public static final String sql_compare_in_locale = "sql.compare_in_locale";
    public static final String sql_enforce_size = "sql.enforce_size";
    public static final String sql_enforce_strict_size = "sql.enforce_strict_size";
    public static final String sql_enforce_refs = "sql.enforce_refs";
    public static final String sql_enforce_names = "sql.enforce_names";
    public static final String sql_enforce_types = "sql.enforce_types";
    public static final String sql_enforce_tdcd = "sql.enforce_tdc_delete";
    public static final String sql_enforce_tdcu = "sql.enforce_tdc_update";
    public static final String sql_concat_nulls = "sql.concat_nulls";
    public static final String sql_nulls_first = "sql.nulls_first";
    public static final String sql_unique_nulls = "sql.unique_nulls";
    public static final String sql_convert_trunc = "sql.convert_trunc";
    public static final String sql_avg_scale = "sql.avg_scale";
    public static final String sql_double_nan = "sql.double_nan";
    public static final String jdbc_translate_tti_types = "jdbc.translate_tti_types";
    public static final String sql_identity_is_pk = "sql.identity_is_pk";
    public static final String sql_longvar_is_lob = "sql.longvar_is_lob";
    public static final String sql_pad_space = "sql.pad_space";
    public static final String sql_string_precision = "sql.string_precision";
    public static final String file_table_cache_scale = "file.cache_scale";
    public static final String file_table_cache_size_scale = "file.cache_size_scale";
    public static final String file_table_cache_rows = "file.cache_rows";
    public static final String file_table_cache_size = "file.cache_size";
    public static final String file_table_all_quoted = "file.all_quoted";
    public static final String file_table_allow_full_path = "file.allow_full_path";
    public static final String file_table_ignore_first = "file.ignore_first";
    public static final String file_table_ignore_first_lines = "file.ignore_first_lines";
    public static final String file_table_quoted = "file.quoted";
    public static final String file_table_fs = "file.fs";
    public static final String file_table_vs = "file.vs";
    public static final String file_table_lvs = "file.lvs";
    public static final String file_table_compression_block_size = "file.compression_block_size";
    public static final String file_read_buffer_size = "file.read_buffer_size";
    public static final String file_table_ignore_unknown_records = "file.file_table_ignore_unknown_records";
    public static final String file_ccsid = "file.ccsid";
    public static final String file_table_date_format = "file.date_format";
    public static final String file_table_sql_date_format = "file.sqldate_format";
    public static final String file_table_sql_time_format = "file.sqltime_format";
    public static final String file_table_sql_timestamp_format = "file.sqltimestamp_format";
    public static final String dtspace_default_schema = "dtspace.default_dataspace";
    public static final String dtspace_index_rpl = "text.engine.ds.index.rpl";
    public static final String text_engine_tx_sync_enable = "text.engine.tx.sync.enable";
    public static final String text_engine_lucene_max_buffered_docs = "text.engine.max_buffered_docs";
    public static final String text_engine_lucene_ram_buffered_size = "text.engine.ram_buffered_size";
    public static final String text_engine_lucene_ram_per_thread_hard_limit = "text.engine.ram_per_thread_hard_limit";
    public static final String text_engine_lucene_reader_pooling = "text.engine.reader_pooling";
    public static final String text_engine_lucene_use_compound_file = "text.engine.use_compound_file";
    public static final String qspace_expiration_thread_interval = "qspace.expiration_interval";
    public static final String dtspace_governor_unit_size = "dtspace.governor.unit_size";
    public static final String dtspace_governor_unit_est_time_ms = "dtspace.governor.unit_est_time_ms";
    public static final String dtspace_governor = "dtspace.governor";
    public static final String dtspace_serializer_date_format = "dtspace.serializer.date_format";
    public static final String dtspace_serializer_sql_date_format = "dtspace.serializer.sqldate_format";
    public static final String dtspace_serializer_sql_time_format = "dtspace.serializer.sqltime_format";
    public static final String dtspace_serializer_sql_timestamp_format = "dtspace.serializer.sqltimestamp_format";
    private DataspaceStore store;
    public static final int NO_MESSAGE = 1;

    public DataspaceStoreProperties(DataspaceStore store) {
        super(dbMeta, store.getPath(), store.dataspaceLogger.getFileAccess(), store.isFilesInJar());
        this.store = store;
        this.stringProps = store.properties;
    }

    public Set listProperties() {
        return dbMeta.keySet();
    }

    void setNewStoreProperties() {
        this.setProperty(dataspace_store_version, THIS_VERSION);
        this.store.setDBModified(StoreFilesState.NOT_MODIFIED_NEW);
        if (this.store.dataspaceLogger.isStoredFileAccess()) {
            this.setProperty(cache_rows, 25000);
            this.setProperty(cache_size, 6000);
            this.setProperty(log_size, 10);
            this.setProperty(log_size_critical, 20);
            this.setProperty(sql_enforce_size, true);
            this.setProperty(nio_data_file, false);
            this.setProperty(default_memory_model, "persistent");
            this.setProperty(jdbc_translate_tti_types, true);
        }
    }

    void filterLoadedProperties() {
        Enumeration<?> en = this.stringProps.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            boolean accept = dbMeta.containsKey(key);
            if (accept) continue;
            this.stringProps.remove(key);
        }
    }

    public void setURLProperties(BaseStoreProperties p) {
        boolean strict = false;
        if (p == null) {
            return;
        }
        String val = p.getProperty(sql_enforce_strict_size);
        if (val != null) {
            p.setProperty(sql_enforce_size, val);
            p.removeProperty(sql_enforce_strict_size);
        }
        strict = p.isPropertyTrue(url_check_props, false);
        for (String propertyName : p.propertyNames()) {
            String propertyValue = p.getProperty(propertyName);
            boolean valid = false;
            boolean validVal = false;
            String error = null;
            Object[] meta = (Object[])dbMeta.get(propertyName);
            if (meta != null && (Integer)meta[1] == 2) {
                valid = true;
                error = BaseStoreProperties.validateProperty(propertyName, propertyValue, meta);
                boolean bl = validVal = error == null;
            }
            if (!propertyName.startsWith("sql.") && !propertyName.startsWith("dtspace.") && !propertyName.startsWith("file.")) continue;
            if (strict && !valid) {
                throw Error.error(5555, propertyName);
            }
            if (!strict || validVal) continue;
            throw Error.error(5556, propertyName);
        }
        for (String propertyName : p.propertyNames()) {
            Object[] meta = (Object[])dbMeta.get(propertyName);
            if (meta == null || (Integer)meta[1] != 2) continue;
            this.setDatabaseProperty(propertyName, p.getProperty(propertyName));
        }
    }

    public Set getUserDefinedPropertyData() {
        HashSet set = new HashSet();
        Iterator it = dbMeta.values().iterator();
        while (it.hasNext()) {
            Object[] row = (Object[])it.next();
            if ((Integer)row[1] != 2) continue;
            set.add(row);
        }
        return set;
    }

    public boolean isUserDefinedProperty(String key) {
        Object[] row = (Object[])dbMeta.get(key);
        return row != null && (Integer)row[1] == 2;
    }

    public boolean isBoolean(String key) {
        Object[] row = (Object[])dbMeta.get(key);
        return row != null && row[2].equals("Boolean") && (Integer)row[1] == 2;
    }

    public boolean isIntegral(String key) {
        Object[] row = (Object[])dbMeta.get(key);
        return row != null && row[2].equals("Integer") && (Integer)row[1] == 2;
    }

    public boolean isString(String key) {
        Object[] row = (Object[])dbMeta.get(key);
        return row != null && row[2].equals("String") && (Integer)row[1] == 2;
    }

    public boolean setDatabaseProperty(String key, String value) {
        Object[] meta = (Object[])dbMeta.get(key);
        String error = BaseStoreProperties.validateProperty(key, value, meta);
        if (error != null) {
            return false;
        }
        this.stringProps.put(key, value);
        return true;
    }

    public int getDefaultWriteDelay() {
        if (this.store.dataspaceLogger.isStoredFileAccess()) {
            return 2000;
        }
        return 500;
    }

    public int getErrorLevel() {
        return 1;
    }

    public boolean divisionByZero() {
        return false;
    }

    @Override
    public String getProperty(String key) {
        Object[] metaData = (Object[])dbMeta.get(key);
        if (metaData == null) {
            throw Error.error(5555, key);
        }
        return this.stringProps.getProperty(key);
    }

    public String getPropertyString(String key) {
        boolean isSystem;
        Object[] metaData = (Object[])dbMeta.get(key);
        if (metaData == null) {
            throw Error.error(5555, key);
        }
        String prop = this.stringProps.getProperty(key);
        boolean bl = isSystem = (Integer)metaData[1] == 0;
        if (prop == null && isSystem) {
            prop = System.getProperty(key);
        }
        if (prop == null) {
            Object value = metaData[4];
            if (value == null) {
                return null;
            }
            return String.valueOf(value);
        }
        return prop;
    }

    @Override
    public boolean isPropertyTrue(String key) {
        boolean isSystem;
        Object[] metaData = (Object[])dbMeta.get(key);
        if (metaData == null) {
            throw Error.error(5555, key);
        }
        Boolean value = (Boolean)metaData[4];
        String prop = null;
        boolean bl = isSystem = (Integer)metaData[1] == 0;
        if (isSystem) {
            try {
                prop = System.getProperty(key);
            }
            catch (SecurityException securityException) {}
        } else {
            prop = this.stringProps.getProperty(key);
        }
        if (prop != null) {
            value = Boolean.valueOf(prop);
        }
        return value;
    }

    public String getStringProperty(String key) {
        Object[] metaData = (Object[])dbMeta.get(key);
        if (metaData == null) {
            throw Error.error(5555, key);
        }
        String value = (String)metaData[4];
        String prop = this.stringProps.getProperty(key);
        if (prop != null) {
            value = prop;
        }
        return value;
    }

    public int getIntegerProperty(String key) {
        Object[] metaData = (Object[])dbMeta.get(key);
        if (metaData == null) {
            throw Error.error(5555, key);
        }
        int value = (Integer)metaData[4];
        String prop = this.stringProps.getProperty(key);
        if (prop != null) {
            try {
                value = Integer.parseInt(prop);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    public boolean getBooleanProperty(String key) {
        Object[] metaData = (Object[])dbMeta.get(key);
        if (metaData == null) {
            throw Error.error(5555, key);
        }
        boolean value = (Boolean)metaData[4];
        String prop = this.stringProps.getProperty(key);
        if (prop != null) {
            try {
                value = Boolean.parseBoolean(prop);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    public static Iterator getPropertiesMetaIterator() {
        return dbMeta.values().iterator();
    }

    public String getClientPropertiesAsString() {
        if (this.isPropertyTrue(jdbc_translate_tti_types)) {
            StringBuffer sb = new StringBuffer(jdbc_translate_tti_types);
            sb.append('=').append(true);
            return sb.toString();
        }
        return "";
    }

    public static Properties getDefaults() {
        Properties props = new Properties();
        try {
            Iterator iter = DataspaceStoreProperties.getPropertiesMetaIterator();
            while (iter.hasNext()) {
                Object[] meta = (Object[])iter.next();
                Object propName = meta[0];
                Object value = meta[4];
                if (((String)meta[2]).equals("String")) {
                    if (value != null) {
                        props.put(propName, (String)value);
                        continue;
                    }
                    props.put(propName, "");
                    continue;
                }
                if (((String)meta[2]).equals("Boolean")) {
                    props.put(propName, ((Boolean)value).toString());
                    continue;
                }
                if (!((String)meta[2]).equals("Integer")) continue;
                props.put(propName, ((Integer)value).toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return props;
    }

    public DatastoreProperties.DatastorePropertyMeta getMeta(String key) {
        if (dbMeta.get(key) != null) {
            Object[] data = (Object[])dbMeta.get(key);
            DatastoreProperties.DatastorePropertyMeta meta = new DatastoreProperties.DatastorePropertyMeta();
            meta.name = (String)data[0];
            meta.propClass = (String)data[2];
            if (data[4] != null) {
                meta.defaultValue = data[4].toString();
            }
            if (data[2].equals("Integer")) {
                meta.isRange = data[3] == null ? Boolean.FALSE : (Boolean)data[3];
                if (data[5] != null) {
                    meta.low = (Integer)data[5];
                }
                if (data[6] != null) {
                    meta.high = (Integer)data[6];
                }
                if (data[7] != null) {
                    meta.values = (int[])data[7];
                }
            }
            return meta;
        }
        return null;
    }

    public static boolean supportsJavaMethod(String name) {
        if (accessibleJavaMethodNames == null) {
            return true;
        }
        if (name.startsWith("java.lang.Math.")) {
            return true;
        }
        if (accessibleJavaMethodNames.contains(name)) {
            return true;
        }
        Iterator it = accessibleJavaMethodNames.iterator();
        while (it.hasNext()) {
            String className = (String)it.next();
            int limit = className.lastIndexOf(".*");
            if (limit < 1 || !name.startsWith(className.substring(0, limit + 1))) continue;
            return true;
        }
        return false;
    }

    public static String getDefaultTimezone() {
        return TimeZone.getDefault().getID();
    }

    public static String getDefaultCCSID() {
        return StandardCharsets.UTF_8.toString();
    }

    static {
        try {
            String prop = System.getProperty(dataspace_method_class_names);
            if (prop != null) {
                accessibleJavaMethodNames = new HashSet();
                for (String name : StringUtil.split(prop, ";")) {
                    accessibleJavaMethodNames.add(name);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        dbMeta = new HashMap(67);
        textMeta = new HashMap(17);
        THIS_VERSION = Version.getVersion();
        THIS_FULL_VERSION = Version.getVersion();
        THIS_CACHE_VERSION = Version.getVersion();
        MAJOR = Version.getMajorVersion();
        MINOR = Version.getMinorVersion();
        REVISION = Version.getBuild();
        textMeta.put(file_table_allow_full_path, BaseStoreProperties.getMeta(file_table_allow_full_path, 2, false));
        textMeta.put(file_table_quoted, BaseStoreProperties.getMeta(file_table_quoted, 2, true));
        textMeta.put(file_table_all_quoted, BaseStoreProperties.getMeta(file_table_all_quoted, 2, false));
        textMeta.put(file_table_ignore_first, BaseStoreProperties.getMeta(file_table_ignore_first, 2, false));
        textMeta.put(file_table_ignore_first_lines, BaseStoreProperties.getMeta(file_table_ignore_first_lines, 2, 0, 0, Integer.MAX_VALUE));
        textMeta.put(file_table_fs, BaseStoreProperties.getMeta(file_table_fs, 2, ","));
        textMeta.put(file_table_vs, BaseStoreProperties.getMeta(file_table_vs, 2, ","));
        textMeta.put(file_table_lvs, BaseStoreProperties.getMeta(file_table_lvs, 2, ","));
        textMeta.put(file_table_cache_scale, BaseStoreProperties.getMeta(file_table_cache_scale, 2, 10, 8, 16));
        textMeta.put(file_table_cache_size_scale, BaseStoreProperties.getMeta(file_table_cache_size_scale, 2, 10, 6, 20));
        textMeta.put(file_table_cache_rows, BaseStoreProperties.getMeta(file_table_cache_rows, 2, 1000, 100, 1000000));
        textMeta.put(file_table_cache_size, BaseStoreProperties.getMeta(file_table_cache_size, 2, 100, 10, 1000000));
        textMeta.put(file_table_compression_block_size, BaseStoreProperties.getMeta(file_table_compression_block_size, 2, 4096, 256, 65536));
        textMeta.put(file_read_buffer_size, BaseStoreProperties.getMeta(file_read_buffer_size, 2, 4096, 1024, Integer.MAX_VALUE));
        textMeta.put(file_table_ignore_unknown_records, BaseStoreProperties.getMeta(file_table_ignore_unknown_records, 2, false));
        textMeta.put(file_table_date_format, BaseStoreProperties.getMeta(file_table_date_format, 2, "yyyy-MM-dd HH:mm:ss"));
        textMeta.put(file_table_sql_date_format, BaseStoreProperties.getMeta(file_table_sql_date_format, 2, "yyyy-MM-dd"));
        textMeta.put(file_table_sql_time_format, BaseStoreProperties.getMeta(file_table_sql_time_format, 2, "HH:mm:ss"));
        textMeta.put(file_table_sql_timestamp_format, BaseStoreProperties.getMeta(file_table_sql_timestamp_format, 2, "yyyy-MM-dd HH:mm:ss.SSS"));
        dbMeta.putAll(textMeta);
        dbMeta.put(dataspace_store_version, BaseStoreProperties.getMeta(dataspace_store_version, 1, null));
        dbMeta.put(dataspace_store_readonly, BaseStoreProperties.getMeta(dataspace_store_readonly, 1, false));
        dbMeta.put(files_readonly, BaseStoreProperties.getMeta(files_readonly, 1, false));
        dbMeta.put(tx_management, BaseStoreProperties.getMeta(tx_management, 2, "MVCC"));
        dbMeta.put(tx_level, BaseStoreProperties.getMeta(tx_level, 2, "READ_COMMITTED"));
        dbMeta.put(temp_directory, BaseStoreProperties.getMeta(temp_directory, 2, null));
        dbMeta.put(default_memory_model, BaseStoreProperties.getMeta(default_memory_model, 2, "MEMORY"));
        dbMeta.put(tx_conflict_rollback, BaseStoreProperties.getMeta(tx_conflict_rollback, 2, true));
        dbMeta.put(tx_conflict_spin_lock_timeout, BaseStoreProperties.getMeta(tx_conflict_spin_lock_timeout, 2, 0, 0, Integer.MAX_VALUE));
        dbMeta.put(jdbc_translate_tti_types, BaseStoreProperties.getMeta(jdbc_translate_tti_types, 2, true));
        dbMeta.put(dataspace_inc_backup, BaseStoreProperties.getMeta(dataspace_inc_backup, 2, true));
        dbMeta.put(log_data, BaseStoreProperties.getMeta(log_data, 2, true));
        dbMeta.put(nio_data_file, BaseStoreProperties.getMeta(nio_data_file, 2, true));
        dbMeta.put(exception_log_processing, BaseStoreProperties.getMeta(exception_log_processing, 2, false));
        dbMeta.put(sql_ref_integrity, BaseStoreProperties.getMeta(sql_ref_integrity, 2, true));
        dbMeta.put(sql_enforce_names, BaseStoreProperties.getMeta(sql_enforce_names, 2, false));
        dbMeta.put(sql_enforce_refs, BaseStoreProperties.getMeta(sql_enforce_refs, 2, false));
        dbMeta.put(sql_enforce_size, BaseStoreProperties.getMeta(sql_enforce_size, 2, false));
        dbMeta.put(sql_enforce_strict_size, BaseStoreProperties.getMeta(sql_enforce_strict_size, 2, true));
        dbMeta.put(sql_enforce_types, BaseStoreProperties.getMeta(sql_enforce_types, 2, false));
        dbMeta.put(sql_enforce_tdcd, BaseStoreProperties.getMeta(sql_enforce_tdcd, 2, true));
        dbMeta.put(sql_enforce_tdcu, BaseStoreProperties.getMeta(sql_enforce_tdcu, 2, true));
        dbMeta.put(sql_concat_nulls, BaseStoreProperties.getMeta(sql_concat_nulls, 2, true));
        dbMeta.put(sql_nulls_first, BaseStoreProperties.getMeta(sql_nulls_first, 2, true));
        dbMeta.put(sql_unique_nulls, BaseStoreProperties.getMeta(sql_unique_nulls, 2, true));
        dbMeta.put(sql_convert_trunc, BaseStoreProperties.getMeta(sql_convert_trunc, 2, true));
        dbMeta.put(sql_avg_scale, BaseStoreProperties.getMeta(sql_avg_scale, 2, 0, 0, 10));
        dbMeta.put(sql_double_nan, BaseStoreProperties.getMeta(sql_double_nan, 2, true));
        dbMeta.put(sql_compare_in_locale, BaseStoreProperties.getMeta(sql_compare_in_locale, 2, false));
        dbMeta.put(sql_identity_is_pk, BaseStoreProperties.getMeta(sql_identity_is_pk, 2, false));
        dbMeta.put(sql_longvar_is_lob, BaseStoreProperties.getMeta(sql_longvar_is_lob, 2, false));
        dbMeta.put(write_delay, BaseStoreProperties.getMeta(write_delay, 2, true));
        dbMeta.put(write_delay_millis, BaseStoreProperties.getMeta(write_delay_millis, 2, 500, 0, 10000));
        dbMeta.put(applog, BaseStoreProperties.getMeta(applog, 2, 0, 0, 2));
        dbMeta.put(script_format, BaseStoreProperties.getMeta(script_format, 2, "TEXT"));
        dbMeta.put(lob_file_scale, BaseStoreProperties.getMeta(lob_file_scale, 2, 1, new int[]{1, 2, 4, 8, 16, 32}));
        dbMeta.put(flob_location_path, BaseStoreProperties.getMeta(flob_location_path, 2, "./flobs"));
        dbMeta.put(lob_in_mem, BaseStoreProperties.getMeta(lob_in_mem, 2, false));
        dbMeta.put(extended_sql_audit, BaseStoreProperties.getMeta(extended_sql_audit, 2, false));
        dbMeta.put(cache_file_scale, BaseStoreProperties.getMeta(cache_file_scale, 2, 8, new int[]{1, 8, 16, 32, 64, 128}));
        dbMeta.put(sql_pad_space, BaseStoreProperties.getMeta(sql_pad_space, 2, true));
        dbMeta.put(sql_string_precision, BaseStoreProperties.getMeta(sql_string_precision, 2, Integer.MAX_VALUE, 0, Integer.MAX_VALUE));
        dbMeta.put(log_size, BaseStoreProperties.getMeta(log_size, 2, 50, 0, 1000));
        dbMeta.put(log_size_critical, BaseStoreProperties.getMeta(log_size_critical, 2, 150, 0, 1000));
        dbMeta.put(defrag_limit, BaseStoreProperties.getMeta(defrag_limit, 2, 20, 0, 100));
        dbMeta.put(runtime_gc_interval, BaseStoreProperties.getMeta(runtime_gc_interval, 2, 0, 0, 1000000));
        dbMeta.put(cache_size, BaseStoreProperties.getMeta(cache_size, 2, 10000, 100, 1000000));
        dbMeta.put(cache_rows, BaseStoreProperties.getMeta(cache_rows, 2, 50000, 100, 1000000));
        dbMeta.put(cache_free_count, BaseStoreProperties.getMeta(cache_free_count, 2, 512, 0, 4096));
        dbMeta.put(result_max_memory_rows, BaseStoreProperties.getMeta(result_max_memory_rows, 2, 0, 0, 1000000));
        dbMeta.put(nio_max_size, BaseStoreProperties.getMeta(nio_max_size, 2, 256, 64, 2048));
        dbMeta.put(qspace_expiration_thread_interval, BaseStoreProperties.getMeta(qspace_expiration_thread_interval, 2, 60, 0, 300));
        dbMeta.put(dtspace_governor_unit_size, BaseStoreProperties.getMeta(dtspace_governor_unit_size, 2, 1000000, 1, Integer.MAX_VALUE));
        dbMeta.put(dtspace_governor_unit_est_time_ms, BaseStoreProperties.getMeta(dtspace_governor_unit_est_time_ms, 2, 1000, 1, Integer.MAX_VALUE));
        dbMeta.put(dtspace_governor, BaseStoreProperties.getMeta(dtspace_governor, 2, false));
        dbMeta.put(dtspace_default_schema, BaseStoreProperties.getMeta(dtspace_default_schema, 2, "SYS"));
        dbMeta.put(checkpoint_interval, BaseStoreProperties.getMeta(checkpoint_interval, 2, "1 hr"));
        dbMeta.put(checkpoint_interval_repeat, BaseStoreProperties.getMeta(checkpoint_interval_repeat, 2, "1 min"));
        dbMeta.put(checkpoint_interval_critical, BaseStoreProperties.getMeta(checkpoint_interval_critical, 2, "6 hr"));
        dbMeta.put(checkpoint_lock_timeout1, BaseStoreProperties.getMeta(checkpoint_lock_timeout1, 2, "100"));
        dbMeta.put(checkpoint_lock_timeout2, BaseStoreProperties.getMeta(checkpoint_lock_timeout2, 2, "200"));
        dbMeta.put(checkpoint_check_consistency, BaseStoreProperties.getMeta(checkpoint_check_consistency, 2, false));
        dbMeta.put(index_operation_max_time, BaseStoreProperties.getMeta(index_operation_max_time, 2, "1 min"));
        dbMeta.put(query_mem_limit, BaseStoreProperties.getMeta(query_mem_limit, 2, 96, 0, 100));
        dbMeta.put(query_mem_limit_chk_rows_start, BaseStoreProperties.getMeta(query_mem_limit_chk_rows_start, 2, 1000, 0, Integer.MAX_VALUE));
        dbMeta.put(query_mem_limit_chk_rows_interval, BaseStoreProperties.getMeta(query_mem_limit_chk_rows_interval, 2, 200, 0, Integer.MAX_VALUE));
        dbMeta.put(typesafe, BaseStoreProperties.getMeta(typesafe, 2, true));
        dbMeta.put(timezone, BaseStoreProperties.getMeta(timezone, 2, DataspaceStoreProperties.getDefaultTimezone()));
        dbMeta.put(file_ccsid, BaseStoreProperties.getMeta(file_ccsid, 2, DataspaceStoreProperties.getDefaultCCSID()));
        dbMeta.put(dtspace_index_rpl, BaseStoreProperties.getMeta(dtspace_index_rpl, 2, true));
        dbMeta.put(text_engine_tx_sync_enable, BaseStoreProperties.getMeta(text_engine_tx_sync_enable, 2, false));
        dbMeta.put(text_engine_lucene_max_buffered_docs, BaseStoreProperties.getMeta(text_engine_lucene_max_buffered_docs, 2, -1, 0, Integer.MAX_VALUE));
        dbMeta.put(text_engine_lucene_ram_buffered_size, BaseStoreProperties.getMeta(text_engine_lucene_ram_buffered_size, 2, 16, 0, Integer.MAX_VALUE));
        dbMeta.put(text_engine_lucene_ram_per_thread_hard_limit, BaseStoreProperties.getMeta(text_engine_lucene_ram_per_thread_hard_limit, 2, 1945, 0, Integer.MAX_VALUE));
        dbMeta.put(text_engine_lucene_reader_pooling, BaseStoreProperties.getMeta(text_engine_lucene_reader_pooling, 2, true));
        dbMeta.put(text_engine_lucene_use_compound_file, BaseStoreProperties.getMeta(text_engine_lucene_use_compound_file, 2, true));
        dbMeta.put(dtspace_serializer_date_format, BaseStoreProperties.getMeta(dtspace_serializer_date_format, 2, "yyyy-MM-dd'T'HH:mm:ss'Z'"));
        dbMeta.put(dtspace_serializer_sql_date_format, BaseStoreProperties.getMeta(dtspace_serializer_sql_date_format, 2, "yyyy-MM-dd"));
        dbMeta.put(dtspace_serializer_sql_time_format, BaseStoreProperties.getMeta(dtspace_serializer_sql_time_format, 2, "HH:mm:ss"));
        dbMeta.put(dtspace_serializer_sql_timestamp_format, BaseStoreProperties.getMeta(dtspace_serializer_sql_timestamp_format, 2, "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
    }
}

