/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.persist.TableDuplicatesResolver;
import com.streamscape.ds.schema.DataspaceSchema;
import com.streamscape.ds.schema.table.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DataspaceStoreDuplicatesResolver {
    private final DataspaceStore dataspaceStore;

    public DataspaceStoreDuplicatesResolver(DataspaceStore dataspaceStore) {
        this.dataspaceStore = dataspaceStore;
    }

    public DataspaceStoreDuplicates findDuplicates(boolean withValues, boolean withFix) {
        long startTime = System.currentTimeMillis();
        DataspaceStoreDuplicates result = new DataspaceStoreDuplicates();
        for (DataspaceSchema schema : this.dataspaceStore.schemaManager.getAllSchemas()) {
            DataspaceDuplicatesResolver.DataspaceDuplicates duplicates = new DataspaceDuplicatesResolver(this.dataspaceStore, schema).findDuplicates(withValues, withFix);
            if (!duplicates.hasDuplicates()) continue;
            result.dataspaceDuplicates.add(new DataspaceDuplicatesResolver(this.dataspaceStore, schema).findDuplicates(withValues, withFix));
        }
        result.durationMs = System.currentTimeMillis() - startTime;
        return result;
    }

    public static class DataspaceStoreDuplicates {
        public List<DataspaceDuplicatesResolver.DataspaceDuplicates> dataspaceDuplicates = new ArrayList<DataspaceDuplicatesResolver.DataspaceDuplicates>();
        public long durationMs = 0L;

        public boolean hasDuplicates() {
            for (DataspaceDuplicatesResolver.DataspaceDuplicates dataspaceDuplicates : this.dataspaceDuplicates) {
                if (!dataspaceDuplicates.hasDuplicates()) continue;
                return true;
            }
            return false;
        }

        public List<String> getDuplicateDataspaceNames() {
            return this.dataspaceDuplicates.stream().filter(d -> d.getDuplicateKeysCount() > 0).map(d -> d.dataspaceName).collect(Collectors.toList());
        }

        public List<String> getDuplicateTableNames() {
            return this.dataspaceDuplicates.stream().flatMap(d -> d.getDuplicateTableNames().stream()).collect(Collectors.toList());
        }

        public int getDuplicateKeysCount() {
            return this.dataspaceDuplicates.stream().mapToInt(d -> d.getDuplicateKeysCount()).reduce(0, (a, b) -> a + b);
        }

        public void deleteValues() {
            this.dataspaceDuplicates.stream().forEach(i -> i.deleteValues());
        }
    }

    public static class DataspaceDuplicatesResolver {
        private final DataspaceStore dataspaceStore;
        private final DataspaceSchema schema;

        public DataspaceDuplicatesResolver(DataspaceStore dataspaceStore, DataspaceSchema schema) {
            this.dataspaceStore = dataspaceStore;
            this.schema = schema;
        }

        public DataspaceDuplicates findDuplicates(boolean withValues, boolean withFix) {
            DataspaceDuplicates result = new DataspaceDuplicates(this.schema.getName());
            Iterator tablesIterator = this.schema.getTables().values().iterator();
            while (tablesIterator.hasNext()) {
                Table table = (Table)tablesIterator.next();
                TableDuplicatesResolver resolver = new TableDuplicatesResolver(this.dataspaceStore, table);
                TableDuplicatesResolver.OrderBy orderBy = null;
                if (table.getObjectName().name.equals("SYSLDEF")) {
                    orderBy = new TableDuplicatesResolver.OrderBy("MODIFIED", true);
                }
                TableDuplicatesResolver.TableDuplicates tableDuplicates = resolver.findDuplicates(orderBy);
                if (withFix) {
                    for (TableDuplicatesResolver.TableIndexDuplicates indexDuplicates : tableDuplicates.indexDuplicates) {
                        if (indexDuplicates.duplicateValues.size() <= 0) continue;
                        resolver.fixDuplicates(indexDuplicates);
                    }
                }
                if (!tableDuplicates.hasDuplicates()) continue;
                if (!withValues) {
                    tableDuplicates.deleteValues();
                }
                result.tableDuplicates.add(tableDuplicates);
            }
            return result;
        }

        public static class DataspaceDuplicates {
            public String dataspaceName;
            public List<TableDuplicatesResolver.TableDuplicates> tableDuplicates;

            public DataspaceDuplicates(String dataspaceName) {
                this.dataspaceName = dataspaceName;
                this.tableDuplicates = new ArrayList<TableDuplicatesResolver.TableDuplicates>();
            }

            public boolean hasDuplicates() {
                for (TableDuplicatesResolver.TableDuplicates tableDuplicates : this.tableDuplicates) {
                    if (!tableDuplicates.hasDuplicates()) continue;
                    return true;
                }
                return false;
            }

            public List<String> getDuplicateTableNames() {
                return this.tableDuplicates.stream().filter(d -> d.getDuplicateKeysCount() > 0).map(d -> d.dataspaceName + "." + d.tableName).collect(Collectors.toList());
            }

            public int getDuplicateKeysCount() {
                return this.tableDuplicates.stream().mapToInt(d -> d.getDuplicateKeysCount()).reduce(0, (a, b) -> a + b);
            }

            public void deleteValues() {
                this.tableDuplicates.stream().forEach(i -> i.deleteValues());
            }
        }
    }
}

