/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.rowio.RowOutputInterface;
import com.streamscape.ds.lib.DoubleIntIndex;
import com.streamscape.ds.lib.HsqlArrayList;
import com.streamscape.ds.lib.StopWatch;
import com.streamscape.ds.lib.StringUtil;
import com.streamscape.ds.lib.store.BitMap;
import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.persist.DataFileCache;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.ScaledRAFile;
import com.streamscape.ds.persist.ScaledRAFileSimple;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.lib.file.RandomAccessInterface;
import java.io.IOException;

final class DataFileDefrag {
    RandomAccessInterface randomAccessOut;
    long fileOffset;
    StopWatch stopw = new StopWatch();
    String dataFileName;
    long[][] rootsList;
    DataspaceStore database;
    DataFileCache dataCache;
    int scale;
    DoubleIntIndex pointerLookup;

    DataFileDefrag(DataspaceStore db, DataFileCache cache, String dataFileName) {
        this.database = db;
        this.dataCache = cache;
        this.scale = cache.cacheFileScale;
        this.dataFileName = dataFileName;
    }

    void process() {
        int i;
        Throwable error = null;
        this.database.dataspaceLogger.logDetailEvent("Defrag process begins");
        HsqlArrayList allTables = this.database.schemaManager.getAllTables(true);
        this.rootsList = new long[allTables.size()][];
        long maxSize = 0L;
        int tSize = allTables.size();
        for (i = 0; i < tSize; ++i) {
            PersistentStore store;
            long size;
            Table table = (Table)allTables.get(i);
            if (table.getTableType() != 6 || (size = (store = this.database.persistentStoreCollection.getStore(table)).elementCount()) <= maxSize) continue;
            maxSize = size;
        }
        if (maxSize > 0x3FFFFFFFL) {
            throw Error.error(3426);
        }
        try {
            this.pointerLookup = new DoubleIntIndex((int)maxSize, false);
            this.randomAccessOut = this.database.dataspaceLogger.isStoredFileAccess() ? ScaledRAFile.newScaledRAFile(this.database, this.dataFileName + ".tmp", false, 3) : new ScaledRAFileSimple(this.database, this.dataFileName + ".tmp", "rw");
            this.randomAccessOut.write(new byte[this.dataCache.initialFreePos], 0, this.dataCache.initialFreePos);
            this.fileOffset = this.dataCache.initialFreePos;
            tSize = allTables.size();
            for (i = 0; i < tSize; ++i) {
                Table t = (Table)allTables.get(i);
                if (t.getTableType() == 6) {
                    long[] rootsArray = this.writeTableToDataFile(t);
                    this.rootsList[i] = rootsArray;
                    this.randomAccessOut.synch();
                } else {
                    this.rootsList[i] = null;
                }
                this.database.dataspaceLogger.logDetailEvent("table complete " + t.getObjectName().name);
            }
            this.randomAccessOut.seek(12L);
            this.randomAccessOut.writeLong(this.fileOffset);
            int flags = 0;
            if (this.database.dataspaceLogger.propIncrementBackup) {
                flags = BitMap.set(flags, 1);
            }
            flags = BitMap.set(flags, 4);
            flags = BitMap.set(flags, 2);
            this.randomAccessOut.seek(28L);
            this.randomAccessOut.writeInt(flags);
            this.randomAccessOut.synch();
            this.randomAccessOut.close();
            this.randomAccessOut = null;
            for (long[] roots : this.rootsList) {
                if (roots == null) continue;
                this.database.dataspaceLogger.logDetailEvent("roots: " + StringUtil.getList(roots, ",", ""));
            }
        }
        catch (IOException e) {
            error = e;
            throw Error.error(452, e);
        }
        catch (OutOfMemoryError e) {
            error = e;
            throw Error.error(460, e);
        }
        catch (Throwable t) {
            error = t;
            throw Error.error(458, t);
        }
        finally {
            try {
                if (this.randomAccessOut != null) {
                    this.randomAccessOut.close();
                }
            }
            catch (Throwable throwable) {}
            if (error instanceof OutOfMemoryError) {
                this.database.dataspaceLogger.logInfoEvent("defrag failed - out of memory - required: " + maxSize * 8L);
            }
            if (error == null) {
                this.database.dataspaceLogger.logDetailEvent("Defrag transfer complete: " + this.stopw.elapsedTime());
                this.database.dataspaceLogger.getFileAccess().renameElement(this.dataFileName + ".tmp", this.dataFileName + ".new");
            } else {
                this.database.dataspaceLogger.logSevereEvent("defrag failed ", error);
                Trace.logException(this, error, true);
                this.database.dataspaceLogger.getFileAccess().removeElement(this.dataFileName + ".tmp");
            }
        }
    }

    void updateTableIndexRoots() {
        HsqlArrayList allTables = this.database.schemaManager.getAllTables(true);
        int size = allTables.size();
        for (int i = 0; i < size; ++i) {
            Table t = (Table)allTables.get(i);
            if (t.getTableType() != 6) continue;
            long[] rootsArray = this.rootsList[i];
            t.setIndexRoots(rootsArray);
        }
    }

    long[] writeTableToDataFile(Table table) throws IOException {
        Row row;
        Session session = this.database.getSessionManager().getSysSession();
        PersistentStore store = table.getRowStore(session);
        RowOutputInterface rowOut = this.dataCache.rowOut.duplicate();
        long[] rootsArray = table.getIndexRootsArray();
        long pos = this.fileOffset;
        long count = 0L;
        this.pointerLookup.removeAll();
        this.pointerLookup.setKeysSearchTarget();
        this.database.dataspaceLogger.logDetailEvent("lookup begins " + table.getObjectName().name + " " + this.stopw.elapsedTime());
        RowIterator it = table.rowIteratorClustered(store);
        while (it.hasNext()) {
            row = it.getNextRow();
            this.pointerLookup.addUnsorted(row.getPos(), (int)(pos / (long)this.scale));
            if (count != 0L && count % 100000L == 0L) {
                this.database.dataspaceLogger.logDetailEvent("pointer pair for row " + count + " " + row.getPos() + " " + pos);
            }
            pos += (long)row.getStorageSize();
            ++count;
        }
        this.database.dataspaceLogger.logDetailEvent("table read " + table.getObjectName().name + " " + this.stopw.elapsedTime());
        count = 0L;
        it = table.rowIteratorClustered(store);
        while (it.hasNext()) {
            row = it.getNextRow();
            rowOut.reset();
            row.write(rowOut, this.pointerLookup);
            this.randomAccessOut.write(rowOut.getOutputStream().getBuffer(), 0, rowOut.size());
            this.fileOffset += (long)row.getStorageSize();
            if (count != 0L && count % 100000L == 0L) {
                this.database.dataspaceLogger.logDetailEvent("rows count " + count + " " + this.stopw.elapsedTime());
            }
            ++count;
        }
        for (int i = 0; i < table.getIndexCount(); ++i) {
            if (rootsArray[i] == -1L) continue;
            int lookupIndex = this.pointerLookup.findFirstEqualKeyIndex((int)rootsArray[i]);
            if (lookupIndex == -1) {
                throw Error.error(466);
            }
            rootsArray[i] = this.pointerLookup.getValue(lookupIndex);
        }
        this.database.dataspaceLogger.logDetailEvent("table written " + table.getObjectName().name);
        return rootsArray;
    }

    public long[][] getIndexRoots() {
        return this.rootsList;
    }
}

