/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.FileUtil;
import com.streamscape.ds.persist.DataFileBlockManager;
import com.streamscape.ds.persist.DataFileCache;
import com.streamscape.ds.persist.ScaledRAFile;

public class DataFileCacheSession
extends DataFileCache {
    public int storeCount;

    public DataFileCacheSession(DataspaceStore dataspaceStore) {
        super(dataspaceStore);
    }

    @Override
    protected void doInit(String fileName) {
        this.dataFileName = fileName + ".data.tmp";
        this.fileAccess = FileUtil.getFileUtil();
        this.cachedRowPadding = this.cacheFileScale = 64;
        this.initialFreePos = this.cacheFileScale;
        this.maxCacheRows = 2048;
        this.maxCacheBytes = this.maxCacheRows * 1024;
        this.maxDataFileSize = Integer.MAX_VALUE * (long)this.cacheFileScale;
        this.dataFile = null;
    }

    @Override
    public void open(boolean readonly) {
        try {
            this.dataFile = new ScaledRAFile(this.dataspaceStore, this.dataFileName, false, false);
            this.fileFreePosition = this.initialFreePos;
            this.initBuffers();
            this.freeBlocks = new DataFileBlockManager(0, this.cacheFileScale, 0, 0L);
        }
        catch (Throwable t) {
            this.dataspaceStore.dataspaceLogger.logWarningEvent("Failed to open Session RA file", t);
            this.close(false);
            throw Error.error(t, 452, 52, new Object[]{t.toString(), this.dataFileName});
        }
    }

    @Override
    public void close(boolean write) {
        this.writeLock.lock();
        try {
            this.cache.clear();
            if (this.dataFile != null) {
                this.dataFile.close();
                this.dataFile = null;
                this.fileAccess.removeElement(this.dataFileName);
            }
        }
        catch (Throwable t) {
            this.dataspaceStore.dataspaceLogger.logWarningEvent("Failed to close Session RA file", t);
            throw Error.error(t, 452, 53, new Object[]{t.toString(), this.dataFileName});
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

