/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.rowio.RowInputBinaryDecode;
import com.streamscape.ds.io.rowio.RowInputInterface;
import com.streamscape.ds.io.rowio.RowOutputBinaryEncode;
import com.streamscape.ds.io.rowio.RowOutputInterface;
import com.streamscape.ds.lib.FileAccess;
import com.streamscape.ds.lib.FileArchiver;
import com.streamscape.ds.lib.FileUtil;
import com.streamscape.ds.lib.StopWatch;
import com.streamscape.ds.lib.store.BitMap;
import com.streamscape.ds.persist.Cache;
import com.streamscape.ds.persist.CachedObject;
import com.streamscape.ds.persist.DataFileBlockManager;
import com.streamscape.ds.persist.DataFileDefrag;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.PersistentStoreTypesCheckDelegate;
import com.streamscape.ds.persist.RAShadowFile;
import com.streamscape.ds.persist.ScaledRAFile;
import com.streamscape.ds.persist.ScaledRAFileSimple;
import com.streamscape.ds.persist.StoreFilesState;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.lib.file.RandomAccessInterface;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DataFileCache {
    protected FileAccess fileAccess;
    public static final int FLAG_ISSHADOWED = 1;
    public static final int FLAG_ISSAVED = 2;
    public static final int FLAG_ROWINFO = 3;
    public static final int FLAG_190 = 4;
    public static final int FLAG_HX = 5;
    static final int LONG_EMPTY_SIZE = 4;
    static final int LONG_FREE_POS_POS = 12;
    static final int LONG_EMPTY_INDEX_POS = 20;
    static final int FLAGS_POS = 28;
    static final int MIN_INITIAL_FREE_POS = 32;
    DataFileBlockManager freeBlocks;
    private static final int initIOBufferSize = 256;
    protected String dataFileName;
    protected String backupFileName;
    protected DataspaceStore dataspaceStore;
    protected boolean fileModified;
    protected boolean cacheModified;
    protected int cacheFileScale;
    protected boolean cacheReadonly;
    protected int cachedRowPadding;
    protected int initialFreePos;
    protected long fileStartFreePosition;
    protected boolean hasRowInfo = false;
    protected int storeCount;
    protected RowInputInterface rowIn;
    public RowOutputInterface rowOut;
    public long maxDataFileSize;
    protected RandomAccessInterface dataFile;
    protected volatile long fileFreePosition;
    protected int maxCacheRows;
    protected long maxCacheBytes;
    protected Cache cache;
    private RAShadowFile shadowFile;
    ReadWriteLock lock = new ReentrantReadWriteLock();
    Lock readLock = this.lock.readLock();
    Lock writeLock = this.lock.writeLock();
    StopWatch shadowCopyTimer = new StopWatch(false);

    public DataFileCache(DataspaceStore dataspaceStore) {
        this.dataspaceStore = dataspaceStore;
    }

    public final void init(String fileName) {
        this.doInit(fileName);
        this.cache = new Cache(this);
    }

    protected void doInit(String fileName) {
        this.dataFileName = fileName + ".dat";
        this.backupFileName = fileName + ".backup";
        this.fileAccess = this.dataspaceStore.dataspaceLogger.getFileAccess();
        this.cacheFileScale = this.dataspaceStore.dataspaceLogger.getCacheFileScale();
        this.cachedRowPadding = 8;
        if (this.cacheFileScale > 8) {
            this.cachedRowPadding = this.cacheFileScale;
        }
        this.initialFreePos = 32;
        if (this.initialFreePos < this.cacheFileScale) {
            this.initialFreePos = this.cacheFileScale;
        }
        this.cacheReadonly = this.dataspaceStore.dataspaceLogger.propFilesReadOnly;
        this.maxCacheRows = this.dataspaceStore.dataspaceLogger.propCacheMaxRows;
        this.maxCacheBytes = this.dataspaceStore.dataspaceLogger.propCacheMaxSize;
        this.maxDataFileSize = Integer.MAX_VALUE * (long)this.cacheFileScale;
        this.dataFile = null;
        this.shadowFile = null;
    }

    public void open(boolean readonly) {
        this.fileFreePosition = this.initialFreePos;
        this.dataspaceStore.dataspaceLogger.logInfoEvent("dataFileCache open start");
        try {
            boolean existsBackup;
            boolean isNio = this.dataspaceStore.dataspaceLogger.propNioDataFile;
            int fileType = this.dataspaceStore.dataspaceLogger.isStoredFileAccess() ? 3 : (this.dataspaceStore.isFilesInJar() ? 2 : (isNio ? 1 : 0));
            if (readonly || this.dataspaceStore.isFilesInJar()) {
                this.dataFile = ScaledRAFile.newScaledRAFile(this.dataspaceStore, this.dataFileName, readonly, fileType);
                this.dataFile.seek(28L);
                int flags = this.dataFile.readInt();
                if (BitMap.isSet(flags, 5)) {
                    throw Error.error(453);
                }
                this.dataFile.seek(12L);
                this.fileFreePosition = this.dataFile.readLong();
                this.initBuffers();
                return;
            }
            long freesize = 0L;
            boolean preexists = this.fileAccess.isStreamElement(this.dataFileName);
            boolean isIncremental = this.dataspaceStore.dataspaceLogger.propIncrementBackup;
            boolean isSaved = false;
            if (preexists) {
                this.dataFile = this.dataspaceStore.dataspaceLogger.isStoredFileAccess() ? ScaledRAFile.newScaledRAFile(this.dataspaceStore, this.dataFileName, true, 3) : new ScaledRAFileSimple(this.dataspaceStore, this.dataFileName, "r");
                long length = this.dataFile.length();
                boolean wrongVersion = false;
                if (length > (long)this.initialFreePos) {
                    this.dataFile.seek(28L);
                    int flags = this.dataFile.readInt();
                    isSaved = BitMap.isSet(flags, 2);
                    isIncremental = BitMap.isSet(flags, 1);
                    if (BitMap.isSet(flags, 5)) {
                        wrongVersion = true;
                    }
                }
                this.dataFile.close();
                if (length > this.maxDataFileSize) {
                    throw Error.error(453, "requires large database support");
                }
                if (wrongVersion) {
                    throw Error.error(453);
                }
            }
            if (isSaved && isIncremental && (existsBackup = this.fileAccess.isStreamElement(this.backupFileName))) {
                isSaved = false;
            }
            if (isSaved) {
                if (isIncremental) {
                    this.deleteBackup();
                } else {
                    boolean existsBackup2 = this.fileAccess.isStreamElement(this.backupFileName);
                    if (!existsBackup2) {
                        this.backupFile(false);
                    }
                }
            } else {
                preexists = isIncremental ? this.restoreBackupIncremental() : this.restoreBackup();
            }
            this.dataFile = ScaledRAFile.newScaledRAFile(this.dataspaceStore, this.dataFileName, readonly, fileType);
            if (preexists) {
                this.dataFile.seek(28L);
                this.dataFile.readInt();
                this.dataFile.seek(4L);
                freesize = this.dataFile.readLong();
                this.dataFile.seek(12L);
                this.fileStartFreePosition = this.fileFreePosition = this.dataFile.readLong();
                this.openShadowFile();
            } else {
                this.initNewFile();
            }
            this.initBuffers();
            this.fileModified = false;
            this.cacheModified = false;
            this.freeBlocks = new DataFileBlockManager(this.dataspaceStore.dataspaceLogger.propMaxFreeBlocks, this.cacheFileScale, 0, freesize);
            this.dataspaceStore.dataspaceLogger.logInfoEvent("dataFileCache open end");
        }
        catch (Throwable t) {
            this.dataspaceStore.dataspaceLogger.logSevereEvent("dataFileCache open failed", t);
            this.close(false);
            throw Error.error(t, 452, 52, new Object[]{t.toString(), this.dataFileName});
        }
    }

    private void initNewFile() throws IOException {
        this.fileFreePosition = this.initialFreePos;
        this.fileStartFreePosition = this.initialFreePos;
        this.dataFile.seek(12L);
        this.dataFile.writeLong(this.fileFreePosition);
        int flags = 0;
        if (this.dataspaceStore.dataspaceLogger.propIncrementBackup) {
            flags = BitMap.set(flags, 1);
        }
        flags = BitMap.set(flags, 2);
        flags = BitMap.set(flags, 4);
        this.dataFile.seek(28L);
        this.dataFile.writeInt(flags);
        this.dataFile.synch();
    }

    void openShadowFile() {
        if (this.dataspaceStore.dataspaceLogger.propIncrementBackup && this.fileFreePosition != (long)this.initialFreePos) {
            this.shadowFile = new RAShadowFile(this.dataspaceStore, this.dataFile, this.backupFileName, this.fileFreePosition, 16384);
        }
    }

    void setIncrementBackup(boolean value) {
        this.writeLock.lock();
        try {
            this.dataFile.seek(28L);
            int flags = this.dataFile.readInt();
            flags = value ? BitMap.set(flags, 1) : BitMap.unset(flags, 1);
            this.dataFile.seek(28L);
            this.dataFile.writeInt(flags);
            this.dataFile.synch();
            this.fileModified = true;
        }
        catch (Throwable t) {
            this.dataspaceStore.dataspaceLogger.logSevereEvent("backupFile failed", t);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private boolean restoreBackup() {
        this.deleteFile();
        try {
            FileAccess fa = this.dataspaceStore.dataspaceLogger.getFileAccess();
            if (fa.isStreamElement(this.backupFileName)) {
                FileArchiver.unarchive(this.backupFileName, this.dataFileName, fa, 1);
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            throw Error.error(t, 452, 26, new Object[]{t.toString(), this.backupFileName});
        }
    }

    private boolean restoreBackupIncremental() {
        try {
            if (this.fileAccess.isStreamElement(this.backupFileName)) {
                RAShadowFile.restoreFile(this.dataspaceStore, this.backupFileName, this.dataFileName);
                this.deleteBackup();
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw Error.error(452, e);
        }
    }

    public void close(boolean write) {
        this.writeLock.lock();
        try {
            boolean empty;
            if (this.dataFile == null) {
                return;
            }
            if (write) {
                this.commitChanges();
            } else if (this.shadowFile != null) {
                this.shadowFile.close();
                this.shadowFile = null;
            }
            this.dataFile.close();
            this.dataspaceStore.dataspaceLogger.logDetailEvent("dataFileCache file close");
            this.dataFile = null;
            if (!write) {
                return;
            }
            boolean bl = empty = this.fileFreePosition == (long)this.initialFreePos;
            if (empty) {
                this.deleteFile();
                this.deleteBackup();
            }
        }
        catch (DataspaceException e) {
            throw e;
        }
        catch (Throwable t) {
            this.dataspaceStore.dataspaceLogger.logSevereEvent("dataFileCache close failed", t);
            throw Error.error(t, 452, 53, new Object[]{t.toString(), this.dataFileName});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void clear() {
        this.writeLock.lock();
        try {
            this.cache.clear();
            this.fileStartFreePosition = this.fileFreePosition = (long)this.initialFreePos;
            this.freeBlocks.clear();
            this.initBuffers();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void adjustStoreCount(int adjust) {
        this.writeLock.lock();
        try {
            this.storeCount += adjust;
            if (this.storeCount == 0) {
                if (this.shadowFile == null) {
                    this.clear();
                } else {
                    this.cache.clear();
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void commitChanges() {
        this.writeLock.lock();
        try {
            if (this.cacheReadonly) {
                return;
            }
            this.dataspaceStore.dataspaceLogger.logInfoEvent("dataFileCache commit start");
            this.cache.saveAll();
            this.dataspaceStore.dataspaceLogger.logDetailEvent("dataFileCache save data");
            if (this.fileModified || this.freeBlocks.isModified()) {
                this.dataFile.seek(4L);
                this.dataFile.writeLong(this.freeBlocks.getLostBlocksSize());
                this.dataFile.seek(12L);
                this.dataFile.writeLong(this.fileFreePosition);
                this.dataFile.seek(28L);
                int flags = this.dataFile.readInt();
                flags = BitMap.set(flags, 2);
                this.dataFile.seek(28L);
                this.dataFile.writeInt(flags);
            }
            this.dataFile.synch();
            this.fileModified = false;
            this.cacheModified = false;
            if (this.shadowFile != null) {
                this.shadowFile.close();
                this.shadowFile = null;
            }
            this.dataspaceStore.dataspaceLogger.logDetailEvent("dataFileCache commit end");
        }
        catch (Throwable t) {
            this.dataspaceStore.dataspaceLogger.logSevereEvent("dataFileCache commit failed", t);
            throw Error.error(t, 452, 53, new Object[]{t.toString(), this.dataFileName});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void initBuffers() {
        if (this.rowOut == null || this.rowOut.getOutputStream().getBuffer().length > 256) {
            this.rowOut = new RowOutputBinaryEncode(this.dataspaceStore.dataspaceLogger.getCrypto(), 256, this.cachedRowPadding);
        }
        if (this.rowIn == null || this.rowIn.getBuffer().length > 256) {
            this.rowIn = new RowInputBinaryDecode(this.dataspaceStore.dataspaceLogger.getCrypto(), new byte[256]);
        }
    }

    DataFileDefrag defrag() {
        this.writeLock.lock();
        try {
            this.cache.saveAll();
            DataFileDefrag dfd = new DataFileDefrag(this.dataspaceStore, this, this.dataFileName);
            dfd.process();
            this.close(true);
            this.cache.clear();
            if (!this.dataspaceStore.dataspaceLogger.propIncrementBackup) {
                this.backupFile(false);
            }
            this.dataspaceStore.schemaManager.setTempIndexRoots(dfd.getIndexRoots());
            try {
                this.dataspaceStore.dataspaceLogger.log.writeLog(false);
            }
            finally {
                this.dataspaceStore.schemaManager.setTempIndexRoots(null);
            }
            this.dataspaceStore.getProperties().setProperty("dtspace.script_format", this.dataspaceStore.dataspaceLogger.propScriptFormat);
            this.dataspaceStore.setDBModified(StoreFilesState.MODIFIED_NEW);
            this.dataspaceStore.dataspaceLogger.log.closeRecoveryLog();
            this.dataspaceStore.dataspaceLogger.log.deleteRecoveryLog();
            this.dataspaceStore.dataspaceLogger.log.renameNewLog();
            this.renameBackupFile();
            this.renameDataFile();
            this.dataspaceStore.setDBModified(StoreFilesState.NOT_MODIFIED);
            this.open(false);
            this.dataspaceStore.schemaManager.setIndexRoots(dfd.getIndexRoots());
            if (this.dataspaceStore.dataspaceLogger.log.dbLogWriter != null) {
                this.dataspaceStore.dataspaceLogger.log.openRecoveryLog(this.dataspaceStore.isRecoveryFailed());
            }
            this.dataspaceStore.setDBModified(StoreFilesState.MODIFIED);
            DataFileDefrag dataFileDefrag = dfd;
            return dataFileDefrag;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int remove(int i, PersistentStore store) {
        this.writeLock.lock();
        try {
            CachedObject r = this.release(i);
            if (r != null) {
                int size = r.getStorageSize();
                this.freeBlocks.add(i, size);
                int n = size;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removePersistence(CachedObject object) {
    }

    private int setFilePos(CachedObject r) {
        int rowSize = r.getStorageSize();
        int i = this.freeBlocks.get(rowSize);
        if (i == -1) {
            i = (int)(this.fileFreePosition / (long)this.cacheFileScale);
            long newFreePosition = this.fileFreePosition + (long)rowSize;
            if (newFreePosition > this.maxDataFileSize) {
                this.dataspaceStore.dataspaceLogger.logSevereEvent("data file reached maximum size " + this.dataFileName, null);
                throw Error.error(468);
            }
            boolean result = this.dataFile.ensureLength(newFreePosition);
            if (!result) {
                this.dataspaceStore.dataspaceLogger.logSevereEvent("data file cannot be enlarged - disk space " + this.dataFileName, null);
                throw Error.error(468);
            }
            this.fileFreePosition = newFreePosition;
        }
        r.setPos(i);
        return i;
    }

    public void add(CachedObject object) {
        this.writeLock.lock();
        try {
            this.cacheModified = true;
            int i = this.setFilePos(object);
            this.cache.put(i, object);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStorageSize(int i) {
        this.readLock.lock();
        try {
            CachedObject value = this.cache.get(i);
            if (value != null) {
                int n = value.getStorageSize();
                return n;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.readSize(i);
    }

    public void replace(CachedObject object) {
        this.writeLock.lock();
        try {
            int pos = object.getPos();
            this.cache.replace(pos, object);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject get(CachedObject object, PersistentStore store, boolean keep) {
        int pos;
        this.readLock.lock();
        try {
            if (object.isInMemory()) {
                if (keep) {
                    object.keepInMemory(true);
                }
                CachedObject cachedObject = object;
                return cachedObject;
            }
            pos = object.getPos();
            if (pos < 0) {
                CachedObject cachedObject = null;
                return cachedObject;
            }
            object = this.cache.get(pos);
            if (object != null) {
                if (keep) {
                    object.keepInMemory(true);
                }
                CachedObject cachedObject = object;
                return cachedObject;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.getFromFile(pos, store, keep, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject get(int pos, PersistentStore store, boolean keep) {
        if (pos < 0) {
            return null;
        }
        this.readLock.lock();
        try {
            CachedObject object = this.cache.get(pos);
            if (object != null) {
                if (keep) {
                    object.keepInMemory(true);
                }
                CachedObject cachedObject = object;
                return cachedObject;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.getFromFile(pos, store, keep, false);
    }

    CachedObject getFromFile(int pos, PersistentStore store, boolean keep, boolean isTypesCheck) {
        CachedObject object = null;
        this.writeLock.lock();
        try {
            if (!isTypesCheck && (object = this.cache.get(pos)) != null) {
                if (keep) {
                    object.keepInMemory(true);
                }
                CachedObject cachedObject = object;
                return cachedObject;
            }
            isTypesCheck = store instanceof PersistentStoreTypesCheckDelegate;
            for (int j = 0; j < 2; ++j) {
                RowInputInterface rowInput;
                block16: {
                    rowInput = null;
                    try {
                        rowInput = this.readObject(pos);
                        if (rowInput != null) break block16;
                        CachedObject cachedObject = null;
                        return cachedObject;
                    }
                    catch (OutOfMemoryError err) {
                        if (rowInput != null) {
                            rowInput.setTypesCheck(false);
                        }
                        this.cache.forceCleanUp();
                        System.gc();
                        this.dataspaceStore.dataspaceLogger.logSevereEvent(this.dataFileName + " getFromFile out of mem " + pos + ", while reading row of size " + String.valueOf(rowInput != null ? Integer.valueOf(rowInput.getSize()) : "unknown") + ", from table '" + (store.getTable() instanceof Table && ((Table)store.getTable()).getObjectName() != null ? ((Table)store.getTable()).getObjectName().getSchemaQualifiedStatementName() : "unknown"), err);
                        Trace.logException(this, err, true);
                        if (j <= 0) continue;
                        throw err;
                    }
                }
                rowInput.setTypesCheck(isTypesCheck);
                object = store.get(rowInput);
                break;
            }
            pos = object.getPos();
            if (!isTypesCheck) {
                this.cache.put(pos, object);
            }
            if (keep) {
                object.keepInMemory(true);
            }
            store.set(object);
            CachedObject j = object;
            return j;
        }
        catch (DataspaceException e) {
            this.dataspaceStore.dataspaceLogger.logSevereEvent(this.dataFileName + " getFromFile " + pos + ", while reading from table '" + (store.getTable() instanceof Table && ((Table)store.getTable()).getObjectName() != null ? ((Table)store.getTable()).getObjectName().getSchemaQualifiedStatementName() : "unknown"), e);
            Trace.logException(this, e, true);
            throw e;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    RowInputInterface getRaw(int i) {
        this.writeLock.lock();
        try {
            RowInputInterface rowInputInterface = this.readObject(i);
            return rowInputInterface;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected int readSize(int pos) {
        this.writeLock.lock();
        try {
            this.dataFile.seek((long)pos * (long)this.cacheFileScale);
            int n = this.dataFile.readInt();
            return n;
        }
        catch (IOException e) {
            throw Error.error(466, e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected RowInputInterface readObject(int pos) {
        int size = -1;
        try {
            this.dataFile.seek((long)pos * (long)this.cacheFileScale);
            size = this.dataFile.readInt();
            try {
                this.rowIn.resetRow(pos, size);
                this.dataFile.read(this.rowIn.getBuffer(), 4, size - 4);
            }
            catch (OutOfMemoryError exception) {
                Trace.logError(this, "OOM error while reading row of size {} from position {}.", size, pos);
                Trace.logException(this, exception, true);
                throw exception;
            }
            return this.rowIn;
        }
        catch (IOException e) {
            Trace.logError(this, "IOException while reading object of size {} from position {}.", size, pos);
            throw Error.error(466, e);
        }
    }

    public CachedObject release(int pos) {
        this.writeLock.lock();
        try {
            this.cacheModified = true;
            CachedObject cachedObject = this.cache.release(pos);
            return cachedObject;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void saveRows(CachedObject[] rows, int offset, int count) {
        if (count == 0) {
            return;
        }
        try {
            this.copyShadow(rows, offset, count);
            this.setFileModified();
            for (int i = offset; i < offset + count; ++i) {
                CachedObject r = rows[i];
                this.saveRowNoLock(r);
                rows[i] = null;
            }
        }
        catch (DataspaceException e) {
            this.dataspaceStore.dataspaceLogger.logSevereEvent("saveRows failed", e);
            throw e;
        }
        catch (Throwable e) {
            this.dataspaceStore.dataspaceLogger.logSevereEvent("saveRows failed", e);
            throw Error.error(466, e);
        }
        finally {
            this.initBuffers();
        }
    }

    public void saveRow(CachedObject row) {
        this.writeLock.lock();
        try {
            this.copyShadow(row);
            this.setFileModified();
            this.saveRowNoLock(row);
        }
        catch (Throwable e) {
            this.dataspaceStore.dataspaceLogger.logSevereEvent("saveRow failed", e);
            throw Error.error(466, e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void saveRowNoLock(CachedObject row) {
        try {
            this.rowOut.reset();
            row.write(this.rowOut);
            this.dataFile.seek((long)row.getPos() * (long)this.cacheFileScale);
            this.dataFile.write(this.rowOut.getOutputStream().getBuffer(), 0, this.rowOut.getOutputStream().size());
        }
        catch (IOException e) {
            throw Error.error(466, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyShadow(CachedObject[] rows, int offset, int count) throws IOException {
        if (this.shadowFile != null) {
            long time = this.shadowCopyTimer.elapsedTime();
            this.shadowCopyTimer.start();
            try {
                for (int i = offset; i < offset + count; ++i) {
                    CachedObject row = rows[i];
                    long seekpos = (long)row.getPos() * (long)this.cacheFileScale;
                    this.shadowFile.copy(seekpos, row.getStorageSize());
                }
                this.shadowFile.synch();
            }
            finally {
                this.shadowCopyTimer.stop();
            }
            this.dataspaceStore.dataspaceLogger.logDetailEvent("shadow copy of elements: " + (count - offset) + ", time: " + (this.shadowCopyTimer.elapsedTime() - time) + ", total time: " + this.shadowCopyTimer.elapsedTime());
        }
    }

    protected void copyShadow(CachedObject row) throws IOException {
        if (this.shadowFile != null) {
            long seekpos = (long)row.getPos() * (long)this.cacheFileScale;
            this.shadowFile.copy(seekpos, row.getStorageSize());
            this.shadowFile.synch();
        }
    }

    void backupFile(boolean newFile) {
        this.writeLock.lock();
        try {
            if (this.dataspaceStore.dataspaceLogger.propIncrementBackup) {
                if (this.fileAccess.isStreamElement(this.backupFileName)) {
                    this.deleteBackup();
                }
                return;
            }
            if (this.fileAccess.isStreamElement(this.dataFileName)) {
                Object filename = newFile ? this.dataFileName + ".new" : this.dataFileName;
                FileArchiver.archive((String)filename, this.backupFileName + ".new", this.dataspaceStore.dataspaceLogger.getFileAccess(), 1);
            }
        }
        catch (IOException e) {
            this.dataspaceStore.dataspaceLogger.logSevereEvent("backupFile failed", e);
            throw Error.error(466, e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void renameBackupFile() {
        this.writeLock.lock();
        try {
            if (this.dataspaceStore.dataspaceLogger.propIncrementBackup) {
                this.deleteBackup();
                return;
            }
            if (this.fileAccess.isStreamElement(this.backupFileName + ".new")) {
                this.deleteBackup();
                this.fileAccess.renameElement(this.backupFileName + ".new", this.backupFileName);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void renameDataFile() {
        this.writeLock.lock();
        try {
            if (this.fileAccess.isStreamElement(this.dataFileName + ".new")) {
                this.deleteFile();
                this.fileAccess.renameElement(this.dataFileName + ".new", this.dataFileName);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void deleteFile() {
        this.writeLock.lock();
        try {
            this.fileAccess.removeElement(this.dataFileName);
            if (this.dataspaceStore.dataspaceLogger.isStoredFileAccess()) {
                return;
            }
            if (this.fileAccess.isStreamElement(this.dataFileName)) {
                this.dataspaceStore.dataspaceLogger.log.deleteOldDataFiles();
                this.fileAccess.removeElement(this.dataFileName);
                if (this.fileAccess.isStreamElement(this.dataFileName)) {
                    String discardName = FileUtil.newDiscardFileName(this.dataFileName);
                    this.fileAccess.renameElement(this.dataFileName, discardName);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void deleteBackup() {
        this.writeLock.lock();
        try {
            if (this.fileAccess.isStreamElement(this.backupFileName)) {
                this.fileAccess.removeElement(this.backupFileName);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public int capacity() {
        return this.maxCacheRows;
    }

    public long bytesCapacity() {
        return this.maxCacheBytes;
    }

    public long getTotalCachedBlockSize() {
        return this.cache.getTotalCachedBlockSize();
    }

    public int getFreeBlockCount() {
        return this.freeBlocks.size();
    }

    public int getTotalFreeBlockSize() {
        return 0;
    }

    public long getFileFreePos() {
        return this.fileFreePosition;
    }

    public int getCachedObjectCount() {
        return this.cache.size();
    }

    public int getAccessCount() {
        return this.cache.incrementAccessCount();
    }

    public String getFileName() {
        return this.dataFileName;
    }

    public boolean hasRowInfo() {
        return this.hasRowInfo;
    }

    public boolean isFileModified() {
        return this.fileModified;
    }

    public boolean isModified() {
        return this.cacheModified;
    }

    public boolean isFileOpen() {
        return this.dataFile != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setFileModified() {
        block7: {
            this.writeLock.lock();
            try {
                if (this.fileModified) break block7;
                long time = this.cache.saveAllTimer.elapsedTime();
                this.cache.saveAllTimer.start();
                try {
                    this.dataFile.seek(28L);
                    int flags = this.dataFile.readInt();
                    flags = BitMap.unset(flags, 2);
                    this.dataFile.seek(28L);
                    this.dataFile.writeInt(flags);
                    this.dataFile.synch();
                }
                finally {
                    this.cache.saveAllTimer.stop();
                    this.dataspaceStore.dataspaceLogger.logDetailEvent("flags set " + (this.cache.saveAllTimer.elapsedTime() - time) + "ms");
                }
                this.fileModified = true;
            }
            catch (Throwable throwable) {
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    public int getFlags() {
        try {
            this.dataFile.seek(28L);
            return this.dataFile.readInt();
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public boolean isDataReadOnly() {
        return this.cacheReadonly;
    }

    public RAShadowFile getShadowFile() {
        return this.shadowFile;
    }

    public void writeLock() {
        this.writeLock.lock();
    }

    public void writeUnlock() {
        this.writeLock.unlock();
    }
}

