/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.rowio.RowInputInterface;
import com.streamscape.ds.io.rowio.RowOutputInterface;
import com.streamscape.ds.io.scriptio.ScriptWriterText;
import com.streamscape.ds.lib.HsqlByteArrayOutputStream;
import com.streamscape.ds.persist.AbstractTextTableIOManager;
import com.streamscape.ds.persist.CachedObject;
import com.streamscape.ds.persist.FileTableCache;
import com.streamscape.ds.persist.FileTableSettings;
import com.streamscape.lib.file.RandomAccessInterface;
import de.jarnbjo.jsnappy.SnappyCompressor;
import de.jarnbjo.jsnappy.SnappyDecompressor;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class CompressedFileTableIOManager
extends AbstractTextTableIOManager<Integer> {
    private Map<Integer, Long> blocksMap = new HashMap<Integer, Long>();
    private int blockNumber = 0;
    private int blockLength = -1;
    private int randomBlockLength = -1;
    private byte[] currentBlockData;
    private long fileCounter = 0L;
    private int rowCounter = 0;
    private int insertBlock = -1;
    private int insertRowPos = 0;
    private byte[] randomAccessBuffer;
    private int randomBlockNumber = -1;

    CompressedFileTableIOManager(RandomAccessInterface dataFile, FileTableSettings textFileSettings, RowInputInterface rowIn, RowOutputInterface rowOut, boolean isReadOnly, String fileName, int blockSize) {
        super(dataFile, textFileSettings, rowIn, rowOut, isReadOnly, fileName, blockSize);
        this.currentBlockData = new byte[blockSize];
        this.randomAccessBuffer = new byte[blockSize];
    }

    @Override
    public int readMagic() {
        try {
            byte[] magic = new byte[FileTableCache.COMPRESSED_FILE_MAGIC.length];
            this.dataFile.read(magic, 0, FileTableCache.COMPRESSED_FILE_MAGIC.length);
            this.fileCounter += (long)FileTableCache.COMPRESSED_FILE_MAGIC.length;
            return FileTableCache.COMPRESSED_FILE_MAGIC.length;
        }
        catch (IOException error) {
            throw new DataspaceException("Source file is corrupted.");
        }
    }

    @Override
    public void convert(String targetFileName, FileTableCache cache) {
        try {
            byte[] originalBuffer;
            Trace.logInfo(this, "Starting Decompression...");
            this.reset();
            byte[] buffer = originalBuffer = new byte[this.blockSize];
            FileInputStream fin = new FileInputStream(new File(this.fileName));
            FileOutputStream fout = new FileOutputStream(new File(targetFileName));
            byte[] magic = new byte[FileTableCache.COMPRESSED_FILE_MAGIC.length];
            fin.read(magic, 0, FileTableCache.COMPRESSED_FILE_MAGIC.length);
            if (cache.isIgnoreFirstLine()) {
                short headerLength = this.readShort(fin);
                byte[] headerData = new byte[headerLength];
                fin.read(headerData);
                String headerFromFile = new String(headerData, 0, (int)headerLength, this.textFileSettings.stringEncoding);
                fout.write(headerFromFile.getBytes());
            }
            try {
                while (true) {
                    int ch2;
                    int ch1;
                    buffer = originalBuffer;
                    short currentBlockSize = this.readShort(fin);
                    short realBlockSize = this.readShort(fin);
                    fin.read(buffer, 0, realBlockSize);
                    buffer = SnappyDecompressor.decompress((byte[])buffer, (int)0, (int)realBlockSize).toByteArray();
                    int counter = 0;
                    while (counter < buffer.length && ((ch1 = buffer[counter++] & 0xFF) | (ch2 = buffer[counter++] & 0xFF)) >= 0 && (ch1 != 0 || ch2 != 0)) {
                        short size = (short)((ch1 << 8) + (ch2 << 0));
                        fout.write(buffer, counter, size);
                        counter += size;
                    }
                    if (currentBlockSize == realBlockSize) continue;
                    long needToSkip = currentBlockSize - realBlockSize;
                    long skipped = 0L;
                    while ((skipped = fin.skip(needToSkip)) > 0L) {
                        needToSkip -= skipped;
                    }
                    if (needToSkip > 0L) break;
                }
                throw new EOFException();
            }
            catch (EOFException error) {
                fin.close();
                fout.close();
                Trace.logInfo(this, "Decompression Completed.");
            }
        }
        catch (Throwable t) {
            Trace.logException(this, t, true);
            throw new DataspaceException(t);
        }
    }

    @Override
    public int readHeaderLine() {
        return this.readHeaderLines(1);
    }

    @Override
    public int readHeaderLines(int lines) {
        try {
            int ch1 = this.dataFile.read();
            int ch2 = this.dataFile.read();
            if ((ch1 | ch2) < 0) {
                return 0;
            }
            short headerLength = (short)((ch1 << 8) + (ch2 << 0));
            byte[] headerData = new byte[headerLength];
            this.dataFile.read(headerData, 0, headerLength);
            this.header = new String(headerData, 0, (int)headerLength, this.textFileSettings.stringEncoding);
            this.fileCounter += (long)(2 + headerLength);
            return headerLength;
        }
        catch (Exception error) {
            throw new DataspaceException(error);
        }
    }

    @Override
    public RowInputInterface readNextRow(long pos) {
        try {
            String rowString;
            int ch2;
            int ch1;
            if (this.rowCounter >= (this.blockLength > 0 ? this.blockLength : this.blockSize)) {
                if (!this.readNextBlock(this.fileCounter)) {
                    return null;
                }
                this.rowCounter = 0;
            }
            if (this.rowCounter >= this.blockLength) {
                return null;
            }
            int rowPos = this.rowCounter;
            if (((ch1 = this.currentBlockData[this.rowCounter++] & 0xFF) | (ch2 = this.currentBlockData[this.rowCounter++] & 0xFF)) < 0 || ch1 == 0 && ch2 == 0) {
                return null;
            }
            short rowLength = (short)((ch1 << 8) + (ch2 << 0));
            byte[] currentRowData = new byte[rowLength];
            System.arraycopy(this.currentBlockData, this.rowCounter, currentRowData, 0, rowLength);
            this.rowCounter += rowLength;
            try {
                rowString = new String(currentRowData, 0, (int)rowLength, this.textFileSettings.stringEncoding);
            }
            catch (UnsupportedEncodingException e) {
                rowString = currentRowData.toString();
            }
            ++this.rowNum;
            if (!this.isForStream) {
                this.rowNumToPosMap.put(this.rowNum, rowPos);
            }
            this.rowIn.setSource(rowString, this.rowNum, rowLength);
            this.rowIn.increaseLine();
            this.rowIn.setBlock(this.blockNumber);
            return this.rowIn;
        }
        catch (IOException error) {
            Trace.logException(this, error, true);
            return null;
        }
    }

    private boolean readNextBlock(long blockPos) throws IOException {
        try {
            this.dataFile.seek(blockPos);
            int ch1 = this.dataFile.read();
            int ch2 = this.dataFile.read();
            if ((ch1 | ch2) < 0) {
                return false;
            }
            short currentCompressedBlockLength = (short)((ch1 << 8) + (ch2 << 0));
            ch1 = this.dataFile.read();
            if ((ch1 | (ch2 = this.dataFile.read())) < 0) {
                return false;
            }
            short currentBlockRealLength = (short)((ch1 << 8) + (ch2 << 0));
            this.dataFile.read(this.currentBlockData, 0, currentBlockRealLength);
            this.fileCounter += (long)(currentCompressedBlockLength + 4);
            this.currentBlockData = SnappyDecompressor.decompress((byte[])this.currentBlockData, (int)0, (int)currentBlockRealLength).toByteArray();
            this.blockLength = this.currentBlockData.length;
            ++this.blockNumber;
            this.blocksMap.put(this.blockNumber, blockPos);
            return true;
        }
        catch (EOFException error) {
            return false;
        }
    }

    private boolean readBlock(int blockNumber, long blockPos) throws IOException {
        try {
            this.dataFile.seek(blockPos);
            int ch1 = this.dataFile.read();
            int ch2 = this.dataFile.read();
            if ((ch1 | ch2) < 0) {
                return false;
            }
            short currentCompressedBlockLength = (short)((ch1 << 8) + (ch2 << 0));
            ch1 = this.dataFile.read();
            if ((ch1 | (ch2 = this.dataFile.read())) < 0) {
                return false;
            }
            short currentBlockRealLength = (short)((ch1 << 8) + (ch2 << 0));
            this.randomAccessBuffer = new byte[currentBlockRealLength];
            this.dataFile.read(this.randomAccessBuffer, 0, currentBlockRealLength);
            this.randomAccessBuffer = SnappyDecompressor.decompress((byte[])this.randomAccessBuffer, (int)0, (int)currentBlockRealLength).toByteArray();
            this.randomBlockLength = currentCompressedBlockLength;
            this.randomBlockNumber = blockNumber;
            return true;
        }
        catch (EOFException error) {
            return false;
        }
    }

    @Override
    public void reset() {
        try {
            this.dataFile.seek(0L);
            this.fileCounter = 0L;
            this.rowCounter = this.blockSize;
            this.blockNumber = -1;
        }
        catch (IOException error) {
            throw new DataspaceException(error);
        }
    }

    @Override
    public void readRow(CachedObject object) {
        try {
            String rowString;
            if (object.getBlock() != -1 && this.randomBlockNumber != object.getBlock()) {
                this.readBlock(object.getBlock(), this.blocksMap.get(object.getBlock()));
            }
            int rowLength = object.getStorageSize();
            int relativePos = (Integer)this.rowNumToPosMap.get(object.getPos());
            byte[] currentRowData = new byte[rowLength];
            System.arraycopy(this.randomAccessBuffer, relativePos + 2, currentRowData, 0, rowLength);
            try {
                rowString = new String(currentRowData, 0, rowLength, this.textFileSettings.stringEncoding);
            }
            catch (UnsupportedEncodingException e) {
                rowString = currentRowData.toString();
            }
            this.rowIn.setSource(rowString, object.getPos(), this.buffer.size());
        }
        catch (IOException err) {
            Trace.logException(this, err, true);
        }
    }

    @Override
    public void clearRowImage(CachedObject row) {
        try {
            long blockPos = this.blocksMap.get(row.getBlock());
            if (row.getBlock() != -1 && this.randomBlockNumber != row.getBlock()) {
                this.readBlock(row.getBlock(), blockPos);
            }
            int length = row.getStorageSize() - ScriptWriterText.BYTES_LINE_SEP.length;
            this.rowOut.reset();
            HsqlByteArrayOutputStream out = this.rowOut.getOutputStream();
            out.fill(32, length);
            out.write(ScriptWriterText.BYTES_LINE_SEP);
            int relativePos = (Integer)this.rowNumToPosMap.get(row.getPos());
            System.arraycopy(out.getBuffer(), 0, this.randomAccessBuffer, relativePos + 2, out.size());
            this.dataFile.seek(blockPos);
            byte[] temp = new byte[]{(byte)(this.randomBlockLength >>> 8 & 0xFF), (byte)(this.randomBlockLength >>> 0 & 0xFF)};
            this.dataFile.write(temp, 0, 2);
            byte[] temp2 = SnappyCompressor.compress((byte[])this.randomAccessBuffer).toByteArray();
            temp[0] = (byte)(temp2.length >>> 8 & 0xFF);
            temp[1] = (byte)(temp2.length >>> 0 & 0xFF);
            this.dataFile.write(temp, 0, 2);
            this.dataFile.write(temp2, 0, temp2.length);
        }
        catch (IOException e) {
            throw Error.runtimeError(201, e.getMessage());
        }
    }

    @Override
    public void writeRow(CachedObject row) {
        try {
            long blockPos = this.blocksMap.get(row.getBlock());
            if (row.getBlock() != -1 && this.randomBlockNumber != row.getBlock()) {
                this.readBlock(row.getBlock(), blockPos);
            }
            this.rowOut.reset();
            row.write(this.rowOut);
            HsqlByteArrayOutputStream out = this.rowOut.getOutputStream();
            int relativePos = (Integer)this.rowNumToPosMap.get(row.getPos());
            this.randomAccessBuffer[relativePos] = (byte)(out.size() >>> 8 & 0xFF);
            this.randomAccessBuffer[relativePos + 1] = (byte)(out.size() >>> 0 & 0xFF);
            System.arraycopy(out.getBuffer(), 0, this.randomAccessBuffer, relativePos + 2, out.size());
            this.dataFile.seek(blockPos);
            byte[] temp = new byte[]{(byte)(this.randomBlockLength >>> 8 & 0xFF), (byte)(this.randomBlockLength >>> 0 & 0xFF)};
            this.dataFile.write(temp, 0, 2);
            byte[] temp2 = SnappyCompressor.compress((byte[])this.randomAccessBuffer).toByteArray();
            temp[0] = (byte)(temp2.length >>> 8 & 0xFF);
            temp[1] = (byte)(temp2.length >>> 0 & 0xFF);
            this.dataFile.write(temp, 0, 2);
            this.dataFile.write(temp2, 0, temp2.length);
        }
        catch (IOException e) {
            throw Error.runtimeError(201, e.getMessage());
        }
    }

    @Override
    public void setFileFreePosition(long pos) {
        super.setFileFreePosition(this.fileCounter);
        this.insertBlock = this.blockNumber;
    }

    @Override
    public long allocateRow(CachedObject object) {
        int rowSize = object.getStorageSize();
        if (this.insertBlock == this.blockNumber || this.insertRowPos + rowSize + 2 >= this.blockSize) {
            this.allocateNewBlock();
        }
        object.setBlock(this.insertBlock);
        int rowPos = this.insertRowPos;
        ++this.rowNum;
        this.rowNumToPosMap.put(this.rowNum, rowPos);
        object.setPos(this.rowNum);
        this.insertRowPos += rowSize + 2;
        return this.fileFreePos;
    }

    private void allocateNewBlock() {
        try {
            ++this.insertBlock;
            this.blocksMap.put(this.insertBlock, this.fileFreePos);
            this.insertRowPos = 0;
            this.dataFile.seek(this.fileFreePos);
            byte[] temp = new byte[]{(byte)(this.blockSize >>> 8 & 0xFF), (byte)(this.blockSize >>> 0 & 0xFF)};
            this.dataFile.write(temp, 0, 2);
            byte[] tempBuffer = new byte[this.blockSize];
            tempBuffer = SnappyCompressor.compress((byte[])tempBuffer).toByteArray();
            temp[0] = (byte)(tempBuffer.length >>> 8 & 0xFF);
            temp[1] = (byte)(tempBuffer.length >>> 0 & 0xFF);
            this.dataFile.write(temp, 0, 2);
            this.dataFile.write(tempBuffer, 0, tempBuffer.length);
            this.fileFreePos += (long)this.blockSize;
        }
        catch (IOException e) {
            throw Error.runtimeError(201, e.getMessage());
        }
    }

    @Override
    public long getFileLength() throws IOException {
        return this.dataFile.length();
    }

    @Override
    public void truncate() {
        this.dataFileLock.lock();
        try {
            this.dataFile.synch();
            this.dataFile.setLength(0L);
            this.resetOnTruncate();
        }
        finally {
            this.dataFileLock.unlock();
        }
    }
}

