/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.lib.FileAccess;
import com.streamscape.ds.lib.FileUtil;
import com.streamscape.ds.lib.HashMap;
import com.streamscape.ds.lib.store.ValuePool;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class BaseStoreProperties {
    public static final int ANY_ERROR = 0;
    public static final int NO_VALUE_FOR_KEY = 1;
    protected String fileName;
    protected Properties stringProps;
    public int[] errorCodes = ValuePool.emptyIntArray;
    public String[] errorKeys = ValuePool.emptyStringArray;
    protected boolean resource = false;
    protected FileAccess fa;
    protected transient HashMap metaData;
    public static final int indexName = 0;
    public static final int indexType = 1;
    public static final int indexClass = 2;
    public static final int indexIsRange = 3;
    public static final int indexDefaultValue = 4;
    public static final int indexRangeLow = 5;
    public static final int indexRangeHigh = 6;
    public static final int indexValues = 7;
    public static final int indexLimit = 9;

    public BaseStoreProperties() {
        this.stringProps = new Properties();
        this.fileName = null;
    }

    public BaseStoreProperties(String fileName) {
        this.stringProps = new Properties();
        this.fileName = fileName;
        this.fa = FileUtil.getFileUtil();
    }

    public BaseStoreProperties(HashMap metaData, String fileName, FileAccess accessor, boolean b) {
        this.stringProps = new Properties();
        this.fileName = fileName;
        this.fa = accessor;
        this.metaData = metaData;
    }

    public BaseStoreProperties(Properties stringProps) {
        this.stringProps = stringProps;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String setProperty(String key, int value) {
        return this.setProperty(key, Integer.toString(value));
    }

    public String setProperty(String key, boolean value) {
        return this.setProperty(key, String.valueOf(value));
    }

    public String setProperty(String key, String value) {
        return (String)this.stringProps.put(key, value);
    }

    public String setPropertyIfNotExists(String key, String value) {
        value = this.getProperty(key, value);
        return this.setProperty(key, value);
    }

    public Properties getProperties() {
        return this.stringProps;
    }

    public String getProperty(String key) {
        return this.stringProps.getProperty(key);
    }

    public boolean isPropertyExist(String key) {
        return this.stringProps.getProperty(key) != null;
    }

    public String getProperty(String key, String defaultValue) {
        return this.stringProps.getProperty(key, defaultValue);
    }

    public int getIntegerProperty(String key, int defaultValue) {
        String prop = this.getProperty(key);
        try {
            if (prop != null) {
                defaultValue = Integer.parseInt(prop);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    public boolean isPropertyTrue(String key) {
        return this.isPropertyTrue(key, false);
    }

    public boolean isPropertyTrue(String key, boolean defaultValue) {
        String value = this.stringProps.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value.toLowerCase().equals("true");
    }

    public void removeProperty(String key) {
        this.stringProps.remove(key);
    }

    public void addProperties(Properties props) {
        if (props == null) {
            return;
        }
        Enumeration<?> keys = props.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = props.getProperty(key);
            this.stringProps.put(key, value);
        }
    }

    public void addProperties(BaseStoreProperties props) {
        if (props == null) {
            return;
        }
        this.addProperties(props.stringProps);
    }

    public boolean propertiesFileExists() {
        String propFilename = this.fileName + ".properties";
        return this.fa.isStreamElement(propFilename);
    }

    private void addError(int code, String key) {
        this.errorCodes = (int[])ArrayUtil.resizeArray(this.errorCodes, this.errorCodes.length + 1);
        this.errorKeys = (String[])ArrayUtil.resizeArray(this.errorKeys, this.errorKeys.length + 1);
        this.errorCodes[this.errorCodes.length - 1] = code;
        this.errorKeys[this.errorKeys.length - 1] = key;
    }

    public static BaseStoreProperties argArrayToProps(String[] arg, String type) {
        BaseStoreProperties props = new BaseStoreProperties();
        for (int i = 0; i < arg.length; ++i) {
            String value;
            String p = arg[i];
            if (p.equals("--help") || p.equals("-help")) {
                props.addError(1, p.substring(1));
                continue;
            }
            if (p.startsWith("--")) {
                value = i + 1 < arg.length ? arg[i + 1] : "";
                props.setProperty(type + "." + p.substring(2), value);
                ++i;
                continue;
            }
            if (p.charAt(0) != '-') continue;
            value = i + 1 < arg.length ? arg[i + 1] : "";
            props.setProperty(type + "." + p.substring(1), value);
            ++i;
        }
        return props;
    }

    public static BaseStoreProperties delimitedArgPairsToProps(String s, String pairsep, String dlimiter, String type) {
        BaseStoreProperties props = new BaseStoreProperties();
        int currentpair = 0;
        while (true) {
            int valindex;
            int nextpair;
            if ((nextpair = s.indexOf(dlimiter, currentpair)) == -1) {
                nextpair = s.length();
            }
            if ((valindex = s.substring(0, nextpair).indexOf(pairsep, currentpair)) == -1) {
                props.addError(1, s.substring(currentpair, nextpair).trim());
            } else {
                Object key = s.substring(currentpair, valindex).trim();
                String value = s.substring(valindex + pairsep.length(), nextpair).trim();
                if (type != null) {
                    key = type + "." + (String)key;
                }
                props.setProperty((String)key, value);
            }
            if (nextpair == s.length()) break;
            currentpair = nextpair + dlimiter.length();
        }
        return props;
    }

    public List<String> propertyNames() {
        ArrayList<String> props = new ArrayList<String>();
        Iterator<Object> iter = this.stringProps.keySet().iterator();
        while (iter.hasNext()) {
            props.add(iter.next().toString());
        }
        return props;
    }

    public boolean isEmpty() {
        return this.stringProps.isEmpty();
    }

    public String[] getErrorKeys() {
        return this.errorKeys;
    }

    public static Object[] getMeta(String name, int type, String defaultValue) {
        Object[] row = new Object[9];
        row[0] = name;
        row[1] = ValuePool.getInt(type);
        row[2] = "String";
        row[4] = defaultValue;
        return row;
    }

    public static Object[] getMeta(String name, int type, boolean defaultValue) {
        Object[] row = new Object[9];
        row[0] = name;
        row[1] = ValuePool.getInt(type);
        row[2] = "Boolean";
        row[4] = defaultValue ? Boolean.TRUE : Boolean.FALSE;
        return row;
    }

    public static Object[] getMeta(String name, int type, int defaultValue, int[] values) {
        Object[] row = new Object[9];
        row[0] = name;
        row[1] = ValuePool.getInt(type);
        row[2] = "Integer";
        row[4] = ValuePool.getInt(defaultValue);
        row[7] = values;
        return row;
    }

    public static Object[] getMeta(String name, int type, int defaultValue, int rangeLow, int rangeHigh) {
        Object[] row = new Object[9];
        row[0] = name;
        row[1] = ValuePool.getInt(type);
        row[2] = "Integer";
        row[4] = ValuePool.getInt(defaultValue);
        row[3] = Boolean.TRUE;
        row[5] = ValuePool.getInt(rangeLow);
        row[6] = ValuePool.getInt(rangeHigh);
        return row;
    }

    public static String validateProperty(String key, String value, Object[] meta) {
        if (meta[2].equals("Boolean")) {
            if ((value = value.toLowerCase()).equals("true") || value.equals("false")) {
                return null;
            }
            return "invalid boolean value for property: " + key;
        }
        if (meta[2].equals("String")) {
            return null;
        }
        if (meta[2].equals("Integer")) {
            int[] values;
            int number = Integer.parseInt(value);
            if (Boolean.TRUE.equals(meta[3])) {
                int low = (Integer)meta[5];
                int high = (Integer)meta[6];
                if (number < low || high < number) {
                    return "value outside range for property: " + key;
                }
            }
            if (meta[7] != null && ArrayUtil.find(values = (int[])meta[7], number) == -1) {
                return "value not supported for property: " + key;
            }
            return null;
        }
        return null;
    }

    public boolean validateProperty(String name, int number) {
        Object[] meta = (Object[])this.metaData.get(name);
        if (meta == null) {
            return false;
        }
        if (meta[2].equals("Integer")) {
            int[] values;
            if (Boolean.TRUE.equals(meta[3])) {
                int low = (Integer)meta[5];
                int high = (Integer)meta[6];
                if (number < low || high < number) {
                    return false;
                }
            }
            return meta[7] == null || ArrayUtil.find(values = (int[])meta[7], number) != -1;
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        int len = this.stringProps.size();
        Enumeration<?> en = this.stringProps.propertyNames();
        for (int i = 0; i < len; ++i) {
            String key = (String)en.nextElement();
            builder.append(key);
            builder.append('=');
            builder.append(this.stringProps.get(key));
            if (i + 1 < len) {
                builder.append(',');
                builder.append(' ');
            }
            builder.append(']');
        }
        return builder.toString();
    }
}

