/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.persist;

import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.rowio.AbstractRowInputText;
import com.streamscape.ds.io.rowio.RowInputInterface;
import com.streamscape.ds.io.rowio.RowOutputInterface;
import com.streamscape.ds.lib.HsqlByteArrayOutputStream;
import com.streamscape.ds.persist.FileTableIOManager;
import com.streamscape.ds.persist.FileTableSettings;
import com.streamscape.lib.file.RandomAccessInterface;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractTextTableIOManager<T>
implements FileTableIOManager {
    protected RandomAccessInterface dataFile;
    protected String fileName;
    protected AbstractRowInputText rowIn;
    protected RowOutputInterface rowOut;
    protected FileTableSettings textFileSettings;
    protected String header;
    protected boolean isReadOnly;
    protected HsqlByteArrayOutputStream buffer;
    protected long fileFreePos = -1L;
    protected int rowNum = 0;
    protected long lastPos = 0L;
    public static final int DEFAULT_BLOCK_SIZE = 4096;
    protected int blockSize = 4096;
    protected boolean isForStream = false;
    protected Map<Integer, T> rowNumToPosMap = new HashMap<Integer, T>();
    protected final ReentrantLock dataFileLock = new ReentrantLock();

    AbstractTextTableIOManager(RandomAccessInterface dataFile, FileTableSettings textFileSettings, RowInputInterface rowIn, RowOutputInterface rowOut, boolean isReadOnly, String fileName, int blockSize) {
        this.dataFile = dataFile;
        this.fileName = fileName;
        this.textFileSettings = textFileSettings;
        this.rowIn = (AbstractRowInputText)rowIn;
        this.rowOut = rowOut;
        this.isReadOnly = isReadOnly;
        this.buffer = new HsqlByteArrayOutputStream(128);
        this.blockSize = blockSize;
    }

    @Override
    public int readMagic() {
        return 0;
    }

    @Override
    public void setFileFreePosition(long pos) {
        this.fileFreePos = pos;
    }

    @Override
    public String getHeaderLine() {
        return this.header;
    }

    @Override
    public int getLineNumber() {
        return this.rowIn.getLineNumber();
    }

    @Override
    public void setForStream(boolean forStream) {
        this.isForStream = forStream;
    }

    @Override
    public long getLastPos() {
        return this.lastPos;
    }

    @Override
    public int writeHeader(String header, String encoding) {
        this.dataFileLock.lock();
        try {
            byte[] buf = null;
            String firstLine = header + FileTableSettings.NL;
            try {
                buf = firstLine.getBytes(encoding);
            }
            catch (UnsupportedEncodingException e) {
                buf = firstLine.getBytes();
            }
            this.dataFile.seek(0L);
            this.dataFile.write(buf, 0, buf.length);
            this.fileFreePos = buf.length;
            int n = buf.length;
            return n;
        }
        catch (IOException e) {
            throw Error.error(484, e);
        }
        finally {
            this.dataFileLock.unlock();
        }
    }

    protected void writeShort(OutputStream out, int value) throws IOException {
        out.write((byte)(value >>> 8 & 0xFF));
        out.write((byte)(value >>> 0 & 0xFF));
    }

    protected short readShort(InputStream in) throws IOException {
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    protected void resetOnTruncate() {
        this.fileFreePos = 0L;
        this.rowNum = 0;
        this.lastPos = 0L;
        this.rowNumToPosMap.clear();
        this.reset();
    }
}

