/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.statement;

import com.streamscape.cli.ds.CollectionType;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.parser.Tokens;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.AbstractCollection;
import com.streamscape.ds.schema.procedure.SQLFunctionsMetaData;
import com.streamscape.ds.session.Session;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.omf.json.jackson.JsonCustomization;
import com.streamscape.omf.json.jackson.JsonNotation;
import com.streamscape.omf.json.jackson.JsonNotationLevel;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.sql.enums.SQLQueryParameterMode;
import com.streamscape.sef.mf.admin.FabricContext;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import com.uwyn.jhighlight.tools.StringUtils;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class StatementUtil {
    public static String functionArgumentTypesToString(SQLFunctionsMetaData.SQLFunctionMetaData.Argument argument) {
        int j;
        StringBuilder builder = new StringBuilder();
        if (argument.getTypes() != null) {
            for (j = 0; j < argument.getTypes().length; ++j) {
                if (j > 0) {
                    builder.append(" | ");
                }
                builder.append(SQLFunctionsMetaData.SQLFunctionMetaData.getTypeName(argument.getTypes()[j]));
            }
        }
        if (argument.getKeySet() != null) {
            for (j = 0; j < argument.getKeySet().length; ++j) {
                if (j > 0) {
                    builder.append(" | ");
                }
                builder.append(Tokens.getKeyword(argument.getKeySet()[j]));
            }
        }
        return builder.toString();
    }

    public static String parameterModeToString(byte mode) {
        switch (mode) {
            case 1: {
                return SQLQueryParameterMode.IN.name();
            }
            case 4: {
                return SQLQueryParameterMode.OUT.name();
            }
            case 2: {
                return SQLQueryParameterMode.INOUT.name();
            }
        }
        return "";
    }

    public static String skipNull(String value) {
        return value == null ? "" : value;
    }

    public static SchemaObject[] getCollectionsByType(Session session, CollectionType collectionType, boolean table) {
        ArrayList<SchemaObject> objectList = new ArrayList<SchemaObject>();
        Iterator iterator = session.dataspaceStore.schemaManager.dataspaceObjectIterator(session.currentDataspace.name, 4);
        while (iterator.hasNext()) {
            SchemaObject object = (SchemaObject)iterator.next();
            if (!(object instanceof AbstractCollection) || collectionType != null && !((AbstractCollection)object).getCollectionType().equals((Object)collectionType)) continue;
            if (table) {
                objectList.add(((AbstractCollection)object).getBaseTable());
                continue;
            }
            objectList.add(object);
        }
        return objectList.toArray(new SchemaObject[0]);
    }

    public static SchemaObject[] getDataspaceObjects(Session session, int objectType) {
        ArrayList<SchemaObject> objectList = new ArrayList<SchemaObject>();
        Iterator iterator = session.dataspaceStore.schemaManager.dataspaceObjectIterator(session.currentDataspace.name, objectType);
        while (iterator.hasNext()) {
            objectList.add((SchemaObject)iterator.next());
        }
        return objectList.toArray(SchemaObject.emptyArray);
    }

    public static interface RowSetSerializer {
        public void serialize(Writer var1) throws Exception;
    }

    public static class JSONRowSetSerializer
    implements RowSetSerializer {
        private RowSet rs;
        private List<String> columnNames;
        private JSONSerializer serializer;

        public JSONRowSetSerializer(RowSet rs) {
            this.rs = rs;
            this.columnNames = rs.getMeta().getColumnNames();
            this.serializer = HTTPUtils.getJsonSerializerForRest((FabricContext)DataspaceStore.getContext(), JsonCustomization.builder().setNotation(JsonNotation.TYPE).addNotationLevel(JsonNotationLevel.NONE).setPrettyPrint(false).build());
        }

        @Override
        public void serialize(Writer writer) throws Exception {
            writer.write(this.getHeader());
            LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
            int currentRow = 0;
            while (this.rs.next()) {
                for (int i = 0; i < this.columnNames.size(); ++i) {
                    row.put(this.columnNames.get(i), this.rs.getObject(i + 1));
                }
                writer.write((currentRow != 0 ? "," : "") + this.serializer.serialize(row));
                ++currentRow;
            }
            writer.write(this.getFooter());
        }

        private String getHeader() {
            return "[";
        }

        private String getFooter() {
            return "]";
        }
    }

    public static class XMLRowSetSerializer
    implements RowSetSerializer {
        private RowSet rs;
        private List<String> columnNames;

        public XMLRowSetSerializer(RowSet rs) {
            this.rs = rs;
            this.columnNames = rs.getMeta().getColumnNames();
        }

        @Override
        public void serialize(Writer writer) throws Exception {
            writer.write(this.getHeader());
            while (this.rs.next()) {
                writer.write(this.getBodyRow(this.rs, this.columnNames));
            }
            writer.write(this.getFooter());
        }

        private String getHeader() {
            return "<?xml version=\"1.0\"?>\n<rows>\n";
        }

        private String getFooter() {
            return "</rows>";
        }

        private String getBodyRow(RowSet rs, List<String> columnNames) throws SQLException {
            StringBuilder sb = new StringBuilder();
            sb.append("\t<row>\n");
            for (int i = 0; i < columnNames.size(); ++i) {
                String columnName = columnNames.get(i);
                String value = StringUtils.encodeHtml((String)rs.getObject(i + 1).toString());
                sb.append("\t\t<" + columnNames.get(i) + ">" + value + "</" + columnName + ">\n");
            }
            sb.append("\t</row>\n");
            return sb.toString();
        }
    }
}

