/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.statement;

import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.OrderedIntHashSet;
import com.streamscape.ds.navigator.RangeIterator;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.navigator.RowSetNavigatorData;
import com.streamscape.ds.parser.ParserDQL;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionColumn;
import com.streamscape.ds.parser.statement.StatementDML;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.persist.snapshot.RowSnapshot;
import com.streamscape.ds.persist.snapshot.RowStoreSnapshot;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.table.SnapshotDataspaceTable;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.stable.table.SnapshotTable;
import java.lang.reflect.Array;
import java.util.Collection;

public class StatementUpdateSnapshot
extends StatementDML {
    private final Expression condition;

    public StatementUpdateSnapshot(Session session, Expression[] targets, Table table, RangeVariable[] rangeVariables, int[] columnMap, Expression[] updateExpressions, boolean[] columnCheckList, ParserDQL.CompileContext compileContext, Expression condition) {
        super(session, targets, table, rangeVariables, columnMap, updateExpressions, columnCheckList, compileContext);
        this.condition = condition;
    }

    public StatementUpdateSnapshot(Session session, Table table, RangeVariable[] rangeVariables, ParserDQL.CompileContext compileContext, boolean restartIdentity, int type) {
        super(session, table, rangeVariables, compileContext, restartIdentity, type);
        this.condition = null;
    }

    @Override
    Result getResult(Session session) {
        Result result = switch (this.type) {
            case 82 -> this.executeUpdate(session);
            case 19 -> {
                if (this.isTruncate) {
                    yield this.executeDeleteTruncateStatement(session);
                }
                yield this.executeDeleteStatement(session);
            }
            default -> throw Error.runtimeError(201, "StatementDML");
        };
        session.sessionContext.diagnosticsVariables[2] = result.getUpdateCount();
        return result;
    }

    private Result executeUpdate(Session session) {
        if (this.condition == null) {
            boolean allExpressionsValue = true;
            for (Expression updateExpression : this.updateExpressions) {
                OrderedHashSet columnExpressions = new OrderedHashSet();
                OrderedIntHashSet typesSet = new OrderedIntHashSet();
                typesSet.add(2);
                columnExpressions = updateExpression.collectAllExpressions(columnExpressions, typesSet, new OrderedIntHashSet());
                for (int i = 0; i < columnExpressions.size(); ++i) {
                    ExpressionColumn columnExpression = (ExpressionColumn)columnExpressions.get(i);
                    NameManager.ObjectName columnObjectName = columnExpression.getColumn().getObjectName();
                    if (this.baseTable.getObjectName() != columnObjectName.parent) continue;
                    allExpressionsValue = false;
                }
            }
            if (allExpressionsValue) {
                return this.executeUpdateOfWholeColumn(session);
            }
        }
        return this.executeUpdateIterable(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result executeUpdateOfWholeColumn(Session session) {
        int count = 0;
        for (int i = 0; i < this.updateExpressions.length; ++i) {
            Expression expression = this.updateExpressions[i];
            Object value = null;
            if (expression.getType() == 22) {
                RowSetNavigatorData navigator = expression.subQuery.getNavigator(session);
                if (navigator.getSize() == 1) {
                    ((RowSetNavigator)navigator).next();
                    value = ((RowSetNavigator)navigator).getCurrent()[0];
                } else {
                    if (navigator.getSize() == 0) continue;
                    value = navigator;
                }
            } else {
                value = expression.getValue(session);
            }
            int columnIndex = this.updateColumnMap[i];
            RowStoreSnapshot store = (RowStoreSnapshot)((SnapshotDataspaceTable)this.targetTable).store;
            store.writeLock();
            try {
                if (value != null && (value instanceof Collection || value.getClass().isArray() || value instanceof RowSetNavigator)) {
                    SnapshotTable sTable;
                    int rowCount;
                    int size = value instanceof Collection ? ((Collection)value).size() : (value.getClass().isArray() ? Array.getLength(value) : ((RowSetNavigator)value).getSize());
                    if (size != (rowCount = (sTable = ((SnapshotDataspaceTable)this.targetTable).getSTable()).rowCount())) {
                        throw Error.error(3201, new Object[]{"snapshot expects '" + rowCount + "' rows, but result '" + String.valueOf(expression) + "' contains '" + size + "' elements."});
                    }
                    int rowIndexWithDeleted = 0;
                    if (value instanceof Collection) {
                        for (Object v : (Collection)value) {
                            while (sTable.getDeletedRows().contains(rowIndexWithDeleted)) {
                                ++rowIndexWithDeleted;
                            }
                            store.setValueToColumn(columnIndex, rowIndexWithDeleted++, v);
                        }
                    } else if (value.getClass().isArray()) {
                        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
                            while (sTable.getDeletedRows().contains(rowIndexWithDeleted)) {
                                ++rowIndexWithDeleted;
                            }
                            store.setValueToColumn(columnIndex, rowIndexWithDeleted++, Array.get(value, rowIndex));
                        }
                    } else {
                        RowSetNavigator navigator = (RowSetNavigator)value;
                        while (navigator.hasNext()) {
                            navigator.next();
                            while (sTable.getDeletedRows().contains(rowIndexWithDeleted)) {
                                ++rowIndexWithDeleted;
                            }
                            store.setValueToColumn(columnIndex, rowIndexWithDeleted++, navigator.getCurrent()[0]);
                        }
                    }
                    count = rowCount;
                    continue;
                }
                count = ((RowStoreSnapshot)((SnapshotDataspaceTable)this.targetTable).store).assignColumnWithValueNoLock(columnIndex, value);
                continue;
            }
            finally {
                store.writeUnlock();
            }
        }
        return Result.newUpdateCountResult(count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result executeUpdateIterable(Session session) {
        RangeIterator it = RangeVariable.getIterator(session, this.targetRangeVariables);
        session.sessionContext.rownum = 0;
        while (it.next()) {
            Session.checkIfThreadIsInterrupted();
            session.sessionData.startRowProcessing();
            Row row = it.getCurrentRow();
            if (row != null) {
                Object[] updateValues = new Object[this.updateExpressions.length];
                for (int i = 0; i < this.updateExpressions.length; ++i) {
                    updateValues[i] = this.updateExpressions[i].getValue(session);
                }
                RowStoreSnapshot store = (RowStoreSnapshot)((SnapshotDataspaceTable)this.targetTable).store;
                store.writeLock();
                try {
                    store.setRowValuesNoLock(((RowSnapshot)row).getRowIndex(), this.updateColumnMap, updateValues);
                }
                finally {
                    store.writeUnlock();
                }
            }
            ++session.sessionContext.rownum;
        }
        return Result.newUpdateCountResult(session.sessionContext.rownum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Result executeDeleteStatement(Session session) {
        RowStoreSnapshot store = (RowStoreSnapshot)((SnapshotDataspaceTable)this.targetTable).store;
        store.writeLock();
        try {
            RangeIterator it = RangeVariable.getIterator(session, this.targetRangeVariables);
            session.sessionContext.rownum = 0;
            while (it.next()) {
                Session.checkIfThreadIsInterrupted();
                Row currentRow = it.getCurrentRow();
                store.deleteRowNoLock(((RowSnapshot)currentRow).getRowIndex());
                ++session.sessionContext.rownum;
            }
            it.release();
        }
        finally {
            store.writeUnlock();
        }
        if (session.sessionContext.rownum == 1) {
            return Result.updateOneResult;
        }
        return new Result(1, session.sessionContext.rownum);
    }
}

