/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.statement;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.statement.RejectException;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.parser.statement.StatementCompound;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.session.Session;
import java.util.LinkedHashMap;
import java.util.Map;

public class StatementSimple
extends Statement {
    String sqlState;
    String message;
    NameManager.ObjectName label;
    ColumnSchema[] variables;
    int[] variableIndexes;
    Expression expression = null;

    public StatementSimple(int type, Expression expression) {
        super(type, 2007);
        this.references = new OrderedHashSet();
        this.isTransactionStatement = false;
        this.expression = expression;
    }

    public StatementSimple(int type, NameManager.ObjectName label) {
        super(type, 2007);
        this.references = new OrderedHashSet();
        this.isTransactionStatement = false;
        this.label = label;
    }

    public StatementSimple(int type, String sqlState, String message) {
        super(type, 2007);
        this.references = new OrderedHashSet();
        this.isTransactionStatement = false;
        this.sqlState = sqlState;
        this.message = message;
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer();
        switch (this.type) {
            case 92: {
                sb.append("THROW").append(' ');
                sb.append("EXCEPTION").append(' ');
                sb.append("SQLSTATE");
                sb.append(' ').append('\'').append(this.sqlState).append('\'');
                if (this.message == null) break;
                sb.append(' ').append("MESSAGE").append(' ');
                sb.append('\'').append(this.message).append('\'');
                break;
            }
            case 91: {
                sb.append("RESIGNAL").append(' ');
                sb.append("SQLSTATE");
                sb.append(' ').append('\'').append(this.sqlState).append('\'');
                break;
            }
            case 102: {
                sb.append("ITERATE").append(' ').append(this.label);
                break;
            }
            case 89: {
                sb.append("LEAVE").append(' ').append(this.label);
                break;
            }
            case 3127: {
                sb.append("BREAK");
                break;
            }
            case 3128: {
                sb.append("CONTINUE");
                break;
            }
            case 3129: {
                sb.append("RETURN");
                break;
            }
            case 3247: {
                sb.append("DISCARD");
                break;
            }
            case 3309: {
                sb.append(1181).append(" ");
            }
        }
        return sb.toString();
    }

    protected String describe(Session session, int blanks) {
        StringBuffer sb = new StringBuffer();
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        sb.append("STATEMENT");
        return sb.toString();
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
        }
        catch (Throwable t) {
            result = Result.newErrorResult(t, null);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
        }
        return result;
    }

    Result getResult(Session session) {
        switch (this.type) {
            case 91: 
            case 92: {
                if (this.expression != null) {
                    Object value = this.expression.getValue(session);
                    value = this.expression.getDataType().convertSQLToJava(session, value);
                    if (value instanceof Throwable) {
                        return Result.newErrorResult((Throwable)value);
                    }
                } else {
                    DataspaceException ex = null;
                    ex = this.message != null ? Error.error(this.message, this.sqlState) : Error.error("sql routine error", this.sqlState);
                    return Result.newErrorResult(ex);
                }
            }
            case 89: 
            case 102: 
            case 3127: 
            case 3128: 
            case 3129: 
            case 3247: {
                String labelString = this.label == null ? "" : this.label.name;
                return Result.newPSMResult(this.type, labelString, null);
            }
            case 3309: {
                throw new RejectException();
            }
        }
        throw Error.runtimeError(201, "");
    }

    @Override
    public void resolve(Session session) {
        boolean resolved = false;
        block0 : switch (this.type) {
            case 91: 
            case 92: {
                resolved = true;
                break;
            }
            case 102: {
                StatementCompound statement = this.parent;
                while (statement != null) {
                    if (statement.isLoop) {
                        if (this.label == null) {
                            resolved = true;
                            break block0;
                        }
                        if (statement.label != null && this.label.name.equals(statement.label.name)) {
                            resolved = true;
                            break block0;
                        }
                    }
                    statement = statement.parent;
                }
                break;
            }
            case 89: 
            case 3127: 
            case 3128: 
            case 3129: 
            case 3247: 
            case 3309: {
                resolved = true;
                break;
            }
            default: {
                throw Error.runtimeError(201, "");
            }
        }
        if (!resolved) {
            throw Error.error(5602);
        }
    }

    @Override
    public String describe(Session session) {
        return "";
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        return result;
    }

    @Override
    public boolean isCatalogLock() {
        return false;
    }

    @Override
    public boolean isCatalogChange() {
        return false;
    }
}

