/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.statement;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.SqlInvariants;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArraySort;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.navigator.RowSetNavigatorData;
import com.streamscape.ds.parser.ParserDQL;
import com.streamscape.ds.parser.expression.ExecImmediateExpression;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionArrayAccessor;
import com.streamscape.ds.parser.expression.ExpressionColumn;
import com.streamscape.ds.parser.expression.ExpressionColumnAccessor;
import com.streamscape.ds.parser.expression.ExpressionOp;
import com.streamscape.ds.parser.expression.ExternalExecutionExpression;
import com.streamscape.ds.parser.expression.QueryExpression;
import com.streamscape.ds.parser.expression.QuerySpecification;
import com.streamscape.ds.parser.expression.ReadTakeExpression;
import com.streamscape.ds.parser.expression.SubQuery;
import com.streamscape.ds.parser.statement.StatementDML;
import com.streamscape.ds.parser.statement.StatementDMQL;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultMetaData;
import com.streamscape.ds.schema.procedure.FunctionSQL;
import com.streamscape.ds.schema.procedure.FunctionSQLInvoked;
import com.streamscape.ds.schema.procedure.FunctionUnitCall;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.event.SysFunctionUnit;
import com.streamscape.ds.types.BinaryData;
import com.streamscape.ds.types.CloseableWrapper;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.utils.RowSetFactoryForDSResult;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.utils.Utils;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class StatementSet
extends StatementDMQL {
    Expression expression;
    Expression[] expressions;
    public Expression[] targets;
    int[] variableIndexes;
    Type[] sourceTypes;
    final int operationType;
    public static final int TRIGGER_SET = 1;
    public static final int SELECT_INTO = 2;
    public static final int VARIABLE_SET = 3;

    public StatementSet(Session session, Expression[] targets, Table table, RangeVariable[] rangeVars, int[] indexes, Expression[] colExpressions, ParserDQL.CompileContext compileContext) {
        super(5, 2004, session.getCurrentDataspaceName());
        this.operationType = 1;
        this.targets = targets;
        this.targetTable = table;
        this.baseTable = this.targetTable.getBaseTable();
        this.updateColumnMap = indexes;
        this.updateExpressions = colExpressions;
        this.updateCheckColumns = this.targetTable.getColumnCheckList(indexes);
        this.targetRangeVariables = rangeVars;
        this.isTransactionStatement = false;
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
    }

    public StatementSet(Session session, Expression[] targets, Expression e, int[] indexes, ParserDQL.CompileContext compileContext) {
        super(5, 2007, null);
        this.operationType = 3;
        this.targets = targets;
        this.expression = e;
        this.variableIndexes = indexes;
        this.sourceTypes = this.expression.getNodeDataTypes();
        this.isTransactionStatement = false;
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
    }

    public StatementSet(Session session, Expression[] targets, Expression[] e, int[] indexes, ParserDQL.CompileContext compileContext) {
        super(5, 2007, null);
        this.operationType = 3;
        this.targets = targets;
        this.expressions = e;
        this.variableIndexes = indexes;
        Type[] types = new Type[e.length];
        int index = -1;
        for (Expression exp : e) {
            types[++index] = exp.getDataType();
        }
        this.sourceTypes = types;
        this.isTransactionStatement = false;
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
    }

    public StatementSet(Session session, Expression[] targets, QueryExpression query, int[] indexes, ParserDQL.CompileContext compileContext) {
        super(5, 2007, null);
        this.operationType = 2;
        this.queryExpression = query;
        this.targets = targets;
        this.variableIndexes = indexes;
        this.sourceTypes = query.getColumnTypes();
        this.isTransactionStatement = false;
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
    }

    @Override
    SubQuery[] getSubqueries(Session session) {
        OrderedHashSet subQueries = null;
        if (this.expression != null) {
            subQueries = this.expression.collectAllSubqueries(subQueries);
        }
        if (this.expressions != null) {
            for (Expression expr : this.expressions) {
                subQueries = expr.collectAllSubqueries(subQueries);
            }
        }
        if (subQueries == null || subQueries.size() == 0) {
            return SubQuery.emptySubqueryArray;
        }
        Object[] subQueryArray = new SubQuery[subQueries.size()];
        subQueries.toArray(subQueryArray);
        ArraySort.sort(subQueryArray, 0, subQueryArray.length, (Comparator)subQueryArray[0]);
        for (int i = 0; i < this.subqueries.length; ++i) {
            ((SubQuery)subQueryArray[i]).prepareTable(session);
        }
        return subQueryArray;
    }

    @Override
    Result getResult(Session session) {
        return this.getResult(session, false);
    }

    private Result getResult(Session session, boolean withMaterialization) {
        Result result = null;
        switch (this.operationType) {
            case 1: {
                if (withMaterialization && this.subqueries.length > 0) {
                    this.materializeSubQueries(session);
                }
                result = this.executeTriggerSetStatement(session);
                break;
            }
            case 2: {
                Object[] values = this.queryExpression.getSingleRowValues(session);
                if (values == null) {
                    session.addWarning(DataspaceException.noDataCondition);
                    values = new Object[this.targets.length];
                }
                this.cloneOtherTypeWrappers(values);
                for (int i = 0; i < values.length; ++i) {
                    values[i] = this.targets[i].getColumn().getDataType().convertToType(session, values[i], this.sourceTypes[i]);
                    this.executeAssignment(session, values[i], i);
                }
                result = Result.updateNoResult;
                break;
            }
            case 3: {
                int i;
                if (this.expression != null && this.expression.getType() == 22) {
                    OtherType type;
                    if (this.targets.length == 1 && this.targets[0].getDataType() instanceof OtherType && ((type = (OtherType)this.targets[0].getDataType()).getInternalClass(session) == RowSet.class || type.userTypeModifier != null && type.userTypeModifier.getName() != null && type.userTypeModifier.getName().name.equalsIgnoreCase("rowset"))) {
                        if (withMaterialization && this.subqueries.length > 0 && this.subQueryIsFunction()) {
                            this.materializeSubQueries(session);
                        }
                        this.expression.subQuery.materialiseCorrelated(session);
                        RowSetNavigatorData navigator = this.expression.subQuery.getNavigator(session);
                        ResultMetaData meta = this.expression.subQuery.queryExpression.getMetaData();
                        RowSet rowSet = ((RowSetFactoryForDSResult)new RowSetFactoryForDSResult().setWithBlobs(true)).createRowSet(session, navigator, meta);
                        this.executeAssignment(session, rowSet, 0);
                        result = Result.updateNoResult;
                        break;
                    }
                    boolean allTargetsArraysOrLists = true;
                    for (i = 0; i < this.targets.length; ++i) {
                        if (this.targets[i].getDataType().isArrayType() || this.targets[i].getDataType().isCollectionType()) continue;
                        allTargetsArraysOrLists = false;
                    }
                    if (allTargetsArraysOrLists) {
                        if (withMaterialization && this.subqueries.length > 0 && this.subQueryIsFunction()) {
                            this.materializeSubQueries(session);
                        }
                        this.expression.subQuery.materialiseCorrelated(session);
                        RowSetNavigatorData navigator = this.expression.subQuery.getNavigator(session);
                        ResultMetaData meta = this.expression.subQuery.queryExpression.getMetaData();
                        int size = navigator.getSize();
                        boolean assigned = false;
                        List[] targetLists = new List[this.targets.length];
                        while (((RowSetNavigator)navigator).next()) {
                            Object[] current = ((RowSetNavigator)navigator).getCurrent();
                            for (int i2 = 0; i2 < current.length; ++i2) {
                                if (size == 1 && (this.sourceTypes[i2].isArrayType() || this.sourceTypes[i2].isCollectionType())) {
                                    this.assignValueToTarget(session, current, i2);
                                    assigned = true;
                                    continue;
                                }
                                if (targetLists[i2] == null) {
                                    targetLists[i2] = this.targets[i2].getDataType().isSetType() ? new HashSet() : new ArrayList();
                                }
                                Type targetElementType = null;
                                if (this.targets[i2].getType() == 99) {
                                    targetElementType = this.targets[i2].getLeftNode().getColumn().getDataType().collectionBaseType();
                                } else if (this.targets[i2].getDataType().isArrayType()) {
                                    targetElementType = this.targets[i2].getDataType().collectionBaseType();
                                }
                                if (targetElementType != null) {
                                    current[i2] = targetElementType.convertToType(session, current[i2], this.sourceTypes[i2]);
                                }
                                current[i2] = OtherTypeWrapper.unwrapAndClone(current[i2]);
                                targetLists[i2].add(current[i2]);
                            }
                        }
                        if (!assigned) {
                            for (int i3 = 0; i3 < targetLists.length; ++i3) {
                                Object value = targetLists[i3];
                                if (size == 0 && value == null) {
                                    value = this.targets[i3].getDataType().convertToType(session, new Object[0], Type.SQL_ARRAY_ALL_TYPES);
                                }
                                if (this.targets[i3].getDataType().isArrayType()) {
                                    value = this.targets[i3].getDataType().convertToType(session, value, this.targets[i3].getDataType());
                                }
                                this.executeAssignment(session, value, i3);
                            }
                        }
                        result = Result.updateNoResult;
                        break;
                    }
                }
                if (this.expressions != null) {
                    for (int i4 = 0; i4 < this.expressions.length; ++i4) {
                        this.processExpression(session, this.expressions[i4], i4);
                    }
                    result = Result.updateNoResult;
                    break;
                }
                Object[] values = this.getExpressionValues(session);
                if (values == null) {
                    values = new Object[this.targets.length];
                }
                for (i = 0; i < values.length; ++i) {
                    this.assignValueToTarget(session, values, i);
                }
                result = Result.updateNoResult;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementSet");
            }
        }
        return result;
    }

    private void assignValueToTarget(Session session, Object[] values, int i) {
        Type targetType = this.targets[i].getType() == 99 ? this.targets[i].getDataType() : this.targets[i].getDataType();
        values[i] = targetType.convertToType(session, values[i], this.sourceTypes[i]);
        this.executeAssignment(session, values[i], i);
    }

    private void cloneOtherTypeWrappers(Object[] values) {
        if (values == null) {
            return;
        }
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] instanceof OtherTypeWrapper)) continue;
            try {
                if (OtherTypeWrapper.unwrap(values[i]) instanceof CloseableWrapper) continue;
                values[i] = SDOUtils.cloneByJSerializer(values[i]);
                continue;
            }
            catch (SDOException exception) {
                Trace.logException(this, exception, true);
            }
        }
    }

    private void processExpression(Session session, Expression expression, int i) {
        Object value = expression.getValue(session);
        Type targetType = this.targets[i].getType() == 99 ? this.targets[i].getLeftNode().getColumn().getDataType().collectionBaseType() : this.targets[i].getDataType();
        value = targetType.convertToType(session, value, this.sourceTypes[i]);
        this.executeAssignment(session, value, i);
    }

    @Override
    public void resolve(Session session) {
        this.references = new OrderedHashSet();
        switch (this.operationType) {
            case 1: {
                for (int i = 0; i < this.updateExpressions.length; ++i) {
                    this.updateExpressions[i].collectObjectNames(this.references);
                }
                break;
            }
            case 2: 
            case 3: {
                if (this.expression != null) {
                    this.expression.collectObjectNames(this.references);
                }
                if (this.queryExpression == null) break;
                this.queryExpression.collectObjectNames(this.references);
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementSet");
            }
        }
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer();
        switch (this.operationType) {
            case 1: {
                return this.sql;
            }
            case 3: {
                sb.append("SET").append(' ');
                sb.append(this.targets[0].getColumn().getObjectName().statementName);
                sb.append(' ').append('=').append(' ').append(this.expression != null ? this.expression.getSQL() : "null");
            }
        }
        return sb.toString();
    }

    protected String describe(Session session, int blanks) {
        StringBuffer sb = new StringBuffer();
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        sb.append("STATEMENT");
        return sb.toString();
    }

    private boolean subQueryIsFunction() {
        if (this.operationType != 3 || this.expression == null || this.expression.subQuery != this.subqueries[0] || this.expression.getType() != 22) {
            return false;
        }
        if (!(this.expression.subQuery.queryExpression instanceof QuerySpecification) || ((QuerySpecification)this.expression.subQuery.queryExpression).exprColumns.length != 1) {
            return false;
        }
        Expression exprColumn = ((QuerySpecification)this.expression.subQuery.queryExpression).exprColumns[0];
        return exprColumn instanceof FunctionSQLInvoked || exprColumn instanceof FunctionSQL || exprColumn instanceof FunctionUnitCall || exprColumn instanceof ExpressionOp && ((ExpressionOp)exprColumn).opType == 103;
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            if (this.subqueries.length > 0 && !this.subQueryIsFunction()) {
                this.materializeSubQueries(session);
            }
            result = this.getResult(session, true);
        }
        catch (Throwable t) {
            result = Result.newErrorResult(t, null);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
        }
        return result;
    }

    @Override
    public String describe(Session session) {
        return "";
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        return result;
    }

    Result executeTriggerSetStatement(Session session) {
        Table table = this.targetTable;
        int[] colMap = this.updateColumnMap;
        Expression[] colExpressions = this.updateExpressions;
        Type[] colTypes = table.getColumnTypes();
        if (this.targetRangeVariables[1] != null) {
            int index = this.targetRangeVariables[1].rangePosition;
            Object[] oldData = session.sessionContext.triggerArguments[index];
            Object[] data = StatementDML.getUpdatedData(session, this.targets, table, colMap, colExpressions, colTypes, oldData);
            ArrayUtil.copyArray(data, oldData, data.length);
            return Result.updateOneResult;
        }
        return Result.updateZeroResult;
    }

    @Override
    void collectTableNamesForRead(OrderedHashSet set) {
        int i;
        for (i = 0; i < this.rangeVariables.length; ++i) {
            Table rangeTable = this.rangeVariables[i].rangeTable;
            NameManager.ObjectName name = rangeTable.getObjectName();
            if (rangeTable.isReadOnly() || rangeTable.isTemp() || name.schema == SqlInvariants.SYSTEM_SCHEMA_NAME) continue;
            set.add(name);
        }
        for (i = 0; i < this.subqueries.length; ++i) {
            if (this.subqueries[i].queryExpression == null) continue;
            this.subqueries[i].queryExpression.getBaseTableNames(set);
        }
        for (i = 0; i < this.routines.length; ++i) {
            set.addAll(this.routines[i].getTableNamesForRead());
        }
    }

    @Override
    void collectTableNamesForWrite(OrderedHashSet set) {
    }

    Object[] getExpressionValues(Session session) {
        Object[] values = null;
        if (this.expressions != null) {
            values = new Object[this.expressions.length];
            for (int i = 0; i < this.expressions.length; ++i) {
                values[i] = this.expressions[i].getValue(session);
            }
        } else if (this.expression != null) {
            if (this.expression.getType() == 25) {
                values = this.expression.getRowValue(session);
            } else if (this.expression.getType() == 22) {
                if (this.expression.subQuery.queryExpression instanceof QuerySpecification && ((QuerySpecification)this.expression.subQuery.queryExpression).exprColumns != null && ((QuerySpecification)this.expression.subQuery.queryExpression).exprColumns.length == 1 && ((QuerySpecification)this.expression.subQuery.queryExpression).exprColumns[0].opType == 12) {
                    values = new Object[]{((ExpressionColumn)((QuerySpecification)this.expression.subQuery.queryExpression).exprColumns[0]).sequence.getLastValue()};
                } else {
                    values = this.expression.subQuery.queryExpression.getSingleRowValues(session);
                    if (values == null) {
                        return null;
                    }
                    this.cloneOtherTypeWrappers(values);
                }
            } else if (this.expression instanceof ExecImmediateExpression) {
                values = StatementSet.convertRowSetToValue(session, this.targets[0].getDataType(), (RowSet)this.expression.getValue(session), this);
            } else {
                values = new Object[1];
                if (this.expression instanceof ExternalExecutionExpression) {
                    ((ExternalExecutionExpression)this.expression).setParentSetStatement(this);
                }
                values[0] = this.expression.getValue(session);
                if (OtherTypeWrapper.unwrap(values[0]) instanceof RowSet && (this.expression instanceof FunctionUnitCall && ((FunctionUnitCall)this.expression).getEntry() instanceof SysFunctionUnit.AbstractGetQueryEntry || this.expression.getType() == 103 && ((ExpressionOp)this.expression).getMethodName() != null && (((ExpressionOp)this.expression).getMethodName().equals("query") || ((ExpressionOp)this.expression).getMethodName().equals("executeQuery")))) {
                    values = StatementSet.convertRowSetToValue(session, this.targets[0].getDataType(), (RowSet)OtherTypeWrapper.unwrap(values[0]), this);
                }
            }
        } else {
            throw new DataspaceException("Invalid statement set.");
        }
        return values;
    }

    private static Object[] convertRowSetToValue(Session session, Type targetType, RowSet rowSet, StatementSet statementSet) {
        OtherType type;
        Object[] values = null;
        if (targetType instanceof OtherType && ((type = (OtherType)targetType).getInternalClass(session) == RowSet.class || type.userTypeModifier != null && type.userTypeModifier.getName() != null && type.userTypeModifier.getName().name.equalsIgnoreCase("rowset"))) {
            values = new Object[]{rowSet};
        }
        if (values == null) {
            try {
                if (rowSet.getMeta().getColumnCount() == 1) {
                    int i = 0;
                    values = new Object[rowSet.getRowCount()];
                    while (rowSet.next()) {
                        values[i++] = OtherTypeWrapper.unwrap(rowSet.getObject(1));
                    }
                } else {
                    if (rowSet.getRowCount() != 1) {
                        throw Error.error(3201, new Object[]{statementSet.getSQL()});
                    }
                    values = new Object[rowSet.getMeta().getColumnCount()];
                    rowSet.next();
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = rowSet.getObject(i + 1);
                    }
                }
                if (values.length == 0) {
                    values = new Object[]{null};
                } else if (targetType.isArrayType() || targetType.isCollectionType()) {
                    values = new Object[]{values};
                }
            }
            catch (SQLException exception) {
                throw new DataspaceException(exception);
            }
        }
        return values;
    }

    Result executeAssignment(Session session, Object value, int j) {
        int colIndex = this.variableIndexes[j];
        Object currentValue = null;
        switch (this.targets[j].getColumn().getObjectType()) {
            case 24: {
                currentValue = session.sessionContext.rplArguments[colIndex];
                break;
            }
            case 23: {
                currentValue = session.sessionContext.routineVariables[colIndex];
                break;
            }
            case 33: {
                if (this.targets[j].getRangeVariable() != null && this.targets[j].getRangeVariable().getParentRplBlock() != null) {
                    currentValue = this.targets[j].getRangeVariable().getParentRplBlock().getTransientVariable(colIndex);
                    break;
                }
                throw new DataspaceException("Unable to evaluate transient variable.");
            }
            case 10: {
                if (this.targets[j].getRangeVariable() == null || this.targets[j].getRangeVariable().rangePosition == -1) {
                    throw new DataspaceException("Invalid range variable or range position for target " + String.valueOf(this.targets[j]));
                }
                currentValue = session.sessionContext.triggerArguments[this.targets[j].getRangeVariable().rangePosition][colIndex];
            }
        }
        if (currentValue instanceof OtherTypeWrapper && ((OtherTypeWrapper)currentValue).getObject() instanceof CloseableWrapper) {
            ((CloseableWrapper)((OtherTypeWrapper)currentValue).getObject()).close();
        } else if (currentValue instanceof CloseableWrapper) {
            ((CloseableWrapper)currentValue).close();
        }
        if (this.targets[j] instanceof ExpressionColumnAccessor && ((ExpressionColumnAccessor)this.targets[j]).getSpath() != null) {
            Object temp = currentValue;
            temp = OtherTypeWrapper.unwrap(temp);
            if ((value = OtherTypeWrapper.unwrap(value)) != null && value.getClass().isArray()) {
                Object[] valueUnwrapped = new Object[Array.getLength(value)];
                for (int i = 0; i < valueUnwrapped.length; ++i) {
                    valueUnwrapped[i] = OtherTypeWrapper.unwrap(Array.get(value, i));
                }
                value = valueUnwrapped;
            }
            try {
                ExpressionColumnAccessor expressionColumnAccessor = (ExpressionColumnAccessor)this.targets[j];
                String spath = expressionColumnAccessor.getSpath();
                if (temp instanceof ImmutableEventDatagram) {
                    if (expressionColumnAccessor.setMethod == null && temp != null) {
                        expressionColumnAccessor.resolveSetMethodForClass(session, temp.getClass(), spath);
                    }
                    if (expressionColumnAccessor.setMethod != null) {
                        if (!expressionColumnAccessor.setMethod.isAccessible()) {
                            expressionColumnAccessor.setMethod.setAccessible(true);
                        }
                        if (value instanceof BinaryData) {
                            value = ((BinaryData)value).getBytes();
                        }
                        if (value != null && value.getClass() == byte[].class && expressionColumnAccessor.setMethod.getParameterTypes()[0] == Byte[].class) {
                            value = BinaryData.convertToByte((byte[])value);
                        }
                        expressionColumnAccessor.setMethod.invoke(temp, value);
                        return Result.updateNoResult;
                    }
                    String fieldName = spath.substring(1);
                    int pos = fieldName.indexOf("/");
                    if (pos != -1) {
                        fieldName = fieldName.substring(0, pos);
                        Method getMethod = expressionColumnAccessor.resolveGetMethodForField(session, temp.getClass(), fieldName);
                        if (getMethod != null) {
                            temp = getMethod.invoke(temp, new Object[0]);
                            spath = spath.substring(pos + 1);
                            if (temp == null) {
                                throw new DataspaceException("Cannot set '" + spath + "' on null value '" + fieldName + "'.");
                            }
                            if (spath.length() > 0) {
                                expressionColumnAccessor.resolveDataTypeFrom(session, temp.getClass(), spath);
                            }
                        }
                    }
                }
                if (spath != null && spath.length() > 0) {
                    value = expressionColumnAccessor.getDataType().convertSQLToJava(session, value);
                }
                if (temp instanceof EventDatagram && spath.length() > 0) {
                    if (((EventDatagram)temp).existsEventProperty(spath.substring(1))) {
                        if (value != null) {
                            value = TypeFactory.convertPropertyValue(((EventDatagram)temp).getEventPropertyType(spath.substring(1)), value);
                        }
                        ((EventDatagram)temp).setEventObjectProperty(spath.substring(1), value);
                    }
                    throw new DataspaceException("Event field values can be set with setters only.");
                }
                if (((ExpressionColumnAccessor)this.targets[j]).root != null) {
                    Object rootValue = ((ExpressionColumnAccessor)this.targets[j]).root.getValue(session);
                    rootValue = OtherTypeWrapper.unwrap(rootValue);
                    session.sessionContext.sdrManager.setValueAtPath("//" + spath, rootValue, value, true);
                }
                session.sessionContext.sdrManager.setValueAtPath("/" + spath, temp, value, true);
            }
            catch (Throwable exception) {
                if (exception instanceof InvocationTargetException) {
                    exception = ((InvocationTargetException)exception).getCause();
                }
                if (Trace.isDebugEnabled(this.getClass())) {
                    Trace.logException(this, exception, true);
                }
                throw new DataspaceException(Utils.formatExceptionWithUnrepeatedCauses(exception));
            }
        } else if (this.targets[j].getType() == 99) {
            if (((ExpressionArrayAccessor)this.targets[j]).isRoot) {
                value = OtherTypeWrapper.unwrap(value);
                currentValue = ((ExpressionArrayAccessor)this.targets[j]).updateArrayValue(session, currentValue, value, false, true);
            } else {
                value = OtherTypeWrapper.unwrap(value);
                ((ExpressionArrayAccessor)this.targets[j]).updateArrayValue(session, value, false);
            }
        } else {
            currentValue = this.targets[j].getDataType() instanceof OtherType && !(value instanceof OtherTypeWrapper) ? new OtherTypeWrapper(value) : value;
        }
        switch (this.targets[j].getColumn().getObjectType()) {
            case 24: {
                session.sessionContext.rplArguments[colIndex] = currentValue;
                break;
            }
            case 23: {
                session.sessionContext.routineVariables[colIndex] = currentValue;
                break;
            }
            case 33: {
                if (this.targets[j].getRangeVariable() != null && this.targets[j].getRangeVariable().getParentRplBlock() != null) {
                    this.targets[j].getRangeVariable().getParentRplBlock().setTransientVariable(colIndex, currentValue);
                    break;
                }
                throw new DataspaceException("Unable to set transient variable. ");
            }
            case 10: {
                if (this.targets[j].getRangeVariable() == null || this.targets[j].getRangeVariable().rangePosition == -1) {
                    throw new DataspaceException("Invalid range variable or range position for target " + String.valueOf(this.targets[j]));
                }
                session.sessionContext.triggerArguments[this.targets[j].getRangeVariable().rangePosition][colIndex] = currentValue;
            }
        }
        return Result.updateNoResult;
    }

    @Override
    public void setDatabaseObjects(Session session, ParserDQL.CompileContext compileContext) {
        super.setDatabaseObjects(session, compileContext);
        if (this.expression != null && this.expression instanceof ReadTakeExpression) {
            this.expression.collectObjectNames(this.references);
        }
    }
}

