/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.statement;

import com.streamscape.ds.CheckpointManager;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.DataspaceDateTime;
import com.streamscape.ds.lib.HsqlArrayList;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.navigator.RowSetNavigatorClient;
import com.streamscape.ds.parser.ParserDDL;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.parser.statement.StatementDMQL;
import com.streamscape.ds.persist.LogRecordType;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultMetaData;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.collection.Tuple;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.schema.server.AbstractVirtualClientServerObject;
import com.streamscape.ds.schema.server.NoSqlServerObject;
import com.streamscape.ds.schema.server.ServerRole;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.transaction.TransactionManagerMVCC;
import com.streamscape.ds.types.IntervalSecondData;
import com.streamscape.ds.types.Type;
import com.streamscape.sef.dataspace.DataspaceManagerException;
import com.streamscape.slex.SizeUnit;
import com.streamscape.slex.file.SLFileSessionContext;
import com.streamscape.slex.lang.AbstractDSLOperation;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class StatementSession
extends Statement {
    public static final StatementSession commitNoChainStatement = new StatementSession(11, new Object[]{Boolean.FALSE});
    public static final StatementSession rollbackNoChainStatement = new StatementSession(62, new Object[]{Boolean.FALSE});
    public static final StatementSession commitAndChainStatement = new StatementSession(11, new Object[]{Boolean.TRUE});
    public static final StatementSession rollbackAndChainStatement = new StatementSession(62, new Object[]{Boolean.TRUE});
    Expression[] expressions;
    Object[] parameters;

    public StatementSession(int type, Expression[] args) {
        super(type);
        this.expressions = args;
        this.isTransactionStatement = false;
        this.isLogged = false;
        switch (type) {
            case 66: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 136: 
            case 3284: {
                this.group = 2008;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StateemntSession");
            }
        }
    }

    public StatementSession(int type, Object[] args) {
        super(type);
        this.parameters = args;
        this.isTransactionStatement = false;
        this.isLogged = false;
        switch (type) {
            case 74: {
                this.group = 2008;
                this.isLogged = true;
                break;
            }
            case 71: 
            case 3243: 
            case 3244: {
                this.group = 2008;
                this.isLogged = false;
                break;
            }
            case 3284: {
                this.group = 2008;
                this.isLogged = true;
                break;
            }
            case 1076: 
            case 3290: {
                this.group = 2011;
                this.isLogged = false;
                break;
            }
            case 3135: 
            case 3184: {
                this.group = 2011;
                this.isLogged = true;
                break;
            }
            case 3136: 
            case 3170: 
            case 3185: {
                this.group = 2011;
                this.isLogged = false;
                break;
            }
            case 3223: 
            case 3224: {
                this.group = 2011;
                this.isLogged = false;
                break;
            }
            case 1: {
                this.group = 2003;
                break;
            }
            case 2: 
            case 15: 
            case 16: {
                this.group = 2016;
                break;
            }
            case 38: {
                this.group = 2004;
                break;
            }
            case 37: 
            case 39: 
            case 40: {
                this.group = 2003;
                break;
            }
            case 45: 
            case 47: 
            case 53: 
            case 98: 
            case 99: {
                this.group = 2003;
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                this.group = 2016;
                break;
            }
            case 22: {
                this.group = 2006;
                break;
            }
            case 67: 
            case 68: 
            case 70: 
            case 109: 
            case 110: 
            case 118: 
            case 136: 
            case 1064: 
            case 1065: 
            case 1066: {
                this.group = 2011;
                break;
            }
            case 1035: {
                this.isLogged = true;
                this.group = 2011;
                break;
            }
            case 11: 
            case 57: 
            case 62: 
            case 63: 
            case 75: 
            case 111: 
            case 1067: {
                this.group = 2005;
                break;
            }
            case 32: 
            case 1068: {
                this.group = 2008;
                break;
            }
            case 3041: {
                this.group = 2008;
                break;
            }
            case 1092: 
            case 1093: 
            case 1094: 
            case 1095: 
            case 3131: 
            case 3132: 
            case 3133: 
            case 3317: {
                this.group = 2011;
                break;
            }
            case 3263: {
                this.group = 2011;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementSession");
            }
        }
    }

    public StatementSession(int type, NameManager.ObjectName[] readNames, NameManager.ObjectName[] writeNames) {
        super(type);
        this.isTransactionStatement = true;
        this.readTableNames = readNames;
        this.writeTableNames = writeNames;
        switch (type) {
            case 1063: {
                this.group = 2015;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementSession");
            }
        }
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
        }
        catch (Throwable t) {
            result = Result.newErrorResult(t, null);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
            return result;
        }
        try {
            if (this.isLogged) {
                if (this.type == 74) {
                    session.dataspaceStore.dataspaceLogger.writeOtherStatement(session, LogRecordType.SESSION, this.sql, (NameManager.ObjectName)this.parameters[0]);
                } else {
                    session.dataspaceStore.dataspaceLogger.writeOtherStatement(session, LogRecordType.SESSION, this.sql, null);
                }
            }
        }
        catch (Throwable e) {
            return Result.newErrorResult(e, this.sql);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    Result getResult(Session session) {
        startTransaction = false;
        if (this.isExplain) {
            return Result.newSingleColumnStringResult("OPERATION", this.describe(session));
        }
        switch (this.type) {
            case 1: 
            case 2: {
                return Result.updateNoResult;
            }
            case 11: {
                try {
                    chain = (Boolean)this.parameters[0];
                    session.commit(chain);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 15: 
            case 16: {
                return Result.updateNoResult;
            }
            case 22: {
                session.close();
                return Result.updateNoResult;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 45: 
            case 47: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 98: 
            case 99: {
                return Result.updateNoResult;
            }
            case 1063: {
                return Result.updateNoResult;
            }
            case 57: {
                savepoint = (String)this.parameters[0];
                try {
                    session.releaseSavepoint(savepoint);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 62: {
                chain = (Boolean)this.parameters[0];
                session.rollback(chain);
                return Result.updateNoResult;
            }
            case 1067: {
                savepoint = (String)this.parameters[0];
                try {
                    session.rollbackToSavepoint(savepoint);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 63: {
                savepoint = (String)this.parameters[0];
                session.savepoint(savepoint);
                return Result.updateNoResult;
            }
            case 66: {
                try {
                    name = (String)this.expressions[0].getValue(session);
                    name = (String)Type.SQL_VARCHAR.trim(session, name, 32, true, true);
                    if (session.dataspaceStore.getCatalogName().name.equals(name)) {
                        return Result.updateNoResult;
                    }
                    return Result.newErrorResult(Error.error(4840), this.sql);
                }
                catch (DataspaceException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 3135: {
                fetchSize = (Integer)this.parameters[0];
                if (fetchSize < -1) {
                    throw new DataspaceException("Fetch size should be greater or equals to -1.");
                }
                session.setFetchSize(fetchSize);
                if (session.getResultMemoryRowCount() == 0) {
                    return Result.newWarningResult(new DataspaceException("Session result memory rows count is still 0, it means that all query result rows will be loaded to the memory on the server side independently on fetch size."));
                }
                return Result.updateNoResult;
            }
            case 3136: {
                result = Result.newDataResult(ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_INTEGER}, new String[]{"Fetch Size"}));
                navigator = new RowSetNavigatorClient();
                result.setNavigator(navigator);
                navigator.add(new Object[]{session.getFetchSize()});
                return result;
            }
            case 3223: {
                serverObject = (AbstractVirtualClientServerObject)this.parameters[0];
                if (serverObject.getServerRole() == ServerRole.MESSAGE || serverObject.getServerRole() == ServerRole.NOSQL && NoSqlServerObject.NoSqlServerType.DYNAMODB.name().equalsIgnoreCase(serverObject.getServerType())) {
                    if (!serverObject.isRunning()) {
                        throw new DataspaceException("Server not started.");
                    }
                } else if (serverObject.getServerRole() != ServerRole.WEB) {
                    throw new DataspaceException("Switching to context of " + String.valueOf((Object)serverObject.getServerRole()) + " server not allowed. Allowed servers: Message, WEB, NOSQL(DynamoDB).");
                }
                session.serverContext = serverObject;
                return Result.updateNoResult;
            }
            case 3184: {
                transferBufferSize = (Integer)this.parameters[0];
                if (transferBufferSize <= 0) {
                    throw new DataspaceException("Fetch size should be greater or equals to 0.");
                }
                session.setTransferBufferSize(transferBufferSize);
                return Result.updateNoResult;
            }
            case 3185: {
                result = Result.newDataResult(ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR}, new String[]{"Transfer Buffer Size"}));
                navigator = new RowSetNavigatorClient();
                result.setNavigator(navigator);
                navigator.add(new Object[]{SizeUnit.convertToBestFractional(session.getTransferBufferSize(), SizeUnit.BYTES).toString()});
                return result;
            }
            case 67: 
            case 68: 
            case 70: {
                return Result.updateNoResult;
            }
            case 3284: {
                ccsid = (String)this.parameters[0];
                session.setSessionCCSID(ccsid);
                return Result.updateNoResult;
            }
            case 71: {
                value = null;
                if (this.expressions == null || this.expressions.length <= 0) ** GOTO lbl125
                if (this.expressions[0].getType() == 1 && this.expressions[0].getConstantValueNoCheck(session) == null) {
                    session.setZoneSeconds(-1);
                    return Result.updateNoResult;
                }
                try {
                    value = this.expressions[0].getValue(session);
                }
                catch (DataspaceException navigator) {
                    // empty catch block
                }
                if (!(value instanceof Result)) ** GOTO lbl119
                result = (Result)value;
                if (!result.isData()) ** GOTO lbl118
                data = result.getNavigator().getNext();
                v0 = single = result.getNavigator().next() == false;
                if (single && data != null && data[0] != null) {
                    value = data[0];
                    result.getNavigator().release();
                } else {
                    result.getNavigator().release();
                    return Result.newErrorResult(Error.error(3409), this.sql);
lbl118:
                    // 1 sources

                    return Result.newErrorResult(Error.error(3409), this.sql);
lbl119:
                    // 1 sources

                    if (value == null) {
                        return Result.newErrorResult(Error.error(3409), this.sql);
                    }
                }
                if (-50400L <= (seconds = ((IntervalSecondData)value).getSeconds()) && seconds <= 50400L) {
                    session.setZoneSeconds((int)seconds);
                    return Result.updateNoResult;
                }
                return Result.newErrorResult(Error.error(3409), this.sql);
lbl125:
                // 1 sources

                timeZoneId = (String)this.parameters[0];
                try {
                    timeZone = TimeZone.getTimeZone(timeZoneId);
                    session.dataspaceStore.setTimeZone(timeZone);
                    DataspaceStore.getContext().getDataspaceManager().setTimezone(timeZone);
                }
                catch (DataspaceManagerException exception) {
                    throw new DataspaceException(exception);
                }
                return Result.newSingleColumnStringResult("Time Zone", timeZoneId);
            }
            case 3243: {
                result = Result.newDataResult(ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING, Type.STRING}, new String[]{"Name", "Time Zone", "Time Zone Offset"}));
                navigator = new RowSetNavigatorClient();
                result.setNavigator(navigator);
                timeZoneInProperty = session.dataspaceStore.dataspaceStoreProperties.getStringProperty("dtspace.timezone");
                navigator.add(new Object[]{"In Session", session.getTimeZone().getID(), DataspaceDateTime.formatTimeZoneOffset(session.getZoneSeconds())});
                navigator.add(new Object[]{"In Configuration", timeZoneInProperty, timeZoneInProperty != null ? DataspaceDateTime.formatTimeZoneOffset(timeZoneInProperty) : ""});
                return result;
            }
            case 3244: {
                result = Result.newDataResult(ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING}, new String[]{"Time Zone", "Time Zone Offset"}));
                navigator = new RowSetNavigatorClient();
                result.setNavigator(navigator);
                Arrays.asList(TimeZone.getAvailableIDs()).stream().forEach((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getResult$0(com.streamscape.ds.navigator.RowSetNavigatorClient java.lang.String ), (Ljava/lang/String;)V)((RowSetNavigatorClient)navigator));
                return result;
            }
            case 72: {
                return Result.updateNoResult;
            }
            case 69: {
                return Result.updateNoResult;
            }
            case 73: {
                role = null;
                try {
                    name = (String)this.expressions[0].getValue(session);
                    if (name != null) {
                        name = (String)Type.SQL_VARCHAR.trim(session, name, 32, true, true);
                        role = session.dataspaceStore.granteeManager.getGroup(name);
                    }
                }
                catch (DataspaceException e) {
                    return Result.newErrorResult(Error.error(2200), this.sql);
                }
                if (session.isInMidTransaction()) {
                    return Result.newErrorResult(Error.error(3701), this.sql);
                }
                if (role == null) {
                    session.setRole(null);
                }
                if (session.getGrantee().hasRole(role)) {
                    session.setRole(role);
                    return Result.updateNoResult;
                }
                return Result.newErrorResult(Error.error(2200), this.sql);
            }
            case 74: {
                try {
                    name = this.expressions == null ? ((NameManager.ObjectName)this.parameters[0]).name : (String)this.expressions[0].getValue(session);
                    name = (String)Type.SQL_VARCHAR.trim(session, name, 32, true, true);
                    schema = session.dataspaceStore.schemaManager.getSchemaHsqlName(name);
                    session.setDataspace(schema.name);
                    if (this.parameters != null && this.parameters.length > 1 && ((Boolean)this.parameters[1]).booleanValue()) {
                        session.setSDSRuntimeSession(false);
                    }
                    return Result.updateNoResult;
                }
                catch (DataspaceException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 76: {
                if (session.isInMidTransaction()) {
                    return Result.newErrorResult(Error.error(3701), this.sql);
                }
                try {
                    password = null;
                    user = (String)this.expressions[0].getValue(session);
                    user = (String)Type.SQL_VARCHAR.trim(session, user, 32, true, true);
                    if (this.expressions[1] != null) {
                        password = (String)this.expressions[1].getValue(session);
                    }
                    sysUser = false;
                    if (this.expressions[2] == Expression.EXPR_TRUE) {
                        sysUser = true;
                    }
                    try {
                        userObject = password == null ? session.dataspaceStore.userManager.get(user) : session.dataspaceStore.getUserManager().getUser(user, password);
                    }
                    catch (Exception error) {
                        if (sysUser) {
                            userObject = session.dataspaceStore.getUserManager().getSysUser();
                        }
                        throw error;
                    }
                    if (userObject == null) {
                        throw Error.error(4001);
                    }
                    this.sql = userObject.getConnectUserSQL();
                    if (userObject == session.getGrantee()) {
                        return Result.updateNoResult;
                    }
                    if (password == null && !session.isProcessingRecoveryLog() && userObject.isAdmin() && !session.getGrantee().isAdmin()) {
                        throw Error.error(4000);
                    }
                    if (session.getGrantee().canChangeAuthorisation()) {
                        session.setUser(userObject);
                        session.setRole(null);
                        session.resetSchema();
                        return Result.updateNoResult;
                    }
                    throw Error.error(4000);
                }
                catch (Exception e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 109: {
                try {
                    if (this.parameters[0] != null) {
                        readonly = (Boolean)this.parameters[0];
                        session.setReadOnlyDefault(readonly);
                    }
                    if (this.parameters[1] != null) {
                        level = (Integer)this.parameters[1];
                        session.setIsolationDefault(level);
                    }
                    return Result.updateNoResult;
                }
                catch (DataspaceException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 110: {
                try {
                    session.setSLFileSessionContext((SLFileSessionContext)this.parameters[0]);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 136: {
                return Result.updateNoResult;
            }
            case 118: {
                return Result.updateNoResult;
            }
            case 111: {
                startTransaction = true;
            }
            case 75: {
                try {
                    if (this.parameters[0] != null) {
                        readonly = (Boolean)this.parameters[0];
                        session.setReadOnly(readonly);
                    }
                    if (this.parameters[1] != null) {
                        level = (Integer)this.parameters[1];
                        session.setIsolation(level);
                    }
                    if (startTransaction) {
                        session.startTransaction();
                    }
                    return Result.updateNoResult;
                }
                catch (DataspaceException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 3131: {
                return Result.updateNoResult;
            }
            case 3132: {
                return Result.updateNoResult;
            }
            case 3133: {
                routine = (RplScript)this.parameters[0];
                withError = (Boolean)this.parameters[1];
                errorTextExpression = (Expression)this.parameters[2];
                if (withError) {
                    if (errorTextExpression == null) {
                        throw Error.error(null, 7100, 0, new Object[]{routine.getObjectName().getSchemaQualifiedStatementName()});
                    }
                    error = Error.error(7100);
                    error.setMessage(String.valueOf(errorTextExpression.getValue(session)));
                    throw error;
                }
                throw Error.error(7101);
            }
            case 1064: {
                mode = (Boolean)this.parameters[0];
                try {
                    session.setAutoCommit(mode);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 3224: {
                result = Result.newDataResult(ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_BOOLEAN}, new String[]{"Auto Commit"}));
                navigator = new RowSetNavigatorClient();
                result.setNavigator(navigator);
                navigator.add(new Object[]{session.isAutoCommit()});
                return result;
            }
            case 1076: {
                realDeclare = (Boolean)this.parameters[0];
                if (!realDeclare) {
                    return Result.updateNoResult;
                }
                variables = (ColumnSchema[])this.parameters[1];
                try {
                    for (i = 0; i < variables.length; ++i) {
                        session.sessionContext.addSessionVariable(variables[i]);
                    }
                    return Result.updateNoResult;
                }
                catch (DataspaceException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 3290: {
                variableNames = (List)this.parameters[0];
                session.sessionContext.removeSessionVariables(variableNames.toArray(new String[0]));
                return Result.updateNoResult;
            }
            case 3170: {
                transientCollection = (Collection)this.parameters[0];
                session.sessionContext.addSessionCollection(transientCollection);
                try {
                    return Result.updateNoResult;
                }
                catch (DataspaceException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1093: {
                result = Result.newDataResult(ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Name", "Type"}));
                navigator = new RowSetNavigatorClient();
                result.setNavigator(navigator);
                if (session.sessionContext.getSessionVariables() != null) {
                    variables = session.sessionContext.getSessionVariables().values();
                    iterator = variables.iterator();
                    while (iterator.hasNext()) {
                        variable = (ColumnSchema)iterator.next();
                        navigator.add(new Object[]{variable.getObjectName().name, Tuple.getTypeName(variable)});
                    }
                }
                return result;
            }
            case 1092: {
                result = Result.newDataResult(ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Name", "Type"}));
                navigator = new RowSetNavigatorClient();
                result.setNavigator(navigator);
                if (session.sessionContext.getSessionCollections() != null) {
                    tables = session.sessionContext.getSessionCollections().values();
                    iterator = tables.iterator();
                    while (iterator.hasNext()) {
                        collection = (Collection)iterator.next();
                        navigator.add(new Object[]{collection.getObjectName().name, collection.getCollectionType().name()});
                    }
                }
                return result;
            }
            case 1094: {
                variableName = ((NameManager.ObjectName)this.parameters[0]).getNameString();
                columnIndex = session.sessionContext.sessionVariablesRange[0].findColumn(variableName);
                if (columnIndex == -1) {
                    throw Error.error(5501, variableName);
                }
                result = Result.newDataResult(ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR}, new String[]{"@" + variableName}));
                navigator = new RowSetNavigatorClient();
                result.setNavigator(navigator);
                navigator.add(new Object[]{session.sessionContext.routineVariables[columnIndex]});
                return result;
            }
            case 3317: {
                result = Result.newDataResult(ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Property", "Value"}));
                navigator = new RowSetNavigatorClient();
                result.setNavigator(navigator);
                txManager = session.dataspaceStore.txManager;
                if (txManager instanceof TransactionManagerMVCC) {
                    mvccManager = (TransactionManagerMVCC)txManager;
                    mvccManager.describe(navigator);
                }
                return result;
            }
            case 1095: {
                id = (Integer)this.parameters[0];
                thisSession = session;
                if (id >= 0 && (thisSession = session.dataspaceStore.getSessionManager().getSession(id)) == null) {
                    throw new DataspaceException("Session with ID " + id + " not found.");
                }
                result = Result.newDataResult(ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Property", "Value"}));
                navigator = new RowSetNavigatorClient();
                result.setNavigator(navigator);
                navigator.add(new Object[]{"Session Context", String.valueOf(thisSession.getSLResourceName())});
                navigator.add(new Object[]{"Autocommit", String.valueOf(thisSession.sessionContext.isAutoCommit)});
                navigator.add(new Object[]{"Session isolation level", Session.getIsolationString(thisSession.getIsolationDefault())});
                navigator.add(new Object[]{"Session read only", String.valueOf(thisSession.isReadOnlyDefault())});
                navigator.add(new Object[]{"Transaction isolation level", Session.getIsolationString(thisSession.getIsolation())});
                navigator.add(new Object[]{"Transaction read only", String.valueOf(thisSession.isReadOnly())});
                navigator.add(new Object[]{"In transaction", String.valueOf(thisSession.isInMidTransaction())});
                currentStat = thisSession.sessionContext.currentStatement != null ? thisSession.sessionContext.currentStatement.getSQL() : "";
                navigator.add(new Object[]{"Current Statement", currentStat});
                lastStat = thisSession.sessionContext.lastStatement != null ? thisSession.sessionContext.lastStatement : "";
                navigator.add(new Object[]{"Last Statement", lastStat});
                navigator.add(new Object[]{"Last Statements In transaction", thisSession.sessionContext.lastStatementsInTransaction.stream().collect(Collectors.joining("\n"))});
                navigator.add(new Object[]{"Max rows", String.valueOf(thisSession.getSQLMaxRows())});
                navigator.add(new Object[]{"Result memory rows", String.valueOf(thisSession.getResultMemoryRowCount())});
                navigator.add(new Object[]{"Fetch Size", String.valueOf(thisSession.getFetchSize())});
                navigator.add(new Object[]{"Session File Context", thisSession.getSLFileSessionContext().toString().toLowerCase()});
                navigator.add(new Object[]{"Session Timeout", thisSession.getRequestTimeout() / 1000L + " seconds"});
                navigator.add(new Object[]{"Timezone", thisSession.dataspaceStore.getTimeZone().getID()});
                navigator.add(new Object[]{"Timezone Offset", DataspaceDateTime.formatTimeZoneOffset(thisSession.getZoneSeconds())});
                navigator.add(new Object[]{"CCSID", thisSession.getSessionCCSID().toString()});
                transientCollections = thisSession.dataspaceStore.schemaManager.listTransientCollections();
                if (transientCollections != null && transientCollections.size() > 0) {
                    first = true;
                    for (i = 0; i < transientCollections.size(); ++i) {
                        if (first) {
                            navigator.add(new Object[]{"Transient Collections", transientCollections.get((int)i).getObjectName().name});
                            first = false;
                            continue;
                        }
                        navigator.add(new Object[]{"", transientCollections.get((int)i).getObjectName().name});
                    }
                } else {
                    navigator.add(new Object[]{"Transient Collections", ""});
                }
                if (thisSession.sessionContext.getSessionVariables() != null && thisSession.sessionContext.getSessionVariables().size() > 0) {
                    first = true;
                    variables = thisSession.sessionContext.getSessionVariables().values();
                    iterator = variables.iterator();
                    while (iterator.hasNext()) {
                        variable = (ColumnSchema)iterator.next();
                        if (first) {
                            navigator.add(new Object[]{"Session Variables", variable.getObjectName().name});
                            first = false;
                            continue;
                        }
                        navigator.add(new Object[]{"", variable.getObjectName().name});
                    }
                } else {
                    navigator.add(new Object[]{"Session Variables", ""});
                }
                return result;
            }
            case 3263: {
                attempts = (Boolean)this.parameters[0];
                checkpointManager = session.dataspaceStore.checkpointManager;
                if (checkpointManager == null) {
                    throw new DataspaceException("Checkpoint manager is null.");
                }
                totalStats = checkpointManager.getTotalStats();
                if (!attempts) {
                    result = Result.newDataResult(ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Property", "Value"}));
                    navigator = new RowSetNavigatorClient();
                    result.setNavigator(navigator);
                    navigator.add(new Object[]{"Checkpoint Interval", checkpointManager.getCheckpointInterval() + " ms"});
                    navigator.add(new Object[]{"Checkpoint Interval Repeat", checkpointManager.getCheckpointIntervalRepeat() + " ms"});
                    navigator.add(new Object[]{"Checkpoint Interval Critical", checkpointManager.getCheckpointIntervalCritical() + " ms"});
                    navigator.add(new Object[]{"Checkpoint Lock Timeout1", checkpointManager.getCheckpointLockTimeout1()});
                    navigator.add(new Object[]{"Checkpoint Lock Timeout2", checkpointManager.getCheckpointLockTimeout2()});
                    navigator.add(new Object[]{"Checkpoint Consistency Check", checkpointManager.isCheckpointCheckConsistency() != false ? "enabled" : "disabled"});
                    navigator.add(new Object[]{"Log Size Max", SizeUnit.convertToBestFractional(checkpointManager.getLogSizeMax(), SizeUnit.BYTES).toStringWithPrecision(2)});
                    navigator.add(new Object[]{"Log Size Critical", SizeUnit.convertToBestFractional(checkpointManager.getLogSizeCritical(), SizeUnit.BYTES).toStringWithPrecision(2)});
                    navigator.add(new Object[]{"----------------------------", "------------------"});
                    navigator.add(new Object[]{"Current Log Size", SizeUnit.convertToBestFractional(checkpointManager.getRecoveryLogSize(), SizeUnit.BYTES).toStringWithPrecision(2)});
                    navigator.add(new Object[]{"Last Checkpoint Attempt", checkpointManager.getLastCheckpointAttemptTimestamp() != 0L ? AbstractDSLOperation.formatDateMillis(checkpointManager.getLastCheckpointAttemptTimestamp()) : "n/a"});
                    navigator.add(new Object[]{"Last Checkpoint Successful", checkpointManager.getLastCheckpointSuccessfulTimestamp() != 0L ? AbstractDSLOperation.formatDateMillis(checkpointManager.getLastCheckpointSuccessfulTimestamp()) : "n/a"});
                    navigator.add(new Object[]{"Checkpoint is Managed by MVCC", checkpointManager.isCheckpointManagedByMVCC()});
                    navigator.add(new Object[]{"Checkpoint is Required", checkpointManager.isCheckpointRequired()});
                    navigator.add(new Object[]{"Checkpoint is In Progress", checkpointManager.isCheckpointInProgress()});
                    navigator.add(new Object[]{"Next Scheduled Checkpoint At", checkpointManager.getNextCheckpointTimestamp() != 0L ? AbstractDSLOperation.formatDateMillis(checkpointManager.getNextCheckpointTimestamp()) : "n/a"});
                    navigator.add(new Object[]{"----------------------------", "------------------"});
                    navigator.add(new Object[]{"Checkpoint Manager Start Time", AbstractDSLOperation.formatDateMillis(totalStats.getStartTime())});
                    navigator.add(new Object[]{"Total Checkpoint Attempts ", totalStats.getAttemptsCount()});
                    navigator.add(new Object[]{"Auto Checkpoint Attempts ", totalStats.getAttemptsCountAuto()});
                    navigator.add(new Object[]{"Successful Checkpoints Count", totalStats.getSuccessCount()});
                    navigator.add(new Object[]{"Fail Checkpoints Count", totalStats.getFailCount()});
                    navigator.add(new Object[]{"Average Auto Checkpoint Duration", totalStats.getAverageAutoDuration() + " ms"});
                    return result;
                }
                result = Result.newDataResult(ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Start Time", "End Time", "Lock Duration", "Duration", "Action", "Log Size", "Lock Timeout", "With Defrag", "Forced Defrag", "Duplicates Before/After", "Success"}));
                navigator = new RowSetNavigatorClient();
                result.setNavigator(navigator);
                for (CheckpointManager.CheckpointStats.CheckpointAttempt attempt : totalStats.getAttempts()) {
                    navigator.add(new Object[]{AbstractDSLOperation.formatDateMillis(attempt.getStartTimestamp()), AbstractDSLOperation.formatDateMillis(attempt.getEndTimestamp()), attempt.getLockDuration() + " ms", attempt.getDuration() + " ms", attempt.getAction() != null ? String.valueOf(attempt.getAction().getName()) : "manual", SizeUnit.convertToBestFractional(attempt.getLogSize(), SizeUnit.BYTES).toStringWithPrecision(2), attempt.getLockTimeout() + " ms", attempt.isDefrag(), attempt.isForcedDefrag(), (String)(attempt.getDuplicatesBefore() != null ? "" + attempt.getDuplicatesBefore().getDuplicateKeysCount() : "") + "/" + (String)(attempt.getDuplicatesAfter() != null ? "" + attempt.getDuplicatesAfter().getDuplicateKeysCount() : ""), attempt.isSuccess()});
                }
                return result;
            }
            case 1065: {
                size = (Integer)this.parameters[0];
                session.setSQLMaxRows(size);
                return Result.updateNoResult;
            }
            case 1066: {
                size = (Integer)this.parameters[0];
                session.setResultMemoryRowCount(size);
                return Result.updateNoResult;
            }
            case 1035: {
                try {
                    mode = (Boolean)this.parameters[0];
                    session.setIgnoreCase(mode);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1068: {
                table = (Table)this.parameters[0];
                tempConstraints = (HsqlArrayList)this.parameters[1];
                statement = (StatementDMQL)this.parameters[2];
                collection = (Collection)this.parameters[3];
                try {
                    if (tempConstraints.size() != 0) {
                        table = ParserDDL.addTableConstraintDefinitions(session, table, tempConstraints, null, false);
                    }
                    table.compile(session, null);
                    session.sessionContext.addSessionCollection(collection);
                    if (table.hasLobColumn()) {
                        throw Error.error(5534);
                    }
                    if (statement != null) {
                        result = statement.execute(session);
                        table.insertIntoTable(session, result);
                    }
                    return Result.updateNoResult;
                }
                catch (DataspaceException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 32: {
                name = (NameManager.ObjectName)this.parameters[0];
                ifExists = (Boolean)this.parameters[1];
                collection = session.sessionContext.findSessionCollection(name.name);
                if (collection == null) {
                    if (ifExists.booleanValue()) {
                        return Result.updateNoResult;
                    }
                    throw Error.error(5501, name.name);
                }
                session.sessionContext.dropSessionCollection(name.name);
                return Result.updateNoResult;
            }
            case 3041: {
                result = Result.newSingleColumnResult("Current User");
                result.getNavigator().add(new Object[]{session.getUser().getObjectName().name});
                return result;
            }
        }
        throw Error.runtimeError(201, "StatementSession");
    }

    @Override
    public boolean isAutoCommitStatement() {
        return false;
    }

    @Override
    public String describe(Session session) {
        return this.sql;
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("sql", this.sql);
        return result;
    }

    @Override
    public boolean isCatalogLock() {
        return false;
    }

    @Override
    public boolean isCatalogChange() {
        return false;
    }

    @Override
    public String getSQL() {
        switch (this.type) {
            case 1076: {
                return "transient var";
            }
        }
        return super.getSQL();
    }

    @Override
    public void resolve(Session session) {
        this.references = new OrderedHashSet();
    }

    private static /* synthetic */ void lambda$getResult$0(RowSetNavigatorClient navigator, String id) {
        navigator.add(new Object[]{id, DataspaceDateTime.formatTimeZoneOffset(id)});
    }

    static {
        StatementSession.commitNoChainStatement.sql = "COMMIT";
        StatementSession.commitAndChainStatement.sql = "COMMIT CHAIN";
        StatementSession.rollbackNoChainStatement.sql = "ROLLBACK";
        StatementSession.rollbackAndChainStatement.sql = "ROLLBACK CHAIN";
        StatementSession.commitNoChainStatement.compileTimestamp = Long.MAX_VALUE;
        StatementSession.commitAndChainStatement.compileTimestamp = Long.MAX_VALUE;
        StatementSession.rollbackNoChainStatement.compileTimestamp = Long.MAX_VALUE;
        StatementSession.rollbackAndChainStatement.compileTimestamp = Long.MAX_VALUE;
    }
}

