/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.statement;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.HsqlArrayList;
import com.streamscape.ds.parser.ParserDDL;
import com.streamscape.ds.parser.statement.StatementSchema;
import com.streamscape.ds.persist.LogRecordType;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.tspace.table.TableCollection;
import com.streamscape.ds.schema.constraint.Constraint;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;

public class StatementSchemaDefinition
extends StatementSchema {
    StatementSchema[] statements;

    public StatementSchemaDefinition(StatementSchema[] statements) {
        this.statements = statements;
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
        }
        catch (Throwable t) {
            result = Result.newErrorResult(t, null);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
        }
        return result;
    }

    @Override
    Result getResult(Session session) {
        int i;
        NameManager.ObjectName schemaDefinitionName = this.statements[0].getSchemaName();
        if (this.isExplain) {
            return Result.newSingleColumnStringResult("OPERATION", this.describe(session));
        }
        Result result = this.statements[0].execute(session);
        HsqlArrayList constraints = new HsqlArrayList();
        StatementSchema log = new StatementSchema(null, 1199);
        if (this.statements.length == 1 || result.isError()) {
            return result;
        }
        NameManager.ObjectName oldSessionSchema = session.getCurrentDataspaceName();
        for (i = 1; i < this.statements.length; ++i) {
            try {
                session.setDataspace(schemaDefinitionName.name);
            }
            catch (DataspaceException dataspaceException) {
                // empty catch block
            }
            this.statements[i].setSchemaHsqlName(schemaDefinitionName);
            session.parser.reset(this.statements[i].getSQL());
            try {
                session.parser.read();
                switch (this.statements[i].getType()) {
                    case 48: 
                    case 49: {
                        result = this.statements[i].execute(session);
                        break;
                    }
                    case 3005: {
                        result = this.statements[i].execute(session);
                        break;
                    }
                    case 77: {
                        StatementSchema cs = (StatementSchema)session.parser.compileCreate();
                        cs.isSchemaDefinition = true;
                        cs.setSchemaHsqlName(schemaDefinitionName);
                        if (session.parser.token.tokenType != 848) {
                            throw session.parser.unexpectedToken();
                        }
                        cs.isLogged = false;
                        result = cs.execute(session);
                        NameManager.ObjectName name = ((Table)cs.arguments[0]).getObjectName();
                        SchemaObject object = session.dataspaceStore.schemaManager.getSchemaObject(name);
                        Table table = null;
                        if (object instanceof Table) {
                            table = (Table)object;
                        } else if (object instanceof TableCollection) {
                            table = ((TableCollection)object).getBaseTable();
                        } else {
                            Trace.logError(this, "Unknown table type: " + object.getClass().getName());
                        }
                        constraints.addAll((HsqlArrayList)cs.arguments[1]);
                        ((HsqlArrayList)cs.arguments[1]).clear();
                        log.sql = table.getSQL();
                        log.execute(session);
                        break;
                    }
                    case 8: 
                    case 10: 
                    case 83: 
                    case 133: {
                        result = this.statements[i].execute(session);
                        break;
                    }
                    case 14: 
                    case 23: 
                    case 84: 
                    case 1074: {
                        StatementSchema cs = (StatementSchema)session.parser.compileCreate();
                        cs.isSchemaDefinition = true;
                        cs.setSchemaHsqlName(schemaDefinitionName);
                        if (session.parser.token.tokenType != 848) {
                            throw session.parser.unexpectedToken();
                        }
                        result = cs.execute(session);
                        break;
                    }
                    case 6: 
                    case 52: 
                    case 79: 
                    case 114: 
                    case 117: {
                        throw session.parser.unsupportedFeature();
                    }
                    default: {
                        throw Error.runtimeError(201, "");
                    }
                }
                if (!result.isError()) continue;
            }
            catch (DataspaceException e) {
                result = Result.newErrorResult(e, this.statements[i].getSQL());
            }
            break;
        }
        if (!result.isError()) {
            try {
                for (i = 0; i < constraints.size(); ++i) {
                    Constraint c = (Constraint)constraints.get(i);
                    Table table = session.dataspaceStore.schemaManager.getUserTable(session, c.core.refTableName);
                    ParserDDL.addForeignKey(session, table, c, null);
                    log.sql = c.getSQL();
                    log.execute(session);
                }
            }
            catch (DataspaceException e) {
                result = Result.newErrorResult(e, this.sql);
            }
        }
        if (result.isError()) {
            try {
                session.dataspaceStore.schemaManager.dropSchema(session, schemaDefinitionName.name, true, false);
                session.dataspaceStore.dataspaceLogger.writeOtherStatement(session, LogRecordType.DROP_DATASPACE, this.getDropSchemaStatement(schemaDefinitionName), null);
            }
            catch (DataspaceException dataspaceException) {
                // empty catch block
            }
        }
        try {
            session.setCurrentDataspaceName(oldSessionSchema);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    String getDropSchemaStatement(NameManager.ObjectName schema) {
        return "DROP SCHEMA " + schema.statementName + " CASCADE";
    }

    @Override
    public boolean isAutoCommitStatement() {
        return true;
    }
}

