/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.statement;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.parser.statement.StatementSchema;
import com.streamscape.ds.parser.statement.StatementSchemaDefinition;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.session.Session;

public class StatementSchemaCompound
extends StatementSchemaDefinition {
    public StatementSchemaCompound(StatementSchema[] statements) {
        super(statements);
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
        }
        catch (Throwable t) {
            result = Result.newErrorResult(t, null);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
        }
        return result;
    }

    @Override
    Result getResult(Session session) {
        if (this.isExplain) {
            return Result.newSingleColumnStringResult("OPERATION", this.describe(session));
        }
        Result result = null;
        for (int i = 0; i < this.statements.length; ++i) {
            session.parser.reset(this.statements[i].getSQL());
            try {
                session.parser.read();
                result = this.statements[i].execute(session);
                if (!result.isError()) continue;
            }
            catch (DataspaceException e) {
                result = Result.newErrorResult(e, this.statements[i].getSQL());
            }
            break;
        }
        return result;
    }
}

