/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.statement;

import com.streamscape.Trace;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.SqlInvariants;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.HsqlArrayList;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.parser.ParserCommand;
import com.streamscape.ds.parser.Scanner;
import com.streamscape.ds.parser.Token;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.persist.LogRecordType;
import com.streamscape.ds.replication.ReplicationEntityName;
import com.streamscape.ds.replication.ReplicationSource;
import com.streamscape.ds.replication.ReplicationTarget;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.DataspaceSchema;
import com.streamscape.ds.schema.SchemaManager;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.AbstractCollection;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.collection.cspace.definitions.KAssertionTypeSchemaObject;
import com.streamscape.ds.schema.collection.cspace.definitions.KGraphTypeSchemaObject;
import com.streamscape.ds.schema.collection.cspace.definitions.KLinkTypeSchemaObject;
import com.streamscape.ds.schema.collection.cspace.definitions.KNodeTypeSchemaObject;
import com.streamscape.ds.schema.collection.cspace.instances.KNode;
import com.streamscape.ds.schema.collection.fspace.table.FileTableCollection;
import com.streamscape.ds.schema.collection.fspace.table.JournalFileTableCollection;
import com.streamscape.ds.schema.collection.fspace.table.LogFileTableCollection;
import com.streamscape.ds.schema.collection.tspace.table.SnapshotCollection;
import com.streamscape.ds.schema.collection.tspace.table.TableCollection;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.constraint.Constraint;
import com.streamscape.ds.schema.constraint.ReferenceLink;
import com.streamscape.ds.schema.table.FileTable;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.TableWorks;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.EventTriggerDefSQL;
import com.streamscape.ds.trigger.TriggerDef;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.utils.SqlUtils;
import com.streamscape.lib.file.RecordField;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.sdo.mf.admin.TypeFactory;
import com.streamscape.sef.dispatcher.AbstractOperation;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class StatementSchema
extends Statement {
    public int order;
    public Object[] arguments = ValuePool.emptyObjectArray;
    public boolean isSchemaDefinition;
    Token[] statementTokens;

    StatementSchema() {
        super(64, 2001);
        this.isTransactionStatement = true;
        this.references = new OrderedHashSet();
    }

    StatementSchema(int type, int group) {
        super(type, group);
        this.isTransactionStatement = true;
        this.references = new OrderedHashSet();
    }

    public StatementSchema(String sql, int type) {
        this(sql, type, null, null, null);
    }

    public StatementSchema(String sql, int type, Object[] args) {
        this(sql, type, args, null, null);
    }

    public StatementSchema(String sql, int type, Object[] args, NameManager.ObjectName[] readName, NameManager.ObjectName[] writeName) {
        super(type);
        this.isTransactionStatement = true;
        this.sql = sql;
        this.references = new OrderedHashSet();
        if (args != null) {
            this.arguments = args;
        }
        if (readName != null) {
            this.readTableNames = readName;
        }
        if (writeName != null) {
            this.writeTableNames = writeName;
        }
        switch (type) {
            case 1192: 
            case 3145: {
                this.group = 2002;
                break;
            }
            case 3: 
            case 4: 
            case 17: 
            case 60: 
            case 127: 
            case 134: 
            case 1069: 
            case 1071: 
            case 3222: 
            case 3242: 
            case 3277: 
            case 3291: {
                this.group = 2002;
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 78: 
            case 115: 
            case 116: 
            case 135: 
            case 1077: 
            case 1078: 
            case 1079: 
            case 3005: 
            case 3205: 
            case 3259: {
                this.group = 2002;
                break;
            }
            case 48: 
            case 3043: {
                this.group = 2002;
                this.order = 10;
                break;
            }
            case 49: {
                this.group = 2002;
                this.order = 10;
                break;
            }
            case 59: 
            case 129: 
            case 3044: {
                this.group = 2002;
                break;
            }
            case 64: {
                this.group = 2001;
                break;
            }
            case 3209: {
                this.isLogged = false;
                this.group = 2001;
                this.references.add(((DataspaceSchema)this.arguments[0]).getObjectName());
                break;
            }
            case 3210: {
                this.isLogged = false;
                this.group = 2001;
                this.references.add(((SchemaObject)this.arguments[0]).getObjectName());
                break;
            }
            case 14: {
                this.group = 2001;
                this.order = 7;
                break;
            }
            case 133: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 77: {
                this.group = 2001;
                this.order = 2;
                break;
            }
            case 3285: {
                this.group = 2001;
                this.order = 2;
                break;
            }
            case 3082: {
                this.group = 2001;
                this.order = 2;
                break;
            }
            case 3014: 
            case 3019: {
                this.group = 2010;
                this.isLogged = false;
                this.isTransactionStatement = true;
                this.order = 2;
                break;
            }
            case 3162: 
            case 3163: 
            case 3169: {
                this.group = 2010;
                this.isLogged = true;
                this.order = 2;
                break;
            }
            case 3004: 
            case 3006: 
            case 3021: 
            case 3024: 
            case 3037: {
                this.group = 2001;
                this.order = 2;
                break;
            }
            case 117: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 79: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 52: {
                this.group = 2001;
                this.order = 2;
                break;
            }
            case 83: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 114: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 84: {
                this.group = 2001;
                this.order = 5;
                break;
            }
            case 6: {
                this.group = 2001;
                this.order = 9;
                break;
            }
            case 8: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 3295: 
            case 3300: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 3319: 
            case 3324: 
            case 3329: 
            case 3331: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 3334: {
                this.group = 2001;
                this.isTransactionStatement = true;
                this.isLogged = true;
                this.order = 1;
                break;
            }
            case 3338: 
            case 3342: {
                this.group = 2001;
                this.isTransactionStatement = true;
                this.isLogged = false;
                this.order = 1;
                break;
            }
            case 10: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 23: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 1073: {
                this.group = 2001;
                this.order = 8;
                break;
            }
            case 1074: {
                this.group = 2002;
                this.order = 4;
                break;
            }
            case 3204: {
                this.group = 2002;
                this.order = 4;
                break;
            }
            case 1075: {
                this.group = 2002;
                this.order = 4;
                break;
            }
            case 1072: {
                this.group = 2002;
                this.order = 11;
                break;
            }
            case 1204: {
                this.group = 2002;
                this.statementTokens = (Token[])args[0];
                break;
            }
            case 1199: {
                this.group = 2002;
                break;
            }
            case 3020: 
            case 3022: 
            case 3026: 
            case 3054: 
            case 3059: 
            case 3060: 
            case 3063: 
            case 3064: 
            case 3071: 
            case 3072: 
            case 3085: 
            case 3103: 
            case 3104: 
            case 3105: 
            case 3106: 
            case 3107: 
            case 3108: 
            case 3112: 
            case 3113: 
            case 3114: 
            case 3115: 
            case 3116: 
            case 3117: 
            case 3118: 
            case 3141: 
            case 3142: 
            case 3154: 
            case 3155: 
            case 3156: 
            case 3164: 
            case 3167: 
            case 3178: 
            case 3179: 
            case 3213: 
            case 3214: 
            case 3216: 
            case 3241: 
            case 3245: 
            case 3246: 
            case 3250: 
            case 3251: 
            case 3270: 
            case 3287: 
            case 3298: 
            case 3299: 
            case 3303: 
            case 3321: 
            case 3326: 
            case 3330: {
                this.group = 2017;
                this.references = new OrderedHashSet();
                break;
            }
            case 3335: {
                this.group = 2017;
                this.references = new OrderedHashSet();
                this.isTransactionStatement = true;
                break;
            }
            case 3238: {
                this.references = new OrderedHashSet();
                this.isLogged = ((ReplicationEntityName)args[0]).isLocalNode();
                this.group = 2017;
                break;
            }
            case 3203: {
                this.references = new OrderedHashSet();
                this.isLogged = ((ReplicationEntityName)args[0]).isLocalNode();
                this.group = 2017;
                break;
            }
            case 3067: 
            case 3258: {
                this.group = 2017;
                this.isLogged = false;
                break;
            }
            case 3194: 
            case 3195: 
            case 3198: 
            case 3266: {
                this.group = 2017;
                this.isTransactionStatement = true;
                this.isLogged = true;
                break;
            }
            case 3267: 
            case 3279: {
                this.group = 2017;
                this.isTransactionStatement = false;
                this.isLogged = false;
                break;
            }
            case 3306: 
            case 3307: {
                this.group = 2017;
                this.isTransactionStatement = false;
                this.isLogged = true;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementSchema");
            }
        }
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
        }
        catch (Throwable t) {
            Trace.logException(this, t, Trace.isDebugEnabled(this.getClass()));
            result = Result.newErrorResult(t, null);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
            return result;
        }
        session.dataspaceStore.schemaManager.setSchemaChangeTimestamp();
        try {
            if (this.isLogged) {
                NameManager.ObjectName objectName = null;
                for (int i = 0; i < this.arguments.length; ++i) {
                    if (this.arguments[i] instanceof NameManager.ObjectName) {
                        objectName = (NameManager.ObjectName)this.arguments[i];
                        break;
                    }
                    if (!(this.arguments[i] instanceof SchemaObject)) continue;
                    objectName = ((SchemaObject)this.arguments[i]).getObjectName();
                    break;
                }
                LogRecordType logRecordType = LogRecordType.OTHER;
                switch (this.type) {
                    case 64: {
                        logRecordType = LogRecordType.CREATE;
                        break;
                    }
                    case 31: {
                        logRecordType = LogRecordType.DROP_DATASPACE;
                        break;
                    }
                    case 10: 
                    case 14: 
                    case 23: 
                    case 51: 
                    case 77: 
                    case 83: 
                    case 84: 
                    case 133: 
                    case 1074: 
                    case 1075: 
                    case 3004: 
                    case 3006: 
                    case 3020: 
                    case 3021: 
                    case 3022: 
                    case 3024: 
                    case 3037: 
                    case 3054: 
                    case 3063: 
                    case 3071: 
                    case 3082: 
                    case 3106: 
                    case 3114: 
                    case 3141: 
                    case 3154: 
                    case 3164: 
                    case 3204: 
                    case 3213: 
                    case 3216: 
                    case 3241: 
                    case 3245: 
                    case 3250: 
                    case 3270: 
                    case 3285: 
                    case 3319: 
                    case 3324: 
                    case 3329: 
                    case 3334: {
                        logRecordType = LogRecordType.CREATE;
                        break;
                    }
                    case 3194: {
                        logRecordType = LogRecordType.OTHER;
                        objectName = (NameManager.ObjectName)this.arguments[3];
                        if (objectName != null) break;
                        objectName = session.currentDataspace;
                        break;
                    }
                    case 3059: {
                        logRecordType = LogRecordType.CREATE;
                        objectName = ((ReplicationSource)this.arguments[0]).getObjectName();
                        break;
                    }
                    case 3238: {
                        logRecordType = LogRecordType.CREATE;
                        objectName = ((ReplicationSource)this.arguments[1]).getObjectName();
                        break;
                    }
                    case 3203: {
                        logRecordType = LogRecordType.CREATE;
                        objectName = ((ReplicationTarget)this.arguments[1]).getObjectName();
                        break;
                    }
                    case 26: 
                    case 27: 
                    case 28: 
                    case 30: 
                    case 34: 
                    case 35: 
                    case 135: 
                    case 1078: 
                    case 3005: 
                    case 3064: 
                    case 3072: 
                    case 3142: 
                    case 3156: 
                    case 3205: 
                    case 3259: 
                    case 3321: 
                    case 3326: 
                    case 3330: 
                    case 3335: {
                        logRecordType = LogRecordType.DROP_OBJECT;
                        break;
                    }
                    case 48: 
                    case 59: {
                        if (objectName != null) break;
                        objectName = session.getCurrentDataspaceName();
                    }
                }
                if (this.type == 3216) {
                    session.dataspaceStore.dataspaceLogger.writeOtherStatement(session, logRecordType, ((JournalFileTableCollection)this.arguments[0]).getSQL(), objectName);
                } else if (this.type == 3270) {
                    session.dataspaceStore.dataspaceLogger.writeOtherStatement(session, logRecordType, ((LogFileTableCollection)this.arguments[0]).getSQL(), objectName);
                } else if (this.type == 3287) {
                    NameManager.ObjectName oldName = (NameManager.ObjectName)this.arguments[1];
                    if (oldName != null) {
                        ReferenceLink referenceLink = (ReferenceLink)this.arguments[0];
                        session.dataspaceStore.dataspaceLogger.writeOtherStatement(session, LogRecordType.DROP_OBJECT, "drop reference link " + oldName.getSchemaQualifiedStatementName(), oldName);
                        session.dataspaceStore.dataspaceLogger.writeOtherStatement(session, LogRecordType.CREATE, referenceLink.getSQL(), referenceLink.getObjectName());
                    }
                } else {
                    TableCollection collection;
                    session.dataspaceStore.dataspaceLogger.writeOtherStatement(session, logRecordType, this.sql, objectName);
                    if (this.type == 77 && this.arguments.length > 3 && this.arguments[2] != null && this.arguments[3] != null && this.arguments[3] instanceof FileTableCollection) {
                        collection = (FileTableCollection)this.arguments[3];
                        FileTable table = (FileTable)collection.getBaseTable();
                        session.dataspaceStore.dataspaceLogger.writeOtherStatement(session, LogRecordType.LINK, table.getDataSourceDDL(), objectName);
                    }
                    if (this.type == 3241) {
                        collection = (SnapshotCollection)this.arguments[0];
                        session.dataspaceStore.dataspaceLogger.writeOtherStatement(session, LogRecordType.LINK, ((SnapshotCollection)collection).getDataSourceDDL(), objectName);
                    }
                }
                if (session.sessionContext.postponedStatements != null) {
                    ArrayList<Statement> stats = session.sessionContext.postponedStatements;
                    session.sessionContext.postponedStatements = null;
                    for (Statement stat : stats) {
                        Result tempResult = stat.execute(session);
                        if (!tempResult.isError()) continue;
                        String error = "";
                        if (tempResult.getException() != null) {
                            error = tempResult.getException().getMessage();
                        }
                        Trace.logError(SqlUtils.class, "Unable to execute statement. " + error);
                    }
                }
            }
        }
        catch (Throwable e) {
            return Result.newErrorResult(e, this.sql);
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    Result getResult(Session session) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [46[TRYBLOCK]], but top level block is 536[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkFileTableBasedOnFileDescriptorCannotBeAltered(Table table) {
        if (table instanceof FileTable && ((FileTable)table).getFileDescriptorName() != null) {
            throw new DataspaceException("File tables based on file descriptor cannot be altered.");
        }
    }

    private void dropType(Session session, NameManager.ObjectName name, boolean cascade) {
        Type distinct = (Type)session.dataspaceStore.schemaManager.getSchemaObject(name);
        if (distinct.isDistinctType()) {
            if (TypeFactory.existsSemanticType(distinct.getObjectName().name)) {
                throw new DataspaceException("Type cannot be removed while its semantic type exists in Runtime.");
            }
        } else {
            throw new DataspaceException("Only distinct types can be dropped.");
        }
        session.dataspaceStore.schemaManager.removeSchemaObject(name, cascade ? SchemaManager.DropScope.CASCADE : SchemaManager.DropScope.NONE);
        distinct.userTypeModifier = null;
    }

    private static void dropDomain(Session session, NameManager.ObjectName name, boolean cascade) {
        Type domain = (Type)session.dataspaceStore.schemaManager.getSchemaObject(name);
        OrderedHashSet set = session.dataspaceStore.schemaManager.getReferencesTo(domain.getObjectName());
        if (!cascade && set.size() > 0) {
            NameManager.ObjectName objectName = (NameManager.ObjectName)set.get(0);
            throw Error.error(5502, objectName.getSchemaQualifiedStatementName());
        }
        Constraint[] constraints = domain.userTypeModifier.getConstraints();
        set = new OrderedHashSet();
        for (int i = 0; i < constraints.length; ++i) {
            set.add(constraints[i].getObjectName());
        }
        session.dataspaceStore.schemaManager.removeSchemaObjects(set);
        session.dataspaceStore.schemaManager.removeSchemaObject(domain.getObjectName(), cascade ? SchemaManager.DropScope.CASCADE : SchemaManager.DropScope.NONE);
        domain.userTypeModifier = null;
    }

    private void dropSchema(Session session, NameManager.ObjectName name, boolean cascade, boolean force) {
        NameManager.ObjectName schema = session.dataspaceStore.schemaManager.getUserSchemaHsqlName(name.name);
        StatementSchema.checkSchemaUpdateAuthorisation(session, schema);
        AbstractDataspace dataspace = (AbstractDataspace)session.dataspaceStore.schemaManager.findSchema(schema.name);
        dataspace.close(session);
        session.dataspaceStore.schemaManager.dropSchema(session, name.name, cascade, force);
        dataspace.destroy(session);
        this.sql = "DROP DATASPACE " + StringUtils.escapeDsObjectName(name.name);
    }

    private void dropRoutine(Session session, NameManager.ObjectName name, SchemaManager.DropScope dropScope) {
        StatementSchema.checkSchemaUpdateAuthorisation(session, name.schema);
        session.dataspaceStore.schemaManager.removeSchemaObject(name, dropScope);
    }

    private void dropObject(Session session, NameManager.ObjectName name, boolean cascade) {
        name = session.dataspaceStore.schemaManager.getSchemaObjectName(name.schema, name.name, name.type, true);
        session.dataspaceStore.schemaManager.removeSchemaObject(name, cascade ? SchemaManager.DropScope.CASCADE : SchemaManager.DropScope.NONE);
    }

    private void dropCollection(Session session, NameManager.ObjectName name, boolean cascade, boolean force) {
        ArrayList<EventTriggerDefSQL> triggers = new ArrayList<EventTriggerDefSQL>();
        Collection collection = (Collection)session.dataspaceStore.schemaManager.getSchemaObject(name);
        if (collection.getReplicationSource() != null && !cascade) {
            throw Error.error(5502, collection.getReplicationSource().getReplicationEntityName().toString());
        }
        if (collection.getBaseTable().triggerList != null) {
            for (TriggerDef def : collection.getBaseTable().triggerList) {
                if (!(def instanceof EventTriggerDefSQL)) continue;
                triggers.add((EventTriggerDefSQL)def);
            }
        }
        session.dataspaceStore.schemaManager.dropCollection(session, collection, cascade, force);
        if (collection.getBaseTable() != null) {
            collection.getBaseTable().setDropped(true);
        }
        for (EventTriggerDefSQL trigger : triggers) {
            trigger.destroy();
            this.writeLogForTriggerDrop(session, trigger.getObjectName());
        }
        triggers.clear();
        triggers = null;
    }

    static void checkSchemaUpdateAuthorisation(Session session, NameManager.ObjectName schema) {
        if (session.isProcessingRecoveryLog) {
            return;
        }
        if (SqlInvariants.isSystemSchemaName(schema.name)) {
            throw Error.error(5503);
        }
        if (session.parser.isSchemaDefinition) {
            if (schema == session.getCurrentDataspaceName()) {
                return;
            }
            Error.error(5505, schema.name);
        }
        session.getGrantee().checkSchemaUpdateOrGrantRights(schema.name);
        session.checkDDLWrite();
    }

    void setOrCheckObjectName(Session session, NameManager.ObjectName parent, NameManager.ObjectName name, boolean check) {
        if (name.schema == null) {
            name.schema = this.schemaName == null ? session.getCurrentDataspaceName() : this.schemaName;
        } else {
            name.schema = session.getSchemaHsqlName(name.schema.name);
            if (name.schema == null) {
                throw Error.error(5505);
            }
            if (this.isSchemaDefinition && this.schemaName != name.schema) {
                throw Error.error(5505);
            }
        }
        name.parent = parent;
        if (!this.isSchemaDefinition && (parent != null || name.type != 14 && name.type != 41 && name.type != 42) && (parent == null || parent.type != 14 && name.type != 41 && name.type != 42)) {
            StatementSchema.checkSchemaUpdateAuthorisation(session, name.schema);
        }
        if (check) {
            session.dataspaceStore.schemaManager.checkSchemaObjectNotExists(name);
        }
    }

    void setSchemaName(Session session, NameManager.ObjectName parent, NameManager.ObjectName name) {
        if (name.schema == null) {
            name.schema = this.schemaName == null ? session.getCurrentDataspaceName() : this.schemaName;
        } else {
            name.schema = session.getSchemaHsqlName(name.schema.name);
            if (name.schema == null) {
                throw Error.error(5505);
            }
            if (this.isSchemaDefinition && this.schemaName != name.schema) {
                throw Error.error(5505);
            }
        }
    }

    @Override
    public boolean isAutoCommitStatement() {
        return true;
    }

    @Override
    public String describe(Session session) {
        return this.sql;
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("sql", this.sql);
        return result;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    private Pair<String, String> splitFunctionDefinition(String fullSQL) {
        int index = -1;
        index = fullSQL.toUpperCase().indexOf(" AS ");
        if (index != -1) {
            return new Pair<String, String>(fullSQL.substring(0, index + 5), fullSQL.substring(index + 5));
        }
        index = fullSQL.toUpperCase().indexOf(" AS\n");
        if (index != -1) {
            return new Pair<String, String>(fullSQL.substring(0, index + 5), fullSQL.substring(index + 5));
        }
        index = fullSQL.toUpperCase().indexOf("\nAS ");
        if (index != -1) {
            return new Pair<String, String>(fullSQL.substring(0, index + 5), fullSQL.substring(index + 5));
        }
        index = fullSQL.toUpperCase().indexOf("\nAS\n");
        if (index != -1) {
            return new Pair<String, String>(fullSQL.substring(0, index + 5), fullSQL.substring(index + 5));
        }
        return null;
    }

    private void writeLogForTriggerDrop(Session session, NameManager.ObjectName triggerName) {
        if (this.isLogged) {
            session.dataspaceStore.dataspaceLogger.writeOtherStatement(session, LogRecordType.DROP_OBJECT, "DROP TRIGGER [" + triggerName.name + "]", triggerName);
        }
    }

    private void checkAndSetSyntaxPart(StringBuilder buffer, String oldSyntaxPart, String newSyntaxPart) {
        String result = "";
        if (newSyntaxPart != null && newSyntaxPart.length() > 0) {
            result = newSyntaxPart;
        } else if (oldSyntaxPart != null) {
            result = oldSyntaxPart;
        }
        buffer.append(result);
    }

    private void checkDDLIsAllowed(Session session, NameManager.ObjectName name) {
        if (name == null || name.schema == null || !AbstractOperation.isSystemDataspace(name.schema.getNameString())) {
            this.checkDDLIsAllowed(session);
        }
    }

    private void checkDDLIsAllowed(Session session) {
        if (session.dataspaceStore.isRecoveryFailed() && this.isLogged() && session.dataspaceStore.dataspaceLogger.isLoggingEnabled() && !session.isProcessingRecoveryLog() && !session.isProcessingLog()) {
            throw new DataspaceException("DDL operations are not allowed when dataspace in RECOVERY_FAILED state.");
        }
    }

    private void updateTriggerObjectDefinition(Session session, SchemaManager schemaManager, SchemaObject newTrigger) {
        String currentDefinition = schemaManager.loadObjectDefinition(session, newTrigger);
        String newSql = this.replaceAlterWithCreate(session, this.sql);
        if (currentDefinition != null) {
            schemaManager.updateObjectDefinition(session, newTrigger, newSql);
        } else {
            schemaManager.saveObjectDefinition(session, newTrigger, newSql);
        }
    }

    private String replaceAlterWithCreate(Session session, String sql) {
        ParserCommand parser = new ParserCommand(session, new Scanner((String)sql));
        if (parser.token.tokenType == 849) {
            parser.read();
        }
        int start = parser.getPosition();
        if (parser.readIfThis(4)) {
            sql = (start > 0 ? ((String)sql).substring(0, start) : "") + "create" + ((String)sql).substring(start + "alter".length());
        }
        return sql;
    }

    private static /* synthetic */ boolean lambda$getResult$11(KNode knode, KNodeTypeSchemaObject n) {
        return n.getObjectName().name.equals(knode.getTypeName());
    }

    private static /* synthetic */ boolean lambda$getResult$10(KNodeTypeSchemaObject finalSubjectKNodeType, KNodeTypeSchemaObject finalObjectKNodeType, KLinkTypeSchemaObject klinkType, KAssertionTypeSchemaObject a) {
        return a.getSubjectType() == finalSubjectKNodeType && a.getObjectType() == finalObjectKNodeType && a.getLinkType() == klinkType;
    }

    private static /* synthetic */ boolean lambda$getResult$9(List removeAssertions, KAssertionTypeSchemaObject a) {
        return removeAssertions.stream().anyMatch(a1 -> a1.getSubjectType() == a.getSubjectType() && a1.getObjectType() == a.getObjectType() && a1.getLinkType() == a.getLinkType());
    }

    private static /* synthetic */ void lambda$getResult$7(KGraphTypeSchemaObject kgraphType, String l) {
        kgraphType.getKlinksFacets().remove(l);
    }

    private static /* synthetic */ boolean lambda$getResult$6(List removeKlinks, KLinkTypeSchemaObject c) {
        return removeKlinks.contains(c.getObjectName().name);
    }

    private static /* synthetic */ boolean lambda$getResult$5(List removeKnodes, KNodeTypeSchemaObject c) {
        return removeKnodes.contains(c.getObjectName().name);
    }

    private static /* synthetic */ boolean lambda$getResult$4(List removeColumns, ColumnSchema c) {
        return removeColumns.contains(c.getNameString());
    }

    private static /* synthetic */ String lambda$getResult$3(Pair pair) {
        return ((RecordField)pair.first).getFieldName();
    }

    private static /* synthetic */ void lambda$getResult$2(List newFields, RecordField field, Type type) {
        newFields.add(new Pair<RecordField, Type>(field, type));
    }

    private static /* synthetic */ void lambda$getResult$1(TableWorks tableWorks, int[] columnIndex, HsqlArrayList columnConstraints, RecordField field, Type type) {
        ColumnSchema c = new ColumnSchema(NameManager.newInfoSchemaColumnName(field.getFieldName(), tableWorks.getTable().getObjectName()), type, field.isNullable(), false, null);
        tableWorks.addColumn(c, columnIndex[0], columnConstraints);
        columnIndex[0] = columnIndex[0] + 1;
    }

    private static /* synthetic */ void lambda$getResult$0(Session session, AbstractCollection foundCollection, String operationName, List allowedTypes) {
        if (!session.isProcessingLog() && !session.isProcessingRecoveryLog()) {
            AbstractCollection.checkAlterAllowed(foundCollection, operationName, allowedTypes);
        }
    }
}

