/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.statement;

import com.streamscape.Trace;
import com.streamscape.ds.lib.ArraySort;
import com.streamscape.ds.lib.HashSet;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.store.BaseHashMap;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.parser.ParserDQL;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.SubQuery;
import com.streamscape.ds.parser.statement.StatementDMQL;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultMetaData;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.session.Session;
import com.streamscape.sef.utils.Utils;
import java.util.Comparator;

public class StatementRplExec
extends StatementDMQL {
    Expression[] arguments = Expression.emptyArray;
    public RplScript procedure = null;

    public StatementRplExec(Session session, RplScript procedure, Expression[] arguments, ParserDQL.CompileContext compileContext) {
        super(7, 2003, session.getCurrentDataspaceName());
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
        this.procedure = procedure;
        this.arguments = arguments;
    }

    @Override
    Result getResult(Session session) {
        Object[] data = ValuePool.emptyObjectArray;
        int argLength = this.arguments.length;
        if (argLength > 0) {
            data = new Object[argLength];
        }
        for (int i = 0; i < this.arguments.length; ++i) {
            Expression e = this.arguments[i];
            Object value = e.getValue(session);
            if (e == null) continue;
            data[i] = value;
        }
        session.sessionContext.rplArguments = data;
        int variableCount = this.procedure.getVariableCount();
        session.sessionContext.routineVariables = new Object[variableCount];
        Result result = this.procedure.statement.execute(session);
        session.sessionContext.closeRoutineVariables();
        if (result.isError() && result.getException() != null) {
            Trace.logError(this, "Exec {}: {}", this.procedure.getObjectName().getSchemaQualifiedStatementName(), Utils.formatExceptionWithUnrepeatedCauses(result.getException()));
        }
        return result;
    }

    @Override
    SubQuery[] getSubqueries(Session session) {
        BaseHashMap subQueries = null;
        for (int i = 0; i < this.arguments.length; ++i) {
            subQueries = this.arguments[i].collectAllSubqueries((OrderedHashSet)subQueries);
        }
        if (subQueries == null || subQueries.size() == 0) {
            return SubQuery.emptySubqueryArray;
        }
        Object[] subQueryArray = new SubQuery[subQueries.size()];
        ((HashSet)subQueries).toArray(subQueryArray);
        ArraySort.sort(subQueryArray, 0, subQueryArray.length, (Comparator)subQueryArray[0]);
        for (int i = 0; i < this.subqueries.length; ++i) {
            ((SubQuery)subQueryArray[i]).prepareTable(session);
        }
        return subQueryArray;
    }

    @Override
    public ResultMetaData getResultMetaData() {
        return ResultMetaData.emptyResultMetaData;
    }

    @Override
    public ResultMetaData getParametersMetaData() {
        return super.getParametersMetaData();
    }

    public Expression[] getArguments() {
        return this.arguments;
    }

    @Override
    void collectTableNamesForRead(OrderedHashSet set) {
        int i;
        for (i = 0; i < this.subqueries.length; ++i) {
            if (this.subqueries[i].queryExpression == null) continue;
            this.subqueries[i].queryExpression.getBaseTableNames(set);
        }
        for (i = 0; i < this.routines.length; ++i) {
            set.addAll(this.routines[i].getTableNamesForRead());
        }
    }

    @Override
    void collectTableNamesForWrite(OrderedHashSet set) {
    }
}

