/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.statement;

import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.navigator.RowSetNavigatorData;
import com.streamscape.ds.navigator.RowSetNavigatorDataChange;
import com.streamscape.ds.parser.statement.StatementDML;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.Type;
import java.util.LinkedHashMap;
import java.util.Map;

public class StatementResultUpdate
extends StatementDML {
    int actionType;
    Type[] types;
    Result result;

    public StatementResultUpdate() {
        this.writeTableNames = new NameManager.ObjectName[1];
        this.setCompileTimestamp(Long.MAX_VALUE);
    }

    @Override
    public String describe(Session session) {
        return "";
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        return result;
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
            this.clearStructures(session);
        }
        catch (Throwable t) {
            this.clearStructures(session);
            result = Result.newErrorResult(t, null);
        }
        return result;
    }

    @Override
    Result getResult(Session session) {
        this.checkAccessRights(session);
        Object[] args = session.sessionContext.dynamicArguments;
        PersistentStore store = this.baseTable.getRowStore(session);
        switch (this.actionType) {
            case 81: {
                Row row = this.getRow(session, args);
                if (row == null || row.isDeleted(session, store)) {
                    throw Error.error(3621);
                }
                RowSetNavigatorDataChange list = session.sessionContext.getRowSetDataChange();
                Object[] data = (Object[])ArrayUtil.duplicateArray(row.getData());
                boolean[] columnCheck = this.baseTable.getNewColumnCheckList();
                for (int i = 0; i < this.baseColumnMap.length; ++i) {
                    if (this.types[i] == Type.SQL_ALL_TYPES) continue;
                    data[this.baseColumnMap[i]] = args[i];
                    columnCheck[this.baseColumnMap[i]] = true;
                }
                int[] colMap = ArrayUtil.booleanArrayToIntIndexes(columnCheck);
                list.addRow(session, row, data, this.baseTable.getColumnTypes(), colMap);
                list.endMainDataSet();
                this.update(session, this.baseTable, list, null);
                break;
            }
            case 18: {
                Row row = this.getRow(session, args);
                if (row == null || row.isDeleted(session, store)) {
                    throw Error.error(3621);
                }
                RowSetNavigatorDataChange list = session.sessionContext.getRowSetDataChange();
                list.addRow(row);
                list.endMainDataSet();
                this.delete(session, this.baseTable, list);
                break;
            }
            case 50: {
                Object[] data = this.baseTable.getNewRowData(session);
                for (int i = 0; i < data.length; ++i) {
                    data[this.baseColumnMap[i]] = args[i];
                }
                return this.insertSingleRow(session, store, data);
            }
        }
        return Result.updateOneResult;
    }

    Row getRow(Session session, Object[] args) {
        int rowIdIndex = this.result.metaData.getColumnCount();
        Long rowId = (Long)args[rowIdIndex];
        PersistentStore store = this.baseTable.getRowStore(session);
        Row row = null;
        if (rowIdIndex + 2 == this.result.metaData.getExtendedColumnCount()) {
            Object[] data = ((RowSetNavigatorData)this.result.getNavigator()).getData(rowId);
            if (data != null) {
                row = (Row)data[rowIdIndex + 1];
            }
        } else {
            int id = (int)rowId.longValue();
            row = (Row)store.get(id, false);
        }
        this.result = null;
        return row;
    }

    public void setRowActionProperties(Result result, int action, Table table, Type[] types, int[] columnMap) {
        this.result = result;
        this.actionType = action;
        this.baseTable = table;
        this.types = types;
        this.baseColumnMap = columnMap;
        this.writeTableNames[0] = table.getObjectName();
    }

    @Override
    void checkAccessRights(Session session) {
        switch (this.type) {
            case 7: {
                break;
            }
            case 50: {
                session.getGrantee().checkInsert(this.targetTable, this.insertCheckColumns);
                break;
            }
            case 85: {
                break;
            }
            case 19: 
            case 100: {
                session.getGrantee().checkDelete(this.targetTable);
                break;
            }
            case 82: 
            case 101: {
                session.getGrantee().checkUpdate(this.targetTable, this.updateCheckColumns);
                break;
            }
            case 128: {
                session.getGrantee().checkInsert(this.targetTable, this.insertCheckColumns);
                session.getGrantee().checkUpdate(this.targetTable, this.updateCheckColumns);
            }
        }
    }
}

