/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.statement;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.parser.ParserDQL;
import com.streamscape.ds.parser.expression.ExplainComplexity;
import com.streamscape.ds.parser.expression.QueryExpression;
import com.streamscape.ds.parser.expression.QuerySpecification;
import com.streamscape.ds.parser.statement.StatementDMQL;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultMetaData;
import com.streamscape.ds.session.Session;

public class StatementQuery
extends StatementDMQL {
    public StatementQuery(Session session, QueryExpression queryExpression, ParserDQL.CompileContext compileContext) {
        super(85, 2003, session.getCurrentDataspaceName());
        this.queryExpression = queryExpression;
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
    }

    @Override
    Result getResult(Session session) {
        this.execDataspaceGovernor(session);
        Result result = this.queryExpression.getResult(session, session.getMaxRows());
        result.setStatement(this);
        return result;
    }

    private void execDataspaceGovernor(Session session) {
        boolean toThrowError = false;
        try {
            if (session.isInteractive() && session.dataspaceStore.getProperties().getBooleanProperty("dtspace.governor") && session.getRequestTimeout() > 0L && this.queryExpression instanceof QuerySpecification) {
                ExplainComplexity explainComplexity = new ExplainComplexity(((QuerySpecification)this.queryExpression).rangeVariables, session.dataspaceStore);
                explainComplexity.init();
                if (explainComplexity.getEstimatedDurationMs() >= session.getRequestTimeout()) {
                    toThrowError = true;
                    throw new DataspaceException("This query estimated execution time is " + explainComplexity.getEstimatedDurationString() + ", which is more that current session timeout " + Math.round(session.getRequestTimeout() / 1000L) + " seconds.\n\nComplexity: " + explainComplexity.getComplexity() + "\nIterations Count: " + (long)explainComplexity.getIterationsCount() + "\nUnit Size: " + explainComplexity.getUnitSize() + "\nUnit Est Time: " + explainComplexity.getUnitEstTimeMs() + " ms\n\nExecute EXPLAIN PLAN for more details.");
                }
            }
        }
        catch (Exception exception) {
            if (toThrowError) {
                throw exception;
            }
            Trace.logError(this, "Failed to estimate query: " + String.valueOf(this.queryExpression));
            Trace.logException(this, exception, true);
        }
    }

    @Override
    public ResultMetaData getResultMetaData() {
        switch (this.type) {
            case 85: 
            case 100: 
            case 101: {
                return this.queryExpression.getMetaData();
            }
            case 65: {
                return this.queryExpression.getMetaData();
            }
        }
        throw Error.runtimeError(201, "StatementQuery.getResultMetaData()");
    }

    @Override
    void collectTableNamesForRead(OrderedHashSet set) {
        int i;
        this.queryExpression.getBaseTableNames(set);
        for (i = 0; i < this.subqueries.length; ++i) {
            if (this.subqueries[i].queryExpression == null) continue;
            this.subqueries[i].queryExpression.getBaseTableNames(set);
        }
        for (i = 0; i < this.routines.length; ++i) {
            set.addAll(this.routines[i].getTableNamesForRead());
        }
    }

    @Override
    void collectTableNamesForWrite(OrderedHashSet set) {
        if (this.queryExpression.isUpdatable) {
            this.queryExpression.getBaseTableNames(set);
        }
    }

    @Override
    public int getResultProperties() {
        return 0;
    }
}

