/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.statement;

import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.navigator.RowSetNavigatorClient;
import com.streamscape.ds.parser.ParserDQL;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.QueryExpression;
import com.streamscape.ds.parser.statement.StatementDML;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.collection.tspace.map.MapCollection;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.Type;

public class StatementPut
extends StatementDML {
    int overrideUserValue = -1;
    Collection collection = null;

    public StatementPut(Session session, Collection collection, Table targetTable, int[] columnMap, Expression insertExpression, boolean[] checkColumns, ParserDQL.CompileContext compileContext) {
        super(3001, 2017, session.getCurrentDataspaceName());
        this.collection = collection;
        this.targetTable = targetTable;
        this.baseTable = targetTable.isTriggerInsertable() ? targetTable : targetTable.getBaseTable();
        this.insertColumnMap = columnMap;
        this.insertCheckColumns = checkColumns;
        this.insertExpression = insertExpression;
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
        this.setupChecks();
        this.isSimpleInsert = insertExpression != null && insertExpression.nodes.length == 1 && this.updatableTableCheck == null;
    }

    StatementPut(Session session, Table targetTable, int[] columnMap, boolean[] checkColumns, QueryExpression queryExpression, ParserDQL.CompileContext compileContext, int override) {
        super(50, 2017, session.getCurrentDataspaceName());
        this.targetTable = targetTable;
        this.baseTable = targetTable.isTriggerInsertable() ? targetTable : targetTable.getBaseTable();
        this.insertColumnMap = columnMap;
        this.insertCheckColumns = checkColumns;
        this.queryExpression = queryExpression;
        this.overrideUserValue = override;
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
        this.setupChecks();
    }

    @Override
    Result getResult(Session session) {
        Result resultOut = null;
        RowSetNavigator generatedNavigator = null;
        PersistentStore store = this.baseTable.getRowStore(session);
        if (this.generatedIndexes != null) {
            resultOut = Result.newUpdateCountResult(this.generatedResultMetaData, 0);
            generatedNavigator = resultOut.getChainedResult().getNavigator();
        }
        if (this.isSimpleInsert) {
            Type[] colTypes = this.baseTable.getColumnTypes();
            Object[] data = this.getInsertData(session, colTypes, this.insertExpression.nodes[0].nodes);
            return ((MapCollection)this.collection).put(session, store, data);
        }
        return null;
    }

    RowSetNavigator getInsertSelectNavigator(Session session) {
        Type[] colTypes = this.baseTable.getColumnTypes();
        int[] columnMap = this.insertColumnMap;
        Result result = this.queryExpression.getResult(session, 0);
        RowSetNavigator nav = result.initialiseNavigator();
        Type[] sourceTypes = result.metaData.columnTypes;
        RowSetNavigatorClient newData = new RowSetNavigatorClient(2);
        while (nav.hasNext()) {
            Object[] data = this.baseTable.getNewRowData(session);
            Object[] sourceData = nav.getNext();
            for (int i = 0; i < columnMap.length; ++i) {
                int j = columnMap[i];
                if (j == this.overrideUserValue) continue;
                Type sourceType = sourceTypes[i];
                data[j] = colTypes[j].convertToType(session, sourceData[i], sourceType);
            }
            newData.add(data);
        }
        return newData;
    }

    RowSetNavigator getInsertValuesNavigator(Session session) {
        Type[] colTypes = this.baseTable.getColumnTypes();
        Expression[] list = this.insertExpression.nodes;
        RowSetNavigatorClient newData = new RowSetNavigatorClient(list.length);
        for (int j = 0; j < list.length; ++j) {
            Expression[] rowArgs = list[j].nodes;
            Object[] data = this.getInsertData(session, colTypes, rowArgs);
            newData.add(data);
        }
        return newData;
    }

    public boolean isBaseTableInMemory() {
        return this.baseTable.isMemory();
    }
}

