/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.statement;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArraySort;
import com.streamscape.ds.lib.HashMappedList;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.navigator.RowSetNavigatorData;
import com.streamscape.ds.parser.ParserDQL;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.SubQuery;
import com.streamscape.ds.parser.statement.StatementDMQL;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultMetaData;
import com.streamscape.ds.schema.RplSchemaObject;
import com.streamscape.ds.schema.column.ColumnBase;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.procedure.FunctionSQL;
import com.streamscape.ds.schema.procedure.FunctionSQLInvoked;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.Type;
import java.util.Comparator;

public class StatementProcedure
extends StatementDMQL {
    Expression expression;
    public RplScript procedure;
    Expression[] arguments = Expression.emptyArray;
    ResultMetaData resultMetaData;

    public StatementProcedure(Session session, Expression expression, ParserDQL.CompileContext compileContext) {
        super(7, 2003, session.getCurrentDataspaceName());
        if (expression.opType == 27) {
            FunctionSQLInvoked f = (FunctionSQLInvoked)expression;
            if (f.routine.returnsCollection) {
                this.procedure = f.routine;
                this.arguments = f.nodes;
            } else {
                this.expression = expression;
            }
        } else {
            this.expression = expression;
        }
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
        if (this.procedure != null) {
            session.getGrantee().checkAccess(this.procedure);
        }
    }

    public StatementProcedure(Session session, RplScript procedure, Expression[] arguments, ParserDQL.CompileContext compileContext) {
        super(7, 2003, session.getCurrentDataspaceName());
        if (procedure.maxDynamicResults > 0) {
            this.statementReturnType = 0;
        }
        this.procedure = procedure;
        this.arguments = arguments;
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
        session.getGrantee().checkAccess(procedure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Result getResult(Session session) {
        session.sessionContext.pushRoutineCollections(new HashMappedList());
        try {
            Result result = this.expression == null ? this.getProcedureResult(session) : this.getExpressionResult(session);
            result.setStatementType(this.statementReturnType);
            Result result2 = result;
            return result2;
        }
        finally {
            session.sessionContext.popRoutineCollections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Result getProcedureResult(Session session) {
        Object[] data = ValuePool.emptyObjectArray;
        int argLength = this.arguments.length;
        if (this.procedure.getMaxDynamicResults() > 0) {
            ++argLength;
        }
        if (argLength > 0) {
            data = new Object[argLength];
        }
        for (int i = 0; i < this.arguments.length; ++i) {
            Expression e = this.arguments[i];
            Object value = e.getValue(session);
            if (e == null) continue;
            Type targetType = this.procedure.getParameter(i).getDataType();
            data[i] = targetType.convertToType(session, value, e.getDataType());
        }
        session.sessionContext.push();
        Result result = Result.updateZeroResult;
        Object[] callArguments = null;
        try {
            session.sessionContext.rplArguments = data;
            session.sessionContext.routineVariables = ValuePool.emptyObjectArray;
            result = this.executePSMProcedure(session);
            callArguments = session.sessionContext.rplArguments;
        }
        finally {
            session.sessionContext.pop();
        }
        if (result.isError()) {
            return result;
        }
        for (int i = 0; i < this.procedure.getParameterCount(); ++i) {
            ColumnSchema param = this.procedure.getParameter(i);
            byte mode = param.getParameterMode();
            if (mode == 1) continue;
            if (this.arguments[i].isDynamicParam()) {
                int paramIndex = this.arguments[i].parameterIndex;
                session.sessionContext.dynamicArguments[paramIndex] = callArguments[i];
                continue;
            }
            int varIndex = this.arguments[i].getColumnIndex();
            session.sessionContext.routineVariables[varIndex] = callArguments[i];
        }
        Result r = result;
        result = Result.newCallResponse(this.getParametersMetaData().getParameterTypes(), this.id, session.sessionContext.dynamicArguments);
        if (this.procedure.returnsCollection()) {
            result.addChainedResult(r);
        } else if (callArguments.length > this.arguments.length) {
            r = (Result)callArguments[this.arguments.length];
            result.addChainedResult(r);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Result executePSMProcedure(Session session) {
        Result result;
        int variableCount = this.procedure.getVariableCount();
        session.sessionContext.routineVariables = new Object[variableCount];
        RplSchemaObject rplObject = session.sessionContext.rplObject;
        try {
            session.sessionContext.rplObject = this.procedure;
            result = this.procedure.statement.execute(session);
        }
        finally {
            session.sessionContext.rplObject = rplObject;
        }
        session.sessionContext.closeRoutineVariables();
        if (result.isError()) {
            return result;
        }
        if (this.procedure.returnsCollection()) {
            RowSetNavigator resultNavigator = result.getNavigator();
            if (resultNavigator == null) {
                return Result.newErrorResult(new DataspaceException("Function execution failure. Incompatible data type returned as a result of function execution."));
            }
            RowSetNavigatorData navigator = new RowSetNavigatorData(session, resultNavigator);
            result.setNavigator(navigator);
        }
        return result;
    }

    Result getExpressionResult(Session session) {
        session.sessionData.startRowProcessing();
        Object o = this.expression.getValue(session);
        if (this.expression instanceof FunctionSQL && o instanceof Result) {
            return (Result)o;
        }
        session.sessionContext.closeRoutineVariables();
        if (this.resultMetaData == null) {
            this.getResultMetaData();
        }
        Result r = Result.newSingleColumnResult(this.resultMetaData);
        Object[] row = this.expression.getDataType().isArrayType() ? new Object[]{o} : (o instanceof Object[] ? (Object[])o : new Object[]{o});
        r.getNavigator().add(row);
        return r;
    }

    @Override
    SubQuery[] getSubqueries(Session session) {
        OrderedHashSet subQueries = null;
        if (this.expression != null) {
            subQueries = this.expression.collectAllSubqueries(subQueries);
        }
        for (int i = 0; i < this.arguments.length; ++i) {
            subQueries = this.arguments[i].collectAllSubqueries(subQueries);
        }
        if (subQueries == null || subQueries.size() == 0) {
            return SubQuery.emptySubqueryArray;
        }
        Object[] subQueryArray = new SubQuery[subQueries.size()];
        subQueries.toArray(subQueryArray);
        ArraySort.sort(subQueryArray, 0, subQueryArray.length, (Comparator)subQueryArray[0]);
        for (int i = 0; i < this.subqueries.length; ++i) {
            ((SubQuery)subQueryArray[i]).prepareTable(session);
        }
        return subQueryArray;
    }

    @Override
    public ResultMetaData getResultMetaData() {
        if (this.resultMetaData != null) {
            return this.resultMetaData;
        }
        switch (this.type) {
            case 7: {
                if (this.expression == null) {
                    return ResultMetaData.emptyResultMetaData;
                }
                ResultMetaData md = ResultMetaData.newResultMetaData(1);
                ColumnBase column = new ColumnBase(null, null, null, "@p0");
                column.setType(this.expression.getDataType());
                md.columns[0] = column;
                md.prepareData();
                this.resultMetaData = md;
                return md;
            }
        }
        throw Error.runtimeError(201, "StatementProcedure");
    }

    @Override
    public ResultMetaData getParametersMetaData() {
        return super.getParametersMetaData();
    }

    public Expression[] getArguments() {
        return this.arguments;
    }

    @Override
    void collectTableNamesForRead(OrderedHashSet set) {
        if (this.expression == null) {
            set.addAll(this.procedure.getTableNamesForRead());
        } else {
            int i;
            for (i = 0; i < this.subqueries.length; ++i) {
                if (this.subqueries[i].queryExpression == null) continue;
                this.subqueries[i].queryExpression.getBaseTableNames(set);
            }
            for (i = 0; i < this.routines.length; ++i) {
                set.addAll(this.routines[i].getTableNamesForRead());
            }
        }
    }

    @Override
    void collectTableNamesForWrite(OrderedHashSet set) {
        if (this.expression == null) {
            set.addAll(this.procedure.getTableNamesForWrite());
        }
    }
}

