/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.statement;

import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.lib.IntKeyHashMap;
import com.streamscape.ds.lib.LongKeyHashMap;
import com.streamscape.ds.lib.LongKeyIntValueHashMap;
import com.streamscape.ds.lib.LongValueHashMap;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.parser.statement.StatementDML;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.session.Session;

public final class StatementManager {
    private DataspaceStore store;
    private IntKeyHashMap schemaMap;
    private LongKeyHashMap csidMap;
    private LongKeyIntValueHashMap useMap;
    private long next_cs_id;

    public StatementManager(DataspaceStore database) {
        this.store = database;
        this.schemaMap = new IntKeyHashMap();
        this.csidMap = new LongKeyHashMap();
        this.useMap = new LongKeyIntValueHashMap();
        this.next_cs_id = 0L;
    }

    public synchronized void reset() {
        this.schemaMap.clear();
        this.csidMap.clear();
        this.useMap.clear();
        this.next_cs_id = 0L;
    }

    private long nextID() {
        ++this.next_cs_id;
        return this.next_cs_id;
    }

    private long getStatementID(NameManager.ObjectName schema, String sql) {
        LongValueHashMap sqlMap = (LongValueHashMap)this.schemaMap.get(schema.hashCode());
        if (sqlMap == null) {
            return -1L;
        }
        return sqlMap.get((Object)sql, -1);
    }

    public synchronized Statement getStatement(Session session, long csid) {
        Statement cs = (Statement)this.csidMap.get(csid);
        if (cs == null) {
            return null;
        }
        if (cs.getCompileTimestamp() < this.store.schemaManager.getSchemaChangeTimestamp()) {
            if ((cs = this.recompileStatement(session, cs)) == null) {
                this.freeStatement(csid);
                return null;
            }
            this.csidMap.put(csid, cs);
        }
        return cs;
    }

    public synchronized Statement getStatement(Session session, Statement statement) {
        long csid = statement.getID();
        Statement cs = (Statement)this.csidMap.get(csid);
        if (cs != null) {
            return this.getStatement(session, csid);
        }
        if (statement.getCompileTimestamp() < this.store.schemaManager.getSchemaChangeTimestamp() && (cs = this.recompileStatement(session, statement)) == null) {
            this.freeStatement(csid);
            return null;
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statement recompileStatement(Session session, Statement cs) {
        Statement newStatement;
        NameManager.ObjectName oldSchema = session.getCurrentDataspaceName();
        try {
            NameManager.ObjectName schema = cs.getSchemaName();
            int props = cs.getCursorPropertiesRequest();
            if (schema != null) {
                session.setDataspace(schema.name);
            }
            boolean setGenerated = cs.generatedResultMetaData() != null;
            newStatement = session.compileStatement(cs.getSQL(), props);
            newStatement.setCursorPropertiesRequest(props);
            if (!cs.getResultMetaData().areTypesCompatible(newStatement.getResultMetaData())) {
                Statement statement = null;
                return statement;
            }
            if (!cs.getParametersMetaData().areTypesCompatible(newStatement.getParametersMetaData())) {
                Statement statement = null;
                return statement;
            }
            newStatement.setCompileTimestamp(this.store.txManager.getGlobalChangeTimestamp());
            if (setGenerated) {
                StatementDML si = (StatementDML)cs;
                newStatement.setGeneratedColumnInfo(si.generatedType, si.generatedInputMetaData);
            }
        }
        catch (Throwable t) {
            Statement statement = null;
            return statement;
        }
        finally {
            session.setCurrentDataspaceName(oldSchema);
        }
        return newStatement;
    }

    private long registerStatement(long csid, Statement cs) {
        if (csid < 0L) {
            csid = this.nextID();
            int schemaid = cs.getSchemaName().hashCode();
            LongValueHashMap sqlMap = (LongValueHashMap)this.schemaMap.get(schemaid);
            if (sqlMap == null) {
                sqlMap = new LongValueHashMap();
                this.schemaMap.put(schemaid, sqlMap);
            }
            sqlMap.put(cs.getSQL(), csid);
        }
        cs.setID(csid);
        cs.setCompileTimestamp(this.store.txManager.getGlobalChangeTimestamp());
        this.csidMap.put(csid, cs);
        return csid;
    }

    public synchronized void freeStatement(long csid) {
        if (csid == -1L) {
            return;
        }
        int useCount = this.useMap.get(csid, 1);
        if (useCount > 1) {
            this.useMap.put(csid, useCount - 1);
            return;
        }
        Statement cs = (Statement)this.csidMap.remove(csid);
        if (cs != null) {
            int schemaid = cs.getSchemaName().hashCode();
            LongValueHashMap sqlMap = (LongValueHashMap)this.schemaMap.get(schemaid);
            String sql = cs.getSQL();
            sqlMap.remove(sql);
        }
        this.useMap.remove(csid);
    }

    public synchronized Statement compile(Session session, Result cmd) throws Throwable {
        int props = cmd.getExecuteProperties();
        Statement cs = null;
        String sql = cmd.getMainString();
        long csid = this.getStatementID(session.currentDataspace, sql);
        if (csid >= 0L && (cs = (Statement)this.csidMap.get(csid)) != null && cs.getCursorPropertiesRequest() != props) {
            cs = null;
            csid = -1L;
        }
        if (cs == null || !cs.isValid() || cs.getCompileTimestamp() < this.store.schemaManager.getSchemaChangeTimestamp()) {
            cs = session.compileStatement(sql, props);
            cs.setCursorPropertiesRequest(props);
            csid = this.registerStatement(csid, cs);
        }
        int useCount = this.useMap.get(csid, 0) + 1;
        this.useMap.put(csid, useCount);
        cs.setGeneratedColumnInfo(cmd.getGeneratedResultType(), cmd.getGeneratedResultMetaData());
        return cs;
    }
}

