/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.statement;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArraySort;
import com.streamscape.ds.lib.HashSet;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.store.BaseHashMap;
import com.streamscape.ds.navigator.RowSetNavigatorClient;
import com.streamscape.ds.parser.ParserDQL;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ReadTakeExpression;
import com.streamscape.ds.parser.expression.SubQuery;
import com.streamscape.ds.parser.statement.StatementDMQL;
import com.streamscape.ds.persist.LogRecordType;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultMetaData;
import com.streamscape.ds.schema.column.ColumnBase;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.stable.table.Snapshot;
import com.streamscape.ds.types.LoggedExpression;
import com.streamscape.ds.types.NullType;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import com.streamscape.sef.scheduler.SchedulerException;
import java.util.Comparator;

public class StatementExpression
extends StatementDMQL {
    public Expression expression;
    private LoggedExpression loggedExpression;

    public StatementExpression(Session session, ParserDQL.CompileContext compileContext, int type, Expression expression) {
        super(type, 2007, null);
        switch (type) {
            case 58: 
            case 1201: {
                this.isTransactionStatement = false;
                this.isTransactionStatement = expression instanceof ReadTakeExpression;
                break;
            }
            case 3123: 
            case 3124: {
                this.isTransactionStatement = false;
                break;
            }
            case 7: 
            case 3125: {
                this.isTransactionStatement = true;
                this.isLogged = false;
                if (expression.nodes.length != 1 || expression.nodes[0] == null || !(OtherTypeWrapper.unwrap(expression.nodes[0].valueData) instanceof LoggedExpression)) break;
                this.loggedExpression = (LoggedExpression)OtherTypeWrapper.unwrap(expression.nodes[0].valueData);
                this.isLogged = true;
                break;
            }
            default: {
                throw Error.runtimeError(201, "");
            }
        }
        this.expression = expression;
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
    }

    @Override
    public String getSQL() {
        switch (this.type) {
            case 58: {
                if (this.sql != null) {
                    return this.sql;
                }
                if (this.expression == null) break;
                return "RETURN " + this.expression.getSQL();
            }
            case 1201: {
                if (this.expression != null) {
                    return this.expression.getSQL();
                }
            }
            case 3123: {
                if (this.expression != null) {
                    return this.expression.getSQL();
                }
            }
            case 3124: {
                if (this.expression != null) {
                    return this.expression.getSQL();
                }
            }
            case 3125: {
                if (this.expression != null) {
                    return this.expression.getSQL();
                }
            }
            case 7: {
                if (this.expression == null) break;
                return this.expression.getSQL();
            }
        }
        return "";
    }

    @Override
    SubQuery[] getSubqueries(Session session) {
        BaseHashMap subQueries = null;
        if (this.expression != null) {
            subQueries = this.expression.collectAllSubqueries((OrderedHashSet)subQueries);
        }
        if (subQueries == null || subQueries.size() == 0) {
            return SubQuery.emptySubqueryArray;
        }
        Object[] subQueryArray = new SubQuery[subQueries.size()];
        ((HashSet)subQueries).toArray(subQueryArray);
        ArraySort.sort(subQueryArray, 0, subQueryArray.length, (Comparator)subQueryArray[0]);
        for (int i = 0; i < this.subqueries.length; ++i) {
            ((SubQuery)subQueryArray[i]).prepareTable(session);
        }
        return subQueryArray;
    }

    protected String describe(Session session, int blanks) {
        StringBuffer sb = new StringBuffer();
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        sb.append("STATEMENT");
        return sb.toString();
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            if (this.subqueries.length > 0) {
                this.materializeSubQueries(session);
            }
            result = this.getResult(session);
        }
        catch (Throwable t) {
            if (t instanceof DataspaceException && t.getCause() instanceof SchedulerException) {
                t = t.getCause();
            }
            result = Result.newErrorResult(t, null);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
        } else {
            String loggedStatement = null;
            try {
                String string = loggedStatement = this.loggedExpression != null ? this.loggedExpression.getAndResetLoggedStatement() : null;
                if (loggedStatement != null) {
                    session.dataspaceStore.dataspaceLogger.writeOtherStatement(session, LogRecordType.OTHER, loggedStatement, null);
                }
            }
            catch (Exception exception) {
                Trace.logError(this, "Failed to write logged statement " + loggedStatement);
                Trace.logException(this, exception, true);
            }
        }
        return result;
    }

    @Override
    Result getResult(Session session) {
        switch (this.type) {
            case 58: 
            case 1201: {
                Result result = this.expression.getResult(session);
                if (this.expression instanceof ReadTakeExpression) {
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.OTHER}, new String[]{"object"});
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result newResult = Result.newDataResult(metaData);
                    newResult.setNavigator(navigator);
                    navigator.add(new Object[]{result.getValueObject()});
                    result = newResult;
                }
                return result;
            }
            case 3123: 
            case 3124: {
                this.expression.getValue(session);
                return Result.updateNoResult;
            }
            case 7: {
                return this.processSimpleExpressionResult(session);
            }
            case 3125: {
                Object temp = this.expression.getValue(session);
                if (temp != null && (temp.equals(Void.class) || temp.getClass().equals(Void.class) || temp.getClass().equals(com.streamscape.sdo.sys.Void.class))) {
                    return Result.updateNoResult;
                }
                if (temp instanceof Result) {
                    return (Result)temp;
                }
                if (OtherTypeWrapper.unwrap(temp) instanceof Snapshot) {
                    temp = ((Snapshot)OtherTypeWrapper.unwrap(temp)).toRowSet(session);
                }
                if (this.expression.getType() == 103 && this.expression.getDataType() instanceof NullType && temp == null) {
                    return Result.updateNoResult;
                }
                ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{this.expression.getDataType()}, new String[]{this.expression.getType() == 103 ? "RESULT" : "VALUE"});
                RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                Result result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                navigator.add(new Object[]{temp});
                return result;
            }
        }
        throw Error.runtimeError(201, "");
    }

    @Override
    public ResultMetaData getResultMetaData() {
        switch (this.type) {
            case 3125: {
                if (this.expression == null) {
                    return ResultMetaData.emptyResultMetaData;
                }
                ResultMetaData md = ResultMetaData.newResultMetaData(1);
                ColumnBase column = new ColumnBase(null, null, null, "@p0");
                column.setType(this.expression.getDataType());
                md.columns[0] = column;
                md.prepareData();
                return md;
            }
        }
        return super.getResultMetaData();
    }

    public Result processSimpleExpressionResult(Session session) {
        ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{this.expression.getDataType()}, new String[]{"result"});
        RowSetNavigatorClient navigator = new RowSetNavigatorClient();
        Result result = Result.newDataResult(metaData);
        result.setNavigator(navigator);
        navigator.add(new Object[]{this.expression.getValue(session)});
        return result;
    }

    @Override
    public void resolve(Session session) {
    }

    @Override
    String describeImpl(Session session) throws Exception {
        return this.getSQL();
    }

    @Override
    void collectTableNamesForRead(OrderedHashSet set) {
        int i;
        for (i = 0; i < this.subqueries.length; ++i) {
            if (this.subqueries[i].queryExpression == null) continue;
            this.subqueries[i].queryExpression.getBaseTableNames(set);
        }
        for (i = 0; i < this.routines.length; ++i) {
            set.addAll(this.routines[i].getTableNamesForRead());
        }
    }

    @Override
    void collectTableNamesForWrite(OrderedHashSet set) {
    }

    @Override
    public void setDatabaseObjects(Session session, ParserDQL.CompileContext compileContext) {
        super.setDatabaseObjects(session, compileContext);
        if (this.expression != null && this.expression instanceof ReadTakeExpression) {
            this.expression.collectObjectNames(this.references);
        }
    }
}

