/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.statement;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.HsqlList;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.navigator.RangeIterator;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.parser.ParserDQL;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionColumn;
import com.streamscape.ds.parser.expression.ExpressionLogical;
import com.streamscape.ds.parser.expression.ExpressionValue;
import com.streamscape.ds.parser.expression.QuerySpecification;
import com.streamscape.ds.parser.statement.StatementDML;
import com.streamscape.ds.parser.statement.StatementDMQL;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.range.RangeVariableResolver;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultMetaData;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.table.DfetchMonitor;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.transaction.TransactionManagerMVCC;
import com.streamscape.ds.types.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class StatementDfetch
extends StatementDMQL {
    private Set<String> addedColumns;
    private boolean deleteRow;
    private long timeout;
    private TimeUnit timeUnit;
    private DfetchMonitor dfetchMonitor;
    private ParserDQL.CompileContext compileContext;
    private Expression whereCondition;
    private StatementDML updateRowStatement;
    private ThreadLocal<Boolean> executingUpdate = new ThreadLocal();

    public StatementDfetch(Session session, QuerySpecification querySpecification, ParserDQL.CompileContext compileContext, boolean deleteRow) {
        super(deleteRow ? 100 : 101, 2004, session.getCurrentDataspaceName());
        this.queryExpression = querySpecification;
        this.compileContext = compileContext;
        this.deleteRow = deleteRow;
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
        this.baseTable = this.rangeVariables[0].rangeTable;
        this.dfetchMonitor = this.rangeVariables[0].rangeTable.dfetchMonitor;
        this.whereCondition = ((QuerySpecification)this.queryExpression).queryCondition;
    }

    public void setAddedColumns(Set<String> addedColumns) {
        this.addedColumns = addedColumns;
    }

    public void setUpdateRowStatement(StatementDML updateRowStatement) {
        this.updateRowStatement = updateRowStatement;
    }

    public void setTimeout(long timeout, TimeUnit timeUnit) {
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    @Override
    Result getResult(Session session) {
        this.executingUpdate.set(false);
        return this.getResultWithRetries(session, this.timeout >= 0L ? this.timeUnit.toMillis(this.timeout) : -1L);
    }

    Result getResultWithRetries(Session session, long timeoutMillis) {
        try {
            this.dfetchMonitor.beginTake();
            this.dfetchMonitor.addWhereCondition(this.whereCondition);
            long startTime = System.currentTimeMillis();
            int retriesCount = 0;
            while (true) {
                try {
                    if (timeoutMillis > 0L) {
                        timeoutMillis -= System.currentTimeMillis() - startTime;
                        startTime = System.currentTimeMillis();
                        if (timeoutMillis <= 0L) {
                            timeoutMillis = -1L;
                        }
                    }
                    Result result = this.getResultWithRetriesImpl(session, timeoutMillis);
                    return result;
                }
                catch (RetryDfetchException exception) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    if (++retriesCount == 20) {
                        Trace.logError(this, "Dfetch max retries count 20 has reached.");
                        throw (DataspaceException)exception.getCause();
                    }
                    session.redoAction = false;
                    continue;
                }
                break;
            }
        }
        finally {
            this.dfetchMonitor.removeWhereCondition(this.whereCondition);
            this.dfetchMonitor.endTake();
        }
    }

    Result getResultWithRetriesImpl(Session session, long timeoutMillis) {
        Result result = this.getResultWithBlocking(session, timeoutMillis);
        if (result.isError()) {
            return result;
        }
        RowSetNavigator navigator = result.getNavigator();
        if (navigator.hasNext()) {
            navigator.next();
            if (this.deleteRow) {
                this.deleteRow(session, result, navigator.getCurrent());
            } else if (this.updateRowStatement != null) {
                this.updateRow(session, result, navigator.getCurrent());
            }
            navigator.beforeFirst();
        }
        if (this.addedColumns != null && this.addedColumns.size() > 0) {
            int columnsCount = result.metaData.getColumnCount() - this.addedColumns.size();
            ResultMetaData newResultMetaData = ResultMetaData.newResultMetaData(columnsCount);
            if (result.metaData.colIndexes != null && result.metaData.colIndexes.length > columnsCount) {
                newResultMetaData.colIndexes = Arrays.copyOf(result.metaData.colIndexes, columnsCount);
            }
            if (result.metaData.columnLabels != null && result.metaData.columnLabels.length > columnsCount) {
                newResultMetaData.columnLabels = Arrays.copyOf(result.metaData.columnLabels, columnsCount);
            }
            if (result.metaData.columns != null && result.metaData.columns.length > columnsCount) {
                newResultMetaData.columns = Arrays.copyOf(result.metaData.columns, columnsCount);
            }
            if (result.metaData.columnTypes != null && result.metaData.columnTypes.length > columnsCount) {
                newResultMetaData.columnTypes = Arrays.copyOf(result.metaData.columnTypes, columnsCount);
            }
            result.metaData = newResultMetaData;
        }
        return result;
    }

    private Result getResultWithBlocking(Session session, long timeoutMillis) {
        Result result = null;
        long start = System.currentTimeMillis();
        do {
            if (this.queryExpression instanceof QuerySpecification) {
                for (RangeVariable v : ((QuerySpecification)this.queryExpression).rangeVariables) {
                    for (RangeIterator iterator : session.sessionContext.rangeIterators) {
                        if (!(iterator instanceof RangeVariable.RangeIteratorBase) || ((RangeVariable.RangeIteratorBase)iterator).rangeVar != v) continue;
                        iterator.reset();
                    }
                }
            }
            result = this.executeStatementWithIsolationHack(session, this.queryExpression);
            result.setStatement(this);
            if (result.isError()) break;
            RowSetNavigator navigator = result.getNavigator();
            if (navigator.hasNext()) {
                navigator.beforeFirst();
                break;
            }
            try {
                if (timeoutMillis > 0L) {
                    this.dfetchMonitor.waitMillis(timeoutMillis);
                } else if (timeoutMillis == 0L) {
                    this.dfetchMonitor.waitMillis(60000L);
                }
            }
            catch (InterruptedException exception) {
                timeoutMillis = -1L;
                Trace.logInfo(this, "Dfetch thread has been interrupted.");
            }
            if (timeoutMillis <= 0L || (timeoutMillis -= System.currentTimeMillis() - start) != 0L) continue;
            timeoutMillis = -1L;
        } while (timeoutMillis >= 0L);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRow(Session session, Result result, Object[] current) {
        Expression oldCondition = this.compileWhereCondition(session, result, current);
        StatementDML deleteStatement = new StatementDML(session, this.rangeVariables[0].rangeTable, this.rangeVariables, this.compileContext, false, 19);
        try {
            this.executeStatement(session, deleteStatement, "delete");
        }
        finally {
            this.setJoinCondition(session, oldCondition, false);
        }
    }

    private void updateRow(Session session, Result result, Object[] current) {
        if (this.updateRowStatement == null) {
            return;
        }
        Expression oldCondition = this.compileWhereCondition(session, result, current);
        this.executeStatement(session, this.updateRowStatement, "update");
        this.setJoinCondition(session, oldCondition, false);
    }

    private Expression compileWhereCondition(Session session, Result result, Object[] current) {
        HashSet<ColumnSchema> identityColumns = new HashSet<ColumnSchema>();
        if (this.baseTable.hasPrimaryKey()) {
            for (int index : this.baseTable.getPrimaryKey()) {
                identityColumns.add(this.baseTable.getColumn(index));
            }
        } else if (this.baseTable.hasIdentityColumn()) {
            identityColumns.add(this.baseTable.getColumn(this.baseTable.getIdentityColumnIndex()));
        } else {
            throw new DataspaceException("Identity or primary key not exist in table '" + this.baseTable.getObjectName().name + "'.");
        }
        Expression whereCondition = null;
        for (ColumnSchema column : identityColumns) {
            ExpressionColumn expressionColumn = new ExpressionColumn(column);
            int columnIndex = -1;
            for (int index = 0; index < result.metaData.columnLabels.length; ++index) {
                if (!result.metaData.columns[index].getNameString().equals(column.getNameString())) continue;
                columnIndex = index;
            }
            if (columnIndex == -1) {
                throw new DataspaceException("Column '" + column.getNameString() + "' not found in result set.");
            }
            ExpressionValue expressionValue = new ExpressionValue(current[columnIndex], result.metaData.columnTypes[columnIndex]);
            ExpressionLogical condition = new ExpressionLogical(expressionColumn, (Expression)expressionValue);
            if (whereCondition == null) {
                whereCondition = condition;
                continue;
            }
            whereCondition = new ExpressionLogical(49, whereCondition, condition);
        }
        HsqlList unresolved = whereCondition.resolveColumnReferences(session, new RangeVariable[0], null);
        unresolved = Expression.resolveColumnSet(session, this.rangeVariables, this.rangeVariables.length, unresolved, null);
        ExpressionColumn.checkColumnsResolved(unresolved);
        ((ExpressionLogical)whereCondition).resolveTypes(session, null);
        if (whereCondition.isUnresolvedParam()) {
            ((ExpressionLogical)whereCondition).dataType = Type.SQL_BOOLEAN;
        }
        if (whereCondition.getDataType() != Type.SQL_BOOLEAN) {
            throw Error.error(5568);
        }
        return this.setJoinCondition(session, whereCondition, false);
    }

    private Expression setJoinCondition(Session session, Expression newCondition, boolean add) {
        Expression oldJoinCondition = this.rangeVariables[0].getJoinCondition();
        if (add) {
            this.rangeVariables[0].addJoinCondition(newCondition);
        } else {
            this.rangeVariables[0].setJoinCondition(newCondition);
            this.rangeVariables[0].resetConditions();
        }
        RangeVariableResolver resolver = new RangeVariableResolver(this.rangeVariables, null, this.compileContext);
        resolver.processConditions(session);
        this.rangeVariables = resolver.rangeVariables;
        return oldJoinCondition;
    }

    public boolean isExecutingUpdate() {
        Boolean executingUpdateValue = this.executingUpdate.get();
        return executingUpdateValue != null && executingUpdateValue != false;
    }

    private Result executeStatementWithIsolationHack(Session session, Object statement) {
        return this.executeStatementWithIsolationHackInternal(session, statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result executeStatementWithIsolationHackInternal(Session session, Object statement) {
        TransactionManagerMVCC tx;
        TransactionManagerMVCC transactionManagerMVCC = tx = session.dataspaceStore.txManager.isMVCC() ? (TransactionManagerMVCC)session.dataspaceStore.txManager : null;
        if (tx != null && !(statement instanceof QuerySpecification) && !this.executingUpdate.get().booleanValue()) {
            tx.writeLock.lock();
            try {
                this.executingUpdate.set(true);
                if (tx.catalogWriteSession != null) {
                    session.latch.countUp();
                    tx.catalogWriteSession.waitingSessions.add(session);
                    session.waitedSessions.add(tx.catalogWriteSession);
                }
            }
            finally {
                tx.writeLock.unlock();
            }
            try {
                session.latch.await();
            }
            catch (InterruptedException e) {
                throw new DataspaceException("Session has been interrupted.");
            }
        }
        long actionTimestampBkp = session.actionTimestamp;
        long transactionTimestampBkp = session.transactionTimestamp;
        if (session.getIsolation() == 8 || session.getIsolation() == 4) {
            session.transactionTimestamp = Long.MAX_VALUE;
            session.actionTimestamp = Long.MAX_VALUE;
        } else if (session.getIsolation() == 2) {
            session.actionTimestamp = Long.MAX_VALUE;
        }
        try {
            Result result = statement instanceof QuerySpecification ? ((QuerySpecification)statement).getResult(session, session.getMaxRows()) : ((StatementDML)statement).getResult(session);
            return result;
        }
        finally {
            session.actionTimestamp = actionTimestampBkp;
            session.transactionTimestamp = transactionTimestampBkp;
        }
    }

    private void executeStatement(Session session, StatementDML statement, String name) {
        try {
            Result result = this.executeStatementWithIsolationHack(session, statement);
            if (result.isError()) {
                if (result.getErrorCode() == 4871) {
                    Trace.logDebug(this, "Dfetch: row change by multiple transactions. Retrying dfetch.");
                    throw new RetryDfetchException(new DataspaceException(result));
                }
                throw new DataspaceException(result);
            }
            if (result.isUpdateCount() && result.getUpdateCount() == 0) {
                Trace.logDebug(this, "Dfetch updated zero rows. Retrying dfetch.");
                throw new RetryDfetchException(new DataspaceException("Dfetch update/delete statement returned zero update count."));
            }
            if (!result.isUpdateCount() || result.getUpdateCount() != 1) {
                throw new DataspaceException("More then one row updated/deleted in dfetch statement. UpdateCount: " + result.getUpdateCount());
            }
        }
        catch (RetryDfetchException exception) {
            throw exception;
        }
        catch (DataspaceException exception) {
            if (exception.getErrorCode() == -4871) {
                Trace.logDebug(this, "Dfetch: row change by multiple transactions. Retrying dfetch.");
                throw new RetryDfetchException(exception);
            }
            throw exception;
        }
        catch (Throwable exception) {
            Trace.logException(this, exception, true);
            throw new DataspaceException("Failed to " + name + " row. Cause: " + exception.getMessage());
        }
    }

    @Override
    public ResultMetaData getResultMetaData() {
        return this.queryExpression.getMetaData();
    }

    @Override
    void collectTableNamesForRead(OrderedHashSet set) {
        int i;
        this.queryExpression.getBaseTableNames(set);
        for (i = 0; i < this.subqueries.length; ++i) {
            if (this.subqueries[i].queryExpression == null) continue;
            this.subqueries[i].queryExpression.getBaseTableNames(set);
        }
        for (i = 0; i < this.routines.length; ++i) {
            set.addAll(this.routines[i].getTableNamesForRead());
        }
    }

    @Override
    void collectTableNamesForWrite(OrderedHashSet set) {
        if (this.queryExpression.isUpdatable) {
            this.queryExpression.getBaseTableNames(set);
        }
    }

    @Override
    public int getResultProperties() {
        return 0;
    }

    static class RetryDfetchException
    extends RuntimeException {
        public RetryDfetchException(DataspaceException cause) {
            super(cause);
        }
    }
}

