/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.statement;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.SqlInvariants;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArraySort;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.lib.HashSet;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.parser.ParserDQL;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionColumn;
import com.streamscape.ds.parser.expression.QueryExpression;
import com.streamscape.ds.parser.expression.SubQuery;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultMetaData;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.schema.sequence.NumberSequence;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class StatementDMQL
extends Statement {
    public static final String PCOL_PREFIX = "@p";
    static final String RETURN_COLUMN_NAME = "@p0";
    Table targetTable;
    Table baseTable;
    int[] baseColumnMap;
    RangeVariable[] targetRangeVariables = RangeVariable.emptyArray;
    Table sourceTable;
    Expression condition;
    boolean restartIdentity;
    int[] insertColumnMap = ValuePool.emptyIntArray;
    int[] updateColumnMap = ValuePool.emptyIntArray;
    int[] baseUpdateColumnMap = ValuePool.emptyIntArray;
    Expression[] updateExpressions = Expression.emptyArray;
    Expression[][] multiColumnValues;
    Expression insertExpression;
    boolean[] insertCheckColumns;
    boolean[] updateCheckColumns;
    Expression updatableTableCheck;
    RangeVariable checkRangeVariable;
    public QueryExpression queryExpression;
    NameManager.SimpleName cursorName;
    ExpressionColumn[] parameters;
    ResultMetaData parameterMetaData;
    SubQuery[] subqueries = SubQuery.emptySubqueryArray;
    public int rangeIteratorCount;
    NumberSequence[] sequences;
    RplScript[] routines;
    RangeVariable[] rangeVariables;

    StatementDMQL(int type, int group, NameManager.ObjectName schemaName) {
        super(type, group);
        this.schemaName = schemaName;
        this.isTransactionStatement = true;
    }

    void setBaseIndexColumnMap() {
        if (this.targetTable != this.baseTable) {
            this.baseColumnMap = this.targetTable.getBaseTableColumnMap();
        }
    }

    public void setCursorName(NameManager.SimpleName name) {
        this.cursorName = name;
    }

    public NameManager.SimpleName getCursorName() {
        return this.cursorName;
    }

    @Override
    public Result execute(Session session) {
        Result result;
        if (this.targetTable != null && session.isReadOnly() && !this.targetTable.isTemp()) {
            DataspaceException e = Error.error(3706);
            return Result.newErrorResult(e);
        }
        if (this.isExplain) {
            return this.getExplainResult(session);
        }
        try {
            if (this.subqueries.length > 0) {
                this.materializeSubQueries(session);
            }
            result = this.getResult(session);
            this.clearStructures(session);
        }
        catch (Throwable t) {
            this.clearStructures(session);
            result = Result.newErrorResult(t, null);
            result.getException().setStatementType(this.group, this.type);
        }
        return result;
    }

    private Result getExplainResult(Session session) {
        NameManager.ObjectName name;
        int i;
        Result result = Result.newSingleColumnStringResult("OPERATION", this.describe(session));
        OrderedHashSet set = this.getReferences();
        result.navigator.add(new Object[]{"Object References"});
        for (i = 0; i < set.size(); ++i) {
            name = (NameManager.ObjectName)set.get(i);
            result.navigator.add(new Object[]{name.getSchemaQualifiedStatementName()});
        }
        result.navigator.add(new Object[]{"Read Locks"});
        for (i = 0; i < this.readTableNames.length; ++i) {
            name = this.readTableNames[i];
            result.navigator.add(new Object[]{name.getSchemaQualifiedStatementName()});
        }
        result.navigator.add(new Object[]{"WriteLocks"});
        for (i = 0; i < this.writeTableNames.length; ++i) {
            name = this.writeTableNames[i];
            result.navigator.add(new Object[]{name.getSchemaQualifiedStatementName()});
        }
        return result;
    }

    abstract Result getResult(Session var1);

    abstract void collectTableNamesForRead(OrderedHashSet var1);

    abstract void collectTableNamesForWrite(OrderedHashSet var1);

    boolean[] getInsertOrUpdateColumnCheckList() {
        switch (this.type) {
            case 50: {
                return this.insertCheckColumns;
            }
            case 82: {
                return this.updateCheckColumns;
            }
            case 128: {
                boolean[] check = (boolean[])ArrayUtil.duplicateArray(this.insertCheckColumns);
                ArrayUtil.orBooleanArray(this.updateCheckColumns, check);
                return check;
            }
        }
        return null;
    }

    private void setParameters() {
        for (int i = 0; i < this.parameters.length; ++i) {
            this.parameters[i].parameterIndex = i;
        }
    }

    void materializeSubQueries(Session session) {
        HashSet subqueryPopFlags = new HashSet();
        for (int i = 0; i < this.subqueries.length; ++i) {
            SubQuery sq = this.subqueries[i];
            if (!subqueryPopFlags.add(sq) || sq.isCorrelated()) continue;
            sq.materialise(session);
        }
    }

    SubQuery[] getSubqueries(Session session) {
        int i;
        OrderedHashSet subQueries = null;
        for (i = 0; i < this.targetRangeVariables.length; ++i) {
            if (this.targetRangeVariables[i] == null) continue;
            OrderedHashSet set = this.targetRangeVariables[i].getSubqueries();
            subQueries = OrderedHashSet.addAll(subQueries, set);
        }
        for (i = 0; i < this.updateExpressions.length; ++i) {
            subQueries = this.updateExpressions[i].collectAllSubqueries(subQueries);
        }
        if (this.insertExpression != null) {
            subQueries = this.insertExpression.collectAllSubqueries(subQueries);
        }
        if (this.condition != null) {
            subQueries = this.condition.collectAllSubqueries(subQueries);
        }
        if (this.queryExpression != null) {
            OrderedHashSet set = this.queryExpression.getSubqueries();
            subQueries = OrderedHashSet.addAll(subQueries, set);
        }
        if (this.updatableTableCheck != null) {
            OrderedHashSet set = this.updatableTableCheck.getSubqueries();
            subQueries = OrderedHashSet.addAll(subQueries, set);
        }
        if (subQueries == null || subQueries.size() == 0) {
            return SubQuery.emptySubqueryArray;
        }
        Object[] subQueryArray = new SubQuery[subQueries.size()];
        subQueries.toArray(subQueryArray);
        ArraySort.sort(subQueryArray, 0, subQueryArray.length, (Comparator)subQueryArray[0]);
        for (int i2 = 0; i2 < subQueryArray.length; ++i2) {
            ((SubQuery)subQueryArray[i2]).prepareTable(session);
        }
        return subQueryArray;
    }

    public void setDatabaseObjects(Session session, ParserDQL.CompileContext compileContext) {
        this.parameters = compileContext.getParameters();
        this.setParameters();
        this.setParameterMetaData();
        this.subqueries = this.getSubqueries(session);
        this.rangeIteratorCount = compileContext.getRangeVarCount();
        this.rangeVariables = compileContext.getRangeVariables();
        this.sequences = compileContext.getSequences();
        this.routines = compileContext.getRoutines();
        OrderedHashSet set = new OrderedHashSet();
        this.collectTableNamesForWrite(set);
        if (set.size() > 0) {
            this.writeTableNames = new NameManager.ObjectName[set.size()];
            set.toArray(this.writeTableNames);
            set.clear();
        }
        this.collectTableNamesForRead(set);
        set.removeAll(this.writeTableNames);
        if (set.size() > 0) {
            this.readTableNames = new NameManager.ObjectName[set.size()];
            set.toArray(this.readTableNames);
        }
        this.references = compileContext.getSchemaObjectNames();
        if (this.targetTable != null) {
            this.references.add(this.targetTable.getObjectName());
        }
    }

    void checkAccessRights(Session session) {
        int i;
        if (this.targetTable != null && !this.targetTable.isTemp()) {
            Grantee owner;
            if (!session.isProcessingLog) {
                this.targetTable.checkDataReadOnly();
            }
            if (!((owner = this.targetTable.getOwner()) == null || !owner.isSystem() || session.getUser().isSystem() || this.targetTable.getObjectName().schema.equals(SqlInvariants.SDS_SCHEMA_NAME) || this.targetTable.getObjectName().schema.equals(SqlInvariants.RDS_SCHEMA_NAME) || this.targetTable.getObjectName().schema.equals(SqlInvariants.SCH_SCHEMA_NAME))) {
                throw Error.error(5501, this.targetTable.getObjectName().name);
            }
            session.checkReadWrite();
        }
        if (session.isAdmin() && session.getGrantee().isSudoCapable()) {
            return;
        }
        for (i = 0; i < this.sequences.length; ++i) {
            session.getGrantee().checkAccess(this.sequences[i]);
        }
        for (i = 0; i < this.routines.length; ++i) {
            session.getGrantee().checkAccess(this.routines[i]);
        }
        for (i = 0; i < this.rangeVariables.length; ++i) {
            RangeVariable range = this.rangeVariables[i];
            if (range.rangeTable.getSchemaName() == SqlInvariants.SYSTEM_SCHEMA_NAME || range.rangeTable.getSchemaName() == SqlInvariants.SYSTEM_SUBQUERY_NAME || range.rangeTable.getSchemaName() == SqlInvariants.SYS_SCHEMA_NAME || range.rangeTable.getSchemaName() == SqlInvariants.SDS_SCHEMA_NAME && !session.isInteractive() || range.rangeTable.getSchemaName() == SqlInvariants.SCH_SCHEMA_NAME && !session.isInteractive() || range.rangeTable.getSchemaName() == SqlInvariants.RDS_SCHEMA_NAME && !session.isInteractive()) continue;
            session.getGrantee().checkSelect(range.rangeTable, range.usedColumns);
        }
        if (this.targetTable != null && this.targetTable.getSchemaName() == SqlInvariants.SDS_SCHEMA_NAME && !session.isInteractive()) {
            return;
        }
        if (this.targetTable != null && this.targetTable.getSchemaName() == SqlInvariants.SCH_SCHEMA_NAME && !session.isInteractive()) {
            return;
        }
        switch (this.type) {
            case 7: {
                break;
            }
            case 50: {
                session.getGrantee().checkInsert(this.targetTable, this.insertCheckColumns);
                break;
            }
            case 85: {
                break;
            }
            case 19: 
            case 100: {
                session.getGrantee().checkDelete(this.targetTable);
                break;
            }
            case 82: 
            case 101: {
                session.getGrantee().checkUpdate(this.targetTable, this.updateCheckColumns);
                break;
            }
            case 128: {
                session.getGrantee().checkInsert(this.targetTable, this.insertCheckColumns);
                session.getGrantee().checkUpdate(this.targetTable, this.updateCheckColumns);
            }
        }
    }

    Result getWriteAccessResult(Session session) {
        try {
            if (this.targetTable != null && !this.targetTable.isTemp()) {
                session.checkReadWrite();
            }
        }
        catch (DataspaceException e) {
            return Result.newErrorResult(e);
        }
        return null;
    }

    @Override
    public ResultMetaData getResultMetaData() {
        switch (this.type) {
            case 19: 
            case 50: 
            case 82: 
            case 128: 
            case 3001: {
                return ResultMetaData.emptyResultMetaData;
            }
        }
        throw Error.runtimeError(201, "StatementDMQL");
    }

    @Override
    public ResultMetaData getParametersMetaData() {
        return this.parameterMetaData;
    }

    void setParameterMetaData() {
        int offset = 0;
        if (this.parameters.length == 0) {
            this.parameterMetaData = ResultMetaData.emptyParamMetaData;
            return;
        }
        this.parameterMetaData = ResultMetaData.newParameterMetaData(this.parameters.length);
        for (int i = 0; i < this.parameters.length; ++i) {
            int idx = i + offset;
            this.parameterMetaData.columnLabels[idx] = PCOL_PREFIX + (i + 1);
            if (this.parameters[i].dataType == null) {
                throw Error.error(5567);
            }
            this.parameterMetaData.columnTypes[idx] = this.parameters[i].dataType;
            byte parameterMode = 1;
            if (this.parameters[i].column != null && this.parameters[i].column.getParameterMode() != 0) {
                parameterMode = this.parameters[i].column.getParameterMode();
            }
            this.parameterMetaData.paramModes[idx] = parameterMode;
            this.parameterMetaData.paramNullable[idx] = this.parameters[i].column == null ? (byte)1 : this.parameters[i].column.getNullability();
        }
    }

    @Override
    public String describe(Session session) {
        try {
            return this.describeImpl(session);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return e.toString();
        }
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        switch (this.type) {
            case 85: {
                result.put("statementType", "SELECT");
                result.putAll(this.queryExpression.describeJson(session));
                this.appendParmsJson(result);
                this.appendSubqueriesJson(session, result);
                break;
            }
            case 100: {
                result.put("statementType", "DFETCH");
                result.putAll(this.queryExpression.describeJson(session));
                this.appendParmsJson(result);
                result.put("deleteRow", true);
                break;
            }
            case 101: {
                result.put("statementType", "DFETCH");
                result.putAll(this.queryExpression.describeJson(session));
                this.appendParmsJson(result);
                result.put("updateRow", true);
                break;
            }
            case 50: {
                if (this.queryExpression == null) {
                    result.put("statementType", "INSERT VALUES");
                    this.appendMultiColumnsJson(result, this.insertColumnMap);
                    this.appendTableJson(result);
                    this.appendParmsJson(result);
                    this.appendSubqueriesJson(session, result);
                    break;
                }
                result.put("statementType", "INSERT SELECT");
                this.appendColumnsJson(result, this.insertColumnMap);
                this.appendTableJson(result);
                result.put("queryExpression", this.queryExpression.describeJson(session));
                this.appendParmsJson(result);
                this.appendSubqueriesJson(session, result);
                break;
            }
            case 82: {
                result.put("statementType", "UPDATE");
                this.appendColumnsJson(result, this.updateColumnMap);
                this.appendTableJson(result);
                this.appendConditionJson(session, result);
                ArrayList<Map<String, Object>> targetRangeVariablesExplained = new ArrayList<Map<String, Object>>();
                for (int i = 0; i < this.targetRangeVariables.length; ++i) {
                    targetRangeVariablesExplained.add(this.targetRangeVariables[i].describeJson(session));
                }
                result.put("targetRangeVariables", targetRangeVariablesExplained);
                this.appendParmsJson(result);
                this.appendSubqueriesJson(session, result);
                break;
            }
            case 19: {
                result.put("statementType", "DELETE");
                this.appendTableJson(result);
                this.appendConditionJson(session, result);
                ArrayList<Map<String, Object>> targetRangeVariablesExplained = new ArrayList<Map<String, Object>>();
                for (int i = 0; i < this.targetRangeVariables.length; ++i) {
                    targetRangeVariablesExplained.add(this.targetRangeVariables[i].describeJson(session));
                }
                result.put("targetRangeVariables", targetRangeVariablesExplained);
                this.appendParmsJson(result);
                this.appendSubqueriesJson(session, result);
                break;
            }
            case 7: {
                result.put("statementType", "CALL");
                break;
            }
            case 128: {
                result.put("statementType", "MERGE");
                this.appendMultiColumnsJson(result, this.insertColumnMap);
                this.appendColumnsJson(result, this.updateColumnMap);
                this.appendTableJson(result);
                this.appendConditionJson(session, result);
                ArrayList<Map<String, Object>> targetRangeVariablesExplained = new ArrayList<Map<String, Object>>();
                for (int i = 0; i < this.targetRangeVariables.length; ++i) {
                    targetRangeVariablesExplained.add(this.targetRangeVariables[i].describeJson(session));
                }
                result.put("targetRangeVariables", targetRangeVariablesExplained);
                this.appendParmsJson(result);
                this.appendSubqueriesJson(session, result);
                break;
            }
            default: {
                result.put("unknown", true);
            }
        }
        return result;
    }

    String describeImpl(Session session) throws Exception {
        StringBuffer sb = new StringBuffer();
        int blanks = 0;
        switch (this.type) {
            case 85: {
                sb.append(this.queryExpression.describe(session, 0));
                this.appendParms(sb).append('\n');
                this.appendSubqueries(session, sb, 2);
                return sb.toString();
            }
            case 100: {
                sb.append("DFETCH ").append(this.queryExpression.describe(session, 0));
                this.appendParms(sb).append('\n');
                sb.append("(DELETE ROW)\n");
                return sb.toString();
            }
            case 101: {
                sb.append("DFETCH ").append(this.queryExpression.describe(session, 0));
                this.appendParms(sb).append('\n');
                sb.append("(UPDATE ROW)");
                return sb.toString();
            }
            case 50: {
                if (this.queryExpression == null) {
                    sb.append("INSERT VALUES");
                    sb.append('[').append('\n');
                    this.appendMultiColumns(sb, this.insertColumnMap).append('\n');
                    this.appendTable(sb).append('\n');
                    this.appendParms(sb).append('\n');
                    this.appendSubqueries(session, sb, 2).append(']');
                    return sb.toString();
                }
                sb.append("INSERT SELECT");
                sb.append('[').append('\n');
                this.appendColumns(sb, this.insertColumnMap).append('\n');
                this.appendTable(sb).append('\n');
                sb.append(this.queryExpression.describe(session, blanks)).append('\n');
                this.appendParms(sb).append('\n');
                this.appendSubqueries(session, sb, 2).append(']');
                return sb.toString();
            }
            case 82: {
                sb.append("UPDATE");
                sb.append('[').append('\n');
                this.appendColumns(sb, this.updateColumnMap).append('\n');
                this.appendTable(sb).append('\n');
                this.appendCondition(session, sb);
                for (int i = 0; i < this.targetRangeVariables.length; ++i) {
                    sb.append(this.targetRangeVariables[i].describe(session, blanks)).append('\n');
                }
                this.appendParms(sb).append('\n');
                this.appendSubqueries(session, sb, 2).append(']');
                return sb.toString();
            }
            case 19: {
                sb.append("DELETE");
                sb.append('[').append('\n');
                this.appendTable(sb).append('\n');
                this.appendCondition(session, sb);
                for (int i = 0; i < this.targetRangeVariables.length; ++i) {
                    sb.append(this.targetRangeVariables[i].describe(session, blanks)).append('\n');
                }
                this.appendParms(sb).append('\n');
                this.appendSubqueries(session, sb, 2).append(']');
                return sb.toString();
            }
            case 7: {
                sb.append("CALL");
                sb.append('[').append(']');
                return sb.toString();
            }
            case 128: {
                sb.append("MERGE");
                sb.append('[').append('\n');
                this.appendMultiColumns(sb, this.insertColumnMap).append('\n');
                this.appendColumns(sb, this.updateColumnMap).append('\n');
                this.appendTable(sb).append('\n');
                this.appendCondition(session, sb);
                for (int i = 0; i < this.targetRangeVariables.length; ++i) {
                    sb.append(this.targetRangeVariables[i].describe(session, blanks)).append('\n');
                }
                this.appendParms(sb).append('\n');
                this.appendSubqueries(session, sb, 2).append(']');
                return sb.toString();
            }
        }
        return "UNKNOWN";
    }

    private StringBuffer appendSubqueries(Session session, StringBuffer sb, int blanks) {
        sb.append("SUBQUERIES[");
        for (int i = 0; i < this.subqueries.length; ++i) {
            sb.append("\n[level=").append(this.subqueries[i].level).append('\n');
            if (this.subqueries[i].queryExpression == null) {
                for (int j = 0; j < blanks; ++j) {
                    sb.append(' ');
                }
                sb.append("value expression");
            } else {
                sb.append(this.subqueries[i].queryExpression.describe(session, blanks));
            }
            sb.append("]");
        }
        sb.append(']');
        return sb;
    }

    private StringBuffer appendTable(StringBuffer sb) {
        sb.append("TABLE[").append(this.targetTable.getObjectName().name).append(']');
        return sb;
    }

    private StringBuffer appendColumns(StringBuffer sb, int[] columnMap) {
        int i;
        if (columnMap == null || this.updateExpressions.length == 0) {
            return sb;
        }
        sb.append("COLUMNS=[");
        for (i = 0; i < columnMap.length; ++i) {
            sb.append('\n').append(columnMap[i]).append(':').append(' ').append(this.targetTable.getColumn(columnMap[i]).getNameString());
        }
        for (i = 0; i < this.updateExpressions.length; ++i) {
            sb.append('[').append(this.updateExpressions[i]).append(']');
        }
        sb.append(']');
        return sb;
    }

    private StringBuffer appendMultiColumns(StringBuffer sb, int[] columnMap) {
        if (columnMap == null || this.multiColumnValues == null) {
            return sb;
        }
        sb.append("COLUMNS=[");
        for (int j = 0; j < this.multiColumnValues.length; ++j) {
            for (int i = 0; i < columnMap.length; ++i) {
                sb.append('\n').append(columnMap[i]).append(':').append(' ').append(this.targetTable.getColumn((int)columnMap[i]).getObjectName().name).append('[').append(this.multiColumnValues[j][i]).append(']');
            }
        }
        sb.append(']');
        return sb;
    }

    private StringBuffer appendParms(StringBuffer sb) {
        sb.append("PARAMETERS=[");
        for (int i = 0; i < this.parameters.length; ++i) {
            sb.append('\n').append('@').append(i).append('[').append(this.parameters[i].describe(null, 0)).append(']');
        }
        sb.append(']');
        return sb;
    }

    private StringBuffer appendCondition(Session session, StringBuffer sb) {
        return this.condition == null ? sb.append("CONDITION[]\n") : sb.append("CONDITION[").append(this.condition.describe(session, 0)).append("]\n");
    }

    private void appendColumnsJson(Map<String, Object> map, int[] columnMap) {
        if (columnMap == null || this.updateExpressions.length == 0) {
            return;
        }
        ArrayList columnsExplained = new ArrayList();
        for (int i = 0; i < columnMap.length; ++i) {
            HashMap<String, Object> columnExplained = new HashMap<String, Object>();
            columnExplained.put("columnIndex", columnMap[i]);
            columnExplained.put("targetColumnName", this.targetTable.getColumn(columnMap[i]).getNameString());
        }
        map.put("columns", columnsExplained);
        ArrayList<String> updateExpressionsExplained = new ArrayList<String>();
        for (int i = 0; i < this.updateExpressions.length; ++i) {
            updateExpressionsExplained.add(this.updateExpressions[i].toString());
        }
        map.put("updateExpressions", updateExpressionsExplained);
    }

    private void appendTableJson(Map<String, Object> map) {
        map.put("tableName", this.targetTable.getObjectName().name);
    }

    private void appendMultiColumnsJson(Map<String, Object> map, int[] columnMap) {
        if (columnMap == null || this.multiColumnValues == null) {
            return;
        }
        ArrayList columnsExplained = new ArrayList();
        for (int j = 0; j < this.multiColumnValues.length; ++j) {
            HashMap<String, Object> columnExplained = new HashMap<String, Object>();
            for (int i = 0; i < columnMap.length; ++i) {
                columnExplained.put("columnIndex", columnMap[i]);
                columnExplained.put("targetColumnName", this.targetTable.getColumn((int)columnMap[i]).getObjectName().name);
                columnExplained.put("targetColumn", this.multiColumnValues[j][i] != null ? this.multiColumnValues[j][i].toString() : null);
            }
        }
        map.put("columns", columnsExplained);
    }

    private void appendSubqueriesJson(Session session, Map<String, Object> map) {
        ArrayList subqueriesExplained = new ArrayList();
        for (int i = 0; i < this.subqueries.length; ++i) {
            HashMap<String, Object> subqueryExplained = new HashMap<String, Object>();
            subqueryExplained.put("level", this.subqueries[i].level);
            if (this.subqueries[i].queryExpression == null) {
                subqueryExplained.put("valueExpression", true);
                continue;
            }
            subqueryExplained.put("queryExpression", this.subqueries[i].queryExpression.describeJson(session));
        }
        map.put("subqueries", subqueriesExplained);
    }

    private void appendParmsJson(Map<String, Object> map) {
        ArrayList<Map<String, Object>> parametersExplained = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < this.parameters.length; ++i) {
            parametersExplained.add(this.parameters[i].describeJson(null));
        }
        map.put("parameters", parametersExplained);
    }

    private void appendConditionJson(Session session, Map<String, Object> map) {
        map.put("condition", this.condition != null ? this.condition.describeJson(session) : null);
    }

    @Override
    public void resolve(Session session) {
    }

    @Override
    public RangeVariable[] getRangeVariables() {
        return this.rangeVariables;
    }

    @Override
    public final boolean isCatalogLock() {
        return false;
    }

    @Override
    public boolean isCatalogChange() {
        return false;
    }
}

