/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.statement;

import com.streamscape.Trace;
import com.streamscape.cli.ds.CollectionType;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.SqlInvariants;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.store.BaseHashMap;
import com.streamscape.ds.navigator.RangeIterator;
import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.navigator.RowSetNavigatorClient;
import com.streamscape.ds.navigator.RowSetNavigatorDataChange;
import com.streamscape.ds.navigator.RowSetNavigatorDataChangeMemory;
import com.streamscape.ds.parser.ParserDML;
import com.streamscape.ds.parser.ParserDQL;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionArithmetic;
import com.streamscape.ds.parser.expression.ExpressionArrayAccessor;
import com.streamscape.ds.parser.expression.QuerySpecification;
import com.streamscape.ds.parser.statement.RejectException;
import com.streamscape.ds.parser.statement.StatementDMQL;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultMetaData;
import com.streamscape.ds.schema.collection.fspace.directory.DirectoryTableCollection;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.constraint.Constraint;
import com.streamscape.ds.schema.procedure.AbstractLazyFlobFunctionExpression;
import com.streamscape.ds.schema.procedure.AppendValueToDirectoryTableExpression;
import com.streamscape.ds.schema.procedure.FunctionCustom;
import com.streamscape.ds.schema.table.FileTable;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.TableDerived;
import com.streamscape.ds.schema.table.VirtualTable;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.Trigger;
import com.streamscape.ds.trigger.TriggerDef;
import com.streamscape.ds.types.FacetsUtils;
import com.streamscape.ds.types.FlobData;
import com.streamscape.ds.types.FlobType;
import com.streamscape.ds.types.Type;
import com.streamscape.lib.utils.Pair;
import com.streamscape.tools.lexer.CommonTokenType;
import com.streamscape.tools.lexer.LexerException;
import com.streamscape.tools.lexer.LexerFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class StatementDML
extends StatementDMQL {
    Expression[] targets;
    Expression updatableTableCheck;
    RangeVariable checkRangeVariable;
    boolean isTruncate;
    boolean isPurge = false;
    boolean isSimpleInsert;
    int generatedType;
    ResultMetaData generatedInputMetaData;
    int[] generatedIndexes;
    ResultMetaData generatedResultMetaData;
    int numberOfRowsToPurge;
    boolean purgeFirst;

    public StatementDML(int type, int group, NameManager.ObjectName schemaName) {
        super(type, group, schemaName);
    }

    public StatementDML(Session session, Table targetTable, RangeVariable[] rangeVars, ParserDQL.CompileContext compileContext, boolean restartIdentity, int type) {
        super(19, 2004, session.getCurrentDataspaceName());
        this.targetTable = targetTable;
        this.baseTable = targetTable.getBaseTable() == null ? targetTable : targetTable.getBaseTable();
        this.targetRangeVariables = rangeVars;
        this.restartIdentity = restartIdentity;
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
        if (type == 1205) {
            this.isTruncate = true;
        }
        this.targetRangeVariables[0].addAllColumns();
    }

    public StatementDML(Session session, Table targetTable, RangeVariable[] rangeVars, ParserDQL.CompileContext compileContext, boolean restartIdentity, int type, int numberOfRowsToPurge, boolean purgeFirst) {
        super(19, 2004, session.getCurrentDataspaceName());
        this.isPurge = true;
        this.targetTable = targetTable;
        this.baseTable = targetTable.getBaseTable() == null ? targetTable : targetTable.getBaseTable();
        this.targetRangeVariables = rangeVars;
        this.restartIdentity = restartIdentity;
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
        this.targetRangeVariables[0].addAllColumns();
        this.numberOfRowsToPurge = numberOfRowsToPurge;
        this.purgeFirst = purgeFirst;
    }

    public StatementDML(Session session, Expression[] targets, Table targetTable, RangeVariable[] rangeVars, int[] updateColumnMap, Expression[] colExpressions, boolean[] checkColumns, ParserDQL.CompileContext compileContext) {
        super(82, 2004, session.getCurrentDataspaceName());
        this.targets = targets;
        this.targetTable = targetTable;
        this.baseTable = targetTable.getBaseTable() == null ? targetTable : targetTable.getBaseTable();
        this.updateColumnMap = updateColumnMap;
        this.updateExpressions = colExpressions;
        this.updateCheckColumns = checkColumns;
        this.targetRangeVariables = rangeVars;
        this.setupChecks();
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
        this.targetRangeVariables[0].addAllColumns();
    }

    public StatementDML(Session session, Expression[] targets, RangeVariable[] targetRangeVars, int[] insertColMap, int[] updateColMap, boolean[] checkColumns, Expression mergeCondition, Expression insertExpr, Expression[] updateExpr, ParserDQL.CompileContext compileContext) {
        super(128, 2004, session.getCurrentDataspaceName());
        this.targets = targets;
        this.sourceTable = targetRangeVars[0].rangeTable;
        this.targetTable = targetRangeVars[1].rangeTable;
        this.baseTable = this.targetTable.isTriggerUpdatable() ? this.targetTable : this.targetTable.getBaseTable();
        this.insertCheckColumns = checkColumns;
        this.insertColumnMap = insertColMap;
        this.updateColumnMap = updateColMap;
        this.insertExpression = insertExpr;
        this.updateExpressions = updateExpr;
        this.targetRangeVariables = targetRangeVars;
        this.condition = mergeCondition;
        this.setupChecks();
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
    }

    StatementDML() {
        super(81, 2004, null);
    }

    void setupChecks() {
        if (this.targetTable != this.baseTable) {
            QuerySpecification select = this.targetTable.getQueryExpression().getMainSelect();
            this.updatableTableCheck = select.checkQueryCondition;
            this.checkRangeVariable = select.rangeVariables[select.rangeVariables.length - 1];
        }
    }

    @Override
    Result getResult(Session session) {
        Result result = null;
        if (this.baseTable instanceof FileTable) {
            ((FileTable)this.baseTable).checkOperation(this.generatedType);
        }
        switch (this.type) {
            case 82: {
                result = this.executeUpdateStatement(session);
                break;
            }
            case 128: {
                result = this.executeMergeStatement(session);
                break;
            }
            case 19: {
                if (this.isPurge) {
                    result = this.executePurgeFirstLastStatement(session, this.purgeFirst, this.numberOfRowsToPurge);
                    break;
                }
                if (this.isTruncate) {
                    result = this.executeDeleteTruncateStatement(session);
                    break;
                }
                result = this.executeDeleteStatement(session);
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementDML");
            }
        }
        session.sessionContext.diagnosticsVariables[2] = result.getUpdateCount();
        return result;
    }

    @Override
    void collectTableNamesForRead(OrderedHashSet set) {
        int i;
        if (this.baseTable.isView()) {
            this.getTriggerTableNames(set, false);
        } else if (!this.baseTable.isTemp()) {
            block5: for (i = 0; i < this.baseTable.fkConstraints.length; ++i) {
                Constraint constraint = this.baseTable.fkConstraints[i];
                switch (this.type) {
                    case 82: {
                        if (!ArrayUtil.haveCommonElement(constraint.getRefColumns(), this.updateColumnMap)) continue block5;
                        set.add(this.baseTable.fkConstraints[i].getMain().getObjectName());
                        continue block5;
                    }
                    case 50: {
                        set.add(this.baseTable.fkConstraints[i].getMain().getObjectName());
                        continue block5;
                    }
                    case 128: {
                        if (this.updateColumnMap != null && ArrayUtil.haveCommonElement(constraint.getRefColumns(), this.updateColumnMap)) {
                            set.add(this.baseTable.fkConstraints[i].getMain().getObjectName());
                        }
                        if (this.insertExpression == null) continue block5;
                        set.add(this.baseTable.fkConstraints[i].getMain().getObjectName());
                    }
                }
            }
            if (this.type == 82 || this.type == 128) {
                this.baseTable.collectFKReadLocks(this.updateColumnMap, set);
            } else if (this.type == 19) {
                this.baseTable.collectFKReadLocks(null, set);
            }
            this.getTriggerTableNames(set, false);
        }
        for (i = 0; i < this.rangeVariables.length; ++i) {
            Table rangeTable = this.rangeVariables[i].rangeTable;
            NameManager.ObjectName name = rangeTable.getObjectName();
            if (rangeTable.isReadOnly() || rangeTable.isTemp() || name.schema == SqlInvariants.SYSTEM_SCHEMA_NAME) continue;
            set.add(name);
        }
        for (i = 0; i < this.subqueries.length; ++i) {
            if (this.subqueries[i].queryExpression == null) continue;
            this.subqueries[i].queryExpression.getBaseTableNames(set);
        }
        for (i = 0; i < this.routines.length; ++i) {
            set.addAll(this.routines[i].getTableNamesForRead());
        }
    }

    @Override
    void collectTableNamesForWrite(OrderedHashSet set) {
        if (this.baseTable.isView()) {
            this.getTriggerTableNames(set, true);
        } else if (!this.baseTable.isTemp()) {
            set.add(this.baseTable.getObjectName());
            if (this.type == 82 || this.type == 128) {
                if (this.updateExpressions.length != 0) {
                    this.baseTable.collectFKWriteLocks(this.updateColumnMap, set);
                }
            } else if (this.type == 19) {
                this.baseTable.collectFKWriteLocks(null, set);
            }
            this.getTriggerTableNames(set, true);
        }
    }

    @Override
    public void setGeneratedColumnInfo(int generate, ResultMetaData meta) {
        if (this.type != 50) {
            return;
        }
        int idColIndex = this.baseTable.getIdentityColumnIndex();
        this.generatedType = generate;
        this.generatedInputMetaData = meta;
        switch (generate) {
            case 2: {
                return;
            }
            case 21: {
                this.generatedIndexes = meta.getGeneratedColumnIndexes();
                for (int i = 0; i < this.generatedIndexes.length; ++i) {
                    if (this.generatedIndexes[i] >= 0 && this.generatedIndexes[i] < this.baseTable.getColumnCount()) continue;
                    throw Error.error(5501);
                }
                break;
            }
            case 1: {
                int i;
                if (this.baseTable.hasGeneratedColumn()) {
                    if (idColIndex >= 0) {
                        int generatedCount = ArrayUtil.countTrueElements(this.baseTable.colGenerated) + 1;
                        this.generatedIndexes = new int[generatedCount];
                        int j = 0;
                        for (i = 0; i < this.baseTable.colGenerated.length; ++i) {
                            if (!this.baseTable.colGenerated[i] && i != idColIndex) continue;
                            this.generatedIndexes[j++] = i;
                        }
                        break;
                    }
                    this.generatedIndexes = ArrayUtil.booleanArrayToIntIndexes(this.baseTable.colGenerated);
                    break;
                }
                if (idColIndex >= 0) {
                    this.generatedIndexes = new int[]{idColIndex};
                    break;
                }
                return;
            }
            case 11: {
                int i;
                String[] columnNames = meta.getGeneratedColumnNames();
                this.generatedIndexes = this.baseTable.getColumnIndexes(columnNames);
                for (i = 0; i < this.generatedIndexes.length; ++i) {
                    if (this.generatedIndexes[i] >= 0) continue;
                    throw Error.error(5501, columnNames[0]);
                }
                break;
            }
        }
        this.generatedResultMetaData = ResultMetaData.newResultMetaData(this.generatedIndexes.length);
        for (int i = 0; i < this.generatedIndexes.length; ++i) {
            ColumnSchema column = this.baseTable.getColumn(this.generatedIndexes[i]);
            this.generatedResultMetaData.columns[i] = column;
        }
        this.generatedResultMetaData.prepareData();
        this.isSimpleInsert = false;
    }

    Object[] getGeneratedColumns(Object[] data) {
        if (this.generatedIndexes == null) {
            return null;
        }
        Object[] values = new Object[this.generatedIndexes.length];
        for (int i = 0; i < this.generatedIndexes.length; ++i) {
            values[i] = data[this.generatedIndexes[i]];
        }
        return values;
    }

    @Override
    public boolean hasGeneratedColumns() {
        return this.generatedIndexes != null;
    }

    @Override
    public ResultMetaData generatedResultMetaData() {
        return this.generatedResultMetaData;
    }

    void getTriggerTableNames(OrderedHashSet set, boolean write) {
        block9: for (TriggerDef td : this.baseTable.triggerList) {
            switch (this.type) {
                case 50: {
                    if (td.getStatementType() != 50) continue block9;
                    break;
                }
                case 3001: {
                    if (td.getStatementType() != 3001) continue block9;
                    break;
                }
                case 3031: {
                    if (td.getStatementType() != 3031) continue block9;
                    break;
                }
                case 82: {
                    if (td.getStatementType() != 82) continue block9;
                    break;
                }
                case 19: {
                    if (td.getStatementType() != 19) continue block9;
                    break;
                }
                case 3032: {
                    if (td.getStatementType() != 3032) continue block9;
                    break;
                }
                case 128: {
                    if (td.getStatementType() != 50 && td.getStatementType() != 82) continue block9;
                    break;
                }
                default: {
                    throw Error.runtimeError(201, "StatementDML");
                }
            }
            if (td.routine == null) continue;
            if (write) {
                set.addAll(td.routine.getTableNamesForWrite());
                continue;
            }
            set.addAll(td.routine.getTableNamesForRead());
        }
    }

    Result executeUpdateStatement(Session session) {
        if (this.baseTable instanceof VirtualTable) {
            if (((VirtualTable)this.baseTable).getCollectionType() == CollectionType.DIRECTORY_TABLE) {
                ((VirtualTable)this.baseTable).materialize(session);
            } else {
                if (session.sessionContext.dynamicArguments != null && session.sessionContext.dynamicArguments.length > 0) {
                    Pair<Object[], int[]> virtualTableDynamicParams = this.getDynamicParamsForVirtualTable(session);
                    return ((VirtualTable)this.baseTable).executeExternalUpdate(session, this.sql, (Object[])virtualTableDynamicParams.first, (int[])virtualTableDynamicParams.second);
                }
                Object[] params = this.getParametersFromVirtualTableStatement(session);
                return ((VirtualTable)this.baseTable).executeExternalUpdate(session, (String)params[0], (Object[])params[1], (int[])params[2]);
            }
        }
        int count = 0;
        Expression[] colExpressions = this.updateExpressions;
        RowSetNavigatorDataChange rowset = session.sessionContext.getRowSetDataChange();
        Type[] colTypes = this.baseTable.getColumnTypes();
        RangeIterator it = RangeVariable.getIterator(session, this.targetRangeVariables);
        Result resultOut = null;
        RowSetNavigator generatedNavigator = null;
        if (this.generatedIndexes != null) {
            resultOut = Result.newUpdateCountResult(this.generatedResultMetaData, 0);
            generatedNavigator = resultOut.getChainedResult().getNavigator();
        }
        session.sessionContext.rownum = 1;
        while (it.next()) {
            Session.checkIfThreadIsInterrupted();
            session.sessionData.startRowProcessing();
            Row row = it.getCurrentRow();
            Object[] data = row.getData();
            Object[] newData = StatementDML.getUpdatedData(session, this.targets, this.baseTable, this.updateColumnMap, colExpressions, colTypes, data);
            if (this.updatableTableCheck != null) {
                it.setCurrent(newData);
                boolean check = this.updatableTableCheck.testCondition(session);
                if (!check) {
                    it.release();
                    throw Error.error(5700);
                }
            }
            rowset.addRow(session, row, newData, colTypes, this.updateColumnMap);
            ++session.sessionContext.rownum;
        }
        rowset.endMainDataSet();
        it.release();
        rowset.beforeFirst();
        count = this.update(session, this.baseTable, rowset, generatedNavigator);
        if (resultOut == null) {
            if (count == 1) {
                return Result.updateOneResult;
            }
            if (count == 0) {
                return Result.updateZeroResult;
            }
            return new Result(1, count);
        }
        resultOut.setUpdateCount(count);
        if (count == 0) {
            session.addWarning(DataspaceException.noDataCondition);
        }
        return resultOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object[] getUpdatedData(Session session, Expression[] targets, Table targetTable, int[] columnMap, Expression[] colExpressions, Type[] colTypes, Object[] oldData) {
        Object[] data = targetTable.getEmptyRowData();
        System.arraycopy(oldData, 0, data, 0, data.length);
        int i = 0;
        int ix = 0;
        while (i < columnMap.length) {
            Expression expr;
            if ((expr = colExpressions[ix++]).getType() == 25) {
                Object[] values = expr.getRowValue(session);
                int j = 0;
                while (j < values.length) {
                    int colIndex = columnMap[i];
                    Expression e = expr.nodes[j];
                    if (targetTable.identityColumn != colIndex || e.getType() != 1 || e.valueData != null) {
                        if (e.getType() == 4) {
                            if (targetTable.identityColumn != colIndex) {
                                data[colIndex] = targetTable.colDefaults[colIndex].getValue(session);
                            }
                        } else {
                            data[colIndex] = colTypes[colIndex].convertToType(session, values[j], e.dataType);
                        }
                    }
                    ++j;
                    ++i;
                }
                continue;
            }
            if (expr.getType() == 22) {
                Object[] values = expr.getRowValue(session);
                int j = 0;
                while (j < values.length) {
                    int colIndex = columnMap[i];
                    Type colType = expr.subQuery.queryExpression.getMetaData().columnTypes[j];
                    data[colIndex] = colTypes[colIndex].convertToType(session, values[j], colType);
                    ++j;
                    ++i;
                }
                continue;
            }
            int colIndex = columnMap[i];
            if (expr.getType() == 4) {
                if (targetTable.identityColumn == colIndex) {
                    ++i;
                    continue;
                }
                data[colIndex] = targetTable.colDefaults[colIndex].getValue(session);
                ++i;
                continue;
            }
            Object value = null;
            if (DirectoryTableCollection.isDataColumn(targetTable, colIndex) && expr instanceof ExpressionArithmetic) {
                String error = "Only expression like Data = Data + {string | lob | readFile} allowed on Data column.";
                if (expr.nodes.length != 2) {
                    throw new DataspaceException(error);
                }
                Object node0Value = expr.nodes[0].getValue(session);
                if ("[File Data]" != node0Value) {
                    throw new DataspaceException(error);
                }
                if (expr.nodes[1] instanceof FunctionCustom && (((FunctionCustom)expr.nodes[1]).funcType == 106 || ((FunctionCustom)expr.nodes[1]).funcType == 231)) {
                    ParserDML.resolveFlobExpression(session, expr.nodes[1], new FlobType());
                }
                value = expr.nodes[1].getValue(session);
                value = new AppendValueToDirectoryTableExpression(value);
            } else {
                FacetsUtils.setUpdateStatementLevel1(true);
                try {
                    value = expr.getValue(session);
                }
                finally {
                    FacetsUtils.setUpdateStatementLevel1(false);
                }
                value = StatementDML.getFlobLazyData(session, value, expr.getDataType(), colTypes[colIndex]);
            }
            data[colIndex] = targets[i].getType() == 99 ? ((ExpressionArrayAccessor)targets[i]).updateArrayValue(session, data[colIndex], value, true, true) : colTypes[colIndex].convertToType(session, value, expr.dataType);
            ++i;
        }
        return data;
    }

    Result executeMergeStatement(Session session) {
        int i;
        Type[] colTypes = this.baseTable.getColumnTypes();
        Result resultOut = null;
        RowSetNavigator generatedNavigator = null;
        if (this.generatedIndexes != null) {
            resultOut = Result.newUpdateCountResult(this.generatedResultMetaData, 0);
            generatedNavigator = resultOut.getChainedResult().getNavigator();
        }
        int count = 0;
        RowSetNavigatorClient newData = new RowSetNavigatorClient(8);
        RowSetNavigatorDataChange updateRowSet = session.sessionContext.getRowSetDataChange();
        RangeVariable[] joinRangeIterators = this.targetRangeVariables;
        RangeIterator[] rangeIterators = new RangeIterator[joinRangeIterators.length];
        for (i = 0; i < joinRangeIterators.length; ++i) {
            rangeIterators[i] = joinRangeIterators[i].getIterator(session);
        }
        int currentIndex = 0;
        while (currentIndex >= 0) {
            RangeIterator it = rangeIterators[currentIndex];
            boolean beforeFirst = it.isBeforeFirst();
            if (it.next()) {
                if (currentIndex < joinRangeIterators.length - 1) {
                    ++currentIndex;
                    continue;
                }
            } else {
                Object[] data;
                if (currentIndex == 1 && beforeFirst && this.insertExpression != null && (data = this.getInsertData(session, colTypes, this.insertExpression.nodes[0].nodes)) != null) {
                    newData.add(data);
                }
                it.reset();
                --currentIndex;
                continue;
            }
            if (this.updateExpressions.length == 0) continue;
            Row row = it.getCurrentRow();
            session.sessionData.startRowProcessing();
            Object[] data = StatementDML.getUpdatedData(session, this.targets, this.baseTable, this.updateColumnMap, this.updateExpressions, colTypes, row.getData());
            try {
                updateRowSet.addRow(session, row, data, colTypes, this.updateColumnMap);
            }
            catch (DataspaceException e) {
                for (int i2 = 0; i2 < joinRangeIterators.length; ++i2) {
                    rangeIterators[i2].reset();
                }
                throw Error.error(3201, new Object[]{this.getSQL()});
            }
        }
        updateRowSet.endMainDataSet();
        for (i = 0; i < joinRangeIterators.length; ++i) {
            rangeIterators[i].reset();
        }
        if (this.updateExpressions.length != 0) {
            count = this.update(session, this.baseTable, updateRowSet, generatedNavigator);
        }
        if (newData.getSize() > 0) {
            this.insertRowSet(session, generatedNavigator, newData);
            count += newData.getSize();
        }
        if (this.insertExpression != null && this.baseTable.triggerLists[Trigger.Type.INSERT_AFTER.ordinal()].length > 0) {
            this.baseTable.fireTriggers(session, Trigger.Type.INSERT_AFTER, newData);
        }
        if (resultOut == null) {
            if (count == 1) {
                return Result.updateOneResult;
            }
            if (count == 0) {
                session.addWarning(DataspaceException.noDataCondition);
                return Result.updateZeroResult;
            }
            return new Result(1, count);
        }
        resultOut.setUpdateCount(count);
        if (count == 0) {
            session.addWarning(DataspaceException.noDataCondition);
        }
        return resultOut;
    }

    int insertRowSet(Session session, RowSetNavigator generatedNavigator, RowSetNavigator newData) {
        Object[] data;
        PersistentStore store = this.baseTable.getRowStore(session);
        RangeVariable.RangeIteratorMain checkIterator = null;
        if (this.updatableTableCheck != null) {
            checkIterator = this.checkRangeVariable.getIterator(session);
        }
        newData.beforeFirst();
        if (this.baseTable.triggerLists[Trigger.Type.INSERT_BEFORE_ROW.ordinal()].length > 0) {
            while (newData.hasNext()) {
                data = newData.getNext();
                try {
                    this.baseTable.fireTriggers(session, Trigger.Type.INSERT_BEFORE_ROW, null, data, null);
                }
                catch (RejectException excetption) {
                    newData.markCurrentRowAsRejected();
                }
            }
            newData.beforeFirst();
        }
        while (newData.hasNext()) {
            Session.checkIfThreadIsInterrupted();
            data = newData.getNext();
            session.sessionData.startRowProcessing();
            this.baseTable.insertSingleRow(session, store, data, null);
            if (checkIterator != null) {
                checkIterator.setCurrent(data);
                boolean check = this.updatableTableCheck.testCondition(session);
                if (!check) {
                    throw Error.error(5700);
                }
            }
            if (generatedNavigator == null) continue;
            Object[] generatedValues = this.getGeneratedColumns(data);
            generatedNavigator.add(generatedValues);
        }
        newData.beforeFirst();
        while (newData.hasNext()) {
            data = newData.getNext();
            StatementDML.performIntegrityChecks(session, this.baseTable, null, data, null);
        }
        newData.beforeFirst();
        if (this.baseTable.triggerLists[Trigger.Type.INSERT_AFTER_ROW.ordinal()].length > 0) {
            while (newData.hasNext()) {
                Session.checkIfThreadIsInterrupted();
                data = newData.getNext();
                this.baseTable.fireTriggers(session, Trigger.Type.INSERT_AFTER_ROW, null, data, null);
            }
            newData.beforeFirst();
        }
        if (this.baseTable.triggerLists[Trigger.Type.CHANGE_AFTER_ROW.ordinal()].length > 0) {
            while (newData.hasNext()) {
                data = newData.getNext();
                this.baseTable.fireTriggers(session, Trigger.Type.CHANGE_AFTER_ROW, null, data, null);
            }
            newData.beforeFirst();
        }
        if (!this.isTransactionStatement()) {
            this.baseTable.dfetchMonitor.rowsInserted(session, newData);
        }
        newData.reset();
        return newData.getSize();
    }

    Result insertSingleRow(Session session, PersistentStore store, Object[] data) {
        if (this.baseTable.triggerLists[Trigger.Type.INSERT_BEFORE_ROW.ordinal()].length > 0) {
            try {
                this.baseTable.fireTriggers(session, Trigger.Type.INSERT_BEFORE_ROW, null, data, null);
            }
            catch (RejectException exception) {
                return Result.updateZeroResult;
            }
        }
        this.baseTable.insertSingleRow(session, store, data, null);
        StatementDML.performIntegrityChecks(session, this.baseTable, null, data, null);
        if (session.dataspaceStore.isReferentialIntegrity()) {
            int size = this.baseTable.fkConstraints.length;
            for (int i = 0; i < size; ++i) {
                this.baseTable.fkConstraints[i].checkInsert(session, this.baseTable, data, true);
            }
        }
        if (this.baseTable.triggerLists[Trigger.Type.INSERT_AFTER_ROW.ordinal()].length > 0) {
            this.baseTable.fireTriggers(session, Trigger.Type.INSERT_AFTER_ROW, null, data, null);
        }
        if (this.baseTable.triggerLists[Trigger.Type.CHANGE_AFTER_ROW.ordinal()].length > 0) {
            this.baseTable.fireTriggers(session, Trigger.Type.CHANGE_AFTER_ROW, null, data, null);
        }
        if (this.baseTable.triggerLists[Trigger.Type.INSERT_AFTER.ordinal()].length > 0) {
            this.baseTable.fireTriggers(session, Trigger.Type.INSERT_AFTER, (RowSetNavigator)null);
        }
        if (!this.isTransactionStatement()) {
            this.baseTable.dfetchMonitor.rowInserted(session, data);
        }
        return Result.updateOneResult;
    }

    private void notifyCollectionDeleted(Session session, boolean all) {
    }

    Object[] getInsertData(Session session, Type[] colTypes, Expression[] rowArgs) {
        Object[] data = this.baseTable.getNewRowData(session);
        session.sessionData.startRowProcessing();
        for (int i = 0; i < rowArgs.length; ++i) {
            Expression e = rowArgs[i];
            int colIndex = this.insertColumnMap[i];
            if (e.opType == 4) {
                if (this.baseTable.identityColumn == colIndex || this.baseTable.colDefaults[colIndex] == null) continue;
                data[colIndex] = this.baseTable.colDefaults[colIndex].getValue(session);
                continue;
            }
            Object value = e.getValue(session);
            Type type = colTypes[colIndex];
            value = StatementDML.getFlobLazyData(session, value, e.dataType, type);
            if (e.getType() == 8) {
                value = e.dataType.convertToDefaultType(session, value);
            }
            if (colTypes[colIndex] != e.dataType) {
                value = type.convertToType(session, value, e.dataType);
            }
            data[colIndex] = value;
        }
        return data;
    }

    private static Object getFlobLazyData(Session session, Object value, Type valueType, Type columnType) {
        if (columnType instanceof FlobType) {
            if (value instanceof AbstractLazyFlobFunctionExpression) {
                value = ((AbstractLazyFlobFunctionExpression)value).getValue(session, columnType);
            } else if (value instanceof FlobData && valueType instanceof FlobType && ((FlobType)valueType).isVariable()) {
                session.dataspaceStore.flobManager.adjustUsageCount(session, ((FlobData)value).getId(), 1);
                ((FlobType)valueType).setAutotag(((FlobType)columnType).getAutotag());
                ((FlobType)valueType).setLocation(((FlobType)columnType).getLocation());
                ((FlobType)valueType).setCharset(((FlobType)columnType).getCharset());
            }
        }
        return value;
    }

    int update(Session session, Table table, RowSetNavigatorDataChange navigator, RowSetNavigator generatedNavigator) {
        Row row;
        boolean hasAfterRowTriggers;
        Table currentTable;
        int[] changedColumns;
        Object[] data;
        int rowCount = navigator.getSize();
        for (int i = 0; i < rowCount; ++i) {
            Session.checkIfThreadIsInterrupted();
            navigator.next();
            Object[] data2 = navigator.getCurrentChangedData();
            session.sessionData.startRowProcessing();
            table.setIdentityColumn(session, data2);
            table.setGeneratedColumns(session, data2);
        }
        navigator.beforeFirst();
        if (table.fkMainConstraints.length > 0) {
            com.streamscape.ds.lib.HashSet path = session.sessionContext.getConstraintPath();
            for (int i = 0; i < rowCount; ++i) {
                Session.checkIfThreadIsInterrupted();
                navigator.next();
                Row row2 = navigator.getCurrentRow();
                Object[] data3 = navigator.getCurrentChangedData();
                StatementDML.performReferentialActions(session, table, navigator, row2, data3, this.updateColumnMap, path);
                path.clear();
            }
            navigator.beforeFirst();
        }
        HashSet<Row> rejectedRows = new HashSet<Row>();
        while (navigator.next()) {
            Session.checkIfThreadIsInterrupted();
            Row row3 = navigator.getCurrentRow();
            data = navigator.getCurrentChangedData();
            changedColumns = navigator.getCurrentChangedColumns();
            currentTable = (Table)row3.getTable();
            if (currentTable instanceof TableDerived) {
                currentTable = ((TableDerived)currentTable).view;
            }
            if (currentTable.triggerLists[Trigger.Type.UPDATE_BEFORE_ROW.ordinal()].length <= 0) continue;
            try {
                currentTable.fireTriggers(session, Trigger.Type.UPDATE_BEFORE_ROW, row3.getData(), data, changedColumns);
                currentTable.enforceRowConstraints(session, data);
            }
            catch (RejectException exception) {
                rejectedRows.add(row3);
            }
        }
        rowCount = (navigator = this.createNewNavigatorWithoutRejectedRows(navigator, session, rejectedRows)).getSize();
        if (rowCount == 0) {
            return 0;
        }
        if (table.isView) {
            return rowCount;
        }
        navigator.beforeFirst();
        if (table instanceof VirtualTable && ((VirtualTable)table).helper instanceof DirectoryTableCollection) {
            while (navigator.next()) {
                Session.checkIfThreadIsInterrupted();
                Row row4 = navigator.getCurrentRow();
                Object[] changedData = navigator.getCurrentChangedData();
                changedColumns = navigator.getCurrentChangedColumns();
                ((DirectoryTableCollection)((VirtualTable)table).helper).updateDirectoryTable(session, row4, changedData, changedColumns);
            }
        } else {
            while (navigator.next()) {
                Session.checkIfThreadIsInterrupted();
                Row row5 = navigator.getCurrentRow();
                Table currentTable2 = (Table)row5.getTable();
                changedColumns = navigator.getCurrentChangedColumns();
                session.addDeleteActionForUpdate(currentTable2, row5, changedColumns);
            }
            navigator.beforeFirst();
            while (navigator.next()) {
                Session.checkIfThreadIsInterrupted();
                Row row6 = navigator.getCurrentRow();
                data = navigator.getCurrentChangedData();
                Table currentTable3 = (Table)row6.getTable();
                int[] changedColumns2 = navigator.getCurrentChangedColumns();
                PersistentStore store = currentTable3.getRowStore(session);
                if (data == null) continue;
                Row newRow = currentTable3.insertSingleRowForUpdate(session, store, data, changedColumns2);
                if (generatedNavigator == null) continue;
                Object[] generatedValues = this.getGeneratedColumns(data);
                generatedNavigator.add(generatedValues);
            }
        }
        navigator.beforeFirst();
        BaseHashMap extraUpdateTables = null;
        boolean bl = hasAfterRowTriggers = table.triggerLists[Trigger.Type.UPDATE_AFTER_ROW.ordinal()].length > 0 || table.triggerLists[Trigger.Type.CHANGE_AFTER_ROW.ordinal()].length > 0 || this.baseTable.getFullTextIndexes() != null;
        while (navigator.next()) {
            Session.checkIfThreadIsInterrupted();
            row = navigator.getCurrentRow();
            currentTable = (Table)row.getTable();
            Object[] changedData = navigator.getCurrentChangedData();
            int[] changedColumns3 = navigator.getCurrentChangedColumns();
            StatementDML.performIntegrityChecks(session, currentTable, row.getData(), changedData, changedColumns3);
            if (currentTable == table) continue;
            if (extraUpdateTables == null) {
                extraUpdateTables = new OrderedHashSet();
            }
            ((com.streamscape.ds.lib.HashSet)extraUpdateTables).add(currentTable);
            if (currentTable.triggerLists[Trigger.Type.UPDATE_AFTER_ROW.ordinal()].length <= 0 && currentTable.triggerLists[Trigger.Type.CHANGE_AFTER_ROW.ordinal()].length <= 0) continue;
            hasAfterRowTriggers = true;
        }
        navigator.beforeFirst();
        if (hasAfterRowTriggers) {
            while (navigator.next()) {
                Session.checkIfThreadIsInterrupted();
                row = navigator.getCurrentRow();
                Object[] changedData = navigator.getCurrentChangedData();
                int[] changedColumns4 = navigator.getCurrentChangedColumns();
                Table currentTable4 = (Table)row.getTable();
                currentTable4.fireTriggers(session, Trigger.Type.UPDATE_AFTER_ROW, row.getData(), changedData, changedColumns4);
                currentTable4.fireTriggers(session, Trigger.Type.CHANGE_AFTER_ROW, null, changedData, null);
            }
            navigator.beforeFirst();
        }
        this.baseTable.fireTriggers(session, Trigger.Type.UPDATE_AFTER, navigator);
        if (extraUpdateTables != null) {
            for (int i = 0; i < extraUpdateTables.size(); ++i) {
                currentTable = (Table)((OrderedHashSet)extraUpdateTables).get(i);
                currentTable.fireTriggers(session, Trigger.Type.UPDATE_AFTER, navigator);
            }
        }
        if (!this.isTransactionStatement()) {
            this.baseTable.dfetchMonitor.rowsInserted(session, navigator);
        }
        return rowCount;
    }

    Result executeDeleteStatement(Session session) {
        if (this.baseTable instanceof VirtualTable) {
            if (((VirtualTable)this.baseTable).getCollectionType() == CollectionType.DIRECTORY_TABLE) {
                ((VirtualTable)this.baseTable).materialize(session);
            } else {
                if (session.sessionContext.dynamicArguments != null && session.sessionContext.dynamicArguments.length > 0) {
                    Pair<Object[], int[]> virtualTableDynamicParams = this.getDynamicParamsForVirtualTable(session);
                    return ((VirtualTable)this.baseTable).executeExternalUpdate(session, this.sql, (Object[])virtualTableDynamicParams.first, (int[])virtualTableDynamicParams.second);
                }
                Object[] params = this.getParametersFromVirtualTableStatement(session);
                return ((VirtualTable)this.baseTable).executeExternalUpdate(session, (String)params[0], (Object[])params[1], (int[])params[2]);
            }
        }
        int count = 0;
        RangeIterator it = RangeVariable.getIterator(session, this.targetRangeVariables);
        RowSetNavigatorDataChange rowset = session.sessionContext.getRowSetDataChange();
        session.sessionContext.rownum = 1;
        while (it.next()) {
            Session.checkIfThreadIsInterrupted();
            Row currentRow = it.getCurrentRow();
            rowset.addRow(currentRow);
            ++session.sessionContext.rownum;
        }
        it.release();
        rowset.endMainDataSet();
        if (rowset.getSize() <= 0) {
            session.addWarning(DataspaceException.noDataCondition);
            return Result.updateZeroResult;
        }
        count = this.delete(session, this.baseTable, rowset);
        if (count == 1) {
            return Result.updateOneResult;
        }
        return new Result(1, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Result executeDeleteTruncateStatement(Session session) {
        PersistentStore store = this.targetTable.getRowStore(session);
        RowIterator it = this.targetTable.getPrimaryIndex().firstRow(store);
        boolean hasData = it.hasNext();
        try {
            while (it.hasNext()) {
                Row row = it.getNextRow();
                session.addDeleteAction((Table)row.getTable(), row, null);
            }
            if (this.restartIdentity && this.targetTable.identitySequence != null) {
                this.targetTable.identitySequence.reset();
            }
        }
        finally {
            it.release();
        }
        this.notifyCollectionDeleted(session, true);
        if (!hasData) {
            session.addWarning(DataspaceException.noDataCondition);
        }
        return Result.updateOneResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Result executePurgeFirstLastStatement(Session session, boolean first, int rowsToPurge) {
        PersistentStore store = this.targetTable.getRowStore(session);
        RowIterator it = this.targetTable.getPrimaryIndex().firstRow(store);
        boolean hasData = it.hasNext();
        int counter = -1;
        try {
            if (rowsToPurge != -1) {
                if (first) {
                    while (it.hasNext() && ++counter < rowsToPurge) {
                        Row row = it.getNextRow();
                        session.addDeleteAction((Table)row.getTable(), row, null);
                    }
                } else {
                    int skip = this.targetTable.getPrimaryIndex().size(session, store) - rowsToPurge;
                    while (it.hasNext() && ++counter < skip) {
                        it.getNextRow();
                    }
                    while (it.hasNext()) {
                        Row row = it.getNextRow();
                        session.addDeleteAction((Table)row.getTable(), row, null);
                    }
                }
            } else {
                while (it.hasNext()) {
                    Row row = it.getNextRow();
                    session.addDeleteAction((Table)row.getTable(), row, null);
                }
            }
        }
        finally {
            it.release();
        }
        this.notifyCollectionDeleted(session, true);
        if (!hasData) {
            session.addWarning(DataspaceException.noDataCondition);
        }
        return Result.updateOneResult;
    }

    int delete(Session session, Table table, RowSetNavigatorDataChange navigator) {
        Table currentTable;
        Object[] changedData;
        Row row;
        boolean hasAfterRowTriggers;
        Object[] data;
        Table currentTable2;
        Row row2;
        int rowCount = navigator.getSize();
        navigator.beforeFirst();
        if (table.fkMainConstraints.length > 0) {
            com.streamscape.ds.lib.HashSet path = session.sessionContext.getConstraintPath();
            for (int i = 0; i < rowCount; ++i) {
                Session.checkIfThreadIsInterrupted();
                navigator.next();
                row2 = navigator.getCurrentRow();
                StatementDML.performReferentialActions(session, table, navigator, row2, null, null, path);
                path.clear();
            }
            navigator.beforeFirst();
        }
        HashSet<Row> rejectedRows = new HashSet<Row>();
        while (navigator.next()) {
            Session.checkIfThreadIsInterrupted();
            Row row3 = navigator.getCurrentRow();
            Object[] changedData2 = navigator.getCurrentChangedData();
            int[] changedColumns = navigator.getCurrentChangedColumns();
            currentTable2 = (Table)row3.getTable();
            if (currentTable2 instanceof TableDerived) {
                currentTable2 = ((TableDerived)currentTable2).view;
            }
            try {
                if (changedData2 == null) {
                    currentTable2.fireTriggers(session, Trigger.Type.DELETE_BEFORE_ROW, row3.getData(), null, null);
                    continue;
                }
                currentTable2.fireTriggers(session, Trigger.Type.UPDATE_BEFORE_ROW, row3.getData(), changedData2, changedColumns);
            }
            catch (RejectException rejectException) {
                rejectedRows.add(row3);
            }
        }
        rowCount = (navigator = this.createNewNavigatorWithoutRejectedRows(navigator, session, rejectedRows)).getSize();
        if (rowCount == 0) {
            return 0;
        }
        if (table.isView) {
            return rowCount;
        }
        boolean hasUpdate = false;
        navigator.beforeFirst();
        if (table instanceof VirtualTable && ((VirtualTable)table).helper instanceof DirectoryTableCollection) {
            while (navigator.next()) {
                Session.checkIfThreadIsInterrupted();
                row2 = navigator.getCurrentRow();
                ((DirectoryTableCollection)((VirtualTable)table).helper).deleteFromDirectoryTable(session, row2);
            }
        } else {
            while (navigator.next()) {
                Session.checkIfThreadIsInterrupted();
                row2 = navigator.getCurrentRow();
                data = navigator.getCurrentChangedData();
                currentTable2 = (Table)row2.getTable();
                session.addDeleteAction(currentTable2, row2, null);
                if (data == null) continue;
                hasUpdate = true;
            }
        }
        navigator.beforeFirst();
        if (hasUpdate) {
            while (navigator.next()) {
                Session.checkIfThreadIsInterrupted();
                row2 = navigator.getCurrentRow();
                data = navigator.getCurrentChangedData();
                currentTable2 = (Table)row2.getTable();
                int[] changedColumns = navigator.getCurrentChangedColumns();
                PersistentStore store = currentTable2.getRowStore(session);
                if (data == null) continue;
                Row row4 = currentTable2.insertSingleRow(session, store, data, changedColumns);
            }
            navigator.beforeFirst();
        }
        BaseHashMap extraUpdateTables = null;
        BaseHashMap extraDeleteTables = null;
        boolean bl = hasAfterRowTriggers = table.triggerLists[Trigger.Type.DELETE_AFTER_ROW.ordinal()].length > 0 || table.triggerLists[Trigger.Type.CHANGE_AFTER_ROW.ordinal()].length > 0 || this.baseTable.getFullTextIndexes() != null;
        if (rowCount != navigator.getSize()) {
            navigator.beforeFirst();
            while (navigator.next()) {
                Session.checkIfThreadIsInterrupted();
                row = navigator.getCurrentRow();
                changedData = navigator.getCurrentChangedData();
                int[] changedColumns = navigator.getCurrentChangedColumns();
                Table currentTable3 = (Table)row.getTable();
                if (changedData != null) {
                    StatementDML.performIntegrityChecks(session, currentTable3, row.getData(), changedData, changedColumns);
                }
                if (currentTable3 == table) continue;
                if (changedData == null) {
                    if (currentTable3.triggerLists[Trigger.Type.DELETE_AFTER_ROW.ordinal()].length > 0 || currentTable3.triggerLists[Trigger.Type.CHANGE_AFTER_ROW.ordinal()].length > 0) {
                        hasAfterRowTriggers = true;
                    }
                    if (extraDeleteTables == null) {
                        extraDeleteTables = new OrderedHashSet();
                    }
                    ((com.streamscape.ds.lib.HashSet)extraDeleteTables).add(currentTable3);
                    continue;
                }
                if (currentTable3.triggerLists[Trigger.Type.UPDATE_AFTER_ROW.ordinal()].length > 0 || currentTable3.triggerLists[Trigger.Type.CHANGE_AFTER_ROW.ordinal()].length > 0) {
                    hasAfterRowTriggers = true;
                }
                if (extraUpdateTables == null) {
                    extraUpdateTables = new OrderedHashSet();
                }
                ((com.streamscape.ds.lib.HashSet)extraUpdateTables).add(currentTable3);
            }
            navigator.beforeFirst();
        }
        if (hasAfterRowTriggers) {
            navigator.beforeFirst();
            while (navigator.next()) {
                Session.checkIfThreadIsInterrupted();
                row = navigator.getCurrentRow();
                changedData = navigator.getCurrentChangedData();
                Table currentTable4 = (Table)row.getTable();
                if (changedData == null) {
                    currentTable4.fireTriggers(session, Trigger.Type.DELETE_AFTER_ROW, row.getData(), null, null);
                    currentTable4.fireTriggers(session, Trigger.Type.CHANGE_AFTER_ROW, null, row.getData(), null);
                    continue;
                }
                currentTable4.fireTriggers(session, Trigger.Type.UPDATE_AFTER_ROW, row.getData(), changedData, null);
                currentTable4.fireTriggers(session, Trigger.Type.CHANGE_AFTER_ROW, null, changedData, null);
            }
            navigator.beforeFirst();
        }
        this.notifyCollectionDeleted(session, true);
        table.fireTriggers(session, Trigger.Type.DELETE_AFTER, navigator);
        if (extraUpdateTables != null) {
            for (int i = 0; i < extraUpdateTables.size(); ++i) {
                currentTable = (Table)((OrderedHashSet)extraUpdateTables).get(i);
                currentTable.fireTriggers(session, Trigger.Type.UPDATE_AFTER, navigator);
            }
        }
        if (extraDeleteTables != null) {
            for (int i = 0; i < extraDeleteTables.size(); ++i) {
                currentTable = (Table)((OrderedHashSet)extraDeleteTables).get(i);
                currentTable.fireTriggers(session, Trigger.Type.DELETE_AFTER, navigator);
            }
        }
        return rowCount;
    }

    public static void performIntegrityChecks(Session session, Table table, Object[] oldData, Object[] newData, int[] updatedColumns) {
        int i;
        if (newData == null) {
            return;
        }
        int size = table.checkConstraints.length;
        for (i = 0; i < size; ++i) {
            table.checkConstraints[i].checkInsert(session, table, newData, oldData == null);
        }
        if (!session.dataspaceStore.isReferentialIntegrity()) {
            return;
        }
        size = table.fkConstraints.length;
        for (i = 0; i < size; ++i) {
            boolean check = oldData == null;
            Constraint c = table.fkConstraints[i];
            if (!check) {
                check = ArrayUtil.haveCommonElement(c.getRefColumns(), updatedColumns);
            }
            if (!check) continue;
            c.checkInsert(session, table, newData, oldData == null);
        }
    }

    static void performReferentialActions(Session session, Table table, RowSetNavigatorDataChange navigator, Row row, Object[] data, int[] changedCols, com.streamscape.ds.lib.HashSet path) {
        if (!session.dataspaceStore.isReferentialIntegrity()) {
            return;
        }
        boolean delete = data == null;
        for (Constraint c : table.fkMainConstraints) {
            int action;
            int n = action = delete ? c.core.deleteAction : c.core.updateAction;
            if (!delete && (!ArrayUtil.haveCommonElement(changedCols, c.core.mainCols) || c.core.mainIndex.compareRowNonUnique(session, row.getData(), data, c.core.mainCols) == 0)) continue;
            RowIterator refiterator = c.findFkRef(session, row.getData());
            if (!refiterator.hasNext()) {
                refiterator.release();
                continue;
            }
            block12: while (refiterator.hasNext()) {
                Object[] info;
                Row refRow = refiterator.getNextRow();
                Object[] refData = null;
                if (c.core.refIndex.compareRowNonUnique(session, refRow.getData(), row.getData(), c.core.mainCols) != 0) break;
                if (delete && refRow.getId() == row.getId()) continue;
                switch (action) {
                    case 0: {
                        int j;
                        if (delete) {
                            boolean result;
                            try {
                                result = navigator.addRow(refRow);
                            }
                            catch (DataspaceException e) {
                                Object[] info2 = StatementDML.getConstraintInfo(c);
                                refiterator.release();
                                throw Error.error(null, 3900, 2, info2);
                            }
                            if (!result) continue block12;
                            StatementDML.performReferentialActions(session, c.core.refTable, navigator, refRow, null, null, path);
                            continue block12;
                        }
                        refData = c.core.refTable.getEmptyRowData();
                        System.arraycopy(refRow.getData(), 0, refData, 0, refData.length);
                        for (j = 0; j < c.core.refCols.length; ++j) {
                            refData[c.core.refCols[j]] = data[c.core.mainCols[j]];
                        }
                        break;
                    }
                    case 2: {
                        int j;
                        refData = c.core.refTable.getEmptyRowData();
                        System.arraycopy(refRow.getData(), 0, refData, 0, refData.length);
                        for (j = 0; j < c.core.refCols.length; ++j) {
                            refData[c.core.refCols[j]] = null;
                        }
                        break;
                    }
                    case 4: {
                        int j;
                        refData = c.core.refTable.getEmptyRowData();
                        System.arraycopy(refRow.getData(), 0, refData, 0, refData.length);
                        for (j = 0; j < c.core.refCols.length; ++j) {
                            ColumnSchema col = c.core.refTable.getColumn(c.core.refCols[j]);
                            refData[c.core.refCols[j]] = col.getDefaultValue(session);
                        }
                        break;
                    }
                    case 3: {
                        if (navigator.containsDeletedRow(refRow)) continue block12;
                    }
                    case 1: {
                        int errorCode = c.core.deleteAction == 3 ? 8 : 3501;
                        info = StatementDML.getConstraintInfo(c);
                        refiterator.release();
                        throw Error.error(null, errorCode, 2, info);
                    }
                    default: {
                        continue block12;
                    }
                }
                try {
                    refData = navigator.addRow(session, refRow, refData, c.core.refTable.getColumnTypes(), c.core.refCols);
                }
                catch (DataspaceException e) {
                    info = StatementDML.getConstraintInfo(c);
                    refiterator.release();
                    throw Error.error(null, 3900, 2, info);
                }
                if (refData == null || !path.add(c)) continue;
                StatementDML.performReferentialActions(session, c.core.refTable, navigator, refRow, refData, c.core.refCols, path);
                path.remove(c);
            }
            refiterator.release();
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private Object[] getParametersFromVirtualTableStatement(Session session) {
        data = new ArrayList<Object>();
        types = new ArrayList<Integer>();
        newSql = this.sql;
        try {
            lexer = LexerFactory.createLexer(newSql);
            lexer.setSkipComments(true);
            builder = new StringBuilder();
            inWhere = false;
            lastPosition = 0;
            block6: while (!lexer.isAtEnd()) {
                token = lexer.readToken();
                if ("where".equalsIgnoreCase(token.getValue())) {
                    inWhere = true;
                    continue;
                }
                if (!token.isCommon()) continue;
                switch (1.$SwitchMap$com$streamscape$tools$lexer$CommonTokenType[token.getCommonType().ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        token = lexer.readToken();
                        paramBeginPosition = lexer.getCurrentTokenPosition();
                        afterDog = false;
                        variableName = null;
                        if (token.isCommon() && token.getCommonType() == CommonTokenType.DOG) {
                            token = lexer.readToken();
                            afterDog = true;
                        }
                        if (token.getCommonType() == CommonTokenType.LITERAL) {
                            variableName = token.getValue();
                        }
                        if (afterDog && variableName == null) {
                            Trace.logError(this, "Unexpected token after @: " + token.toString() + ". sql: " + this.sql);
                            break;
                        }
                        if (variableName == null) break;
                        expression = null;
                        if (!inWhere) ** GOTO lbl42
                        block7: for (Cloneable rangeVariable : this.rangeVariables) {
                            if (rangeVariable == null || rangeVariable.getJoinCondition() == null) continue;
                            for (Expression joinExpressionNode : rangeVariable.getJoinCondition().nodes) {
                                if (!joinExpressionNode.getColumnName().equals(variableName)) continue;
                                expression = joinExpressionNode;
                                continue block7;
                            }
                        }
                        ** GOTO lbl46
lbl42:
                        // 2 sources

                        for (Cloneable updateExpression : this.updateExpressions) {
                            if (!updateExpression.getColumnName().equals(variableName)) continue;
                            expression = updateExpression;
                            break;
                        }
lbl46:
                        // 3 sources

                        if (expression == null) continue block6;
                        data.add(expression.getDataType().convertSQLToJava(session, expression.getValue(session)));
                        types.add(expression.getDataType().getJDBCTypeCode());
                        builder.append(lexer.substring(lastPosition, paramBeginPosition)).append(" ? ");
                        lastPosition = lexer.getCurrentPosition();
                        break;
                    }
                    case 6: {
                        break;
                    }
                }
            }
            builder.append(lexer.substring(lastPosition, lexer.getLength()));
            newSql = builder.toString();
        }
        catch (LexerException exception) {
            throw new DataspaceException("Failed to create lexer. Cause: " + exception.getMessage());
        }
        typesArray = new int[types.size()];
        for (i = 0; i < types.size(); ++i) {
            typesArray[i] = (Integer)types.get(i);
        }
        return new Object[]{newSql, data.toArray(), typesArray};
    }

    private Pair<Object[], int[]> getDynamicParamsForVirtualTable(Session session) {
        if (session.sessionContext.dynamicArguments != null && session.sessionContext.dynamicArguments.length > 0) {
            Object[] result = new Object[session.sessionContext.dynamicArguments.length];
            int[] types = new int[result.length];
            if (this.parameters != null && this.parameters.length == session.sessionContext.dynamicArguments.length) {
                for (int i = 0; i < this.parameters.length; ++i) {
                    if (this.parameters[i] == null || this.parameters[i].getDataType() == null) continue;
                    result[i] = this.parameters[i].getDataType().convertSQLToJava(session, session.sessionContext.dynamicArguments[i]);
                    types[i] = this.parameters[i].getDataType().getJDBCTypeCode();
                }
                return new Pair<Object[], int[]>(result, types);
            }
        }
        return new Pair<Object, Object>(null, null);
    }

    static String[] getConstraintInfo(Constraint c) {
        return new String[]{c.core.refName.name, c.core.refTable.getObjectName().name};
    }

    @Override
    public void clearStructures(Session session) {
        session.sessionContext.clearStructures(this);
    }

    private RowSetNavigatorDataChange createNewNavigatorWithoutRejectedRows(RowSetNavigatorDataChange navigator, Session session, Set<Row> rejectedRows) {
        if (rejectedRows.size() > 0) {
            navigator.beforeFirst();
            RowSetNavigatorDataChangeMemory navigatorNew = new RowSetNavigatorDataChangeMemory(session);
            while (navigator.next()) {
                Row row = navigator.getCurrentRow();
                Object[] changedData = navigator.getCurrentChangedData();
                int[] changedColumns = navigator.getCurrentChangedColumns();
                if (rejectedRows.contains(row)) continue;
                navigatorNew.addRow(row, changedData, changedColumns);
            }
            return navigatorNew;
        }
        return navigator;
    }
}

