/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.statement;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.HashMappedList;
import com.streamscape.ds.lib.HashSet;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.OrderedIntHashSet;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.RaiseRequestExpression;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.parser.statement.StatementCommand;
import com.streamscape.ds.parser.statement.StatementCursor;
import com.streamscape.ds.parser.statement.StatementExpression;
import com.streamscape.ds.parser.statement.StatementHandler;
import com.streamscape.ds.parser.statement.StatementQuery;
import com.streamscape.ds.parser.statement.StatementSimple;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.SemanticTypeAndPrototypeSchemaObjectsCache;
import com.streamscape.ds.schema.column.ColumnBase;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.EventType;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import com.streamscape.lib.utils.Pair;
import com.streamscape.sdo.excp.LanguageException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class StatementCompound
extends Statement {
    final boolean isLoop;
    NameManager.ObjectName label;
    StatementHandler[] handlers = StatementHandler.emptyExceptionHandlerArray;
    boolean hasUndoHandler;
    StatementQuery loopCursor;
    Statement[] statements;
    Statement[] catchStatements;
    Statement[] finallyStatements;
    NameManager.ObjectName exceptionName;
    StatementExpression condition;
    boolean isAtomic;
    Statement initStat = null;
    Statement[] loopStatements = null;
    NameManager.ObjectName foreachVarName = null;
    Expression expression = null;
    List<Pair<Expression, Statement>> switchStatements = null;
    public ColumnSchema[] variables = ColumnSchema.emptyArray;
    private Map<String, String> types;
    public StatementCursor[] cursors = StatementCursor.emptyArray;
    public RangeVariable[] rangeVariables = RangeVariable.emptyArray;
    com.streamscape.ds.schema.collection.Collection[] collections = Table.emptyCollectionArray;
    public HashMappedList scopeTables;
    public static final StatementCompound[] emptyStatementArray = new StatementCompound[0];

    public Statement[] getStatements() {
        return this.statements;
    }

    public void setInitStat(Statement initStat) {
        this.initStat = initStat;
    }

    public void setLoopStatements(Statement[] loopStatements) {
        this.loopStatements = loopStatements;
    }

    public void setForeachVarName(NameManager.ObjectName foreachVarName) {
        this.foreachVarName = foreachVarName;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public void setSwitchStatements(List<Pair<Expression, Statement>> switchStatements) {
        for (Pair<Expression, Statement> switchUnit : switchStatements) {
            ((Statement)switchUnit.second).setParent(this);
        }
        this.switchStatements = switchStatements;
    }

    public void addImportedType(String alias, String className) {
        if (this.types == null) {
            this.types = new HashMap<String, String>();
        }
        this.types.put(alias, className);
    }

    public boolean hasImportedType(String alias) {
        if (this.types != null && this.types.get(alias) != null) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.hasImportedType(alias);
        }
        return false;
    }

    public String resolveImportedType(String alias) {
        String className = null;
        if (this.types != null) {
            className = this.types.get(alias);
        }
        if (className == null && this.parent != null) {
            return this.parent.resolveImportedType(alias);
        }
        return className;
    }

    public StatementCompound(int type, NameManager.ObjectName label) {
        super(type, 2007);
        this.label = label;
        this.isTransactionStatement = false;
        switch (type) {
            case 46: 
            case 90: 
            case 95: 
            case 97: {
                this.isLoop = true;
                break;
            }
            case 12: 
            case 88: 
            case 3126: 
            case 3177: 
            case 3276: {
                this.isLoop = false;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementCompound");
            }
        }
    }

    @Override
    public String getSQL() {
        return this.sql;
    }

    protected String describe(Session session, int blanks) {
        StringBuffer sb = new StringBuffer();
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        sb.append("STATEMENT");
        return sb.toString();
    }

    public void setExceptionName(NameManager.ObjectName name) {
        this.exceptionName = name;
    }

    public void setLocalDeclarations(Object[] declarations) {
        int i;
        int varCount = 0;
        int handlerCount = 0;
        int cursorCount = 0;
        int collectionCount = 0;
        for (i = 0; i < declarations.length; ++i) {
            if (declarations[i] instanceof ColumnSchema) {
                ++varCount;
                continue;
            }
            if (declarations[i] instanceof StatementHandler) {
                ++handlerCount;
                continue;
            }
            if (declarations[i] instanceof com.streamscape.ds.schema.collection.Collection) {
                ++collectionCount;
                continue;
            }
            ++cursorCount;
        }
        if (varCount > 0) {
            this.variables = new ColumnSchema[varCount];
        }
        if (handlerCount > 0) {
            this.handlers = new StatementHandler[handlerCount];
        }
        if (collectionCount > 0) {
            this.collections = new com.streamscape.ds.schema.collection.Collection[collectionCount];
        }
        if (cursorCount > 0) {
            this.cursors = new StatementCursor[cursorCount];
        }
        varCount = 0;
        handlerCount = 0;
        collectionCount = 0;
        cursorCount = 0;
        for (i = 0; i < declarations.length; ++i) {
            if (declarations[i] instanceof ColumnSchema) {
                this.variables[varCount++] = (ColumnSchema)declarations[i];
                continue;
            }
            if (declarations[i] instanceof StatementHandler) {
                StatementHandler handler = (StatementHandler)declarations[i];
                handler.setParent(this);
                this.handlers[handlerCount++] = handler;
                if (handler.handlerType != 7) continue;
                this.hasUndoHandler = true;
                continue;
            }
            if (declarations[i] instanceof com.streamscape.ds.schema.collection.Collection) {
                com.streamscape.ds.schema.collection.Collection table = (com.streamscape.ds.schema.collection.Collection)declarations[i];
                this.collections[collectionCount++] = table;
                continue;
            }
            StatementCursor cursor = (StatementCursor)declarations[i];
            this.cursors[cursorCount++] = cursor;
        }
        this.setVariables();
        this.setHandlers();
        this.setCollections();
        this.setCursors();
    }

    public void setLoopStatement(StatementQuery cursorStatement) {
        this.loopCursor = cursorStatement;
        NameManager.ObjectName[] colNames = cursorStatement.queryExpression.getResultColumnNames();
        Type[] colTypes = cursorStatement.queryExpression.getColumnTypes();
        Object[] columns = new ColumnSchema[colNames.length];
        for (int i = 0; i < colNames.length; ++i) {
            columns[i] = new ColumnSchema(colNames[i], colTypes[i], false, false, null);
            ((ColumnBase)columns[i]).setParameterMode((byte)1);
        }
        this.setLocalDeclarations(columns);
    }

    public void setStatements(Statement[] statements) {
        for (int i = 0; i < statements.length; ++i) {
            statements[i].setParent(this);
        }
        this.statements = statements;
    }

    public void setCatchStatements(Statement[] statements) {
        for (int i = 0; i < statements.length; ++i) {
            statements[i].setParent(this);
        }
        this.catchStatements = statements;
    }

    public void setFinallyStatements(Statement[] statements) {
        for (int i = 0; i < statements.length; ++i) {
            statements[i].setParent(this);
        }
        this.finallyStatements = statements;
    }

    public void setCondition(StatementExpression condition) {
        this.condition = condition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result execute(Session session) {
        Result result = null;
        switch (this.type) {
            case 12: {
                this.initialiseVariables(session);
                result = this.executeBlock(session);
                break;
            }
            case 3276: {
                int routineVariablesLength = session.sessionContext.routineVariables.length;
                Object[] routineVariables = session.sessionContext.routineVariables;
                if (this.root.variableCount > session.sessionContext.routineVariables.length) {
                    routineVariables = Arrays.copyOf(session.sessionContext.routineVariables, this.root.variableCount);
                }
                session.sessionContext.push();
                try {
                    session.sessionContext.routineVariables = routineVariables;
                    result = this.executeBlock(session);
                    session.sessionContext.closeRoutineVariables();
                }
                finally {
                    session.sessionContext.pop();
                    session.sessionContext.routineVariables = Arrays.copyOf(routineVariables, routineVariablesLength);
                }
                if (result.isError()) break;
                result = Result.updateNoResult;
                break;
            }
            case 3126: {
                this.initialiseVariables(session);
                result = this.executeTryCatch(session);
                break;
            }
            case 46: {
                result = this.executeForLoop(session);
                break;
            }
            case 90: 
            case 95: 
            case 97: {
                result = this.executeLoop(session);
                break;
            }
            case 88: {
                result = this.executeIf(session);
                break;
            }
            case 3177: {
                result = this.executeSwitch(session);
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementCompound");
            }
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result executeBlock(Session session) {
        boolean push;
        Result result = Result.updateZeroResult;
        boolean bl = this.root != null ? !this.root.isTrigger() : (push = true);
        if (push) {
            session.sessionContext.push();
            if (this.hasUndoHandler) {
                String name = NameManager.getAutoSavepointNameString(session.actionTimestamp, session.sessionContext.depth);
                session.savepoint(name);
            }
        }
        try {
            for (int i = 0; i < this.statements.length; ++i) {
                Session.checkIfThreadIsInterrupted();
                if (Trace.isDebugEnabled(StatementCompound.class) && !(this.statements[i] instanceof StatementCompound)) {
                    try {
                        Trace.logDebug(this, "[executeBlock] Session: {} Statement SQL: {}.", session.getId(), this.statements[i].getSQL());
                    }
                    catch (Exception exception) {
                        Trace.logError(this, "Failed to get getSQL()");
                        Trace.logException(this, exception, true);
                    }
                }
                result = this.statements[i].execute(session);
                if ((result = this.handleCondition(session, result)).isError()) {
                    if (result.getException() == null || result.getException().isLogged()) break;
                    Trace.logException(this, result.getException(), true);
                    result.getException().setLogged(true);
                    break;
                }
                if (result.getType() == 42) break;
            }
            if (result.getType() == 42 && result.getErrorCode() == 89) {
                if (result.getMainString() == null) {
                    result = Result.updateZeroResult;
                } else if (this.label != null && this.label.name.equals(result.getMainString())) {
                    result = Result.updateZeroResult;
                }
            }
        }
        finally {
            if (push) {
                session.sessionContext.pop();
            }
        }
        return result;
    }

    private Result handleCondition(Session session, Result result) {
        String sqlState = null;
        if (result.isError()) {
            sqlState = result.getSubString();
        } else if (session.getLastWarning() != null) {
            sqlState = session.getLastWarning().getSQLState();
        } else {
            return result;
        }
        if (sqlState != null) {
            for (int i = 0; i < this.handlers.length; ++i) {
                StatementHandler handler = this.handlers[i];
                session.clearWarnings();
                if (!handler.handlesCondition(sqlState)) continue;
                session.resetSchema();
                String labelString = this.label == null ? null : this.label.name;
                switch (handler.handlerType) {
                    case 5: {
                        result = Result.updateZeroResult;
                        break;
                    }
                    case 7: {
                        session.rollbackToSavepoint();
                        result = Result.newPSMResult(89, labelString, null);
                        break;
                    }
                    case 6: {
                        result = Result.newPSMResult(89, null, null);
                    }
                }
                Result actionResult = handler.statement.execute(session);
                if (actionResult.isError()) {
                    result = actionResult;
                    this.handleCondition(session, result);
                    continue;
                }
                return result;
            }
            if (this.parent != null) {
                return this.parent.handleCondition(session, result);
            }
        }
        return result;
    }

    private Result executeForLoop(Session session) {
        if (this.loopCursor != null) {
            Result queryResult = this.loopCursor.getResult(session);
            if (queryResult.isError()) {
                return queryResult;
            }
            Result result = Result.updateZeroResult;
            while (queryResult.navigator.hasNext()) {
                queryResult.navigator.next();
                Object[] data = queryResult.navigator.getCurrent();
                this.initialiseVariables(session, data, queryResult.metaData.columns, queryResult.metaData.columnLabels);
                for (int i = 0; i < this.statements.length && !(result = this.statements[i].execute(session)).isError() && result.getType() != 42; ++i) {
                }
                if (result.isError()) break;
                if (result.getType() != 42) continue;
                if (result.getErrorCode() == 102) {
                    if (result.getMainString() != null && (this.label == null || !this.label.name.equals(result.getMainString()))) break;
                    continue;
                }
                if (result.getErrorCode() == 89) break;
                if (result.getErrorCode() == 3127) {
                    result = Result.updateZeroResult;
                    break;
                }
                if (result.getErrorCode() == 3128) continue;
            }
            queryResult.navigator.release();
            return result;
        }
        if (this.foreachVarName != null && this.expression != null) {
            Result result = Result.updateZeroResult;
            Object expressionValue = this.expression.getValue(session);
            boolean requiresWrapper = false;
            expressionValue = OtherTypeWrapper.unwrap(expressionValue);
            int index = -1;
            for (RangeVariable var : this.rangeVariables) {
                if (var == null || (index = var.findColumn(this.foreachVarName.name)) == -1) continue;
                ColumnSchema colMeta = var.getColumn(index);
                requiresWrapper = colMeta.getDataType() instanceof OtherType;
                break;
            }
            if (index == -1) {
                throw new DataspaceException("For each loop invalid state. Unable to set variable.");
            }
            Class<?> valueClass = expressionValue.getClass();
            if (valueClass.isArray()) {
                Object[] arrayValue;
                for (Object value : arrayValue = (Object[])expressionValue) {
                    if (requiresWrapper) {
                        value = new OtherTypeWrapper(value);
                    }
                    session.sessionContext.routineVariables[index] = value;
                    if (this.statements == null) continue;
                    for (int i = 0; i < this.statements.length && !(result = this.statements[i].execute(session)).isError() && result.getType() != 42; ++i) {
                    }
                    if (result.getType() != 42) continue;
                    if (result.getErrorCode() == 3127) {
                        result = Result.updateZeroResult;
                    } else if (result.getErrorCode() == 3128) {
                        continue;
                    }
                    break;
                }
            } else if (Collection.class.isAssignableFrom(valueClass)) {
                Collection collectionValue = (Collection)expressionValue;
                for (Object value : collectionValue) {
                    if (requiresWrapper) {
                        value = new OtherTypeWrapper(value);
                    }
                    session.sessionContext.routineVariables[index] = value;
                    if (this.statements == null) continue;
                    for (int i = 0; i < this.statements.length && !(result = this.statements[i].execute(session)).isError() && result.getType() != 42; ++i) {
                    }
                    if (result.getType() != 42) continue;
                    if (result.getErrorCode() == 3127) {
                        result = Result.updateZeroResult;
                    } else if (result.getErrorCode() == 3128) {
                        continue;
                    }
                    break;
                }
            } else {
                throw new DataspaceException("Unsupported data in foreach loop.");
            }
            return result;
        }
        Result result = Result.updateZeroResult;
        if (this.initStat != null) {
            result = this.initStat.execute(session);
            if (result.isError()) {
                return result;
            }
            if (result.getType() == 42) {
                if (result.getErrorCode() == 3127) {
                    return Result.updateZeroResult;
                }
                if (result.getErrorCode() == 3128) {
                    return Result.updateZeroResult;
                }
            }
        }
        while (true) {
            if (this.condition != null) {
                result = this.condition.execute(session);
                if (result.isError()) break;
                Object conditionValue = result.getValueObject();
                if (!Boolean.TRUE.equals(conditionValue = Type.SQL_BOOLEAN.convertToType(session, conditionValue, this.condition.expression.getDataType()))) {
                    result = Result.updateZeroResult;
                    break;
                }
            }
            if (this.statements != null) {
                for (int i = 0; i < this.statements.length && !(result = this.statements[i].execute(session)).isError() && result.getType() != 42; ++i) {
                }
                if (result.isError()) break;
                if (result.getType() == 42) {
                    if (result.getErrorCode() == 3127) {
                        result = Result.updateZeroResult;
                        break;
                    }
                    if (result.getErrorCode() != 3128) break;
                }
            }
            if (this.loopStatements == null) continue;
            for (int i = 0; i < this.loopStatements.length; ++i) {
                result = this.loopStatements[i].execute(session);
                if (result.isError()) {
                    return result;
                }
                if (result.getType() == 42) break;
            }
            if (result.getType() != 42) continue;
            if (result.getErrorCode() == 3127) break;
            if (result.getErrorCode() != 3128) continue;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result executeSwitch(Session session) {
        boolean push;
        Result result = Result.updateZeroResult;
        boolean bl = this.root != null ? !this.root.isTrigger() : (push = true);
        if (push) {
            session.sessionContext.push();
        }
        try {
            Type type = this.expression.getDataType();
            Object switchValue = this.expression.getValue(session);
            for (Pair<Expression, Statement> switchStat : this.switchStatements) {
                Object currentValue = ((Expression)switchStat.first).getValue(session);
                if (type.compare(session, switchValue, currentValue) != 0) continue;
                Result result2 = ((Statement)switchStat.second).execute(session);
                return result2;
            }
        }
        finally {
            if (push) {
                session.sessionContext.pop();
            }
        }
        return result;
    }

    private Result executeLoop(Session session) {
        Result result;
        block12: {
            result = Result.updateZeroResult;
            while (true) {
                if (this.type == 97) {
                    result = this.condition.execute(session);
                    if (result.isError()) break block12;
                    Object conditionValue = result.getValueObject();
                    if (!Boolean.TRUE.equals(conditionValue = Type.SQL_BOOLEAN.convertToType(session, conditionValue, this.condition.expression.getDataType()))) {
                        result = Result.updateZeroResult;
                        break block12;
                    }
                }
                Session.checkIfThreadIsInterrupted();
                for (int i = 0; i < this.statements.length && !(result = this.statements[i].execute(session)).isError() && result.getType() != 42; ++i) {
                }
                if (result.isError()) break block12;
                if (result.getType() == 42) {
                    if (result.getErrorCode() == 102) {
                        if (result.getMainString() == null || this.label != null && this.label.name.equals(result.getMainString())) {
                            continue;
                        }
                        break block12;
                    }
                    if (result.getErrorCode() == 89) {
                        if (result.getMainString() == null) {
                            result = Result.updateZeroResult;
                        }
                        if (this.label == null || !this.label.name.equals(result.getMainString())) break block12;
                        result = Result.updateZeroResult;
                        break block12;
                    }
                    if (result.getErrorCode() == 3127) {
                        result = Result.updateZeroResult;
                    } else if (result.getErrorCode() == 3128) {
                        continue;
                    }
                    break block12;
                }
                if (this.type != 95) continue;
                result = this.condition.execute(session);
                if (result.isError()) break block12;
                if (Boolean.TRUE.equals(result.getValueObject())) break;
            }
            result = Result.updateZeroResult;
        }
        return result;
    }

    private Result executeIf(Session session) {
        Result result = Result.updateZeroResult;
        boolean execute = false;
        for (int i = 0; i < this.statements.length; ++i) {
            if (this.statements[i].getType() == 1201) {
                if (execute || (result = this.statements[i].execute(session)).isError()) break;
                Object value = result.getValueObject();
                execute = Boolean.TRUE.equals(OtherTypeWrapper.unwrap(value));
                ++i;
            }
            result = Result.updateZeroResult;
            if (execute && i < this.statements.length && ((result = this.statements[i].execute(session)).isError() || result.getType() == 42)) break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Result executeTryCatch(Session session) {
        Result result = Result.updateZeroResult;
        try {
            try {
                result = this.executeBlockForTryCatch(session, this.statements);
                if (result.getType() == 42) {
                    Result result2 = result;
                    return result2;
                }
            }
            catch (Exception ex) {
                LanguageException languageException = LanguageException.create(ex);
                RangeVariable[] vars = this.rangeVariables;
                int index = -1;
                for (int i = 0; i < vars.length && (vars[i] == null || (index = vars[i].findColumn(this.exceptionName.name)) <= -1); ++i) {
                }
                if (index > 0) {
                    session.sessionContext.routineVariables[index] = new OtherTypeWrapper(languageException);
                }
                if (this.catchStatements == null) {
                }
                result = this.executeBlockForTryCatch(session, this.catchStatements);
                if (result.getType() == 42) {
                    Result result3 = result;
                    return result3;
                }
            }
            finally {
                if (this.finallyStatements != null && (result = this.executeBlockForTryCatch(session, this.finallyStatements)).getType() == 42) {
                    return result;
                }
            }
        }
        catch (Throwable t) {
            return Result.newErrorResult(t, null);
        }
    }

    private Result executeBlockForTryCatch(Session session, Statement[] statements) {
        Result result = Result.updateZeroResult;
        for (int i = 0; i < statements.length; ++i) {
            result = statements[i].execute(session);
            if (result.isError()) {
                if (result.getException() != null) {
                    throw result.getException();
                }
                throw new DataspaceException("Execution of statement '" + statements[i].getSQL() + "' failed.");
            }
            if (result.getType() == 42) break;
        }
        return result;
    }

    @Override
    public void resolve(Session session) {
        int i;
        int i2;
        OrderedHashSet set = new OrderedHashSet();
        if (this.statements != null) {
            for (i2 = 0; i2 < this.statements.length; ++i2) {
                if (this.statements[i2].getType() == 89 || this.statements[i2].getType() == 102) {
                    if (this.findLabel((StatementSimple)this.statements[i2])) continue;
                    throw Error.error(5508, ((StatementSimple)this.statements[i2]).label.name);
                }
                if (this.statements[i2].getType() != 58 || this.root.isFunction()) continue;
                throw Error.error(5602, "RETURN");
            }
            for (i2 = 0; i2 < this.statements.length; ++i2) {
                this.statements[i2].resolve(session);
                this.checkRaiseStatement(session, this.statements[i2], set);
            }
        }
        if (this.catchStatements != null) {
            for (i2 = 0; i2 < this.catchStatements.length; ++i2) {
                this.catchStatements[i2].resolve(session);
                this.checkRaiseStatement(session, this.catchStatements[i2], set);
            }
        }
        if (this.finallyStatements != null) {
            for (i2 = 0; i2 < this.finallyStatements.length; ++i2) {
                this.finallyStatements[i2].resolve(session);
                this.checkRaiseStatement(session, this.finallyStatements[i2], set);
            }
        }
        if (this.loopStatements != null) {
            for (i2 = 0; i2 < this.loopStatements.length; ++i2) {
                this.loopStatements[i2].resolve(session);
                this.checkRaiseStatement(session, this.loopStatements[i2], set);
            }
        }
        if (this.switchStatements != null) {
            for (Pair<Expression, Statement> switchStat : this.switchStatements) {
                ((Statement)switchStat.second).resolve(session);
                this.checkRaiseStatement(session, (Statement)switchStat.second, set);
            }
        }
        for (int i3 = 0; i3 < this.handlers.length; ++i3) {
            this.handlers[i3].resolve(session);
        }
        OrderedHashSet writeTableNamesSet = new OrderedHashSet();
        OrderedHashSet readTableNamesSet = new OrderedHashSet();
        for (i = 0; i < this.variables.length; ++i) {
            this.variables[i].setReferences();
            set.addAll(this.variables[i].getReferences());
        }
        if (this.initStat != null) {
            this.initStat.resolve(session);
        }
        if (this.condition != null) {
            set.addAll(this.condition.getReferences());
            readTableNamesSet.addAll(this.condition.getTableNamesForRead());
        }
        if (this.statements != null) {
            for (i = 0; i < this.statements.length; ++i) {
                set.addAll(this.statements[i].getReferences());
                readTableNamesSet.addAll(this.statements[i].getTableNamesForRead());
                writeTableNamesSet.addAll(this.statements[i].getTableNamesForWrite());
            }
        }
        if (this.catchStatements != null) {
            for (i = 0; i < this.catchStatements.length; ++i) {
                set.addAll(this.catchStatements[i].getReferences());
                readTableNamesSet.addAll(this.catchStatements[i].getTableNamesForRead());
                writeTableNamesSet.addAll(this.catchStatements[i].getTableNamesForWrite());
            }
        }
        if (this.finallyStatements != null) {
            for (i = 0; i < this.finallyStatements.length; ++i) {
                set.addAll(this.finallyStatements[i].getReferences());
                readTableNamesSet.addAll(this.finallyStatements[i].getTableNamesForRead());
                writeTableNamesSet.addAll(this.finallyStatements[i].getTableNamesForWrite());
            }
        }
        if (this.loopCursor != null) {
            set.addAll(this.loopCursor.getReferences());
            readTableNamesSet.addAll(this.loopCursor.getTableNamesForRead());
            writeTableNamesSet.addAll(this.loopCursor.getTableNamesForWrite());
        }
        if (this.loopStatements != null) {
            for (i = 0; i < this.loopStatements.length; ++i) {
                set.addAll(this.loopStatements[i].getReferences());
                readTableNamesSet.addAll(this.loopStatements[i].getTableNamesForRead());
                writeTableNamesSet.addAll(this.loopStatements[i].getTableNamesForWrite());
            }
        }
        if (this.switchStatements != null) {
            for (Pair<Expression, Statement> switchStat : this.switchStatements) {
                set.addAll(((Statement)switchStat.second).getReferences());
                readTableNamesSet.addAll(((Statement)switchStat.second).getTableNamesForRead());
                writeTableNamesSet.addAll(((Statement)switchStat.second).getTableNamesForWrite());
            }
        }
        for (int i4 = 0; i4 < this.handlers.length; ++i4) {
            set.addAll(this.handlers[i4].getReferences());
            readTableNamesSet.addAll(this.handlers[i4].getTableNamesForRead());
            writeTableNamesSet.addAll(this.handlers[i4].getTableNamesForWrite());
        }
        if (this.initStat != null) {
            set.addAll(this.initStat.getReferences());
            readTableNamesSet.addAll(this.initStat.getTableNamesForRead());
            writeTableNamesSet.addAll(this.initStat.getTableNamesForWrite());
        }
        readTableNamesSet.removeAll(writeTableNamesSet);
        this.readTableNames = new NameManager.ObjectName[readTableNamesSet.size()];
        readTableNamesSet.toArray(this.readTableNames);
        this.writeTableNames = new NameManager.ObjectName[writeTableNamesSet.size()];
        writeTableNamesSet.toArray(this.writeTableNames);
        this.references = set;
    }

    private void checkRaiseStatement(Session session, Statement stat, OrderedHashSet set) {
        if (stat.getType() == 3025 || stat.getType() == 3027 || stat.getType() == 3028 || stat.getType() == 3289) {
            Type type;
            String eventId = null;
            Object[] params = ((StatementCommand)stat).getParameters();
            if (params.length > 0 && params[0] instanceof String) {
                eventId = (String)params[0];
            } else if (params.length > 1 && params[1] instanceof Expression) {
                Type type2 = ((Expression)params[1]).getDataType();
                if (type2 != null && type2 instanceof EventType && ((EventType)type2).getEventId() != null && session.sessionContext.raisedEventIds != null) {
                    eventId = ((EventType)type2).getEventId();
                }
            } else if (params.length > 0 && params[0] instanceof RaiseRequestExpression && (type = ((RaiseRequestExpression)params[0]).getEventExpression().getDataType()) != null && type instanceof EventType && ((EventType)type).getEventId() != null && session.sessionContext.raisedEventIds != null) {
                eventId = ((EventType)type).getEventId();
            }
            if (eventId != null) {
                session.sessionContext.raisedEventIds.add(eventId);
                set.add(SemanticTypeAndPrototypeSchemaObjectsCache.createOrGetEventPrototypeObjectName(eventId));
            }
        }
    }

    @Override
    public void setRoot(RplScript routine) {
        this.root = routine;
    }

    @Override
    public String describe(Session session) {
        return "";
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        return result;
    }

    @Override
    public OrderedHashSet getReferences() {
        return this.references;
    }

    public void setAtomic(boolean atomic) {
        this.isAtomic = atomic;
    }

    public boolean hasTransientCollection(String name) {
        return this.scopeTables != null && this.scopeTables.keySet().contains(name);
    }

    public com.streamscape.ds.schema.collection.Collection getTransientCollection(String name) {
        return this.scopeTables != null ? (com.streamscape.ds.schema.collection.Collection)this.scopeTables.get(name) : null;
    }

    public void addLocalVariable(ColumnSchema variable) {
        this.variables = Arrays.copyOf(this.variables, this.variables.length + 1);
        this.variables[this.variables.length - 1] = variable;
        String name = variable.getObjectName().name;
        if (!this.root.scopeVariables.add(name, variable)) {
            throw Error.error(5606, name);
        }
        if (this.root.getParameterIndex(name) != -1) {
            throw Error.error(5606, name);
        }
        RangeVariable[] parameterRangeVariables = this.root.getParameterRangeVariables();
        RangeVariable range = new RangeVariable(this.root.scopeVariables, null, true, 4);
        this.rangeVariables = Arrays.copyOf(parameterRangeVariables, parameterRangeVariables.length + 1);
        this.rangeVariables[this.rangeVariables.length - 1] = range;
        this.root.variableCount = this.root.scopeVariables.size();
    }

    public void addTransientVariable(ColumnSchema variable, Object initialValue) {
        String name = variable.getObjectName().name;
        if (this.root.hasTransientVariable(name)) {
            throw Error.error(5606, name);
        }
        if (this.root.getParameterIndex(name) != -1) {
            throw Error.error(5606, name);
        }
        this.root.addTransientVariable(name, variable);
        this.root.setTransientVariable(this.root.getNumberOfTransientVariables() - 1, initialValue);
        RangeVariable range = new RangeVariable(this.root.getTransientVariables(), null, true, 5);
        range.setParentRplBloc(this.root);
        RangeVariable[] parameterRangeVariables = this.root.getParameterRangeVariables();
        parameterRangeVariables[parameterRangeVariables.length - 1] = range;
    }

    public void addTransientCollection(com.streamscape.ds.schema.collection.Collection variable) {
        this.collections = Arrays.copyOf(this.collections, this.collections.length + 1);
        this.collections[this.collections.length - 1] = variable;
        this.setCollections();
    }

    private void setVariables() {
        if (this.variables.length == 0) {
            this.rangeVariables = this.parent == null ? this.root.getParameterRangeVariables() : this.parent.rangeVariables;
            return;
        }
        for (int i = 0; i < this.variables.length; ++i) {
            String name = this.variables[i].getObjectName().name;
            boolean added = this.root.scopeVariables.add(name, this.variables[i]);
            if (!added) {
                throw Error.error(5606, name);
            }
            if (this.root.getParameterIndex(name) == -1) continue;
            throw Error.error(5606, name);
        }
        RangeVariable[] parameterRangeVariables = this.root.getParameterRangeVariables();
        RangeVariable range = new RangeVariable(this.root.scopeVariables, null, true, 4);
        this.rangeVariables = new RangeVariable[parameterRangeVariables.length + 1];
        for (int i = 0; i < parameterRangeVariables.length; ++i) {
            this.rangeVariables[i] = parameterRangeVariables[i];
        }
        this.rangeVariables[parameterRangeVariables.length] = range;
        this.root.variableCount = this.root.scopeVariables.size();
    }

    private void setHandlers() {
        if (this.handlers.length == 0) {
            return;
        }
        HashSet statesSet = new HashSet();
        OrderedIntHashSet typesSet = new OrderedIntHashSet();
        for (int i = 0; i < this.handlers.length; ++i) {
            int[] types = this.handlers[i].getConditionTypes();
            for (int j = 0; j < types.length; ++j) {
                if (typesSet.add(types[j])) continue;
                throw Error.error(5601);
            }
            String[] states = this.handlers[i].getConditionStates();
            for (int j = 0; j < states.length; ++j) {
                if (statesSet.add(states[j])) continue;
                throw Error.error(5601);
            }
        }
    }

    private void setCollections() {
        int i;
        if (this.collections.length == 0) {
            return;
        }
        HashMappedList list = new HashMappedList();
        if (this.parent != null && this.parent.scopeTables != null) {
            for (i = 0; i < this.parent.scopeTables.size(); ++i) {
                list.add(this.parent.scopeTables.getKey(i), this.parent.scopeTables.get(i));
            }
        }
        for (i = 0; i < this.collections.length; ++i) {
            String name = this.collections[i].getObjectName().name;
            boolean added = list.add(name, this.collections[i]);
            if (added) continue;
            throw Error.error(5606, name);
        }
        this.scopeTables = list;
    }

    private void setCursors() {
        if (this.cursors.length == 0) {
            return;
        }
        HashSet list = new HashSet();
        for (int i = 0; i < this.cursors.length; ++i) {
            StatementCursor cursor = this.cursors[i];
            boolean added = list.add(cursor.getCursorName().name);
            if (added) continue;
            throw Error.error(5606, cursor.getCursorName().name);
        }
    }

    private boolean findLabel(StatementSimple statement) {
        if (this.label != null && statement.label.name.equals(this.label.name)) {
            return this.isLoop || statement.getType() != 102;
        }
        if (this.parent == null) {
            return false;
        }
        return this.parent.findLabel(statement);
    }

    private void initialiseVariables(Session session) {
        RangeVariable varRange = null;
        for (RangeVariable var : this.rangeVariables) {
            if (var == null || var.rangeType != 4) continue;
            varRange = var;
            break;
        }
        Object[] vars = session.sessionContext.routineVariables;
        for (int i = 0; i < this.variables.length; ++i) {
            try {
                int index = varRange.findColumn(this.variables[i].getObjectName().name);
                if (index == -1) continue;
                vars[index] = this.variables[i].getDefaultValue(session);
                continue;
            }
            catch (DataspaceException dataspaceException) {
                // empty catch block
            }
        }
    }

    private void initialiseVariables(Session session, Object[] data, ColumnBase[] columns, String[] columnLabels) {
        if (columns == null || columns.length <= 0 || data.length != columns.length) {
            return;
        }
        Object[] vars = session.sessionContext.routineVariables;
        String firstColumnName = columnLabels[0];
        if (firstColumnName == null) {
            firstColumnName = columns[0].getNameString();
        }
        if (firstColumnName == null) {
            throw new DataspaceException("Invalid variable name in 'for' loop.");
        }
        int firstVarIndex = this.root.scopeVariables.getIndex(firstColumnName);
        for (int i = 0; i < data.length; ++i) {
            try {
                vars[firstVarIndex + i] = data[i];
                continue;
            }
            catch (DataspaceException dataspaceException) {
                // empty catch block
            }
        }
    }

    @Override
    public RangeVariable[] getRangeVariables() {
        return this.rangeVariables;
    }

    @Override
    public boolean containsTransactionalStatement() {
        if (this.statements == null) {
            return false;
        }
        for (Statement statement : this.statements) {
            if (!statement.containsTransactionalStatement()) continue;
            return true;
        }
        if (this.catchStatements != null) {
            for (Statement statement : this.catchStatements) {
                if (!statement.containsTransactionalStatement()) continue;
                return true;
            }
        }
        if (this.finallyStatements != null) {
            for (Statement statement : this.finallyStatements) {
                if (!statement.containsTransactionalStatement()) continue;
                return true;
            }
        }
        if (this.loopStatements != null) {
            for (Statement statement : this.loopStatements) {
                if (!statement.containsTransactionalStatement()) continue;
                return true;
            }
        }
        if (this.switchStatements != null) {
            for (Pair pair : this.switchStatements) {
                if (!((Statement)pair.second).containsTransactionalStatement()) continue;
                return true;
            }
        }
        return false;
    }
}

