/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.statement;

import com.streamscape.Trace;
import com.streamscape.cli.ds.CollectionType;
import com.streamscape.cli.ds.collection.Facets;
import com.streamscape.cli.ds.collection.JournalFileTable;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.CheckpointManager;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.DataspaceStoreState;
import com.streamscape.ds.core.MemoryModel;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.scriptio.ScriptWriterText;
import com.streamscape.ds.lib.DataspaceDateTime;
import com.streamscape.ds.lib.HashMappedList;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.WrapperIterator;
import com.streamscape.ds.lib.java.JavaSystem;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.navigator.RowSetNavigatorClient;
import com.streamscape.ds.parser.completion.DataspaceFunctionUnitManagerForCompletion;
import com.streamscape.ds.parser.expression.ExecBlockExpression;
import com.streamscape.ds.parser.expression.ExecImmediateExpression;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.FindTextExpression;
import com.streamscape.ds.parser.statement.FabricEventSinkFactoryImpl;
import com.streamscape.ds.parser.statement.FabricEventSourceFactoryImpl;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.parser.statement.StatementSchema;
import com.streamscape.ds.parser.statement.StatementUtil;
import com.streamscape.ds.persist.BaseStoreProperties;
import com.streamscape.ds.persist.DataspaceStoreProperties;
import com.streamscape.ds.persist.LogRecordType;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.fulltext.FullTextIndex;
import com.streamscape.ds.persist.fulltext.FullTextManager;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.persist.jfq.FileQueueFilesManager;
import com.streamscape.ds.persist.snapshot.IndexSnapshot;
import com.streamscape.ds.replication.AbstractReplicationEntity;
import com.streamscape.ds.replication.ReplicaInfo;
import com.streamscape.ds.replication.ReplicaState;
import com.streamscape.ds.replication.ReplicationData;
import com.streamscape.ds.replication.ReplicationDataTransaction;
import com.streamscape.ds.replication.ReplicationEntityName;
import com.streamscape.ds.replication.ReplicationOperationType;
import com.streamscape.ds.replication.ReplicationQueue;
import com.streamscape.ds.replication.ReplicationQueueFileBased;
import com.streamscape.ds.replication.ReplicationResponse;
import com.streamscape.ds.replication.ReplicationSource;
import com.streamscape.ds.replication.ReplicationTarget;
import com.streamscape.ds.replication.ReplicationUtil;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultMetaData;
import com.streamscape.ds.result.ResultPseudo;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.rights.Right;
import com.streamscape.ds.rights.UserWrapper;
import com.streamscape.ds.schema.DataspaceSchema;
import com.streamscape.ds.schema.RplSchemaObject;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.AbstractCollection;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.collection.CollectionMetaDataImpl;
import com.streamscape.ds.schema.collection.Tuple;
import com.streamscape.ds.schema.collection.cspace.CSpace;
import com.streamscape.ds.schema.collection.cspace.definitions.KAssertionTypeSchemaObject;
import com.streamscape.ds.schema.collection.cspace.definitions.KGraphInstanceSchemaObject;
import com.streamscape.ds.schema.collection.cspace.definitions.KGraphTypeSchemaObject;
import com.streamscape.ds.schema.collection.cspace.definitions.KLinkTypeSchemaObject;
import com.streamscape.ds.schema.collection.cspace.definitions.KNodeTypeSchemaObject;
import com.streamscape.ds.schema.collection.cspace.instances.KGraph;
import com.streamscape.ds.schema.collection.cspace.tables.CSpaceSysTablesManager;
import com.streamscape.ds.schema.collection.cspace.tables.KAssertionTableManager;
import com.streamscape.ds.schema.collection.cspace.tables.KNodeTableManager;
import com.streamscape.ds.schema.collection.fspace.hadoop.HadoopVirtualTableCollection;
import com.streamscape.ds.schema.collection.fspace.table.JournalFileTableCollection;
import com.streamscape.ds.schema.collection.fspace.table.LogFileTableCollection;
import com.streamscape.ds.schema.collection.qspace.equeue.EventQueueCollection;
import com.streamscape.ds.schema.collection.qspace.pqueue.ProcessQueueCollection;
import com.streamscape.ds.schema.collection.qspace.pqueue.ProcessQueueRecipientsTableManager;
import com.streamscape.ds.schema.collection.qspace.pqueue.ProcessState;
import com.streamscape.ds.schema.collection.qspace.queue.BlockingQueueCollection;
import com.streamscape.ds.schema.collection.stream.SourceStreamCollection;
import com.streamscape.ds.schema.collection.tspace.etable.EventTableCollection;
import com.streamscape.ds.schema.collection.tspace.table.SnapshotCollection;
import com.streamscape.ds.schema.collection.tspace.vtable.VirtualTableCollection;
import com.streamscape.ds.schema.column.ColumnBase;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.constraint.ReferenceLink;
import com.streamscape.ds.schema.event.Actor;
import com.streamscape.ds.schema.job.JobObject;
import com.streamscape.ds.schema.procedure.FunctionSQL;
import com.streamscape.ds.schema.procedure.RoutineSchema;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.schema.sequence.NumberSequence;
import com.streamscape.ds.schema.server.ServerObject;
import com.streamscape.ds.schema.server.ServerRole;
import com.streamscape.ds.schema.table.FileTable;
import com.streamscape.ds.schema.table.JournalFileQueueTable;
import com.streamscape.ds.schema.table.SnapshotDataspaceTable;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.TableWorks;
import com.streamscape.ds.schema.timer.TimerObject;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.session.SessionData;
import com.streamscape.ds.stable.index.SIndex;
import com.streamscape.ds.state.DataspaceStateHolder;
import com.streamscape.ds.trigger.EventTriggerDefSQL;
import com.streamscape.ds.trigger.RecompiledTrigger;
import com.streamscape.ds.trigger.ReplicationEventTrigger;
import com.streamscape.ds.trigger.ReplicationModifyTrigger;
import com.streamscape.ds.trigger.ReplicationValidateTrigger;
import com.streamscape.ds.trigger.Trigger;
import com.streamscape.ds.trigger.TriggerDef;
import com.streamscape.ds.trigger.WindowTriggerDefSQL;
import com.streamscape.ds.types.AspectsSchemaObject;
import com.streamscape.ds.types.BooleanType;
import com.streamscape.ds.types.CharacterType;
import com.streamscape.ds.types.FacetsSchemaObject;
import com.streamscape.ds.types.FacetsUtils;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.utils.RowSetFactoryForDSResult;
import com.streamscape.ds.utils.SourceEventFlowDataImpl;
import com.streamscape.ds.utils.SqlUtils;
import com.streamscape.ds.utils.schemaserialization.DumpLoadUtil;
import com.streamscape.ds.utils.schemaserialization.ObjectType;
import com.streamscape.ds.utils.schemaserialization.SchemaComparator;
import com.streamscape.ds.utils.schemaserialization.SchemaDumper;
import com.streamscape.ds.utils.schemaserialization.SchemaLoader;
import com.streamscape.lib.file.AbstractRecordTypeDefinition;
import com.streamscape.lib.file.FileDescriptor;
import com.streamscape.lib.file.FileDescriptorBuilder;
import com.streamscape.lib.file.FileDescriptorFactory;
import com.streamscape.lib.file.FileLinesReader;
import com.streamscape.lib.file.FileRecordsReader;
import com.streamscape.lib.file.FileRecordsWriter;
import com.streamscape.lib.timer.FabricTimer;
import com.streamscape.lib.timer.FabricTimerManager;
import com.streamscape.lib.timer.FabricTimerState;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.omf.java.Utils;
import com.streamscape.omf.json.jackson.JsonNotation;
import com.streamscape.omf.json.jackson.JsonNotationLevel;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.enums.AcknowledgeAction;
import com.streamscape.sdo.event.AcknowledgementEvent;
import com.streamscape.sdo.operation.SLMessage;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.rowset.RowSetPrinter;
import com.streamscape.sef.dataspace.DataspaceManager;
import com.streamscape.sef.dispatcher.AbstractDataspaceComponent;
import com.streamscape.sef.dispatcher.AbstractModeratorOperation;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.sef.enums.ComponentState;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.mf.admin.FabricTimerFactory;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.EventFlowEntity;
import com.streamscape.sef.pkg.PackageDescriptor;
import com.streamscape.sef.pkg.PackageManifestManager;
import com.streamscape.sef.security.Group;
import com.streamscape.sef.security.User;
import com.streamscape.sef.service.ServiceDescriptor;
import com.streamscape.sef.service.ServiceManager;
import com.streamscape.sef.service.ServiceManagerException;
import com.streamscape.sef.trace.record.LogRecordMatcherPattern;
import com.streamscape.sef.trace.record.LogRecordMatcherResolver;
import com.streamscape.sef.trace.record.TimestampResolverUtils;
import com.streamscape.service.osf.config.ActiveEvent;
import com.streamscape.slex.file.SLFileInputStream;
import com.streamscape.slex.file.SLFileOutputStream;
import com.streamscape.tools.parser.ParserPositionalException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.lang.reflect.Array;
import java.nio.file.Paths;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class StatementCommand
extends Statement {
    Object[] parameters;
    NameManager.ObjectName logRecordName = null;

    public StatementCommand(int type, Object[] args) {
        this(type, args, null, null);
    }

    public StatementCommand(int type, Object[] args, NameManager.ObjectName[] readNames, NameManager.ObjectName[] writeNames) {
        super(type);
        this.isTransactionStatement = true;
        this.parameters = args;
        if (readNames != null) {
            this.readTableNames = readNames;
        }
        if (writeNames != null) {
            this.writeTableNames = writeNames;
        }
        switch (type) {
            case 3304: 
            case 3305: {
                this.references = new OrderedHashSet();
                this.group = 2014;
                this.isLogged = true;
                break;
            }
            case 1205: {
                this.references = new OrderedHashSet();
                this.group = 2014;
                this.references.add(this.parameters[0]);
                if (!(args[1] instanceof FileTable) && (!(args[1] instanceof Table) || !((Table)args[1]).isSessionBased)) break;
                this.isLogged = false;
                break;
            }
            case 3281: {
                this.references = new OrderedHashSet();
                if (((ReplicationEntityName)args[0]).isLocalNode()) {
                    this.group = 2014;
                    this.isTransactionStatement = true;
                    this.isLogged = true;
                    break;
                }
                this.group = 2017;
                this.isTransactionStatement = false;
                this.isLogged = false;
                break;
            }
            case 1191: {
                this.group = 2009;
                this.statementReturnType = 2;
                this.isTransactionStatement = false;
                this.isLogged = false;
                break;
            }
            case 1002: {
                this.group = 2014;
                this.isLogged = false;
                break;
            }
            case 1004: {
                String name = (String)this.parameters[0];
                if (name == null) {
                    this.statementReturnType = 2;
                }
                this.group = 2014;
                this.isLogged = false;
            }
            case 1025: 
            case 1026: {
                this.isTransactionStatement = false;
                this.group = 2013;
                break;
            }
            case 1015: {
                this.isTransactionStatement = false;
                this.group = 2013;
                break;
            }
            case 1011: 
            case 1012: 
            case 1013: 
            case 1014: 
            case 1016: 
            case 1018: 
            case 1019: 
            case 1020: 
            case 1023: 
            case 1024: 
            case 1027: 
            case 1028: 
            case 1029: 
            case 1033: 
            case 1034: 
            case 1036: 
            case 1038: 
            case 1039: 
            case 1040: 
            case 1041: 
            case 1044: 
            case 1045: 
            case 3080: 
            case 3140: 
            case 3211: 
            case 3212: {
                this.group = 2013;
                this.isTransactionStatement = true;
                break;
            }
            case 3283: {
                this.group = 2012;
                this.isLogged = false;
                this.isTransactionStatement = false;
                break;
            }
            case 1198: {
                this.group = 2012;
                break;
            }
            case 1196: {
                this.references = new OrderedHashSet();
                this.isLogged = false;
            }
            case 1195: 
            case 3262: {
                this.references = new OrderedHashSet();
                this.group = 2012;
                this.references.add((NameManager.ObjectName)this.parameters[0]);
                break;
            }
            case 3292: 
            case 3293: {
                this.references = new OrderedHashSet();
                this.group = 2012;
                this.references.add(((Collection)this.parameters[0]).getObjectName());
                break;
            }
            case 1194: {
                this.group = 2012;
                if (!((Table)this.parameters[0]).isSnapshot()) break;
                this.isLogged = false;
                break;
            }
            case 3217: 
            case 3218: 
            case 3219: 
            case 3272: 
            case 3273: 
            case 3274: {
                this.references = new OrderedHashSet();
                this.group = 2017;
                this.references.add(((AbstractCollection)this.parameters[0]).getObjectName());
                break;
            }
            case 1003: {
                this.group = 2014;
                this.isTransactionStatement = false;
                this.isLogged = false;
                break;
            }
            case 1197: {
                this.group = 2012;
                break;
            }
            case 1193: {
                this.group = 2013;
                this.isTransactionStatement = false;
                this.isLogged = false;
                break;
            }
            case 1060: 
            case 1061: 
            case 1062: {
                this.group = 2013;
                this.isTransactionStatement = false;
                break;
            }
            case 1005: {
                this.group = 2011;
                this.isTransactionStatement = false;
                this.isLogged = false;
                break;
            }
            case 3033: 
            case 3034: {
                this.references = new OrderedHashSet();
                this.group = 2017;
                this.isTransactionStatement = true;
                break;
            }
            case 3146: {
                this.group = 2017;
                this.isTransactionStatement = true;
                this.isLogged = false;
                break;
            }
            case 3017: 
            case 3025: 
            case 3027: 
            case 3028: 
            case 3038: 
            case 3048: 
            case 3049: 
            case 3053: 
            case 3055: 
            case 3056: 
            case 3057: 
            case 3058: 
            case 3074: 
            case 3075: 
            case 3076: 
            case 3077: 
            case 3078: 
            case 3079: 
            case 3081: 
            case 3083: 
            case 3086: 
            case 3087: 
            case 3092: 
            case 3093: 
            case 3109: 
            case 3119: 
            case 3121: 
            case 3122: 
            case 3130: 
            case 3144: 
            case 3153: 
            case 3157: 
            case 3171: 
            case 3180: 
            case 3183: 
            case 3186: 
            case 3187: 
            case 3197: 
            case 3199: 
            case 3200: 
            case 3206: 
            case 3255: 
            case 3261: 
            case 3289: 
            case 3296: 
            case 3297: 
            case 3301: 
            case 3302: 
            case 3318: 
            case 3343: {
                this.references = new OrderedHashSet();
                this.isTransactionStatement = false;
                this.isLogged = false;
                this.group = 2017;
                break;
            }
            case 3320: 
            case 3322: 
            case 3325: 
            case 3327: 
            case 3332: 
            case 3333: 
            case 3336: 
            case 3337: {
                this.references = new OrderedHashSet();
                this.isTransactionStatement = false;
                this.isLogged = false;
                this.group = 2017;
                break;
            }
            case 3286: {
                this.references = new OrderedHashSet();
                this.isTransactionStatement = false;
                this.isLogged = false;
                this.group = 2017;
                break;
            }
            case 3061: 
            case 3065: 
            case 3228: {
                this.references = new OrderedHashSet();
                this.isTransactionStatement = true;
                this.isLogged = false;
                this.group = 2017;
                break;
            }
            case 3165: 
            case 3166: {
                this.references = new OrderedHashSet();
                this.isTransactionStatement = true;
                this.isLogged = false;
                this.group = 2017;
                break;
            }
            case 3159: 
            case 3160: {
                this.references = new OrderedHashSet();
                this.isTransactionStatement = false;
                this.isLogged = true;
                this.group = 2017;
                break;
            }
            case 3012: 
            case 3013: 
            case 3015: 
            case 3016: 
            case 3069: 
            case 3070: 
            case 3088: 
            case 3090: 
            case 3091: 
            case 3096: 
            case 3097: 
            case 3098: 
            case 3099: 
            case 3111: 
            case 3147: 
            case 3148: 
            case 3149: 
            case 3150: 
            case 3151: 
            case 3152: 
            case 3226: 
            case 3282: 
            case 3316: {
                this.references = new OrderedHashSet();
                this.isTransactionStatement = true;
                this.isLogged = false;
                this.group = 2017;
                break;
            }
            case 3253: 
            case 3254: {
                this.references = new OrderedHashSet();
                this.isTransactionStatement = false;
                this.isLogged = true;
                this.group = 2017;
                break;
            }
            case 3227: {
                this.references = new OrderedHashSet();
                this.isTransactionStatement = false;
                this.isLogged = false;
                this.group = 2017;
                break;
            }
            case 3240: 
            case 3252: {
                this.references = new OrderedHashSet();
                this.isTransactionStatement = false;
                this.isLogged = false;
                this.group = 2017;
                break;
            }
            case 3188: 
            case 3220: 
            case 3248: 
            case 3249: {
                this.references = new OrderedHashSet();
                this.isTransactionStatement = ((ReplicationEntityName)args[0]).isLocalNode();
                this.isLogged = false;
                this.group = 2017;
                break;
            }
            case 3229: 
            case 3230: 
            case 3231: 
            case 3232: {
                this.references = new OrderedHashSet();
                if (((ReplicationEntityName)args[0]).isLocalNode()) {
                    this.isTransactionStatement = true;
                    this.isLogged = true;
                } else {
                    this.isTransactionStatement = false;
                    this.isLogged = false;
                }
                this.group = 2017;
                break;
            }
            case 3233: {
                this.references = new OrderedHashSet();
                this.isTransactionStatement = ((ReplicationEntityName)args[0]).isLocalNode();
                this.isLogged = false;
                this.group = 2017;
                break;
            }
            case 3010: 
            case 3011: {
                this.references = new OrderedHashSet();
                this.isTransactionStatement = true;
                this.isLogged = false;
                this.group = 2017;
                break;
            }
            case 3137: 
            case 3138: 
            case 3168: {
                this.references = new OrderedHashSet();
                this.isTransactionStatement = true;
                this.isLogged = false;
                this.group = 2017;
                break;
            }
            case 3050: 
            case 3051: {
                this.references = new OrderedHashSet();
                this.isTransactionStatement = false;
                this.isLogged = true;
                this.group = 2017;
                break;
            }
            case 3239: {
                this.references = new OrderedHashSet();
                this.isTransactionStatement = false;
                this.isLogged = false;
                this.group = 2017;
                break;
            }
            case 3181: 
            case 3182: {
                this.references = new OrderedHashSet();
                this.isTransactionStatement = true;
                this.isLogged = ((ReplicationEntityName)args[0]).isLocalNode();
                this.group = 2017;
                break;
            }
            case 3172: 
            case 3208: 
            case 3236: 
            case 3237: 
            case 3260: {
                this.references = new OrderedHashSet();
                this.isTransactionStatement = false;
                this.isLogged = false;
                this.group = 2017;
                break;
            }
            case 3173: 
            case 3174: 
            case 3175: {
                this.references = new OrderedHashSet();
                this.isTransactionStatement = false;
                this.isLogged = false;
                this.group = 2017;
                break;
            }
            case 3271: {
                this.references = new OrderedHashSet();
                this.isTransactionStatement = false;
                this.isLogged = false;
                this.group = 2017;
                break;
            }
            case 3275: {
                this.references = new OrderedHashSet();
                this.isTransactionStatement = false;
                this.isLogged = true;
                this.group = 2017;
                break;
            }
            case 3278: {
                this.references = new OrderedHashSet();
                this.isTransactionStatement = false;
                this.isLogged = false;
                this.group = 2017;
                break;
            }
            case 43: {
                this.references = new OrderedHashSet();
                this.isTransactionStatement = false;
                this.isLogged = false;
                this.group = 2017;
                break;
            }
            case 3312: {
                this.references = new OrderedHashSet();
                this.isTransactionStatement = true;
                this.isLogged = false;
                this.group = 2017;
                break;
            }
            case 3288: {
                this.references = new OrderedHashSet();
                this.isTransactionStatement = false;
                this.isLogged = false;
                this.group = 2017;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementCommand");
            }
        }
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
        }
        catch (Throwable t) {
            result = Result.newErrorResult(t, null);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
            return result;
        }
        try {
            if (this.isLogged) {
                LogRecordType recordType = LogRecordType.OTHER;
                if (this.type == 1195 || this.type == 3217 && this.type != 3272 || this.type == 3292) {
                    recordType = LogRecordType.LINK;
                } else if (this.type == 3262 || this.type == 3218 && this.type != 3273 || this.type == 3293) {
                    recordType = LogRecordType.UNLINK;
                }
                session.dataspaceStore.dataspaceLogger.writeOtherStatement(session, recordType, this.sql, this.logRecordName);
            }
        }
        catch (Throwable e) {
            return Result.newErrorResult(e, this.sql);
        }
        return result;
    }

    /*
     * Opcode count of 17327 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Result getResult(Session session) {
        if (this.isExplain) {
            return Result.newSingleColumnStringResult("OPERATION", this.describe(session));
        }
        switch (this.type) {
            case 1205: {
                return this.getTruncateResult(session);
            }
            case 3304: {
                NameManager.ObjectName schemaName = (NameManager.ObjectName)this.parameters[0];
                boolean online = (Boolean)this.parameters[1];
                DataspaceSchema schema = session.dataspaceStore.schemaManager.findSchema(schemaName.name);
                if (schema == null) {
                    throw new DataspaceException("Dataspace '" + schemaName.name + "' does not exist.");
                }
                schema.setOnline(online);
                return Result.updateNoResult;
            }
            case 3305: {
                NameManager.ObjectName schemaName = (NameManager.ObjectName)this.parameters[0];
                boolean started = (Boolean)this.parameters[1];
                DataspaceSchema schema = session.dataspaceStore.schemaManager.findSchema(schemaName.name);
                if (schema == null) {
                    throw new DataspaceException("Dataspace '" + schemaName.name + "' does not exist.");
                }
                schema.setStarted(started);
                return Result.updateNoResult;
            }
            case 3281: {
                ReplicationEntityName replicationEntityName = (ReplicationEntityName)this.parameters[0];
                if (replicationEntityName.isLocalNode()) {
                    this.parameters[0] = ((SchemaObject)this.parameters[1]).getObjectName();
                    return this.getTruncateResult(session);
                }
                ReplicationResponse replicaResponse = ReplicationUtil.sendSqlRequestTo(session, replicationEntityName, this.sql);
                if (replicaResponse.isOk()) return Result.updateNoResult;
                throw replicaResponse.getException();
            }
            case 1191: {
                boolean isJson = (Boolean)this.parameters[0];
                Statement statement = (Statement)this.parameters[1];
                if (!isJson) return Result.newSingleColumnStringResult("OPERATION", statement.describe(session));
                try {
                    Map<String, Object> o = statement.describeJson(session);
                    String json = DataspaceStore.getContext().getJSONSerializerFactory().createSerializerDefaultBuilderLazy("JSONSerializer$DataspaceExplain").apply(builder -> {
                        builder.setJsonNotation(JsonNotation.TYPE);
                        builder.setJsonNotationLevel(JsonNotationLevel.NONE);
                    }).getOrBuild().withPrettyPrint(true).serialize(o);
                    return Result.newSingleColumnStringResult("OPERATION", json);
                }
                catch (SerializerException e2) {
                    throw new RuntimeException(e2);
                }
            }
            case 1002: {
                boolean defrag = (Boolean)this.parameters[0];
                boolean auto = (Boolean)this.parameters[1];
                CheckpointManager.CheckpointStats.CheckpointAttempt checkpointAttempt = (CheckpointManager.CheckpointStats.CheckpointAttempt)this.parameters[3];
                Result result = null;
                try {
                    session.checkAdmin();
                    session.checkDDLWrite();
                    result = session.dataspaceStore.dataspaceLogger.checkpoint(defrag, checkpointAttempt);
                }
                catch (DataspaceException e3) {
                    try {
                        result = Result.newErrorResult(e3, this.sql);
                        if (checkpointAttempt == null || checkpointAttempt.isAuto()) return result;
                        checkpointAttempt.setSuccess(result != null && !result.isError());
                        checkpointAttempt.setEndTimestamp(System.currentTimeMillis());
                        session.dataspaceStore.checkpointManager.addCheckpointAttempt(checkpointAttempt);
                        session.dataspaceStore.checkpointManager.updateCheckpointResult(result);
                        return result;
                    }
                    catch (Throwable throwable) {
                        if (checkpointAttempt == null || checkpointAttempt.isAuto()) throw throwable;
                        checkpointAttempt.setSuccess(result != null && !result.isError());
                        checkpointAttempt.setEndTimestamp(System.currentTimeMillis());
                        session.dataspaceStore.checkpointManager.addCheckpointAttempt(checkpointAttempt);
                        session.dataspaceStore.checkpointManager.updateCheckpointResult(result);
                        throw throwable;
                    }
                }
                if (checkpointAttempt == null || checkpointAttempt.isAuto()) return result;
                checkpointAttempt.setSuccess(result != null && !result.isError());
                checkpointAttempt.setEndTimestamp(System.currentTimeMillis());
                session.dataspaceStore.checkpointManager.addCheckpointAttempt(checkpointAttempt);
                session.dataspaceStore.checkpointManager.updateCheckpointResult(result);
                return result;
            }
            case 1011: {
                try {
                    boolean mode = (Boolean)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.dataspaceStore.dataspaceLogger.setIncrementBackup(mode);
                    this.setProperty(session, "dtspace.incremental_backup", mode);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e4) {
                    return Result.newErrorResult(e4, this.sql);
                }
            }
            case 1012: {
                try {
                    int value = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.dataspaceStore.dataspaceLogger.setCacheMaxRows(value);
                    this.setProperty(session, "dtspace.cache_rows", value);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e5) {
                    return Result.newErrorResult(e5, this.sql);
                }
            }
            case 1013: {
                try {
                    int value = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.dataspaceStore.dataspaceLogger.setCacheSize(value);
                    this.setProperty(session, "dtspace.cache_size", value);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e6) {
                    return Result.newErrorResult(e6, this.sql);
                }
            }
            case 1016: {
                try {
                    int value = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (session.isProcessingLog) {
                        session.dataspaceStore.dataspaceLogger.setLobFileScaleNoCheck(value);
                    } else {
                        session.dataspaceStore.dataspaceLogger.setLobFileScale(value);
                    }
                    this.setProperty(session, "dtspace.lob_file_scale", value);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e7) {
                    return Result.newErrorResult(e7, this.sql);
                }
            }
            case 3080: {
                try {
                    boolean value = (Boolean)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    this.setProperty(session, "dtspace.lob_in_mem", value);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e8) {
                    return Result.newErrorResult(e8, this.sql);
                }
            }
            case 3211: {
                try {
                    boolean value = (Boolean)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    this.setProperty(session, "sql.string_precision", value);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e9) {
                    return Result.newErrorResult(e9, this.sql);
                }
            }
            case 3212: {
                try {
                    boolean value = (Boolean)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    this.setProperty(session, "dtspace.extended_sql_audit", value);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e10) {
                    return Result.newErrorResult(e10, this.sql);
                }
            }
            case 3140: {
                try {
                    String value = (String)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    this.setProperty(session, "dtspace.checkpoint_interval", value);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e11) {
                    return Result.newErrorResult(e11, this.sql);
                }
            }
            case 1023: {
                try {
                    int value = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (session.isProcessingLog) {
                        session.dataspaceStore.dataspaceLogger.setCacheFileScaleNoCheck(value);
                    } else {
                        session.dataspaceStore.dataspaceLogger.setCacheFileScale(value);
                    }
                    this.setProperty(session, "dtspace.cache_file_scale", value);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e12) {
                    return Result.newErrorResult(e12, this.sql);
                }
            }
            case 1014: {
                try {
                    int value = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.dataspaceStore.dataspaceLogger.setDefagLimit(value);
                    this.setProperty(session, "dtspace.defrag_limit", value);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e13) {
                    return Result.newErrorResult(e13, this.sql);
                }
            }
            case 1015: {
                try {
                    int value = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.dataspaceStore.dataspaceLogger.setEventLogLevel(value, false);
                    this.setProperty(session, "dtspace.applog", value);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e14) {
                    return Result.newErrorResult(e14, this.sql);
                }
            }
            case 1020: {
                try {
                    session.checkAdmin();
                    session.checkDDLWrite();
                    Object v = this.parameters[0];
                    if (v instanceof Boolean) {
                        boolean value = (Boolean)this.parameters[0];
                        session.dataspaceStore.dataspaceLogger.setNioDataFile(value);
                        this.setProperty(session, "dtspace.nio_data_file", value);
                        return Result.updateNoResult;
                    } else {
                        int value = (Integer)this.parameters[0];
                        session.dataspaceStore.dataspaceLogger.setNioMaxSize(value);
                        this.setProperty(session, "dtspace.nio_max_size", value);
                    }
                    return Result.updateNoResult;
                }
                catch (DataspaceException e15) {
                    return Result.newErrorResult(e15, this.sql);
                }
            }
            case 1018: {
                try {
                    boolean value = (Boolean)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.dataspaceStore.dataspaceLogger.setLogData(value);
                    this.setProperty(session, "dtspace.log_data", value);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e16) {
                    return Result.newErrorResult(e16, this.sql);
                }
            }
            case 1019: {
                try {
                    int value = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.dataspaceStore.dataspaceLogger.setLogSize(value * 1024 * 1024);
                    this.setProperty(session, "dtspace.log_size", value);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e17) {
                    return Result.newErrorResult(e17, this.sql);
                }
            }
            case 1024: {
                try {
                    String value = (String)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.dataspaceStore.dataspaceLogger.setScriptType(value);
                    this.setProperty(session, "dtspace.script_format", value);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e18) {
                    return Result.newErrorResult(e18, this.sql);
                }
            }
            case 1026: {
                try {
                    int value = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.dataspaceStore.dataspaceLogger.setWriteDelay(value);
                    this.setProperty(session, "dtspace.write_delay_millis", value);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e19) {
                    return Result.newErrorResult(e19, this.sql);
                }
            }
            case 1034: {
                try {
                    String name2 = (String)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.dataspaceStore.collation.setCollation(name2);
                    session.dataspaceStore.schemaManager.setSchemaChangeTimestamp();
                    return Result.updateNoResult;
                }
                catch (DataspaceException e20) {
                    return Result.newErrorResult(e20, this.sql);
                }
            }
            case 1036: {
                boolean mode = (Boolean)this.parameters[0];
                session.checkAdmin();
                session.checkDDLWrite();
                session.dataspaceStore.setReferentialIntegrity(mode);
                this.setProperty(session, "sql.ref_integrity", mode);
                return Result.updateNoResult;
            }
            case 1044: {
                String property = (String)this.parameters[0];
                boolean mode = (Boolean)this.parameters[1];
                int value = ((Number)this.parameters[2]).intValue();
                session.checkAdmin();
                session.checkDDLWrite();
                switch (property) {
                    case "sql.enforce_names": {
                        session.dataspaceStore.setStrictNames(mode);
                        break;
                    }
                    case "sql.enforce_size": {
                        session.dataspaceStore.setStrictColumnSize(mode);
                        break;
                    }
                    case "sql.enforce_types": {
                        session.dataspaceStore.setStrictTypes(mode);
                        break;
                    }
                    case "sql.enforce_refs": {
                        session.dataspaceStore.setStrictReferences(mode);
                        break;
                    }
                    case "sql.enforce_tdc_delete": {
                        session.dataspaceStore.setStrictTDCD(mode);
                        break;
                    }
                    case "sql.enforce_tdc_update": {
                        session.dataspaceStore.setStrictTDCU(mode);
                        break;
                    }
                    case "jdbc.translate_tti_types": {
                        session.dataspaceStore.setTranslateTTI(mode);
                        break;
                    }
                    case "sql.concat_nulls": {
                        session.dataspaceStore.setConcatNulls(mode);
                        break;
                    }
                    case "sql.unique_nulls": {
                        session.dataspaceStore.setUniqueNulls(mode);
                        break;
                    }
                    case "sql.convert_trunc": {
                        session.dataspaceStore.setConvertTrunc(mode);
                        break;
                    }
                    case "sql.avg_scale": {
                        session.dataspaceStore.setAvgScale(value);
                        break;
                    }
                    case "sql.double_nan": {
                        session.dataspaceStore.setDoubleNaN(mode);
                        break;
                    }
                    case "sql.longvar_is_lob": {
                        session.dataspaceStore.setLongVarIsLob(mode);
                        break;
                    }
                    case "sql.string_precision": {
                        session.dataspaceStore.setDefaultStringPrecision(value);
                        this.setProperty(session, property, value);
                        return Result.updateNoResult;
                    }
                }
                this.setProperty(session, property, mode);
                return Result.updateNoResult;
            }
            case 1027: {
                NameManager.ObjectName schema = (NameManager.ObjectName)this.parameters[0];
                session.checkAdmin();
                session.checkDDLWrite();
                session.dataspaceStore.schemaManager.setDefaultSchemaHsqlName(schema);
                session.dataspaceStore.schemaManager.setSchemaChangeTimestamp();
                this.setProperty(session, "dtspace.default_dataspace", schema.name);
                return Result.updateNoResult;
            }
            case 1028: {
                MemoryModel model = (MemoryModel)((Object)this.parameters[0]);
                session.checkAdmin();
                session.checkDDLWrite();
                session.dataspaceStore.schemaManager.setDefaultMemoryModel(model);
                this.setProperty(session, "dtspace.default_memory_model", model.name());
                return Result.updateNoResult;
            }
            case 1039: {
                try {
                    int mode = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.dataspaceStore.txManager.setTransactionControl(session, mode);
                    switch (mode) {
                        case 0: {
                            this.setProperty(session, "dtspace.tx_management", "LOCKS");
                            return Result.updateNoResult;
                        }
                        case 2: {
                            this.setProperty(session, "dtspace.tx_management", "MVCC");
                            return Result.updateNoResult;
                        }
                        case 1: {
                            this.setProperty(session, "dtspace.tx_management", "MVLOCKS");
                        }
                    }
                    return Result.updateNoResult;
                }
                catch (DataspaceException e21) {
                    return Result.newErrorResult(e21, this.sql);
                }
            }
            case 1040: {
                try {
                    int mode = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.dataspaceStore.defaultIsolationLevel = mode;
                    this.setProperty(session, "dtspace.tx_isolation_level", mode == 8 ? "SERIALIZABLE" : "READ_COMMITTED");
                    return Result.updateNoResult;
                }
                catch (DataspaceException e22) {
                    return Result.newErrorResult(e22, this.sql);
                }
            }
            case 1029: {
                try {
                    int count = (Integer)this.parameters[0];
                    session.checkAdmin();
                    JavaSystem.gcFrequency = count;
                    this.setProperty(session, "runtime.gc_interval", count);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e23) {
                    return Result.newErrorResult(e23, this.sql);
                }
            }
            case 1033: {
                int size = (Integer)this.parameters[0];
                session.checkAdmin();
                session.dataspaceStore.setResultMaxMemoryRows(size);
                this.setProperty(session, "dtspace.result_max_memory_rows", size);
                return Result.updateNoResult;
            }
            case 1038: {
                try {
                    int currentValue;
                    int currentValue2;
                    int currentValue3;
                    int currentValue4;
                    int currentValue5;
                    int currentValue6;
                    int currentValue7;
                    int newValue;
                    Boolean isAllQuoted;
                    Boolean isQuoted;
                    Boolean ignoreFirst;
                    String lvs;
                    String vs;
                    String source = (String)this.parameters[0];
                    BaseStoreProperties props = null;
                    session.checkAdmin();
                    if (source.length() > 0 && (props = BaseStoreProperties.delimitedArgPairsToProps(source, "=", ";", null)).getErrorKeys().length > 0) {
                        throw Error.error(482, props.getErrorKeys()[0]);
                    }
                    String fs = props.getProperty("file.fs");
                    if (fs != null) {
                        session.dataspaceStore.dataspaceStoreProperties.setProperty("file.fs", fs);
                    }
                    if ((vs = props.getProperty("file.vs")) != null) {
                        session.dataspaceStore.dataspaceStoreProperties.setProperty("file.vs", vs);
                    }
                    if ((lvs = props.getProperty("file.lvs")) != null) {
                        session.dataspaceStore.dataspaceStoreProperties.setProperty("file.lvs", lvs);
                    }
                    if (props.isPropertyExist("file.ignore_first") && (ignoreFirst = Boolean.valueOf(props.isPropertyTrue("file.ignore_first"))) != null) {
                        session.dataspaceStore.dataspaceStoreProperties.setProperty("file.ignore_first", ignoreFirst);
                    }
                    if (props.isPropertyExist("file.ignore_first_lines")) {
                        int ignoreFirstLines = props.getIntegerProperty("file.ignore_first_lines", 0);
                        session.dataspaceStore.dataspaceStoreProperties.setProperty("file.ignore_first_lines", ignoreFirstLines);
                    }
                    if (props.isPropertyExist("file.quoted") && (isQuoted = Boolean.valueOf(props.isPropertyTrue("file.quoted"))) != null) {
                        session.dataspaceStore.dataspaceStoreProperties.setProperty("file.quoted", isQuoted);
                    }
                    if (props.isPropertyExist("file.all_quoted") && (isAllQuoted = Boolean.valueOf(props.isPropertyTrue("file.all_quoted"))) != null) {
                        session.dataspaceStore.dataspaceStoreProperties.setProperty("file.all_quoted", isAllQuoted);
                    }
                    if (props.isPropertyExist("file.cache_rows") && (newValue = props.getIntegerProperty("file.cache_rows", currentValue7 = session.dataspaceStore.dataspaceStoreProperties.getIntegerProperty("file.cache_rows"))) != currentValue7) {
                        session.dataspaceStore.dataspaceStoreProperties.setProperty("file.cache_rows", newValue);
                    }
                    if (props.isPropertyExist("file.cache_scale") && (newValue = props.getIntegerProperty("file.cache_scale", currentValue6 = session.dataspaceStore.dataspaceStoreProperties.getIntegerProperty("file.cache_scale"))) != currentValue6) {
                        session.dataspaceStore.dataspaceStoreProperties.setProperty("file.cache_scale", newValue);
                    }
                    if (props.isPropertyExist("file.cache_size") && (newValue = props.getIntegerProperty("file.cache_size", currentValue5 = session.dataspaceStore.dataspaceStoreProperties.getIntegerProperty("file.cache_size"))) != currentValue5) {
                        session.dataspaceStore.dataspaceStoreProperties.setProperty("file.cache_size", newValue);
                    }
                    if (props.isPropertyExist("file.cache_size_scale") && (newValue = props.getIntegerProperty("file.cache_size_scale", currentValue4 = session.dataspaceStore.dataspaceStoreProperties.getIntegerProperty("file.cache_size_scale"))) != currentValue4) {
                        session.dataspaceStore.dataspaceStoreProperties.setProperty("file.cache_size_scale", newValue);
                    }
                    if (props.isPropertyExist("file.compression_block_size") && (newValue = props.getIntegerProperty("file.compression_block_size", currentValue3 = session.dataspaceStore.dataspaceStoreProperties.getIntegerProperty("file.compression_block_size"))) != currentValue3) {
                        session.dataspaceStore.dataspaceStoreProperties.setProperty("file.compression_block_size", newValue);
                    }
                    if (props.isPropertyExist("file.file_table_ignore_unknown_records") && (newValue = (int)(props.isPropertyTrue("file.file_table_ignore_unknown_records", (currentValue2 = session.dataspaceStore.dataspaceStoreProperties.isPropertyTrue("file.file_table_ignore_unknown_records")) != 0) ? 1 : 0)) != currentValue2) {
                        session.dataspaceStore.dataspaceStoreProperties.setProperty("file.file_table_ignore_unknown_records", newValue != 0);
                    }
                    if (props.isPropertyExist("file.read_buffer_size") && (newValue = props.getIntegerProperty("file.read_buffer_size", currentValue = session.dataspaceStore.dataspaceStoreProperties.getIntegerProperty("file.read_buffer_size"))) != currentValue) {
                        session.dataspaceStore.dataspaceStoreProperties.setProperty("file.read_buffer_size", newValue);
                    }
                    session.dataspaceStore.persistStoreState();
                    return Result.updateNoResult;
                }
                catch (DataspaceException e24) {
                    return Result.newErrorResult(e24, this.sql);
                }
            }
            case 1041: {
                try {
                    boolean value = (Boolean)this.parameters[0];
                    session.checkAdmin();
                    session.dataspaceStore.dataspaceLogger.propTextAllowFullPath = value;
                    this.setProperty(session, "file.allow_full_path", value);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e25) {
                    return Result.newErrorResult(e25, this.sql);
                }
            }
            case 1004: {
                ScriptWriterText dsw = null;
                String name3 = (String)this.parameters[0];
                try {
                    session.checkAdmin();
                    if (name3 == null) {
                        return session.dataspaceStore.getScript(false);
                    }
                    dsw = new ScriptWriterText(session.dataspaceStore, name3, true, true, true);
                    dsw.writeAll(null);
                    dsw.close();
                    return Result.updateNoResult;
                }
                catch (DataspaceException e26) {
                    return Result.newErrorResult(e26, this.sql);
                }
            }
            case 1198: {
                try {
                    NameManager.ObjectName name4 = (NameManager.ObjectName)this.parameters[0];
                    int[] colIndex = (int[])this.parameters[1];
                    Table table = session.dataspaceStore.schemaManager.getTable(session, name4.name, name4.schema.name);
                    StatementSchema.checkSchemaUpdateAuthorisation(session, table.getSchemaName());
                    if (!table.isCached() && !table.isText()) {
                        throw Error.error(457);
                    }
                    Index index = table.getIndexForColumns(session, colIndex);
                    if (index == null) return Result.updateNoResult;
                    Index[] indexes = table.getIndexList();
                    for (int i = 0; i < indexes.length; ++i) {
                        indexes[i].setClustered(false);
                    }
                    index.setClustered(true);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e27) {
                    return Result.newErrorResult(e27, this.sql);
                }
            }
            case 1193: {
                try {
                    NameManager.ObjectName name5 = (NameManager.ObjectName)this.parameters[0];
                    String value = (String)this.parameters[1];
                    Table table = session.dataspaceStore.schemaManager.getTable(session, name5.name, name5.schema.name);
                    if (!session.isProcessingLog()) return Result.updateNoResult;
                    table.setIndexRoots(session, value);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e28) {
                    return Result.newErrorResult(e28, this.sql);
                }
            }
            case 1194: {
                try {
                    Table table = (Table)this.parameters[0];
                    boolean mode = (Boolean)this.parameters[1];
                    StatementSchema.checkSchemaUpdateAuthorisation(session, table.getSchemaName());
                    table.setDataReadOnly(mode);
                    session.dataspaceStore.schemaManager.setSchemaChangeTimestamp();
                    return Result.updateNoResult;
                }
                catch (DataspaceException e29) {
                    return Result.newErrorResult(e29, this.sql);
                }
            }
            case 1195: 
            case 3262: {
                try {
                    NameManager.ObjectName name6 = (NameManager.ObjectName)this.parameters[0];
                    Table table = session.dataspaceStore.schemaManager.getTable(session, name6.name, name6.schema.name);
                    if (table instanceof FileTable && ((FileTable)table).getParent() instanceof JournalFileTable) {
                        throw new DataspaceException("Link/unlink operations is not allowed for JFT. Use start/stop instead.");
                    }
                    StatementSchema.checkSchemaUpdateAuthorisation(session, table.getSchemaName());
                    if (!table.isText()) {
                        return Result.newErrorResult(Error.error(321), this.sql);
                    }
                    this.logRecordName = name6;
                    if (this.parameters.length == 1) {
                        if (this.type == 1195) {
                            if (((FileTable)table).getDataSource() == null || ((FileTable)table).getDataSource().length() == 0) {
                                throw new DataspaceException("File table data source is not set.");
                            }
                            ((FileTable)table).connect(session);
                            String fullSql = ((FileTable)table).getDataSourceDDL();
                            if (fullSql != null) {
                                this.sql = fullSql;
                            }
                        } else {
                            ((FileTable)table).disconnect();
                        }
                        session.dataspaceStore.schemaManager.setSchemaChangeTimestamp();
                        return Result.updateNoResult;
                    }
                    String source = (String)this.parameters[1];
                    boolean isReadOnly = (Boolean)this.parameters[2];
                    boolean forStream = (Boolean)this.parameters[3];
                    boolean forAppend = (Boolean)this.parameters[4];
                    long checkInterval = ((Number)this.parameters[5]).longValue();
                    if (source == null || source.length() == 0) {
                        throw new DataspaceException("File table data source is empty.");
                    }
                    if (forAppend) {
                        isReadOnly = true;
                    }
                    ((FileTable)table).setDataSource(session, source);
                    ((FileTable)table).setDataReadOnly(isReadOnly);
                    ((FileTable)table).connect(session, isReadOnly, forStream, forAppend, checkInterval);
                    return Result.updateNoResult;
                }
                catch (Throwable e302) {
                    DataspaceException e302;
                    if (!(e302 instanceof DataspaceException)) {
                        e302 = Error.error(467, e302.toString());
                    }
                    if (!session.isProcessingRecoveryLog() && !session.isProcessingLog()) return Result.newErrorResult(e302, this.sql);
                    session.addWarning(e302);
                    session.dataspaceStore.dataspaceLogger.logWarningEvent("Problem processing LINK/UNLINK FILE TABLE", e302);
                    return Result.updateNoResult;
                }
            }
            case 1196: {
                try {
                    NameManager.ObjectName name7 = (NameManager.ObjectName)this.parameters[0];
                    Table table = session.dataspaceStore.schemaManager.getTable(session, name7.name, name7.schema.name);
                    if (table instanceof FileTable && ((FileTable)table).getParent() instanceof JournalFileTable) {
                        throw new DataspaceException("Link/unlink/set operations is not allowed for JFT. Use start/stop instead.");
                    }
                    StatementSchema.checkSchemaUpdateAuthorisation(session, table.getSchemaName());
                    if (!table.isText()) {
                        return Result.newErrorResult(Error.error(321), this.sql);
                    }
                    ((FileTable)table).setHeader((String)this.parameters[1]);
                    return Result.updateNoResult;
                }
                catch (Throwable e312) {
                    if (e312 instanceof DataspaceException) return Result.newErrorResult(e312, this.sql);
                    DataspaceException e312 = Error.error(467, e312.toString());
                    return Result.newErrorResult(e312, this.sql);
                }
            }
            case 3217: {
                try {
                    JournalFileTableCollection collection = (JournalFileTableCollection)this.parameters[0];
                    String filename = (String)this.parameters[1];
                    Long checkInterval = (Long)this.parameters[2];
                    JournalFileTableCollection.ProcessingStrategy processingStrategy = (JournalFileTableCollection.ProcessingStrategy)((Object)this.parameters[3]);
                    Boolean suspendOnFail = (Boolean)this.parameters[4];
                    long startSeqId = (Long)this.parameters[5];
                    long startTimestamp = (Long)this.parameters[6];
                    if (filename != null) {
                        collection.setDataSource(session, filename);
                    }
                    if (checkInterval != -1L) {
                        collection.setCheckInterval(session, checkInterval);
                    }
                    collection.setProcessingStrategy(session, processingStrategy, startSeqId, startTimestamp);
                    collection.setSuspendOnFail(session, suspendOnFail);
                    collection.start(session);
                    if (processingStrategy != null && processingStrategy != JournalFileTableCollection.ProcessingStrategy.DEFAULT) {
                        this.sql = "start journal file table " + collection.getObjectName().getSchemaQualifiedStatementName();
                        if (suspendOnFail.booleanValue()) {
                            this.sql = this.sql + " suspend on fail";
                        }
                    }
                    this.logRecordName = collection.getObjectName();
                    return Result.updateNoResult;
                }
                catch (Throwable exception2) {
                    if (exception2 instanceof DataspaceException) return Result.newErrorResult(exception2, this.sql);
                    DataspaceException exception2 = Error.error(467, exception2.toString());
                    return Result.newErrorResult(exception2, this.sql);
                }
            }
            case 3218: {
                try {
                    JournalFileTableCollection collection = (JournalFileTableCollection)this.parameters[0];
                    collection.stop(session);
                    this.logRecordName = collection.getObjectName();
                    return Result.updateNoResult;
                }
                catch (Throwable exception3) {
                    if (exception3 instanceof DataspaceException) return Result.newErrorResult(exception3, this.sql);
                    DataspaceException exception3 = Error.error(467, exception3.toString());
                    return Result.newErrorResult(exception3, this.sql);
                }
            }
            case 3219: {
                try {
                    JournalFileTableCollection collection = (JournalFileTableCollection)this.parameters[0];
                    collection.resume(session);
                    this.logRecordName = collection.getObjectName();
                    return Result.updateNoResult;
                }
                catch (Throwable exception4) {
                    if (exception4 instanceof DataspaceException) return Result.newErrorResult(exception4, this.sql);
                    DataspaceException exception4 = Error.error(467, exception4.toString());
                    return Result.newErrorResult(exception4, this.sql);
                }
            }
            case 3272: {
                try {
                    LogFileTableCollection collection = (LogFileTableCollection)this.parameters[0];
                    String filename = (String)this.parameters[1];
                    Long checkInterval = (Long)this.parameters[2];
                    LogFileTableCollection.ProcessingStrategy processingStrategy = (LogFileTableCollection.ProcessingStrategy)((Object)this.parameters[3]);
                    Boolean suspendOnFail = (Boolean)this.parameters[4];
                    long startRecordOffset = (Long)this.parameters[5];
                    long startRecordTimestamp = (Long)this.parameters[6];
                    String rotationFileRegexp = (String)this.parameters[7];
                    if (session.isProcessingRecoveryLog() || session.isProcessingLog()) {
                        if (filename != null) {
                            collection.setDataSource(session, filename);
                            collection.setRotationFileRegexp(rotationFileRegexp);
                        }
                        if (rotationFileRegexp != null) {
                            collection.setRotationFileRegexp(rotationFileRegexp);
                        }
                        collection.setSuspendOnFail(session, suspendOnFail);
                        collection.setNeedToStart(true);
                        return Result.updateNoResult;
                    } else {
                        if (collection.isStarted()) {
                            throw new DataspaceException("Log file table already started.");
                        }
                        if (filename != null) {
                            if (collection.getSourceFileName() == null || !Paths.get(filename, new String[0]).toAbsolutePath().toString().equals(Paths.get(collection.getSourceFileName(), new String[0]).toAbsolutePath().toString())) {
                                collection.setLogFileTableProperties(-1L, -1L, false);
                            }
                            collection.setDataSource(session, filename);
                            collection.setRotationFileRegexp(rotationFileRegexp);
                        }
                        if (rotationFileRegexp != null) {
                            collection.setRotationFileRegexp(rotationFileRegexp);
                        }
                        if (checkInterval != -1L) {
                            collection.setCheckInterval(session, checkInterval);
                        }
                        collection.setProcessingStrategy(session, processingStrategy, startRecordOffset, startRecordTimestamp);
                        collection.setSuspendOnFail(session, suspendOnFail);
                        collection.start(session);
                        if (processingStrategy != null && processingStrategy != LogFileTableCollection.ProcessingStrategy.DEFAULT) {
                            this.sql = collection.getStartLogFileTableSQL();
                        }
                        this.logRecordName = collection.getObjectName();
                    }
                    return Result.updateNoResult;
                }
                catch (Throwable exception5) {
                    if (exception5 instanceof DataspaceException) return Result.newErrorResult(exception5, this.sql);
                    DataspaceException exception5 = Error.error(467, exception5.toString());
                    return Result.newErrorResult(exception5, this.sql);
                }
            }
            case 3273: {
                try {
                    LogFileTableCollection collection = (LogFileTableCollection)this.parameters[0];
                    if (session.isProcessingLog() || session.isProcessingRecoveryLog()) {
                        collection.setNeedToStart(false);
                    } else {
                        collection.stop(session);
                    }
                    this.logRecordName = collection.getObjectName();
                    return Result.updateNoResult;
                }
                catch (Throwable exception6) {
                    if (exception6 instanceof DataspaceException) return Result.newErrorResult(exception6, this.sql);
                    DataspaceException exception6 = Error.error(467, exception6.toString());
                    return Result.newErrorResult(exception6, this.sql);
                }
            }
            case 3274: {
                try {
                    LogFileTableCollection collection = (LogFileTableCollection)this.parameters[0];
                    collection.resume(session);
                    this.logRecordName = collection.getObjectName();
                    return Result.updateNoResult;
                }
                catch (Throwable exception7) {
                    if (exception7 instanceof DataspaceException) return Result.newErrorResult(exception7, this.sql);
                    DataspaceException exception7 = Error.error(467, exception7.toString());
                    return Result.newErrorResult(exception7, this.sql);
                }
            }
            case 3086: {
                try {
                    NameManager.ObjectName name8 = (NameManager.ObjectName)this.parameters[0];
                    Table table = session.dataspaceStore.schemaManager.getTable(session, name8.name, name8.schema.name);
                    StatementSchema.checkSchemaUpdateAuthorisation(session, table.getSchemaName());
                    if (!table.isText()) {
                        DataspaceException e32 = Error.error(321);
                        return Result.newErrorResult(e32, this.sql);
                    }
                    ((FileTable)table).compress(session);
                    session.dataspaceStore.schemaManager.setSchemaChangeTimestamp();
                    return Result.updateNoResult;
                }
                catch (Throwable e332) {
                    if (e332 instanceof DataspaceException) return Result.newErrorResult(e332, this.sql);
                    DataspaceException e332 = Error.error(467, e332.toString());
                    return Result.newErrorResult(e332, this.sql);
                }
            }
            case 3096: {
                try {
                    Collection collection = (Collection)this.parameters[0];
                    String fileName = (String)this.parameters[2];
                    Boolean compressed = (Boolean)this.parameters[3];
                    boolean ignoreErrors = (Boolean)this.parameters[4];
                    Boolean verbose = (Boolean)this.parameters[11];
                    Boolean noData = (Boolean)this.parameters[8];
                    boolean withWait = (Boolean)this.parameters[13];
                    long limit = (Long)this.parameters[15];
                    List packages = (List)this.parameters[18];
                    List includeObjects = (List)this.parameters[5];
                    List excludeObjects = (List)this.parameters[6];
                    SchemaDumper dumper = new SchemaDumper(session, fileName, compressed, includeObjects, excludeObjects);
                    dumper.setVerbose(verbose);
                    dumper.setNoData(noData);
                    dumper.setLimit(limit);
                    dumper.setPackages(packages);
                    dumper.setIgnoreErrors(ignoreErrors);
                    Result result = withWait ? Result.updateNoResult : ResultPseudo.emptyResult;
                    dumper.dumpCollection(collection, withWait);
                    session.dataspaceStore.schemaManager.setSchemaChangeTimestamp();
                    return result;
                }
                catch (Throwable e342) {
                    if (e342 instanceof DataspaceException) return Result.newErrorResult(e342, this.sql);
                    DataspaceException e342 = Error.error(467, e342.toString());
                    return Result.newErrorResult(e342, this.sql);
                }
            }
            case 3097: {
                try {
                    String collectionName = (String)this.parameters[1];
                    String mergeMode = (String)this.parameters[9];
                    if (collectionName == null && this.parameters[0] != null) {
                        collectionName = ((SchemaObject)this.parameters[0]).getObjectName().name;
                    }
                    String fileName = (String)this.parameters[2];
                    Boolean compressed = (Boolean)this.parameters[3];
                    Boolean ignoreErrors = (Boolean)this.parameters[4];
                    boolean verbose = (Boolean)this.parameters[11];
                    boolean withWait = (Boolean)this.parameters[13];
                    Map additionalOptions = (Map)this.parameters[17];
                    SchemaLoader schemaLoader = new SchemaLoader(session, fileName, compressed);
                    schemaLoader.setMergeMode(SchemaLoader.MergeMode.valueOf(mergeMode));
                    schemaLoader.setVerbose(verbose);
                    schemaLoader.setIgnoreErrors(ignoreErrors);
                    boolean global = true;
                    Object globalVal = additionalOptions.get("packagesGlobal");
                    if (globalVal != null) {
                        global = (Boolean)globalVal;
                    }
                    schemaLoader.setArtifactGlobal(global);
                    Boolean ignoreFlobs = (Boolean)additionalOptions.get("IGNOREFLOBS");
                    if (ignoreFlobs == null) {
                        ignoreFlobs = false;
                    }
                    schemaLoader.setIgnoreFlobs(ignoreFlobs);
                    Result result = withWait ? Result.updateNoResult : ResultPseudo.emptyResult;
                    int memoryModel = 0;
                    String newName = null;
                    if (additionalOptions != null) {
                        if (additionalOptions.get("newMemoryModel") != null) {
                            memoryModel = (Integer)additionalOptions.get("newMemoryModel");
                        }
                        newName = (String)additionalOptions.get("newCollectionName");
                    }
                    schemaLoader.loadCollection(collectionName, withWait, memoryModel, newName);
                    session.dataspaceStore.schemaManager.setSchemaChangeTimestamp();
                    return result;
                }
                catch (Throwable e352) {
                    if (e352 instanceof DataspaceException) return Result.newErrorResult(e352, this.sql);
                    DataspaceException e352 = Error.error(467, e352.toString());
                    return Result.newErrorResult(e352, this.sql);
                }
            }
            case 3227: {
                try {
                    FileDescriptor fileDescriptor = (FileDescriptor)this.parameters[0];
                    final Table sourceTable = (Table)this.parameters[1];
                    String filePath = (String)this.parameters[2];
                    final int unitSize = (Integer)this.parameters[3];
                    final boolean metaset = (Boolean)this.parameters[4];
                    final Set metasetOperations = (Set)this.parameters[5];
                    final ReplicationSource replicationSource = sourceTable.getReplicationSource();
                    if (replicationSource == null) {
                        throw new DataspaceException("Replication source is null.");
                    }
                    if (!replicationSource.isEnabled()) {
                        throw new DataspaceException("Replication source should be enabled to load replication queue.");
                    }
                    try (final Session localSession = session.dataspaceStore.getSessionManager().newSession(session.dataspaceStore, session.getUser(), false, false);){
                        List<ReplicaInfo> list = replicationSource.listReplicas(localSession);
                        if (list == null || list.stream().filter(info -> info.getState() != ReplicaState.DROPPED && info.getState() != ReplicaState.EVICTED).count() == 0L) {
                            throw new DataspaceException("At least one replica should be created on source to load replication queue.");
                        }
                        localSession.commit(false);
                        FileDescriptorFactory factory = new FileDescriptorFactory();
                        factory.init(fileDescriptor, DataspaceStoreManager.getRuntimeContext().getSystemClassLoaderChain(), DataspaceStoreManager.getRuntimeContext());
                        FileRecordsReader reader = factory.createFileRecordsReader();
                        final int[] counter = new int[1];
                        final Object[][] xObj = new Object[1][];
                        reader.setRecordListener(new FileDescriptorFactory.RecordListener(){

                            @Override
                            public void onRecord(Object recordObject, AbstractRecordTypeDefinition recordDefinition) {
                                Object[] dataArray;
                                int operation;
                                if (counter[0] == 0) {
                                    localSession.startTransaction();
                                }
                                if (!metaset) {
                                    if (metasetOperations.contains(135)) {
                                        operation = 135;
                                    } else if (metasetOperations.contains(79)) {
                                        operation = 79;
                                    } else {
                                        throw new DataspaceException("Wrong operation type.");
                                    }
                                    dataArray = ((ArrayList)recordObject).toArray();
                                } else {
                                    String operationChar;
                                    ArrayList initialRow = (ArrayList)recordObject;
                                    dataArray = initialRow.subList(3, initialRow.size()).toArray();
                                    switch (operationChar = (String)initialRow.get(2)) {
                                        case "I": {
                                            operation = 135;
                                            break;
                                        }
                                        case "U": {
                                            operation = 303;
                                            break;
                                        }
                                        case "X": {
                                            operation = 842;
                                            break;
                                        }
                                        case "D": {
                                            operation = 79;
                                            break;
                                        }
                                        default: {
                                            throw new DataspaceException("Wrong operation type.");
                                        }
                                    }
                                }
                                ArrayList<Object> tmpDataArray = new ArrayList<Object>();
                                for (Object o : dataArray) {
                                    if (o instanceof Timestamp) {
                                        o = new TimestampData(((Timestamp)o).getTime(), ((Timestamp)o).getNanos());
                                    }
                                    tmpDataArray.add(o);
                                }
                                dataArray = tmpDataArray.toArray();
                                if (operation == 135) {
                                    replicationSource.onInsert(localSession, dataArray, null);
                                } else if (operation == 79) {
                                    replicationSource.onDelete(localSession, sourceTable, dataArray, false, null);
                                } else if (operation == 842) {
                                    xObj[0] = dataArray;
                                } else if (operation == 303) {
                                    if (xObj[0] == null) {
                                        throw new DataspaceException("Wrong sequence of records");
                                    }
                                    replicationSource.onUpdate(localSession, sourceTable, xObj[0], dataArray, false, null);
                                    xObj[0] = null;
                                }
                                counter[0] = counter[0] + 1;
                                if (counter[0] > unitSize && xObj[0] == null) {
                                    replicationSource.onBeforeCommit(localSession);
                                    localSession.commit(false);
                                    replicationSource.onAfterCommit(localSession);
                                    counter[0] = 0;
                                }
                            }

                            @Override
                            public void onGroupRecord(Object recordObject, String type, String key) {
                            }
                        });
                        reader.setExceptionStrategy(e -> {
                            throw Error.error(467, e.toString());
                        });
                        InputStream inputStreamBuf = null;
                        try {
                            inputStreamBuf = SessionData.createFileInputStream(session, filePath, false, false, null);
                            if (inputStreamBuf instanceof SLFileInputStream) {
                                ((SLFileInputStream)inputStreamBuf).setVerbose(false);
                            }
                            inputStreamBuf = new BufferedInputStream(inputStreamBuf, 16384);
                            FileLinesReader fileLinesReader = factory.createFileLinesReader(inputStreamBuf, null, true);
                            reader.readSingleFile(fileLinesReader);
                            if (counter[0] <= 0 && !localSession.isTransaction) return Result.updateNoResult;
                            replicationSource.onBeforeCommit(localSession);
                            localSession.commit(false);
                            replicationSource.onAfterCommit(localSession);
                            return Result.updateNoResult;
                        }
                        finally {
                            replicationSource.onAfterCommitConfirm(localSession);
                            if (inputStreamBuf != null) {
                                inputStreamBuf.close();
                            }
                        }
                    }
                }
                catch (Throwable e362) {
                    if (e362 instanceof DataspaceException) return Result.newErrorResult(e362, this.sql);
                    DataspaceException e362 = Error.error(467, e362.toString());
                    return Result.newErrorResult(e362, this.sql);
                }
            }
            case 3226: {
                try {
                    FileDescriptor fileDescriptor = (FileDescriptor)this.parameters[0];
                    Table sourceTable = (Table)this.parameters[1];
                    String filePath = (String)this.parameters[2];
                    int unitSize = (Integer)this.parameters[3];
                    boolean metaset = (Boolean)this.parameters[4];
                    Set metasetOperations = (Set)this.parameters[5];
                    ReplicationSource replicationSource = sourceTable.getReplicationSource();
                    if (replicationSource == null) {
                        throw new DataspaceException("Replication source is null.");
                    }
                    if (!replicationSource.isEnabled()) {
                        throw new DataspaceException("Replication source should be enabled to load replication queue.");
                    }
                    Function<TimestampData, Timestamp> convertTimestampData = td -> {
                        Timestamp t = new Timestamp(td.getMilliseconds());
                        t.setNanos(td.getNanos());
                        return t;
                    };
                    List<ReplicaInfo> list = replicationSource.listReplicas(session);
                    if (list == null || list.stream().filter(info -> info.getState() != ReplicaState.DROPPED && info.getState() != ReplicaState.EVICTED).count() == 0L) {
                        throw new DataspaceException("At least one replica should be created on source to load replication queue.");
                    }
                    FileDescriptorFactory factory = new FileDescriptorFactory();
                    factory.init(fileDescriptor, DataspaceStoreManager.getRuntimeContext().getSystemClassLoaderChain(), DataspaceStoreManager.getRuntimeContext());
                    NameManager.ObjectName sourceTableName = sourceTable.getObjectName();
                    JournalFileQueueTable repQueueStorage = (JournalFileQueueTable)replicationSource.getReplicationQueue().getReplicationQueueStorage();
                    long minHeldReplicationId = Long.MAX_VALUE;
                    for (ReplicaInfo replicaInfo2 : list) {
                        if (replicaInfo2.getReplicationId() < 0L) continue;
                        minHeldReplicationId = Math.min(minHeldReplicationId, replicaInfo2.getReplicationId());
                    }
                    long currentReplicationId = minHeldReplicationId;
                    int batchSize = 1000;
                    long operationIndex = 1L;
                    OutputStream outputStream = null;
                    try (Writer dumpWriter = null;
                         FileQueueFilesManager.FileQueueDataReader dataReader = repQueueStorage.getFilesManager().createDataReader();){
                        outputStream = SessionData.createFileOutputStream(session, filePath, true, false);
                        if (outputStream instanceof SLFileOutputStream) {
                            ((SLFileOutputStream)outputStream).setVerbose(false);
                        }
                        dumpWriter = new OutputStreamWriter(outputStream);
                        FileRecordsWriter writer = factory.createFileRecordsWriter(dumpWriter);
                        while (!Thread.currentThread().isInterrupted()) {
                            dataReader.seekToFirst(new ReplicationQueueFileBased.ReplicationQueueReplicationIdComparator(currentReplicationId + 1L), new ReplicationQueueFileBased.ReplicationQueueReplicationIdIndexes(), FileQueueFilesManager.SeekType.LESS_EQUALS_OR_NEXT);
                            Object[][] batchArray = dataReader.readNextBatch(batchSize);
                            if (batchArray.length == 0) {
                                return Result.updateNoResult;
                            }
                            for (Object[] row : batchArray) {
                                ReplicationDataTransaction transaction = (ReplicationDataTransaction)OtherTypeWrapper.unwrap(row[2]);
                                for (ReplicationData data : transaction.getData()) {
                                    ArrayList<Object> rowList;
                                    if (data.getOperationType().equals((Object)ReplicationOperationType.INSERT) && !metasetOperations.contains(135) || data.getOperationType().equals((Object)ReplicationOperationType.UPDATE) && !metasetOperations.contains(303) || data.getOperationType().equals((Object)ReplicationOperationType.DELETE) && !metasetOperations.contains(79)) continue;
                                    if (data.getOperationType().equals((Object)ReplicationOperationType.UPDATE)) {
                                        rowList = new ArrayList<Object>();
                                        if (metaset) {
                                            Object[] oldData = (Object[])data.getRow()[0];
                                            rowList.add(operationIndex++);
                                            rowList.add(new Timestamp(System.currentTimeMillis()));
                                            rowList.add("X");
                                            for (Object o : oldData) {
                                                if (o instanceof TimestampData) {
                                                    o = convertTimestampData.apply((TimestampData)o);
                                                }
                                                rowList.add(o);
                                            }
                                            writer.writeRecord(null, rowList);
                                        }
                                        rowList.clear();
                                        Object[] newData = (Object[])data.getRow()[1];
                                        if (metaset) {
                                            rowList.add(operationIndex++);
                                            rowList.add(new Timestamp(System.currentTimeMillis()));
                                            rowList.add("U");
                                        }
                                        Object[] objectArray = newData;
                                        int n2 = objectArray.length;
                                        for (int i = 0; i < n2; ++i) {
                                            Object o;
                                            o = objectArray[i];
                                            if (o instanceof TimestampData) {
                                                o = convertTimestampData.apply((TimestampData)o);
                                            }
                                            rowList.add(o);
                                        }
                                        writer.writeRecord(null, rowList);
                                        continue;
                                    }
                                    rowList = new ArrayList();
                                    if (metaset) {
                                        String operation;
                                        rowList.add(operationIndex++);
                                        rowList.add(new Timestamp(System.currentTimeMillis()));
                                        if (data.getOperationType().equals((Object)ReplicationOperationType.INSERT)) {
                                            operation = "I";
                                        } else {
                                            if (!data.getOperationType().equals((Object)ReplicationOperationType.DELETE)) throw new DataspaceException("Wrong operation type");
                                            operation = "D";
                                        }
                                        rowList.add(operation);
                                    }
                                    for (Object o : data.getRow()) {
                                        if (o instanceof TimestampData) {
                                            o = convertTimestampData.apply((TimestampData)o);
                                        }
                                        rowList.add(o);
                                    }
                                    writer.writeRecord(null, rowList);
                                }
                            }
                            currentReplicationId += (long)batchSize;
                        }
                        return Result.updateNoResult;
                    }
                }
                catch (Throwable e372) {
                    if (e372 instanceof DataspaceException) return Result.newErrorResult(e372, this.sql);
                    DataspaceException e372 = Error.error(467, e372.toString());
                    return Result.newErrorResult(e372, this.sql);
                }
            }
            case 3188: 
            case 3220: 
            case 3229: 
            case 3230: 
            case 3231: 
            case 3232: 
            case 3248: 
            case 3249: {
                ReplicationEntityName entityName = (ReplicationEntityName)this.parameters[0];
                if (entityName.isLocalNode()) {
                    ReplicationTarget replica = (ReplicationTarget)session.dataspaceStore.schemaManager.getSchemaObject(entityName.getSourceOrReplicaName(), entityName.getDataspaceName(), 29);
                    if (this.type == 3229) {
                        replica.suspend(session);
                        return Result.updateNoResult;
                    } else if (this.type == 3230) {
                        replica.resume(session);
                        return Result.updateNoResult;
                    } else if (this.type == 3232) {
                        replica.start(session);
                        return Result.updateNoResult;
                    } else if (this.type == 3231) {
                        replica.stop(session);
                        return Result.updateNoResult;
                    } else if (this.type == 3220) {
                        if (this.parameters[1] instanceof Boolean && ((Boolean)this.parameters[1]).booleanValue()) {
                            replica.resetMetrics();
                            return Result.updateNoResult;
                        } else {
                            replica.reset(session);
                        }
                        return Result.updateNoResult;
                    } else if (this.type == 3249) {
                        replica.setReplicationId(session, (Long)this.parameters[1]);
                        return Result.updateNoResult;
                    } else if (this.type == 3248) {
                        replica.skipCurrentUnitOnReplica(session);
                        return Result.updateNoResult;
                    } else {
                        if (this.type != 3188) throw new DataspaceException("Invalid type " + this.type + ", sql: " + this.sql);
                        replica.materialize(session, (Boolean)this.parameters[1]);
                    }
                    return Result.updateNoResult;
                } else {
                    ReplicationResponse replicaResponse = ReplicationUtil.sendSqlRequestTo(session, entityName, this.sql);
                    if (replicaResponse.isOk()) return Result.updateNoResult;
                    throw replicaResponse.getException();
                }
            }
            case 3181: 
            case 3182: 
            case 3233: 
            case 3239: {
                ReplicationEntityName sourceEntityName = (ReplicationEntityName)this.parameters[0];
                if (sourceEntityName.isLocalNode()) {
                    Collection collection = (Collection)session.dataspaceStore.schemaManager.getSchemaObject(sourceEntityName.getSourceOrReplicaName(), sourceEntityName.getDataspaceName(), 4);
                    ReplicationSource source = collection.getReplicationSource();
                    if (source == null) {
                        throw new DataspaceException("Source with specified name doesn't exist.");
                    }
                    if (this.type == 3233) {
                        ReplicationEntityName replicaEntityName = (ReplicationEntityName)this.parameters[1];
                        List<ReplicaInfo> replicas = source.listReplicas(session);
                        if (replicas.stream().filter(replicaInfo -> replicaInfo.getReplicaEntityName().equalsNoCollection(replicaEntityName)).count() == 0L) {
                            throw new DataspaceException("Replica '" + replicaEntityName.getFullName() + "' isn't paired with source '" + sourceEntityName.getFullName() + "'.");
                        }
                        source.evictReplica(replicaEntityName, session);
                        source.sendSourceUpdatedForReplica(session, replicaEntityName);
                        return Result.updateNoResult;
                    } else if (this.type == 3181) {
                        source.enable(session);
                        source.listReplicas(session).forEach(r -> source.sendSourceUpdatedForReplica(session, r.getReplicaEntityName()));
                        return Result.updateNoResult;
                    } else if (this.type == 3182) {
                        source.disable();
                        source.listReplicas(session).forEach(r -> source.sendSourceUpdatedForReplica(session, r.getReplicaEntityName()));
                        return Result.updateNoResult;
                    } else {
                        if (this.type != 3239) throw new DataspaceException("Invalid type " + this.type + ", sql: " + this.sql);
                        source.resetMetrics();
                    }
                    return Result.updateNoResult;
                } else {
                    ReplicationResponse replicaResponse = ReplicationUtil.sendSqlRequestTo(session, sourceEntityName, this.sql);
                    if (replicaResponse.isOk()) return Result.updateNoResult;
                    throw replicaResponse.getException();
                }
            }
            case 3098: {
                try {
                    Result result;
                    SchemaObject obj = (SchemaObject)this.parameters[0];
                    String fileName = (String)this.parameters[2];
                    Boolean compressed = (Boolean)this.parameters[3];
                    boolean ignoreErrors = (Boolean)this.parameters[4];
                    List includeObjects = (List)this.parameters[5];
                    List excludeObjects = (List)this.parameters[6];
                    String password = (String)this.parameters[7];
                    boolean noData = (Boolean)this.parameters[8];
                    boolean bl = (Boolean)this.parameters[11];
                    boolean withWait = (Boolean)this.parameters[13];
                    long limit = (Long)this.parameters[15];
                    List packages = (List)this.parameters[18];
                    SchemaDumper dumper = new SchemaDumper(session, fileName, compressed, includeObjects, excludeObjects);
                    dumper.setPassword(password);
                    dumper.setNoData(noData);
                    dumper.setVerbose(bl);
                    dumper.setPackages(packages);
                    dumper.setIgnoreErrors(ignoreErrors);
                    dumper.setLimit(limit);
                    Result result2 = result = withWait ? Result.updateNoResult : ResultPseudo.emptyResult;
                    if (!(obj instanceof AbstractDataspace)) {
                        return Result.newErrorResult(new IllegalArgumentException("Invalid object specified for dump."));
                    }
                    dumper.dumpDataspace((AbstractDataspace)obj, withWait);
                    session.dataspaceStore.schemaManager.setSchemaChangeTimestamp();
                    return result;
                }
                catch (Throwable e382) {
                    if (e382 instanceof DataspaceException) return Result.newErrorResult(e382, this.sql);
                    DataspaceException e382 = Error.error(467, e382.toString());
                    return Result.newErrorResult(e382, this.sql);
                }
            }
            case 3316: {
                try {
                    String dataspaceName = ((NameManager.ObjectName)this.parameters[0]).name;
                    String dumpName = (String)this.parameters[1];
                    boolean verbose = (Boolean)this.parameters[2];
                    String password = (String)this.parameters[3];
                    SchemaComparator comparator = new SchemaComparator(session, dumpName);
                    comparator.setDataspaceName(dataspaceName);
                    comparator.setPassword(password);
                    comparator.setVerbose(verbose);
                    Map<ObjectType, List<SchemaComparator.SchemaComparatorResult>> comparatorResult = comparator.compareDataspace();
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Type", "Name", "Status", "Source Dump Definition", "Target Database Definition", "Source Last Change", "Target Last Change"});
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    for (Map.Entry<ObjectType, List<SchemaComparator.SchemaComparatorResult>> entry2 : comparatorResult.entrySet()) {
                        for (SchemaComparator.SchemaComparatorResult r2 : entry2.getValue()) {
                            navigator.add(new Object[]{entry2.getKey().getName(), r2.getName(), r2.getStatus().getDisplayName(), r2.getStatus() != SchemaComparator.SchemaComparatorResult.SchemaComparatorStatus.OK && r2.getDumpDefinition() != null ? r2.getDumpDefinition() : "", r2.getStatus() != SchemaComparator.SchemaComparatorResult.SchemaComparatorStatus.OK && r2.getDataspaceDefinition() != null ? r2.getDataspaceDefinition() : "", r2.getStatus() != SchemaComparator.SchemaComparatorResult.SchemaComparatorStatus.OK && r2.getDumpLastModifiedTimestamp() != null ? DataspaceDateTime.getSqlTimestampString(r2.getDumpLastModifiedTimestamp()) : "", r2.getStatus() != SchemaComparator.SchemaComparatorResult.SchemaComparatorStatus.OK && r2.getDataspaceLastModifiedTimestamp() != null ? DataspaceDateTime.getSqlTimestampString(r2.getDataspaceLastModifiedTimestamp()) : ""});
                        }
                    }
                    return result;
                }
                catch (Throwable e392) {
                    if (e392 instanceof DataspaceException) return Result.newErrorResult(e392, this.sql);
                    DataspaceException e392 = Error.error(467, e392.toString());
                    return Result.newErrorResult(e392, this.sql);
                }
            }
            case 3099: {
                try {
                    Object ignoreDeps;
                    String dataspaceName = (String)this.parameters[1];
                    if (dataspaceName == null && this.parameters[0] != null) {
                        dataspaceName = ((SchemaObject)this.parameters[0]).getObjectName().name;
                    }
                    String fileName = (String)this.parameters[2];
                    boolean compressed = (Boolean)this.parameters[3];
                    boolean ignoreErrors = (Boolean)this.parameters[4];
                    String password = (String)this.parameters[7];
                    boolean noData = (Boolean)this.parameters[8];
                    String mergeMode = (String)this.parameters[9];
                    boolean verbose = (Boolean)this.parameters[11];
                    boolean bl = (Boolean)this.parameters[13];
                    Map additionalOptions = (Map)this.parameters[17];
                    List includeObjects = (List)this.parameters[5];
                    List excludeObjects = (List)this.parameters[6];
                    SchemaLoader loader = new SchemaLoader(session, fileName, compressed, includeObjects, excludeObjects);
                    loader.setDataspaceName(dataspaceName);
                    loader.setPassword(password);
                    loader.setMergeMode(SchemaLoader.MergeMode.valueOf(mergeMode));
                    loader.setNoData(noData);
                    loader.setIgnoreErrors(ignoreErrors);
                    loader.setVerbose(verbose);
                    Object globalVal = additionalOptions.get("packagesGlobal");
                    if (globalVal != null) {
                        loader.setArtifactGlobal((Boolean)globalVal);
                    }
                    if ((ignoreDeps = additionalOptions.get("IGNOREDEPENDENCIES")) != null) {
                        loader.setIgnoreDependencies((Boolean)ignoreDeps);
                    }
                    Result result = bl ? Result.updateNoResult : ResultPseudo.emptyResult;
                    loader.loadDataspace(bl);
                    session.dataspaceStore.schemaManager.setSchemaChangeTimestamp();
                    return result;
                }
                catch (Throwable e402) {
                    if (e402 instanceof DataspaceException) return Result.newErrorResult(e402, this.sql);
                    DataspaceException e402 = Error.error(467, e402.toString());
                    return Result.newErrorResult(e402, this.sql);
                }
            }
            case 3111: {
                try {
                    VirtualTableCollection virtualTable = (VirtualTableCollection)this.parameters[0];
                    virtualTable.invalidateCache();
                    return Result.updateNoResult;
                }
                catch (Throwable e412) {
                    if (e412 instanceof DataspaceException) return Result.newErrorResult(e412, this.sql);
                    DataspaceException e412 = Error.error(467, e412.toString());
                    return Result.newErrorResult(e412, this.sql);
                }
            }
            case 3292: {
                SnapshotCollection snapshotCollection = (SnapshotCollection)this.parameters[0];
                String filepath = (String)this.parameters[1];
                boolean readOnly = (Boolean)this.parameters[2];
                boolean toDelimitedFile = (Boolean)this.parameters[3];
                if (snapshotCollection.isLinked()) {
                    throw new DataspaceException("Snapshot '" + snapshotCollection.getObjectName().name + "' already linked. Unlink first.");
                }
                snapshotCollection.getBaseTable().store.writeLock();
                try {
                    snapshotCollection.setLinkFilepath(filepath);
                    snapshotCollection.setLinkToDelimited(toDelimitedFile);
                    snapshotCollection.materializeFrom(session, filepath, toDelimitedFile, false, false);
                    snapshotCollection.rebuildPrimaryKeyIfNeeded();
                    if (readOnly) {
                        snapshotCollection.getBaseTable().setDataReadOnly(readOnly);
                    }
                    snapshotCollection.setLinked(true);
                    return Result.updateNoResult;
                }
                catch (Exception exception8) {
                    DataspaceException exception8;
                    snapshotCollection.setLinkException(exception8);
                    if (session.isProcessingLog || session.isProcessingRecoveryLog) {
                        Result noData = Result.updateNoResult;
                        return noData;
                    }
                    if (!(exception8 instanceof DataspaceException)) {
                        exception8 = Error.error(467, exception8.toString());
                    }
                    Result noData = Result.newErrorResult(exception8, this.sql);
                    return noData;
                }
                finally {
                    snapshotCollection.getBaseTable().store.writeUnlock();
                }
            }
            case 3293: {
                SnapshotCollection snapshotCollection = (SnapshotCollection)this.parameters[0];
                snapshotCollection.getBaseTable().store.writeLock();
                try {
                    snapshotCollection.setLinkFilepath(null);
                    snapshotCollection.setLinkToDelimited(false);
                    snapshotCollection.setLinked(false);
                    snapshotCollection.setLinkException(null);
                    ((SnapshotDataspaceTable)snapshotCollection.getBaseTable()).getSTable().clear();
                    return Result.updateNoResult;
                }
                catch (Exception exception9) {
                    DataspaceException exception9;
                    if (!(exception9 instanceof DataspaceException)) {
                        exception9 = Error.error(467, exception9.toString());
                    }
                    Result readOnly = Result.newErrorResult(exception9, this.sql);
                    return readOnly;
                }
                finally {
                    snapshotCollection.getBaseTable().store.writeUnlock();
                }
            }
            case 3240: {
                try {
                    SnapshotCollection snapshotCollection = (SnapshotCollection)this.parameters[0];
                    Boolean from = (Boolean)this.parameters[1];
                    String filepath = (String)this.parameters[2];
                    Collection fromCollection = (Collection)this.parameters[3];
                    boolean readOnly = (Boolean)this.parameters[4];
                    boolean withDefrag = (Boolean)this.parameters[5];
                    boolean fromDelimitedFile = (Boolean)this.parameters[6];
                    boolean force = (Boolean)this.parameters[7];
                    boolean bl = (Boolean)this.parameters[8];
                    if (from.booleanValue()) {
                        snapshotCollection.getBaseTable().store.writeLock();
                        try {
                            Index primaryIndex;
                            if (snapshotCollection.isLinked()) {
                                throw new DataspaceException("Snapshot collection is linked and cannot be loaded.");
                            }
                            if (filepath != null) {
                                snapshotCollection.materializeFrom(session, filepath, fromDelimitedFile, force, bl);
                            } else {
                                snapshotCollection.materializeFrom(session, fromCollection);
                            }
                            snapshotCollection.rebuildPrimaryKeyIfNeeded();
                            if (withDefrag) {
                                ((SnapshotDataspaceTable)snapshotCollection.getBaseTable()).getSTable().defrag(true);
                            }
                            if ((primaryIndex = snapshotCollection.getBaseTable().getPrimaryIndex()) != null && !primaryIndex.isBuilt()) {
                                SIndex sPrimaryIndex = ((IndexSnapshot)primaryIndex).getSIndex();
                                if (sPrimaryIndex.isValid()) {
                                    Trace.logInfo(this, "Rebuilding primary key {} for snapshot {}.", sPrimaryIndex.getName(), snapshotCollection.getCollectionName());
                                    sPrimaryIndex.reset();
                                    sPrimaryIndex.build(((IndexSnapshot)primaryIndex).getTable().getSTable().getSelection());
                                } else {
                                    Trace.logInfo(this, "Primary key {} for snapshot {} is not valid.", sPrimaryIndex.getName(), snapshotCollection.getCollectionName());
                                }
                            }
                            if (!readOnly) return Result.updateNoResult;
                            snapshotCollection.getBaseTable().setDataReadOnly(readOnly);
                            return Result.updateNoResult;
                        }
                        finally {
                            snapshotCollection.getBaseTable().store.writeUnlock();
                        }
                    }
                    if (withDefrag) {
                        snapshotCollection.getBaseTable().store.writeLock();
                        try {
                            ((SnapshotDataspaceTable)snapshotCollection.getBaseTable()).getSTable().defrag(true);
                        }
                        finally {
                            snapshotCollection.getBaseTable().store.writeUnlock();
                        }
                    }
                    snapshotCollection.getBaseTable().store.readLock();
                    snapshotCollection.autosaveLock.lock();
                    try {
                        snapshotCollection.materializeTo(session, filepath);
                        snapshotCollection.startAutosaveAndConsumer();
                        return Result.updateNoResult;
                    }
                    finally {
                        snapshotCollection.autosaveLock.unlock();
                        snapshotCollection.getBaseTable().store.readUnlock();
                    }
                }
                catch (Throwable e422) {
                    if (e422 instanceof DataspaceException) return Result.newErrorResult(e422, this.sql);
                    DataspaceException e422 = Error.error(467, e422.toString());
                    return Result.newErrorResult(e422, this.sql);
                }
            }
            case 3252: {
                try {
                    SnapshotCollection snapshotCollection = (SnapshotCollection)this.parameters[0];
                    boolean withTrim = (Boolean)this.parameters[1];
                    snapshotCollection.getBaseTable().store.writeLock();
                    try {
                        ((SnapshotDataspaceTable)snapshotCollection.getBaseTable()).getSTable().defrag(withTrim);
                        return Result.updateNoResult;
                    }
                    finally {
                        snapshotCollection.getBaseTable().store.writeUnlock();
                    }
                }
                catch (Throwable e432) {
                    if (e432 instanceof DataspaceException) return Result.newErrorResult(e432, this.sql);
                    DataspaceException e432 = Error.error(467, e432.toString());
                    return Result.newErrorResult(e432, this.sql);
                }
            }
            case 3255: {
                try {
                    FindTextExpression findTextExp = (FindTextExpression)this.parameters[0];
                    return findTextExp.getResultValue(session);
                }
                catch (Exception e44) {
                    return Result.newErrorResult(e44, this.sql);
                }
            }
            case 3286: {
                try {
                    return Result.updateNoResult;
                }
                catch (Exception e45) {
                    return Result.newErrorResult(e45, this.sql);
                }
            }
            case 3130: {
                try {
                    AbstractDataspaceComponent dataspace = (AbstractDataspaceComponent)this.parameters[0];
                    String eventId = (String)this.parameters[1];
                    dataspace.bindProducerFor(eventId, new SourceEventFlowDataImpl(EventFlowEntity.DATASPACE_EVENT_PRODUCER, null, null, null));
                    return Result.updateNoResult;
                }
                catch (Throwable e46) {
                    return Result.newErrorResult(e46, this.sql);
                }
            }
            case 3144: {
                try {
                    Session sessionToKill = (Session)this.parameters[0];
                    if (sessionToKill.getCurrentThreadId() != -1L) {
                        throw new DataspaceException("Session cannot be closed when it is running a command. Interrupt it first.");
                    }
                    sessionToKill.close();
                    return Result.updateNoResult;
                }
                catch (Throwable e47) {
                    return Result.newErrorResult(e47, this.sql);
                }
            }
            case 3318: {
                try {
                    Session sessionToInterrupt = (Session)this.parameters[0];
                    sessionToInterrupt.abortTransaction = true;
                    sessionToInterrupt.interruptCurrentProcessing();
                    return Result.updateNoResult;
                }
                catch (Throwable e48) {
                    return Result.newErrorResult(e48, this.sql);
                }
            }
            case 3087: {
                try {
                    NameManager.ObjectName name9 = (NameManager.ObjectName)this.parameters[0];
                    Table table = session.dataspaceStore.schemaManager.getTable(session, name9.name, name9.schema.name);
                    StatementSchema.checkSchemaUpdateAuthorisation(session, table.getSchemaName());
                    if (!table.isText()) {
                        DataspaceException e49 = Error.error(321);
                        return Result.newErrorResult(e49, this.sql);
                    }
                    ((FileTable)table).decompress(session);
                    session.dataspaceStore.schemaManager.setSchemaChangeTimestamp();
                    return Result.updateNoResult;
                }
                catch (Throwable e502) {
                    if (e502 instanceof DataspaceException) return Result.newErrorResult(e502, this.sql);
                    DataspaceException e502 = Error.error(467, e502.toString());
                    return Result.newErrorResult(e502, this.sql);
                }
            }
            case 1197: {
                try {
                    NameManager.ObjectName name10 = (NameManager.ObjectName)this.parameters[0];
                    int type = (Integer)this.parameters[1];
                    Table table = session.dataspaceStore.schemaManager.getUserTable(session, name10.name, name10.schema.name);
                    StatementSchema.checkSchemaUpdateAuthorisation(session, table.getSchemaName());
                    session.setScripting(true);
                    TableWorks tw = new TableWorks(session, table);
                    tw.setTableType(session, type);
                    session.dataspaceStore.schemaManager.setSchemaChangeTimestamp();
                    return Result.updateNoResult;
                }
                catch (DataspaceException e51) {
                    return Result.newErrorResult(e51, this.sql);
                }
            }
            case 1061: {
                try {
                    UserWrapper user = (UserWrapper)this.parameters[0];
                    NameManager.ObjectName schema = (NameManager.ObjectName)this.parameters[1];
                    session.checkDDLWrite();
                    if (user == null) {
                        user = session.getUser();
                    } else {
                        session.checkAdmin();
                        session.checkDDLWrite();
                        user = session.dataspaceStore.userManager.get(user.getObjectName().getNameString());
                    }
                    if (schema != null) {
                        schema = session.dataspaceStore.schemaManager.getSchemaHsqlName(schema.name);
                    }
                    user.setInitialSchema(schema);
                    session.dataspaceStore.schemaManager.setSchemaChangeTimestamp();
                    return Result.updateNoResult;
                }
                catch (DataspaceException e52) {
                    return Result.newErrorResult(e52, this.sql);
                }
            }
            case 1062: {
                try {
                    UserWrapper user = this.parameters[0] == null ? session.getUser() : (UserWrapper)this.parameters[0];
                    session.checkDDLWrite();
                    session.setScripting(true);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e53) {
                    return Result.newErrorResult(e53, this.sql);
                }
            }
            case 1005: {
                try {
                    long sessionID = ((Number)this.parameters[0]).longValue();
                    int action = ((Number)this.parameters[1]).intValue();
                    Session targetSession = session.dataspaceStore.collectionSessionManager.getSession(sessionID);
                    if (sessionID > 0L) {
                        throw new DataspaceException("ALTER SESSION not supported because works with errors.");
                    }
                    if (targetSession == null) {
                        throw Error.error(4500);
                    }
                    switch (action) {
                        case 2: {
                            targetSession.resetSession();
                            return Result.updateNoResult;
                        }
                        case 278: {
                            targetSession.sessionData.persistentStoreCollection.clearAllTables();
                            return Result.updateNoResult;
                        }
                        case 236: {
                            targetSession.sessionData.closeAllNavigators();
                            return Result.updateNoResult;
                        }
                        case 39: {
                            targetSession.abortTransaction = true;
                            targetSession.latch.setCount(0);
                            targetSession.close();
                            return Result.updateNoResult;
                        }
                        case 233: {
                            targetSession.abortTransaction = true;
                            targetSession.latch.setCount(0);
                        }
                    }
                    return Result.updateNoResult;
                }
                catch (DataspaceException e54) {
                    return Result.newErrorResult(e54, this.sql);
                }
            }
            case 3010: {
                try {
                    ProcessQueueCollection queue = (ProcessQueueCollection)this.parameters[0];
                    queue.suspend(session);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e55) {
                    return Result.newErrorResult(e55, this.sql);
                }
            }
            case 3011: {
                try {
                    ProcessQueueCollection queue = (ProcessQueueCollection)this.parameters[0];
                    queue.resume(session);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e56) {
                    return Result.newErrorResult(e56, this.sql);
                }
            }
            case 3012: {
                try {
                    EventQueueCollection queue = (EventQueueCollection)this.parameters[0];
                    queue.start(session);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e57) {
                    return Result.newErrorResult(e57, this.sql);
                }
            }
            case 3069: {
                try {
                    EventTableCollection table = (EventTableCollection)this.parameters[0];
                    table.start(session);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e58) {
                    return Result.newErrorResult(e58, this.sql);
                }
            }
            case 3253: {
                try {
                    SnapshotCollection snapshot = (SnapshotCollection)this.parameters[0];
                    snapshot.start(session);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e59) {
                    return Result.newErrorResult(e59, this.sql);
                }
            }
            case 3254: {
                try {
                    SnapshotCollection snapshot = (SnapshotCollection)this.parameters[0];
                    snapshot.stop(session);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e60) {
                    return Result.newErrorResult(e60, this.sql);
                }
            }
            case 3055: {
                try {
                    SourceStreamCollection stream = (SourceStreamCollection)this.parameters[0];
                    return stream.start(null);
                }
                catch (DataspaceException e61) {
                    return Result.newErrorResult(e61, this.sql);
                }
            }
            case 3056: {
                try {
                    SourceStreamCollection stream = (SourceStreamCollection)this.parameters[0];
                    stream.stop(null);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e62) {
                    return Result.newErrorResult(e62, this.sql);
                }
            }
            case 3057: {
                try {
                    SourceStreamCollection stream = (SourceStreamCollection)this.parameters[0];
                    stream.suspend(null);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e63) {
                    return Result.newErrorResult(e63, this.sql);
                }
            }
            case 3058: {
                try {
                    SourceStreamCollection stream = (SourceStreamCollection)this.parameters[0];
                    stream.resume(null);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e64) {
                    return Result.newErrorResult(e64, this.sql);
                }
            }
            case 3075: 
            case 3076: 
            case 3077: 
            case 3078: 
            case 3079: 
            case 3081: {
                TimerObject timerObject = (TimerObject)this.parameters[0];
                try {
                    FabricTimer timer = FabricTimerManager.getInstance().getTimer(timerObject.getTimerGroup(), timerObject.getObjectName().name);
                    switch (this.type) {
                        case 3075: {
                            if (timer == null || timer.getState() != FabricTimerState.STARTED) {
                                throw new DataspaceException("Timer '" + timerObject.getTimerGroup() + "." + timerObject.getObjectName().name + "' is not running and can not be suspended.");
                            }
                            timer.suspend();
                            return Result.updateNoResult;
                        }
                        case 3076: {
                            if (timer == null || timer.getState() != FabricTimerState.SUSPENDED) {
                                throw new DataspaceException("Timer '" + timerObject.getTimerGroup() + "." + timerObject.getObjectName().name + "' is not running and can not be resumed.");
                            }
                            timer.resume();
                            return Result.updateNoResult;
                        }
                        case 3078: {
                            if (timer == null) {
                                AbstractDataspace dataspace = (AbstractDataspace)session.dataspaceStore.schemaManager.findSchema(session.getCurrentDataspaceName().name);
                                timer = FabricTimerFactory.createTimer(timerObject.getTimerGroup(), timerObject.getObjectName().name, timerObject.getTimeUnit().toMillis(timerObject.getInterval()), timerObject.getRepeatCount(), dataspace);
                                if (timerObject.getParams() != null) {
                                    for (Map.Entry<String, Expression> entry3 : timerObject.getParams().entrySet()) {
                                        Expression expr = entry3.getValue();
                                        expr.materialise(session);
                                        Object value = expr.getValue(session);
                                        if (value == null) continue;
                                        timer.addValue(entry3.getKey(), value);
                                    }
                                }
                            }
                            if (timer.getState() == FabricTimerState.STARTED) {
                                throw new DataspaceException("Timer '" + timerObject.getTimerGroup() + "." + timerObject.getObjectName().name + "' already started.");
                            }
                            timer.start();
                            return Result.updateNoResult;
                        }
                        case 3079: {
                            if (timer == null) {
                                throw new DataspaceException("Timer '" + timerObject.getTimerGroup() + "." + timerObject.getObjectName().name + "' is not running and can not be stopped.");
                            }
                            timer.stop();
                            return Result.updateNoResult;
                        }
                        case 3077: {
                            if (timer == null) {
                                throw new DataspaceException("Timer '" + timerObject.getTimerGroup() + "." + timerObject.getObjectName().name + "' is not running and can not be reset.");
                            }
                            timer.reset();
                            return Result.updateNoResult;
                        }
                        case 3081: {
                            if (timer == null) {
                                throw new DataspaceException("Timer '" + timerObject.getTimerGroup() + "." + timerObject.getObjectName().name + "' is not running and can not be cancelled.");
                            }
                            timer.cancel();
                        }
                    }
                    return Result.updateNoResult;
                }
                catch (Exception e65) {
                    return Result.newErrorResult(e65, this.sql);
                }
            }
            case 3028: {
                try {
                    Expression raiseRequestExp = (Expression)this.parameters[0];
                    raiseRequestExp.getValue(session);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e66) {
                    return Result.newErrorResult(e66, this.sql);
                }
            }
            case 3289: {
                Expression dataExp = (Expression)this.parameters[1];
                boolean withSourceData = (Boolean)this.parameters[2];
                AcknowledgeAction acknowledgeAction = (AcknowledgeAction)((Object)this.parameters[3]);
                try {
                    ImmutableEventDatagram event = null;
                    String eventId = null;
                    if (this.parameters[0] instanceof Expression) {
                        Object value = OtherTypeWrapper.unwrap(((Expression)this.parameters[0]).getValue(session));
                        if (value instanceof ImmutableEventDatagram) {
                            event = (ImmutableEventDatagram)value;
                        } else if (value instanceof String) {
                            eventId = (String)value;
                        }
                    } else {
                        eventId = (String)this.parameters[0];
                    }
                    AcknowledgementEvent acknowledgementEvent = null;
                    try {
                        if (eventId != null) {
                            acknowledgementEvent = session.sessionContext.eventDatagramFactory.createAcknowledgement(eventId);
                        } else if (event instanceof EventDatagram) {
                            acknowledgementEvent = session.sessionContext.eventDatagramFactory.createAcknowledgement((EventDatagram)event, withSourceData);
                        } else if (event instanceof ExceptionEventDatagram) {
                            acknowledgementEvent = session.sessionContext.eventDatagramFactory.createAcknowledgement((ExceptionEventDatagram)event);
                        } else {
                            if (event != null) throw new DataspaceException("Source event must be EventDatagram or ExceptionEventDatagram.");
                            throw new DataspaceException("Source event is null.");
                        }
                        if (acknowledgeAction != null) {
                            acknowledgementEvent.setAction(acknowledgeAction);
                        }
                        if (dataExp != null) {
                            Object data = OtherTypeWrapper.unwrap(dataExp.getValue(session));
                            acknowledgementEvent.setData(data);
                        }
                    }
                    catch (Exception exception) {
                        throw new DataspaceException("Creating AcknowledgementEvent failed.", exception);
                    }
                    DataspaceSchema dataspace = session.dataspaceStore.schemaManager.findSchema(session.currentDataspace.name);
                    if (dataspace == null) {
                        throw new DataspaceException("Unable to get reference to parent dataspace.");
                    }
                    try {
                        dataspace.raiseAcknowledgement(acknowledgementEvent, -1L);
                        return Result.updateNoResult;
                    }
                    catch (Exception exception) {
                        throw new DataspaceException("Raising AcknowledgementEvent failed.", exception);
                    }
                }
                catch (DataspaceException exception) {
                    return Result.newErrorResult(exception, this.sql);
                }
            }
            case 3025: {
                String eventId = (String)this.parameters[0];
                Expression exp = (Expression)this.parameters[1];
                try {
                    ImmutableEventDatagram event = (ImmutableEventDatagram)OtherTypeWrapper.unwrap(exp.getValue(session));
                    if (event == null) return Result.updateNoResult;
                    DataspaceSchema dataspace = session.dataspaceStore.schemaManager.findSchema(session.currentDataspace.name);
                    if (dataspace == null) {
                        throw new DataspaceException("Unable to get reference to parent dataspace.");
                    }
                    try {
                        FabricEventSinkFactoryImpl.reset(event);
                    }
                    catch (Throwable error) {
                        Trace.logError(this, "Unable to set EventId on event trigger outgoing event. " + error.getMessage());
                        throw new DataspaceException(error.getMessage());
                    }
                    if (eventId != null) {
                        try {
                            FabricEventSourceFactoryImpl.setEventId(event, eventId);
                        }
                        catch (Throwable error) {
                            Trace.logError(this, "Unable to set EventId on event trigger outgoing event. " + error.getMessage());
                            throw new DataspaceException(error.getMessage());
                        }
                    }
                    try {
                        if (event instanceof AcknowledgementEvent) {
                            dataspace.raiseAcknowledgement((AcknowledgementEvent)event, 0L);
                            return Result.updateNoResult;
                        } else {
                            EventScope scope = null;
                            if (this.parameters.length > 2 && this.parameters[2] instanceof EventScope) {
                                scope = (EventScope)((Object)this.parameters[2]);
                            }
                            if (scope == null) {
                                scope = session.sessionContext.triggerDefinition != null ? session.sessionContext.triggerDefinition.getEventScope() : (session.sessionContext.eventScope != null ? session.sessionContext.eventScope : dataspace.getEventScope());
                            }
                            dataspace.raiseEvent(event, scope, 0L);
                        }
                        return Result.updateNoResult;
                    }
                    catch (Exception error) {
                        throw new DataspaceException("Raise event failed. " + error.getMessage(), error);
                    }
                }
                catch (DataspaceException e67) {
                    return Result.newErrorResult(e67, this.sql);
                }
            }
            case 3027: {
                String eventId = (String)this.parameters[0];
                Expression exp = (Expression)this.parameters[1];
                try {
                    ImmutableEventDatagram exception = (ImmutableEventDatagram)OtherTypeWrapper.unwrap(exp.getValue(session));
                    if (eventId != null) {
                        try {
                            FabricEventSourceFactoryImpl.setEventId(exception, eventId);
                        }
                        catch (Throwable error) {
                            Trace.logError(this, "Unable to set EventId on event trigger outgoing event. " + error.getMessage());
                            throw new DataspaceException(error.getMessage());
                        }
                    }
                    if (!(exception instanceof ExceptionEventDatagram)) return Result.updateNoResult;
                    DataspaceSchema dataspace = session.dataspaceStore.schemaManager.findSchema(session.currentDataspace.name);
                    if (dataspace == null) {
                        throw new DataspaceException("Unable to get reference to parent dataspace.");
                    }
                    try {
                        dataspace.raiseException((ExceptionEventDatagram)exception);
                        return Result.updateNoResult;
                    }
                    catch (Exception error) {
                        throw new DataspaceException("Exception raising failed.", error);
                    }
                }
                catch (DataspaceException e68) {
                    return Result.newErrorResult(e68, this.sql);
                }
            }
            case 3146: {
                BlockingQueueCollection sourceQueue = (BlockingQueueCollection)this.parameters[0];
                BlockingQueueCollection targetQueue = (BlockingQueueCollection)this.parameters[1];
                Integer maxElements = (Integer)this.parameters[2];
                String whereClause = (String)this.parameters[3];
                int count = sourceQueue.drainTo(session, targetQueue, maxElements, whereClause);
                return Result.newUpdateCountResult(count);
            }
            case 3013: {
                try {
                    EventQueueCollection queue = (EventQueueCollection)this.parameters[0];
                    queue.stop(session);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e69) {
                    return Result.newErrorResult(e69, this.sql);
                }
            }
            case 3070: {
                try {
                    EventTableCollection table = (EventTableCollection)this.parameters[0];
                    table.stop(session);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e70) {
                    return Result.newErrorResult(e70, this.sql);
                }
            }
            case 3090: {
                try {
                    ProcessQueueCollection queue = (ProcessQueueCollection)this.parameters[0];
                    String processId = (String)this.parameters[1];
                    ProcessState processState = (ProcessState)((Object)this.parameters[2]);
                    queue.setProcessState(session, processId, processState);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e71) {
                    return Result.newErrorResult(e71, this.sql);
                }
            }
            case 3091: {
                try {
                    ProcessQueueCollection queue = (ProcessQueueCollection)this.parameters[0];
                    Expression processId = (Expression)this.parameters[1];
                    String key = (String)this.parameters[2];
                    Expression value = (Expression)this.parameters[3];
                    queue.setProcessMeta(session, processId.getValue(session).toString(), key, value.getValue(session).toString());
                    return Result.updateNoResult;
                }
                catch (DataspaceException e72) {
                    return Result.newErrorResult(e72, this.sql);
                }
            }
            case 3092: {
                try {
                    ProcessQueueCollection queue = (ProcessQueueCollection)this.parameters[0];
                    Expression processId = (Expression)this.parameters[1];
                    String key = (String)this.parameters[2];
                    Map<String, Object> meta = queue.getMetaset(session, processId.getValue(session).toString());
                    if (meta == null) return Result.updateNoResult;
                    Object value = meta.get(key);
                    if (value == null) throw new DataspaceException("Metaset '" + key + "' is not set for processId '" + String.valueOf(processId) + "'.");
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR});
                    metaData.columnLabels = new String[]{"Value"};
                    metaData.columns = new ColumnBase[1];
                    ColumnBase column2 = new ColumnBase("", "", "", "");
                    column2.setType(Type.SQL_VARCHAR);
                    metaData.columns[0] = column2;
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    navigator.add(new Object[]{value.toString()});
                    return result;
                }
                catch (DataspaceException e73) {
                    return Result.newErrorResult(e73, this.sql);
                }
            }
            case 3093: {
                try {
                    ProcessQueueCollection queue = (ProcessQueueCollection)this.parameters[0];
                    Expression processId = (Expression)this.parameters[1];
                    Map<String, Object> meta = queue.getMetaset(session, processId.getValue(session).toString());
                    if (meta == null) return Result.updateNoResult;
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR});
                    metaData.columnLabels = new String[]{"Key", "Value"};
                    metaData.columns = new ColumnBase[2];
                    ColumnBase column3 = new ColumnBase("", "", "", "");
                    column3.setType(Type.SQL_VARCHAR);
                    metaData.columns[0] = column3;
                    column3 = new ColumnBase("", "", "", "");
                    column3.setType(Type.SQL_VARCHAR);
                    metaData.columns[1] = column3;
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    for (Map.Entry<String, Object> entry4 : meta.entrySet()) {
                        navigator.add(new Object[]{entry4.getKey(), entry4.getValue().toString()});
                    }
                    return result;
                }
                catch (DataspaceException e74) {
                    return Result.newErrorResult(e74, this.sql);
                }
            }
            case 3015: 
            case 3016: 
            case 3088: 
            case 3147: 
            case 3148: 
            case 3149: 
            case 3150: 
            case 3151: 
            case 3152: {
                try {
                    ProcessQueueCollection queue = (ProcessQueueCollection)this.parameters[0];
                    String processId = (String)this.parameters[1];
                    ProcessQueueCollection targetQueue = null;
                    if (this.parameters.length > 2) {
                        targetQueue = (ProcessQueueCollection)this.parameters[2];
                    }
                    switch (this.type) {
                        case 3015: {
                            queue.retryProcess(session, processId, null);
                            break;
                        }
                        case 3088: {
                            queue.reofferProcess(session, processId, null);
                            break;
                        }
                        case 3016: {
                            queue.discardProcess(session, processId, null);
                            break;
                        }
                        case 3147: {
                            queue.acknowledge(session, processId);
                            break;
                        }
                        case 3148: {
                            queue.updateProcessState(session, processId, ProcessState.UNACKNOWLEDGED);
                            break;
                        }
                        case 3149: {
                            queue.updateProcessState(session, processId, ProcessState.UNDELIVERED);
                            break;
                        }
                        case 3150: {
                            queue.updateProcessState(session, processId, ProcessState.SKIPPED);
                            break;
                        }
                        case 3151: {
                            queue.updateProcessState(session, processId, ProcessState.PENDING);
                            break;
                        }
                        case 3152: {
                            queue.updateProcessState(session, processId, ProcessState.EXPIRED);
                        }
                    }
                    if (targetQueue == null) return Result.updateNoResult;
                    Object event = queue.read(session, "ProcessId='" + processId + "'");
                    targetQueue.add(session, event);
                    return Result.updateNoResult;
                }
                catch (DataspaceException e75) {
                    return Result.newErrorResult(e75, this.sql);
                }
            }
            case 3153: {
                ProcessQueueCollection queue = (ProcessQueueCollection)this.parameters[0];
                String processId = (String)this.parameters[1];
                ProcessState state = queue.getProcessState(session, processId);
                if (state == null) {
                    throw new DataspaceException("Process '" + processId + "' doesn't exist.");
                }
                ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR}, new String[]{"Process State"});
                RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                Result result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                navigator.add(new Object[]{state});
                return result;
            }
            case 3138: {
                try {
                    Expression statementId = (Expression)this.parameters[0];
                    Object whereClause = (String)this.parameters[1];
                    if (whereClause == null) {
                        whereClause = "";
                    } else if (((String)whereClause).length() > 0) {
                        whereClause = " where " + (String)whereClause;
                    }
                    if (statementId != null) {
                        whereClause = whereClause == null || ((String)whereClause).length() <= 0 ? " where STATEMENT_ID = " + String.valueOf(statementId.getValue(session)) : (String)whereClause + " and STATEMENT_ID = " + String.valueOf(statementId.getValue(session));
                    }
                    Result result = null;
                    result = session.executeDirectStatement("delete from SDS.RECOVERY_LOG" + (String)whereClause);
                    this.setDataspaceOnlineAndStartServices(session);
                    return result;
                }
                catch (DataspaceException e76) {
                    return Result.newErrorResult(e76, this.sql);
                }
            }
            case 3137: {
                try {
                    Expression statementId = (Expression)this.parameters[0];
                    Object whereClause = (String)this.parameters[1];
                    if (whereClause == null) {
                        whereClause = "";
                    } else if (((String)whereClause).length() > 0) {
                        whereClause = " where " + (String)whereClause;
                    }
                    if (statementId != null) {
                        whereClause = whereClause == null || ((String)whereClause).length() <= 0 ? " where STATEMENT_ID = " + String.valueOf(statementId.getValue(session)) : (String)whereClause + " and STATEMENT_ID = " + String.valueOf(statementId.getValue(session));
                    }
                    RowSetNavigator navigator = null;
                    Result result = null;
                    result = session.executeDirectStatement("select STATEMENT_ID, DATASPACE, STATEMENT from SDS.RECOVERY_LOG" + (String)whereClause + " order by STATEMENT_ID");
                    if (result.isError() || !result.isData()) {
                        return result;
                    }
                    navigator = result.navigator;
                    NameManager.ObjectName currentDataspace = session.getCurrentDataspaceName();
                    try {
                        ArrayList<Pair<Integer, Object>> statements = new ArrayList<Pair<Integer, Object>>();
                        while (navigator.next()) {
                            Integer statId = ((Number)navigator.getCurrent(0)).intValue();
                            Object dataspace = (String)navigator.getCurrent(1);
                            String string = (String)navigator.getCurrent(2);
                            if (dataspace != null) {
                                if (((String)dataspace).equals("SYSTEM_SCHEMA")) {
                                    dataspace = "SYS";
                                }
                                statements.add(new Pair<Integer, CallSite>(-1, (CallSite)((Object)("set dataspace [" + (String)dataspace + "]"))));
                            }
                            statements.add(new Pair<Integer, String>(statId, string));
                        }
                        boolean sdsRuntimeSession = session.isSDSRuntimeSession();
                        session.setSDSRuntimeSession(false);
                        try {
                            for (Pair pair : statements) {
                                boolean loggingEnabled = session.dataspaceStore.dataspaceLogger.isLoggingEnabled();
                                try {
                                    session.dataspaceStore.dataspaceLogger.setLoggingEnabled(false);
                                    result = session.executeDirectStatement((String)pair.second);
                                }
                                finally {
                                    session.dataspaceStore.dataspaceLogger.setLoggingEnabled(loggingEnabled);
                                }
                                if (result.isError()) {
                                } else if ((Integer)pair.first == -1 || !(result = session.executeDirectStatement("delete from SDS.RECOVERY_LOG where STATEMENT_ID = " + String.valueOf(pair.first))).isError()) continue;
                                break;
                            }
                        }
                        finally {
                            session.setSDSRuntimeSession(sdsRuntimeSession);
                        }
                        if (!result.isError()) {
                            result = Result.updateNoResult;
                        }
                    }
                    finally {
                        session.setCurrentDataspaceName(currentDataspace);
                    }
                    this.setDataspaceOnlineAndStartServices(session);
                    return result;
                }
                catch (DataspaceException e77) {
                    return Result.newErrorResult(e77, this.sql);
                }
            }
            case 3168: {
                int statementNumber = (Integer)this.parameters[0];
                Object whereClause = (String)this.parameters[1];
                if (whereClause == null) {
                    whereClause = "";
                } else if (((String)whereClause).length() > 0) {
                    whereClause = " where " + (String)whereClause;
                }
                if (statementNumber < 0) return session.executeDirectStatement("select * from SDS.RECOVERY_LOG" + (String)whereClause + " order by STATEMENT_ID");
                return session.executeDirectStatement("select * from SDS.RECOVERY_LOG where STATEMENT_ID = " + statementNumber);
            }
            case 3017: {
                try {
                    ProcessQueueCollection queue = (ProcessQueueCollection)this.parameters[0];
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_BOOLEAN, Type.SQL_VARCHAR, Type.SQL_BOOLEAN, Type.SQL_VARCHAR}, new String[]{"Name", "EventId", "Enabled", "Token", "Certified", "Subscription Rule"});
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    for (ProcessQueueRecipientsTableManager.RecipientInfo recipientInfo : queue.getRecipients(session)) {
                        navigator.add(new Object[]{recipientInfo.getRecipientName(), StringUtils.wrapEventId(recipientInfo.getEventId()), recipientInfo.isEnabled(), recipientInfo.getToken(), recipientInfo.isCertified(), recipientInfo.getSubscriptionRule()});
                    }
                    return result;
                }
                catch (DataspaceException e78) {
                    return Result.newErrorResult(e78, this.sql);
                }
            }
            case 3180: {
                DataspaceSchema schema = (DataspaceSchema)this.parameters[0];
                boolean withSystem = (Boolean)this.parameters[1];
                ResultMetaData metaData = this.createMetaData(new Pair<String, CharacterType>("Type", Type.SQL_VARCHAR), new Pair<String, CharacterType>("Name", Type.SQL_VARCHAR), new Pair<String, CharacterType>("State", Type.SQL_VARCHAR), new Pair<String, CharacterType>("Last Error", Type.SQL_VARCHAR), new Pair<String, CharacterType>("Sample Element Count", Type.SQL_VARCHAR), new Pair<String, CharacterType>("Data Scope", Type.SQL_VARCHAR));
                RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                Result result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                HashSet<String> collectionNames = new HashSet<String>();
                com.streamscape.ds.lib.Iterator it = session.dataspaceStore.schemaManager.dataspaceObjectIterator(schema.getObjectName().name, 4);
                while (it.hasNext()) {
                    AbstractCollection collection = (AbstractCollection)it.next();
                    if (collection instanceof HadoopVirtualTableCollection && !withSystem) continue;
                    DataspaceStateHolder dataspaceStateHolder = collection.aggregateStateHolder();
                    Table table = collection.getBaseTable();
                    navigator.add(new Object[]{AbstractCollection.getCollectionTypeName(collection.getCollectionType()), collection.getObjectName().name, ((DataspaceStoreState)((Object)dataspaceStateHolder.getState())).toString(), dataspaceStateHolder.getLastOrSyntaxOrAllErrors(), table != null ? table.getSampleCountAsString(session) : "n/a", table != null ? table.getDataScopeString() : "n/a"});
                    collectionNames.add(collection.getObjectName().name);
                }
                if (withSystem) {
                    it = session.dataspaceStore.schemaManager.dataspaceObjectIterator(schema.getObjectName().name, 3);
                    while (it.hasNext()) {
                        Table table = (Table)it.next();
                        if (collectionNames.contains(table.getObjectName().name)) continue;
                        navigator.add(new Object[]{CollectionType.TABLE.name(), table.getObjectName().name, "ONLINE", "", table.getSampleCountAsString(session), table.getDataScopeString()});
                    }
                }
                com.streamscape.ds.lib.Iterator iterator = session.dataspaceStore.schemaManager.dataspaceObjectIterator(schema.getObjectName().name, 8);
                while (iterator.hasNext()) {
                    NumberSequence sequence = (NumberSequence)iterator.next();
                    navigator.add(new Object[]{"SEQUENCE", sequence.getObjectName().name, "ONLINE", "", "n/a", "DATASPACE"});
                }
                return result;
            }
            case 3038: {
                try {
                    NameManager.ObjectName schemaName = (NameManager.ObjectName)this.parameters[0];
                    Collection collection = (Collection)this.parameters[1];
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Event Trigger", "Collection Name", "Trigger Type", "Trigger Condition", "Absolute Order", "Relative Order", "State", "Last Error", "Created", "Last Modified"});
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    com.streamscape.ds.lib.Iterator it = session.dataspaceStore.schemaManager.dataspaceObjectIterator(schemaName.name, 9);
                    HashMap<String, Object> triggersByCollection = new HashMap<String, Object>();
                    while (it.hasNext()) {
                        TriggerDef trigger = (TriggerDef)it.next();
                        if (!(trigger instanceof RecompiledTrigger)) continue;
                        RecompiledTrigger recompiledTrigger = (RecompiledTrigger)((Object)trigger);
                        DataspaceStateHolder stateHolder = recompiledTrigger.aggregateStateHolder();
                        String collectionName = "n/a";
                        String triggerType = "EVENT";
                        if (recompiledTrigger instanceof ReplicationEventTrigger) {
                            AbstractReplicationEntity replicationEntity = ((ReplicationEventTrigger)recompiledTrigger).getReplicationEntity();
                            if (replicationEntity instanceof ReplicationSource) {
                                triggerType = "REPLICA SOURCE";
                                collectionName = ((ReplicationSource)replicationEntity).getReplicationEntityName().getSourceOrReplicaName();
                            } else {
                                triggerType = "REPLICA TARGET";
                                collectionName = ((ReplicationTarget)replicationEntity).getTargetEntityName().getFullNameNoDataspaceTypeNoNodeName();
                            }
                        } else if (recompiledTrigger instanceof ReplicationValidateTrigger) {
                            replicationTarget = ((ReplicationValidateTrigger)recompiledTrigger).getReplicationTarget();
                            triggerType = "VALIDATE TRIGGER";
                            collectionName = replicationTarget.getTargetEntityName().getFullNameNoDataspaceTypeNoNodeName();
                        } else if (recompiledTrigger instanceof ReplicationModifyTrigger) {
                            replicationTarget = ((ReplicationModifyTrigger)recompiledTrigger).getReplicationTarget();
                            triggerType = "MODIFY TRIGGER";
                            collectionName = replicationTarget.getTargetEntityName().getFullNameNoDataspaceTypeNoNodeName();
                        } else if (recompiledTrigger instanceof WindowTriggerDefSQL) {
                            triggerType = "WINDOW";
                            if (recompiledTrigger.getObjectName().parent != null) {
                                collectionName = recompiledTrigger.getObjectName().parent.name;
                            }
                        } else if (recompiledTrigger.getObjectName().parent != null) {
                            collectionName = recompiledTrigger.getObjectName().parent.name;
                        }
                        if (collection != null && !collectionName.equals(collection.getObjectName().name)) continue;
                        Map triggersByCollectionByType = triggersByCollection.getOrDefault(collectionName, new HashMap());
                        triggersByCollection.put(collectionName, triggersByCollectionByType);
                        TreeMap<Integer, Object> triggersByCollectionByTypeByAbsoluteIndex = triggersByCollectionByType.getOrDefault(triggerType, new TreeMap());
                        triggersByCollectionByType.put(triggerType, triggersByCollectionByTypeByAbsoluteIndex);
                        List rows = triggersByCollectionByTypeByAbsoluteIndex.getOrDefault(trigger.getActionTimingIndex(), new ArrayList());
                        triggersByCollectionByTypeByAbsoluteIndex.put(trigger.getActionTimingIndex(), rows);
                        rows.add(new Object[]{trigger, new Object[]{trigger.getObjectName().name, collectionName, triggerType, trigger.getActionTimingString() + " " + trigger.getOperationTypeString(), trigger.getActionTimingIndex(), trigger.getTriggerOrderString(), recompiledTrigger.getStateName((DataspaceStoreState)((Object)stateHolder.getState())), stateHolder.getLastOrSyntaxOrAllErrors(), SqlUtils.getObjectCreatedTimestamp(session, trigger), SqlUtils.getObjectModifiedTimestamp(session, trigger)}});
                    }
                    for (Map map : triggersByCollection.values()) {
                        for (TreeMap triggersForCollectionForType : map.values()) {
                            int absoluteIndex = 1;
                            for (List triggersForCollectionForTypeForAbsoluteIndex : triggersForCollectionForType.values()) {
                                triggersForCollectionForTypeForAbsoluteIndex.sort(Comparator.comparingInt(c -> ((TriggerDef)c[0]).triggerOrder));
                                for (Object[] row : triggersForCollectionForTypeForAbsoluteIndex) {
                                    ((Object[])row[1])[4] = "" + absoluteIndex++;
                                    navigator.add((Object[])row[1]);
                                }
                            }
                        }
                    }
                    return result;
                }
                catch (DataspaceException e79) {
                    return Result.newErrorResult(e79, this.sql);
                }
            }
            case 3157: {
                try {
                    DataspaceSchema schema = (DataspaceSchema)this.parameters[0];
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Name", "Action Events", "State", "Last Error", "Created", "Last Modified"});
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    com.streamscape.ds.lib.Iterator it = session.dataspaceStore.schemaManager.dataspaceObjectIterator(schema.getObjectName().name, 32);
                    while (it.hasNext()) {
                        Actor handler = (Actor)it.next();
                        boolean first = true;
                        StringBuilder buffer = new StringBuilder();
                        for (Actor.ActorEntry entry5 : handler.getActorEntries()) {
                            buffer.append(first ? "" : ", ").append(StringUtils.wrapEventId(entry5.getEventId()));
                            if (entry5.getSelector() != null) {
                                buffer.append(' ').append("WHEN").append(' ').append("(").append(entry5.getSelector()).append(")");
                            }
                            first = false;
                        }
                        DataspaceStateHolder dataspaceStateHolder = handler.aggregateStateHolder();
                        navigator.add(new Object[]{handler.getObjectName().name, buffer.toString(), handler.getStateName((DataspaceStoreState)((Object)dataspaceStateHolder.getState())), dataspaceStateHolder.getLastOrSyntaxOrAllErrors(), SqlUtils.getObjectCreatedTimestamp(session, handler), SqlUtils.getObjectModifiedTimestamp(session, handler)});
                    }
                    return result;
                }
                catch (DataspaceException e80) {
                    return Result.newErrorResult(e80, this.sql);
                }
            }
            case 3206: {
                try {
                    DataspaceSchema schema = (DataspaceSchema)this.parameters[0];
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Name", "Source Column", "Source Spath", "Target Column", "Target Spath", "Nullable", "Facet Join", "Aspect Join", "State", "Last Error"});
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    com.streamscape.ds.lib.Iterator it = session.dataspaceStore.schemaManager.dataspaceObjectIterator(schema.getObjectName().name, 37);
                    while (it.hasNext()) {
                        ReferenceLink referenceLink = (ReferenceLink)it.next();
                        DataspaceStateHolder stateHolder = referenceLink.aggregateStateHolder();
                        navigator.add(new Object[]{referenceLink.getObjectName().name, ReferenceLink.buildColumnName(referenceLink.getSourceColumnObjectName()), referenceLink.getSourceSpath(), ReferenceLink.buildColumnName(referenceLink.getTargetColumnObjectName()), referenceLink.getTargetSpath(), String.valueOf(referenceLink.isNullable()), referenceLink.getFacetsJoin() != null ? referenceLink.getFacetsJoin().getSQL() : "", referenceLink.getAspectsJoin() != null ? referenceLink.getAspectsJoin().getSQL() : "", ((DataspaceStoreState)((Object)stateHolder.getState())).toString(), stateHolder.getLastOrSyntaxOrAllErrors()});
                    }
                    return result;
                }
                catch (DataspaceException e81) {
                    return Result.newErrorResult(e81, this.sql);
                }
            }
            case 3074: {
                try {
                    NameManager.ObjectName schemaName = (NameManager.ObjectName)this.parameters[0];
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR});
                    metaData.columnLabels = new String[]{"Timer", "Group"};
                    metaData.columns = new ColumnBase[2];
                    ColumnBase column4 = new ColumnBase("", "", "", "");
                    column4.setType(Type.SQL_VARCHAR);
                    metaData.columns[0] = column4;
                    column4 = new ColumnBase("", "", "", "");
                    column4.setType(Type.SQL_VARCHAR);
                    metaData.columns[1] = column4;
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    com.streamscape.ds.lib.Iterator it = session.dataspaceStore.schemaManager.dataspaceObjectIterator(schemaName.name, 30);
                    while (it.hasNext()) {
                        TimerObject timer = (TimerObject)it.next();
                        navigator.add(new Object[]{timer.getObjectName().name, timer.getTimerGroup()});
                    }
                    return result;
                }
                catch (DataspaceException e82) {
                    return Result.newErrorResult(e82, this.sql);
                }
            }
            case 3171: {
                try {
                    SchemaObject object = (SchemaObject)this.parameters[0];
                    NameManager.ObjectName schemaName = (NameManager.ObjectName)this.parameters[1];
                    if (object == null) {
                        ResultMetaData metaData = this.createMetaData(new Pair<String, CharacterType>("Object Type", Type.SQL_VARCHAR), new Pair<String, CharacterType>("Object Name", Type.SQL_VARCHAR), new Pair<String, CharacterType>("Event Id", Type.SQL_VARCHAR), new Pair<String, CharacterType>("Event Type", Type.SQL_VARCHAR), new Pair<String, CharacterType>("Event Scope", Type.SQL_VARCHAR), new Pair<String, BooleanType>("Event Selector", Type.SQL_BOOLEAN), new Pair<String, BooleanType>("Trigger", Type.SQL_BOOLEAN), new Pair<String, CharacterType>("Event Model", Type.SQL_VARCHAR));
                        RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                        Result result = Result.newDataResult(metaData);
                        result.setNavigator(navigator);
                        com.streamscape.ds.lib.Iterator it = session.dataspaceStore.schemaManager.dataspaceObjectIterator(schemaName.name, 4);
                        while (it.hasNext()) {
                            Collection collection = (Collection)it.next();
                            this.processCollectionEvents(navigator, collection, true);
                        }
                        it = session.dataspaceStore.schemaManager.dataspaceObjectIterator(schemaName.name, 32);
                        while (it.hasNext()) {
                            Actor actor = (Actor)it.next();
                            this.processActorEvents(navigator, actor, true);
                        }
                        it = session.dataspaceStore.schemaManager.dataspaceObjectIterator(schemaName.name, 17);
                        while (it.hasNext()) {
                            RoutineSchema routineSchema = (RoutineSchema)it.next();
                            this.processFunctionEvents(navigator, routineSchema, true);
                        }
                        return result;
                    }
                    ResultMetaData metaData = this.createMetaData(new Pair<String, CharacterType>("Event Id", Type.SQL_VARCHAR), new Pair<String, CharacterType>("Event Type", Type.SQL_VARCHAR), new Pair<String, CharacterType>("Event Scope", Type.SQL_VARCHAR), new Pair<String, BooleanType>("Event Selector", Type.SQL_BOOLEAN), new Pair<String, BooleanType>("Triggers", Type.SQL_BOOLEAN), new Pair<String, CharacterType>("Event Model", Type.SQL_VARCHAR));
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    if (object instanceof Collection) {
                        this.processCollectionEvents(navigator, (Collection)object, false);
                        return result;
                    } else if (object instanceof EventTriggerDefSQL) {
                        this.processEventTriggerEvents(navigator, (EventTriggerDefSQL)object, false);
                        return result;
                    } else if (object instanceof Actor) {
                        this.processActorEvents(navigator, (Actor)object, false);
                        return result;
                    } else {
                        if (!(object instanceof RoutineSchema)) return result;
                        this.processFunctionEvents(navigator, (RoutineSchema)object, false);
                    }
                    return result;
                }
                catch (DataspaceException e83) {
                    return Result.newErrorResult(e83, this.sql);
                }
            }
            case 3109: {
                try {
                    ServerRole serveRole = (ServerRole)((Object)this.parameters[0]);
                    String serverType = (String)this.parameters[1];
                    NameManager.ObjectName schemaName = (NameManager.ObjectName)this.parameters[2];
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Name", "Role", "Type", "Dataspace", "Factory", "Started", "State", "Invalid", "Last Error"});
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    com.streamscape.ds.lib.Iterator it = null;
                    if (schemaName == null) {
                        for (DataspaceSchema schema : session.dataspaceStore.schemaManager.getAllSchemas()) {
                            com.streamscape.ds.lib.Iterator it1 = session.dataspaceStore.schemaManager.dataspaceObjectIterator(schema.getObjectName().name, 27);
                            it = it != null ? new WrapperIterator(it, it1) : it1;
                        }
                    } else {
                        it = session.dataspaceStore.schemaManager.dataspaceObjectIterator(schemaName.name, 27);
                    }
                    while (it.hasNext()) {
                        ServerObject server = (ServerObject)it.next();
                        if (serveRole != null && server.getServerRole() != serveRole || serverType != null && server.getServerType() != null && !server.getServerType().toLowerCase().contains(serverType.toLowerCase())) continue;
                        String string = server.getFactoryType() != null && server.getFactoryName() != null ? server.getFactoryType() + "." + server.getFactoryName() : "";
                        navigator.add(new Object[]{server.getObjectName().name, server.getServerRole().getRoleName(), server.getServerType(), server.getObjectName().schema.name, string, server.isRunning() ? "x" : "", server.getConnectionState().toString(), server.isInvalid() ? "x" : "", server.getLastError() != null ? server.getLastError() : ""});
                    }
                    return result;
                }
                catch (DataspaceException e84) {
                    return Result.newErrorResult(e84, this.sql);
                }
            }
            case 3119: {
                try {
                    NameManager.ObjectName schemaName = (NameManager.ObjectName)this.parameters[0];
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"NAME", "TYPE"});
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    com.streamscape.ds.lib.Iterator it = session.dataspaceStore.schemaManager.dataspaceObjectIterator(schemaName.name, 31);
                    while (it.hasNext()) {
                        JobObject job = (JobObject)it.next();
                        navigator.add(new Object[]{job.getObjectName().name, job.getJobType().getTypeName()});
                    }
                    return result;
                }
                catch (DataspaceException e85) {
                    return Result.newErrorResult(e85, this.sql);
                }
            }
            case 3343: {
                ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Future Id", "User Key", "State", "Created At", "Scheduled At", "Interval Seconds", "Session ID", "Function SQL", "Interval SQL", "Argument Values"});
                RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                Result result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                session.dataspaceStore.futureFunctionManager.getFutures().values().stream().sorted((f1, f2) -> Long.compare(f1.getInfo().getCreatedAtUtc(), f2.getInfo().getCreatedAtUtc())).forEach(f -> navigator.add(new Object[]{f.getId().toString(), f.getInfo().getUserKey() != null ? f.getInfo().getUserKey() : "", f.getFutureFucntionState(), DataspaceDateTime.formatTimestamp(session, f.getInfo().getCreatedAtUtc()), DataspaceDateTime.formatTimestamp(session, f.getInfo().getCreatedAtUtc() + (long)(f.getInfo().getIntervalSeconds() * 1000)), f.getInfo().getIntervalSeconds(), f.getInfo().getSessionId() != null ? f.getInfo().getSessionId() : "", f.getInfo().getFunctionSql(), f.getInfo().getFunctionIntervalSql(), f.getFutureParams().stream().map(String::valueOf).collect(Collectors.joining(", "))}));
                return result;
            }
            case 3183: {
                try {
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_TIMESTAMP, Type.SQL_VARCHAR, Type.SQL_BOOLEAN, Type.SQL_BOOLEAN, Type.SQL_BOOLEAN, Type.SQL_BIGINT, Type.SQL_BOOLEAN, Type.SQL_BIGINT, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_BIGINT, Type.SQL_BIGINT, Type.SQL_VARCHAR, Type.SQL_BIGINT, Type.SQL_BIGINT, Type.SQL_BIGINT}, new String[]{"ID", "CONNECTED", "USER", "IS_ADMIN", "AUTOCOMMIT", "READONLY", "LAST_IDENTITY", "IN_TRAN", "TRAN_SIZE", "DATASPACE", "WAITING_FOR_THIS", "THIS_WAITING_FOR", "CURRENT_STMT", "LAST_STMT", "LATCH_COUNT", "STMT_NESTED_LEVEL", "REPLICATION_LOCK", "REPLICATION_NESTED", "CURRENT_THREAD", "LAST_THREAD"});
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    long lastIdentity = 0L;
                    String currentDataspace = "";
                    long currentThread = -1L;
                    long lastThread = -1L;
                    boolean all = (Boolean)this.parameters[0];
                    boolean active = (Boolean)this.parameters[1];
                    Session[] sessions = session.dataspaceStore.collectionSessionManager.getVisibleSessions(session);
                    for (int i = 0; i < sessions.length; ++i) {
                        Statement st;
                        if (sessions[i].isClosed() || !session.isSDSRuntimeSession() && !all && !session.currentDataspace.equals(sessions[i].currentDataspace)) continue;
                        Session s = sessions[i];
                        long sessionId = ValuePool.getLong(s.getId());
                        TimestampData connectTime = new TimestampData(s.getConnectTime() + (long)(session.getZoneSeconds() * 1000));
                        String string = s.getUsername();
                        boolean isAdmin = ValuePool.getBoolean(s.isAdmin());
                        boolean isAutocommit = s.sessionContext.isAutoCommit;
                        boolean isReadonly = s.isReadOnlyDefault;
                        Number lastId = s.getLastIdentity();
                        if (lastId != null) {
                            lastIdentity = ValuePool.getLong(lastId.longValue());
                        }
                        boolean inTran = s.isInMidTransaction();
                        long transactionSize = ValuePool.getLong(s.getTransactionSize());
                        NameManager.ObjectName name11 = s.getCurrentDataspaceName();
                        if (name11 != null) {
                            currentDataspace = name11.name;
                        }
                        BiConsumer<StringBuilder, OrderedHashSet> sessionsToString = (builder, set) -> {
                            String postfix = "";
                            if (builder.length() > 0) {
                                postfix = builder.toString();
                                builder.setLength(0);
                            }
                            if (set.size() > 0) {
                                Object[] array = new Session[set.size()];
                                set.toArray(array);
                                for (int j = 0; j < array.length; ++j) {
                                    if (j > 0) {
                                        builder.append(',');
                                    }
                                    builder.append(((Session)array[j]).getId()).append(postfix);
                                }
                            }
                        };
                        StringBuilder builder2 = new StringBuilder();
                        sessionsToString.accept(builder2, s.waitingSessions);
                        Object waitingForThis = builder2.toString();
                        builder2 = new StringBuilder();
                        builder2.append("R");
                        sessionsToString.accept(builder2, s.replicationWaitingSessions);
                        if (builder2.length() > 0) {
                            if (((String)waitingForThis).length() > 0) {
                                waitingForThis = (String)waitingForThis + ",";
                            }
                            waitingForThis = (String)waitingForThis + builder2.toString();
                        }
                        if (((String)waitingForThis).length() == 0) {
                            waitingForThis = "-";
                        }
                        builder2 = new StringBuilder();
                        sessionsToString.accept(builder2, s.waitedSessions);
                        Object thisWaitingFor = builder2.toString();
                        builder2 = new StringBuilder();
                        builder2.append("R");
                        sessionsToString.accept(builder2, s.replicationWaitedSessions);
                        if (builder2.length() > 0) {
                            if (((String)thisWaitingFor).length() > 0) {
                                thisWaitingFor = (String)thisWaitingFor + ",";
                            }
                            thisWaitingFor = (String)thisWaitingFor + builder2.toString();
                        }
                        if (((String)thisWaitingFor).length() == 0) {
                            thisWaitingFor = "-";
                        }
                        String currentStat = (st = s.sessionContext.currentStatement) == null ? "-" : st.getSQL();
                        String lastStat = s.sessionContext.lastStatement;
                        if (lastStat == null) {
                            lastStat = "-";
                        }
                        long latchCount = new Long(s.latch.getCount());
                        long nestedLevel = s.getCurrentStatementCounter();
                        String replicationLock = s.replicationLockObjectName != null ? s.replicationLockObjectName.getSchemaQualifiedStatementName() : "-";
                        long replicationNested = s.replicationLockManualDepth;
                        currentThread = s.getCurrentThreadId();
                        lastThread = s.getLastThreadId();
                        if (active && st == null) continue;
                        navigator.add(new Object[]{sessionId, connectTime, string, isAdmin, isAutocommit, isReadonly, lastIdentity, inTran, transactionSize, currentDataspace, waitingForThis, thisWaitingFor, currentStat, lastStat, latchCount, nestedLevel, replicationLock, replicationNested, currentThread, lastThread});
                    }
                    return result;
                }
                catch (DataspaceException e86) {
                    return Result.newErrorResult(e86, this.sql);
                }
            }
            case 3186: {
                ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING}, new String[]{"Property", "Value"});
                RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                Result result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                DataspaceStoreProperties properites = session.dataspaceStore.dataspaceStoreProperties;
                com.streamscape.ds.lib.Set names = properites.listProperties();
                ArrayList<String> nameList = new ArrayList<String>();
                com.streamscape.ds.lib.Iterator iterator = names.iterator();
                while (iterator.hasNext()) {
                    nameList.add((String)iterator.next());
                }
                Collections.sort(nameList);
                nameList.forEach(name -> navigator.add(new Object[]{name, properites.getPropertyString((String)name)}));
                return result;
            }
            case 3187: {
                String propertyName = (String)this.parameters[0];
                Object propertyValue = this.parameters[1];
                if (propertyValue != null) {
                    propertyValue = String.valueOf(propertyValue);
                }
                Result result = Result.updateNoResult;
                if (propertyName.equals("dtspace.query_mem_limit")) {
                    session.dataspaceStore.queryMemoryMonitor.setThresholdPercent(Integer.valueOf((String)propertyValue));
                } else if (propertyName.equals("dtspace.query_mem_limit_chk_rows_start")) {
                    session.dataspaceStore.queryMemoryMonitor.setChkRowsStart(Integer.valueOf((String)propertyValue));
                } else if (propertyName.equals("dtspace.query_mem_limit_chk_rows_interval")) {
                    session.dataspaceStore.queryMemoryMonitor.setChkRowsInterval(Integer.valueOf((String)propertyValue));
                } else if (propertyName.equals("dtspace.typesafe")) {
                    OtherType.typeSafe = Boolean.valueOf(((String)propertyValue).toUpperCase());
                } else if (!(propertyName.equals("dtspace.governor.unit_est_time_ms") || propertyName.equals("dtspace.governor.unit_size") || propertyName.equals("dtspace.governor") || propertyName.equals("dtspace.serializer.date_format") || propertyName.equals("dtspace.serializer.sqltimestamp_format") || propertyName.equals("dtspace.serializer.sqltime_format") || propertyName.equals("dtspace.serializer.sqldate_format"))) {
                    if (propertyName.equals("dtspace.tx_conflict_spin_lock_timeout")) {
                        session.dataspaceStore.txConflictSpinLockTimeout = Integer.valueOf((String)propertyValue).intValue();
                    } else {
                        result = Result.newSingleColumnStringResult("WARNING", "Node should be restarted to take into account new property value.");
                    }
                }
                session.dataspaceStore.dataspaceStoreProperties.setProperty(propertyName, (String)propertyValue);
                session.dataspaceStore.persistStoreState();
                return result;
            }
            case 3121: 
            case 3122: {
                JobObject jobObject = (JobObject)this.parameters[0];
                switch (this.type) {
                    case 3121: {
                        jobObject.startJob();
                        return Result.updateNoResult;
                    }
                    case 3122: {
                        jobObject.stopJob();
                    }
                }
                return Result.updateNoResult;
            }
            case 3083: {
                Boolean all = (Boolean)this.parameters[0];
                try {
                    ResultMetaData metaData = all != false ? ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"System Domain", "User Domain"}) : ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Domain", "State"});
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    if (all.booleanValue()) {
                        com.streamscape.ds.lib.Iterator it1 = session.dataspaceStore.schemaManager.dataspaceObjectIterator("SYS", 14);
                        com.streamscape.ds.lib.Iterator it2 = session.dataspaceStore.schemaManager.dataspaceObjectIterator(session.getCurrentDataspaceName().name, 14);
                        while (it1.hasNext() || it2.hasNext()) {
                            Type system = null;
                            Type user = null;
                            if (it1.hasNext()) {
                                system = (Type)it1.next();
                            }
                            if (it2.hasNext()) {
                                user = (Type)it2.next();
                            }
                            if ((system == null || !system.isDomainType()) && (user == null || !user.isDomainType())) continue;
                            Object[] objectArray = new Object[2];
                            Object object = system != null && system.isDomainType() ? system.getObjectName().name + (system.userTypeModifier.aggregateStateHolder().isSuspectState() ? "(SUSPECT)" : "") : (objectArray[0] = "");
                            objectArray[1] = user != null && user.isDomainType() ? user.getObjectName().name + (user.userTypeModifier.aggregateStateHolder().isSuspectState() ? "(SUSPECT)" : "") : "";
                            navigator.add(objectArray);
                        }
                        return result;
                    } else {
                        com.streamscape.ds.lib.Iterator it = session.dataspaceStore.schemaManager.dataspaceObjectIterator(session.getCurrentDataspaceName().name, 14);
                        while (it.hasNext()) {
                            Type type = (Type)it.next();
                            if (!type.isDomainType()) continue;
                            navigator.add(new Object[]{type.getObjectName().name, ((DataspaceStoreState)((Object)type.userTypeModifier.aggregateStateHolder().getState())).toString()});
                        }
                    }
                    return result;
                }
                catch (DataspaceException e87) {
                    return Result.newErrorResult(e87, this.sql);
                }
            }
            case 3197: {
                try {
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Type Name", "State"});
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    com.streamscape.ds.lib.Iterator it = session.dataspaceStore.schemaManager.dataspaceObjectIterator("SYS", 13);
                    while (it.hasNext()) {
                        Type t = (Type)it.next();
                        if (!t.isDistinctType()) continue;
                        navigator.add(new Object[]{t.getObjectName().name, ((DataspaceStoreState)((Object)t.userTypeModifier.aggregateStateHolder().getState())).toString()});
                    }
                    return result;
                }
                catch (DataspaceException e88) {
                    return Result.newErrorResult(e88, this.sql);
                }
            }
            case 3199: {
                try {
                    DataspaceStateHolder stateHolder;
                    NameManager.ObjectName schemaName = (NameManager.ObjectName)this.parameters[0];
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Object Type", "Object Name", "State", "Last Error"});
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    ArrayList<ReplicationSource> replicationSources = new ArrayList<ReplicationSource>();
                    com.streamscape.ds.lib.Iterator iterator = session.dataspaceStore.schemaManager.dataspaceObjectIterator(schemaName.name, 4);
                    while (iterator.hasNext()) {
                        AbstractCollection collection = (AbstractCollection)iterator.next();
                        DataspaceStateHolder stateHolder2 = collection.aggregateStateHolder();
                        navigator.add(new Object[]{AbstractCollection.getCollectionTypeName(collection.getCollectionType()), collection.getObjectName().name, ((DataspaceStoreState)((Object)stateHolder2.getState())).toString(), stateHolder2.getLastOrSyntaxOrAllErrors()});
                        if (collection.getReplicationSource() == null) continue;
                        replicationSources.add(collection.getReplicationSource());
                    }
                    for (ReplicationSource replicationSource : replicationSources) {
                        ReplicationSource.ReplicationError replicationError = replicationSource.getReplicationErrors();
                        navigator.add(new Object[]{"REPLICATION SOURCE", replicationSource.getObjectName().name, ((DataspaceStoreState)((Object)((AbstractCollection)replicationSource.getCollection()).getStateHolder().getState())).toString(), replicationError.getLastReplicationError() != null ? replicationError.getLastReplicationError() : ""});
                    }
                    com.streamscape.ds.lib.Iterator iterator2 = session.dataspaceStore.schemaManager.dataspaceObjectIterator(schemaName.name, 29);
                    while (iterator2.hasNext()) {
                        ReplicationTarget replica = (ReplicationTarget)iterator2.next();
                        String error = replica.getLastError();
                        navigator.add(new Object[]{"REPLICA", replica.getName(), replica.getState().getStateWithSourceDisabled(replica.isSourceEnabled()), error != null ? error : ""});
                    }
                    iterator2 = session.dataspaceStore.schemaManager.dataspaceObjectIterator(schemaName.name, 19);
                    iterator2 = new WrapperIterator(iterator2, session.dataspaceStore.schemaManager.dataspaceObjectIterator(schemaName.name, 32));
                    iterator2 = new WrapperIterator(iterator2, session.dataspaceStore.schemaManager.dataspaceObjectIterator(schemaName.name, 9));
                    while (iterator2.hasNext()) {
                        SchemaObject schemaObject = (SchemaObject)iterator2.next();
                        RplSchemaObject rpl = null;
                        String type = null;
                        if (schemaObject instanceof Actor) {
                            type = "ACTOR";
                            rpl = (RplSchemaObject)((Object)schemaObject);
                        } else if (schemaObject instanceof EventTriggerDefSQL) {
                            type = "TRIGGER";
                            rpl = (RplSchemaObject)((Object)schemaObject);
                        } else if (schemaObject instanceof RoutineSchema) {
                            type = "FUNCTION";
                            rpl = ((RoutineSchema)schemaObject).routines[0];
                        }
                        if (rpl == null) continue;
                        DataspaceStateHolder dataspaceStateHolder = rpl.aggregateStateHolder();
                        navigator.add(new Object[]{type, rpl.getObjectName().name, rpl.getStateName((DataspaceStoreState)((Object)dataspaceStateHolder.getState())), dataspaceStateHolder.getLastOrSyntaxOrAllErrors()});
                    }
                    iterator2 = session.dataspaceStore.schemaManager.dataspaceObjectIterator(schemaName.name, 8);
                    while (iterator2.hasNext()) {
                        NumberSequence sequence = (NumberSequence)iterator2.next();
                        navigator.add(new Object[]{"SEQUENCE", sequence.getObjectName().name, "ONLINE", ""});
                    }
                    iterator2 = session.dataspaceStore.schemaManager.dataspaceObjectIterator(schemaName.name, 37);
                    while (iterator2.hasNext()) {
                        ReferenceLink link = (ReferenceLink)iterator2.next();
                        stateHolder = link.aggregateStateHolder();
                        navigator.add(new Object[]{"REFERENCE LINK", link.getObjectName().name, ((DataspaceStoreState)((Object)stateHolder.getState())).toString(), stateHolder.getLastOrSyntaxOrAllErrors()});
                    }
                    iterator2 = session.dataspaceStore.schemaManager.dataspaceObjectIterator(schemaName.name, 27);
                    while (iterator2.hasNext()) {
                        ServerObject server = (ServerObject)iterator2.next();
                        stateHolder = server.aggregateObjectStateHolder();
                        navigator.add(new Object[]{"SERVER", server.getObjectName().name, ((DataspaceStoreState)((Object)stateHolder.getState())).toString(), stateHolder.getLastOrSyntaxOrAllErrors()});
                    }
                    return result;
                }
                catch (DataspaceException e89) {
                    return Result.newErrorResult(e89, this.sql);
                }
            }
            case 3200: {
                SchemaObject o;
                SchemaObject schemaObject = (SchemaObject)this.parameters[0];
                ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Object Type", "Object Name"});
                RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                Result result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                OrderedHashSet references = session.dataspaceStore.schemaManager.getReferencesTo(schemaObject.getObjectName());
                com.streamscape.ds.lib.Iterator iterator = references.iterator();
                if (schemaObject.getObjectName().type == 4) {
                    o = session.dataspaceStore.schemaManager.findSchemaObject(schemaObject.getObjectName().name, schemaObject.getObjectName().schema.name, 3);
                    if (o != null) {
                        iterator = new WrapperIterator(iterator, session.dataspaceStore.schemaManager.getReferencesTo(o.getObjectName()).iterator());
                    }
                } else if (schemaObject.getObjectName().type == 3 && (o = session.dataspaceStore.schemaManager.findSchemaObject(schemaObject.getObjectName().name, schemaObject.getObjectName().schema.name, 4)) != null) {
                    iterator = new WrapperIterator(iterator, session.dataspaceStore.schemaManager.getReferencesTo(o.getObjectName()).iterator());
                }
                if (schemaObject.getObjectName().type == 17 && (o = session.dataspaceStore.schemaManager.findSchemaObject(schemaObject.getObjectName().name, schemaObject.getObjectName().schema.name, 25)) != null && o instanceof RplScript) {
                    iterator = new WrapperIterator(iterator, session.dataspaceStore.schemaManager.getReferencesTo(((RplScript)o).getSpecificName()).iterator());
                }
                while (iterator.hasNext()) {
                    NameManager.ObjectName reference = (NameManager.ObjectName)iterator.next();
                    if (reference.type == 10 && reference.parent != null) {
                        reference = reference.parent;
                    }
                    navigator.add(new Object[]{SqlUtils.getSchemaObjectType(reference.type), reference.name});
                }
                return result;
            }
            case 3061: {
                try {
                    DataspaceSchema schema = (DataspaceSchema)this.parameters[0];
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_INTEGER, Type.SQL_INTEGER}, new String[]{"Collection Name", "Fully Qualified Name", "Event Scope", "Enabled", "Mode", "Total Replicas", "Replica Names", "Replication Id", "Committed Id"});
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    com.streamscape.ds.lib.Iterator it = session.dataspaceStore.schemaManager.dataspaceObjectIterator(schema.getObjectName().name, 4);
                    while (it.hasNext()) {
                        Collection collection = (Collection)it.next();
                        ReplicationSource r3 = collection.getReplicationSource();
                        if (r3 == null) continue;
                        List<ReplicaInfo> replicas = r3.listReplicas(session);
                        navigator.add(new Object[]{collection.getObjectName().name, r3.getReplicationEntityName().getFullName(), r3.getEventScope(), r3.isEnabled(), r3.getReplicationSourceSettings().sync != false ? "Sync" : "Async", replicas.size(), ReplicationUtil.formattedOutputReplicaList(replicas, true), r3.getReplicationId(), r3.getCommittedReplicationId()});
                    }
                    return result;
                }
                catch (DataspaceException e90) {
                    return Result.newErrorResult(e90, this.sql);
                }
            }
            case 3228: {
                try {
                    DataspaceSchema schema = (DataspaceSchema)this.parameters[0];
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR}, new String[]{"Replication Queue Name"});
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    com.streamscape.ds.lib.Iterator it = session.dataspaceStore.schemaManager.dataspaceObjectIterator(schema.getObjectName().name, 4);
                    while (it.hasNext()) {
                        Collection collection = (Collection)it.next();
                        ReplicationSource r4 = collection.getReplicationSource();
                        if (r4 == null || r4.getReplicationQueue() == null) continue;
                        navigator.add(new Object[]{ReplicationQueue.getQueueName(collection.getObjectName().schema.name, collection.getObjectName().name)});
                    }
                    return result;
                }
                catch (DataspaceException e91) {
                    return Result.newErrorResult(e91, this.sql);
                }
            }
            case 3065: {
                try {
                    DataspaceSchema schema = (DataspaceSchema)this.parameters[0];
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Replica Name", "Fully Qualified Source Name", "Fully Qualified Target Name", "Target Collection Name", "Event Scope", "Mode", "State", "Suspended", "ReplicationId", "Last Error", "MetaSchema"});
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    com.streamscape.ds.lib.Iterator it = session.dataspaceStore.schemaManager.dataspaceObjectIterator(schema.getObjectName().name, 29);
                    while (it.hasNext()) {
                        ReplicationTarget target = (ReplicationTarget)it.next();
                        Object[] objectArray = new Object[11];
                        objectArray[0] = target.getObjectName().name;
                        objectArray[1] = target.getSourceEntityName().getFullName();
                        objectArray[2] = target.getTargetEntityName().getFullName();
                        objectArray[3] = target.getTargetCollectionName();
                        objectArray[4] = target.getEventScope().toString();
                        objectArray[5] = target.isSyncSet() ? (target.isSync() ? "Sync" : "Async") : "n/a";
                        objectArray[6] = target.getState().getStateWithSourceDisabled(target.isSourceEnabled());
                        objectArray[7] = target.isSuspended();
                        objectArray[8] = target.getReplicationId();
                        objectArray[9] = target.getLastError() != null ? target.getLastError() : "";
                        objectArray[10] = target.getMetaSchema().toString();
                        navigator.add(objectArray);
                    }
                    return result;
                }
                catch (DataspaceException e92) {
                    return Result.newErrorResult(e92, this.sql);
                }
            }
            case 3053: {
                try {
                    DataspaceSchema schema = (DataspaceSchema)this.parameters[0];
                    Boolean all = (Boolean)this.parameters[1];
                    Boolean attrs = (Boolean)this.parameters[2];
                    Boolean lib = (Boolean)this.parameters[3];
                    ResultMetaData metaData = all != false ? ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"User Function", "System Function"}) : (attrs != false ? ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Function", "State", "Last Error", "Created", "Last Modified", "Event Capable", "Collection Capable"}) : (lib != false ? ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Function Unit Name", "Functions"}) : ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Function", "State", "Last Error", "Created", "Last Modified"})));
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    if (all.booleanValue()) {
                        com.streamscape.ds.lib.Iterator it = session.dataspaceStore.schemaManager.dataspaceObjectIterator(schema.getObjectName().name, 17);
                        List<String> list = FunctionSQL.listFunctions();
                        int counter = -1;
                        while (it.hasNext()) {
                            RoutineSchema function = (RoutineSchema)it.next();
                            navigator.add(new Object[]{function.getObjectName().name, ++counter < list.size() ? list.get(counter) : ""});
                        }
                        while (counter < list.size() - 1) {
                            navigator.add(new Object[]{"", list.get(++counter)});
                        }
                        return result;
                    }
                    if (lib.booleanValue()) {
                        DataspaceFunctionUnitManagerForCompletion m = new DataspaceFunctionUnitManagerForCompletion();
                        m.listEntries().stream().sorted().map(name -> new Object[]{name, m.lookupFunctionUnit((String)name).listEntryNames().stream().sorted().collect(Collectors.joining("\n"))}).forEach(entry -> navigator.add((Object[])entry));
                        return result;
                    }
                    if (attrs.booleanValue()) {
                        com.streamscape.ds.lib.Iterator it = session.dataspaceStore.schemaManager.dataspaceObjectIterator(schema.getObjectName().name, 17);
                        while (it.hasNext()) {
                            RoutineSchema routineSchema = (RoutineSchema)it.next();
                            RplScript routine = null;
                            DataspaceStateHolder stateHolder = null;
                            try {
                                routine = routineSchema.routines[0];
                                stateHolder = routine.aggregateStateHolder();
                            }
                            catch (Throwable exception) {
                                stateHolder = new DataspaceStateHolder();
                                stateHolder.setLastError("Failed to get function state, error: " + exception.toString());
                            }
                            navigator.add(new Object[]{routineSchema.getObjectName().name, ((DataspaceStoreState)((Object)stateHolder.getState())).toString(), stateHolder.getLastOrSyntaxOrAllErrors(), SqlUtils.getObjectCreatedTimestamp(session, routine), SqlUtils.getObjectModifiedTimestamp(session, routine), routine.isEventCapable() ? "x" : "-", routine.isTableCapable() ? "x" : "-"});
                        }
                        return result;
                    }
                    com.streamscape.ds.lib.Iterator it = session.dataspaceStore.schemaManager.dataspaceObjectIterator(schema.getObjectName().name, 17);
                    while (it.hasNext()) {
                        RoutineSchema routineSchema = (RoutineSchema)it.next();
                        DataspaceStateHolder stateHolder = null;
                        try {
                            stateHolder = routineSchema.routines[0].aggregateStateHolder();
                        }
                        catch (Throwable exception) {
                            stateHolder = new DataspaceStateHolder();
                            stateHolder.setLastError("Failed to get function state, error: " + exception.toString());
                        }
                        navigator.add(new Object[]{routineSchema.getObjectName().name, ((DataspaceStoreState)((Object)stateHolder.getState())).toString(), stateHolder.getLastOrSyntaxOrAllErrors(), SqlUtils.getObjectCreatedTimestamp(session, routineSchema), SqlUtils.getObjectModifiedTimestamp(session, routineSchema)});
                    }
                    return result;
                }
                catch (DataspaceException e93) {
                    return Result.newErrorResult(e93, this.sql);
                }
            }
            case 3048: {
                try {
                    Result result = Result.newSingleColumnResult("User");
                    RowSetNavigator navigator = result.getNavigator();
                    List<User> users = DataspaceManager.getContext().getSecurityManager().getUsers();
                    Collections.sort(users);
                    for (User user : users) {
                        navigator.add(new Object[]{user.getName()});
                    }
                    return result;
                }
                catch (Exception e94) {
                    return Result.newErrorResult(e94, this.sql);
                }
            }
            case 3049: {
                try {
                    Result result = Result.newSingleColumnResult("Group");
                    RowSetNavigator navigator = result.getNavigator();
                    List<Group> groups = DataspaceManager.getContext().getSecurityManager().getGroups();
                    Collections.sort(groups);
                    for (Group group : groups) {
                        navigator.add(new Object[]{group.getName()});
                    }
                    return result;
                }
                catch (Exception e95) {
                    return Result.newErrorResult(e95, this.sql);
                }
            }
            case 3261: {
                try {
                    FullTextManager fullTextManager = session.dataspaceStore.getFullTextManager();
                    ArrayList<CharacterType> types = new ArrayList<CharacterType>();
                    types.add(Type.SQL_VARCHAR);
                    types.add(Type.SQL_VARCHAR);
                    ArrayList<String> columnNames = new ArrayList<String>();
                    columnNames.add("Name");
                    columnNames.add("Collections");
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(types.toArray(new Type[0]), columnNames.toArray(new String[0]));
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    com.streamscape.ds.lib.Iterator it = session.dataspaceStore.schemaManager.dataspaceObjectIterator(session.currentDataspace.name, 38);
                    while (it.hasNext()) {
                        FullTextIndex index = (FullTextIndex)it.next();
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(index.getObjectName().name);
                        arrayList.add(index.getColumnDescription());
                        Collections.addAll(arrayList, index.getListPropertyValues());
                        navigator.add(arrayList.toArray());
                    }
                    return result;
                }
                catch (Exception e96) {
                    return Result.newErrorResult(e96, this.sql);
                }
            }
            case 3296: {
                boolean keys = (Boolean)this.parameters[0];
                ResultMetaData metaData = keys ? ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_ARRAY_ALL_TYPES, Type.SQL_ARRAY_ALL_TYPES}, new String[]{"Facet Set", "Static", "Searchable", "Description", "Inferences", "Keys", "Types"}) : ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Facet Set", "Static", "Searchable", "Description", "Inferences"});
                RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                Result result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                com.streamscape.ds.lib.Iterator it = session.dataspaceStore.schemaManager.dataspaceObjectIterator("SDS", 41);
                while (it.hasNext()) {
                    FacetsSchemaObject facets = (FacetsSchemaObject)it.next();
                    if (keys) {
                        List columnKeys = facets.getColumns().stream().map(column -> column.getNameString()).collect(Collectors.toList());
                        List columnTypes = facets.getColumns().stream().map(column -> column.dataType.getDefinition()).collect(Collectors.toList());
                        navigator.add(new Object[]{facets.getObjectName().getStatementName(), facets.isStatic(), facets.isIndexed(), Optional.ofNullable(facets.getDescription()).orElse(""), "", columnKeys, columnTypes});
                        continue;
                    }
                    navigator.add(new Object[]{facets.getObjectName().getStatementName(), facets.isStatic(), facets.isIndexed(), Optional.ofNullable(facets.getDescription()).orElse(""), ""});
                }
                return result;
            }
            case 3322: {
                KNodeTypeSchemaObject schemaObject = (KNodeTypeSchemaObject)this.parameters[0];
                boolean keys = (Boolean)this.parameters[1];
                boolean asDdl = (Boolean)this.parameters[2];
                boolean asJson = (Boolean)this.parameters[3];
                if (keys) {
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Key", "Value Type"});
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    if (schemaObject.getColumns() == null) return result;
                    for (ColumnSchema columnSchema : schemaObject.getColumns()) {
                        navigator.add(new Object[]{columnSchema.getNameString(), columnSchema.getDataType().getDefinition()});
                    }
                    return result;
                }
                if (asDdl) {
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR}, new String[]{"STATEMENT"});
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    String sql = schemaObject.getSQL(schemaObject.getObjectName().name);
                    navigator.add(new Object[]{sql});
                    return result;
                }
                if (asJson) {
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR}, new String[]{"JSON"});
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    String json = schemaObject.toKNodeType().toJSON();
                    navigator.add(new Object[]{json});
                    return result;
                }
                ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Property", "Value"});
                RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                Result result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                navigator.add(new Object[]{"Name", schemaObject.getObjectName().getStatementName()});
                navigator.add(new Object[]{"Comment", Optional.ofNullable(schemaObject.getComment()).orElse("")});
                navigator.add(new Object[]{"Subject Key", schemaObject.getSubjectKey()});
                navigator.add(new Object[]{"Keys Count", schemaObject.getColumns().size()});
                return result;
            }
            case 3327: {
                KLinkTypeSchemaObject schemaObject = (KLinkTypeSchemaObject)this.parameters[0];
                boolean keys = (Boolean)this.parameters[1];
                boolean asDdl = (Boolean)this.parameters[2];
                boolean asJson = (Boolean)this.parameters[3];
                if (keys) {
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Key", "Value Type"});
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    if (schemaObject.getColumns() == null) return result;
                    for (ColumnSchema columnSchema : schemaObject.getColumns()) {
                        navigator.add(new Object[]{columnSchema.getNameString(), columnSchema.getDataType().getDefinition()});
                    }
                    return result;
                }
                if (asDdl) {
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR}, new String[]{"STATEMENT"});
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    String sql = schemaObject.getSQL(schemaObject.getObjectName().name);
                    navigator.add(new Object[]{sql});
                    return result;
                }
                if (asJson) {
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR}, new String[]{"JSON"});
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    String json = schemaObject.toKLinkType().toJSON();
                    navigator.add(new Object[]{json});
                    return result;
                }
                ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Property", "Value"});
                RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                Result result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                navigator.add(new Object[]{"Name", schemaObject.getObjectName().getStatementName()});
                navigator.add(new Object[]{"Comment", Optional.ofNullable(schemaObject.getComment()).orElse("")});
                navigator.add(new Object[]{"Keys Count", schemaObject.getColumns().size()});
                return result;
            }
            case 3332: {
                KGraphTypeSchemaObject schemaObject = (KGraphTypeSchemaObject)this.parameters[0];
                boolean asDdl = (Boolean)this.parameters[1];
                boolean facets = (Boolean)this.parameters[2];
                boolean knodes = (Boolean)this.parameters[3];
                boolean kassertions = (Boolean)this.parameters[4];
                boolean klinks = (Boolean)this.parameters[5];
                boolean asJson = (Boolean)this.parameters[6];
                if (asDdl) {
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR}, new String[]{"STATEMENT"});
                    RowSetNavigatorClient rowSetNavigatorClient = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(rowSetNavigatorClient);
                    String sql = schemaObject.getSQL(schemaObject.getObjectName().name);
                    rowSetNavigatorClient.add(new Object[]{sql});
                    return result;
                }
                if (asJson) {
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR}, new String[]{"JSON"});
                    RowSetNavigatorClient rowSetNavigatorClient = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(rowSetNavigatorClient);
                    String json = schemaObject.toKGraphType().toJSON();
                    rowSetNavigatorClient.add(new Object[]{json});
                    return result;
                }
                if (knodes) {
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"KNode Definition Name", "Subject Key Alias"});
                    RowSetNavigatorClient rowSetNavigatorClient = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(rowSetNavigatorClient);
                    for (KNodeTypeSchemaObject knode : schemaObject.getKnodes()) {
                        rowSetNavigatorClient.add(new Object[]{knode.getObjectName().name, knode.getSubjectKey()});
                    }
                    return result;
                }
                if (klinks) {
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"KLink Definition Name", "Facets"});
                    RowSetNavigatorClient rowSetNavigatorClient = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(rowSetNavigatorClient);
                    for (KLinkTypeSchemaObject klink : schemaObject.getKlinks()) {
                        Facets klinkFacets = schemaObject.getKlinksFacets().get(klink.getObjectName().name);
                        rowSetNavigatorClient.add(new Object[]{klink.getObjectName().name, FacetsUtils.facetsToString(klinkFacets)});
                    }
                    return result;
                }
                if (kassertions) {
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Subject KNode", "KLink", "Object KNode", "KLink Facets", "Occurency"});
                    RowSetNavigatorClient rowSetNavigatorClient = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(rowSetNavigatorClient);
                    for (KAssertionTypeSchemaObject kassertion : schemaObject.getAssertions()) {
                        Facets klinkFacets = schemaObject.getKlinksFacets().get(kassertion.getLinkType().getObjectName().name);
                        rowSetNavigatorClient.add(new Object[]{kassertion.getSubjectType().getObjectName().name, kassertion.getLinkType().getObjectName().name, kassertion.getObjectType().getObjectName().name, FacetsUtils.facetsToString(klinkFacets), kassertion.getOccurrency().toString()});
                    }
                    return result;
                }
                if (facets) {
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Name", "Type"});
                    RowSetNavigatorClient rowSetNavigatorClient = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(rowSetNavigatorClient);
                    for (ColumnSchema column5 : schemaObject.getColumns()) {
                        rowSetNavigatorClient.add(new Object[]{column5.getNameString(), column5.getDataType().getNameString()});
                    }
                    return result;
                }
                ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Property", "Value"});
                RowSetNavigatorClient rowSetNavigatorClient = new RowSetNavigatorClient();
                Result result = Result.newDataResult(metaData);
                result.setNavigator(rowSetNavigatorClient);
                rowSetNavigatorClient.add(new Object[]{"Name", schemaObject.getObjectName().getStatementName()});
                rowSetNavigatorClient.add(new Object[]{"Comment", Optional.ofNullable(schemaObject.getComment()).orElse("")});
                rowSetNavigatorClient.add(new Object[]{"KNodes", schemaObject.getKnodes().stream().map(n -> n.getObjectName().name).collect(Collectors.joining(", "))});
                rowSetNavigatorClient.add(new Object[]{"KLinks", schemaObject.getKlinks().stream().map(n -> n.getObjectName().name).collect(Collectors.joining(", "))});
                return result;
            }
            case 3336: {
                KGraphInstanceSchemaObject schemaObject = (KGraphInstanceSchemaObject)this.parameters[0];
                boolean asDdl = (Boolean)this.parameters[1];
                boolean knodes = (Boolean)this.parameters[2];
                boolean kassertions = (Boolean)this.parameters[3];
                boolean asJson = (Boolean)this.parameters[4];
                CSpaceSysTablesManager tablesManager = ((CSpace)session.dataspaceStore.schemaManager.findSchema(schemaObject.getSchemaName().name)).getCSpaceSysTablesManager();
                if (asDdl) {
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR}, new String[]{"STATEMENT"});
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    String sql = schemaObject.getSQL(schemaObject.getObjectName().name);
                    navigator.add(new Object[]{sql});
                    return result;
                }
                if (knodes) {
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"KNode Id", "KNode Definition", "Subject Key", "Subject Key Alias", "Facets"});
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    List<KNodeTableManager.KNodeRow> kNodesByGraphId = tablesManager.getKNodeTableManager().getKNodesByGraphId(session, tablesManager.getKGraphTableManager().getKGraph(session, schemaObject.getObjectName().name).getKGraphId());
                    for (KNodeTableManager.KNodeRow kNodeRow : kNodesByGraphId) {
                        KNodeTypeSchemaObject kNodeDefinition = (KNodeTypeSchemaObject)session.dataspaceStore.schemaManager.getSchemaObject(kNodeRow.getTypeName(), "SDS", 43);
                        navigator.add(new Object[]{kNodeRow.getKNodeId(), kNodeRow.getTypeName(), kNodeRow.getSubjectKey(), kNodeDefinition.getSubjectKey(), FacetsUtils.facetsToString(kNodeRow.getFacets())});
                    }
                    return result;
                }
                if (kassertions) {
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"KAssertion Id", "KLink Definition", "Subject KNode", "Object KNode", "Facets"});
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    List<KAssertionTableManager.KAssertionRow> kAssertionsByGraphId = tablesManager.getKAssertionTableManager().getKAssertionsByGraphId(session, tablesManager.getKGraphTableManager().getKGraph(session, schemaObject.getObjectName().name).getKGraphId());
                    Map kNodesByGraphId = tablesManager.getKNodeTableManager().getKNodesByGraphId(session, tablesManager.getKGraphTableManager().getKGraph(session, schemaObject.getObjectName().name).getKGraphId()).stream().collect(Collectors.toMap(KNodeTableManager.KNodeRow::getKNodeId, Function.identity()));
                    for (KAssertionTableManager.KAssertionRow kAssertionRow : kAssertionsByGraphId) {
                        KNodeTableManager.KNodeRow subjectKNodeRow = (KNodeTableManager.KNodeRow)kNodesByGraphId.get(kAssertionRow.getSubjectKNodeId());
                        KNodeTableManager.KNodeRow objectKNodeRow = (KNodeTableManager.KNodeRow)kNodesByGraphId.get(kAssertionRow.getObjectKNodeId());
                        KLinkTypeSchemaObject klinkDefintion = (KLinkTypeSchemaObject)session.dataspaceStore.schemaManager.getSchemaObject(kAssertionRow.getTypeName(), "SDS", 44);
                        KNodeTypeSchemaObject subjectKNodeDefinition = (KNodeTypeSchemaObject)session.dataspaceStore.schemaManager.getSchemaObject(subjectKNodeRow.getTypeName(), "SDS", 43);
                        KNodeTypeSchemaObject objectKNodeDefinition = (KNodeTypeSchemaObject)session.dataspaceStore.schemaManager.getSchemaObject(objectKNodeRow.getTypeName(), "SDS", 43);
                        Facets klinkFacets = schemaObject.getKgraphType().getKlinksFacets().get(klinkDefintion.getObjectName().name);
                        if (klinkFacets == null) {
                            klinkFacets = new Facets();
                        }
                        if (kAssertionRow.getFacets() != null) {
                            klinkFacets.putAll(kAssertionRow.getFacets());
                        }
                        navigator.add(new Object[]{kAssertionRow.getkAssertionId(), kAssertionRow.getTypeName(), subjectKNodeDefinition.getObjectName().name + ":[" + subjectKNodeRow.getSubjectKey() + "]", objectKNodeDefinition.getObjectName().name + ":[" + objectKNodeRow.getSubjectKey() + "]", FacetsUtils.facetsToString(klinkFacets)});
                    }
                    return result;
                }
                if (asJson) {
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR}, new String[]{"JSON"});
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    KGraph kGraph = schemaObject.toKGraph(session);
                    navigator.add(new Object[]{kGraph.toJSON()});
                    return result;
                }
                ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Property", "Value"});
                RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                Result result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                navigator.add(new Object[]{"Name", schemaObject.getObjectName().getStatementName()});
                navigator.add(new Object[]{"Definition Name", schemaObject.getKgraphType().getObjectName().getStatementName()});
                navigator.add(new Object[]{"Comment", Optional.ofNullable(schemaObject.getComment()).orElse("")});
                return result;
            }
            case 3297: {
                FacetsSchemaObject facets = (FacetsSchemaObject)this.parameters[0];
                boolean keys = (Boolean)this.parameters[1];
                boolean asDdl = (Boolean)this.parameters[2];
                if (keys) {
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Key", "Value Type"});
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    for (ColumnSchema columnSchema : facets.getColumns()) {
                        navigator.add(new Object[]{columnSchema.getNameString(), columnSchema.getDataType().getDefinition()});
                    }
                    return result;
                }
                if (asDdl) {
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR}, new String[]{"STATEMENT"});
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    String sql = facets.getSQL(facets.getObjectName().name);
                    navigator.add(new Object[]{sql});
                    return result;
                }
                ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Property", "Value"});
                RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                Result result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                navigator.add(new Object[]{"Facets Name", facets.getObjectName().getStatementName()});
                navigator.add(new Object[]{"Static", facets.isStatic()});
                navigator.add(new Object[]{"Searchable", facets.isIndexed()});
                navigator.add(new Object[]{"Description", Optional.ofNullable(facets.getDescription()).orElse("")});
                navigator.add(new Object[]{"Key Count", facets.getColumns().size()});
                return result;
            }
            case 3301: {
                ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Aspect Set", "Value Type", "Static", "Searchable", "Description", "Inferences"});
                RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                Result result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                com.streamscape.ds.lib.Iterator it = session.dataspaceStore.schemaManager.dataspaceObjectIterator("SDS", 42);
                while (it.hasNext()) {
                    AspectsSchemaObject aspects = (AspectsSchemaObject)it.next();
                    navigator.add(new Object[]{aspects.getObjectName().getStatementName(), aspects.getType().getTypeDefinition(), aspects.isStatic(), aspects.isIndexed(), Optional.ofNullable(aspects.getDescription()).orElse(""), ""});
                }
                return result;
            }
            case 3302: {
                AspectsSchemaObject aspects = (AspectsSchemaObject)this.parameters[0];
                boolean asDdl = (Boolean)this.parameters[1];
                if (asDdl) {
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR}, new String[]{"STATEMENT"});
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    String sql = aspects.getSQL(aspects.getObjectName().name);
                    navigator.add(new Object[]{sql});
                    return result;
                }
                ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Property", "Value"});
                RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                Result result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                navigator.add(new Object[]{"Aspects Name", aspects.getObjectName().getStatementName()});
                navigator.add(new Object[]{"Static", aspects.isStatic()});
                navigator.add(new Object[]{"Searchable", aspects.isIndexed()});
                navigator.add(new Object[]{"Description", Optional.ofNullable(aspects.getDescription()).orElse("")});
                navigator.add(new Object[]{"Value Type", aspects.getType().getTypeDefinition()});
                return result;
            }
            case 3320: {
                ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Name", "Comment", "Subject Key", "Keys Count"});
                RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                Result result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                com.streamscape.ds.lib.Iterator it = session.dataspaceStore.schemaManager.dataspaceObjectIterator("SDS", 43);
                while (it.hasNext()) {
                    KNodeTypeSchemaObject knode = (KNodeTypeSchemaObject)it.next();
                    navigator.add(new Object[]{knode.getObjectName().getStatementName(), Optional.ofNullable(knode.getComment()).orElse(""), knode.getSubjectKey(), knode.getColumns().size()});
                }
                return result;
            }
            case 3325: {
                ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Name", "Comment", "Keys Count"});
                RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                Result result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                com.streamscape.ds.lib.Iterator it = session.dataspaceStore.schemaManager.dataspaceObjectIterator("SDS", 44);
                while (it.hasNext()) {
                    KLinkTypeSchemaObject klink = (KLinkTypeSchemaObject)it.next();
                    navigator.add(new Object[]{klink.getObjectName().getStatementName(), Optional.ofNullable(klink.getComment()).orElse(""), klink.getColumns().size()});
                }
                return result;
            }
            case 3333: {
                ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Name", "Comment"});
                RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                Result result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                com.streamscape.ds.lib.Iterator it = session.dataspaceStore.schemaManager.dataspaceObjectIterator(session.currentDataspace.name, 45);
                while (it.hasNext()) {
                    KGraphTypeSchemaObject kgraph = (KGraphTypeSchemaObject)it.next();
                    navigator.add(new Object[]{kgraph.getObjectName().getStatementName(), Optional.ofNullable(kgraph.getComment()).orElse("")});
                }
                return result;
            }
            case 3337: {
                ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Name", "Definition name", "Comment"});
                RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                Result result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                com.streamscape.ds.lib.Iterator it = session.dataspaceStore.schemaManager.dataspaceObjectIterator(session.currentDataspace.name, 46);
                while (it.hasNext()) {
                    KGraphInstanceSchemaObject kgraph = (KGraphInstanceSchemaObject)it.next();
                    navigator.add(new Object[]{kgraph.getObjectName().getStatementName(), kgraph.getKgraphType().getObjectName().getStatementName(), Optional.ofNullable(kgraph.getComment()).orElse("")});
                }
                return result;
            }
            case 3165: 
            case 3166: {
                try {
                    ServerObject serverObject = (ServerObject)this.parameters[0];
                    if (this.type == 3165) {
                        serverObject.startServer(session);
                        return Result.updateNoResult;
                    } else {
                        serverObject.stopServer(session);
                    }
                    return Result.updateNoResult;
                }
                catch (Exception e97) {
                    return Result.newErrorResult(e97, this.sql);
                }
            }
            case 3050: {
                try {
                    TriggerDef trigger = (TriggerDef)this.parameters[0];
                    trigger.enable(session);
                    trigger.setAutoEnable(true);
                    this.logRecordName = trigger.getObjectName();
                    return Result.updateNoResult;
                }
                catch (Exception e98) {
                    return Result.newErrorResult(e98, this.sql);
                }
            }
            case 3051: {
                try {
                    TriggerDef trigger = (TriggerDef)this.parameters[0];
                    trigger.disable();
                    trigger.setAutoEnable(false);
                    this.logRecordName = trigger.getObjectName();
                    return Result.updateNoResult;
                }
                catch (Exception e99) {
                    return Result.newErrorResult(e99, this.sql);
                }
            }
            case 3159: {
                try {
                    Actor actor = (Actor)this.parameters[0];
                    actor.setAutoEnable(true);
                    if (DataspaceManager.getContext().getRunLevel() == 4) {
                        actor.enable(session);
                    }
                    this.logRecordName = actor.getObjectName();
                    return Result.updateNoResult;
                }
                catch (Exception e100) {
                    return Result.newErrorResult(e100, this.sql);
                }
            }
            case 3160: {
                try {
                    Actor actor = (Actor)this.parameters[0];
                    actor.setAutoEnable(false);
                    if (DataspaceManager.getContext().getRunLevel() == 4) {
                        actor.disable();
                    }
                    this.logRecordName = actor.getObjectName();
                    return Result.updateNoResult;
                }
                catch (Exception e101) {
                    return Result.newErrorResult(e101, this.sql);
                }
            }
            case 3172: {
                try {
                    DataspaceSchema dataspace = session.dataspaceStore.schemaManager.findSchema(session.currentDataspace.name);
                    if (dataspace == null) {
                        throw new DataspaceException("Unable to retrieve reference to current dataspace.");
                    }
                    PackageManifestManager manager = dataspace.getPackageManifestManager();
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_BOOLEAN, Type.SQL_BOOLEAN, Type.SQL_BOOLEAN, Type.SQL_BOOLEAN, Type.SQL_BOOLEAN}, new String[]{"Package Name", "Autoload", "Chained Loader", "Load As Root", "Loaded", "Valid"});
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    for (String pkgName : manager.listPackages()) {
                        PackageDescriptor pkg = manager.getPackage(pkgName);
                        navigator.add(new Object[]{pkgName, pkg.isAutoload(), pkg.useChainedLoader(), pkg.loadAsRoot(), manager.isPackageLoaded(pkgName), pkg.isValid()});
                    }
                    return result;
                }
                catch (Exception e102) {
                    return Result.newErrorResult(e102, this.sql);
                }
            }
            case 3173: {
                try {
                    DataspaceSchema dataspace = session.dataspaceStore.schemaManager.findSchema(session.currentDataspace.name);
                    if (dataspace == null) {
                        throw new DataspaceException("Unable to retrieve reference to current dataspace.");
                    }
                    PackageManifestManager manager = dataspace.getPackageManifestManager();
                    PackageType type = (PackageType)((Object)this.parameters[0]);
                    String name12 = (String)this.parameters[1];
                    boolean autoload = (Boolean)this.parameters[2];
                    long sequence = (Long)this.parameters[3];
                    RepositoryAccessor repository = DataspaceManager.getContext().getRepositoryAccessor();
                    PackageDescriptor packageDescriptor = PackageDescriptor.create(repository.getPackage(type, name12), autoload, false);
                    if (sequence > -1L) {
                        manager.addPackageAt(((Number)sequence).intValue(), packageDescriptor);
                        return Result.updateNoResult;
                    } else {
                        manager.addPackage(packageDescriptor);
                    }
                    return Result.updateNoResult;
                }
                catch (Exception e103) {
                    return Result.newErrorResult(e103, this.sql);
                }
            }
            case 3175: {
                try {
                    DataspaceSchema dataspace = session.dataspaceStore.schemaManager.findSchema(session.currentDataspace.name);
                    if (dataspace == null) {
                        throw new DataspaceException("Unable to retrieve reference to current dataspace.");
                    }
                    PackageManifestManager manager = dataspace.getPackageManifestManager();
                    PackageType type = (PackageType)((Object)this.parameters[0]);
                    String name13 = (String)this.parameters[1];
                    boolean autoload = (Boolean)this.parameters[2];
                    long sequence = (Long)this.parameters[3];
                    PackageDescriptor pkgDescriptor = manager.getPackage(type.name() + "." + name13);
                    if (pkgDescriptor == null) {
                        throw new DataspaceException("Specified package '" + type.name() + "." + name13 + "' does not exist.");
                    }
                    if (manager.isPackageLoaded(type.name() + "." + name13)) {
                        manager.unloadPackage(type.name() + "." + name13);
                    }
                    pkgDescriptor.setAutoload(autoload);
                    manager.removePackage(type.name() + "." + name13);
                    if (sequence > -1L) {
                        manager.addPackageAt(((Number)sequence).intValue(), pkgDescriptor);
                        return Result.updateNoResult;
                    } else {
                        manager.addPackage(pkgDescriptor);
                    }
                    return Result.updateNoResult;
                }
                catch (Exception e104) {
                    return Result.newErrorResult(e104, this.sql);
                }
            }
            case 3174: {
                try {
                    DataspaceSchema dataspace = session.dataspaceStore.schemaManager.findSchema(session.currentDataspace.name);
                    if (dataspace == null) {
                        throw new DataspaceException("Unable to retrieve reference to current dataspace.");
                    }
                    PackageManifestManager manager = dataspace.getPackageManifestManager();
                    PackageType type = (PackageType)((Object)this.parameters[0]);
                    String name14 = (String)this.parameters[1];
                    PackageDescriptor pkgDescriptor = manager.getPackage(type.name() + "." + name14);
                    if (pkgDescriptor == null) {
                        throw new DataspaceException("Specified package '" + type.name() + "." + name14 + "' does not exist.");
                    }
                    if (manager.isPackageLoaded(type.name() + "." + name14)) {
                        manager.unloadPackage(type.name() + "." + name14);
                    }
                    manager.removePackage(type.name() + "." + name14);
                    return Result.updateNoResult;
                }
                catch (Exception e105) {
                    return Result.newErrorResult(e105, this.sql);
                }
            }
            case 3236: {
                try {
                    User user = (User)this.parameters[0];
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING}, new String[]{"Property", "Value"});
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    navigator.add(new Object[]{"Name", user.getName()});
                    navigator.add(new Object[]{"Alias", StatementUtil.skipNull(user.getAlias())});
                    navigator.add(new Object[]{"Description", StatementUtil.skipNull(user.getDescription())});
                    navigator.add(new Object[]{"Organization", user.getOrganization()});
                    navigator.add(new Object[]{"State", user.getState()});
                    navigator.add(new Object[]{"Permissions", user.hasOwnPermissions() ? "User" : "Inherited"});
                    navigator.add(new Object[]{"DN", StatementUtil.skipNull(user.getDNRecord())});
                    navigator.add(new Object[]{"Distinguished Entity", user.isDistinguishedEntity()});
                    navigator.add(new Object[]{"Sudo Capable", user.isSudoCapable()});
                    navigator.add(new Object[]{"Groups", user.listGroups()});
                    return result;
                }
                catch (Exception e106) {
                    return Result.newErrorResult(e106, this.sql);
                }
            }
            case 3208: {
                try {
                    DataspaceSchema schema;
                    ArrayList<Grantee> users = new ArrayList<Grantee>();
                    List granteeList = (List)this.parameters[0];
                    List objectList = (List)this.parameters[1];
                    boolean isTupleList = (Boolean)this.parameters[2];
                    ArrayList<RplScript> scriptFilterList = null;
                    ArrayList<SchemaObject> collectionFilterList = null;
                    ArrayList<SchemaObject> serverFilterList = null;
                    if (!objectList.isEmpty()) {
                        scriptFilterList = new ArrayList<RplScript>();
                        collectionFilterList = new ArrayList<SchemaObject>();
                        serverFilterList = new ArrayList<SchemaObject>();
                        for (SchemaObject schemaObject : objectList) {
                            if (schemaObject instanceof RoutineSchema) {
                                scriptFilterList.add(((RoutineSchema)schemaObject).routines[0]);
                                continue;
                            }
                            if (schemaObject.getObjectType() == 4) {
                                collectionFilterList.add(schemaObject);
                                continue;
                            }
                            if (schemaObject.getObjectType() != 27) continue;
                            serverFilterList.add(schemaObject);
                        }
                    }
                    if (granteeList != null) {
                        for (String string : granteeList) {
                            users.add(session.dataspaceStore.granteeManager.get(string));
                        }
                    } else {
                        com.streamscape.ds.lib.Iterator iter = session.dataspaceStore.granteeManager.getGrantees().iterator();
                        while (iter.hasNext()) {
                            users.add((Grantee)iter.next());
                        }
                    }
                    Type[] resultTypes = new Type[3 + users.size()];
                    String[] stringArray = new String[3 + users.size()];
                    if (isTupleList) {
                        resultTypes[0] = Type.SQL_VARCHAR;
                        stringArray[0] = "Collection";
                        resultTypes[1] = Type.SQL_VARCHAR;
                        stringArray[1] = "Tuple Name";
                        resultTypes[2] = Type.SQL_VARCHAR;
                        stringArray[2] = "Type";
                    } else {
                        resultTypes[0] = Type.SQL_VARCHAR;
                        stringArray[0] = "Context";
                        resultTypes[1] = Type.SQL_VARCHAR;
                        stringArray[1] = "Object";
                        resultTypes[2] = Type.SQL_VARCHAR;
                        stringArray[2] = "Type";
                    }
                    for (int i = 0; i < users.size(); ++i) {
                        resultTypes[i + 3] = Type.SQL_VARCHAR;
                        stringArray[i + 3] = ((Grantee)users.get((int)i)).getObjectName().name;
                    }
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(resultTypes, stringArray);
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    String context = null;
                    com.streamscape.ds.lib.Iterator routines = session.dataspaceStore.schemaManager.dataspaceObjectIterator(session.currentDataspace.name, 25);
                    while (!isTupleList && routines.hasNext()) {
                        RplScript routine = (RplScript)routines.next();
                        if (scriptFilterList != null && !scriptFilterList.contains(routine)) continue;
                        Object[] rowData = new Object[users.size() + 3];
                        context = routine.getSchemaName().name;
                        rowData[0] = context;
                        rowData[1] = routine.getObjectName().name;
                        rowData[2] = "FUNCTION";
                        for (int k = 0; k < users.size(); ++k) {
                            Grantee granteeUser = (Grantee)users.get(k);
                            boolean hasExecuteRight = false;
                            boolean hasFullRight = false;
                            if (granteeUser.isAdmin() && granteeUser.isSudoCapable()) {
                                hasExecuteRight = true;
                            }
                            if (!hasExecuteRight) {
                                OrderedHashSet grantees = granteeUser.getGranteeAndAllRolesWithPublic();
                                for (int i = 0; i < grantees.size() && !hasExecuteRight; ++i) {
                                    Grantee granteeObject = (Grantee)grantees.get(i);
                                    OrderedHashSet rights = granteeObject.getAllDirectPrivileges(routine);
                                    OrderedHashSet grants = granteeObject.getAllGrantedPrivileges(routine);
                                    OrderedHashSet schemaRights = granteeObject.getSchemaRights(routine.getSchemaName());
                                    rights.addAll(grants);
                                    rights.addAll(schemaRights);
                                    for (int j = 0; j < rights.size(); ++j) {
                                        Right right = (Right)rights.get(j);
                                        if (right.isFull()) {
                                            hasFullRight = true;
                                            continue;
                                        }
                                        if (!right.canAccessFully(32)) continue;
                                        hasExecuteRight = true;
                                    }
                                }
                            }
                            rowData[k + 3] = hasFullRight ? "a-----" : (hasExecuteRight ? "x-----" : "------");
                        }
                        navigator.add(rowData);
                    }
                    com.streamscape.ds.lib.Iterator iterator = session.dataspaceStore.schemaManager.dataspaceObjectIterator(session.currentDataspace.name, 4);
                    Collection collection = null;
                    int[] colPrivilegeTypes = new int[]{1, 4, 8, 2};
                    String[] colPrivilegeShortNames = new String[]{"s", "i", "u", "d"};
                    String[] colPrivilegePartialShortNames = new String[]{"S", "I", "U", "D"};
                    while (iterator.hasNext()) {
                        collection = (Collection)iterator.next();
                        if (collectionFilterList != null && !collectionFilterList.contains(collection)) continue;
                        if (!isTupleList) {
                            Object[] rowData = new Object[users.size() + 3];
                            rowData[0] = collection.getSchemaName().name;
                            rowData[1] = collection.getObjectName().name;
                            rowData[2] = collection.getCollectionType().name();
                            for (int k = 0; k < users.size(); ++k) {
                                Grantee granteeUser = (Grantee)users.get(k);
                                char[] permissions = "------".toCharArray();
                                if (granteeUser.isAdmin() && granteeUser.isSudoCapable()) {
                                    for (int m = 0; m < colPrivilegeTypes.length; ++m) {
                                        permissions[m + 1] = colPrivilegeShortNames[m].charAt(0);
                                    }
                                } else {
                                    OrderedHashSet rights = granteeUser.getFullRights(collection.getBaseTable());
                                    if (rights.size() > 0) {
                                        block625: for (int m = 0; m < colPrivilegeTypes.length; ++m) {
                                            int i;
                                            for (i = 0; i < rights.size(); ++i) {
                                                if (!((Right)rights.get(i)).isFull()) continue;
                                                permissions[m + 1] = 97;
                                                break;
                                            }
                                            if (permissions[m + 1] == '-') {
                                                for (i = 0; i < rights.size(); ++i) {
                                                    if (!((Right)rights.get(i)).canAccessFully(colPrivilegeTypes[m])) continue;
                                                    permissions[m + 1] = colPrivilegeShortNames[m].charAt(0);
                                                    break;
                                                }
                                            }
                                            if (permissions[m + 1] != '-') continue;
                                            for (i = 0; i < rights.size(); ++i) {
                                                if (!((Right)rights.get(i)).canAccessPartially(colPrivilegeTypes[m])) continue;
                                                permissions[m + 1] = colPrivilegePartialShortNames[m].charAt(0);
                                                continue block625;
                                            }
                                        }
                                    }
                                }
                                rowData[k + 3] = String.valueOf(permissions);
                            }
                            navigator.add(rowData);
                            continue;
                        }
                        OrderedHashSet disclosableFields = session.getGrantee().getDisclosableFields(collection.getBaseTable());
                        for (Tuple tuple : new CollectionMetaDataImpl(collection).getTuples()) {
                            String tupleName = tuple.getName();
                            if (disclosableFields != null && !disclosableFields.contains(((ColumnSchema)tuple.getColumnBase()).getObjectName())) {
                                tupleName = "***";
                            }
                            Object[] rowData = new Object[users.size() + 3];
                            rowData[0] = collection.getObjectName().name;
                            rowData[1] = tupleName;
                            rowData[2] = tuple.getTypeName();
                            for (int k = 0; k < users.size(); ++k) {
                                Grantee granteeUser = (Grantee)users.get(k);
                                char[] permissions = "----".toCharArray();
                                if (granteeUser.isAdmin() && granteeUser.isSudoCapable()) {
                                    for (int m = 0; m < colPrivilegeShortNames.length; ++m) {
                                        permissions[m] = colPrivilegeShortNames[m].charAt(0);
                                    }
                                } else {
                                    OrderedHashSet rights = granteeUser.getFullRights(collection.getBaseTable());
                                    if (rights.size() > 0) {
                                        block632: for (int m = 0; m < colPrivilegeTypes.length; ++m) {
                                            for (int i = 0; i < rights.size(); ++i) {
                                                if (!((Right)rights.get(i)).canAccessFully(colPrivilegeTypes[m]) && !((Right)rights.get(i)).canAccessPartially(colPrivilegeTypes[m], (ColumnSchema)tuple.getColumnBase())) continue;
                                                permissions[m + 1] = colPrivilegeShortNames[m].charAt(0);
                                                continue block632;
                                            }
                                        }
                                    }
                                }
                                rowData[k + 3] = String.valueOf(permissions);
                            }
                            navigator.add(rowData);
                        }
                    }
                    com.streamscape.ds.lib.Iterator serversIt = session.dataspaceStore.schemaManager.dataspaceObjectIterator(session.currentDataspace.name, 27);
                    while (!isTupleList && serversIt.hasNext()) {
                        ServerObject server = (ServerObject)serversIt.next();
                        if (serverFilterList != null && !serverFilterList.contains(server)) continue;
                        Object[] rowData = new Object[users.size() + 3];
                        context = server.getSchemaName().name;
                        rowData[0] = context;
                        rowData[1] = server.getObjectName().name;
                        rowData[2] = "SERVER";
                        for (int k = 0; k < users.size(); ++k) {
                            Grantee granteeUser = (Grantee)users.get(k);
                            boolean hasUsageRight = false;
                            if (granteeUser.isAdmin() && granteeUser.isSudoCapable()) {
                                hasUsageRight = true;
                            } else {
                                OrderedHashSet rights = granteeUser.getFullRights(server);
                                for (int i = 0; i < rights.size() && !(hasUsageRight |= ((Right)rights.get(i)).canAccess(16)); ++i) {
                                }
                            }
                            rowData[k + 3] = hasUsageRight ? "-----g" : "------";
                        }
                        navigator.add(rowData);
                    }
                    if (isTupleList || (schema = session.dataspaceStore.schemaManager.findSchema(session.currentDataspace.name)) == null) return result;
                    int[] schemaPrivilegeTypes = new int[]{32, 1, 4, 8, 2, 16};
                    String[] privilegeShortNames = new String[]{"e", "s", "i", "u", "d", "g"};
                    Object[] rowData = new Object[users.size() + 3];
                    context = schema.getObjectName().name;
                    rowData[0] = context;
                    rowData[1] = schema.getObjectName().name;
                    rowData[2] = "DATASPACE";
                    for (int k = 0; k < users.size(); ++k) {
                        Grantee granteeUser = (Grantee)users.get(k);
                        char[] permissions = "------".toCharArray();
                        if (granteeUser.isAdmin() && granteeUser.isSudoCapable()) {
                            for (int m = 0; m < schemaPrivilegeTypes.length; ++m) {
                                permissions[m + 1] = privilegeShortNames[m].charAt(0);
                            }
                        } else {
                            OrderedHashSet rights = granteeUser.getSchemaRights(schema.getObjectName());
                            block639: for (int m = 0; m < schemaPrivilegeTypes.length; ++m) {
                                int i;
                                for (i = 0; i < rights.size(); ++i) {
                                    if (!((Right)rights.get(i)).canAccessFully(schemaPrivilegeTypes[m])) continue;
                                    permissions[m] = privilegeShortNames[m].charAt(0);
                                    break;
                                }
                                for (i = 0; i < rights.size(); ++i) {
                                    if (!((Right)rights.get(i)).isFull()) continue;
                                    permissions[m] = 97;
                                    continue block639;
                                }
                            }
                        }
                        rowData[k + 3] = String.valueOf(permissions);
                    }
                    navigator.add(rowData);
                    return result;
                }
                catch (Exception e107) {
                    return Result.newErrorResult(e107, this.sql);
                }
            }
            case 3237: {
                try {
                    String fileName = (String)this.parameters[0];
                    SchemaLoader loader = new SchemaLoader(session, fileName, false);
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING}, new String[]{"Property", "Value"});
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    DumpLoadUtil.describeDataspaceColumns(loader).forEach(navigator::add);
                    return result;
                }
                catch (Exception error) {
                    return Result.newErrorResult(error, this.sql);
                }
            }
            case 3260: {
                try {
                    FullTextIndex index = (FullTextIndex)this.parameters[0];
                    int displayType = (Integer)this.parameters[1];
                    if (displayType == 406) {
                        ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING}, new String[]{"Property", "Value"});
                        RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                        Result result = Result.newDataResult(metaData);
                        result.setNavigator(navigator);
                        navigator.add(new Object[]{"Name", index.getObjectName().name});
                        navigator.add(new Object[]{"Columns", index.getColumnDescription()});
                        index.addSpecificProperties(result);
                        index.aggregateStateHolder().exposeState(navigator, false, true, "State", new Class[0]);
                        return result;
                    }
                    if (displayType == 1126) {
                        return index.getTupleStatistics();
                    }
                }
                catch (Exception error) {
                    return Result.newErrorResult(error, this.sql);
                }
            }
            case 3271: {
                String filename = (String)this.parameters[0];
                int linesCount = (Integer)this.parameters[1];
                int sampleRate = (Integer)this.parameters[2];
                String timestampJavaFormat = (String)this.parameters[3];
                if (session.isSLFileStreamNeeded()) {
                    // empty if block
                }
                LogRecordMatcherPattern pattern = null;
                LogRecordMatcherResolver resolver = null;
                InputStream inputStreamBuf = null;
                try {
                    inputStreamBuf = SessionData.createFileInputStream(session, filename, false, false, null);
                    if (inputStreamBuf instanceof SLFileInputStream) {
                        ((SLFileInputStream)inputStreamBuf).setVerbose(false);
                    }
                    inputStreamBuf = new BufferedInputStream(inputStreamBuf, 16384);
                    resolver = LogRecordMatcherResolver.builder().sourceReader(new InputStreamReader(inputStreamBuf)).linesCount(linesCount).skipJavaTraces(true).wordsInSquareBrackets(false).sampleRate(sampleRate).javaTimestampFormat(timestampJavaFormat).compactClassNames(true).build();
                    pattern = resolver.resolve();
                }
                catch (Exception exception) {
                    throw new DataspaceException(exception);
                }
                finally {
                    if (inputStreamBuf != null) {
                        try {
                            inputStreamBuf.close();
                        }
                        catch (IOException exception) {
                            Trace.logException(this, exception, true);
                        }
                    }
                }
                if (pattern == null) {
                    throw new DataspaceException("Log file structure cannot be determined.");
                }
                ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING}, new String[]{"Property", "Value"});
                RowSetNavigatorClient rowSetNavigatorClient = new RowSetNavigatorClient();
                Result result = Result.newDataResult(metaData);
                result.setNavigator(rowSetNavigatorClient);
                TimestampResolverUtils.TimestampFragmentParser timestampResolver = (TimestampResolverUtils.TimestampFragmentParser)pattern.getFragmentParser("timestamp");
                rowSetNavigatorClient.add(new Object[]{"Lines Read", resolver.getLinesRead()});
                rowSetNavigatorClient.add(new Object[]{"Header Pattern", pattern.getPatternString()});
                rowSetNavigatorClient.add(new Object[]{"Records Regexp", pattern.getRecordRegexp()});
                rowSetNavigatorClient.add(new Object[]{"Timestamp Pattern", timestampResolver != null ? timestampResolver.getPattern() : "n/a"});
                rowSetNavigatorClient.add(new Object[]{"Timestamp Java Format", timestampResolver != null ? timestampResolver.getJavaFormat() : "n/a"});
                rowSetNavigatorClient.add(new Object[]{"Pattern Syntax", LogFileTableCollection.logRecordMatcherToString(pattern)});
                return result;
            }
            case 3283: {
                String ccsid = (String)this.parameters[0];
                session.dataspaceStore.setCCSID(ccsid);
                return Result.updateNoResult;
            }
            case 3275: {
                LogFileTableCollection logFileTableCollection = (LogFileTableCollection)this.parameters[0];
                long lineOffset = (Long)this.parameters[1];
                long timestamp = (Long)this.parameters[2];
                boolean skipFirstLine = (Boolean)this.parameters[3];
                if (session.isProcessingLog() || session.isProcessingRecoveryLog()) {
                    logFileTableCollection.setLogFileTableProperties(lineOffset, timestamp, skipFirstLine);
                }
                this.logRecordName = logFileTableCollection.getObjectName();
                return Result.updateNoResult;
            }
            case 3278: {
                Expression expression = (Expression)this.parameters[0];
                Object message = null;
                try {
                    if (!session.isInteractive() && !session.isSDSRuntimeSession() && !session.insideTryCatchScript) return Result.updateNoResult;
                    Object value = OtherTypeWrapper.unwrap(expression.getValue(session));
                    if (value instanceof ParserPositionalException) {
                        message = ((ParserPositionalException)value).getErrorMessage();
                        if (((ParserPositionalException)value).getLineNumber() > 0) {
                            message = (String)message + "\n\n" + ((ParserPositionalException)value).getLineAndPositionMessage();
                        }
                    } else if (value instanceof Throwable) {
                        message = Utils.formatExceptionWithUnrepeatedCauses((Throwable)value);
                    } else if (value instanceof RowSet) {
                        message = new RowSetPrinter().printToString((RowSet)value);
                    } else if (value != null && value.getClass().isArray()) {
                        StringBuilder builder3 = new StringBuilder();
                        builder3.append("[");
                        for (int i = 0; i < Array.getLength(value); ++i) {
                            if (i > 0) {
                                builder3.append(", ");
                            }
                            builder3.append(String.valueOf(Array.get(value, i)));
                        }
                        builder3.append("]");
                        message = builder3.toString();
                    } else {
                        message = String.valueOf(value);
                    }
                    message = (String)message + "\n";
                    if (session.insideTryCatchScript || session.sessionContext.rplObject != null || session.sessionContext.depth > 1) {
                        AbstractOperation.raiseSLMessage(new SLMessage((String)message, session.getComponentName(), session.getSLSessionName()));
                        return Result.updateNoResult;
                    }
                    ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING}, new String[]{"Message"});
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    Result result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    navigator.add(new Object[]{message});
                    return result;
                }
                catch (Throwable exception) {
                    if (message != null) {
                        Trace.logError(this, "Failed to send PRINT message: " + message);
                    }
                    Trace.logException(this, exception, true);
                }
                return Result.updateNoResult;
            }
            case 43: {
                ExecImmediateExpression execImmediateExpression = (ExecImmediateExpression)this.parameters[0];
                return execImmediateExpression.getResult(session);
            }
            case 3312: {
                ExecBlockExpression execBlockExpression = (ExecBlockExpression)this.parameters[0];
                return execBlockExpression.getResult(session);
            }
            case 3282: {
                Writer writer = null;
                try {
                    String sql = (String)this.parameters[0];
                    String file = (String)this.parameters[1];
                    int type = (Integer)this.parameters[2];
                    boolean withHeader = (Boolean)this.parameters[3];
                    boolean quoted = (Boolean)this.parameters[4];
                    Result res = session.executeDirectStatement("exec immediate (" + sql + ")");
                    if (res.isError()) {
                        throw res.getException();
                    }
                    if (!res.isData()) {
                        throw new DataspaceException("The statement does not contain a result.");
                    }
                    RowSet rowSet = ((RowSetFactoryForDSResult)new RowSetFactoryForDSResult().setWithBlobs(false)).createRowSets(session, res).get(0);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (int i = 0; i < rowSet.getMeta().getColumnCount(); ++i) {
                        arrayList.add(rowSet.getMeta().getColumnName(i + 1));
                    }
                    OutputStream output = SessionData.createFileOutputStream(session, file, true, false);
                    if (output instanceof SLFileOutputStream) {
                        ((SLFileOutputStream)output).setVerbose(false);
                    }
                    writer = new OutputStreamWriter(output);
                    if (type == 636) {
                        FileDescriptorBuilder.CsvFileDescriptorBuilder builder4 = (FileDescriptorBuilder.CsvFileDescriptorBuilder)FileDescriptorBuilder.csv().setAllQuoted(quoted).setTrimWhitespaces(false);
                        FileDescriptorBuilder.UntypedRecordTypeDefinitionBuilderForDescriptor recordTypeBuilder = builder4.untypedRecordTypeDefinition();
                        for (int i = 0; i < res.metaData.columns.length; ++i) {
                            ((FileDescriptorBuilder.RecordFieldBuilder)((FileDescriptorBuilder.RecordFieldBuilder)recordTypeBuilder.recordField().setFieldName("field1")).setDataType("string")).add();
                        }
                        builder4.addRecord(recordTypeBuilder.build());
                        FileDescriptor descriptor = builder4.build();
                        FileDescriptorFactory factory = new FileDescriptorFactory();
                        factory.init(descriptor, DataspaceStoreManager.getRuntimeContext().getSystemClassLoaderChain(), DataspaceStoreManager.getRuntimeContext());
                        FileRecordsWriter recordsWriter = factory.createFileRecordsWriter(writer);
                        if (withHeader) {
                            recordsWriter.writeRecord(null, arrayList);
                        }
                        while (rowSet.next()) {
                            recordsWriter.writeRecord(null, Arrays.asList(rowSet.getCurrentRow().getRawData()));
                        }
                    } else if (type == 1110) {
                        new StatementUtil.JSONRowSetSerializer(rowSet).serialize(writer);
                    } else if (type == 1109) {
                        new StatementUtil.XMLRowSetSerializer(rowSet).serialize(writer);
                    }
                    Result result = Result.updateNoResult;
                    return result;
                }
                catch (Exception error) {
                    Trace.logException(this, error, true);
                    Result file = Result.newErrorResult(error, this.sql);
                    return file;
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException exception) {
                            Trace.logException(this, exception, true);
                        }
                    }
                }
            }
            case 3288: {
                try {
                    boolean events = (Boolean)this.parameters[0];
                    Result result = events ? Result.newDataResult(ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING}, new String[]{"Event Id"})) : Result.newDataResult(ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING}, new String[]{"Property", "Value"}));
                    RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                    result.setNavigator(navigator);
                    ComponentReference component = session.dataspaceStore.schemaManager.findSchema(session.currentDataspace.name).getComponentReference();
                    List<String> eventIds = component.listBoundEventIds();
                    if (events) {
                        Collections.sort(eventIds);
                        for (String eventId : eventIds) {
                            navigator.add(new Object[]{StringUtils.wrapEventId(eventId)});
                        }
                        return result;
                    } else {
                        navigator.add(new Object[]{"Name", component.getName()});
                        navigator.add(new Object[]{"Description", StatementUtil.skipNull(component.getDescription())});
                        navigator.add(new Object[]{"Model", component.getModel().toString()});
                        navigator.add(new Object[]{"Scope", component.getEventScope()});
                        navigator.add(new Object[]{"Address", component.getAddress()});
                        navigator.add(new Object[]{"Events", AbstractModeratorOperation.formatEventIds(component.listBoundEventIds())});
                    }
                    return result;
                }
                catch (Exception exception) {
                    return Result.newErrorResult(exception, this.sql);
                }
            }
        }
        throw Error.runtimeError(201, "StatementCommand");
    }

    private void setDataspaceOnlineAndStartServices(Session session) {
        if (session.dataspaceStore.dataspaceLogger.isRecoveryLogFailuresEmpty(session)) {
            session.dataspaceStore.setStoreState(DataspaceStoreState.ONLINE);
            session.dataspaceStore.validate(true);
            if (session.dataspaceStore.checkpointManager != null) {
                session.dataspaceStore.checkpointManager.setLastCheckpointAttemptTimestamp(false);
            }
            CheckpointManager.CheckpointStats.CheckpointAttempt checkpointAttempt = new CheckpointManager.CheckpointStats.CheckpointAttempt(CheckpointManager.CheckpointAction.CHECKPOINT_SYSTEM, System.currentTimeMillis(), 0L, false, session.dataspaceStore.checkpointManager != null ? session.dataspaceStore.checkpointManager.getRecoveryLogSize() : -1L);
            if (session.dataspaceStore.checkpointManager != null) {
                checkpointAttempt.setDuplicatesBefore(session.dataspaceStore.checkpointManager.checkConsistencyAndLogBefore());
            }
            Result result = session.dataspaceStore.dataspaceLogger.checkpoint(false, checkpointAttempt);
            if (session.dataspaceStore.checkpointManager != null) {
                checkpointAttempt.setSuccess(!result.isError());
                checkpointAttempt.setEndTimestamp(System.currentTimeMillis());
                if (session.dataspaceStore.checkpointManager != null) {
                    checkpointAttempt.setDuplicatesAfter(session.dataspaceStore.checkpointManager.checkConsistencyAndLogAfter());
                }
                session.dataspaceStore.checkpointManager.addCheckpointAttempt(checkpointAttempt);
                session.dataspaceStore.checkpointManager.updateCheckpointResult(result);
            }
            ServiceManager serviceManager = DataspaceStoreManager.getRuntimeContext().getServiceManager();
            ArrayList<String> servicesToStart = new ArrayList<String>();
            for (String serviceFullName : serviceManager.listRegisteredServices()) {
                ComponentState serviceState;
                ServiceDescriptor serviceDescriptor = serviceManager.getService(serviceFullName);
                if (serviceDescriptor == null || !serviceDescriptor.isAutostart() || (serviceState = serviceManager.getServiceState(serviceFullName)) != null && serviceState != ComponentState.INITIALIZED) continue;
                servicesToStart.add(serviceFullName);
            }
            int servicesSize = 0;
            while (servicesToStart.size() > 0 && servicesSize != servicesToStart.size()) {
                servicesSize = servicesToStart.size();
                Iterator iterator = servicesToStart.iterator();
                while (iterator.hasNext()) {
                    String serviceFullName = (String)iterator.next();
                    try {
                        serviceManager.startService(serviceFullName);
                    }
                    catch (ServiceManagerException exception) {
                        if (exception.getErrorCode() == 6076) continue;
                        Trace.logError(this, "Failed to start service '" + serviceFullName + "'.");
                        Trace.logException(this, exception, true);
                    }
                    catch (Exception exception) {
                        Trace.logError(this, "Failed to start service '" + serviceFullName + "'.");
                        Trace.logException(this, exception, true);
                    }
                    iterator.remove();
                }
            }
        }
    }

    private void setProperty(Session session, String name, int value) {
        session.dataspaceStore.dataspaceStoreProperties.setProperty(name, value);
        session.dataspaceStore.persistStoreState();
    }

    private void setProperty(Session session, String name, boolean value) {
        session.dataspaceStore.dataspaceStoreProperties.setProperty(name, value);
        session.dataspaceStore.persistStoreState();
    }

    private void setProperty(Session session, String name, String value) {
        session.dataspaceStore.dataspaceStoreProperties.setProperty(name, value);
        session.dataspaceStore.persistStoreState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Result getTruncateResult(Session session) {
        try {
            int i;
            Object[] tables;
            boolean force;
            NameManager.ObjectName name = (NameManager.ObjectName)this.parameters[0];
            Table table = (Table)this.parameters[1];
            boolean restartIdentity = (Boolean)this.parameters[2];
            boolean noCheck = (Boolean)this.parameters[3];
            boolean bl = force = this.parameters.length > 4 ? (Boolean)this.parameters[4] : false;
            if (name.type == 3 || name.type == 4) {
                if (table == null) {
                    table = session.dataspaceStore.schemaManager.getUserTable(session, name);
                }
                tables = new Table[]{table};
                session.getGrantee().checkDelete(table);
                if (!noCheck) {
                    for (i = 0; i < table.fkMainConstraints.length; ++i) {
                        NameManager.ObjectName tableName;
                        Table refTable;
                        if (table.fkMainConstraints[i].getRef() == table || (refTable = session.dataspaceStore.schemaManager.getUserTable(session, tableName = table.fkMainConstraints[i].getRef().getObjectName())).isEmpty(session)) continue;
                        throw Error.error(8, refTable.getObjectName().name);
                    }
                }
            } else {
                session.dataspaceStore.schemaManager.getSchemaHsqlName(name.name);
                HashMappedList list = session.dataspaceStore.schemaManager.getTables(name.name);
                tables = new Table[list.size()];
                list.toValuesArray(tables);
                StatementSchema.checkSchemaUpdateAuthorisation(session, name);
                if (!noCheck) {
                    OrderedHashSet set = new OrderedHashSet();
                    session.dataspaceStore.schemaManager.getCascadingReferencesToSchema(name, set);
                    for (int i2 = 0; i2 < set.size(); ++i2) {
                        Table refTable;
                        NameManager.ObjectName objectName = (NameManager.ObjectName)set.get(i2);
                        if (objectName.type != 6 || objectName.parent.type != 3 || (refTable = session.dataspaceStore.schemaManager.getUserTable(session, objectName.parent)).isEmpty(session)) continue;
                        throw Error.error(8, refTable.getObjectName().name);
                    }
                }
                if (restartIdentity) {
                    com.streamscape.ds.lib.Iterator it = session.dataspaceStore.schemaManager.dataspaceObjectIterator(name.name, 8);
                    while (it.hasNext()) {
                        NumberSequence sequence = (NumberSequence)it.next();
                        sequence.reset();
                    }
                }
            }
            for (i = 0; i < tables.length; ++i) {
                table = tables[i];
                PersistentStore store = table.getRowStore(session);
                if (table instanceof FileTable) {
                    ((FileTable)table).truncate(session, force);
                }
                store.removeAll();
                if (!restartIdentity || table.identitySequence == null) continue;
                table.identitySequence.reset();
            }
            if (table.triggerLists[Trigger.Type.TRUNCATE.ordinal()].length > 0 || table.getReplicationSource() != null) {
                Exception exception;
                block31: {
                    exception = null;
                    AbstractDataspace dataspace = (AbstractDataspace)session.dataspaceStore.schemaManager.findSchema(name.schema.name);
                    try (Session localSession = dataspace.createSystemSession();){
                        localSession.disableReplication(session.isReplicationDisabled());
                        try {
                            if (table.triggerLists[Trigger.Type.TRUNCATE.ordinal()].length > 0) {
                                table.fireTriggers(localSession, Trigger.Type.TRUNCATE, null, null, null);
                                localSession.commit(true);
                            }
                        }
                        catch (Exception e) {
                            exception = e;
                        }
                        if (table.getReplicationSource() == null || localSession.isReplicationDisabled() || !table.isReplicated()) break block31;
                        try {
                            localSession.setAutoCommit(false);
                            localSession.setParentSessionId(session.getId());
                            table.getReplicationSource().onTruncate(localSession, table);
                            table.getReplicationSource().onBeforeCommit(localSession);
                            localSession.commit(true);
                            table.getReplicationSource().onAfterCommit(localSession);
                        }
                        finally {
                            table.getReplicationSource().onAfterCommitConfirm(localSession);
                        }
                    }
                }
                if (exception != null) {
                    throw exception instanceof DataspaceException ? (DataspaceException)exception : new DataspaceException(exception);
                }
            }
            if (table.getFullTextIndexes() != null) {
                try {
                    for (FullTextIndex index : table.getFullTextIndexes()) {
                        index.deleteAllTable(table);
                    }
                }
                catch (Exception e) {
                    Trace.logException(this, e, true);
                }
            }
            this.logRecordName = name;
            return Result.updateNoResult;
        }
        catch (DataspaceException e) {
            return Result.newErrorResult(e, this.sql);
        }
    }

    @Override
    public ResultMetaData getResultMetaData() {
        switch (this.type) {
            case 1191: {
                return ResultMetaData.newSingleColumnMetaData("OPERATION");
            }
            case 1004: {
                if (this.statementReturnType != 2) break;
                return ResultMetaData.newSingleColumnMetaData("COMMANDS");
            }
        }
        return super.getResultMetaData();
    }

    private void processCollectionEvents(RowSetNavigatorClient navigator, Collection collection, boolean all) {
        for (ActiveEvent event : collection.getEvents()) {
            this.addActiveEvent(collection.getObjectName(), event, navigator, all);
        }
        if (collection.getBaseTable().triggerList != null) {
            for (TriggerDef trigger : collection.getBaseTable().triggerList) {
                this.processEventTriggerEvents(navigator, trigger, all);
            }
        }
    }

    private void processActorEvents(RowSetNavigatorClient navigator, Actor actor, boolean all) {
        for (ActiveEvent event : actor.getEvents()) {
            this.addActiveEvent(actor.getObjectName(), event, navigator, all);
        }
    }

    private void processEventTriggerEvents(RowSetNavigatorClient navigator, TriggerDef trigger, boolean all) {
        if (trigger instanceof EventTriggerDefSQL) {
            for (ActiveEvent event : ((EventTriggerDefSQL)trigger).getEvents()) {
                this.addActiveEvent(trigger.getObjectName(), event, navigator, all);
            }
        }
    }

    private void processFunctionEvents(RowSetNavigatorClient navigator, RoutineSchema routineSchema, boolean all) {
        if (routineSchema.routines != null) {
            for (RplScript routine : routineSchema.routines) {
                for (ActiveEvent event : routine.getEvents()) {
                    this.addActiveEvent(routine.getObjectName(), event, navigator, all);
                }
            }
        }
    }

    @Override
    public boolean isAutoCommitStatement() {
        return this.type == 3312 ? false : this.isTransactionStatement;
    }

    @Override
    public String describe(Session session) {
        return this.sql;
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("sql", this.sql);
        return result;
    }

    private void addActiveEvent(NameManager.ObjectName objectName, ActiveEvent event, RowSetNavigator navigator, boolean all) {
        if (all) {
            navigator.add(new Object[]{SqlUtils.getSchemaObjectType(objectName.type), objectName.name, event.getEventId(), event.getType().name(), event.getEventScope(), event.getSelector() != null ? event.getSelector() : "-", event.getTrigger() != null ? event.getTrigger() : "-", event.getEventModel()});
        } else {
            navigator.add(new Object[]{event.getEventId(), event.getType().name(), event.getEventScope(), event.getSelector() != null ? event.getSelector() : "-", event.getTrigger() != null ? event.getTrigger() : "-", event.getEventModel()});
        }
    }
}

