/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.statement;

import com.streamscape.Trace;
import com.streamscape.cli.ds.CollectionType;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.analyze.ResultRow;
import com.streamscape.ds.analyze.SchemaAnalyzer;
import com.streamscape.ds.core.DataspaceStoreState;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.DataspaceDateTime;
import com.streamscape.ds.lib.FileUtil;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.navigator.RowSetNavigatorClient;
import com.streamscape.ds.parser.ParserRPL;
import com.streamscape.ds.parser.Tokens;
import com.streamscape.ds.parser.completion.DataspaceFunctionUnitManagerForCompletion;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.parser.statement.StatementUtil;
import com.streamscape.ds.persist.FlobManager;
import com.streamscape.ds.persist.LobValidator;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.TableDuplicatesResolver;
import com.streamscape.ds.persist.TableTypesValidator;
import com.streamscape.ds.persist.fulltext.CollectionColumn;
import com.streamscape.ds.persist.fulltext.FullTextIndex;
import com.streamscape.ds.persist.fulltext.FullTextQuery;
import com.streamscape.ds.persist.fulltext.FullTextTuple;
import com.streamscape.ds.persist.fulltext.FullTextUtils;
import com.streamscape.ds.persist.fulltext.IndexColumn;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.persist.snapshot.IndexSnapshot;
import com.streamscape.ds.replication.ReplicaInfo;
import com.streamscape.ds.replication.ReplicaState;
import com.streamscape.ds.replication.ReplicationDeliveryMetrics;
import com.streamscape.ds.replication.ReplicationEntityName;
import com.streamscape.ds.replication.ReplicationFlow;
import com.streamscape.ds.replication.ReplicationMetaSchema;
import com.streamscape.ds.replication.ReplicationOperationType;
import com.streamscape.ds.replication.ReplicationQueue;
import com.streamscape.ds.replication.ReplicationResponse;
import com.streamscape.ds.replication.ReplicationSource;
import com.streamscape.ds.replication.ReplicationTarget;
import com.streamscape.ds.replication.ReplicationUtil;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultMetaData;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.SemanticTypeAndPrototypeSchemaObjectsCache;
import com.streamscape.ds.schema.collection.AbstractCollection;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.collection.CollectionMetaDataImpl;
import com.streamscape.ds.schema.collection.Tuple;
import com.streamscape.ds.schema.collection.cspace.CSpace;
import com.streamscape.ds.schema.collection.cspace.KGraphValidator;
import com.streamscape.ds.schema.collection.cspace.definitions.KGraphInstanceSchemaObject;
import com.streamscape.ds.schema.collection.cspace.instances.KGraph;
import com.streamscape.ds.schema.collection.fspace.directory.DirectoryTableCollection;
import com.streamscape.ds.schema.collection.qspace.equeue.EventQueueCollection;
import com.streamscape.ds.schema.collection.qspace.pqueue.ProcessQueueCollection;
import com.streamscape.ds.schema.collection.tspace.map.MapCollection;
import com.streamscape.ds.schema.collection.tspace.vtable.VirtualTableCollection;
import com.streamscape.ds.schema.column.ColumnBase;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.constraint.Constraint;
import com.streamscape.ds.schema.constraint.ReferenceLink;
import com.streamscape.ds.schema.event.Actor;
import com.streamscape.ds.schema.job.JobObject;
import com.streamscape.ds.schema.procedure.FunctionCustom;
import com.streamscape.ds.schema.procedure.FunctionList;
import com.streamscape.ds.schema.procedure.FunctionSQL;
import com.streamscape.ds.schema.procedure.RoutineSchema;
import com.streamscape.ds.schema.procedure.SQLFunctionsMetaData;
import com.streamscape.ds.schema.sequence.NumberSequence;
import com.streamscape.ds.schema.server.ServerObject;
import com.streamscape.ds.schema.table.JournalFileQueueTable;
import com.streamscape.ds.schema.table.SnapshotDataspaceTable;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.timer.TimerObject;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.stable.columns.AbstractStringColumn;
import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.columns.ColumnType;
import com.streamscape.ds.stable.index.SIndex;
import com.streamscape.ds.stable.index.SIndexType;
import com.streamscape.ds.trigger.EventTriggerDefSQL;
import com.streamscape.ds.trigger.RecompiledTrigger;
import com.streamscape.ds.trigger.ReplicationEventTrigger;
import com.streamscape.ds.trigger.ReplicationModifyTrigger;
import com.streamscape.ds.trigger.ReplicationValidateTrigger;
import com.streamscape.ds.trigger.TriggerDef;
import com.streamscape.ds.trigger.TriggerDefSQL;
import com.streamscape.ds.trigger.WindowTriggerDefSQL;
import com.streamscape.ds.types.ArrayType;
import com.streamscape.ds.types.BooleanType;
import com.streamscape.ds.types.CharacterType;
import com.streamscape.ds.types.FlobData;
import com.streamscape.ds.types.LobData;
import com.streamscape.ds.types.NumberType;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.utils.DDLCollectionFormatter;
import com.streamscape.ds.utils.SqlUtils;
import com.streamscape.lib.timer.FabricTimerManager;
import com.streamscape.lib.timer.FabricTimerState;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.lib.utils.Utils;
import com.streamscape.omf.json.jackson.JsonCustomization;
import com.streamscape.omf.json.jackson.JsonNotation;
import com.streamscape.omf.json.jackson.JsonNotationLevel;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.omf.serializer.SerializerUtils;
import com.streamscape.runtime.mf.operation.type.EntityCompleter;
import com.streamscape.runtime.mf.operation.type.SemanticTypeEntitiesDescriber;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.sql.enums.SQLQueryParameterMode;
import com.streamscape.sef.dataspace.DataspaceManager;
import com.streamscape.sef.evtrigger.TriggerActionTime;
import com.streamscape.sef.mf.admin.FabricContext;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import com.streamscape.slex.SizeUnit;
import com.streamscape.tools.lexer.BufferUtils;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;

public class StatementCollectionQuery
extends Statement {
    Object[] parameters;

    public StatementCollectionQuery(int type, Object[] args) {
        this(type, args, null, null);
    }

    public StatementCollectionQuery(int type, Object[] args, NameManager.ObjectName readName, NameManager.ObjectName writeName) {
        super(type);
        this.isTransactionStatement = false;
        this.parameters = args;
        if (readName != null && readName != writeName) {
            this.readTableNames = new NameManager.ObjectName[]{readName};
        }
        if (writeName != null) {
            this.writeTableNames = new NameManager.ObjectName[]{writeName};
        }
        switch (type) {
            case 3009: 
            case 3052: 
            case 3073: 
            case 3084: 
            case 3089: 
            case 3095: 
            case 3110: 
            case 3120: 
            case 3134: 
            case 3158: 
            case 3190: 
            case 3191: 
            case 3192: 
            case 3193: 
            case 3196: 
            case 3201: 
            case 3207: 
            case 3234: 
            case 3235: 
            case 3242: 
            case 3264: 
            case 3265: 
            case 3310: 
            case 3311: 
            case 3313: 
            case 3315: {
                this.group = 2017;
                this.isLogged = false;
                break;
            }
            case 3268: 
            case 3276: 
            case 3280: {
                this.group = 2017;
                this.isLogged = false;
                this.isTransactionStatement = true;
                break;
            }
            case 3189: {
                this.group = 2017;
                this.isLogged = false;
                this.isTransactionStatement = args[9] != null && args[9] != TableTypesValidator.NormalizeScope.NONE;
                break;
            }
            case 3225: {
                this.group = 2017;
                this.isTransactionStatement = ((ReplicationEntityName)args[0]).isLocalNode();
                this.isLogged = false;
                break;
            }
            case 3002: 
            case 3035: 
            case 3036: {
                this.group = 2017;
                this.isTransactionStatement = true;
                this.isLogged = false;
                break;
            }
            case 3339: 
            case 3340: 
            case 3341: {
                this.group = 2017;
                this.isTransactionStatement = true;
                this.isLogged = false;
                break;
            }
            case 3062: 
            case 3066: {
                this.group = 2017;
                this.isTransactionStatement = ((ReplicationEntityName)args[0]).isLocalNode();
                this.isLogged = false;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementCollectionQuery");
            }
        }
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
        }
        catch (Throwable t) {
            result = Result.newErrorResult(t, null);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
            return result;
        }
        return result;
    }

    /*
     * Opcode count of 13782 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    Result getResult(Session session) {
        if (this.isExplain) {
            return Result.newSingleColumnStringResult("OPERATION", this.describe(session));
        }
        switch (this.type) {
            case 3002: {
                collection = (Collection)this.parameters[0];
                queryParameter = (String)this.parameters[1];
                switch (1.$SwitchMap$com$streamscape$cli$ds$CollectionType[collection.getCollectionType().ordinal()]) {
                    case 1: {
                        map = (MapCollection)collection;
                        if (queryParameter.equalsIgnoreCase("SIZE")) {
                            metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_INTEGER});
                            metaData.columnLabels = new String[]{"SIZE"};
                            metaData.columns = new ColumnBase[1];
                            column = new ColumnBase("", "", "", "");
                            column.setType(Type.SQL_VARCHAR);
                            metaData.columns[0] = column;
                            navigator = new RowSetNavigatorClient();
                            response = Result.newDataResult(metaData);
                            response.setNavigator(navigator);
                            response.getNavigator().add(new Object[]{map.size(session)});
                            return response;
                        }
                        if (queryParameter.equalsIgnoreCase("VALUES")) {
                            return map.valuesWithResultSet(session);
                        }
                        if (!queryParameter.equalsIgnoreCase("KEY_SET")) break;
                        return map.keySetWithResult(session);
                    }
                }
            }
            case 3009: {
                collection = (Collection)this.parameters[0];
                describeType = (Integer)this.parameters[1];
                tupleNames = (List)this.parameters[2];
                metaType = (Integer)this.parameters[3];
                if (describeType == 1035) {
                    metaData = this.createMetaData(new Pair[]{new Pair<String, CharacterType>("Name", Type.SQL_VARCHAR), new Pair<String, CharacterType>("Type", Type.SQL_VARCHAR), new Pair<String, NumberType>("Precision", Type.SQL_INTEGER), new Pair<String, NumberType>("Scale", Type.SQL_INTEGER), new Pair<String, BooleanType>("Nullable", Type.SQL_BOOLEAN), new Pair<String, BooleanType>("Searchable", Type.SQL_BOOLEAN), new Pair<String, BooleanType>("Primary Key", Type.SQL_BOOLEAN), new Pair<String, BooleanType>("Index", Type.SQL_BOOLEAN), new Pair<String, BooleanType>("Identity", Type.SQL_BOOLEAN), new Pair<String, CharacterType>("Comment", Type.SQL_VARCHAR)});
                    navigator = new RowSetNavigatorClient();
                    result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    disclosableFields = session.getGrantee().getDisclosableFields(collection.getBaseTable());
                    for (Tuple tuple : new CollectionMetaDataImpl(collection).getTuples()) {
                        tupleName = tuple.getName();
                        columnName = ((ColumnSchema)tuple.getColumnBase()).getObjectName();
                        if (disclosableFields != null && !disclosableFields.contains(columnName)) {
                            tupleName = "***";
                        }
                        comment = tuple.getComment();
                        navigator.add(new Object[]{tupleName, tuple.getTypeName(), tuple.getPrecision(), tuple.getScale(), tuple.isNullable(), tuple.isSearchable(), tuple.isPrimaryKey(), tuple.isIndex(), tuple.isIdentity(), comment != null ? comment : ""});
                    }
                    return result;
                }
                if (describeType == 1124) {
                    metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_BOOLEAN, Type.SQL_BOOLEAN, Type.SQL_BOOLEAN, Type.SQL_BOOLEAN, Type.STRING}, new String[]{"Name", "Columns", "Primary Key", "Unique", "Built", "Valid", "Type"});
                    navigator = new RowSetNavigatorClient();
                    result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    for (Index index : collection.getBaseTable().getIndexList()) {
                        columns = new ArrayList<String>();
                        for (i = 0; i < index.getColumns().length; ++i) {
                            columnIndex = index.getColumns()[i];
                            columnName = collection.getBaseTable().getColumn(columnIndex).getNameString();
                            if (index.getColumnDesc()[i]) {
                                columnName = (String)columnName + "(desc)";
                            }
                            columns.add((String)columnName);
                        }
                        if (columns.size() == 0 && index.getObjectName().name.equals("IDX")) continue;
                        indexType = "AVL";
                        if (index instanceof IndexSnapshot) {
                            indexType = ((IndexSnapshot)index).getSIndexType().toString();
                        }
                        navigator.add(new Object[]{index.getObjectName().getNameString(), columns.toString(), collection.getBaseTable().getPrimaryIndex() == index, index.isUnique(), index.isBuilt(), index.isValid(), indexType});
                    }
                    fullTextIndexes = collection.getBaseTable().getFullTextIndexes();
                    if (fullTextIndexes != null) {
                        for (FullTextIndex index : fullTextIndexes) {
                            tableColumns = new ArrayList<CallSite>();
                            tableIndexes = index.getTableIndexes();
                            for (i = 0; i < tableIndexes.size(); ++i) {
                                tableIndex = tableIndexes.get(i);
                                tableName = tableIndex.getTable().getObjectName().name;
                                columnsList = tableIndex.getTable().getColumnListSQL(tableIndex.getColumnIndexes(), tableIndex.getIndexColumns().size());
                                tableColumns.add((CallSite)(tableName + columnsList));
                            }
                            navigator.add(new Object[]{index.getObjectName().getNameString(), tableColumns.toString(), false, false, true, true, "Full-Text"});
                        }
                    }
                    return result;
                }
                if (describeType == 937) {
                    metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Event Trigger", "Trigger Type", "Trigger Condition", "Absolute Order", "Relative Order", "State", "Last Error", "Created", "Last Modified"});
                    navigator = new RowSetNavigatorClient();
                    result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    triggersByType = new LinkedHashMap<String, TreeMap<K, V>>();
                    for (TriggerDef trigger : collection.getBaseTable().triggerList) {
                        if (!(trigger instanceof RecompiledTrigger)) continue;
                        eventTrigger = (RecompiledTrigger)trigger;
                        triggerType = "EVENT";
                        if (eventTrigger instanceof ReplicationEventTrigger) {
                            replicationEntity = ((ReplicationEventTrigger)eventTrigger).getReplicationEntity();
                            triggerType = replicationEntity instanceof ReplicationSource ? "REPLICA SOURCE" : "REPLICA TARGET";
                        } else if (eventTrigger instanceof ReplicationValidateTrigger) {
                            triggerType = "VALIDATE TRIGGER";
                        } else if (eventTrigger instanceof ReplicationModifyTrigger) {
                            triggerType = "MODIFY TRIGGER";
                        } else if (eventTrigger instanceof WindowTriggerDefSQL) {
                            triggerType = "WINDOW";
                        }
                        treeMap = triggersByType.getOrDefault(triggerType, new TreeMap<K, V>());
                        triggersByType.put((String)triggerType, treeMap);
                        list = treeMap.getOrDefault(trigger.getActionTimingIndex(), new ArrayList<E>());
                        treeMap.put(trigger.getActionTimingIndex(), list);
                        list.add(trigger);
                    }
                    for (Map.Entry entry : triggersByType.entrySet()) {
                        absoluteIndex = 1;
                        for (List list : ((TreeMap)entry.getValue()).values()) {
                            list.sort(Comparator.comparingInt((ToIntFunction<TriggerDef>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, lambda$getResult$0(com.streamscape.ds.trigger.TriggerDef ), (Lcom/streamscape/ds/trigger/TriggerDef;)I)()));
                            for (TriggerDef trigger : list) {
                                eventTrigger = (RecompiledTrigger)trigger;
                                stateHolder = eventTrigger.aggregateStateHolder();
                                navigator.add(new Object[]{eventTrigger.getObjectName().name, entry.getKey(), trigger.getActionTimingString() + " " + trigger.getOperationTypeString(), "" + absoluteIndex++, trigger.getTriggerOrderString(), eventTrigger.getStateName((DataspaceStoreState)stateHolder.getState()), stateHolder.getLastOrSyntaxOrAllErrors(), SqlUtils.getObjectCreatedTimestamp(session, trigger), SqlUtils.getObjectModifiedTimestamp(session, trigger)});
                            }
                        }
                    }
                    return result;
                }
                if (describeType == 1126) {
                    metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Tuple", "Type", "Data Size In Memory", "Deleted Size In Memory", "Total Size In Memory", "Size On Disk", "Deleted", "Nulls"});
                    navigator = new RowSetNavigatorClient();
                    result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    if (!collection.getBaseTable().isSnapshot()) {
                        throw new DataspaceException("Statistics is available for snapshots only.");
                    }
                    addRow = (Consumer<Object[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getResult$1(com.streamscape.ds.navigator.RowSetNavigatorClient java.lang.Object[] ), ([Ljava/lang/Object;)V)((RowSetNavigatorClient)navigator);
                    sTable = ((SnapshotDataspaceTable)collection.getBaseTable()).getSTable();
                    totalInMemoryData = 0L;
                    totalInMemoryRemoved = 0L;
                    totalInMemoryFull = 0L;
                    totalOnDisk = -1L;
                    totalNullsPercentage = 0.0;
                    totalDeletedPercentage = 0.0;
                    if (sTable.getDeletedRows().count() > 0) {
                        totalDeletedPercentage = (double)sTable.getDeletedRows().count() / (double)sTable.rowCountWithDeleted();
                    }
                    for (i = 0; i < collection.getBaseTable().columnList.size(); ++i) {
                        columnSchema = (ColumnSchema)collection.getBaseTable().columnList.get(i);
                        column = sTable.column(columnSchema.getNameString());
                        sizeInMemoryData = column.sizeInMemoryData();
                        sizeInMemoryFull = column.sizeInMemoryFull();
                        sizeOnDisk = column.sizeOnDisk();
                        nullsPercentage = 0.0;
                        if (column.size() > 0) {
                            nullsPercentage = (double)column.countMissing() / (double)column.size() * 100.0;
                        }
                        sizeInMemoryRemoved = column.type() == ColumnType.STRING || column.type() == ColumnType.CATEGORY ? ((AbstractStringColumn)column).sizeInMemory(sTable.getDeletedRows().getSelection()) : (long)((double)sizeInMemoryData * totalDeletedPercentage);
                        addRow.accept(new Object[]{column.name(), columnSchema.getDataType().getNameString(), sizeInMemoryData -= sizeInMemoryRemoved, sizeInMemoryRemoved, sizeInMemoryFull, sizeOnDisk, totalDeletedPercentage * 100.0, nullsPercentage});
                        totalInMemoryData += sizeInMemoryData;
                        totalInMemoryRemoved += sizeInMemoryRemoved;
                        totalInMemoryFull += sizeInMemoryFull;
                        totalOnDisk += sizeOnDisk;
                        if (sizeOnDisk == -1L) {
                            totalOnDisk = -1L;
                        }
                        totalNullsPercentage = (totalNullsPercentage * (double)i + nullsPercentage) / (double)(i + 1);
                    }
                    for (SIndex sIndex : sTable.listSIndexes()) {
                        sizeInMemoryData = sIndex.sizeInMemoryData();
                        sizeInMemoryFull = sIndex.sizeInMemoryFull();
                        sizeOnDisk = sIndex.sizeOnDisk();
                        type = (sIndex.getType() == SIndexType.READ_ONLY ? "READ_ONLY " : "AVL ") + "INDEX(" + sIndex.getColumns().stream().map((Function<Column, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getResult$2(com.streamscape.ds.stable.columns.Column ), (Lcom/streamscape/ds/stable/columns/Column;)Ljava/lang/String;)()).collect(Collectors.joining(",")) + ")";
                        sizeInMemoryRemoved = 0L;
                        deletedPercentage = 0.0;
                        if (sIndex.getType() == SIndexType.READ_ONLY) {
                            sizeInMemoryRemoved = (long)((double)sizeInMemoryData * totalDeletedPercentage);
                            sizeInMemoryData -= sizeInMemoryRemoved;
                            deletedPercentage = totalDeletedPercentage;
                        }
                        addRow.accept(new Object[]{sIndex.getName(), type, sizeInMemoryData, sizeInMemoryRemoved, sizeInMemoryFull, sizeOnDisk, deletedPercentage * 100.0, -1.0});
                        totalInMemoryData += sizeInMemoryData;
                        totalInMemoryRemoved += sizeInMemoryRemoved;
                        totalInMemoryFull += sizeInMemoryFull;
                        totalOnDisk += sizeOnDisk;
                        if (sizeOnDisk != -1L) continue;
                        totalOnDisk = -1L;
                    }
                    sizeInMemoryData = sTable.getDeletedRows().sizeInMemory();
                    sizeOnDisk = sTable.getDeletedRows().sizeOnDisk();
                    addRow.accept(new Object[]{"delete_map", "BITMAP", sizeInMemoryData, 0L, sizeInMemoryData, sizeOnDisk, -1.0, -1.0});
                    totalInMemoryData += sizeInMemoryData;
                    if (totalOnDisk >= 0L) {
                        totalOnDisk += sizeOnDisk;
                    }
                    addRow.accept(new Object[]{"total", "*", totalInMemoryData, totalInMemoryRemoved, totalInMemoryFull, totalOnDisk, totalDeletedPercentage * 100.0, totalNullsPercentage});
                    return result;
                }
                if (describeType == 1139) {
                    rowMetaData = collection.getBaseTable().getRowMetaData();
                    metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{metaType == 78 ? Type.OTHER : Type.STRING}, new String[]{"Meta Data"});
                    navigator = new RowSetNavigatorClient();
                    result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    resultObject = rowMetaData;
                    try {
                        if (metaType == 1109) {
                            resultObject = DataspaceStore.getContext().getXSerializer().serialize(rowMetaData);
                        } else if (metaType == 1110) {
                            resultObject = HTTPUtils.getJsonSerializerForRest((FabricContext)DataspaceStore.getContext(), JsonCustomization.builder().setNotation(JsonNotation.TYPE).addNotationLevel(JsonNotationLevel.NONE).setPrettyPrint(true).build()).serialize(rowMetaData);
                        }
                    }
                    catch (SerializerException exception) {
                        throw new DataspaceException("Failed to serialize meta data. Cause: " + Utils.formatExceptionWithUnrepeatedCauses(exception));
                    }
                    navigator.add(new Object[]{resultObject});
                    return result;
                }
                if (describeType == 639) {
                    metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR}, new String[]{"STATEMENT"});
                    navigator = new RowSetNavigatorClient();
                    result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    sqls = new ArrayList<String>();
                    if (collection instanceof VirtualTableCollection) {
                        sqls.add(((VirtualTableCollection)collection).getSQL(false));
                    } else {
                        sqls.addAll(Arrays.asList(collection.getSQL(new OrderedHashSet(), new OrderedHashSet())));
                    }
                    sqls.addAll(Arrays.asList(collection.getBaseTable().getCommentsSQL()));
                    navigator.add(new Object[]{new DDLCollectionFormatter(collection.getObjectName()).format(sqls)});
                    return result;
                }
                if (tupleNames != null) {
                    tupleName = tupleNames.stream().collect(Collectors.joining("."));
                    tuple = new CollectionMetaDataImpl(collection).getTuples().stream().filter((Predicate<Tuple>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getResult$3(java.util.List com.streamscape.ds.schema.collection.Tuple ), (Lcom/streamscape/ds/schema/collection/Tuple;)Z)((List)tupleNames)).findAny().orElse(null);
                    if (tuple == null) {
                        throw new DataspaceException("Tuple '" + (String)tupleNames.get(0) + "' doesn't exist.");
                    }
                    metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING}, new String[]{"Property", "Value"});
                    result = Result.newDataResult(metaData);
                    navigator = new RowSetNavigatorClient();
                    result.setNavigator(navigator);
                    dataType = tuple.getDataspaceType();
                    if (dataType instanceof ArrayType) {
                        dataType = ((ArrayType)dataType).collectionBaseType();
                    }
                    if (tupleNames.size() == 1) {
                        comment = tuple.getComment();
                        navigator.add(new Object[]{"Name", tuple.getName()});
                        navigator.add(new Object[]{"Type", tuple.getTypeName()});
                        navigator.add(new Object[]{"Precision", tuple.getPrecision()});
                        navigator.add(new Object[]{"Scale", tuple.getScale()});
                        navigator.add(new Object[]{"Nullable", tuple.isNullable()});
                        navigator.add(new Object[]{"Searchable", tuple.isSearchable()});
                        navigator.add(new Object[]{"Primary Key", tuple.isPrimaryKey()});
                        navigator.add(new Object[]{"Index", tuple.isIndex()});
                        navigator.add(new Object[]{"Comment", comment != null ? comment : ""});
                        clazz = dataType.getInternalClass(session);
                        if (clazz != null && !EntityCompleter.isPrimitive(clazz) && (semanticType = DataspaceStoreManager.getContext().getSemanticTypeCache().lookupSemanticClass(clazz)) != null) {
                            try {
                                SerializerUtils.SemanticTypeAncestor.valueOf(semanticType.getAncestorType());
                            }
                            catch (Exception exception) {
                                navigator.add(new Object[]{"Ancestor", semanticType.getAncestorType()});
                                navigator.add(new Object[]{"Description", semanticType.getDescription()});
                                navigator.add(new Object[]{"System", semanticType.isSystem()});
                                navigator.add(new Object[]{"Valid", semanticType.isValid()});
                                navigator.add(new Object[]{"Dirty", semanticType.isDirty()});
                                pkg = DataspaceStoreManager.getRuntimeContext().getPackageLoaderRegistry().lookupPackageBySemanticType(semanticType);
                                if (pkg != null) {
                                    navigator.add(new Object[]{"Package", pkg.getFullName()});
                                }
                            }
                        }
                    } else {
                        clazz = dataType.getInternalClass(session);
                        if (clazz != null) {
                            tupleNames.remove(0);
                            try {
                                rowSet = new SemanticTypeEntitiesDescriber(false, tupleNames.stream().collect(Collectors.joining(".")), DataspaceStoreManager.getContext()).describe(clazz);
                                if (!rowSet.next()) ** GOTO lbl276
                                for (i = 1; i <= rowSet.getMeta().getColumnCount(); ++i) {
                                    navigator.add(new Object[]{rowSet.getMeta().getColumnName(i), rowSet.getString(i)});
                                }
                            }
                            catch (Exception exception) {
                                throw new DataspaceException("Failed to analyze tuple '" + tupleName + "'. Cause: " + exception.getMessage());
                            }
                        } else {
                            throw new DataspaceException("Failed to load class for tuple '" + tuple.getName() + "' of type '" + tuple.getTypeName() + "'.");
                        }
                    }
lbl276:
                    // 4 sources

                    return result;
                }
                return collection.getCollectionProperties(session);
            }
            case 3313: {
                sequence = (NumberSequence)this.parameters[0];
                metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING}, new String[]{"Property", "Value"});
                navigator = new RowSetNavigatorClient();
                result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                navigator.add(new Object[]{"Name", sequence.getObjectName().name});
                navigator.add(new Object[]{"Start Value", sequence.getStartValue()});
                navigator.add(new Object[]{"Increment", sequence.getIncrement()});
                navigator.add(new Object[]{"Type", sequence.getDataType().getNameString()});
                navigator.add(new Object[]{"Min Value", sequence.getMinValue()});
                navigator.add(new Object[]{"Max Value", sequence.getMaxValue()});
                navigator.add(new Object[]{"Next Value", sequence.peek()});
                navigator.add(new Object[]{"Cycle", sequence.isCycle()});
                navigator.add(new Object[]{"Limit Reached", sequence.isLimitReached()});
                navigator.add(new Object[]{"Comment", sequence.getComment() != null ? sequence.getComment() : ""});
                firstReference = true;
                referencesToSequence = session.dataspaceStore.schemaManager.getReferencesTo(sequence.getObjectName());
                for (i = 0; i < referencesToSequence.size(); ++i) {
                    referenceName = (NameManager.ObjectName)referencesToSequence.get(i);
                    navigator.add(new Object[]{firstReference != false ? "References" : "", referenceName.getSchemaQualifiedStatementName()});
                    firstReference = false;
                }
                return result;
            }
            case 3280: {
                collection = (DirectoryTableCollection)this.parameters[0];
                file = (String)this.parameters[1];
                tuples = (Boolean)this.parameters[2];
                initResult = (Function<String[], Result>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getResult$4(java.lang.String[] ), ([Ljava/lang/String;)Lcom/streamscape/ds/result/Result;)();
                count = collection.size(session);
                if (file != null) {
                    try {
                        rs = collection.select(session, "Name = '" + file + "'");
                        if (!rs.next()) {
                            throw new DataspaceException("File '" + file + "' not found in directory table '" + collection.getCollectionName() + "'");
                        }
                        if (tuples) {
                            res = initResult.apply(new String[]{"Name", "Size", "Timestamp", "Mime Type"});
                            res.navigator.add(new Object[]{file, rs.getString("Size"), rs.getString("ModificationTime"), FileUtil.detectMimeType(collection.getPath() + "/" + file)});
                        }
                        res = initResult.apply(new String[]{"Property", "Value"});
                        res.navigator.add(new Object[]{"Name", file});
                        res.navigator.add(new Object[]{"Size", rs.getString("Size")});
                        res.navigator.add(new Object[]{"Timestamp", rs.getString("ModificationTime")});
                        res.navigator.add(new Object[]{"Mime Type", FileUtil.detectMimeType(collection.getPath() + "/" + file)});
                    }
                    catch (Exception e) {
                        throw new DataspaceException(e);
                    }
                } else if (tuples) {
                    res = initResult.apply(new String[]{"Name", "Entry count", "Dir Path", "FS type"});
                    res.navigator.add(new Object[]{collection.getCollectionName(), count, collection.getPath(), collection.getServerType(session)});
                } else {
                    res = initResult.apply(new String[]{"Property", "Value"});
                    res.navigator.add(new Object[]{"Name", collection.getCollectionName()});
                    res.navigator.add(new Object[]{"Entry count", count});
                    res.navigator.add(new Object[]{"Dir Path", collection.getPath()});
                    res.navigator.add(new Object[]{"FS type", collection.getServerType(session)});
                }
                return res;
            }
            case 3225: {
                sourceEntityName = (ReplicationEntityName)this.parameters[0];
                metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING}, new String[]{"Property", "Value"});
                navigator = new RowSetNavigatorClient();
                result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                if (sourceEntityName.isLocalNode()) {
                    unprocessedCount = -1L;
                    totalElementsCount = 0L;
                    minReplicationId = null;
                    minUnprocessedReplicationId = null;
                    maxUnprocessedReplicationId = null;
                    minUnprocessedTimestampStr = "none";
                    maxUnprocessedTimestampStr = "none";
                    holdByReplicas = new ArrayList<CallSite>();
                    replicationQueueName = ReplicationQueue.getQueueName(sourceEntityName.getDataspaceName(), sourceEntityName.getSourceOrReplicaName());
                    table = session.dataspaceStore.schemaManager.getTable(session, replicationQueueName, "RDS");
                    whereClause = "";
                    minHeldReplicationId = 0x7FFFFFFFFFFFFFFFL;
                    collection = session.dataspaceStore.schemaManager.getCollection(session, sourceEntityName.getSourceOrReplicaName(), sourceEntityName.getDataspaceName());
                    if (collection != null && (replicationSource = collection.getReplicationSource()) != null) {
                        replicas = replicationSource.listReplicas(session);
                        for (Object replicaInfo : replicas) {
                            if (replicaInfo.getReplicationId() < 0L) continue;
                            minHeldReplicationId = Math.min(minHeldReplicationId, replicaInfo.getReplicationId());
                        }
                    }
                    if (minHeldReplicationId == 0x7FFFFFFFFFFFFFFFL) {
                        minHeldReplicationId = -1L;
                    }
                    if (minHeldReplicationId >= 0L) {
                        whereClause = " where ReplicationId > " + minHeldReplicationId;
                    }
                    selectResult = session.executeDirectStatement("select min(ReplicationId) from " + table.getObjectName().getSchemaQualifiedStatementName());
                    if (selectResult.navigator.next() && selectResult.navigator.getCurrent(0) != null) {
                        minReplicationId = ((Number)selectResult.navigator.getCurrent(0)).longValue();
                    }
                    selectResult = session.executeDirectStatement("select ReplicationId, Timestamp from " + table.getObjectName().getSchemaQualifiedStatementName() + (String)whereClause + " limit 1");
                    if (selectResult.navigator.next()) {
                        if (selectResult.navigator.getCurrent(0) != null) {
                            minUnprocessedReplicationId = ((Number)selectResult.navigator.getCurrent(0)).longValue();
                        }
                        if (selectResult.navigator.getCurrent(1) != null) {
                            minUnprocessedTimestampStr = DataspaceDateTime.formatTimestampForResultSet(session, DataspaceDateTime.convertMillisToCalendar(session.getCalendar(), ((TimestampData)selectResult.navigator.getCurrent(1)).getMilliseconds()));
                        }
                    }
                    selectResult = session.executeDirectStatement("select count(*) from " + table.getObjectName().getSchemaQualifiedStatementName());
                    if (selectResult.navigator.next()) {
                        totalElementsCount = ((Number)selectResult.navigator.getCurrent(0)).longValue();
                    }
                    unprocessedCount = totalElementsCount;
                    if (minUnprocessedReplicationId == null) {
                        unprocessedCount = 0L;
                    } else if (whereClause.length() > 0 && minReplicationId != null && minReplicationId < minUnprocessedReplicationId) {
                        selectResult = session.executeDirectStatement("select count(*) from " + table.getObjectName().getSchemaQualifiedStatementName() + (String)whereClause);
                        if (selectResult.navigator.next()) {
                            unprocessedCount = ((Number)selectResult.navigator.getCurrent(0)).longValue();
                        }
                    }
                    if (unprocessedCount > 0L) {
                        selectResult = session.executeDirectStatement("select max(ReplicationId) from " + table.getObjectName().getSchemaQualifiedStatementName());
                        if (selectResult.navigator.next() && selectResult.navigator.getCurrent(0) != null) {
                            maxUnprocessedReplicationId = ((Number)selectResult.navigator.getCurrent(0)).longValue();
                        }
                        selectResult = session.executeDirectStatement("select max(Timestamp) from " + table.getObjectName().getSchemaQualifiedStatementName());
                        if (selectResult.navigator.next() && selectResult.navigator.getCurrent(0) != null) {
                            maxUnprocessedTimestampStr = DataspaceDateTime.formatTimestampForResultSet(session, DataspaceDateTime.convertMillisToCalendar(session.getCalendar(), ((TimestampData)selectResult.navigator.getCurrent(0)).getMilliseconds()));
                        }
                    }
                    replicationSource = null;
                    collection = session.dataspaceStore.schemaManager.getCollection(session, sourceEntityName.getSourceOrReplicaName(), sourceEntityName.getDataspaceName());
                    if (collection != null && (replicationSource = collection.getReplicationSource()) != null && maxUnprocessedReplicationId != null) {
                        replicas = replicationSource.listReplicas(session);
                        for (ReplicaInfo replicaInfo : replicas) {
                            if (replicaInfo.getReplicationId() < 0L || replicaInfo.getReplicationId() >= maxUnprocessedReplicationId) continue;
                            holdByReplicas.add((CallSite)(replicaInfo.getReplicaEntityName().toString() + "(" + replicaInfo.getReplicationId() + ")"));
                        }
                    }
                    navigator.add(new Object[]{"Name", sourceEntityName.getSourceOrReplicaName()});
                    navigator.add(new Object[]{"Source Collection", sourceEntityName.getFullName()});
                    navigator.add(new Object[]{"Queue Name", ReplicationQueue.getQueueName(sourceEntityName.getDataspaceName(), sourceEntityName.getSourceOrReplicaName())});
                    navigator.add(new Object[]{"Queue Type", table instanceof JournalFileQueueTable != false ? ReplicationQueue.QueueType.JOURNAL_FILE.ddlName() : ReplicationQueue.QueueType.DATASPACE.ddlName()});
                    navigator.add(new Object[]{"Unprocessed RU Count", unprocessedCount});
                    navigator.add(new Object[]{"Min Replication Id", minUnprocessedReplicationId != null ? minUnprocessedReplicationId : "none"});
                    navigator.add(new Object[]{"Min Timestamp", minUnprocessedTimestampStr});
                    navigator.add(new Object[]{"Max Replication Id", maxUnprocessedReplicationId != null ? maxUnprocessedReplicationId : "none"});
                    navigator.add(new Object[]{"Max Timestamp", maxUnprocessedTimestampStr});
                    navigator.add(new Object[]{"Backlogged Replicas", holdByReplicas.toString()});
                    navigator.add(new Object[]{"Max Queue Size", replicationSource != null && replicationSource.getReplicationQueueSettings().queueMaxSize > 0L ? SizeUnit.convertToBestEvent(replicationSource.getReplicationQueueSettings().queueMaxSize, SizeUnit.BYTES).toString() : "unlimited"});
                    navigator.add(new Object[]{"-----------", ""});
                    navigator.add(new Object[]{"Acknowledged RU Count", totalElementsCount - unprocessedCount});
                    if (table instanceof JournalFileQueueTable) {
                        fileManager = ((JournalFileQueueTable)table).getFilesManager();
                        navigator.add(new Object[]{"Size On Disk", SizeUnit.convertToBestFractional(fileManager.listFilePaths().stream().mapToLong((ToLongFunction<Path>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)J, lambda$getResult$5(java.nio.file.Path ), (Ljava/nio/file/Path;)J)()).sum(), SizeUnit.BYTES).toStringWithPrecision(2)});
                        navigator.add(new Object[]{"Block File Count", fileManager.listFileNames().size()});
                        navigator.add(new Object[]{"Block File Size", SizeUnit.convertToBestEvent(fileManager.getMaxFileSizeBytes(), SizeUnit.BYTES).toString()});
                        navigator.add(new Object[]{"RU Persistence", fileManager.getTransactionPersistentType().toString()});
                        navigator.add(new Object[]{"Write Flush Interval", fileManager.getFlushTimeout() + " ms"});
                        navigator.add(new Object[]{"Write Buffer Size", SizeUnit.convertToBestEvent(fileManager.getWriteBufferSizeBytes(), SizeUnit.BYTES).toString()});
                    }
                } else {
                    replicaResponse = ReplicationUtil.sendSqlRequestTo(session, sourceEntityName, this.sql);
                    if (!replicaResponse.isOk()) {
                        throw replicaResponse.getException();
                    }
                    if (replicaResponse.getRowSet() == null) {
                        throw new DataspaceException("Returned RowSet is null");
                    }
                    try {
                        while (replicaResponse.getRowSet().next()) {
                            navigator.add(new Object[]{replicaResponse.getRowSet().getString(1), replicaResponse.getRowSet().getString(2)});
                        }
                    }
                    catch (SQLException exception) {
                        throw new DataspaceException(exception);
                    }
                }
                return result;
            }
            case 3189: {
                collection = (AbstractCollection)this.parameters[0];
                lobs = (Boolean)this.parameters[1];
                flobs = (Boolean)this.parameters[2];
                types = (Boolean)this.parameters[3];
                consistency = (Boolean)this.parameters[4];
                consistencyResolve = (Boolean)this.parameters[5];
                orderByColumnName = (String)this.parameters[6];
                orderByDescending = (Boolean)this.parameters[7];
                topN = (Integer)this.parameters[8];
                normalizeScope = (TableTypesValidator.NormalizeScope)this.parameters[9];
                orderBy = orderByColumnName != null ? new TableDuplicatesResolver.OrderBy(orderByColumnName, orderByDescending) : null;
                lobValidator = session.dataspaceStore.lobManager.getValidator();
                flobValidator = session.dataspaceStore.flobManager.getValidator(false);
                if (flobs) {
                    navigator = new RowSetNavigatorClient();
                    result = Result.newDataResult(ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING, Type.LONG, Type.STRING, Type.STRING, Type.STRING}, new String[]{"Identity", "Column Name", "FlobID", "Location", "Filename", "Error"}));
                    result.setNavigator(navigator);
                    invalidTable = flobValidator.checkTableLobs(collection.getBaseTable(), null, null, true);
                    if (invalidTable != null) {
                        for (LobValidator.InvalidRow r : invalidTable.getInvalidRows()) {
                            for (LobValidator.InvalidColumn c : r.getInvalidColumns()) {
                                navigator.add(new Object[]{r.getIdentity().toString(), invalidTable.getColumnNames().get(c.getColumnId()), c.getLobId(), ((FlobData)c.getLobData()).getLocation(), ((FlobData)c.getLobData()).getFilename(), c.getException().getMessage()});
                            }
                        }
                    }
                    return result;
                }
                if (lobs) {
                    navigator = new RowSetNavigatorClient();
                    result = Result.newDataResult(ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING, Type.LONG, Type.STRING}, new String[]{"Identity", "Column Name", "LobID", "Error"}));
                    result.setNavigator(navigator);
                    invalidTable = lobValidator.checkTableLobs(collection.getBaseTable(), null, null, true);
                    if (invalidTable != null) {
                        for (LobValidator.InvalidRow r : invalidTable.getInvalidRows()) {
                            for (LobValidator.InvalidColumn c : r.getInvalidColumns()) {
                                navigator.add(new Object[]{r.getIdentity().toString(), invalidTable.getColumnNames().get(c.getColumnId()), c.getLobId(), c.getException().getMessage()});
                            }
                        }
                    }
                    return result;
                }
                if (types) {
                    navigator = new RowSetNavigatorClient();
                    result = Result.newDataResult(ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING, Type.STRING, Type.STRING}, new String[]{"Column Name", "Column Type", "Identity", "Error"}));
                    result.setNavigator(navigator);
                    invalidTypes = collection.validateTypes(topN != null ? topN : 0, normalizeScope);
                    if (invalidTypes != null) {
                        invalidTypes.getInvalidTypes().entrySet().stream().forEach((Consumer<Map.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getResult$8(com.streamscape.ds.navigator.RowSetNavigatorClient java.util.Map$Entry ), (Ljava/util/Map$Entry;)V)((RowSetNavigatorClient)navigator));
                    }
                    return result;
                }
                if (consistency) {
                    table = collection.getBaseTable();
                    resolver = new TableDuplicatesResolver(session.dataspaceStore, table);
                    if (consistencyResolve) {
                        tableDuplicates = resolver.findDuplicates(orderBy);
                        for (TableDuplicatesResolver.TableIndexDuplicates indexDuplicates : tableDuplicates.indexDuplicates) {
                            resolver.fixDuplicates(indexDuplicates);
                        }
                    }
                    tableDuplicates = resolver.findDuplicates(orderBy);
                    navigator = new RowSetNavigatorClient();
                    columnTypes = new ArrayList<CharacterType>();
                    columnTypes.add(Type.STRING);
                    columnTypes.add(Type.STRING);
                    columnTypes.add(Type.STRING);
                    columnTypes.add(Type.STRING);
                    columnNames = new ArrayList<String>();
                    columnNames.add("Constraint Name");
                    columnNames.add("Is Primary Key");
                    if (consistencyResolve) {
                        columnNames.add("Count Of Resolved Duplicate Keys");
                        columnNames.add("Total Count Resolved Of Duplicates");
                    } else {
                        columnNames.add("Count Of Duplicate Keys");
                        columnNames.add("Total Count Of Duplicates");
                    }
                    columnNameToIndex = new HashMap<String, Integer>();
                    for (TableDuplicatesResolver.TableIndexDuplicates indexDuplicates : tableDuplicates.indexDuplicates) {
                        for (String columnName : indexDuplicates.constraintColumnNames) {
                            if (columnNameToIndex.containsKey(columnName)) continue;
                            columnTypes.add(Type.STRING);
                            columnNames.add(columnName);
                            columnNameToIndex.put(columnName, columnNames.size() - 1);
                        }
                    }
                    if (orderBy != null) {
                        columnTypes.add(Type.STRING);
                        columnNames.add(orderBy.getColumnName());
                        columnNameToIndex.put(orderBy.getColumnName(), columnNames.size() - 1);
                    }
                    result = Result.newDataResult(ResultMetaData.newSimpleResultMetaData(columnTypes.toArray(new Type[0]), columnNames.toArray(new String[0])));
                    result.setNavigator(navigator);
                    for (TableDuplicatesResolver.TableIndexDuplicates indexDuplicates : tableDuplicates.indexDuplicates) {
                        for (List<Object[]> values : indexDuplicates.duplicateValues.values()) {
                            row = new Object[columnNames.size()];
                            row[0] = indexDuplicates.constraintName;
                            row[1] = indexDuplicates.isPrimaryKey;
                            row[2] = values.size();
                            row[3] = values.stream().map((Function<Object[], Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getResult$9(java.lang.Object[] ), ([Ljava/lang/Object;)Ljava/lang/Integer;)()).reduce(0, (BinaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$getResult$10(java.lang.Integer java.lang.Integer ), (Ljava/lang/Integer;Ljava/lang/Integer;)Ljava/lang/Integer;)());
                            for (i = 0; i < indexDuplicates.constraintColumnIndexes.size(); ++i) {
                                row[((Integer)columnNameToIndex.get((Object)indexDuplicates.constraintColumnNames.get((int)i))).intValue()] = values.get(0)[indexDuplicates.constraintColumnIndexes.get(i)];
                            }
                            navigator.add(row);
                            if (orderBy == null) continue;
                            for (Object[] rowValues : values) {
                                rowWithOrderBy = new Object[columnNames.size()];
                                rowWithOrderBy[0] = "";
                                rowWithOrderBy[1] = "";
                                rowWithOrderBy[2] = "";
                                rowWithOrderBy[3] = "";
                                for (i = 0; i < indexDuplicates.constraintColumnIndexes.size(); ++i) {
                                    rowWithOrderBy[((Integer)columnNameToIndex.get((Object)indexDuplicates.constraintColumnNames.get((int)i))).intValue()] = "";
                                }
                                value = rowValues[indexDuplicates.columnNames.indexOf(orderBy.getColumnName())];
                                if (value instanceof TimestampData) {
                                    value = DataspaceDateTime.formatTimestamp(session, ((TimestampData)value).getMilliseconds());
                                }
                                rowWithOrderBy[((Integer)columnNameToIndex.get((Object)orderBy.getColumnName())).intValue()] = value;
                                navigator.add(rowWithOrderBy);
                            }
                        }
                    }
                    return result;
                }
                collection.validate(true, topN != null ? topN : 0);
                navigator = new RowSetNavigatorClient();
                result = Result.newDataResult(ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING}, new String[]{"Property", "Value"}));
                result.setNavigator(navigator);
                navigator.add(new Object[]{"Number of Tuples", new CollectionMetaDataImpl(collection).getTuples().size()});
                navigator.add(new Object[]{"Number of Entries", collection.count(session)});
                collection.exposeCollectionState(navigator, true);
                return result;
            }
            case 3190: {
                collectionNames = (Set)this.parameters[0];
                all = (Boolean)this.parameters[1];
                verbose = (Boolean)this.parameters[2];
                flobValidator = session.dataspaceStore.flobManager.getValidator((Function<LobData, LobData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getResult$11(com.streamscape.ds.session.Session com.streamscape.ds.types.LobData ), (Lcom/streamscape/ds/types/LobData;)Lcom/streamscape/ds/types/LobData;)((Session)session));
                if (all) {
                    schema = session.dataspaceStore.schemaManager.findSchema(session.currentDataspace.statementName);
                    if (schema == null) {
                        throw new DataspaceException("Schema '" + String.valueOf(this.schemaName) + "' doesn't exist.");
                    }
                    for (i = 0; i < schema.getTables().size(); ++i) {
                        collectionNames.add(((Table)schema.getTables().get((int)i)).getObjectName().name);
                    }
                }
                if (verbose) {
                    navigator = new RowSetNavigatorClient();
                    result = Result.newDataResult(ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING, Type.LONG, Type.STRING, Type.STRING, Type.STRING, Type.STRING}, new String[]{"Collection Name", "Identity", "Column Name", "FlobID", "Location", "Filename", "Error"}));
                    result.setNavigator(navigator);
                    for (String collectionName : collectionNames) {
                        collection = (AbstractCollection)session.dataspaceStore.schemaManager.getCollection(session, collectionName, null);
                        Trace.logInfo(this, "Checking collection '" + collectionName + "'");
                        invalidTable = flobValidator.checkTableLobs(collection.getBaseTable(), null, null, true);
                        if (invalidTable == null) continue;
                        for (LobValidator.InvalidRow r : invalidTable.getInvalidRows()) {
                            for (LobValidator.InvalidColumn c : r.getInvalidColumns()) {
                                navigator.add(new Object[]{collection.getObjectName().name, r.getIdentity().toString(), invalidTable.getColumnNames().get(c.getColumnId()), c.getLobId(), ((FlobData)c.getLobData()).getLocation(), ((FlobData)c.getLobData()).getFilename(), c.getException().getMessage()});
                            }
                        }
                    }
                    return result;
                }
                navigator = new RowSetNavigatorClient();
                result = Result.newDataResult(ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING, Type.STRING, Type.SQL_BOOLEAN, Type.LONG, Type.LONG}, new String[]{"Collection Name", "Tuple", "Location", "Location Valid", "Valid Flobs", "Invalid FLobs"}));
                result.setNavigator(navigator);
                for (String collectionName : collectionNames) {
                    collection = (AbstractCollection)session.dataspaceStore.schemaManager.getCollection(session, collectionName, null);
                    Trace.logInfo(this, "Checking collection '" + collectionName + "'");
                    validationResult = flobValidator.validateFlobsForTable(collection.getBaseTable(), null);
                    for (Map.Entry<LobValidator.FlobValidationPerColumnAndLocationKey, LobValidator.FlobValidationPerColumnAndLocationValidCount> entry : validationResult.getMap().entrySet()) {
                        location = entry.getKey().getLocation();
                        locationExists = location != null && location.length() > 0 ? session.dataspaceStore.flobManager.getFlobFileManager().isFlobLocationExists(location) : false;
                        navigator.add(new Object[]{collection.getObjectName().name, entry.getKey().getColumn(), location, locationExists, entry.getValue().getValidCount(), entry.getValue().getInvalidCount()});
                    }
                }
                return result;
            }
            case 3310: {
                collectionColumnsMap = (Map)this.parameters[0];
                notEmpty = (Boolean)this.parameters[1];
                verbose = (Boolean)this.parameters[2];
                flobValidator = session.dataspaceStore.flobManager.getValidator((Function<LobData, LobData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getResult$12(com.streamscape.ds.session.Session boolean com.streamscape.ds.types.LobData ), (Lcom/streamscape/ds/types/LobData;)Lcom/streamscape/ds/types/LobData;)((Session)session, (boolean)notEmpty));
                if (verbose) {
                    navigator = new RowSetNavigatorClient();
                    result = Result.newDataResult(ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING, Type.LONG, Type.STRING, Type.STRING, Type.STRING, Type.STRING}, new String[]{"Collection Name", "Identity", "Column Name", "FlobID", "Location", "Filename", "Error"}));
                    result.setNavigator(navigator);
                    for (Map.Entry<K, V> collectionEntry : collectionColumnsMap.entrySet()) {
                        collection = (AbstractCollection)session.dataspaceStore.schemaManager.getCollection(session, (String)collectionEntry.getKey(), null);
                        for (Object columnName : (Set)collectionEntry.getValue()) {
                            if (collection.getBaseTable().findColumn((String)columnName) >= 0) continue;
                            throw new DataspaceException("Column '" + (String)columnName + "' doesn't exist in table '" + (String)collectionEntry.getKey() + "'.");
                        }
                        Trace.logInfo(this, "Validating collection '" + (String)collectionEntry.getKey() + "' and columns " + (((Set)collectionEntry.getValue()).size() == 0 ? "all" : ((Set)collectionEntry.getValue()).stream().collect(Collectors.joining(","))));
                        invalidTable = flobValidator.checkTableLobs(collection.getBaseTable(), (Set)collectionEntry.getValue(), null, true);
                        if (invalidTable == null) continue;
                        columnName = invalidTable.getInvalidRows().iterator();
                        while (columnName.hasNext()) {
                            r = (LobValidator.InvalidRow)columnName.next();
                            for (LobValidator.InvalidColumn c : r.getInvalidColumns()) {
                                navigator.add(new Object[]{collection.getObjectName().name, r.getIdentity().toString(), invalidTable.getColumnNames().get(c.getColumnId()), c.getLobId(), ((FlobData)c.getLobData()).getLocation(), ((FlobData)c.getLobData()).getFilename(), c.getException().getMessage()});
                            }
                        }
                    }
                    return result;
                }
                navigator = new RowSetNavigatorClient();
                result = Result.newDataResult(ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING, Type.STRING, Type.LONG, Type.LONG}, new String[]{"Collection Name", "Tuple", "Location", "Valid Flobs", "Invalid FLobs"}));
                result.setNavigator(navigator);
                for (Map.Entry<K, V> collectionEntry : collectionColumnsMap.entrySet()) {
                    collection = (AbstractCollection)session.dataspaceStore.schemaManager.getCollection(session, (String)collectionEntry.getKey(), null);
                    for (Object columnName : (Set)collectionEntry.getValue()) {
                        if (collection.getBaseTable().findColumn((String)columnName) >= 0) continue;
                        throw new DataspaceException("Column '" + (String)columnName + "' doesn't exist in table '" + (String)collectionEntry.getKey() + "'.");
                    }
                    Trace.logInfo(this, "Validating collection '" + (String)collectionEntry.getKey() + "' and columns " + (((Set)collectionEntry.getValue()).size() == 0 ? "all" : ((Set)collectionEntry.getValue()).stream().collect(Collectors.joining(","))));
                    validationResult = flobValidator.validateFlobsForTable(collection.getBaseTable(), (Set)collectionEntry.getValue());
                    columnName = validationResult.getMap().entrySet().iterator();
                    while (columnName.hasNext()) {
                        entry = (Map.Entry)columnName.next();
                        navigator.add(new Object[]{collection.getObjectName().name, ((LobValidator.FlobValidationPerColumnAndLocationKey)entry.getKey()).getColumn(), ((LobValidator.FlobValidationPerColumnAndLocationKey)entry.getKey()).getLocation(), ((LobValidator.FlobValidationPerColumnAndLocationValidCount)entry.getValue()).getValidCount(), ((LobValidator.FlobValidationPerColumnAndLocationValidCount)entry.getValue()).getInvalidCount()});
                    }
                }
                return result;
            }
            case 3311: {
                collectionColumnsMap = (Map)this.parameters[0];
                navigator = new RowSetNavigatorClient();
                result = Result.newDataResult(ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING, Type.STRING, Type.LONG, Type.LONG}, new String[]{"Collection Name", "Tuple", "Location", "Valid Flobs", "Invalid FLobs"}));
                result.setNavigator(navigator);
                flobValidator = session.dataspaceStore.flobManager.getValidator((Function<LobData, LobData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getResult$13(com.streamscape.ds.session.Session com.streamscape.ds.types.LobData ), (Lcom/streamscape/ds/types/LobData;)Lcom/streamscape/ds/types/LobData;)((Session)session));
                for (Map.Entry<K, V> collectionEntry : collectionColumnsMap.entrySet()) {
                    collection = (AbstractCollection)session.dataspaceStore.schemaManager.getCollection(session, (String)collectionEntry.getKey(), null);
                    for (Object columnName : (Set)collectionEntry.getValue()) {
                        if (collection.getBaseTable().findColumn((String)columnName) >= 0) continue;
                        throw new DataspaceException("Column '" + (String)columnName + "' doesn't exist in table '" + (String)collectionEntry.getKey() + "'.");
                    }
                    Trace.logInfo(this, "Invalidating collection '" + (String)collectionEntry.getKey() + "' and columns " + (((Set)collectionEntry.getValue()).size() == 0 ? "all" : ((Set)collectionEntry.getValue()).stream().collect(Collectors.joining(","))));
                    validationResult = flobValidator.validateFlobsForTable(collection.getBaseTable(), null);
                    columnName = validationResult.getMap().entrySet().iterator();
                    while (columnName.hasNext()) {
                        entry = (Map.Entry)columnName.next();
                        navigator.add(new Object[]{collection.getObjectName().name, ((LobValidator.FlobValidationPerColumnAndLocationKey)entry.getKey()).getColumn(), ((LobValidator.FlobValidationPerColumnAndLocationKey)entry.getKey()).getLocation(), ((LobValidator.FlobValidationPerColumnAndLocationValidCount)entry.getValue()).getValidCount(), ((LobValidator.FlobValidationPerColumnAndLocationValidCount)entry.getValue()).getInvalidCount()});
                    }
                }
                return result;
            }
            case 3192: {
                navigator = new RowSetNavigatorClient();
                result = Result.newDataResult(ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING, Type.STRING, Type.STRING, Type.LONG, Type.STRING}, new String[]{"Dataspace Name", "Collection Name", "Identity", "Column Name", "LobID", "Error"}));
                result.setNavigator(navigator);
                lobValidator = session.dataspaceStore.lobManager.getValidator();
                invalidFlobs = lobValidator.checkAllLobs(true);
                if (invalidFlobs != null) {
                    for (LobValidator.InvalidTable t : invalidFlobs.getInvalidTables()) {
                        for (LobValidator.InvalidRow r : t.getInvalidRows()) {
                            for (LobValidator.InvalidColumn c : r.getInvalidColumns()) {
                                navigator.add(new Object[]{t.getObjectName().schema.getNameString(), t.getObjectName().getNameString(), r.getIdentity().toString(), t.getColumnNames().get(c.getColumnId()), c.getLobId(), c.getException().getMessage()});
                            }
                        }
                    }
                    for (Long flobId : invalidFlobs.getUnreferencedLobs()) {
                        navigator.add(new Object[]{null, null, null, null, flobId, "Unreferenced LOB."});
                    }
                }
                return result;
            }
            case 3191: {
                dataspaceName = (String)this.parameters[0];
                tableName = (String)this.parameters[1];
                columnName = (String)this.parameters[2];
                onlyLocations = (Boolean)this.parameters[3];
                withTables = (Boolean)this.parameters[4];
                unreferenced = (Boolean)this.parameters[5];
                invalid = (Boolean)this.parameters[6];
                all = (Boolean)this.parameters[7];
                result = null;
                if (unreferenced || invalid) {
                    navigator = new RowSetNavigatorClient();
                    result = Result.newDataResult(ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING, Type.STRING, Type.STRING, Type.LONG, Type.STRING, Type.STRING, Type.STRING}, new String[]{"Dataspace Name", "Collection Name", "Identity", "Column Name", "FlobID", "Location", "Filename", "Error"}));
                    result.setNavigator(navigator);
                    flobValidator = session.dataspaceStore.flobManager.getValidator(false);
                    invalidFlobs = null;
                    unreferencedLobs = null;
                    if (unreferenced) {
                        invalidFlobs = flobValidator.checkAllLobs(invalid != false && dataspaceName == null);
                        unreferencedLobs = invalidFlobs.getUnreferencedLobs();
                    }
                    if (invalid) {
                        if (dataspaceName == null) {
                            if (invalidFlobs == null) {
                                invalidFlobs = flobValidator.checkAllLobs(true);
                            }
                        } else {
                            invalidFlobs = flobValidator.checkAllLobs(dataspaceName, tableName, columnName, null, true);
                        }
                    }
                    if (invalidFlobs != null && invalid) {
                        for (LobValidator.InvalidTable t : invalidFlobs.getInvalidTables()) {
                            for (LobValidator.InvalidRow r : t.getInvalidRows()) {
                                for (LobValidator.InvalidColumn c : r.getInvalidColumns()) {
                                    navigator.add(new Object[]{t.getObjectName().schema.getNameString(), t.getObjectName().getNameString(), r.getIdentity().toString(), t.getColumnNames().get(c.getColumnId()), c.getLobId(), ((FlobData)c.getLobData()).getLocation(), ((FlobData)c.getLobData()).getFilename(), c.getException().getMessage()});
                                }
                            }
                        }
                    }
                    if (unreferenced && unreferencedLobs != null) {
                        for (Long flobId : invalidFlobs.getUnreferencedLobs()) {
                            try {
                                flobData = session.dataspaceStore.flobManager.getFlobData(flobId);
                                navigator.add(new Object[]{null, null, null, null, flobId, flobData.getLocation(), flobData.getFilename(), "Unreferenced FLOB."});
                            }
                            catch (Exception exception) {
                                navigator.add(new Object[]{null, null, null, null, flobId, null, null, exception.getMessage()});
                            }
                        }
                    }
                } else if (onlyLocations) {
                    if (withTables) {
                        navigator = new RowSetNavigatorClient();
                        result = Result.newDataResult(ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.SQL_BOOLEAN, Type.STRING}, new String[]{"Location", "Exists", "References from"}));
                        result.setNavigator(navigator);
                        for (FlobManager.FlobLocation flobLocation : session.dataspaceStore.flobManager.listLocations(true)) {
                            navigator.add(new Object[]{flobLocation.getLocation(), flobLocation.exists(), flobLocation.getReferences().toString()});
                        }
                    } else {
                        navigator = new RowSetNavigatorClient();
                        result = Result.newDataResult(ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.SQL_BOOLEAN}, new String[]{"Location", "Exists"}));
                        result.setNavigator(navigator);
                        for (FlobManager.FlobLocation flobLocation : session.dataspaceStore.flobManager.listLocations(false)) {
                            navigator.add(new Object[]{flobLocation.getLocation(), flobLocation.exists()});
                        }
                    }
                } else if (all) {
                    if (withTables) {
                        navigator = new RowSetNavigatorClient();
                        result = Result.newDataResult(ResultMetaData.newSimpleResultMetaData(new Type[]{Type.LONG, Type.STRING, Type.STRING, Type.SQL_BOOLEAN, Type.SQL_INTEGER, Type.LONG, Type.STRING}, new String[]{"FlobID", "Location", "Filename", "Exists", "References Count", "Size", "References from"}));
                        result.setNavigator(navigator);
                        allFlobsInfo = dataspaceName != null ? session.dataspaceStore.flobManager.listAllFlobs(dataspaceName, tableName, columnName) : session.dataspaceStore.flobManager.listAllFlobs(true);
                        for (FlobManager.FlobDataIdWrapper flobDataIdWrapper : allFlobsInfo.getFlobDataIdWrappers()) {
                            navigator.add(new Object[]{flobDataIdWrapper.getFlobData().getId(), flobDataIdWrapper.getFlobData().getLocation(), flobDataIdWrapper.getFlobData().getFilename(), flobDataIdWrapper.exists(), flobDataIdWrapper.getFlobData().getUsageCount(), flobDataIdWrapper.getLength(), allFlobsInfo.resolveReferences(flobDataIdWrapper.getReferences()).toString()});
                        }
                    } else {
                        navigator = new RowSetNavigatorClient();
                        result = Result.newDataResult(ResultMetaData.newSimpleResultMetaData(new Type[]{Type.LONG, Type.STRING, Type.STRING, Type.SQL_BOOLEAN, Type.SQL_INTEGER, Type.LONG}, new String[]{"FlobID", "Location", "Filename", "Exists", "References Count", "Size"}));
                        result.setNavigator(navigator);
                        allFlobsInfo = dataspaceName != null ? session.dataspaceStore.flobManager.listAllFlobs(dataspaceName, tableName, columnName) : session.dataspaceStore.flobManager.listAllFlobs(false);
                        for (FlobManager.FlobDataIdWrapper flobDataIdWrapper : allFlobsInfo.getFlobDataIdWrappers()) {
                            navigator.add(new Object[]{flobDataIdWrapper.getFlobData().getId(), flobDataIdWrapper.getFlobData().getLocation(), flobDataIdWrapper.getFlobData().getFilename(), flobDataIdWrapper.exists(), flobDataIdWrapper.getFlobData().getUsageCount(), flobDataIdWrapper.getLength()});
                        }
                    }
                } else {
                    throw new DataspaceException("At least one of locations, unreferenced, invalid or all must be specified.");
                }
                return result;
            }
            case 3052: 
            case 3158: {
                object = (SchemaObject)this.parameters[0];
                mode = (Integer)this.parameters[1];
                noComments = (Boolean)this.parameters[2];
                noJavadoc = (Boolean)this.parameters[3];
                if (object == null) {
                    throw new DataspaceException("Specified " + (this.type == 3052 ? "trigger" : "actor") + " doesn't exist.");
                }
                if (mode == 989 || mode == 567 || mode == 634) {
                    sql = session.dataspaceStore.schemaManager.loadObjectDefinition(session, object);
                    if (sql == null) {
                        if (object instanceof RecompiledTrigger) {
                            sql = ((RecompiledTrigger)object).getPrettyPrintedSQL();
                        } else if (object instanceof Actor) {
                            sql = ((Actor)object).getPrettyPrintedSQL();
                        }
                    }
                    if (mode == 567) {
                        if (this.type == 3158) {
                            splitter = new ParserRPL.ActorSyntaxSplitter(session, sql);
                            if (!splitter.split()) {
                                sql = "Failed to split signatire/body.";
                            }
                            if ((pos = (sql = splitter.getRpl()).toUpperCase().replaceAll("\n", " ").indexOf("AS ")) > -1) {
                                sql = sql.substring(pos + "AS".length()).trim();
                            }
                        } else if (this.type == 3052) {
                            splitter = object instanceof ReplicationEventTrigger != false ? new ParserRPL.ReplicationEventTriggerSyntaxSplitter(session, sql) : (object instanceof ReplicationValidateTrigger != false ? new ParserRPL.ReplicationValidateTriggerSyntaxSplitter(session, sql) : (object instanceof ReplicationModifyTrigger != false ? new ParserRPL.ReplicationModifyTriggerSyntaxSplitter(session, sql) : (object instanceof WindowTriggerDefSQL != false ? new ParserRPL.WindowTriggerSyntaxSplitter(session, sql) : new ParserRPL.EventTriggerSyntaxSplitter(session, sql))));
                            sql = splitter.split() == false ? "Failed to split signature/body." : splitter.getRpl();
                            if (sql == null) {
                                sql = "";
                            }
                            if ((pos = sql.toUpperCase().replaceAll("\n", " ").indexOf("AS ")) > -1) {
                                sql = sql.substring(pos + "AS".length()).trim();
                            }
                        }
                    } else if (mode == 634) {
                        sql = BufferUtils.extractUnwrappedJavaDoc(sql);
                    }
                    if (mode != 634) {
                        if (noComments) {
                            sql = BufferUtils.removeComments(sql);
                        } else if (noJavadoc) {
                            sql = BufferUtils.removeJavaDoc(sql);
                        }
                    }
                    if (mode == 989 && object instanceof TriggerDef) {
                        sql = ParserRPL.EventTriggerSyntaxSplitter.replaceOrder(sql, ((TriggerDef)object).getTriggerOrderString());
                    }
                    metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR}, new String[]{Tokens.getKeyword(mode)});
                    navigator = new RowSetNavigatorClient();
                    result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    navigator.add(new Object[]{sql});
                    return result;
                }
                if (mode == 635) {
                    metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Event", "Type", "Selector", "Model"});
                    navigator = new RowSetNavigatorClient();
                    result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    if (this.type == 3052) {
                        if (object instanceof EventTriggerDefSQL) {
                            trigger = (EventTriggerDefSQL)object;
                            selector = trigger.getTriggerDefinition().getEventSelector();
                            if (selector == null || selector.length() == 0) {
                                selector = "x";
                            }
                            if (trigger.getTriggerDefinition().getTriggerActionTime() == TriggerActionTime.AFTER) {
                                eventId = trigger.getTriggerDefinition().getActionableEventId();
                                if (eventId != null) {
                                    navigator.add(new Object[]{StringUtils.wrapEventId(eventId), "Actionable", selector, this.resolveEventModel(eventId)});
                                }
                            } else {
                                it = session.dataspaceStore.schemaManager.databaseObjectIterator(32);
                                while (it.hasNext()) {
                                    handler = (Actor)it.next();
                                    if (!handler.getObjectName().name.equals(trigger.getTriggerDefinition().getEventHandlerName()) || handler.getActorEntries() == null) continue;
                                    for (Actor.ActorEntry event : handler.getActorEntries()) {
                                        eventId = event.getEventId();
                                        if (selector.equals("x")) {
                                            selector = event.getSelector();
                                        } else if (!selector.equals("x") && event.getSelector() != null && event.getSelector().length() > 0) {
                                            selector = "(" + event.getSelector() + ") && (" + (String)selector + ")";
                                        }
                                        if (selector == null || selector.length() == 0) {
                                            selector = "x";
                                        }
                                        navigator.add(new Object[]{StringUtils.wrapEventId(eventId), "Actionable", selector, this.resolveEventModel(eventId)});
                                    }
                                }
                            }
                        }
                        if (object instanceof TriggerDefSQL) {
                            trigger = (TriggerDefSQL)object;
                            selector = "x";
                            if (trigger.routine.eventIds != null) {
                                for (String eventId : trigger.routine.eventIds) {
                                    navigator.add(new Object[]{StringUtils.wrapEventId(eventId), "Source", selector, this.resolveEventModel(eventId)});
                                }
                            }
                        }
                    } else if (this.type == 3158) {
                        handler = (Actor)object;
                        if (handler.getActorEntries() != null) {
                            for (Object event : handler.getActorEntries()) {
                                eventId = event.getEventId();
                                selector = event.getSelector();
                                if (selector == null || selector.length() == 0) {
                                    selector = "x";
                                }
                                navigator.add(new Object[]{StringUtils.wrapEventId(eventId), "Sink", selector, this.resolveEventModel(eventId)});
                            }
                        }
                        selector = "x";
                        if (handler.getRoutine().eventIds != null) {
                            for (String eventId : handler.getRoutine().eventIds) {
                                navigator.add(new Object[]{StringUtils.wrapEventId(eventId), "Source", selector, this.resolveEventModel(eventId)});
                            }
                        }
                    }
                    return result;
                }
                if (mode != 935) ** GOTO lbl967
                if (this.type == 3052) {
                    if (this.parameters[0] instanceof EventTriggerDefSQL) {
                        eventTrigger = (EventTriggerDefSQL)this.parameters[0];
                        trigger = eventTrigger.getTriggerDefinition();
                        metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Property", "Value"});
                        navigator = new RowSetNavigatorClient();
                        result = Result.newDataResult(metaData);
                        result.setNavigator(navigator);
                        navigator.add(new Object[]{"Name", eventTrigger.getObjectName().name});
                        navigator.add(new Object[]{"Collection", eventTrigger.getTable() != null ? eventTrigger.getTable().getObjectName().name : ""});
                        navigator.add(new Object[]{"Event Scope", trigger != null ? trigger.getEventScope().name() : "unknown"});
                        navigator.add(new Object[]{"Trigger Condition", eventTrigger.getActionTimingString() + " " + eventTrigger.getOperationTypeString()});
                        navigator.add(new Object[]{"For Each Statement", false});
                        navigator.add(new Object[]{"Actionable Event", StringUtils.wrapEventId(trigger.getActionableEventId())});
                        if (eventTrigger.routine != null && eventTrigger.routine.eventIds != null) {
                            buffer = new StringBuilder();
                            first = true;
                            for (String eventId : eventTrigger.routine.eventIds) {
                                if (!first) {
                                    buffer.append(",");
                                } else {
                                    first = false;
                                }
                                buffer.append(StringUtils.wrapEventId(eventId));
                            }
                            navigator.add(new Object[]{"Source Events", buffer.toString()});
                        } else if (eventTrigger.routine == null) {
                            navigator.add(new Object[]{"Source Events", "routine not compiled"});
                        } else {
                            navigator.add(new Object[]{"Source Events", ""});
                        }
                        navigator.add(new Object[]{"Advisory Capable", false});
                        navigator.add(new Object[]{"RPL Expression", eventTrigger.getConditionSQL() != null ? eventTrigger.getConditionSQL() : ""});
                        navigator.add(new Object[]{"Enabled", eventTrigger.isEnabled()});
                        navigator.add(new Object[]{"Order", eventTrigger.getTriggerOrderString()});
                        eventTrigger.aggregateStateHolder().exposeState(navigator, false, true, "State", new Class[0]);
                        this.addCreatedModifiedTimestampToDescribe(navigator, session, object);
                        return result;
                    }
                    if (this.parameters[0] instanceof WindowTriggerDefSQL) {
                        windowTrigger = (WindowTriggerDefSQL)this.parameters[0];
                        metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Property", "Value"});
                        navigator = new RowSetNavigatorClient();
                        result = Result.newDataResult(metaData);
                        result.setNavigator(navigator);
                        navigator.add(new Object[]{"Name", windowTrigger.getObjectName().name});
                        navigator.add(new Object[]{"Collection", windowTrigger.getTable() != null ? windowTrigger.getTable().getObjectName().name : ""});
                        navigator.add(new Object[]{"Event Scope", windowTrigger != null ? windowTrigger.getEventScope().name() : "unknown"});
                        navigator.add(new Object[]{"Trigger Condition", windowTrigger.getActionTimingString() + " " + windowTrigger.getOperationTypeString()});
                        if (windowTrigger.routine != null && windowTrigger.routine.eventIds != null) {
                            buffer = new StringBuilder();
                            first = true;
                            for (String eventId : windowTrigger.routine.eventIds) {
                                if (!first) {
                                    buffer.append(",");
                                } else {
                                    first = false;
                                }
                                buffer.append(StringUtils.wrapEventId(eventId));
                            }
                            navigator.add(new Object[]{"Source Events", buffer.toString()});
                        } else if (windowTrigger.routine == null) {
                            navigator.add(new Object[]{"Source Events", "routine not compiled"});
                        } else {
                            navigator.add(new Object[]{"Source Events", ""});
                        }
                        navigator.add(new Object[]{"Advisory Capable", false});
                        navigator.add(new Object[]{"RPL Expression", windowTrigger.getConditionSQL() != null ? windowTrigger.getConditionSQL() : ""});
                        navigator.add(new Object[]{"Enabled", windowTrigger.isEnabled()});
                        windowTrigger.aggregateStateHolder().exposeState(navigator, false, true, "State", new Class[0]);
                        this.addCreatedModifiedTimestampToDescribe(navigator, session, object);
                        return result;
                    }
                } else {
                    handler = (Actor)this.parameters[0];
                    result = handler.getActorProperties(session);
                    this.addCreatedModifiedTimestampToDescribe(result.getNavigator(), session, object);
                    return result;
lbl967:
                    // 1 sources

                    throw new DataspaceException("Invalid mode specified " + Tokens.getKeyword(mode));
                }
            }
            case 3062: {
                sourceEntityName = (ReplicationEntityName)this.parameters[0];
                metrics = (Boolean)this.parameters[1];
                full = (Boolean)this.parameters[2];
                metricName = (String)this.parameters[3];
                metricsForReplicaEntityName = (ReplicationEntityName)this.parameters[4];
                response = ReplicationUtil.getSourceDefinition(session, sourceEntityName, null, true, metrics);
                if (!response.isOk()) {
                    throw new DataspaceException(response.getErrorMessage());
                }
                replicationSourceInfo = response.getReplicationSourceInfo();
                if (metrics) {
                    formatDate = (Function<Long, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getResult$14(com.streamscape.ds.session.Session java.lang.Long ), (Ljava/lang/Long;)Ljava/lang/String;)((Session)session);
                    if (full) {
                        map = replicationSourceInfo.getReplicaMetricsReportMap();
                        if (metricsForReplicaEntityName != null) {
                            replicaMetricsReport = map.get(metricsForReplicaEntityName.getFullName());
                            if (replicaMetricsReport == null) {
                                throw new DataspaceException("Metric for replica with name '" + metricsForReplicaEntityName.getFullName() + "' not found.");
                            }
                            map = Collections.singletonMap(metricsForReplicaEntityName.getFullName(), replicaMetricsReport);
                        }
                        result = new Result[1];
                        finalMap = map;
                        fillMetric = (BiConsumer<String, Object[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$getResult$15(java.lang.String java.util.Map com.streamscape.ds.result.Result[] java.util.function.Function java.lang.String java.lang.Object[] ), (Ljava/lang/String;[Ljava/lang/Object;)V)((StatementCollectionQuery)this, (String)metricName, finalMap, (Result[])result, formatDate);
                        fillMetricsFace = (BiConsumer<String, Object[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$getResult$16(java.util.function.BiConsumer java.lang.String java.lang.Object[] ), (Ljava/lang/String;[Ljava/lang/Object;)V)(fillMetric);
                        for (Map.Entry<String, ReplicationDeliveryMetrics.ReplicaMetricsReport> entry : map.entrySet()) {
                            fillMetricsFace.accept(entry.getKey(), new Object[]{"GLOBAL", entry.getValue().getGlobal()});
                        }
                        if (result[0] == null) {
                            throw new DataspaceException("Metric with name '" + metricName + "' doesn't exist.");
                        }
                        return result[0];
                    }
                    metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING}, new String[]{"Metric", "Value"});
                    navigator = new RowSetNavigatorClient();
                    result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    metricsReport = replicationSourceInfo.getReplicationSourceMetricsReport();
                    global = metricsReport.getGlobal();
                    total = global.getTotal();
                    average = global.getAverageInUnits();
                    navigator.add(new Object[]{"Collector Start Time", formatDate.apply(global.getStartTime())});
                    navigator.add(new Object[]{"Collector Elapsed Time", global.getEndTime() - global.getStartTime() + " ms"});
                    navigator.add(new Object[]{"----------------------------------", "-----------------------"});
                    navigator.add(new Object[]{"Total RU Count", global.getUnitsCount()});
                    navigator.add(new Object[]{"Total Statements", total.getStatementsCount()});
                    navigator.add(new Object[]{"Total Inserts", total.getInsertsCount()});
                    navigator.add(new Object[]{"Total Updates", total.getUpdatesCount()});
                    navigator.add(new Object[]{"Total Deletes", total.getDeletesCount()});
                    navigator.add(new Object[]{"Total Truncates", total.getTruncatesCount()});
                    navigator.add(new Object[]{"Total Rollbacks", global.getRollbacksCount()});
                    navigator.add(new Object[]{"----------------------------------", "-----------------------"});
                    navigator.add(new Object[]{"Total RU Commit Time ", total.getUnitCommitTime() + " ms"});
                    navigator.add(new Object[]{"Total RU Processing Time ", total.getUnitProcessingTime() + " ms"});
                    navigator.add(new Object[]{"Total RU Replica Processing Time ", replicationSourceInfo.isSync() != false ? total.getUnitProcessingTargetTime() + " ms" : "n/a"});
                    navigator.add(new Object[]{"----------------------------------", "-----------------------"});
                    navigator.add(new Object[]{"Average RU Statements", this.formatMetric(average.getStatementsCount(), 0)});
                    navigator.add(new Object[]{"Average RU Inserts", this.formatMetric(average.getInsertsCount(), 0)});
                    navigator.add(new Object[]{"Average RU Updates", this.formatMetric(average.getUpdatesCount(), 0)});
                    navigator.add(new Object[]{"Average RU Deletes", this.formatMetric(average.getDeletesCount(), 0)});
                    navigator.add(new Object[]{"Average RU Truncates", this.formatMetric(average.getTruncatesCount(), 0)});
                    navigator.add(new Object[]{"Average RU Batch Statements", replicationSourceInfo.isSync() != false ? this.formatMetric(average.getStatementsCount(), 0) : (replicationSourceInfo.getReplicationQueueSettings() != null ? this.formatMetric(average.getStatementsCount() * (double)replicationSourceInfo.getReplicationQueueSettings().batchSize, 0) : "n/a")});
                    navigator.add(new Object[]{"----------------------------------", "-----------------------"});
                    navigator.add(new Object[]{"Average RU Commit Time ", this.formatMetric(average.getUnitCommitTime()) + " ms"});
                    navigator.add(new Object[]{"Average RU Processing Time ", this.formatMetric(average.getUnitProcessingTime()) + " ms"});
                    navigator.add(new Object[]{"Average RU Replica Processing Time ", replicationSourceInfo.isSync() != false ? this.formatMetric(average.getUnitProcessingTargetTime()) + " ms" : "n/a"});
                    navigator.add(new Object[]{"----------------------------------", "-----------------------"});
                    navigator.add(new Object[]{"First RU Time", formatDate.apply(global.getMinTimestamp())});
                    navigator.add(new Object[]{"Last RU Time", formatDate.apply(global.getMaxTimestamp())});
                    return result;
                }
                metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING}, new String[]{"Property", "Value"});
                navigator = new RowSetNavigatorClient();
                result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                syncMode = replicationSourceInfo.isSync();
                replicationSourceSettings = replicationSourceInfo.getReplicationSourceSettings();
                replicationQueueSettings = replicationSourceInfo.getReplicationQueueSettings();
                navigator.add(new Object[]{"Source Name", sourceEntityName.getSourceOrReplicaName()});
                navigator.add(new Object[]{"Fully Qualified Name", sourceEntityName.getFullName()});
                navigator.add(new Object[]{"Dataspace Type", sourceEntityName.getDataspaceType()});
                navigator.add(new Object[]{"Source Collection Type", AbstractCollection.getCollectionTypeName(replicationSourceInfo.getSourceCollectionType())});
                navigator.add(new Object[]{"Enabled", replicationSourceInfo.isEnabled()});
                navigator.add(new Object[]{"Event Scope", replicationSourceInfo.getEventScope()});
                navigator.add(new Object[]{"Mode", syncMode != false ? "Sync" : "Async"});
                if (syncMode) {
                    navigator.add(new Object[]{"Rollback On Failure", replicationSourceInfo.isRollbackOnFailure()});
                }
                if (!syncMode) {
                    navigator.add(new Object[]{"Replication Queue", ReplicationQueue.getQueueName(sourceEntityName.getDataspaceName(), sourceEntityName.getSourceOrReplicaName())});
                    navigator.add(new Object[]{"Replication Queue Scan", replicationQueueSettings.batchInterval + " ms"});
                    navigator.add(new Object[]{"Replication Queue Scan After Error", replicationQueueSettings.batchIntervalError + " ms"});
                }
                navigator.add(new Object[]{"Replication Id", replicationSourceInfo.getReplicationId()});
                navigator.add(new Object[]{"Committed Id", replicationSourceInfo.getCommittedReplicationId()});
                if (!syncMode) {
                    navigator.add(new Object[]{"RU Batch Size", replicationQueueSettings.batchSize});
                }
                navigator.add(new Object[]{"RU Batch Timeout", replicationSourceSettings.batchTimeout + " ms"});
                navigator.add(new Object[]{"Total Replicas", replicationSourceInfo.getListReplicas().size()});
                navigator.add(new Object[]{"Replica Names", ReplicationUtil.formattedOutputReplicaList(replicationSourceInfo.getListReplicas(), true)});
                navigator.add(new Object[]{"Publish Metrics Time Window", replicationSourceSettings.publishMetricsTimeWindow > 0L ? replicationSourceSettings.publishMetricsTimeWindow + " " + SqlUtils.timeUnitToString(replicationSourceSettings.publishMetricsTimeWindowUnit) : "n/a"});
                navigator.add(new Object[]{"Publish Metrics Batch Window", replicationSourceSettings.publishMetricsUnitWindow > 0 ? Integer.valueOf(replicationSourceSettings.publishMetricsUnitWindow) : "n/a"});
                if (syncMode) {
                    navigator.add(new Object[]{"On Rollback Triggers", replicationSourceInfo.getRollbackTriggerNames() != null ? replicationSourceInfo.getRollbackTriggerNames().toString() : "[]"});
                    failedTransactionsCount = 0L;
                    if (replicationSourceInfo.getListReplicas().size() == 1 && replicationSourceInfo.getListReplicas().get(0).getReplicationId() >= 0L) {
                        failedTransactionsCount = replicationSourceInfo.getCommittedReplicationId() - replicationSourceInfo.getListReplicas().get(0).getReplicationId();
                    }
                    navigator.add(new Object[]{"Failed Transactions Count", failedTransactionsCount});
                }
                navigator.add(new Object[]{"RU Batch Error Count", replicationSourceInfo.getReplicationErrors().getReplicationErrorsCount()});
                navigator.add(new Object[]{"Batch Transfer Error Since", replicationSourceInfo.getReplicationErrors().getReplicationErrorsSince() == 0L ? "none" : DataspaceDateTime.formatTimestampForResultSet(session, replicationSourceInfo.getReplicationErrors().getReplicationErrorsSince())});
                navigator.add(new Object[]{"Batch Transfer Last Error", replicationSourceInfo.getReplicationErrors().getLastReplicationError() == null ? "none" : Utils.formatExceptionWithUnrepeatedCauses(replicationSourceInfo.getReplicationErrors().getLastReplicationError())});
                return result;
            }
            case 3234: {
                entityName = (ReplicationEntityName)this.parameters[0];
                asJson = (Boolean)this.parameters[1];
                asXml = (Boolean)this.parameters[2];
                metrics = (Boolean)this.parameters[3];
                withMetrics = (Boolean)this.parameters[4];
                atReplica = (Boolean)this.parameters[5];
                resultObject = null;
                if (atReplica) {
                    response = ReplicationUtil.getReplicaInfo(session, entityName, true);
                    if (!response.isOk()) {
                        throw new DataspaceException(response.getErrorMessage());
                    }
                    flowMetrics = new ReplicationFlow.ReplicationFlowMetrics();
                    flowMetrics.addReplicaMetricReport(response.getReplicaInfo().getReplicaEntityName().getFullName(), response.getReplicaInfo().getReplicaMetricsReport());
                    resultObject = flowMetrics;
                } else {
                    response = ReplicationUtil.getSourceDefinition(session, entityName, null, true, metrics != false || withMetrics != false);
                    if (!response.isOk()) {
                        throw new DataspaceException(response.getErrorMessage());
                    }
                    flowMetrics = null;
                    if (metrics || withMetrics) {
                        flowMetrics = new ReplicationFlow.ReplicationFlowMetrics();
                        flowMetrics.setReplicaMetricReports(response.getReplicationSourceInfo().getReplicaMetricsReportMap());
                    }
                    if (metrics) {
                        resultObject = flowMetrics;
                    } else {
                        flow = new ReplicationFlow();
                        info = response.getReplicationSourceInfo();
                        flow.setNodeName(entityName.getNodeName());
                        flow.setDataspaceType(entityName.getDataspaceType());
                        flow.setDataspaceName(entityName.getDataspaceName());
                        flow.setReplicationSourceName(entityName.getSourceOrReplicaName());
                        flow.setSourceCollectionType(info.getSourceCollectionType());
                        flow.setEnabled(info.isEnabled());
                        flow.setEventScope(info.getEventScope());
                        flow.setRollbackOnFailure(info.isRollbackOnFailure());
                        flow.setSync(info.isSync());
                        flow.setVersion(info.getVersion());
                        flow.setReplicationId(info.getReplicationId());
                        flow.setCommittedReplicationId(info.getCommittedReplicationId());
                        flow.setPublishMetricsTimeWindow(info.getReplicationSourceSettings().publishMetricsTimeWindow);
                        flow.setPublishMetricsTimeWindowUnit(info.getReplicationSourceSettings().publishMetricsTimeWindowUnit);
                        flow.setPublishMetricsUnitWindow(info.getReplicationSourceSettings().publishMetricsUnitWindow);
                        flow.setReplicationErrorsSince(info.getReplicationErrors().getReplicationErrorsSince());
                        flow.setReplicationErrorsCount(info.getReplicationErrors().getReplicationErrorsCount());
                        flow.setLastReplicationError(info.getReplicationErrors().getLastReplicationError() != null ? info.getReplicationErrors().getLastReplicationError().getMessage() : null);
                        flow.setRollbackTriggers(info.getRollbackTriggerNames());
                        if (!info.isSync()) {
                            queue = new ReplicationFlow.ReplicationQueue();
                            queue.setBatchInterval(info.getReplicationQueueSettings().batchInterval);
                            queue.setBatchIntervalError(info.getReplicationQueueSettings().batchIntervalError);
                            queue.setBatchSize(info.getReplicationQueueSettings().batchSize);
                            queue.setQueueFileMaxFileSize(info.getReplicationQueueSettings().queueFileMaxFileSize);
                            queue.setQueueFileWriteBufferSize(info.getReplicationQueueSettings().queueFileWriteBufferSize);
                            queue.setQueueFileWriteFlushDelay(info.getReplicationQueueSettings().queueFileWriteFlushDelay);
                            queue.setTransactionPersistenceType(info.getReplicationQueueSettings().transactionPersistenceType);
                            flow.setQueue(queue);
                        }
                        info.getListReplicas().forEach((Consumer<ReplicaInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getResult$17(com.streamscape.ds.session.Session com.streamscape.ds.replication.ReplicationFlow com.streamscape.ds.replication.ReplicaInfo ), (Lcom/streamscape/ds/replication/ReplicaInfo;)V)((Session)session, (ReplicationFlow)flow));
                        if (withMetrics) {
                            flow.setMetrics(flowMetrics);
                        }
                        resultObject = flow;
                    }
                }
                metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{asJson != false || asXml != false ? Type.OTHER : Type.STRING}, new String[]{"Flow"});
                navigator = new RowSetNavigatorClient();
                result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                try {
                    if (asXml) {
                        resultObject = DataspaceStore.getContext().getXSerializer().serialize(resultObject);
                    } else if (asJson) {
                        resultObject = HTTPUtils.getJsonSerializerForRest((FabricContext)DataspaceStore.getContext(), JsonCustomization.builder().setNotation(JsonNotation.TYPE).addNotationLevel(JsonNotationLevel.NONE).setPrettyPrint(true).build()).serialize(resultObject);
                    }
                }
                catch (SerializerException exception) {
                    throw new DataspaceException("Failed to serialize flow. Cause: " + Utils.formatExceptionWithUnrepeatedCauses(exception));
                }
                navigator.add(new Object[]{resultObject});
                return result;
            }
            case 3235: {
                schemaName = (NameManager.ObjectName)this.parameters[0];
                serializeTypeCode = (Integer)this.parameters[1];
                functionContentCode = (Integer)this.parameters[2];
                functionListFilterCode = (Integer)this.parameters[3];
                group = (SQLFunctionsMetaData.SQLFunctionMetaData.Group)this.parameters[4];
                functionList = new FunctionList();
                functionList.setGroups(SQLFunctionsMetaData.SQLFunctionMetaData.Group.getOrderedGroupList());
                if (functionListFilterCode == 305 || functionListFilterCode == 2) {
                    it = session.dataspaceStore.schemaManager.dataspaceObjectIterator(schemaName.name, 17);
                    while (it.hasNext()) {
                        function = (RoutineSchema)it.next();
                        if (function.routines == null || function.routines.length == 0) {
                            throw Error.error(5501, function.getObjectName().name);
                        }
                        routine = function.routines[0];
                        functionItem = new FunctionList.Function();
                        functionItem.setName(function.getObjectName().name);
                        for (i = 0; i < routine.getParameterCount(); ++i) {
                            parameter = routine.getParameter(i);
                            argumentMode = StatementUtil.parameterModeToString(parameter.getParameterMode());
                            functionItem.getArguments().add(new FunctionList.Argument(parameter.getNameString(), Tuple.getTypeName(parameter.getDataType()), argumentMode));
                        }
                        if (functionContentCode == 116) {
                            routineDefinition = session.dataspaceStore.schemaManager.loadObjectDefinition(session, routine);
                            functionItem.setDefinition(routineDefinition);
                            functionItem.setDescription(BufferUtils.extractUnwrappedJavaDoc(routineDefinition));
                        }
                        functionItem.setReturns(new FunctionList.Argument(null, Tuple.getTypeName(routine.getReturnType()), SQLQueryParameterMode.OUT.name()));
                        functionList.getFunctions().add(functionItem);
                    }
                }
                if (functionListFilterCode == 276 || functionListFilterCode == 2) {
                    systemFunctions = FunctionSQL.listFunctions();
                    for (String functionName : systemFunctions) {
                        functionItem = new FunctionList.Function();
                        functionItem.setName(functionName);
                        metadata = FunctionCustom.getFunctionMetaData(functionName);
                        if (metadata == null) {
                            metadata = FunctionSQL.getFunctionMetaData(functionName);
                        }
                        functionItem.setGroup(metadata.getGroup().getTitle());
                        functionItem.setSystem(true);
                        if (group != null && !metadata.getGroup().equals((Object)group)) continue;
                        for (i = 0; i < metadata.getArgumentsCount(); ++i) {
                            argument = metadata.getArgument(i);
                            typesStr = StatementUtil.functionArgumentTypesToString(argument);
                            functionItem.getArguments().add(new FunctionList.Argument(argument.getName(), typesStr, SQLQueryParameterMode.IN.name(), argument.isOptional()));
                        }
                        if (functionContentCode == 116) {
                            functionItem.setDescription(metadata.getDescription());
                        }
                        functionItem.setReturns(new FunctionList.Argument(null, Tuple.getTypeName(metadata.getResultType()), SQLQueryParameterMode.OUT.name()));
                        functionList.getFunctions().add(functionItem);
                    }
                }
                metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{serializeTypeCode != -1 ? Type.OTHER : Type.STRING}, new String[]{"Flow"});
                navigator = new RowSetNavigatorClient();
                result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                resultObject = functionList;
                try {
                    if (serializeTypeCode == 1109) {
                        resultObject = DataspaceStore.getContext().getXSerializer().serialize(functionList);
                    } else if (serializeTypeCode == 1110) {
                        resultObject = HTTPUtils.getJsonSerializerForRest((FabricContext)DataspaceStore.getContext(), JsonCustomization.builder().setNotation(JsonNotation.TYPE).addNotationLevel(JsonNotationLevel.NONE).setPrettyPrint(true).build()).serialize(functionList);
                    }
                }
                catch (SerializerException exception) {
                    throw new DataspaceException("Failed to serialize flow. Cause: " + Utils.formatExceptionWithUnrepeatedCauses(exception));
                }
                navigator.add(new Object[]{resultObject});
                return result;
            }
            case 3066: {
                replicaEntityName = (ReplicationEntityName)this.parameters[0];
                if (replicaEntityName.isLocalNode()) {
                    metrics = (Boolean)this.parameters[1];
                    full = (Boolean)this.parameters[2];
                    metricName = (String)this.parameters[3];
                    lastReplicationUnit = (Boolean)this.parameters[4];
                    state = (Boolean)this.parameters[5];
                    replica = (ReplicationTarget)session.dataspaceStore.schemaManager.getSchemaObject(replicaEntityName.getSourceOrReplicaName(), replicaEntityName.getDataspaceName(), 29);
                    getReplicationQueueBacklog = (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$getResult$18(com.streamscape.ds.replication.ReplicationTarget com.streamscape.ds.session.Session com.streamscape.ds.replication.ReplicationEntityName ), ()Ljava/lang/String;)((StatementCollectionQuery)this, (ReplicationTarget)replica, (Session)session, (ReplicationEntityName)replicaEntityName);
                    formatDate = (Function<Long, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getResult$19(com.streamscape.ds.session.Session java.lang.Long ), (Ljava/lang/Long;)Ljava/lang/String;)((Session)session);
                    if (metrics) {
                        replicaMetricsReport = replica.getReplicaMetricsReport();
                        if (full) {
                            result = new Result[1];
                            fillMetric = (Consumer<Object[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getResult$20(java.lang.String com.streamscape.ds.result.Result[] java.util.function.Function java.lang.Object[] ), ([Ljava/lang/Object;)V)((StatementCollectionQuery)this, (String)metricName, (Result[])result, formatDate);
                            fillMetricsFace = (Consumer<Object[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getResult$21(java.util.function.Consumer java.lang.Object[] ), ([Ljava/lang/Object;)V)(fillMetric);
                            fillMetricsFace.accept(new Object[]{"GLOBAL", replicaMetricsReport.getGlobal()});
                            if (result[0] == null) {
                                throw new DataspaceException("Metric with name '" + metricName + "' doesn't exist.");
                            }
                            return result[0];
                        }
                        metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING}, new String[]{"Metric", "Value"});
                        navigator = new RowSetNavigatorClient();
                        result = Result.newDataResult(metaData);
                        result.setNavigator(navigator);
                        global = replicaMetricsReport.getGlobal();
                        total = replicaMetricsReport.getGlobal().getTotal();
                        averageInBatches = replicaMetricsReport.getGlobal().getAverageInBatches();
                        averageInUnits = replicaMetricsReport.getGlobal().getAverageInUnits();
                        navigator.add(new Object[]{"Collector Start Time", formatDate.apply(global.getStartTime())});
                        navigator.add(new Object[]{"Collector Elapsed Time", global.getEndTime() - global.getStartTime() + " ms"});
                        navigator.add(new Object[]{"----------------------------", "-----------------------"});
                        navigator.add(new Object[]{"Total RU Count", total.getUnitsCount()});
                        navigator.add(new Object[]{"Total Statements", total.getStatementsCount()});
                        navigator.add(new Object[]{"Total Inserts", total.getStatementsMap()[ReplicationOperationType.INSERT.ordinal()]});
                        navigator.add(new Object[]{"Total Updates", total.getStatementsMap()[ReplicationOperationType.UPDATE.ordinal()]});
                        navigator.add(new Object[]{"Total Deletes", total.getStatementsMap()[ReplicationOperationType.DELETE.ordinal()]});
                        navigator.add(new Object[]{"Total Truncates", total.getStatementsMap()[ReplicationOperationType.TRUNCATE.ordinal()]});
                        navigator.add(new Object[]{"Total Failed RU", total.getFailedUnitsCount()});
                        navigator.add(new Object[]{"Total Discarded Statements", total.getDiscardedStatementsCount()});
                        navigator.add(new Object[]{"Total Ignored Statements", total.getIgnoredStatementsCount()});
                        navigator.add(new Object[]{"----------------------------", "-----------------------"});
                        navigator.add(new Object[]{"Average Insert Time", this.formatMetric(averageInUnits.getStatementsMapTime()[ReplicationOperationType.INSERT.ordinal()]) + " ms"});
                        navigator.add(new Object[]{"Average Update Time", this.formatMetric(averageInUnits.getStatementsMapTime()[ReplicationOperationType.UPDATE.ordinal()]) + " ms"});
                        navigator.add(new Object[]{"Average Delete Time", this.formatMetric(averageInUnits.getStatementsMapTime()[ReplicationOperationType.DELETE.ordinal()]) + " ms"});
                        navigator.add(new Object[]{"Average Truncate Time", this.formatMetric(averageInUnits.getStatementsMapTime()[ReplicationOperationType.TRUNCATE.ordinal()]) + " ms"});
                        navigator.add(new Object[]{"Average Statement Time", this.formatMetric(total.getStatementsCount() > 0L ? (double)total.getStatementsMapTime()[ReplicationOperationType.TRANSACTION.ordinal()] / (double)total.getStatementsCount() : 0.0) + " ms"});
                        navigator.add(new Object[]{"Average RU Process Time", this.formatMetric(averageInUnits.getStatementsMapTime()[ReplicationOperationType.TRANSACTION.ordinal()]) + " ms"});
                        navigator.add(new Object[]{"Average RU Statements", this.formatMetric(averageInUnits.getStatementsCount(), 0)});
                        if (replica.isSyncSet() && !replica.isSync()) {
                            navigator.add(new Object[]{"----------------------------", "-----------------------"});
                            navigator.add(new Object[]{"Replication Queue Backlog", getReplicationQueueBacklog.get() + " RU"});
                        }
                        navigator.add(new Object[]{"----------------------------", "-----------------------"});
                        navigator.add(new Object[]{"Transfer Batch Start", formatDate.apply(global.getMinTimestamp())});
                        navigator.add(new Object[]{"Transfer Batch Last", formatDate.apply(global.getMaxTimestamp())});
                        navigator.add(new Object[]{"Total Transfer Batches", global.getCount()});
                        navigator.add(new Object[]{"Total Batch Read Time", total.getBatchReadTime() + " ms"});
                        navigator.add(new Object[]{"Total Batch Size", total.getBatchSizeInBytes() > 0L ? SizeUnit.convertToBestFractional(total.getBatchSizeInBytes(), SizeUnit.BYTES).toStringWithPrecision(2) : "n/a"});
                        navigator.add(new Object[]{"Total Batch Process Time", total.getTargetProcessingTime() + " ms"});
                        navigator.add(new Object[]{"Total RU Process Time", total.getStatementsMapTime()[ReplicationOperationType.TRANSACTION.ordinal()] + " ms"});
                        navigator.add(new Object[]{"Total Unprocessed RU", total.getUnprocessedUnitsCount()});
                        navigator.add(new Object[]{"Total Unprocessed Statements", total.getUnprocessedStatementsCount()});
                        navigator.add(new Object[]{"Total Unprocessed Inserts", total.getUnprocessedStatementsMap() != null ? total.getUnprocessedStatementsMap()[ReplicationOperationType.INSERT.ordinal()] : 0L});
                        navigator.add(new Object[]{"Total Unprocessed Updates", total.getUnprocessedStatementsMap() != null ? total.getUnprocessedStatementsMap()[ReplicationOperationType.UPDATE.ordinal()] : 0L});
                        navigator.add(new Object[]{"Total Unprocessed Deletes", total.getUnprocessedStatementsMap() != null ? total.getUnprocessedStatementsMap()[ReplicationOperationType.DELETE.ordinal()] : 0L});
                        navigator.add(new Object[]{"Total Unprocessed Truncates", total.getUnprocessedStatementsMap() != null ? total.getUnprocessedStatementsMap()[ReplicationOperationType.TRUNCATE.ordinal()] : 0L});
                        navigator.add(new Object[]{"----------------------------", "-----------------------"});
                        navigator.add(new Object[]{"Average Batch Read Time", this.formatMetric(averageInBatches.getBatchReadEndTime()) + " ms"});
                        navigator.add(new Object[]{"Average Batch Process Time", this.formatMetric(averageInBatches.getTargetProcessingTime()) + " ms"});
                        navigator.add(new Object[]{"Average Batch Size", SizeUnit.convertToBestFractional((long)averageInBatches.getBatchSizeInBytes(), SizeUnit.BYTES).toStringWithPrecision(2)});
                        navigator.add(new Object[]{"Average RU In Batch", this.formatMetric(averageInBatches.getUnitsCount(), 0) + " RU"});
                        navigator.add(new Object[]{"Average RU Batch Statements", this.formatMetric(averageInBatches.getStatementsCount(), 0)});
                        return result;
                    }
                    if (lastReplicationUnit) {
                        metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR}, new String[]{"Value"});
                        navigator = new RowSetNavigatorClient();
                        result = Result.newDataResult(metaData);
                        result.setNavigator(navigator);
                        unit = replica.getLastReplicationUnit();
                        json = "";
                        if (unit != null) {
                            try {
                                json = HTTPUtils.getJsonSerializerForRest((FabricContext)DataspaceStore.getContext(), JsonCustomization.builder().setPrettyPrint(true).build()).serialize(unit);
                            }
                            catch (SerializerException exception) {
                                throw new DataspaceException(exception);
                            }
                        }
                        navigator.add(new Object[]{json});
                        return result;
                    }
                    if (state) {
                        metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR}, new String[]{"State"});
                        navigator = new RowSetNavigatorClient();
                        result = Result.newDataResult(metaData);
                        result.setNavigator(navigator);
                        navigator.add(new Object[]{replica.getState().getStateWithSourceDisabled(replica.isSourceEnabled())});
                        return result;
                    }
                    metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Property", "Value"});
                    navigator = new RowSetNavigatorClient();
                    result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    replicaInfo = replica.getReplicaInfo(metrics);
                    navigator.add(new Object[]{"Name", replicaInfo.getReplicaEntityName().getSourceOrReplicaName()});
                    navigator.add(new Object[]{"Fully Qualified Source Name", replicaInfo.getSourceEntityName().getFullName()});
                    navigator.add(new Object[]{"Source Dataspace Type", replicaInfo.getSourceEntityName().getDataspaceType()});
                    navigator.add(new Object[]{"Fully Qualified Target Name", replicaInfo.getReplicaEntityName().getFullName()});
                    navigator.add(new Object[]{"Target Dataspace Type", replicaInfo.getReplicaEntityName().getDataspaceType()});
                    navigator.add(new Object[]{"Target Collection Name", replicaInfo.getReplicaEntityName().getCollectionName()});
                    navigator.add(new Object[]{"Target Collection Type", replicaInfo.getTargetCollectionType() != null ? AbstractCollection.getCollectionTypeName(replicaInfo.getTargetCollectionType()) : "n/a"});
                    if (replicaInfo.getTargetCollectionType() == CollectionType.VTABLE) {
                        vserverName = replicaInfo.getTargetVirtualServerName();
                        if (vserverName != null && replicaInfo.getTargetVirtualServerType() != null) {
                            vserverName = (String)vserverName + " (" + replicaInfo.getTargetVirtualServerType() + ")";
                        }
                        navigator.add(new Object[]{"Target Virtual Server", vserverName != null ? vserverName : "n/a"});
                    }
                    navigator.add(new Object[]{"Target Event Scope", replicaInfo.getEventScope()});
                    navigator.add(new Object[]{"State", replicaInfo.getState().getStateWithSourceDisabled(replicaInfo.isSourceEnabled())});
                    navigator.add(new Object[]{"State Changed At", formatDate.apply(replicaInfo.getLastTimeStateChanged())});
                    if (replicaInfo.getState() == ReplicaState.STOPPED) {
                        navigator.add(new Object[]{"Replica Stopped At", formatDate.apply(replicaInfo.getLastTimeStartedStopped())});
                    } else if (replicaInfo.getState() != ReplicaState.EVICTED && replicaInfo.getState() != ReplicaState.DROPPED) {
                        navigator.add(new Object[]{"Replica Started At", formatDate.apply(replicaInfo.getLastTimeStartedStopped())});
                    }
                    navigator.add(new Object[]{"Suspended", replicaInfo.isSuspended()});
                    if (replicaInfo.isSuspended()) {
                        navigator.add(new Object[]{"Replica Suspended At", formatDate.apply(replicaInfo.getLastTimeResumedSuspended())});
                    } else {
                        navigator.add(new Object[]{"Replica Resumed At", formatDate.apply(replicaInfo.getLastTimeResumedSuspended())});
                    }
                    v0 = new Object[2];
                    v0[0] = "Mode";
                    v0[1] = replicaInfo.getSync() != null ? (replicaInfo.getSync().booleanValue() ? "Sync" : "Async") : "n/a";
                    navigator.add(v0);
                    if (replicaInfo.getSync() != null && !replicaInfo.getSync().booleanValue()) {
                        navigator.add(new Object[]{"Replication Queue Backlog", getReplicationQueueBacklog.get() + " RU"});
                    }
                    navigator.add(new Object[]{"Renew", replicaInfo.isRenew()});
                    navigator.add(new Object[]{"Materialize", replicaInfo.isWithMaterialization()});
                    navigator.add(new Object[]{"Retry Count", replicaInfo.getRetryCount()});
                    navigator.add(new Object[]{"ReplicationId", replicaInfo.getReplicationId()});
                    navigator.add(new Object[]{"Meta Schema", replicaInfo.getMetaSchema().toString()});
                    navigator.add(new Object[]{"On Update", replicaInfo.isUpsert() != false ? "UPSERT" : "UPDATE"});
                    navigator.add(new Object[]{"Ignore On Fail Delete", replicaInfo.isIgnoreOnFailDelete() != false ? "x" : ""});
                    navigator.add(new Object[]{"Ignore On Fail Update", replicaInfo.isIgnoreOnFailUpdate() != false ? "x" : ""});
                    navigator.add(new Object[]{"Ignore On Fail Insert", replicaInfo.isIgnoreOnFailInsert() != false ? "x" : ""});
                    navigator.add(new Object[]{"On Success Triggers", replicaInfo.getSuccessTriggers() != null ? replicaInfo.getSuccessTriggers().toString() : "[]"});
                    navigator.add(new Object[]{"On Fail Triggers", replicaInfo.getFailTriggers() != null ? replicaInfo.getFailTriggers().toString() : "[]"});
                    navigator.add(new Object[]{"Validate Triggers", replicaInfo.getValidationTriggers() != null ? replicaInfo.getValidationTriggers().toString() : "[]"});
                    navigator.add(new Object[]{"Modify Trigger", replicaInfo.getTransformTrigger() != null ? replicaInfo.getTransformTrigger() : ""});
                    navigator.add(new Object[]{"Primary Key", replicaInfo.getPrimaryReplicationKey() != null ? replicaInfo.getPrimaryReplicationKey().toString() : "[]"});
                    navigator.add(new Object[]{"Publish Time Window", replicaInfo.getPublishTimeWindow() != 0L ? replicaInfo.getPublishTimeWindow() + " " + SqlUtils.timeUnitToString(replicaInfo.getPublishTimeWindowUnit()) : "disabled"});
                    navigator.add(new Object[]{"Publish Batch Window", replicaInfo.getPublishBatchWindow() != 0L ? Long.valueOf(replicaInfo.getPublishBatchWindow()) : "disabled"});
                    navigator.add(new Object[]{"Last Error", replicaInfo.getLastError() != null ? replicaInfo.getLastError() : ""});
                    return result;
                }
                replicaResponse = ReplicationUtil.sendSqlRequestTo(session, replicaEntityName, this.sql);
                if (!replicaResponse.isOk()) {
                    throw replicaResponse.getException();
                }
                if (replicaResponse.getRowSet() == null) {
                    throw new DataspaceException("Returned RowSet is null");
                }
                try {
                    types = new Type[replicaResponse.getRowSet().getRowMetaData().getColumnCount()];
                    names = new String[replicaResponse.getRowSet().getRowMetaData().getColumnCount()];
                    for (i = 0; i < types.length; ++i) {
                        names[i] = replicaResponse.getRowSet().getRowMetaData().getColumnDescriptor(i + 1).getName();
                        types[i] = Type.STRING;
                    }
                    metaData = ResultMetaData.newSimpleResultMetaData(types, names);
                    navigator = new RowSetNavigatorClient();
                    result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    while (replicaResponse.getRowSet().next()) {
                        navigator.add(replicaResponse.getRowSet().getCurrentRow().getRawData());
                    }
                    return result;
                }
                catch (SQLException exception) {
                    throw new DataspaceException(exception);
                }
            }
            case 3207: {
                metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Property", "Value"});
                navigator = new RowSetNavigatorClient();
                result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                link = (ReferenceLink)this.parameters[0];
                stateHolder = link.aggregateStateHolder();
                navigator.add(new Object[]{"Name", link.getObjectName().name});
                navigator.add(new Object[]{"Source Column", ReferenceLink.buildColumnName(link.getSourceColumnObjectName())});
                navigator.add(new Object[]{"Source Spath", link.getSourceSpath()});
                navigator.add(new Object[]{"Target Column", ReferenceLink.buildColumnName(link.getTargetColumnObjectName())});
                navigator.add(new Object[]{"Target Spath", link.getTargetSpath()});
                navigator.add(new Object[]{"Nullable", String.valueOf(link.isNullable())});
                navigator.add(new Object[]{"Description", link.getDescription() != null ? link.getDescription() : ""});
                navigator.add(new Object[]{"Facet Join", link.getFacetsJoin() != null ? link.getFacetsJoin().getSQL() : ""});
                navigator.add(new Object[]{"Aspect Join", link.getAspectsJoin() != null ? link.getAspectsJoin().getSQL() : ""});
                navigator.add(new Object[]{"State", ((DataspaceStoreState)stateHolder.getState()).toString()});
                navigator.add(new Object[]{"Error", stateHolder.getLastOrSyntaxOrAllErrors()});
                return result;
            }
            case 3073: {
                schemaObject = (TimerObject)this.parameters[0];
                metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR});
                metaData.columnLabels = new String[]{"Property", "Value"};
                metaData.columns = new ColumnBase[2];
                column = new ColumnBase("", "", "", "");
                column.setType(Type.SQL_VARCHAR);
                metaData.columns[0] = column;
                column = new ColumnBase("", "", "", "");
                column.setType(Type.SQL_VARCHAR);
                metaData.columns[1] = column;
                navigator = new RowSetNavigatorClient();
                result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                timer = FabricTimerManager.getInstance().getTimer(schemaObject.getTimerGroup(), schemaObject.getObjectName().name);
                navigator.add(new Object[]{"Name", schemaObject.getObjectName().name});
                navigator.add(new Object[]{"Group", schemaObject.getTimerGroup()});
                if (timer != null) {
                    navigator.add(new Object[]{"State", timer.getState().name()});
                    navigator.add(new Object[]{"Interval", schemaObject.getInterval() + " " + schemaObject.getTimeUnit().name().toLowerCase()});
                    navigator.add(new Object[]{"Repeat Count", timer.getRepeatCount()});
                    navigator.add(new Object[]{"Duration", timer.getDuration()});
                    navigator.add(new Object[]{"Remaining Time", timer.getRemainingTime()});
                    navigator.add(new Object[]{"Remaining Repeat Count", timer.getRemainingRepeatCount()});
                } else {
                    navigator.add(new Object[]{"State", FabricTimerState.EXPIRED.name()});
                    navigator.add(new Object[]{"Interval", schemaObject.getInterval() + " " + schemaObject.getTimeUnit().name().toLowerCase()});
                    navigator.add(new Object[]{"Repeat Count", schemaObject.getRepeatCount()});
                    navigator.add(new Object[]{"Duration", 0});
                    navigator.add(new Object[]{"Remaining Time", 0});
                    navigator.add(new Object[]{"Remaining Repeat Count", 0});
                }
                first = true;
                if (schemaObject.getParams() != null) {
                    for (Map.Entry<String, Expression> entry : schemaObject.getParams().entrySet()) {
                        navigator.add(new Object[]{first != false ? "Parameters" : "", entry.getKey() + " = " + entry.getValue().getSQL()});
                        first = false;
                    }
                }
                return result;
            }
            case 3110: {
                schemaObject = (ServerObject)this.parameters[0];
                metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Property", "Value"});
                navigator = new RowSetNavigatorClient();
                result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                schemaObject.describeProperties(session, navigator);
                return result;
            }
            case 3120: {
                schemaObject = (JobObject)this.parameters[0];
                metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Property", "Value"});
                navigator = new RowSetNavigatorClient();
                result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                schemaObject.describeProperties(navigator);
                return result;
            }
            case 3084: {
                schemaObject = (Type)this.parameters[0];
                metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Property", "Value"});
                navigator = new RowSetNavigatorClient();
                result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                typeName = Type.getTypeName(schemaObject.userTypeModifier.dataType.typeCode);
                if (typeName == null) {
                    typeName = schemaObject.userTypeModifier.dataType.getObjectName().name;
                }
                navigator.add(new Object[]{"Name", schemaObject.getObjectName().name});
                navigator.add(new Object[]{"Base Type", typeName});
                navigator.add(new Object[]{"System", schemaObject.getObjectName().schema.name.equals("SYS")});
                first = true;
                for (Constraint c : schemaObject.userTypeModifier.getConstraints()) {
                    navigator.add(new Object[]{first != false ? "Constraints" : "", c.getSQL()});
                    first = false;
                }
                if (schemaObject.userTypeModifier != null) {
                    schemaObject.userTypeModifier.exposeStateHolder(navigator);
                }
                return result;
            }
            case 3196: {
                schemaObject = (Type)this.parameters[0];
                metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Property", "Value"});
                navigator = new RowSetNavigatorClient();
                result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                navigator.add(new Object[]{"Name", schemaObject.getObjectName().name});
                navigator.add(new Object[]{"Base Type", schemaObject.userTypeModifier != null ? schemaObject.userTypeModifier.getName().name : schemaObject.getObjectName().name});
                navigator.add(new Object[]{"System", schemaObject.getObjectName().schema.name.equals("SYS")});
                first = true;
                for (Constraint c : schemaObject.userTypeModifier.getConstraints()) {
                    navigator.add(new Object[]{first != false ? "Constraints" : "", c.getSQL()});
                    first = false;
                }
                if (schemaObject.userTypeModifier != null) {
                    schemaObject.userTypeModifier.exposeStateHolder(navigator);
                }
                return result;
            }
            case 3134: {
                metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Property", "Value"});
                navigator = new RowSetNavigatorClient();
                result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                session.dataspaceStore.exposeDataspaceStoreState(navigator);
                return result;
            }
            case 3193: {
                metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Property", "Value"});
                navigator = new RowSetNavigatorClient();
                result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                dataspaceName = (NameManager.ObjectName)this.parameters[0];
                if (dataspaceName == null) {
                    dataspaceName = session.currentDataspace;
                }
                v1 = owner = (dataspace = (AbstractDataspace)session.dataspaceStore.lookup(dataspaceName.name)).getOwner() != null ? dataspace.getOwner().getObjectName().name : "unknown";
                if (owner.equalsIgnoreCase("sysadmin")) {
                    owner = "";
                }
                navigator.add(new Object[]{"Type", dataspace.getType()});
                navigator.add(new Object[]{"Name", dataspace.getName()});
                navigator.add(new Object[]{"Owner", owner});
                navigator.add(new Object[]{"Event Scope", dataspace.getEventScope().toString()});
                navigator.add(new Object[]{"Log Level", dataspace.getLogger() != null ? dataspace.getLogger().getLogLevel().name() : ""});
                navigator.add(new Object[]{"MetaSet", dataspace.getMetasetName() != null ? dataspace.getMetasetName() : "n/a"});
                dataspace.exposeDataspaceState(navigator, false, dataspace.getState());
                navigator.add(new Object[]{"Created Timestamp", dataspace.getCreatedAt() > 0L ? DataspaceDateTime.getSqlTimestampString(dataspace.getCreatedAt(), session.getTimeZone()) : "n/a"});
                return result;
            }
            case 3201: {
                metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING, Type.STRING, Type.STRING}, new String[]{"Type", "Collection", "Column", "Error"});
                navigator = new RowSetNavigatorClient();
                result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                dataspace = (AbstractDataspace)session.dataspaceStore.lookup(session.currentDataspace.name);
                invalidTypes = dataspace.validateTypes();
                if (invalidTypes != null) {
                    for (Map.Entry<OtherType, List<TableTypesValidator.InvalidTable>> invalidTypeEntry : invalidTypes.getInvalidTypes().entrySet()) {
                        for (TableTypesValidator.InvalidTable invalidTable : invalidTypeEntry.getValue()) {
                            for (TableTypesValidator.InvalidColumn column : invalidTable.getInvalidColumns()) {
                                navigator.add(new Object[]{invalidTypeEntry.getKey().getObjectName().name, invalidTable.getObjectName().name, column.getColumnName(), column.getError()});
                            }
                        }
                    }
                }
                return result;
            }
            case 3264: {
                metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"DEPENDANT OBJECT", "DEPENDANT TYPE", "DEPENDS ON", "OBJECT TYPE", "SYS"});
                navigator = new RowSetNavigatorClient();
                result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                objectName = (NameManager.ObjectName)this.parameters[0];
                withLocal = (Boolean)this.parameters[1];
                withExternal = (Boolean)this.parameters[2];
                depth = (Integer)this.parameters[3];
                all = (Boolean)this.parameters[4];
                addReferencesFrom = (BiConsumer<NameManager.ObjectName, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$getResult$22(boolean com.streamscape.ds.navigator.RowSetNavigatorClient com.streamscape.ds.session.Session com.streamscape.ds.NameManager$ObjectName java.util.Map ), (Lcom/streamscape/ds/NameManager$ObjectName;Ljava/util/Map;)V)((boolean)all, (RowSetNavigatorClient)navigator, (Session)session);
                switch (objectName.type) {
                    case 2: {
                        referencesFromSchema = session.dataspaceStore.schemaManager.getCascadingReferencesFromSchema(objectName, withLocal, withExternal, depth);
                        for (Map.Entry<NameManager.ObjectName, Map<NameManager.ObjectName, List<NameManager.ObjectName>>> entry : referencesFromSchema.entrySet()) {
                            addReferencesFrom.accept(entry.getKey(), entry.getValue());
                        }
                        break;
                    }
                    default: {
                        referencesFromObject = session.dataspaceStore.schemaManager.getCascadingReferencesFromObject(session.dataspaceStore.schemaManager.getSchemaObject(objectName), withLocal, withExternal, depth, objectName.schema);
                        addReferencesFrom.accept(objectName, referencesFromObject);
                        break;
                    }
                }
                return result;
            }
            case 3265: {
                metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"REFERENCED OBJECT", "OBJECT TYPE", "REFERENCED BY", "REFERENCE TYPE", "SYS"});
                navigator = new RowSetNavigatorClient();
                result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                objectName = (NameManager.ObjectName)this.parameters[0];
                withLocal = (Boolean)this.parameters[1];
                withExternal = (Boolean)this.parameters[2];
                depth = (Integer)this.parameters[3];
                all = (Boolean)this.parameters[4];
                addReferencesTo = (BiConsumer<NameManager.ObjectName, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$getResult$23(com.streamscape.ds.navigator.RowSetNavigatorClient com.streamscape.ds.session.Session com.streamscape.ds.NameManager$ObjectName java.util.Map ), (Lcom/streamscape/ds/NameManager$ObjectName;Ljava/util/Map;)V)((RowSetNavigatorClient)navigator, (Session)session);
                switch (objectName.type) {
                    case 2: {
                        referencesToSchema = session.dataspaceStore.schemaManager.getCascadingReferencesToSchema(objectName, withLocal, withExternal, depth);
                        for (Map.Entry<NameManager.ObjectName, Map<NameManager.ObjectName, List<NameManager.ObjectName>>> entry : referencesToSchema.entrySet()) {
                            addReferencesTo.accept(entry.getKey(), entry.getValue());
                        }
                        break;
                    }
                    default: {
                        referencesToObject = session.dataspaceStore.schemaManager.getCascadingReferencesToObject(objectName, withLocal, withExternal, depth);
                        addReferencesTo.accept(objectName, referencesToObject);
                        break;
                    }
                }
                return result;
            }
            case 3268: {
                queryString = (String)this.parameters[0];
                searchType = (FullTextQuery.SearchType)this.parameters[1];
                index = session.dataspaceStore.getFullTextManager().getSysldefIndex();
                if (index == null) {
                    throw new DataspaceException("Index is not initialized. Need to be re-indexed.");
                }
                sysldefTable = (Table)session.dataspaceStore.schemaManager.findSchemaObject("SYSLDEF", "SDS", 3);
                tuples = new ArrayList<FullTextTuple>();
                tuples.add(new FullTextTuple(sysldefTable, "COMPONENT_NAME"));
                tuples.add(new FullTextTuple(sysldefTable, "ENTITY_TYPE"));
                tuples.add(new FullTextTuple(sysldefTable, "ENTITY_NAME"));
                tuples.add(new FullTextTuple(FullTextTuple.FIND_TABLE_NAME, FullTextTuple.FIELD_ENTRIES_NAME, "Entry"));
                query = new FullTextQuery(queryString, new HashMap<Table, Map<IndexColumn, CollectionColumn.ColumnOperand>>(), Arrays.asList(new FullTextIndex[]{index}), FullTextQuery.ReturnType.DATA, tuples, searchType, FullTextQuery.OrderType.DESC, true, true, true, 0);
                sdsSession = FullTextUtils.retrieveSDSSession(session);
                return session.dataspaceStore.getFullTextManager().search(query, sdsSession).toResult();
            }
            case 3276: {
                queryString = (String)this.parameters[0];
                analyzer = new SchemaAnalyzer();
                rs = analyzer.find(session, queryString);
                metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Name", "Type", "Parent"});
                navigator = new RowSetNavigatorClient();
                result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                rs.getRows().forEach((Consumer<ResultRow>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getResult$24(com.streamscape.ds.navigator.RowSetNavigatorClient com.streamscape.ds.analyze.ResultRow ), (Lcom/streamscape/ds/analyze/ResultRow;)V)((RowSetNavigatorClient)navigator));
                return result;
            }
            case 3242: {
                indexes = (List)this.parameters[0];
                storesInvolved = new HashSet<PersistentStore>();
                for (Object[] objects : indexes) {
                    index = (Index)objects[0];
                    sIndex = ((IndexSnapshot)index).getSIndex();
                    if (sIndex == null) {
                        throw new DataspaceException("SIndex '" + index.getObjectName().getNameString() + "' isn't found.");
                    }
                    if (!sIndex.isValid()) {
                        throw new DataspaceException("SIndex '" + index.getObjectName().getNameString() + "' isn't valid.");
                    }
                    storesInvolved.add(((IndexSnapshot)index).getTable().store);
                }
                readOnlyTables = new HashSet<E>();
                buildIndex = (Consumer<Object[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getResult$25(java.util.Set java.lang.Object[] ), ([Ljava/lang/Object;)V)(readOnlyTables);
                for (PersistentStore store : storesInvolved) {
                    store.writeLock();
                }
                try {
                    if (indexes.size() > 1) {
                        executorService = Executors.newFixedThreadPool(indexes.size());
                        completionService = new ExecutorCompletionService<Void>(executorService);
                        for (Object[] objects : indexes) {
                            completionService.submit((Callable<Void>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$getResult$26(java.util.function.Consumer java.lang.Object[] ), ()Ljava/lang/Void;)(buildIndex, (Object[])objects));
                        }
                        buildException = null;
                        for (i = 0; i < indexes.size(); ++i) {
                            try {
                                future = completionService.take();
                                future.get();
                                continue;
                            }
                            catch (InterruptedException exception) {
                                throw new DataspaceException("Execution interrupted.");
                            }
                            catch (ExecutionException exception) {
                                buildException = new DataspaceException(exception.getCause());
                            }
                        }
                        if (buildException != null) {
                            throw buildException;
                        }
                    } else {
                        buildIndex.accept((Object[])indexes.get(0));
                    }
                    readOnlyTables.stream().forEach((Consumer<Table>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getResult$27(com.streamscape.ds.schema.table.Table ), (Lcom/streamscape/ds/schema/table/Table;)V)());
                }
                finally {
                    for (PersistentStore store : storesInvolved) {
                        store.writeUnlock();
                    }
                }
                return Result.updateNoResult;
            }
            case 3315: {
                functionUnitName = (String)this.parameters[0];
                functionName = (String)this.parameters[1];
                mode = (Integer)this.parameters[2];
                m = new DataspaceFunctionUnitManagerForCompletion();
                functionUnit = m.lookupFunctionUnit(functionUnitName);
                if (functionUnit == null) {
                    throw new DataspaceException("Function unit '" + functionUnitName + "' does not exist.");
                }
                function = functionUnit.getEntry(functionName);
                if (function == null) {
                    throw new DataspaceException("Function '" + functionName + "' doesn't exist in function unit '" + functionUnitName + "'.");
                }
                if (mode == -1) {
                    mode = 1002;
                }
                metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR}, new String[]{Tokens.getKeyword(mode)});
                navigator = new RowSetNavigatorClient();
                result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                if (mode == 1002) {
                    navigator.add(new Object[]{function.getMetaData().getFunctionSignature()});
                } else if (mode == 634) {
                    navigator.add(new Object[]{function.getMetaData().getDescription()});
                } else if (mode == 1159) {
                    navigator.add(new Object[]{function.getMetaData().getFullDescription()});
                }
                return result;
            }
            case 3095: {
                function = this.parameters[0];
                functionName = (String)this.parameters[1];
                mode = (Integer)this.parameters[2];
                noComments = (Boolean)this.parameters[3];
                noJavadoc = (Boolean)this.parameters[4];
                if (function instanceof RoutineSchema) {
                    schemaObject = (RoutineSchema)function;
                    if (schemaObject.routines != null && schemaObject.routines.length > 0) {
                        routine = schemaObject.routines[0];
                        if (mode == -1) {
                            mode = 989;
                        }
                        if (mode == 989 || mode == 567 || mode == 634 || mode == 1002 || mode == 1159) {
                            resultSql = "Function SQL not found.";
                            temp = session.dataspaceStore.schemaManager.loadObjectDefinition(session, routine);
                            if (temp != null) {
                                resultSql = temp;
                                if (mode == 567 || mode == 1002 || mode == 1159) {
                                    splitter = new ParserRPL.FunctionSyntaxSplitter(session, resultSql);
                                    if (!splitter.split()) {
                                        resultSql = "Failed to split SQL signature from body.";
                                    } else if (mode == 567) {
                                        resultSql = splitter.getRpl();
                                        if (resultSql != null && (pos = resultSql.toUpperCase().replaceAll("(\r\n|\n)", " ").indexOf("AS ")) > -1) {
                                            resultSql = resultSql.substring(pos + "AS".length()).trim();
                                        }
                                    } else {
                                        resultSql = splitter.getSignature();
                                    }
                                } else if (mode == 634) {
                                    resultSql = BufferUtils.extractUnwrappedJavaDoc(resultSql);
                                }
                                if (mode != 634) {
                                    if (noComments) {
                                        resultSql = BufferUtils.removeComments(resultSql);
                                    } else if (noJavadoc) {
                                        resultSql = BufferUtils.removeJavaDoc(resultSql);
                                    }
                                }
                            }
                            metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR}, new String[]{Tokens.getKeyword(mode)});
                            navigator = new RowSetNavigatorClient();
                            result = Result.newDataResult(metaData);
                            result.setNavigator(navigator);
                            navigator.add(new Object[]{resultSql});
                            return result;
                        }
                        if (mode == 990) {
                            metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_VARCHAR}, new String[]{"Name", "Type", "Mode"});
                            navigator = new RowSetNavigatorClient();
                            result = Result.newDataResult(metaData);
                            result.setNavigator(navigator);
                            for (i = 0; i < routine.getParameterCount(); ++i) {
                                parameter = routine.getParameter(i);
                                navigator.add(new Object[]{parameter.getNameString(), Tuple.getTypeName(parameter.getDataType()), StatementUtil.parameterModeToString(parameter.getParameterMode())});
                            }
                            navigator.add(new Object[]{"RETURNS", Tuple.getTypeName(routine.getReturnType()), SQLQueryParameterMode.OUT.name()});
                            return result;
                        }
                        if (mode == 935) {
                            metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING}, new String[]{"Property", "Value"});
                            navigator = new RowSetNavigatorClient();
                            result = Result.newDataResult(metaData);
                            result.setNavigator(navigator);
                            navigator.add(new Object[]{"Name", schemaObject.getObjectName().name});
                            comment = schemaObject.getObjectName().comment;
                            navigator.add(new Object[]{"Comment", comment != null ? comment : "---"});
                            routine.aggregateStateHolder().exposeState(navigator, false, true, "State", new Class[0]);
                            this.addCreatedModifiedTimestampToDescribe(navigator, session, routine);
                            return result;
                        }
                        throw new DataspaceException("Unsupportable parameter.");
                    }
                    throw Error.error(5501, functionName);
                }
                functionMetaData = FunctionCustom.getFunctionMetaData(functionName);
                if (functionMetaData == null) {
                    functionMetaData = FunctionSQL.getFunctionMetaData(functionName);
                }
                if (functionMetaData == null) {
                    throw Error.error(5501, functionName);
                }
                if (mode == -1) {
                    mode = 1002;
                }
                if (mode == 567 || mode == 989) {
                    throw new DataspaceException("Body and definition not available for system function.");
                }
                if (mode == 1002) {
                    metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR}, new String[]{"Function Definition"});
                    navigator = new RowSetNavigatorClient();
                    result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    definition = functionMetaData.getSignature();
                    navigator.add(new Object[]{definition});
                    return result;
                }
                if (mode == 634) {
                    metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR}, new String[]{"Function Description"});
                    navigator = new RowSetNavigatorClient();
                    result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    description = functionMetaData.getDescription();
                    navigator.add(new Object[]{description});
                    return result;
                }
                if (mode == 1159) {
                    metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR}, new String[]{"Function Description"});
                    navigator = new RowSetNavigatorClient();
                    result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    definition = functionMetaData.getSignature();
                    description = functionMetaData.getDescription();
                    navigator.add(new Object[]{definition + "\n\n" + description});
                    return result;
                }
                if (mode == 990) {
                    metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR, Type.SQL_VARCHAR, Type.SQL_BOOLEAN, Type.SQL_VARCHAR}, new String[]{"Name", "Type", "Optional", "Mode"});
                    navigator = new RowSetNavigatorClient();
                    result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    for (i = 0; i < functionMetaData.getArgumentsCount(); ++i) {
                        argument = functionMetaData.getArgument(i);
                        navigator.add(new Object[]{argument.getName(), StatementUtil.functionArgumentTypesToString(argument), argument.isOptional(), "IN"});
                    }
                    navigator.add(new Object[]{"RETURNS", SQLFunctionsMetaData.SQLFunctionMetaData.getTypeName(functionMetaData.getResultType()), false, "OUT"});
                    return result;
                }
                if (mode == 516) {
                    metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING}, new String[]{"Property", "Value"});
                    navigator = new RowSetNavigatorClient();
                    result = Result.newDataResult(metaData);
                    result.setNavigator(navigator);
                    navigator.add(new Object[]{"State", "ONLINE"});
                } else {
                    throw new DataspaceException("Unknown option specified.");
                }
            }
            case 3035: {
                collection = (ProcessQueueCollection)this.parameters[0];
                return collection.getQueueStatistics(session);
            }
            case 3089: {
                collection = (ProcessQueueCollection)this.parameters[0];
                response = Result.newSingleColumnResult("STATE");
                response.getNavigator().add(new Object[]{collection.getQueueState(session).name()});
                return response;
            }
            case 3339: {
                kgraphInstance = (KGraphInstanceSchemaObject)this.parameters[0];
                metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_VARCHAR}, new String[]{"KGRAPH"});
                navigator = new RowSetNavigatorClient();
                result = Result.newDataResult(metaData);
                result.setNavigator(navigator);
                navigator.add(new Object[]{kgraphInstance.toKGraph(session)});
                return result;
            }
            case 3341: {
                kgraphExpression = (Expression)this.parameters[0];
                kgraphObject = OtherTypeWrapper.unwrap(kgraphExpression.getValue(session));
                if (!(kgraphObject instanceof KGraph)) {
                    throw new DataspaceException("Provided expression does not evaluate to KGraph instance.");
                }
                new KGraphValidator().validate(session, (KGraph)kgraphObject);
                return Result.updateNoResult;
            }
            case 3340: {
                kgraphExpression = (Expression)this.parameters[0];
                kgraphObject = OtherTypeWrapper.unwrap(kgraphExpression.getValue(session));
                if (!(kgraphObject instanceof KGraph)) {
                    throw new DataspaceException("Provided expression does not evaluate to KGraph instance.");
                }
                kgraph = (KGraph)kgraphObject;
                kGraphInstanceSchemaObject = (KGraphInstanceSchemaObject)session.dataspaceStore.schemaManager.findSchemaObject(kgraph.getName(), session.currentDataspace.name, 46);
                if (kGraphInstanceSchemaObject == null) {
                    throw new DataspaceException("KGraph with specified name doesn't exist in dataspace. First create it with command CREATE KGRAPH.");
                }
                if (!kGraphInstanceSchemaObject.getKgraphType().getObjectName().name.equals(kgraph.getTypeName())) {
                    throw new DataspaceException("KGraph type cannot be changed.");
                }
                new KGraphValidator().validate(session, kgraph);
                cSpace = (CSpace)session.dataspaceStore.schemaManager.findSchema(session.currentDataspace.name);
                tableManager = cSpace.getCSpaceSysTablesManager();
                tableManager.deleteKGraph(session, kgraph.getName());
                tableManager.createKGraph(session, kgraph);
                return Result.updateNoResult;
            }
            case 3036: {
                collection = (Collection)this.parameters[0];
                seqId = (String)this.parameters[1];
                switch (1.$SwitchMap$com$streamscape$cli$ds$CollectionType[collection.getCollectionType().ordinal()]) {
                    case 2: 
                    case 3: {
                        return ((EventQueueCollection)collection).getSourceEvent(session, seqId);
                    }
                }
                throw new DataspaceException("Specified collection does not support event retrieval.");
            }
        }
        throw Error.runtimeError(201, "StatementCollectionQuery");
    }

    private void addCreatedModifiedTimestampToDescribe(RowSetNavigator navigator, Session session, SchemaObject object) {
        Pair<Timestamp, Timestamp> timestamps = session.dataspaceStore.schemaManager.loadObjectTimestamps(session, object);
        navigator.add(new Object[]{"Created", timestamps == null || timestamps.first == null ? "n/a" : DataspaceDateTime.getSqlTimestampString((Timestamp)timestamps.first)});
        navigator.add(new Object[]{"Last Modified", timestamps == null || timestamps.second == null ? "n/a" : DataspaceDateTime.getSqlTimestampString((Timestamp)timestamps.second)});
    }

    private String formatMetric(double d) {
        return this.formatMetric(d, 2);
    }

    private String formatMetric(double d, int precision) {
        return String.format("%." + precision + "f", d);
    }

    private Object resolveEventModel(String eventId) {
        try {
            return DataspaceManager.getContext().getDatagramPrototypeCache().getModel(eventId);
        }
        catch (DatagramFactoryException e) {
            Trace.logError(this, "Event model not found for event [" + eventId + "]. Cause: " + e.getMessage());
            return "Unknown";
        }
    }

    @Override
    public boolean isAutoCommitStatement() {
        return this.isTransactionStatement;
    }

    @Override
    public String describe(Session session) {
        return this.sql;
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("sql", this.sql);
        return result;
    }

    public Object getParameter(int index) {
        return this.parameters != null && this.parameters.length > index ? this.parameters[index] : null;
    }

    private static /* synthetic */ void lambda$getResult$27(Table t) {
        t.setDataReadOnly(true);
    }

    private static /* synthetic */ Void lambda$getResult$26(Consumer buildIndex, Object[] objects) throws Exception {
        buildIndex.accept(objects);
        return null;
    }

    private static /* synthetic */ void lambda$getResult$25(Set readOnlyTables, Object[] objects) {
        Index index = (Index)objects[0];
        boolean force = (Boolean)objects[1];
        boolean readOnly = (Boolean)objects[2];
        SIndex sIndex = ((IndexSnapshot)index).getSIndex();
        if (force) {
            sIndex.reset();
        }
        sIndex.build(((IndexSnapshot)index).getTable().getSTable().getSelection());
        if (readOnly) {
            readOnlyTables.add(((IndexSnapshot)index).getTable());
        }
    }

    private static /* synthetic */ void lambda$getResult$24(RowSetNavigatorClient navigator, ResultRow row) {
        navigator.add(new Object[]{row.getName(), row.getTypeName(), row.getParentName() == null ? "---" : row.getParentName()});
    }

    private static /* synthetic */ void lambda$getResult$23(RowSetNavigatorClient navigator, Session session, NameManager.ObjectName from, Map map) {
        for (Map.Entry referencedByEntry : map.entrySet()) {
            NameManager.ObjectName referencedBy = SemanticTypeAndPrototypeSchemaObjectsCache.mapTypeToSemanticType((NameManager.ObjectName)referencedByEntry.getKey());
            Object referencedByString = referencedBy.getSchemaQualifiedStatementNameNoSys();
            for (int i = ((List)referencedByEntry.getValue()).size() - 1; i >= 0; --i) {
                NameManager.ObjectName n = SemanticTypeAndPrototypeSchemaObjectsCache.mapTypeToSemanticType((NameManager.ObjectName)((List)referencedByEntry.getValue()).get(i));
                referencedByString = (String)referencedByString + "->" + n.getSchemaQualifiedStatementNameNoSys();
            }
            navigator.add(new Object[]{from.getStatementName(), SqlUtils.getSchemaObjectTypeName(from, session), referencedByString, SqlUtils.getSchemaObjectTypeName(referencedBy, session), false});
        }
    }

    private static /* synthetic */ void lambda$getResult$22(boolean all, RowSetNavigatorClient navigator, Session session, NameManager.ObjectName from, Map map) {
        for (Map.Entry entry : map.entrySet()) {
            NameManager.ObjectName referenceTo = SemanticTypeAndPrototypeSchemaObjectsCache.mapTypeToSemanticType((NameManager.ObjectName)entry.getKey());
            Object referenceToString = referenceTo.getSchemaQualifiedStatementNameNoSys();
            boolean system = SemanticTypeAndPrototypeSchemaObjectsCache.isSystem(referenceTo);
            if (system && !all) continue;
            if (((List)entry.getValue()).size() > 0) {
                for (int i = ((List)entry.getValue()).size() - 1; i >= 0; --i) {
                    referenceToString = (String)referenceToString + "<-" + SemanticTypeAndPrototypeSchemaObjectsCache.mapTypeToSemanticType((NameManager.ObjectName)((List)entry.getValue()).get(i)).getSchemaQualifiedStatementNameNoSys();
                }
            }
            if (((String)referenceToString).toLowerCase().startsWith("module") && !((String)(referenceToString = ((String)referenceToString).substring("module".length()).trim())).contains("<-")) continue;
            navigator.add(new Object[]{from.getStatementName(), SqlUtils.getSchemaObjectTypeName(from, session), referenceToString, SqlUtils.getSchemaObjectTypeName(referenceTo, session), system});
        }
    }

    private static /* synthetic */ void lambda$getResult$21(Consumer fillMetric, Object[] params) {
        String prefix = (String)params[0];
        ReplicationDeliveryMetrics.ReplicaMetricsReportFacet facet = (ReplicationDeliveryMetrics.ReplicaMetricsReportFacet)params[1];
        if (facet == null) {
            return;
        }
        fillMetric.accept(new Object[]{prefix + "_TOTAL", facet, facet.getTotal()});
        fillMetric.accept(new Object[]{prefix + "_AVERAGE", facet, facet.getAverageInBatches()});
        for (Map.Entry<String, Pair<ReplicationDeliveryMetrics.ReplicationDeliveryMetric, ReplicationDeliveryMetrics.ReplicationDeliveryMetric>> entry : facet.getMinMax().entrySet()) {
            fillMetric.accept(new Object[]{prefix + "_" + entry.getKey() + "_MIN", facet, entry.getValue().first});
            fillMetric.accept(new Object[]{prefix + "_" + entry.getKey() + "_MAX", facet, entry.getValue().second});
        }
    }

    private /* synthetic */ void lambda$getResult$20(String metricName, Result[] result, Function formatDate, Object[] params) {
        ReplicationDeliveryMetrics.ReplicationDeliveryMetricAverage metric;
        String prefix = (String)params[0];
        ReplicationDeliveryMetrics.ReplicaMetricsReportFacet face = (ReplicationDeliveryMetrics.ReplicaMetricsReportFacet)params[1];
        ReplicationDeliveryMetrics.ReplicationDeliveryMetricAverage replicationDeliveryMetricAverage = metric = params[2] == null || params[2] instanceof ReplicationDeliveryMetrics.ReplicationDeliveryMetricAverage ? (ReplicationDeliveryMetrics.ReplicationDeliveryMetricAverage)params[2] : new ReplicationDeliveryMetrics.ReplicationDeliveryMetricAverage((ReplicationDeliveryMetrics.ReplicationDeliveryMetric)params[2]);
        if (metricName == null) {
            if (result[0] == null) {
                ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING, Type.STRING, Type.STRING, Type.STRING, Type.STRING, Type.STRING, Type.STRING}, new String[]{"Metric Name", "First Batch Time", "Last Batch Time", "Total Batches Count", "Batch Size(in units)", "Statements Count", "Batch Size(bytes)", "Target Processing Time(ms)"});
                RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                result[0] = Result.newDataResult(metaData);
                result[0].setNavigator(navigator);
            }
            if (face == null || metric == null) {
                result[0].navigator.add(new Object[]{prefix, "n/a", "n/a", 0, 0, 0, 0, "n/a"});
                return;
            }
            result[0].navigator.add(new Object[]{prefix, formatDate.apply(face.getMinTimestamp()), formatDate.apply(face.getMaxTimestamp()), this.formatMetric(face.getCount()), this.formatMetric(metric.getUnitsCount()), this.formatMetric(metric.getStatementsCount()), this.formatMetric(metric.getBatchSizeInBytes()), this.formatMetric(metric.getTargetProcessingTime())});
        } else {
            int i;
            if (!prefix.equals(metricName)) {
                return;
            }
            ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING}, new String[]{"Name", "Value"});
            RowSetNavigatorClient navigator = new RowSetNavigatorClient();
            result[0] = Result.newDataResult(metaData);
            result[0].setNavigator(navigator);
            result[0].navigator.add(new Object[]{"Metric Name", prefix});
            result[0].navigator.add(new Object[]{"First Batch Time", face != null ? formatDate.apply(face.getMinTimestamp()) : "n/a"});
            result[0].navigator.add(new Object[]{"Last Batch Time", face != null ? formatDate.apply(face.getMaxTimestamp()) : "n/a"});
            result[0].navigator.add(new Object[]{"Total Batches Count", face != null ? this.formatMetric(face.getCount()) : "0"});
            result[0].navigator.add(new Object[]{"Batch Size(in units)", metric != null ? this.formatMetric(metric.getUnitsCount()) : "0"});
            result[0].navigator.add(new Object[]{"Statements Count", metric != null ? this.formatMetric(metric.getStatementsCount()) : "0"});
            for (i = 0; i < ReplicationOperationType.values().length; ++i) {
                result[0].navigator.add(new Object[]{"  " + ReplicationOperationType.values()[i].toString(), metric != null ? this.formatMetric(metric.getStatementsMap()[i]) : "0"});
            }
            result[0].navigator.add(new Object[]{"Not Processed Units Count", metric != null ? this.formatMetric(metric.getUnprocessedUnitsCount()) : "0"});
            result[0].navigator.add(new Object[]{"Not Processed Statements Count", metric != null ? this.formatMetric(metric.getUnprocessedStatementsCount()) : "0"});
            if (metric != null && metric.getUnprocessedStatementsCount() > 0.0) {
                for (i = 0; i < ReplicationOperationType.values().length; ++i) {
                    result[0].navigator.add(new Object[]{"  Not Processed " + ReplicationOperationType.values()[i].toString(), metric != null ? this.formatMetric(metric.getUnprocessedStatementsMap()[i]) : "0"});
                }
            }
            result[0].navigator.add(new Object[]{"Failed Units", metric != null ? this.formatMetric(metric.getFailedUnitsCount()) : "0"});
            result[0].navigator.add(new Object[]{"Batch Size(bytes)", metric == null ? "0" : this.formatMetric(metric.getBatchSizeInBytes())});
            result[0].navigator.add(new Object[]{"Target Processing Time(ms)", metric != null ? this.formatMetric(metric.getTargetProcessingTime()) : "n/a"});
        }
    }

    private static /* synthetic */ String lambda$getResult$19(Session session, Long time) {
        return time == 0L ? "n/a" : DataspaceDateTime.getSqlTimestampString((long)time, session.getTimeZone());
    }

    private /* synthetic */ String lambda$getResult$18(ReplicationTarget replica, Session session, ReplicationEntityName replicaEntityName) {
        String replicationQueueBacklog;
        block4: {
            replicationQueueBacklog = "n/a";
            if (replica.getState() == ReplicaState.ACTIVE || replica.getState() == ReplicaState.OUTSYNC || replica.getState() == ReplicaState.SYNCING) {
                try {
                    long sourceReplicationId;
                    ReplicationResponse sourceReplicationIdResponse = ReplicationUtil.getSourceReplicationId(session, replica.getSourceEntityName(), replicaEntityName);
                    if (sourceReplicationIdResponse != null && sourceReplicationIdResponse.isOk() && (sourceReplicationId = sourceReplicationIdResponse.getReplicationId()) >= 0L && replica.getReplicationId() >= 0L) {
                        replicationQueueBacklog = String.valueOf(sourceReplicationId - replica.getReplicationId());
                    }
                }
                catch (Exception exception) {
                    if (!Trace.isDebugEnabled(this.getClass())) break block4;
                    Trace.logException(this, exception, true);
                }
            }
        }
        return replicationQueueBacklog;
    }

    private static /* synthetic */ void lambda$getResult$17(Session session, ReplicationFlow flow, ReplicaInfo replicaInfo) {
        ReplicationFlow.Replica replica = new ReplicationFlow.Replica();
        replica.setNodeName(replicaInfo.getReplicaEntityName().getNodeName());
        replica.setDataspaceType(replicaInfo.getReplicaEntityName().getDataspaceType());
        replica.setDataspaceName(replicaInfo.getReplicaEntityName().getDataspaceName());
        replica.setReplicaName(replicaInfo.getReplicaEntityName().getSourceOrReplicaName());
        replica.setReplicaCollectionName(replicaInfo.getReplicaEntityName().getCollectionName());
        replica.setReplicaReplicationId(replicaInfo.getReplicationId());
        replica.setReplicaState(replicaInfo.getState());
        replica.setAttached(replicaInfo.getState() != null);
        replica.setSuspended(replicaInfo.isSuspended());
        replica.setNotExists(replicaInfo.isNotExists());
        replica.setMetaSchema(ReplicationMetaSchema.NONE);
        if (!replica.isNotExists()) {
            try {
                ReplicationResponse replicaResponse = ReplicationUtil.getReplicaInfo(session, replicaInfo.getReplicaEntityName(), false);
                if (replicaResponse.isOk() && replicaResponse.getReplicaInfo() != null) {
                    replicaInfo = replicaResponse.getReplicaInfo();
                    if (replica.getReplicaState() == null) {
                        replica.setReplicaState(replicaInfo.getState());
                    }
                    replica.setReplicaCollectionName(replicaInfo.getReplicaEntityName().getCollectionName());
                    replica.setTargetCollectionType(replicaInfo.getTargetCollectionType());
                    replica.setTargetVirtualServerName(replicaInfo.getTargetVirtualServerName());
                    replica.setTargetVirtualServerType(replicaInfo.getTargetVirtualServerType());
                    replica.setWithMaterialization(replicaInfo.isWithMaterialization());
                    replica.setRenew(replicaInfo.isRenew());
                    replica.setSuccessTriggers(replicaInfo.getSuccessTriggers());
                    replica.setFailTriggers(replicaInfo.getFailTriggers());
                    replica.setValidationTriggers(replicaInfo.getValidationTriggers());
                    replica.setTransformTrigger(replicaInfo.getTransformTrigger());
                    replica.setTransformTriggerUsingMapper(replicaInfo.isTransformTriggerUsingMapper());
                    replica.setTransformTriggerMappers(replicaInfo.getTransformTriggerMappers());
                    replica.setMetaSchema(replicaInfo.getMetaSchema());
                    replica.setRetryCount(replicaInfo.getRetryCount());
                    replica.setLastTimeResumedSuspended(replicaInfo.getLastTimeResumedSuspended());
                    replica.setLastTimeStateChanged(replicaInfo.getLastTimeStateChanged());
                    replica.setLastTimeStartedStopped(replicaInfo.getLastTimeStartedStopped());
                    replica.setLastError(replicaInfo.getLastError());
                    replica.setUpsert(replicaInfo.isUpsert());
                    replica.setIgnoreOnFailDelete(replicaInfo.isIgnoreOnFailDelete());
                    replica.setIgnoreOnFailUpdate(replicaInfo.isIgnoreOnFailUpdate());
                    replica.setIgnoreOnFailInsert(replicaInfo.isIgnoreOnFailInsert());
                    replica.setPrimaryReplicationKey(replicaInfo.getPrimaryReplicationKey());
                }
            }
            catch (Exception exception) {
                replica.setUnreachable(true);
            }
        }
        flow.addReplica(replica);
    }

    private static /* synthetic */ void lambda$getResult$16(BiConsumer fillMetric, String replicaName, Object[] params) {
        String prefix = (String)params[0];
        ReplicationDeliveryMetrics.ReplicaMetricsReportFacet facet = (ReplicationDeliveryMetrics.ReplicaMetricsReportFacet)params[1];
        if (facet == null) {
            return;
        }
        fillMetric.accept(replicaName, new Object[]{prefix + "_TOTAL", facet, facet.getTotal()});
        fillMetric.accept(replicaName, new Object[]{prefix + "_AVERAGE", facet, facet.getAverageInBatches()});
        for (Map.Entry<String, Pair<ReplicationDeliveryMetrics.ReplicationDeliveryMetric, ReplicationDeliveryMetrics.ReplicationDeliveryMetric>> entry : facet.getMinMax().entrySet()) {
            fillMetric.accept(replicaName, new Object[]{prefix + "_" + entry.getKey() + "_MIN", facet, entry.getValue().first});
            fillMetric.accept(replicaName, new Object[]{prefix + "_" + entry.getKey() + "_MAX", facet, entry.getValue().second});
        }
    }

    private /* synthetic */ void lambda$getResult$15(String metricName, Map finalMap, Result[] result, Function formatDate, String replicaName, Object[] params) {
        ReplicationDeliveryMetrics.ReplicationDeliveryMetricAverage metric;
        String prefix = (String)params[0];
        ReplicationDeliveryMetrics.ReplicaMetricsReportFacet face = (ReplicationDeliveryMetrics.ReplicaMetricsReportFacet)params[1];
        ReplicationDeliveryMetrics.ReplicationDeliveryMetricAverage replicationDeliveryMetricAverage = metric = params[2] == null || params[2] instanceof ReplicationDeliveryMetrics.ReplicationDeliveryMetricAverage ? (ReplicationDeliveryMetrics.ReplicationDeliveryMetricAverage)params[2] : new ReplicationDeliveryMetrics.ReplicationDeliveryMetricAverage((ReplicationDeliveryMetrics.ReplicationDeliveryMetric)params[2]);
        if (metricName == null || metricName != null && finalMap.size() > 1) {
            if (metricName != null && !prefix.equals(metricName)) {
                return;
            }
            if (result[0] == null) {
                ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING, Type.STRING, Type.STRING, Type.STRING, Type.STRING, Type.STRING, Type.STRING, Type.STRING, Type.STRING, Type.STRING, Type.STRING}, new String[]{"Replica Name", "Metric Name", "First Batch Time", "Last Batch Time", "Total Batches Count", "Batch Size(in units)", "Statements Count", "Batch Size(bytes)", "Batch Read Start Time", "Batch Read Time(ms)", "Delivery Time(ms)", "Target Processing Time(ms)"});
                RowSetNavigatorClient navigator = new RowSetNavigatorClient();
                result[0] = Result.newDataResult(metaData);
                result[0].setNavigator(navigator);
            }
            if (face == null || metric == null) {
                result[0].navigator.add(new Object[]{replicaName, prefix, "n/a", "n/a", 0, 0, 0, 0, "n/a", "n/a", "n/a", "n/a", "n/a", "n/a"});
                return;
            }
            result[0].navigator.add(new Object[]{replicaName, prefix, formatDate.apply(face.getMinTimestamp()), formatDate.apply(face.getMaxTimestamp()), this.formatMetric(face.getCount()), this.formatMetric(metric.getUnitsCount()), this.formatMetric(metric.getStatementsCount()), this.formatMetric(metric.getBatchSizeInBytes()), formatDate.apply((long)metric.getBatchReadStartTime()), this.formatMetric(metric.getBatchReadTime()), this.formatMetric(metric.getDeliveryTime()), this.formatMetric(metric.getTargetProcessingTime())});
        } else {
            int i;
            if (!prefix.equals(metricName)) {
                return;
            }
            ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.STRING, Type.STRING}, new String[]{"Name", "Value"});
            RowSetNavigatorClient navigator = new RowSetNavigatorClient();
            result[0] = Result.newDataResult(metaData);
            result[0].setNavigator(navigator);
            result[0].navigator.add(new Object[]{"Replica Name", replicaName});
            result[0].navigator.add(new Object[]{"Metric Name", prefix});
            result[0].navigator.add(new Object[]{"First Batch Time", face != null ? formatDate.apply(face.getMinTimestamp()) : "n/a"});
            result[0].navigator.add(new Object[]{"Last Batch Time", face != null ? formatDate.apply(face.getMaxTimestamp()) : "n/a"});
            result[0].navigator.add(new Object[]{"Total Batches Count", face != null ? this.formatMetric(face.getCount()) : "0"});
            result[0].navigator.add(new Object[]{"Batch Size(in units)", metric != null ? this.formatMetric(metric.getUnitsCount()) : "0"});
            result[0].navigator.add(new Object[]{"Statements Count", metric != null ? this.formatMetric(metric.getStatementsCount()) : "0"});
            for (i = 0; i < ReplicationOperationType.values().length; ++i) {
                result[0].navigator.add(new Object[]{"  " + ReplicationOperationType.values()[i].toString(), metric != null ? this.formatMetric(metric.getStatementsMap()[i]) : "0"});
            }
            result[0].navigator.add(new Object[]{"Not Processed Units Count", metric != null ? this.formatMetric(metric.getUnprocessedUnitsCount()) : "0"});
            result[0].navigator.add(new Object[]{"Not Processed Statements Count", metric != null ? this.formatMetric(metric.getUnprocessedStatementsCount()) : "0"});
            if (metric != null && metric.getUnprocessedStatementsCount() > 0.0) {
                for (i = 0; i < ReplicationOperationType.values().length; ++i) {
                    result[0].navigator.add(new Object[]{"  Not Processed " + ReplicationOperationType.values()[i].toString(), metric != null ? this.formatMetric(metric.getUnprocessedStatementsMap()[i]) : "0"});
                }
            }
            result[0].navigator.add(new Object[]{"Failed Units Count", metric != null ? this.formatMetric(metric.getFailedUnitsCount()) : "0"});
            result[0].navigator.add(new Object[]{"Batch Size(bytes)", metric == null ? "0" : this.formatMetric(metric.getBatchSizeInBytes())});
            result[0].navigator.add(new Object[]{"Batch Read Start Time", metric != null ? formatDate.apply((long)metric.getBatchReadStartTime()) : "n/a"});
            result[0].navigator.add(new Object[]{"Batch Read Time(ms)", metric != null ? this.formatMetric(metric.getBatchReadTime()) : "n/a"});
            result[0].navigator.add(new Object[]{"Delivery Time(ms)", metric != null ? this.formatMetric(metric.getDeliveryTime()) : "n/a"});
            result[0].navigator.add(new Object[]{"Target Processing Time(ms)", metric != null ? this.formatMetric(metric.getTargetProcessingTime()) : "n/a"});
        }
    }

    private static /* synthetic */ String lambda$getResult$14(Session session, Long time) {
        return time == 0L ? "n/a" : DataspaceDateTime.getSqlTimestampString((long)time, session.getTimeZone());
    }

    private static /* synthetic */ LobData lambda$getResult$13(Session session, LobData lobData) {
        session.dataspaceStore.flobManager.invalidateFlob(lobData.getId());
        throw new RuntimeException("Flob is invalidated");
    }

    private static /* synthetic */ LobData lambda$getResult$12(Session session, boolean notEmpty, LobData lobData) {
        if (!session.dataspaceStore.flobManager.validateFlob(lobData.getId(), notEmpty).isValid()) {
            throw new RuntimeException("Flob is not valid");
        }
        return lobData;
    }

    private static /* synthetic */ LobData lambda$getResult$11(Session session, LobData lobData) {
        if (!session.dataspaceStore.flobManager.getFlobData(lobData.getId()).isValid()) {
            throw new RuntimeException("Flob is not valid");
        }
        return lobData;
    }

    private static /* synthetic */ Integer lambda$getResult$10(Integer a, Integer b) {
        return a + b;
    }

    private static /* synthetic */ Integer lambda$getResult$9(Object[] v) {
        return v.length;
    }

    private static /* synthetic */ void lambda$getResult$8(RowSetNavigatorClient navigator, Map.Entry e) {
        ((TableTypesValidator.InvalidTable)((List)e.getValue()).get(0)).getInvalidColumns().stream().forEach(c -> c.getInvalidRows().stream().forEach(r -> navigator.add(new Object[]{c.getColumnName(), ((OtherType)e.getKey()).getNameString(), r.getIdentity(), c.getError()})));
    }

    private static /* synthetic */ long lambda$getResult$5(Path p) {
        return p.toFile().length();
    }

    private static /* synthetic */ Result lambda$getResult$4(String[] columns) {
        Object[] types = new Type[columns.length];
        Arrays.fill(types, Type.STRING);
        ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData((Type[])types, columns);
        Result result = Result.newDataResult(metaData);
        RowSetNavigatorClient navigator = new RowSetNavigatorClient();
        result.setNavigator(navigator);
        return result;
    }

    private static /* synthetic */ boolean lambda$getResult$3(List tupleNames, Tuple t) {
        return t.getName().equals(tupleNames.get(0));
    }

    private static /* synthetic */ String lambda$getResult$2(Column c) {
        return c.name();
    }

    private static /* synthetic */ void lambda$getResult$1(RowSetNavigatorClient navigator, Object[] values) {
        String name = (String)values[0];
        String type = (String)values[1];
        long sizeInMemoryData = (Long)values[2];
        long sizeInMemoryRemoved = (Long)values[3];
        long sizeInMemoryFull = (Long)values[4];
        long sizeOnDisk = (Long)values[5];
        double deletedPercentage = (Double)values[6];
        double nullsPercentage = (Double)values[7];
        navigator.add(new Object[]{name, type, SizeUnit.convertToBestFractional(sizeInMemoryData, SizeUnit.BYTES).toStringWithPrecision(2), SizeUnit.convertToBestFractional(sizeInMemoryRemoved, SizeUnit.BYTES).toStringWithPrecision(2), SizeUnit.convertToBestFractional(sizeInMemoryFull, SizeUnit.BYTES).toStringWithPrecision(2), sizeOnDisk >= 0L ? SizeUnit.convertToBestFractional(sizeOnDisk, SizeUnit.BYTES).toStringWithPrecision(2) : "n/a", deletedPercentage >= 0.0 ? String.format("%.2f ", deletedPercentage) + "%" : "n/a", nullsPercentage >= 0.0 ? String.format("%.2f ", nullsPercentage) + "%" : "n/a"});
    }

    private static /* synthetic */ int lambda$getResult$0(TriggerDef o) {
        return o.triggerOrder;
    }
}

