/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.statement;

import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.collection.tspace.map.MapCollection;
import com.streamscape.ds.session.Session;
import java.util.LinkedHashMap;
import java.util.Map;

public class StatementCollectionInvoke
extends Statement {
    Object[] parameters;

    public StatementCollectionInvoke(int type, Object[] args) {
        this(type, args, null, null);
    }

    StatementCollectionInvoke(int type, Object[] args, NameManager.ObjectName readName, NameManager.ObjectName writeName) {
        super(type);
        this.isTransactionStatement = true;
        this.parameters = args;
        if (readName != null && readName != writeName) {
            this.readTableNames = new NameManager.ObjectName[]{readName};
        }
        if (writeName != null) {
            this.writeTableNames = new NameManager.ObjectName[]{writeName};
        }
        switch (type) {
            case 3003: {
                this.group = 2017;
                this.isLogged = false;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementCollectionInvoke");
            }
        }
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
        }
        catch (Throwable t) {
            result = Result.newErrorResult(t, null);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
            return result;
        }
        return result;
    }

    Result getResult(Session session) {
        if (this.isExplain) {
            return Result.newSingleColumnStringResult("OPERATION", this.describe(session));
        }
        switch (this.type) {
            case 3003: {
                Collection collection = (Collection)this.parameters[0];
                String invokeOperation = (String)this.parameters[1];
                switch (collection.getCollectionType()) {
                    case MAP: {
                        MapCollection map = (MapCollection)collection;
                        if (!invokeOperation.equalsIgnoreCase("CLEAR")) break;
                        return map.clearWithResult(session);
                    }
                }
                return Result.updateNoResult;
            }
        }
        throw Error.runtimeError(201, "StatementCollectionQuery");
    }

    @Override
    public boolean isAutoCommitStatement() {
        return this.isTransactionStatement;
    }

    @Override
    public String describe(Session session) {
        return this.sql;
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("sql", this.sql);
        return result;
    }
}

