/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.statement;

import com.streamscape.ds.NameManager;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.parser.expression.ExpressionColumn;
import com.streamscape.ds.parser.statement.StatementCompound;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultMetaData;
import com.streamscape.ds.schema.column.ColumnBase;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.Type;
import com.streamscape.lib.utils.Pair;
import java.util.Map;

public abstract class Statement {
    static final int META_RESET_VIEWS = 1;
    static final int META_RESET_STATEMENTS = 2;
    static final Statement[] emptyArray = new Statement[0];
    public final int type;
    int group;
    boolean isLogged = true;
    boolean isValid = true;
    int statementReturnType = 1;
    NameManager.ObjectName schemaName;
    RplScript root;
    StatementCompound parent;
    boolean isError;
    public boolean isTransactionStatement;
    public boolean isExplain;
    public String sql;
    long id;
    public long compileTimestamp;
    public NameManager.ObjectName[] readTableNames = NameManager.ObjectName.emptyArray;
    public NameManager.ObjectName[] writeTableNames = NameManager.ObjectName.emptyArray;
    OrderedHashSet references;
    int cursorPropertiesRequest;

    public abstract Result execute(Session var1);

    public void setParameters(ExpressionColumn[] params) {
    }

    Statement(int type) {
        this.type = type;
    }

    Statement(int type, int group) {
        this.type = type;
        this.group = group;
    }

    public final boolean isError() {
        return this.isError;
    }

    public boolean isTransactionStatement() {
        return this.isTransactionStatement;
    }

    public boolean isAutoCommitStatement() {
        return false;
    }

    public void setCompileTimestamp(long ts) {
        this.compileTimestamp = ts;
    }

    public long getCompileTimestamp() {
        return this.compileTimestamp;
    }

    public final void setSQL(String sql) {
        this.sql = sql;
    }

    public String getSQL() {
        return this.sql;
    }

    public OrderedHashSet getReferences() {
        return this.references;
    }

    public final void setDescribe() {
        this.isExplain = true;
    }

    public abstract String describe(Session var1);

    public abstract Map<String, Object> describeJson(Session var1);

    public NameManager.ObjectName getSchemaName() {
        return this.schemaName;
    }

    public final void setSchemaHsqlName(NameManager.ObjectName name) {
        this.schemaName = name;
    }

    public final void setID(long csid) {
        this.id = csid;
    }

    public final long getID() {
        return this.id;
    }

    public final int getType() {
        return this.type;
    }

    public final int getGroup() {
        return this.group;
    }

    public final boolean isValid() {
        return this.isValid;
    }

    public final boolean isLogged() {
        return this.isLogged;
    }

    public void clearVariables() {
    }

    public void resolve(Session session) {
    }

    public RangeVariable[] getRangeVariables() {
        return RangeVariable.emptyArray;
    }

    public final NameManager.ObjectName[] getTableNamesForRead() {
        return this.readTableNames;
    }

    public final NameManager.ObjectName[] getTableNamesForWrite() {
        return this.writeTableNames;
    }

    public boolean isCatalogLock() {
        switch (this.group) {
            case 2002: {
                if (this.type == 134) {
                    return false;
                }
            }
            case 2001: 
            case 2012: {
                return true;
            }
            case 2014: {
                return true;
            }
        }
        return false;
    }

    public boolean isCatalogChange() {
        switch (this.group) {
            case 2001: 
            case 2002: 
            case 2012: {
                return true;
            }
        }
        return false;
    }

    public void setParent(StatementCompound statement) {
        this.parent = statement;
    }

    public void setRoot(RplScript root) {
        this.root = root;
    }

    public boolean hasGeneratedColumns() {
        return false;
    }

    public ResultMetaData generatedResultMetaData() {
        return null;
    }

    public void setGeneratedColumnInfo(int mode, ResultMetaData meta) {
    }

    public ResultMetaData getResultMetaData() {
        return ResultMetaData.emptyResultMetaData;
    }

    public ResultMetaData getParametersMetaData() {
        return ResultMetaData.emptyParamMetaData;
    }

    public int getResultProperties() {
        return 0;
    }

    public int getStatementReturnType() {
        return this.statementReturnType;
    }

    public int getCursorPropertiesRequest() {
        return this.cursorPropertiesRequest;
    }

    public void setCursorPropertiesRequest(int props) {
        this.cursorPropertiesRequest = props;
    }

    public void clearStructures(Session session) {
    }

    protected ResultMetaData createMetaData(Pair<String, Type> ... tuples) {
        Type[] types = new Type[tuples.length];
        String[] tupleLables = new String[tuples.length];
        ColumnBase[] columns = new ColumnBase[tuples.length];
        for (int i = 0; i < tuples.length; ++i) {
            tupleLables[i] = (String)tuples[i].first;
            types[i] = (Type)tuples[i].second;
            ColumnBase column = new ColumnBase("", "", "", "");
            column.setType((Type)tuples[i].second);
            columns[i] = column;
        }
        ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(types);
        metaData.columns = columns;
        metaData.columnLabels = tupleLables;
        return metaData;
    }

    public boolean containsTransactionalStatement() {
        return this.isTransactionStatement;
    }
}

