/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.expression;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.lib.HsqlList;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.NumberType;

public class UpdateDeleteStatementExpression
extends Expression {
    private Statement statement;

    public UpdateDeleteStatementExpression(Statement statement) {
        super(1);
        this.statement = statement;
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        return unresolvedSet;
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        this.statement.resolve(session);
        this.dataType = NumberType.SQL_INTEGER;
    }

    @Override
    public Object getValue(Session session) {
        Result result = this.getResult(session);
        if (result.isError()) {
            if (result.getException() != null) {
                throw result.getException();
            }
            throw new DataspaceException("Deletion error: " + result.getMainString());
        }
        return result.getUpdateCount();
    }

    @Override
    public Result getResult(Session session) {
        Result result = this.statement.execute(session);
        return result;
    }

    @Override
    public String getSQL() {
        return this.statement.getSQL();
    }
}

